/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import nxm.sys.libg.DPix;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.MPoint;
import nxm.sys.libg.Pix;
import nxm.sys.libg.View;

public class ViewMercader
extends View {
    private double[] tl2m;
    private double[] dtl2m;
    private static final int ndeg = 400;

    public ViewMercader(MPlot MP) {
        super(MP);
        this.prepTables();
        this.setup();
    }

    public static double lat2mer(double lat) {
        if (lat >= 85.0) {
            return lat + 94.0;
        }
        if (lat <= -85.0) {
            return lat - 94.0;
        }
        return 57.29577951308232 * Math.log(Math.tan(0.7853981633974483 + lat * (Math.PI / 180) / 2.0));
    }

    public static double mer2lat(double mer) {
        if (mer >= 179.0) {
            return mer - 94.0;
        }
        if (mer <= -179.0) {
            return mer + 94.0;
        }
        return (Math.atan(Math.exp(Math.PI / 180 * mer)) - 0.7853981633974483) * 57.29577951308232 * 2.0;
    }

    private void prepTables() {
        int i;
        this.tl2m = new double[402];
        this.dtl2m = new double[401];
        for (i = 0; i < 201; ++i) {
            double z;
            this.tl2m[i + 200] = z = ViewMercader.lat2mer(i);
            this.tl2m[200 - i] = -z;
        }
        for (i = 0; i <= 400; ++i) {
            this.dtl2m[i] = this.tl2m[i + 1] - this.tl2m[i];
        }
    }

    @Override
    public int rwc2pix(double[] rwc, MPoint pix) {
        while (rwc[1] > 180.0) {
            rwc[1] = rwc[1] - 360.0;
        }
        while (rwc[1] < -180.0) {
            rwc[1] = rwc[1] + 360.0;
        }
        int vis = this.rwc2pix(rwc, 0, 3, 1, this.MP.tpix);
        pix.x = this.MP.tpix.x[0];
        pix.y = this.MP.tpix.y[0];
        return vis;
    }

    @Override
    public int pix2rwc(MPoint pix, double[] rwc) {
        double mxx = this.MP.mxx;
        double mxb = this.MP.mxb;
        double myy = (double)(this.MP.iy1 - this.MP.iy2) / (this.t_lat2mer(this.MP.ry2) - this.t_lat2mer(this.MP.ry1));
        double myb = (double)this.MP.iy2 - this.t_lat2mer(this.MP.ry1) * myy;
        double retx = ((double)pix.x - mxb) / mxx;
        double rety = ((double)pix.y - myb) / myy;
        rwc[0] = retx;
        rwc[1] = ViewMercader.mer2lat(rety);
        rwc[2] = 0.0;
        return 1;
    }

    public double iy2ry(int iy) {
        double myy = (double)(this.MP.iy1 - this.MP.iy2) / (ViewMercader.lat2mer(this.MP.ry2) - ViewMercader.lat2mer(this.MP.ry1));
        double myb = (double)this.MP.iy2 - ViewMercader.lat2mer(this.MP.ry1) * myy;
        return ViewMercader.mer2lat(((double)iy - myb) / myy);
    }

    public int ry2iy(double ry) {
        double myy = (double)(this.MP.iy1 - this.MP.iy2) / (ViewMercader.lat2mer(this.MP.ry2) - ViewMercader.lat2mer(this.MP.ry1));
        double myb = (double)this.MP.iy2 - ViewMercader.lat2mer(this.MP.ry1) * myy;
        return (int)(ViewMercader.lat2mer(ry) * myy + myb);
    }

    private double t_lat2mer(double lat) {
        if (lat >= 85.0) {
            return lat + 95.0;
        }
        if (lat <= -85.0) {
            return lat - 95.0;
        }
        double alat = lat + 200.0;
        int ilat = (int)alat;
        double plat = alat - (double)ilat;
        return this.tl2m[ilat] + plat * this.dtl2m[ilat];
    }

    @Override
    public int rwc2pix(float[] buf, int off, int dim, int npts, Pix pix, double xstart, double xdelta) {
        int j = off;
        int n = pix.setSize(npts);
        int xoff = off / dim;
        float[] buf2 = new float[n * 2];
        int bufOffset = 0;
        for (int i = 0; i < n; ++i) {
            double x = xstart + (double)(xoff + i) * xdelta;
            buf2[bufOffset++] = (float)Math.IEEEremainder(x, 360.0);
            buf2[bufOffset++] = (float)Math.IEEEremainder(buf[j], 360.0);
            j += dim;
        }
        return this.rwc2pix(buf2, 0, 2, n, pix);
    }

    @Override
    public int rwc2pix(double[] buf, int off, int dim, int npts, Pix pix, double xstart, double xdelta) {
        int j = off;
        int n = pix.setSize(npts);
        int xoff = off / dim;
        double[] buf2 = new double[n * 2];
        int bufOffset = 0;
        for (int i = 0; i < n; ++i) {
            double x = xstart + (double)(xoff + i) * xdelta;
            buf2[bufOffset++] = Math.IEEEremainder(x, 360.0);
            buf2[bufOffset++] = Math.IEEEremainder(buf[j], 360.0);
            j += dim;
        }
        return this.rwc2pix(buf2, 0, 2, n, pix);
    }

    @Override
    public int rwc2pix(float[] buf, int off, int dim, int npts, Pix pix) {
        if ((pix.flags & 2) != 0) {
            return this.rwc2pixClip(buf, off, dim, npts, pix, true);
        }
        int j = off;
        int n = pix.setSize(npts);
        int[] pax = pix.x;
        int[] pay = pix.y;
        double mxx = this.MP.mxx;
        double mxb = this.MP.mxb;
        double myy = (double)(this.MP.iy1 - this.MP.iy2) / (ViewMercader.lat2mer(this.MP.ry2) - ViewMercader.lat2mer(this.MP.ry1));
        double myb = (double)this.MP.iy2 - ViewMercader.lat2mer(this.MP.ry1) * myy;
        if (dim == 2) {
            for (int i = 0; i < n; ++i) {
                pax[i] = (int)((double)buf[j++] * mxx + mxb);
                pay[i] = (int)(ViewMercader.lat2mer(buf[j++]) * myy + myb);
            }
        } else {
            int i = 0;
            while (i < n) {
                pax[i] = (int)((double)buf[j + 0] * mxx + mxb);
                pay[i] = (int)(ViewMercader.lat2mer(buf[j + 1]) * myy + myb);
                ++i;
                j += dim;
            }
        }
        return n;
    }

    @Override
    public int rwc2pix(double[] buf, int off, int dim, int npts, Pix pix) {
        if ((pix.flags & 2) != 0) {
            return this.rwc2pixClip(buf, off, dim, npts, pix, true);
        }
        int j = off;
        int n = pix.setSize(npts);
        int[] pax = pix.x;
        int[] pay = pix.y;
        double mxx = this.MP.mxx;
        double mxb = this.MP.mxb;
        double myy = (double)(this.MP.iy1 - this.MP.iy2) / (ViewMercader.lat2mer(this.MP.ry2) - ViewMercader.lat2mer(this.MP.ry1));
        double myb = (double)this.MP.iy2 - ViewMercader.lat2mer(this.MP.ry1) * myy;
        if (dim == 2) {
            for (int i = 0; i < n; ++i) {
                pax[i] = (int)(buf[j++] * mxx + mxb);
                pay[i] = (int)(ViewMercader.lat2mer(buf[j++]) * myy + myb);
            }
        } else {
            int i = 0;
            while (i < n) {
                pax[i] = (int)(buf[j + 0] * mxx + mxb);
                pay[i] = (int)(ViewMercader.lat2mer(buf[j + 1]) * myy + myb);
                ++i;
                j += dim;
            }
        }
        return n;
    }

    @Override
    int rwc2pix(double[] buf, int off, int dim, int npts, Pix pix, boolean isFill) {
        if (isFill && (pix.flags & 2) != 0) {
            return this.rwc2pixClipAdjustForFill(buf, off, dim, npts, pix, true);
        }
        return this.rwc2pix(buf, off, dim, npts, pix);
    }

    @Override
    public int rwc2dpix(double[] buf, int off, int dim, int npts, DPix pix) {
        if ((pix.flags & 2) != 0) {
            return this.rwc2dpixClip(buf, off, dim, npts, pix, true);
        }
        int j = off;
        int n = pix.setSize(npts);
        double[] pax = pix.x;
        double[] pay = pix.y;
        double mxx = this.MP.mxx;
        double mxb = this.MP.mxb;
        double myy = (double)(this.MP.iy1 - this.MP.iy2) / (ViewMercader.lat2mer(this.MP.ry2) - ViewMercader.lat2mer(this.MP.ry1));
        double myb = (double)this.MP.iy2 - ViewMercader.lat2mer(this.MP.ry1) * myy;
        if (dim == 2) {
            for (int i = 0; i < n; ++i) {
                pax[i] = buf[j++] * mxx + mxb;
                pay[i] = ViewMercader.lat2mer(buf[j++]) * myy + myb;
            }
        } else {
            int i = 0;
            while (i < n) {
                pax[i] = buf[j + 0] * mxx + mxb;
                pay[i] = ViewMercader.lat2mer(buf[j + 1]) * myy + myb;
                ++i;
                j += dim;
            }
        }
        return n;
    }
}

