/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import nxm.sys.lib.Midas;
import nxm.sys.libg.DPix;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.MPoint;
import nxm.sys.libg.Pix;
import nxm.sys.libg.View;

public class ViewGeo
extends View {
    private static final float PI = (float)Math.PI;
    private static final float PI_LO = 1.2246469E-16f;
    private static final float PI_OVER_4 = 0.7853982f;
    private static final float PI_OVER_2 = 1.5707964f;
    private static final float PI2 = (float)Math.PI * 2;
    private static final float PI3 = (float)Math.PI * 3;
    private static final float DEG2RADF = (float)Math.PI / 180;
    public double lat = 0.0;
    public double lon = 0.0;
    public double alt = 6.0;
    private double[] tsin;
    private double[] tcos;
    private double[] dtsin;
    private double[] dtcos;
    private double slat;
    private double clat;
    private double zvis;
    private double rvis;
    private double equatorialRadius;
    private double inverseEquatorialRad;
    private float rlatO;
    private float rlonO;
    private float raltO;
    private double drlon;
    private double draltO;
    private static final int ndeg = 725;

    public ViewGeo(MPlot MP) {
        super(MP);
        this.prepTables();
        this.setup();
    }

    private void prepTables() {
        int i;
        this.tsin = new double[725];
        this.tcos = new double[725];
        this.dtsin = new double[725];
        this.dtcos = new double[725];
        for (i = 0; i < 725; ++i) {
            this.tsin[i] = Math.sin(Math.PI / 180 * (double)i);
            this.tcos[i] = Math.cos(Math.PI / 180 * (double)i);
        }
        for (i = 0; i < 724; ++i) {
            this.dtsin[i] = this.tsin[i + 1] - this.tsin[i];
            this.dtcos[i] = this.tcos[i + 1] - this.tcos[i];
        }
    }

    @Override
    public boolean setObserver(double[] arg) {
        this.lon = arg[0];
        this.lat = arg[1];
        this.alt = arg[2];
        while (this.lat > 180.0) {
            this.lat -= 360.0;
        }
        while (this.lat < -180.0) {
            this.lat += 360.0;
        }
        while (this.lon > 180.0) {
            this.lon -= 360.0;
        }
        while (this.lon < -180.0) {
            this.lon += 360.0;
        }
        this.setup();
        return true;
    }

    @Override
    public boolean getObserver(double[] arg) {
        arg[0] = this.lon;
        arg[1] = this.lat;
        arg[2] = this.alt;
        return true;
    }

    @Override
    public void setup() {
        this.rlonO = (float)this.lon;
        this.rlatO = (float)this.lat;
        this.raltO = (float)this.alt;
        this.drlon = this.lon;
        this.draltO = this.alt;
        this.slat = Math.sin(-this.lat * (Math.PI / 180));
        this.clat = Math.cos(-this.lat * (Math.PI / 180));
        this.zvis = 1.0 / this.alt;
        double pang = Math.asin(this.zvis);
        this.rvis = 1.0 / (Math.cos(pang) * Math.cos(pang));
        this.equatorialRadius = 6378137.0;
        this.inverseEquatorialRad = 1.0 / this.equatorialRadius;
    }

    @Override
    public int rwc2pix(double[] rwc, MPoint pix) {
        while (rwc[0] > 180.0) {
            rwc[0] = rwc[0] - 360.0;
        }
        while (rwc[0] < -180.0) {
            rwc[0] = rwc[0] + 360.0;
        }
        while (rwc[1] > 180.0) {
            rwc[1] = rwc[1] - 360.0;
        }
        while (rwc[1] < -180.0) {
            rwc[1] = rwc[1] + 360.0;
        }
        int vis = this.rwc2pix(rwc, 0, 3, 1, this.MP.tpix);
        pix.x = this.MP.tpix.x[0];
        pix.y = this.MP.tpix.y[0];
        return vis;
    }

    @Override
    public int pix2rwc(MPoint pix, double[] rwc) {
        double retz;
        double p2 = this.draltO * this.draltO;
        double retx = ((double)pix.x - this.MP.mxb) / this.MP.mxx;
        double rety = ((double)pix.y - this.MP.myb) / this.MP.myy;
        double rad = retx * retx + rety * rety;
        double fact = this.quadsolve(p2 + rad, -2.0 * p2, p2 - 1.0);
        if (fact == 0.0) {
            rad = Math.atan2(rety, retx);
            retx = Math.cos(rad);
            double rrety = Math.sin(rad);
            rety = rrety * this.clat;
            retz = rrety * this.slat;
        } else {
            double rretx = retx * fact;
            double rrety = rety * fact;
            double rretz = Math.sqrt(1.0 - rad * fact * fact);
            retx = rretx;
            rety = rrety * this.clat - rretz * this.slat;
            retz = rrety * this.slat + rretz * this.clat;
        }
        retx = 57.29577951308232 * Math.atan2(retx, retz);
        rwc[0] = (this.drlon + retx + 540.0) % 360.0 - 180.0;
        rwc[1] = 57.29577951308232 * Math.asin(rety);
        rwc[2] = 0.0;
        return 1;
    }

    private double quadsolve(double a, double b, double c) {
        double d = b * b - 4.0 * a * c;
        if (d < 1.0E-20 || Math.abs(a) < 1.0E-20) {
            return 0.0;
        }
        return (-b - Math.sqrt(d)) / (2.0 * a);
    }

    @Override
    public int rwc2pix(float[] buf, int off, int dim, int npts, Pix pix, double xstart, double xdelta) {
        int j = off;
        int n = pix.setSize(npts);
        int xoff = off / dim;
        float[] buf2 = new float[n * 2];
        int bufOffset = 0;
        for (int i = 0; i < n; ++i) {
            double x = xstart + (double)(xoff + i) * xdelta;
            buf2[bufOffset++] = (float)Math.IEEEremainder(x, 360.0);
            buf2[bufOffset++] = (float)Math.IEEEremainder(buf[j], 360.0);
            j += dim;
        }
        return this.rwc2pix(buf2, 0, 2, n, pix);
    }

    @Override
    public int rwc2pix(double[] buf, int off, int dim, int npts, Pix pix, double xstart, double xdelta) {
        int j = off;
        int n = pix.setSize(npts);
        int xoff = off / dim;
        double[] buf2 = new double[n * 2];
        int bufOffset = 0;
        for (int i = 0; i < n; ++i) {
            double x = xstart + (double)(xoff + i) * xdelta;
            buf2[bufOffset++] = Math.IEEEremainder(x, 360.0);
            buf2[bufOffset++] = Math.IEEEremainder(buf[j], 360.0);
            j += dim;
        }
        return this.rwc2pix(buf2, 0, 2, n, pix);
    }

    @Override
    public int rwc2pix(float[] buf, int off, int dim, int npts, Pix pix) {
        int i;
        int j = off;
        int k = 0;
        int[] pax = pix.x;
        int[] pay = pix.y;
        float[] paz = pix.z;
        double mxx = this.MP.mxx;
        double myy = this.MP.myy;
        double mxb = this.MP.mxb;
        double myb = this.MP.myb;
        boolean viso = false;
        boolean chk = (pix.flags & 1) != 0;
        npts = Math.min(npts, pix.max);
        for (i = 0; i < npts; ++i) {
            double ff;
            boolean vis;
            double zz;
            double yy;
            double xx;
            double alon = buf[j++] - this.rlonO + 360.0f;
            double alat = buf[j++] + 360.0f;
            int ilon = (int)alon;
            int ilat = (int)alat;
            double plon = alon - (double)ilon;
            double plat = alat - (double)ilat;
            double cp = this.tcos[ilon] + plon * this.dtcos[ilon];
            double sp = this.tsin[ilon] + plon * this.dtsin[ilon];
            double ct = this.tcos[ilat] + plat * this.dtcos[ilat];
            double st = this.tsin[ilat] + plat * this.dtsin[ilat];
            double ctcp = ct * cp;
            if (dim == 2) {
                xx = ct * sp;
                yy = ctcp * this.slat + st * this.clat;
                zz = ctcp * this.clat - st * this.slat;
                vis = zz > this.zvis;
                ff = this.draltO / (this.draltO - zz);
                xx *= ff;
                yy *= ff;
            } else {
                double rr = ((double)buf[j++] + this.equatorialRadius) * this.inverseEquatorialRad;
                xx = rr * (ct * sp);
                yy = rr * (ctcp * this.slat + st * this.clat);
                zz = rr * (ctcp * this.clat - st * this.slat);
                ff = this.draltO / (this.draltO - zz);
                boolean bl = vis = zz < this.draltO && (zz > this.zvis || (xx *= ff) * xx + (yy *= ff) * yy >= this.rvis);
            }
            if (vis) {
                pax[k] = (int)(xx * mxx + mxb);
                pay[k] = (int)(yy * myy + myb);
                paz[k] = (float)zz;
                ++k;
            } else if (chk) {
                pax[k] = 0;
                pay[k] = 0;
                paz[k] = (float)zz;
                ++k;
            } else if (viso) break;
            viso = vis;
        }
        pix.off = i;
        pix.n = i;
        if (!chk) {
            k = this.checkrange(pax, pay, k);
        }
        return k;
    }

    @Override
    public int rwc2pix(double[] buf, int off, int dim, int npts, Pix pix) {
        int i;
        if (off + dim * npts > buf.length) {
            Midas.log("Data is incompatible with View Geo", 1);
            return 0;
        }
        int j = off;
        int k = 0;
        int[] pax = pix.x;
        int[] pay = pix.y;
        float[] paz = pix.z;
        double mxx = this.MP.mxx;
        double myy = this.MP.myy;
        double mxb = this.MP.mxb;
        double myb = this.MP.myb;
        boolean viso = false;
        boolean chk = (pix.flags & 1) != 0;
        boolean keep = (pix.flags & 0x10) != 0;
        boolean fullkeep = (pix.flags & 0x40) != 0;
        npts = Math.min(npts, pix.max);
        for (i = 0; i < npts; ++i) {
            double radialLineAdjustment;
            boolean vis;
            double zz;
            double yy;
            double xx;
            double alon = buf[j++] - this.lon + 360.0;
            double alat = buf[j++] + 360.0;
            int ilon = (int)alon;
            int ilat = (int)alat;
            double plon = alon - (double)ilon;
            double plat = alat - (double)ilat;
            if (ilon < 0 || ilon >= this.tcos.length || ilon >= this.dtcos.length || ilon > this.tsin.length || ilon > this.dtsin.length || ilat < 0 || ilat >= this.tcos.length || ilat >= this.dtcos.length || ilat > this.tsin.length || ilat > this.dtsin.length) continue;
            double cp = this.tcos[ilon] + plon * this.dtcos[ilon];
            double sp = this.tsin[ilon] + plon * this.dtsin[ilon];
            double ct = this.tcos[ilat] + plat * this.dtcos[ilat];
            double st = this.tsin[ilat] + plat * this.dtsin[ilat];
            double ctcp = ct * cp;
            if (dim == 2) {
                xx = ct * sp;
                yy = ctcp * this.slat + st * this.clat;
                zz = ctcp * this.clat - st * this.slat;
                vis = zz > this.zvis;
                radialLineAdjustment = this.draltO / (this.draltO - zz);
                xx *= radialLineAdjustment;
                yy *= radialLineAdjustment;
            } else {
                double rr = (buf[j++] + this.equatorialRadius) * this.inverseEquatorialRad;
                xx = rr * (ct * sp);
                yy = rr * (ctcp * this.slat + st * this.clat);
                zz = rr * (ctcp * this.clat - st * this.slat);
                radialLineAdjustment = this.draltO / (this.draltO - zz);
                boolean bl = vis = zz < this.draltO && (zz > this.zvis || (xx *= radialLineAdjustment) * xx + (yy *= radialLineAdjustment) * yy >= this.rvis);
            }
            if (vis || fullkeep) {
                pax[k] = (int)(xx * mxx + mxb);
                pay[k] = (int)(yy * myy + myb);
                paz[k] = (float)zz;
                ++k;
            } else if (chk) {
                pax[k] = 0;
                pay[k] = 0;
                paz[k] = (float)zz;
                ++k;
            } else if (viso) break;
            viso = vis;
        }
        pix.off = i;
        pix.n = i;
        if (!chk && !keep) {
            k = this.checkrange(pax, pay, k);
        }
        return k;
    }

    private int checkrange(int[] pax, int[] pay, int kpts) {
        if (kpts == 2) {
            if (pax[0] > this.MP.ix2 + 100 && pax[1] > this.MP.ix2 + 100) {
                kpts = 0;
            }
            if (pax[0] < this.MP.ix1 - 100 && pax[1] < this.MP.ix1 - 100) {
                kpts = 0;
            }
            if (pay[0] > this.MP.iy2 + 100 && pay[1] > this.MP.iy2 + 100) {
                kpts = 0;
            }
            if (pay[0] < this.MP.iy1 - 100 && pay[1] < this.MP.iy1 - 100) {
                kpts = 0;
            }
        } else if (kpts == 1) {
            if (pax[0] > this.MP.ix2 + 100) {
                kpts = 0;
            }
            if (pax[0] < this.MP.ix1 - 100) {
                kpts = 0;
            }
            if (pay[0] > this.MP.iy2 + 100) {
                kpts = 0;
            }
            if (pay[0] < this.MP.iy1 - 100) {
                kpts = 0;
            }
        }
        return kpts;
    }

    public boolean fastPix2rwc(int x, int y, float[] rwc) {
        boolean offEarth = false;
        float p2 = this.raltO * this.raltO;
        float retx = (float)(((double)x - this.MP.mxb) / this.MP.mxx);
        float rety = (float)(((double)y - this.MP.myb) / this.MP.myy);
        float rad = retx * retx + rety * rety;
        float fact = (float)this.quadsolve(p2 + rad, -2.0f * p2, p2 - 1.0f);
        if (fact == 0.0f) {
            offEarth = true;
        } else {
            float rrety = rety * fact;
            float rretz = (float)Math.sqrt(1.0f - rad * fact * fact);
            retx *= fact;
            rety = (float)((double)rrety * this.clat - (double)rretz * this.slat);
            float retz = (float)((double)rrety * this.slat + (double)rretz * this.clat);
            float rlonRad = (float)Math.PI / 180 * this.rlonO;
            retx = this.fastAtan2(retx, retz);
            rwc[0] = (rlonRad + retx + (float)Math.PI * 3) % ((float)Math.PI * 2);
            rwc[1] = (float)Math.PI - (float)Math.asin(rety);
        }
        return offEarth;
    }

    private float fastAtan2(float y, float x) {
        int yy = Float.floatToRawIntBits(y);
        int xx = Float.floatToRawIntBits(x);
        int ix = xx & Integer.MAX_VALUE;
        int iy = yy & Integer.MAX_VALUE;
        int m = yy >> 31 & 1 | xx >> 30 & 2;
        int k = iy - ix >> 20;
        float z = k > 60 ? 1.5707964f : (xx < 0 && k < -60 ? 0.0f : (float)Math.atan(Math.abs(y / x)));
        int zz = Float.floatToRawIntBits(z);
        switch (m) {
            case 0: {
                return z;
            }
            case 1: {
                return Float.intBitsToFloat(zz ^ Integer.MIN_VALUE);
            }
            case 2: {
                return (float)Math.PI - (z - 1.2246469E-16f);
            }
        }
        return z - 1.2246469E-16f - (float)Math.PI;
    }

    @Override
    int rwc2dpix(double[] buf, DPix pix) {
        return this.rwc2dpix(buf, 0, 3, 1, pix);
    }

    @Override
    public int rwc2dpix(double[] buf, int off, int dim, int npts, DPix pix) {
        int i;
        int j = off;
        int k = 0;
        double[] pax = pix.x;
        double[] pay = pix.y;
        double[] paz = pix.z;
        double mxx = this.MP.mxx;
        double myy = this.MP.myy;
        double mxb = this.MP.mxb;
        double myb = this.MP.myb;
        boolean viso = false;
        boolean chk = (pix.flags & 1) != 0;
        boolean keep = (pix.flags & 0x10) != 0;
        boolean fullkeep = (pix.flags & 0x40) != 0;
        npts = Math.min(npts, pix.max);
        for (i = 0; i < npts; ++i) {
            double ff;
            boolean vis;
            double zz;
            double yy;
            double xx;
            double alon = buf[j++] - this.lon + 360.0;
            double alat = buf[j++] + 360.0;
            int ilon = (int)alon;
            int ilat = (int)alat;
            double plon = alon - (double)ilon;
            double plat = alat - (double)ilat;
            if (ilon < 0 || ilon >= this.tcos.length || ilon >= this.dtcos.length || ilon > this.tsin.length || ilon > this.dtsin.length || ilat < 0 || ilat >= this.tcos.length || ilat >= this.dtcos.length || ilat > this.tsin.length || ilat > this.dtsin.length) continue;
            double cp = this.tcos[ilon] + plon * this.dtcos[ilon];
            double sp = this.tsin[ilon] + plon * this.dtsin[ilon];
            double ct = this.tcos[ilat] + plat * this.dtcos[ilat];
            double st = this.tsin[ilat] + plat * this.dtsin[ilat];
            double ctcp = ct * cp;
            ctcp = ct * cp;
            if (dim == 2) {
                xx = ct * sp;
                yy = ctcp * this.slat + st * this.clat;
                zz = ctcp * this.clat - st * this.slat;
                vis = zz > this.zvis;
                ff = this.draltO / (this.draltO - zz);
                xx *= ff;
                yy *= ff;
            } else {
                double rr = (buf[j++] + this.equatorialRadius) * this.inverseEquatorialRad;
                xx = rr * (ct * sp);
                yy = rr * (ctcp * this.slat + st * this.clat);
                zz = rr * (ctcp * this.clat - st * this.slat);
                ff = this.draltO / (this.draltO - zz);
                boolean bl = vis = zz < this.draltO && (zz > this.zvis || (xx *= ff) * xx + (yy *= ff) * yy >= this.rvis);
            }
            if (vis || fullkeep) {
                pax[k] = xx * mxx + mxb;
                pay[k] = yy * myy + myb;
                paz[k] = zz;
                ++k;
            } else if (chk) {
                pax[k] = 0.0;
                pay[k] = 0.0;
                paz[k] = zz;
                ++k;
            } else if (viso) break;
            viso = vis;
        }
        pix.off = i;
        pix.n = i;
        if (!chk && !keep) {
            k = this.checkrange(pax, pay, k);
        }
        return k;
    }

    private int checkrange(double[] pax, double[] pay, int kpts) {
        if (kpts == 2) {
            if (pax[0] > (double)(this.MP.ix2 + 100) && pax[1] > (double)(this.MP.ix2 + 100)) {
                kpts = 0;
            }
            if (pax[0] < (double)(this.MP.ix1 - 100) && pax[1] < (double)(this.MP.ix1 - 100)) {
                kpts = 0;
            }
            if (pay[0] > (double)(this.MP.iy2 + 100) && pay[1] > (double)(this.MP.iy2 + 100)) {
                kpts = 0;
            }
            if (pay[0] < (double)(this.MP.iy1 - 100) && pay[1] < (double)(this.MP.iy1 - 100)) {
                kpts = 0;
            }
        } else if (kpts == 1) {
            if (pax[0] > (double)(this.MP.ix2 + 100)) {
                kpts = 0;
            }
            if (pax[0] < (double)(this.MP.ix1 - 100)) {
                kpts = 0;
            }
            if (pay[0] > (double)(this.MP.iy2 + 100)) {
                kpts = 0;
            }
            if (pay[0] < (double)(this.MP.iy1 - 100)) {
                kpts = 0;
            }
        }
        return kpts;
    }

    @Override
    int rwc2pix(double[] rwc, MPoint pix, boolean rangeAdjust) {
        Midas.log("rwc2pix with range adjustment designed for latloncontinuous is NOT designed for ViewGeo", 1);
        return this.rwc2pix(rwc, pix);
    }

    @Override
    int rwc2pix(double[] buf, int off, int dim, int npts, Pix pix, boolean isSpecializedFill) {
        return this.rwc2pix(buf, off, dim, npts, pix);
    }

    @Override
    int rwc2pixClip(float[] buf, int off, int dim, int npts, Pix pix, boolean mer) {
        Midas.log("rwc2pixClip is NOT designed for ViewGeo", 1);
        return this.rwc2pix(buf, off, dim, npts, pix);
    }

    @Override
    int rwc2pixClip(double[] buf, int off, int dim, int npts, MPlot MP, Pix pix) {
        Midas.log("rwc2pixClip is NOT designed for ViewGeo", 1);
        return this.rwc2pix(buf, off, dim, npts, pix);
    }

    @Override
    int rwc2pixClip(double[] buf, int off, int dim, int npts, Pix pix, boolean mer) {
        Midas.log("rwc2pixClip is NOT designed for ViewGeo", 1);
        return this.rwc2pix(buf, off, dim, npts, pix);
    }

    @Override
    int rwc2pixClipAdjustForFill(double[] buf, int off, int dim, int npts, Pix pix, boolean mer) {
        Midas.log("rwc2pixClipAdjustForFill is NOT designed for ViewGeo", 1);
        return this.rwc2pix(buf, off, dim, npts, pix);
    }

    @Override
    int rwc2dpixClip(double[] buf, int off, int dim, int npts, MPlot MP, DPix pix) {
        Midas.log("rwc2dpixClip is NOT designed for ViewGeo", 1);
        return this.rwc2dpix(buf, off, dim, npts, pix);
    }

    @Override
    int rwc2dpixClip(double[] buf, int off, int dim, int npts, DPix pix, boolean mer) {
        Midas.log("rwc2dpixClip is NOT designed for ViewGeo", 1);
        return this.rwc2dpix(buf, off, dim, npts, pix);
    }
}

