/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import nxm.sys.inc.Constants;
import nxm.sys.lib.Midas;
import nxm.sys.libg.DPix;
import nxm.sys.libg.GeometricUtil;
import nxm.sys.libg.IntersectingLine;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.MPoint;
import nxm.sys.libg.Pix;
import nxm.sys.libg.ViewMercader;

public class View
implements Constants {
    protected MPlot MP;

    public View(MPlot MP) {
        this.MP = MP;
    }

    public boolean setObserver(double[] arg) {
        return true;
    }

    public boolean getObserver(double[] arg) {
        arg[2] = 0.0;
        arg[1] = 0.0;
        arg[0] = 0.0;
        return true;
    }

    public boolean rotate(double[] arg) {
        return true;
    }

    public void setup() {
    }

    public int rwc2pix(double[] rwc, MPoint pix) {
        if (rwc == null || rwc.length < 2 || pix == null) {
            return 1;
        }
        if (this.MP.xvy) {
            pix.y = (int)(rwc[0] * this.MP.mxx + this.MP.mxb);
            pix.x = (int)(rwc[1] * this.MP.myy + this.MP.myb);
        } else {
            double xCord = rwc[0];
            if (this.MP.view == 14 && this.MP.hasExtendedRange() && xCord <= this.MP.orx1 && xCord + 360.0 < this.MP.orx2) {
                xCord += 360.0;
            }
            pix.x = (int)(xCord * this.MP.mxx + this.MP.mxb);
            pix.y = (int)(rwc[1] * this.MP.myy + this.MP.myb);
        }
        return 1;
    }

    int rwc2pix(double[] rwc, MPoint pix, boolean rangeAdjust) {
        if (rwc == null || rwc.length < 2 || pix == null) {
            return 1;
        }
        if (this.MP.xvy) {
            pix.y = (int)(rwc[0] * this.MP.mxx + this.MP.mxb);
            pix.x = (int)(rwc[1] * this.MP.myy + this.MP.myb);
        } else {
            double xCord = rwc[0];
            if (rangeAdjust && this.MP.view == 14 && this.MP.hasExtendedRange() && xCord <= this.MP.orx1 && xCord + 360.0 < this.MP.orx2) {
                xCord += 360.0;
            }
            pix.x = (int)(xCord * this.MP.mxx + this.MP.mxb);
            pix.y = (int)(rwc[1] * this.MP.myy + this.MP.myb);
        }
        return 1;
    }

    public int pix2rwc(MPoint pix, double[] rwc) {
        if (pix == null || rwc == null || rwc.length < 3) {
            return 0;
        }
        if (this.MP.xvy) {
            rwc[0] = ((double)pix.y - this.MP.mxb) / this.MP.mxx;
            rwc[1] = ((double)pix.x - this.MP.myb) / this.MP.myy;
        } else {
            rwc[0] = ((double)pix.x - this.MP.mxb) / this.MP.mxx;
            rwc[1] = ((double)pix.y - this.MP.myb) / this.MP.myy;
        }
        rwc[2] = 0.0;
        return 0;
    }

    public int rwc2pix(float[] buf, int off, int dim, int npts, Pix pix, double xstart, double xdelta) {
        if (buf == null || pix == null) {
            return 0;
        }
        int j = off;
        int xoff = off / dim;
        int[] pax = pix.x;
        int[] pay = pix.y;
        int pixSz = pix.setSize(npts);
        int n = this.calcNumPointsToPlot(buf.length, off, dim, pixSz, pax.length, pay.length);
        double mxx = this.MP.mxx;
        double myy = this.MP.myy;
        double mxb = this.MP.mxb;
        double myb = this.MP.myb;
        if (dim == 1) {
            int i = 0;
            while (i < n) {
                double x = xstart + (double)(xoff + i) * xdelta;
                pax[i] = (int)(x * mxx + mxb);
                pay[i] = (int)((double)buf[j] * myy + myb);
                ++i;
                ++j;
            }
        } else {
            int i = 0;
            while (i < n) {
                double x = xstart + (double)(xoff + i) * xdelta;
                pax[i] = (int)(x * mxx + mxb);
                pay[i] = (int)((double)buf[j] * myy + myb);
                ++i;
                j += dim;
            }
        }
        return n;
    }

    public int rwc2pix(double[] buf, int off, int dim, int npts, Pix pix, double xstart, double xdelta) {
        if (buf == null || pix == null) {
            return 0;
        }
        int j = off;
        int xoff = off / dim;
        int[] pax = pix.x;
        int[] pay = pix.y;
        int pixSz = pix.setSize(npts);
        int n = this.calcNumPointsToPlot(buf.length, off, dim, pixSz, pax.length, pay.length);
        double mxx = this.MP.mxx;
        double myy = this.MP.myy;
        double mxb = this.MP.mxb;
        double myb = this.MP.myb;
        if (dim == 1) {
            int i = 0;
            while (i < n) {
                double x = xstart + (double)(xoff + i) * xdelta;
                pax[i] = (int)(x * mxx + mxb);
                pay[i] = (int)(buf[j] * myy + myb);
                ++i;
                ++j;
            }
        } else {
            int i = 0;
            while (i < n) {
                double x = xstart + (double)(xoff + i) * xdelta;
                pax[i] = (int)(x * mxx + mxb);
                pay[i] = (int)(buf[j] * myy + myb);
                ++i;
                j += dim;
            }
        }
        return n;
    }

    public int rwc2pix(float[] buf, int off, int dim, int npts, Pix pix) {
        if (buf == null || pix == null) {
            return 0;
        }
        int j = off;
        int n = pix.setSize(npts);
        int[] pax = pix.x;
        int[] pay = pix.y;
        double mxx = this.MP.mxx;
        double myy = this.MP.myy;
        double mxb = this.MP.mxb;
        double myb = this.MP.myb;
        if ((pix.flags & 2) != 0) {
            if (this.MP.view == 11 || this.MP.view == 14) {
                return this.rwc2pixClip(buf, off, dim, npts, pix, false);
            }
            int dxmax = this.MP.ix21 / 2;
            int dymax = this.MP.iy21 / 2;
            for (int i = 0; i < n && i < pax.length && i < pay.length && j < buf.length - 1; ++i, j += dim) {
                pax[i] = (int)((double)buf[j + 0] * mxx + mxb);
                pay[i] = (int)((double)buf[j + 1] * myy + myb);
                if (i == 0) continue;
                int dx = pax[i] - pax[i - 1];
                int dy = pay[i] - pay[i - 1];
                if (dx >= -dxmax && dx <= dxmax && dy >= -dymax && dy <= dymax) continue;
                pix.off = i;
                pix.n = i;
                return i;
            }
        } else {
            if (this.MP.view == 14 && this.MP.hasExtendedRange()) {
                return this.rwc2pixClip(buf, off, dim, npts, pix, false);
            }
            if (dim == 2) {
                for (int i = 0; i < n && i < pax.length && i < pay.length && j < buf.length - 1; ++i) {
                    pax[i] = (int)((double)buf[j++] * mxx + mxb);
                    pay[i] = (int)((double)buf[j++] * myy + myb);
                }
            } else {
                for (int i = 0; i < n && i < pax.length && i < pay.length && j < buf.length - 1; ++i, j += dim) {
                    pax[i] = (int)((double)buf[j + 0] * mxx + mxb);
                    pay[i] = (int)((double)buf[j + 1] * myy + myb);
                }
            }
        }
        return n;
    }

    public int rwc2pix(double[] buf, int off, int dim, int npts, Pix pix) {
        return this.rwc2pix(buf, off, dim, npts, pix, false);
    }

    int rwc2pix(double[] buf, int off, int dim, int npts, Pix pix, boolean isSpecializedFill) {
        if (buf == null || pix == null) {
            return 0;
        }
        int j = off;
        int n = pix.setSize(npts);
        int[] pax = pix.x;
        int[] pay = pix.y;
        double mxx = this.MP.mxx;
        double myy = this.MP.myy;
        double mxb = this.MP.mxb;
        double myb = this.MP.myb;
        pix.save = false;
        if ((pix.flags & 2) != 0) {
            if (this.MP.view == 11 || this.MP.view == 14) {
                if (!isSpecializedFill) {
                    return this.rwc2pixClip(buf, off, dim, npts, pix, false);
                }
                int res = this.rwc2pixClipAdjustForFill(buf, off, dim, npts, pix, false);
                return this.pixSpanEntireMap(pix, res, buf[1] > 0.0);
            }
            int dxmax = this.MP.ix21 / 2;
            int dymax = this.MP.iy21 / 2;
            for (int i = 0; i < n && i < pax.length && i < pay.length && j < buf.length - 1; ++i, j += dim) {
                pax[i] = (int)(buf[j + 0] * mxx + mxb);
                pay[i] = (int)(buf[j + 1] * myy + myb);
                if (i == 0) continue;
                int dx = pax[i] - pax[i - 1];
                int dy = pay[i] - pay[i - 1];
                if (dx >= -dxmax && dx <= dxmax && dy >= -dymax && dy <= dymax) continue;
                pix.off = i;
                pix.n = i;
                return i;
            }
        } else {
            if (this.MP.view == 14 && this.MP.hasExtendedRange()) {
                if (!isSpecializedFill) {
                    return this.rwc2pixClip(buf, off, dim, npts, pix, false);
                }
                int res = this.rwc2pixClipAdjustForFill(buf, off, dim, npts, pix, false);
                return this.pixSpanEntireMap(pix, res, buf[1] > 0.0);
            }
            if (dim == 2) {
                for (int i = 0; i < n && i < pax.length && i < pay.length && j < buf.length - 1; ++i) {
                    pax[i] = (int)(buf[j++] * mxx + mxb);
                    pay[i] = (int)(buf[j++] * myy + myb);
                }
            } else {
                for (int i = 0; i < n && i < pax.length && i < pay.length && j < buf.length - 1; ++i, j += dim) {
                    pax[i] = (int)(buf[j + 0] * mxx + mxb);
                    pay[i] = (int)(buf[j + 1] * myy + myb);
                }
            }
        }
        return n;
    }

    int rwc2pixClip(float[] buf, int off, int dim, int npts, Pix pix, boolean mer) {
        if (buf == null || pix == null) {
            return 0;
        }
        int j = off;
        int n = pix.setSize(npts);
        int[] pax = pix.x;
        int[] pay = pix.y;
        double mxx = this.MP.mxx;
        double mxb = this.MP.mxb;
        double myy = this.MP.myy;
        double myb = this.MP.myb;
        double rx = this.MP.hasExtendedRange() ? (this.MP.getOuterXMax() - this.MP.getOuterXMin()) / 2.0 : 0.0;
        double ry = 0.0;
        double range = MPlot.LONGITUDE_RANGE;
        double max = MPlot.LONGITUDE_DEFAULT_MAX;
        if (this.MP.hasExtendedRange()) {
            double p = 1.0E-6;
            if (this.MP.getOuterXMax() > (double)MPlot.LONGITUDE_DEFAULT_MAX + p) {
                max = this.MP.getOuterXMax();
            }
            if (this.MP.getOuterXMin() < (double)MPlot.LONGITUDE_DEFAULT_MIN - p) {
                max = this.MP.getOuterXMin() + (double)MPlot.LONGITUDE_RANGE;
            }
        }
        double min = max - (double)MPlot.LONGITUDE_RANGE;
        double rxWrapHigh = max - (double)MPlot.LONGITUDE_RANGE / 4.0;
        double rxWrapLow = min + (double)MPlot.LONGITUDE_RANGE / 4.0;
        for (int i = 0; i < n && i < pax.length && i < pay.length && j < buf.length - 1; ++i, j += dim) {
            double rxp = rx;
            double ryp = ry;
            ry = buf[j + 1];
            for (rx = (double)buf[j + 0]; rx > max; rx -= (double)MPlot.LONGITUDE_RANGE) {
            }
            while (rx < min) {
                rx += (double)MPlot.LONGITUDE_RANGE;
            }
            while (ry > 90.0) {
                ry -= 180.0;
            }
            while (ry < -90.0) {
                ry += 180.0;
            }
            pax[i] = (int)(rx * mxx + mxb);
            int n2 = pay[i] = mer ? (int)(ViewMercader.lat2mer(ry) * myy + myb) : (int)(ry * myy + myb);
            if (i == 0 || !(rx > rxWrapHigh && rxp < rxWrapLow) && (!(rxp > rxWrapHigh) || !(rx < rxWrapLow))) continue;
            this.splitLineSegment(rx, ry, rxp, ryp, range, pax, pay, pix, i, mer, mxx, mxb, myy, myb, min, max);
            return i + 1;
        }
        return n;
    }

    int rwc2pixClip(double[] buf, int off, int dim, int npts, MPlot MP, Pix pix) {
        boolean mer;
        if (buf == null || pix == null) {
            return 0;
        }
        double rx = 0.0;
        double ry = 0.0;
        double mxx = MP.mxx;
        double mxb = MP.mxb;
        double myy = MP.myy;
        double myb = MP.myb;
        boolean bl = mer = MP.view != 11 && MP.view != 14;
        if (mer) {
            myy = (double)(MP.iy1 - MP.iy2) / (ViewMercader.lat2mer(MP.ry2) - ViewMercader.lat2mer(MP.ry1));
            myb = (double)MP.iy2 - ViewMercader.lat2mer(MP.ry1) * myy;
        }
        int i1 = 0;
        int i2 = 0;
        boolean drawMain = true;
        Pix pixMain = new Pix(npts, pix.flags);
        Pix pixAlt = new Pix(npts, pix.flags);
        for (int i = 0; i < npts && off < buf.length - 1; ++i, off += dim) {
            int y;
            double rxp = rx;
            double ryp = ry;
            ry = buf[off + 1];
            for (rx = buf[off + 0]; rx > 180.0; rx -= 360.0) {
            }
            while (rx < -180.0) {
                rx += 360.0;
            }
            while (ry > 90.0) {
                ry -= 180.0;
            }
            while (ry < -90.0) {
                ry += 180.0;
            }
            int x = (int)(rx * mxx + mxb);
            int n = y = mer ? (int)(ViewMercader.lat2mer(ry) * myy + myb) : (int)(ry * myy + myb);
            if (rx > 90.0 && rxp < -90.0 || rx < -90.0 && rxp > 90.0) {
                int pt = rx < rxp ? 180 : -180;
                int newY = this.getExtrapolatedYPix(rx, rxp, ry, ryp, MP);
                if (!drawMain) {
                    pt = -pt;
                }
                this.checkSize(pixMain, i1 + 2);
                this.checkSize(pixAlt, i2 + 2);
                pixMain.x[i1] = (int)((double)pt * mxx + mxb);
                pixMain.y[i1++] = newY;
                pixAlt.x[i2] = (int)((double)(-pt) * mxx + mxb);
                pixAlt.y[i2++] = newY;
                drawMain = !drawMain;
                pix.save = true;
            }
            if (drawMain) {
                pixMain.x[i1] = x;
                pixMain.y[i1++] = y;
                continue;
            }
            pixAlt.x[i2] = x;
            pixAlt.y[i2++] = y;
        }
        pix.n = i2;
        pix.x = pixMain.x;
        pix.y = pixMain.y;
        pix.sx = pixAlt.x;
        pix.sy = pixAlt.y;
        pix.off = npts;
        return i1;
    }

    private int getExtrapolatedYPix(double rx, double rxp, double ry, double ryp, MPlot MP) {
        boolean mer;
        double myy = MP.myy;
        double myb = MP.myb;
        boolean bl = mer = MP.view == 12;
        if (mer) {
            myy = (double)(MP.iy1 - MP.iy2) / (ViewMercader.lat2mer(MP.ry2) - ViewMercader.lat2mer(MP.ry1));
            myb = (double)MP.iy2 - ViewMercader.lat2mer(MP.ry1) * myy;
        }
        int base = rx < rxp ? 180 : -180;
        double dx1 = rx - rxp + (double)(base * 2);
        double dy1 = ry - ryp;
        double dx2 = (double)base - rxp;
        double ryn = dx2 / (dx1 / dy1) + ryp;
        int newY = mer ? (int)(ViewMercader.lat2mer(ryn) * myy + myb) : (int)(ryn * myy + myb);
        return newY;
    }

    private int getYAtBorder(double rx, double ry, double rxp, double ryp, double rxShift, boolean crossLeft, double myy, double myb) {
        double x1 = rx;
        double y1 = ry;
        double x2 = crossLeft ? rxp + (double)MPlot.LONGITUDE_RANGE : rxp - (double)MPlot.LONGITUDE_RANGE;
        double y2 = ryp;
        boolean mer = this.MP.view == 12;
        double slope = (y2 - y1) / (x2 - x1);
        double yIntercept = y1 - slope * x1;
        double ryn = slope * rxShift + yIntercept;
        return (int)(mer ? (double)((int)(ViewMercader.lat2mer(ryn) * myy + myb)) : ryn * myy + myb);
    }

    private void checkSize(Pix pix, int size) {
        this.checkSize(pix, size, 0);
    }

    private void checkSize(Pix pix, int size, int sizeSave) {
        int[] tmpy;
        int[] tmpx;
        if (pix.x.length <= size || pix.y.length <= size) {
            tmpx = new int[pix.x.length * 2];
            tmpy = new int[pix.y.length * 2];
            System.arraycopy(pix.x, 0, tmpx, 0, pix.x.length);
            pix.x = tmpx;
            System.arraycopy(pix.y, 0, tmpy, 0, pix.y.length);
            pix.y = tmpy;
        }
        if (pix.sx.length <= sizeSave || pix.sy.length <= sizeSave) {
            tmpx = new int[pix.sx.length * 2];
            tmpy = new int[pix.sy.length * 2];
            System.arraycopy(pix.sx, 0, tmpx, 0, pix.sx.length);
            pix.sx = tmpx;
            System.arraycopy(pix.sy, 0, tmpy, 0, pix.sy.length);
            pix.sy = tmpy;
        }
    }

    int rwc2pixClip(double[] buf, int off, int dim, int npts, Pix pix, boolean mer) {
        boolean neverClip;
        boolean bl = neverClip = (pix.flags & 0x20) != 0 && this.MP.view == 14;
        if (buf == null || pix == null) {
            return 0;
        }
        int j = off;
        int n = pix.setSize(npts);
        int[] pax = pix.x;
        int[] pay = pix.y;
        double mxx = this.MP.mxx;
        double mxb = this.MP.mxb;
        double myy = this.MP.myy;
        double myb = this.MP.myb;
        double rx = this.MP.hasExtendedRange() ? (this.MP.getOuterXMax() - this.MP.getOuterXMin()) / 2.0 : 0.0;
        double ry = 0.0;
        double range = MPlot.LONGITUDE_RANGE;
        double max = MPlot.LONGITUDE_DEFAULT_MAX;
        if (mer) {
            myy = (double)(this.MP.iy1 - this.MP.iy2) / (ViewMercader.lat2mer(this.MP.ry2) - ViewMercader.lat2mer(this.MP.ry1));
            myb = (double)this.MP.iy2 - ViewMercader.lat2mer(this.MP.ry1) * myy;
        }
        if (this.MP.hasExtendedRange()) {
            double p = 1.0E-6;
            if (this.MP.getOuterXMax() > (double)MPlot.LONGITUDE_DEFAULT_MAX + p) {
                max = this.MP.getOuterXMax();
            }
            if (this.MP.getOuterXMin() < (double)MPlot.LONGITUDE_DEFAULT_MIN - p) {
                max = this.MP.getOuterXMin() + (double)MPlot.LONGITUDE_RANGE;
            }
        }
        double min = max - (double)MPlot.LONGITUDE_RANGE;
        double rxWrapHigh = max - (double)MPlot.LONGITUDE_RANGE / 4.0;
        double rxWrapLow = min + (double)MPlot.LONGITUDE_RANGE / 4.0;
        for (int i = 0; i < n && i < pax.length && i < pay.length && j < buf.length - 1; ++i, j += dim) {
            double rxp = rx;
            double ryp = ry;
            ry = buf[j + 1];
            for (rx = buf[j + 0]; rx > max; rx -= (double)MPlot.LONGITUDE_RANGE) {
            }
            while (rx < min) {
                rx += (double)MPlot.LONGITUDE_RANGE;
            }
            while (ry > 90.0) {
                ry -= 180.0;
            }
            while (ry < -90.0) {
                ry += 180.0;
            }
            pax[i] = (int)(rx * mxx + mxb);
            int n2 = pay[i] = mer ? (int)(ViewMercader.lat2mer(ry) * myy + myb) : (int)(ry * myy + myb);
            if (i == 0 || !(rx > rxWrapHigh && rxp < rxWrapLow) && (!(rxp > rxWrapHigh) || !(rx < rxWrapLow)) || neverClip) continue;
            this.splitLineSegment(rx, ry, rxp, ryp, range, pax, pay, pix, i, mer, mxx, mxb, myy, myb, min, max);
            return i + 1;
        }
        return n;
    }

    int rwc2pixClipAdjustForFill(double[] buf, int off, int dim, int npts, Pix pix, boolean mer) {
        if (buf == null || pix == null) {
            return 0;
        }
        int n = pix.setSize(npts);
        if (pix.x.length < npts) {
            pix.x = new int[npts];
        }
        if (pix.y.length < npts) {
            pix.y = new int[npts];
        }
        double mxx = this.MP.mxx;
        double mxb = this.MP.mxb;
        double myy = this.MP.myy;
        double myb = this.MP.myb;
        double rx = this.MP.hasExtendedRange() ? (this.MP.getOuterXMax() - this.MP.getOuterXMin()) / 2.0 : 0.0;
        double ry = 0.0;
        double max = MPlot.LONGITUDE_DEFAULT_MAX;
        if (mer) {
            myy = (double)(this.MP.iy1 - this.MP.iy2) / (ViewMercader.lat2mer(this.MP.ry2) - ViewMercader.lat2mer(this.MP.ry1));
            myb = (double)this.MP.iy2 - ViewMercader.lat2mer(this.MP.ry1) * myy;
        }
        if (this.MP.hasExtendedRange()) {
            double p = 1.0E-6;
            if (this.MP.getOuterXMax() > (double)MPlot.LONGITUDE_DEFAULT_MAX + p) {
                max = this.MP.getOuterXMax();
            }
            if (this.MP.getOuterXMin() < (double)MPlot.LONGITUDE_DEFAULT_MIN - p) {
                max = this.MP.getOuterXMin() + (double)MPlot.LONGITUDE_RANGE;
            }
        }
        int i1 = 0;
        int i2 = 0;
        boolean drawMain = true;
        double min = max - (double)MPlot.LONGITUDE_RANGE;
        double rxWrapHigh = max - (double)MPlot.LONGITUDE_RANGE / 4.0;
        double rxWrapLow = min + (double)MPlot.LONGITUDE_RANGE / 4.0;
        pix.sx = new int[npts];
        pix.sy = new int[npts];
        for (int i = 0; i < n && i < npts && off < buf.length - 1; ++i, off += dim) {
            boolean crossRight;
            int y;
            double rxp = rx;
            double ryp = ry;
            ry = buf[off + 1];
            for (rx = buf[off + 0]; rx > max; rx -= (double)MPlot.LONGITUDE_RANGE) {
            }
            while (rx < min) {
                rx += (double)MPlot.LONGITUDE_RANGE;
            }
            while (ry > 90.0) {
                ry -= 180.0;
            }
            while (ry < -90.0) {
                ry += 180.0;
            }
            int x = (int)(rx * mxx + mxb);
            int n2 = y = mer ? (int)(ViewMercader.lat2mer(ry) * myy + myb) : (int)(ry * myy + myb);
            if (i == 0) {
                pix.x[i1] = x;
                pix.y[i1++] = y;
                continue;
            }
            boolean crossLeft = rx > rxWrapHigh && rxp < rxWrapLow;
            boolean bl = crossRight = rxp > rxWrapHigh && rx < rxWrapLow;
            if (crossLeft || crossRight) {
                double rxpShift;
                double rxShift;
                if (crossLeft) {
                    rxShift = min;
                    rxpShift = max;
                } else {
                    rxShift = max;
                    rxpShift = min;
                }
                this.checkSize(pix, npts - i + i1, npts - i + i2);
                double diffToCompare = (double)(this.MP.ix2 - this.MP.ix1) * 0.8;
                if (drawMain && i2 > 0 && (double)pix.x[i1 - 1] > diffToCompare && pix.x[i1 - 1] <= pix.sx[i2 - 1]) {
                    int j;
                    for (j = 0; j < i2 && (double)pix.sx[j] > diffToCompare; ++j) {
                        pix.x[i1] = pix.sx[j];
                        pix.y[i1++] = pix.sy[j];
                    }
                    if ((i2 -= j) != 0) {
                        Midas.log("The shape may not draw correctly when split", 1);
                    }
                }
                int newY = this.getYAtBorder(rx, ry, rxp, ryp, rxpShift, crossLeft, myy, myb);
                pix.x[i1] = (int)((drawMain ? rxShift : rxpShift) * mxx + mxb);
                pix.y[i1] = newY;
                pix.sy[i2] = newY;
                pix.sx[i2] = (int)((!drawMain ? rxShift : rxpShift) * mxx + mxb);
                ++i1;
                ++i2;
                drawMain = !drawMain;
                pix.save = true;
            }
            if (drawMain) {
                pix.x[i1] = x;
                pix.y[i1++] = y;
                continue;
            }
            pix.sx[i2] = x;
            pix.sy[i2++] = y;
        }
        pix.n = i2;
        pix.off = npts;
        return i1;
    }

    private void splitLineSegment(double rx, double ry, double rxp, double ryp, double range, int[] pax, int[] pay, Pix pix, int i, boolean mer, double mxx, double mxb, double myy, double myb, double min, double max) {
        double ryn;
        double rxNewPax;
        double rxnNewPix;
        if (rx < rxp) {
            double dx1 = rx - rxp + range;
            double dy1 = ry - ryp;
            double dx2 = max - rxp;
            rxnNewPix = min;
            rxNewPax = max;
            ryn = dx2 / (dx1 / dy1) + ryp;
        } else {
            double dx1 = rx - rxp - range;
            double dy1 = ry - ryp;
            double dx2 = min - rxp;
            rxnNewPix = max;
            rxNewPax = min;
            ryn = dx2 / (dx1 / dy1) + ryp;
        }
        pix.sx[0] = (int)(rxnNewPix * mxx + mxb);
        pix.sx[1] = pax[i];
        pix.sy[0] = mer ? (int)(ViewMercader.lat2mer(ryn) * myy + myb) : (int)(ryn * myy + myb);
        pix.sy[1] = pay[i];
        pax[i] = (int)(rxNewPax * mxx + mxb);
        pay[i] = pix.sy[0];
        pix.save = true;
        pix.off = i;
        pix.n = 2;
    }

    int rwc2dpix(double[] rwc, DPix pix) {
        if (rwc == null || rwc.length < 2 || pix == null) {
            return 1;
        }
        if (this.MP.xvy) {
            pix.y[0] = rwc[0] * this.MP.mxx + this.MP.mxb;
            pix.x[0] = rwc[1] * this.MP.myy + this.MP.myb;
        } else {
            double xCord = rwc[0];
            if (this.MP.view == 14 && this.MP.hasExtendedRange() && xCord <= this.MP.orx1 && xCord + 360.0 < this.MP.orx2) {
                xCord += 360.0;
            }
            pix.x[0] = xCord * this.MP.mxx + this.MP.mxb;
            pix.y[0] = rwc[1] * this.MP.myy + this.MP.myb;
        }
        pix.n = 1;
        return 1;
    }

    public int rwc2dpix(double[] buf, int off, int dim, int npts, DPix pix) {
        if (buf == null || pix == null) {
            return 0;
        }
        int j = off;
        int n = pix.setSize(npts);
        double[] pax = pix.getX();
        double[] pay = pix.getY();
        double mxx = this.MP.mxx;
        double myy = this.MP.myy;
        double mxb = this.MP.mxb;
        double myb = this.MP.myb;
        if ((pix.getFlags() & 2) != 0) {
            if (this.MP.view == 11 || this.MP.view == 14) {
                return this.rwc2dpixClip(buf, off, dim, npts, pix, false);
            }
            double dxmax = this.MP.ix21 / 2;
            double dymax = this.MP.iy21 / 2;
            for (int i = 0; i < n && i < pax.length && i < pay.length && j < buf.length - 1; ++i, j += dim) {
                pax[i] = buf[j + 0] * mxx + mxb;
                pay[i] = buf[j + 1] * myy + myb;
                if (i == 0) continue;
                double dx = pax[i] - pax[i - 1];
                double dy = pay[i] - pay[i - 1];
                if (!(dx < -dxmax || dx > dxmax || dy < -dymax) && !(dy > dymax)) continue;
                pix.setOffset(i);
                pix.setSize(i);
                return i;
            }
        } else {
            if (this.MP.view == 14 && this.MP.hasExtendedRange()) {
                return this.rwc2dpixClip(buf, off, dim, npts, pix, false);
            }
            if (dim == 2) {
                for (int i = 0; i < n && i < pax.length && i < pay.length && j < buf.length - 1; ++i) {
                    pax[i] = buf[j++] * mxx + mxb;
                    pay[i] = buf[j++] * myy + myb;
                }
            } else {
                for (int i = 0; i < n && i < pax.length && i < pay.length && j < buf.length - 1; ++i, j += dim) {
                    pax[i] = buf[j + 0] * mxx + mxb;
                    pay[i] = buf[j + 1] * myy + myb;
                }
            }
        }
        return n;
    }

    int rwc2dpixClip(double[] buf, int off, int dim, int npts, MPlot MP, DPix pix) {
        boolean mer;
        if (buf == null || pix == null) {
            return 0;
        }
        double rx = 0.0;
        double ry = 0.0;
        double mxx = MP.mxx;
        double mxb = MP.mxb;
        double myy = MP.myy;
        double myb = MP.myb;
        boolean bl = mer = MP.view != 11 && MP.view != 14;
        if (mer) {
            myy = (double)(MP.iy1 - MP.iy2) / (ViewMercader.lat2mer(MP.ry2) - ViewMercader.lat2mer(MP.ry1));
            myb = (double)MP.iy2 - ViewMercader.lat2mer(MP.ry1) * myy;
        }
        int i1 = 0;
        int i2 = 0;
        boolean drawMain = true;
        DPix pixMain = new DPix(npts, pix.getFlags());
        DPix pixAlt = new DPix(npts, pix.getFlags());
        for (int i = 0; i < npts && off < buf.length - 1; ++i, off += dim) {
            double y;
            double rxp = rx;
            double ryp = ry;
            ry = buf[off + 1];
            for (rx = buf[off + 0]; rx > 180.0; rx -= 360.0) {
            }
            while (rx < -180.0) {
                rx += 360.0;
            }
            while (ry > 90.0) {
                ry -= 180.0;
            }
            while (ry < -90.0) {
                ry += 180.0;
            }
            double x = rx * mxx + mxb;
            double d = y = mer ? ViewMercader.lat2mer(ry) * myy + myb : ry * myy + myb;
            if (rx > 90.0 && rxp < -90.0 || rx < -90.0 && rxp > 90.0) {
                int pt = rx < rxp ? 180 : -180;
                int newY = this.getExtrapolatedYPix(rx, rxp, ry, ryp, MP);
                if (!drawMain) {
                    pt = -pt;
                }
                this.checkSize(pixMain, i1 + 2);
                this.checkSize(pixAlt, i2 + 2);
                pixMain.x[i1] = (double)pt * mxx + mxb;
                pixMain.y[i1++] = newY;
                pixAlt.x[i2] = (double)(-pt) * mxx + mxb;
                pixAlt.y[i2++] = newY;
                drawMain = !drawMain;
                pix.save = true;
            }
            if (drawMain) {
                this.checkSize(pixMain, i1 + 2);
                pixMain.x[i1] = x;
                pixMain.y[i1++] = y;
                continue;
            }
            this.checkSize(pixAlt, i2 + 2);
            pixAlt.x[i2] = x;
            pixAlt.y[i2++] = y;
        }
        pix.n = i2;
        pix.x = pixMain.x;
        pix.y = pixMain.y;
        pix.sx = pixAlt.x;
        pix.sy = pixAlt.y;
        pix.off = npts;
        return i1;
    }

    int rwc2dpixClip(double[] buf, int off, int dim, int npts, DPix pix, boolean mer) {
        boolean neverClip;
        boolean bl = neverClip = (pix.flags & 0x20) != 0;
        if (buf == null || pix == null) {
            return 0;
        }
        int j = off;
        int n = pix.setSize(npts);
        double[] pax = pix.getX();
        double[] pay = pix.getY();
        double mxx = this.MP.mxx;
        double mxb = this.MP.mxb;
        double myy = this.MP.myy;
        double myb = this.MP.myb;
        double rx = this.MP.hasExtendedRange() ? (this.MP.getOuterXMax() - this.MP.getOuterXMin()) / 2.0 : 0.0;
        double ry = 0.0;
        double range = MPlot.LONGITUDE_RANGE;
        double max = MPlot.LONGITUDE_DEFAULT_MAX;
        if (this.MP.hasExtendedRange()) {
            double p = 1.0E-6;
            if (this.MP.getOuterXMax() > (double)MPlot.LONGITUDE_DEFAULT_MAX + p) {
                max = this.MP.getOuterXMax();
            }
            if (this.MP.getOuterXMin() < (double)MPlot.LONGITUDE_DEFAULT_MIN - p) {
                max = this.MP.getOuterXMin() + (double)MPlot.LONGITUDE_RANGE;
            }
        }
        double min = max - (double)MPlot.LONGITUDE_RANGE;
        double rxWrapHigh = max - (double)MPlot.LONGITUDE_RANGE / 4.0;
        double rxWrapLow = min + (double)MPlot.LONGITUDE_RANGE / 4.0;
        for (int i = 0; i < n && i < pax.length && i < pay.length && j < buf.length - 1; ++i, j += dim) {
            double rxp = rx;
            double ryp = ry;
            ry = buf[j + 1];
            for (rx = buf[j + 0]; rx > max; rx -= (double)MPlot.LONGITUDE_RANGE) {
            }
            while (rx < min) {
                rx += (double)MPlot.LONGITUDE_RANGE;
            }
            while (ry > 90.0) {
                ry -= 180.0;
            }
            while (ry < -90.0) {
                ry += 180.0;
            }
            pax[i] = rx * mxx + mxb;
            double d = pay[i] = mer ? ViewMercader.lat2mer(ry) * myy + myb : ry * myy + myb;
            if (i == 0 || !(rx > rxWrapHigh && rxp < rxWrapLow) && (!(rxp > rxWrapHigh) || !(rx < rxWrapLow)) || neverClip) continue;
            this.splitLineSegment(rx, ry, rxp, ryp, range, pax, pay, pix, i, mer, mxx, mxb, myy, myb, min, max);
            return i + 1;
        }
        return n;
    }

    int calcNumPointsToPlot(int bufLength, int bufOff, int dim, int pixSize, int paxLength, int payLength) {
        int numElemBuf = bufLength - bufOff;
        int numPerPass = Math.min(dim, 2);
        int bufN = numElemBuf >= numPerPass ? 1 + (numElemBuf - numPerPass) / dim : 0;
        int pixN = Math.min(pixSize, Math.min(paxLength, payLength));
        return Math.min(bufN, pixN);
    }

    private void splitLineSegment(double rx, double ry, double rxp, double ryp, double range, double[] pax, double[] pay, DPix pix, int i, boolean mer, double mxx, double mxb, double myy, double myb, double min, double max) {
        double ryn;
        double rxNewPax;
        double rxnNewPix;
        if (rx < rxp) {
            double dx1 = rx - rxp + range;
            double dy1 = ry - ryp;
            double dx2 = max - rxp;
            rxnNewPix = min;
            rxNewPax = max;
            ryn = dx2 / (dx1 / dy1) + ryp;
        } else {
            double dx1 = rx - rxp - range;
            double dy1 = ry - ryp;
            double dx2 = min - rxp;
            rxnNewPix = max;
            rxNewPax = min;
            ryn = dx2 / (dx1 / dy1) + ryp;
        }
        pix.sx[0] = rxnNewPix * mxx + mxb;
        pix.sx[1] = pax[i];
        pix.sy[0] = mer ? ViewMercader.lat2mer(ryn) * myy + myb : ryn * myy + myb;
        pix.sy[1] = pay[i];
        pax[i] = rxNewPax * mxx + mxb;
        pay[i] = pix.sy[0];
        pix.save = true;
        pix.off = i;
        pix.n = i;
    }

    private void checkSize(DPix pix, int size) {
        if (pix.getLengthX() <= size || pix.getLengthY() <= size) {
            double[] tmpx = new double[pix.getLengthX() * 2];
            double[] tmpy = new double[pix.getLengthY() * 2];
            System.arraycopy(pix.getX(), 0, tmpx, 0, pix.getLengthX());
            pix.setX(tmpx);
            System.arraycopy(pix.getY(), 0, tmpy, 0, pix.getLengthY());
            pix.setY(tmpy);
        }
    }

    Pix[] dpix2viewablePix(DPix pix, int npts, int off) {
        Pix[] viewable = null;
        ArrayList xPixels = new ArrayList();
        ArrayList yPixels = new ArrayList();
        if (npts < 2) {
            viewable = new Pix[]{pix.toPix()};
        }
        Point2D.Double visibleBoxMinXY = new Point2D.Double(this.MP.ix1, this.MP.iy1);
        Point2D.Double visibleBoxMaxXY = new Point2D.Double(this.MP.ix2, this.MP.iy2);
        IntersectingLine visibleSegment = null;
        Line2D.Double originalSegment = null;
        int lineSegmentGrp = 0;
        int maxIndex = Math.min(off + npts, Math.min(pix.getLengthX(), pix.getLengthY())) - 1;
        for (int i = off; i < maxIndex; ++i) {
            originalSegment = new Line2D.Double(pix.x[i], pix.y[i], pix.x[i + 1], pix.y[i + 1]);
            visibleSegment = GeometricUtil.adjustToVisibleLine(originalSegment, visibleBoxMinXY, visibleBoxMaxXY);
            if (visibleSegment == null) continue;
            xPixels.add(new ArrayList());
            yPixels.add(new ArrayList());
            ((ArrayList)xPixels.get(lineSegmentGrp)).add((int)visibleSegment.line.x1);
            ((ArrayList)xPixels.get(lineSegmentGrp)).add((int)visibleSegment.line.x2);
            ((ArrayList)yPixels.get(lineSegmentGrp)).add((int)visibleSegment.line.y1);
            ((ArrayList)yPixels.get(lineSegmentGrp)).add((int)visibleSegment.line.y2);
            ++lineSegmentGrp;
        }
        if (xPixels.size() > 0) {
            viewable = new Pix[xPixels.size()];
            for (int pixGrp = 0; pixGrp < xPixels.size(); ++pixGrp) {
                ArrayList xPixGrp = (ArrayList)xPixels.get(pixGrp);
                ArrayList yPixGrp = (ArrayList)yPixels.get(pixGrp);
                viewable[pixGrp] = new Pix(pix.max - 1, pix.flags);
                viewable[pixGrp].n = xPixGrp.size();
                for (int i = 0; i < viewable[pixGrp].n; ++i) {
                    viewable[pixGrp].x[i] = (Integer)xPixGrp.get(i);
                    viewable[pixGrp].y[i] = (Integer)yPixGrp.get(i);
                }
            }
        }
        return viewable;
    }

    int pixSpanEntireMap(Pix pix, int n, boolean north) {
        if (pix.save && pix.x[0] == pix.sx[pix.n - 1]) {
            pix.x = View.combine(pix.sx, pix.n, pix.x, n);
            pix.y = View.combine(pix.sy, pix.n, pix.y, n);
            n += pix.n;
            pix.save = false;
            n = this.completePolygon(pix, n, north);
        }
        return n;
    }

    static int[] combine(int[] a, int aNumPoints, int[] b, int bNumPoints) {
        int[] result = new int[aNumPoints + bNumPoints];
        System.arraycopy(a, 0, result, 0, aNumPoints);
        System.arraycopy(b, 0, result, aNumPoints, bNumPoints);
        return result;
    }

    int completePolygon(Pix pix, int n, boolean north) {
        int newY;
        if (pix.x[0] == pix.x[n - 1]) {
            return n;
        }
        int length = n + 3;
        if (pix.x.length < length) {
            int[] resx = new int[length];
            int[] resy = new int[length];
            System.arraycopy(pix.x, 0, resx, 0, n);
            System.arraycopy(pix.y, 0, resy, 0, n);
            pix.x = resx;
            pix.y = resy;
        }
        double yval = north ? 90.0 : -90.0;
        pix.y[n] = newY = (int)(yval * this.MP.myy + this.MP.myb);
        pix.y[n + 1] = newY;
        pix.y[n + 2] = pix.y[0];
        pix.x[n] = pix.x[n - 1];
        pix.x[n + 1] = pix.x[0];
        pix.x[n + 2] = pix.x[0];
        return n + 3;
    }

    private static Point2D.Double getIntersection(Line2D.Double line, double axisDistanceLinePt1ToBoxBoundary, double axisDistanceLinePt2ToBoxBoundary) {
        if (axisDistanceLinePt1ToBoxBoundary * axisDistanceLinePt2ToBoxBoundary >= 0.0) {
            return null;
        }
        if (axisDistanceLinePt1ToBoxBoundary == axisDistanceLinePt2ToBoxBoundary) {
            return null;
        }
        double p2MinusP1X = line.x2 - line.x1;
        double p2MinusP1Y = line.y2 - line.y1;
        double multFactor = -axisDistanceLinePt1ToBoxBoundary / (axisDistanceLinePt2ToBoxBoundary - axisDistanceLinePt1ToBoxBoundary);
        double distIntersectFromP1X = p2MinusP1X * multFactor;
        double distIntersectFromP1Y = p2MinusP1Y * multFactor;
        double intersectX = line.x1 + distIntersectFromP1X;
        double intersectY = line.y1 + distIntersectFromP1Y;
        return new Point2D.Double(intersectX, intersectY);
    }
}

