/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Graphics;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Position;
import nxm.sys.lib.Shell;
import nxm.sys.libg.Feature;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MPlot;

@InternalUseOnly(value="PROTOTYPE only - not for use")
public class ResizeBox {
    static int hRadius = 2;
    static int sRadius = hRadius + 1;
    static Color selColor = Color.WHITE;
    private static boolean debugResizing = false;

    private ResizeBox() {
    }

    static void drawSelectedBox(Feature feature) {
        int ix1 = feature.ix1Last;
        int ix2 = feature.ix2Last;
        int iy1 = feature.iy1Last;
        int iy2 = feature.iy2Last;
        int idx = ix2 - ix1;
        int idy = iy2 - iy1;
        Graphics gc = feature.MP.gc;
        gc.setColor(selColor);
        int diameter = hRadius + hRadius;
        int midx = (ix2 + ix1) / 2;
        int midy = (iy2 + iy1) / 2;
        gc.drawRect(ix1, iy1, idx, idy);
        gc.drawOval(ix1 - hRadius, iy1 - hRadius, diameter, diameter);
        gc.drawOval(ix2 - hRadius, iy1 - hRadius, diameter, diameter);
        gc.drawOval(ix2 - hRadius, iy2 - hRadius, diameter, diameter);
        gc.drawOval(ix1 - hRadius, iy2 - hRadius, diameter, diameter);
        gc.drawOval(ix1 - hRadius, midy - hRadius, diameter, diameter);
        gc.drawOval(ix2 - hRadius, midy - hRadius, diameter, diameter);
        gc.drawOval(midx - hRadius, iy1 - hRadius, diameter, diameter);
        gc.drawOval(midx - hRadius, iy2 - hRadius, diameter, diameter);
        gc.drawOval(midx - hRadius, midy - hRadius, diameter, diameter);
        gc.setColor(feature.MP.theme.cfg);
    }

    @InternalUseOnly(value="Public for testing purposes only")
    public static Handle getHandle(Feature feature, int px, int py) {
        int ix1 = feature.ix1Last;
        int ix2 = feature.ix2Last;
        int iy1 = feature.iy1Last;
        int iy2 = feature.iy2Last;
        int midx = (ix2 + ix1) / 2;
        int midy = (iy2 + iy1) / 2;
        if (px > ix1 - sRadius && px < ix1 + sRadius && py > iy1 - sRadius && py < iy1 + sRadius) {
            return Handle.NW;
        }
        if (px > midx - sRadius && px < midx + sRadius && py > iy1 - sRadius && py < iy1 + sRadius) {
            return Handle.N;
        }
        if (px > ix2 - sRadius && px < ix2 + sRadius && py > iy1 - sRadius && py < iy1 + sRadius) {
            return Handle.NE;
        }
        if (px > ix1 - sRadius && px < ix1 + sRadius && py > midy - sRadius && py < midy + sRadius) {
            return Handle.W;
        }
        if (px > ix2 - sRadius && px < ix2 + sRadius && py > midy - sRadius && py < midy + sRadius) {
            return Handle.E;
        }
        if (px > ix1 - sRadius && px < ix1 + sRadius && py > iy2 - sRadius && py < iy2 + sRadius) {
            return Handle.SW;
        }
        if (px > midx - sRadius && px < midx + sRadius && py > iy2 - sRadius && py < iy2 + sRadius) {
            return Handle.S;
        }
        if (px > ix2 - sRadius && px < ix2 + sRadius && py > iy2 - sRadius && py < iy2 + sRadius) {
            return Handle.SE;
        }
        if (px > midx - sRadius && px < midx + sRadius && py > midy - sRadius && py < midy + sRadius) {
            return Handle.MOVE;
        }
        return Handle.NONE;
    }

    @InternalUseOnly(value="Public for testing purposes only")
    public static String cursorFromHandle(Handle handle) {
        String handleName = handle.toString();
        if ("MOVE".equals(handleName)) {
            return handleName;
        }
        if ("NONE".equals(handleName)) {
            return "Default";
        }
        return handleName + "Resize";
    }

    @InternalUseOnly(value="Public for testing purposes only")
    public static Direction directionFromHandleView(Handle handle, int view) {
        boolean yxView = ResizeBox.isYXView(view);
        boolean xInverse = ResizeBox.isInverseX(view);
        boolean yInverse = ResizeBox.isInverseY(view);
        boolean bothInverse = xInverse && yInverse;
        switch (handle) {
            case NW: {
                if (yxView) {
                    if (bothInverse) {
                        return Direction.POSXNEGY;
                    }
                    if (xInverse) {
                        return Direction.POSXY;
                    }
                    if (yInverse) {
                        return Direction.NEGXY;
                    }
                    return Direction.NEGXPOSY;
                }
                if (bothInverse) {
                    return Direction.NEGXPOSY;
                }
                if (xInverse) {
                    return Direction.NEGXY;
                }
                if (yInverse) {
                    return Direction.POSXY;
                }
                return Direction.POSXNEGY;
            }
            case N: {
                if (yxView) {
                    if (yInverse) {
                        return Direction.NEGY;
                    }
                    return Direction.POSY;
                }
                if (xInverse) {
                    return Direction.NEGX;
                }
                return Direction.POSX;
            }
            case NE: {
                if (yxView) {
                    if (bothInverse) {
                        return Direction.NEGXY;
                    }
                    if (xInverse) {
                        return Direction.NEGXPOSY;
                    }
                    if (yInverse) {
                        return Direction.POSXNEGY;
                    }
                    return Direction.POSXY;
                }
                if (bothInverse) {
                    return Direction.NEGXY;
                }
                if (xInverse) {
                    return Direction.NEGXPOSY;
                }
                if (yInverse) {
                    return Direction.POSXNEGY;
                }
                return Direction.POSXY;
            }
            case W: {
                if (yxView) {
                    if (xInverse) {
                        return Direction.POSX;
                    }
                    return Direction.NEGX;
                }
                if (yInverse) {
                    return Direction.POSY;
                }
                return Direction.NEGY;
            }
            case E: {
                if (yxView) {
                    if (xInverse) {
                        return Direction.NEGX;
                    }
                    return Direction.POSX;
                }
                if (yInverse) {
                    return Direction.NEGY;
                }
                return Direction.POSY;
            }
            case SW: {
                if (yxView) {
                    if (bothInverse) {
                        return Direction.POSXY;
                    }
                    if (xInverse) {
                        return Direction.POSXNEGY;
                    }
                    if (yInverse) {
                        return Direction.NEGXPOSY;
                    }
                    return Direction.NEGXY;
                }
                if (bothInverse) {
                    return Direction.POSXY;
                }
                if (xInverse) {
                    return Direction.POSXNEGY;
                }
                if (yInverse) {
                    return Direction.NEGXPOSY;
                }
                return Direction.NEGXY;
            }
            case S: {
                if (yxView) {
                    if (yInverse) {
                        return Direction.POSY;
                    }
                    return Direction.NEGY;
                }
                if (xInverse) {
                    return Direction.POSX;
                }
                return Direction.NEGX;
            }
            case SE: {
                if (yxView) {
                    if (bothInverse) {
                        return Direction.NEGXPOSY;
                    }
                    if (xInverse) {
                        return Direction.NEGXY;
                    }
                    if (yInverse) {
                        return Direction.POSXY;
                    }
                    return Direction.POSXNEGY;
                }
                if (bothInverse) {
                    return Direction.POSXNEGY;
                }
                if (xInverse) {
                    return Direction.POSXY;
                }
                if (yInverse) {
                    return Direction.NEGXY;
                }
                return Direction.NEGXPOSY;
            }
            case MOVE: {
                return Direction.MOVE;
            }
            case NONE: {
                return Direction.NONE;
            }
        }
        return Direction.NONE;
    }

    static void updateBounds(Feature feature, Handle handle, Position curr, int view) {
        Direction direction = ResizeBox.directionFromHandleView(handle, view);
        ResizeBox.updateBounds(feature, direction, curr);
    }

    @InternalUseOnly(value="Public for testing purposes only")
    public static void updateBounds(Feature feature, Direction direction, Position curr) {
        boolean featHasT = feature.toTable().containsKey("DT");
        if (debugResizing) {
            System.out.println("ResizeBox.updateBounds debug information");
            if (featHasT) {
                System.out.println("    feature has T");
            }
            System.out.println("    direction:" + (Object)((Object)direction));
            System.out.println("    resize box corner / cursor position:" + curr);
        }
        switch (direction) {
            case NEGXY: {
                feature.setXMinMax(curr.x, feature.getXMax());
                feature.setYMinMax(curr.y, feature.getYMax());
                if (!featHasT) break;
                feature.setTMinMax(curr.t, feature.getTMax());
                break;
            }
            case NEGY: {
                feature.setYMinMax(curr.y, feature.getYMax());
                if (!featHasT) break;
                feature.setTMinMax(curr.t, feature.getTMax());
                break;
            }
            case POSXNEGY: {
                feature.setXMinMax(feature.getXMin(), curr.x);
                feature.setYMinMax(curr.y, feature.getYMax());
                if (!featHasT) break;
                feature.setTMinMax(curr.t, feature.getTMax());
                break;
            }
            case NEGX: {
                feature.setXMinMax(curr.x, feature.getXMax());
                break;
            }
            case POSX: {
                feature.setXMinMax(feature.getXMin(), curr.x);
                break;
            }
            case NEGXPOSY: {
                feature.setXMinMax(curr.x, feature.getXMax());
                feature.setYMinMax(feature.getYMin(), curr.y);
                if (!featHasT) break;
                feature.setTMinMax(feature.getTMin(), curr.t);
                break;
            }
            case POSY: {
                feature.setYMinMax(feature.getYMin(), curr.y);
                if (!featHasT) break;
                feature.setTMinMax(feature.getTMin(), curr.t);
                break;
            }
            case POSXY: {
                feature.setXMinMax(feature.getXMin(), curr.x);
                feature.setYMinMax(feature.getYMin(), curr.y);
                if (!featHasT) break;
                feature.setTMinMax(feature.getTMin(), curr.t);
                break;
            }
            case MOVE: {
                double xShift = curr.x - feature.getX();
                double yShift = curr.y - feature.getY();
                double tShift = curr.t - feature.getT();
                feature.setXMinMax(feature.getXMin() + xShift, feature.getXMax() + xShift);
                feature.setYMinMax(feature.getYMin() + yShift, feature.getYMax() + yShift);
                if (!featHasT) break;
                feature.setTMinMax(feature.getTMin() + tShift, feature.getTMax() + tShift);
                break;
            }
        }
    }

    static int processDrag(Feature elasticFeature, Handle elasticHandle) {
        MPlot MP = elasticFeature.MP;
        if (MP.isStandardXYView() || MP.isLatLonView()) {
            MBox box = MP.box;
            box.reform();
            ResizeBox.updateBounds(elasticFeature, elasticHandle, MP.getPosition(box.x + box.w, box.y + box.h), MP.view);
            return 1;
        }
        Shell.warning("Resizing of elastic features is only supported in standard XY and LAtLon views");
        return -2;
    }

    public static boolean isSupportedView(int view) {
        return view == 8 || view == 4 || view == 6 || view == 2 || view == 7 || view == 3 || view == 5 || view == 1 || view == 11 || view == 14;
    }

    static boolean isInverseX(int view) {
        return view == 8 || view == 4 || view == 6 || view == 3;
    }

    static boolean isInverseY(int view) {
        return view == 8 || view == 4 || view == 2 || view == 7;
    }

    static boolean isYXView(int view) {
        return view == 4 || view == 2 || view == 3 || view == 1 || view == 11 || view == 14;
    }

    @InternalUseOnly(value="Public for testing purposes only")
    public static enum Direction {
        NONE("NONE"),
        NEGXY("NEGXY"),
        NEGY("NEGY"),
        POSXNEGY("POSXNEGY"),
        NEGX("NEGX"),
        POSX("POSX"),
        NEGXPOSY("NEGXPOSY"),
        POSY("POSY"),
        POSXY("POSXY"),
        MOVE("MOVE");

        private final String name;

        private Direction(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    @InternalUseOnly(value="Public for testing purposes only")
    public static enum Handle {
        NONE("NONE"),
        NW("NW"),
        N("N"),
        NE("NE"),
        W("W"),
        E("E"),
        SW("SW"),
        S("S"),
        SE("SE"),
        MOVE("MOVE");

        private final String name;

        private Handle(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

