/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import nxm.sys.lib.Midas;
import nxm.sys.libg.LayerT5;
import nxm.sys.libg.Line;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.Pix;
import nxm.sys.libg.Point3D;
import nxm.sys.libg.Region;

public class RegionGroup {
    static final int LON_GRID_SIZE = 20;
    static final int LAT_GRID_SIZE = 20;
    static final int REGION_GRID_COUNT = 8;
    static final double MAX_ZOOM_PERCENT = 0.005;
    static final int MAX_ZOOM_LEVEL = 5;
    static final int THIRD_ZOOM_LEVEL = 1;
    static final int SECOND_ZOOM_LEVEL = 2;
    static final int FIRST_ZOOM_LEVEL = 4;
    static final int MAX_ZOOM_FACTOR = 1;
    static final int THIRD_ZOOM_FACTOR = 8;
    static final int SECOND_ZOOM_FACTOR = 4;
    static final int FIRST_ZOOM_FACTOR = 2;
    static final int ZOOM_PERCENT_FIRST = 3;
    static final int ZOOM_PERCENT_SECOND = 10;
    static final int ZOOM_PERCENT_THIRD = 20;
    static final int ZOOM_PERCENT_MAX = 75;
    private static final double Y_SHIFT_FACTOR = 0.1;
    private static final Color AQUABLUE = new Color(0, 255, 255, 125);
    private static final Color YELLOW = new Color(255, 255, 0, 125);
    private static final Color RED = new Color(255, 0, 0, 125);
    private static final Color PINK = new Color(255, 192, 203, 125);
    Point3D topRight;
    Point3D topLeft;
    Region[][] regions = new Region[8][8];
    double x1;
    double y1;
    double xRange = Double.valueOf(20.0) / Double.valueOf(8.0);
    double yRange = Double.valueOf(20.0) / Double.valueOf(8.0);
    double minX = Double.MAX_VALUE;
    double maxX = -1.7976931348623157E308;
    double minY = Double.MAX_VALUE;
    double maxY = -1.7976931348623157E308;
    Point3D center;
    MPlot MP;
    private LayerT5 layer;

    public RegionGroup(int indexOfGroupX, int indexOfGroupY, LayerT5 layer) {
        this.layer = layer;
        double xVal = indexOfGroupX * 20 + MPlot.LONGITUDE_DEFAULT_MIN;
        double yVal = indexOfGroupY * 20 + MPlot.LATITUDE_DEFAULT_MIN;
        this.topLeft = new Point3D(layer);
        this.topLeft.setPos(0.0, yVal + 20.0, xVal);
        this.topLeft.prep(false);
        this.topRight = new Point3D(layer);
        this.topRight.setPos(0.0, yVal + 20.0, xVal + 20.0);
        this.topRight.prep(false);
        this.center = new Point3D(layer);
        this.x1 = xVal;
        this.y1 = yVal;
        this.MP = layer.getMPlot();
    }

    public int addPoint(Point3D point) {
        int[] indexes = this.getIndexes(point);
        int xIndex = indexes[0];
        int yIndex = indexes[1];
        if (point.getPosLon() > this.maxX) {
            this.maxX = point.getPosLon();
        }
        if (point.getPosLon() < this.minX) {
            this.minX = point.getPosLon();
        }
        if (point.getPosLat() > this.maxY) {
            this.maxY = point.getPosLat();
        }
        if (point.getPosLat() < this.minY) {
            this.minY = point.getPosLat();
        }
        double centerX = (this.maxX + this.minX) / 2.0;
        double centerY = (this.maxY + this.minY) / 2.0;
        this.center.setPos(0.0, centerY, centerX);
        if (this.regions[xIndex][yIndex] == null) {
            this.regions[xIndex][yIndex] = new Region();
        }
        return this.regions[xIndex][yIndex].addPoint(point);
    }

    public int getNumPtsInRegionGroup() {
        int size = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (this.regions[i][j] == null) continue;
                size += this.regions[i][j].getNumPtsInRegion();
            }
        }
        return size;
    }

    private int[] getIndexes(Point3D point) {
        int xIndex;
        double x = point.getPosLon();
        double y = point.getPosLat();
        int yIndex = 1;
        for (xIndex = 1; xIndex <= 8; ++xIndex) {
            double maxXVal = this.x1 + (double)xIndex * this.xRange;
            if (!(x < maxXVal)) continue;
            --xIndex;
            break;
        }
        while (yIndex <= 8) {
            double maxYVal = this.y1 + (double)yIndex * this.yRange;
            if (y < maxYVal) {
                --yIndex;
                break;
            }
            ++yIndex;
        }
        yIndex = 8 - yIndex - 1;
        xIndex = Math.min(xIndex, 7);
        yIndex = Math.max(yIndex, 0);
        return new int[]{xIndex, yIndex};
    }

    public void removePoint(Point3D point) {
        int indexY;
        int[] indexes = this.getIndexes(point);
        int indexX = indexes[0];
        Region region = this.regions[indexX][indexY = indexes[1]];
        if (region == null) {
            return;
        }
        region.removePoint(point.indexInRegion);
    }

    private int[] getRegionPointCountByZoomlevel(int zoomLevel) {
        int zoomFactor = 1;
        int regionPointCount = 1;
        if (zoomLevel == 1) {
            regionPointCount = 16;
            zoomFactor = 8;
        } else if (zoomLevel == 2) {
            regionPointCount = 8;
            zoomFactor = 4;
        } else if (zoomLevel == 4) {
            regionPointCount = 4;
            zoomFactor = 2;
        }
        int[] sizes = new int[regionPointCount];
        double xRange = Double.valueOf(20.0) / (double)zoomFactor;
        double yRange = Double.valueOf(20.0) / (double)zoomFactor;
        for (int i = 0; i < this.regions.length; i += zoomLevel) {
            for (int j = 0; j < this.regions[i].length; j += zoomLevel) {
                this.MP.gc.setFont(this.layer.getNumberFontSmall());
                double x = this.topLeft.posLon + (double)(i / zoomLevel) * xRange;
                double y = this.topLeft.posLat - (double)(j / zoomLevel) * yRange;
                Point3D topLeftTemp = new Point3D(this.layer);
                topLeftTemp.setPos(0.0, y, x);
                topLeftTemp.prep(false);
                Point3D topRightTemp = new Point3D(this.layer);
                topRightTemp.setPos(0.0, y, x + xRange);
                ArrayList<Point3D> pointsToDraw = new ArrayList<Point3D>();
                int size = 0;
                for (int xIndex = i; xIndex < i + zoomLevel; ++xIndex) {
                    for (int yIndex = j; yIndex < j + zoomLevel; ++yIndex) {
                        if (this.regions[xIndex][yIndex] == null) continue;
                        Region region = this.regions[xIndex][yIndex];
                        for (int k = 0; k < region.getNumPointsInRegion(); ++k) {
                            Point3D pointToDraw = region.points[k];
                            if (pointToDraw == null) continue;
                            if (pointsToDraw.size() <= this.layer.minimumClusterSize) {
                                pointsToDraw.add(pointToDraw);
                            }
                            ++size;
                        }
                    }
                }
                sizes[i / zoomLevel] = size;
            }
        }
        return sizes;
    }

    static void drawRegionPointGroupings(int zoomLevel, Line lin, List<RegionGroup> regionGroups, int xIndex, int yIndex, MPlot MP) {
        Pix pix = new Pix(2, 0);
        if (regionGroups.size() == 0) {
            return;
        }
        Point3D topLeft = regionGroups.get((int)0).topLeft;
        Point3D topRight = regionGroups.get((int)0).topRight;
        LayerT5 layer = regionGroups.get((int)0).layer;
        MP.viewer.rwc2pix(new double[]{topLeft.getPosLon(), topLeft.getPosLat(), topRight.getPosLon(), topRight.getPosLat()}, 0, 2, 2, pix);
        if (pix.x[0] < MP.ix1 && pix.x[1] < MP.ix1 || pix.x[0] > MP.ix2 && pix.x[1] > MP.ix2) {
            return;
        }
        int diameter = Math.abs(pix.x[0] - pix.x[1]);
        int regionPointCount = 0;
        for (RegionGroup cg : regionGroups) {
            regionPointCount += cg.getNumPtsInRegionGroup();
        }
        topLeft.prep(false);
        topRight.prep(false);
        if (regionPointCount <= layer.minimumClusterSize) {
            RegionGroup.drawPointsNonGrouped(lin, regionGroups);
            return;
        }
        if (zoomLevel == 0) {
            RegionGroup.drawCluster(diameter, regionPointCount, topLeft._ixPos, topLeft._iyPos, MP, layer);
        } else {
            RegionGroup.drawSemiClusters(lin, zoomLevel, diameter, regionGroups, MP, layer, topLeft);
        }
    }

    static void drawCluster(int diameter, int size, int ixPos, int iyPos, MPlot MP, LayerT5 layer) {
        Color currentColor = MP.gc.getColor();
        MP.gc.setColor(RegionGroup.getRegionCircleColor(size));
        int numShift = RegionGroup.setFontAndGetNumShift(diameter, size, MP, layer);
        int yShift = (int)((double)diameter * 0.1);
        MP.gc.fillOval(ixPos, iyPos, diameter, diameter);
        MP.gc.setColor(Color.BLACK);
        MP.gc.drawString(size + "", ixPos + numShift, iyPos + diameter / 2 + yShift);
        MP.gc.setColor(currentColor);
    }

    static void drawPointsNonGrouped(Line lin, List<RegionGroup> regionGroups) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                for (RegionGroup cg : regionGroups) {
                    if (cg.regions[i][j] == null) continue;
                    cg.regions[i][j].drawAllPoints(lin);
                }
            }
        }
    }

    private static void drawSemiClusters(Line lin, int zoomLevel, int diameter, List<RegionGroup> regionGroups, MPlot MP, LayerT5 layer, Point3D topLeft) {
        int zoomFactor = 1;
        if (zoomLevel == 1) {
            zoomFactor = 8;
        } else if (zoomLevel == 2) {
            zoomFactor = 4;
        } else if (zoomLevel == 4) {
            zoomFactor = 2;
        }
        diameter /= zoomFactor;
        double gridRange = Double.valueOf(20.0) / (double)zoomFactor;
        for (int i = 0; i < 8; i += zoomLevel) {
            for (int j = 0; j < 8; j += zoomLevel) {
                RegionGroup.drawSemiClusters(lin, zoomLevel, i, j, diameter, gridRange, MP, layer, topLeft, regionGroups);
            }
        }
    }

    static void drawSemiClusters(Line lin, int regionDimension, int xIndexInRegion, int yIndexInRegion, int diameter, double gridRange, MPlot MP, LayerT5 layer, Point3D topLeft, List<RegionGroup> regionGroups) {
        ArrayList<Region> regionsInSemiRegionGrouping = new ArrayList<Region>();
        double x = topLeft.posLon + (double)(xIndexInRegion / regionDimension) * gridRange;
        double y = topLeft.posLat - (double)(yIndexInRegion / regionDimension) * gridRange;
        Point3D topLeftTemp = new Point3D(layer);
        topLeftTemp.setPos(0.0, y, x);
        topLeftTemp.prep(false);
        Point3D topRightTemp = new Point3D(layer);
        topRightTemp.setPos(0.0, y, x + gridRange);
        int size = RegionGroup.getSizeOfSemiRegionGrouping(regionDimension, xIndexInRegion, yIndexInRegion, regionsInSemiRegionGrouping, regionGroups);
        if (size == 0) {
            return;
        }
        if (size <= layer.minimumClusterSize) {
            RegionGroup.drawAllPointsInRegions(regionsInSemiRegionGrouping, lin);
            return;
        }
        RegionGroup.drawCluster(diameter, size, topLeftTemp._ixPos, topLeftTemp._iyPos, MP, layer);
    }

    static int getSizeOfSemiRegionGrouping(int regionDimension, int xIndexInRegion, int yIndexInRegion, List<Region> regionsInSemiRegionGrouping, List<RegionGroup> regionGroups) {
        int size = 0;
        int endXIndex = xIndexInRegion + regionDimension;
        int endYIndex = yIndexInRegion + regionDimension;
        for (int xIndexInSemiRegion = xIndexInRegion; xIndexInSemiRegion < endXIndex; ++xIndexInSemiRegion) {
            for (int yIndexInSemiRegion = yIndexInRegion; yIndexInSemiRegion < endYIndex; ++yIndexInSemiRegion) {
                for (RegionGroup regionGroup : regionGroups) {
                    Region region = regionGroup.regions[xIndexInSemiRegion][yIndexInSemiRegion];
                    if (region == null) continue;
                    regionsInSemiRegionGrouping.add(region);
                    size += region.getNumPtsInRegion();
                }
            }
        }
        return size;
    }

    static void drawAllPointsInRegions(List<Region> regionsInSemiRegion, Line lin) {
        for (Region region : regionsInSemiRegion) {
            region.drawAllPoints(lin);
        }
    }

    private static Color getRegionCircleColor(int size) {
        if (size < 10) {
            return AQUABLUE;
        }
        if (size < 100) {
            return YELLOW;
        }
        if (size < 1000) {
            return RED;
        }
        if (size < 10000) {
            return PINK;
        }
        return new Color(127, 0, 255);
    }

    int countPointsInRange(double x1, double x2, double y1, double y2) {
        int pointCount = 0;
        for (int i = 0; i < this.regions.length; ++i) {
            for (int j = 0; j < this.regions[i].length; ++j) {
                Region region = this.regions[i][j];
                if (region == null) continue;
                pointCount += region.countPointsInRange(x1, x2, y1, y2);
            }
        }
        return pointCount;
    }

    static int getXIndex(double val) {
        int index = (int)((val += 180.0) / 20.0);
        index = Math.min(Math.max(index, 0), MPlot.LONGITUDE_RANGE / 20 - 1);
        return index;
    }

    static int getYIndex(double val) {
        int index = (int)((val += 90.0) / 20.0);
        index = Math.min(Math.max(index, 0), MPlot.LATITUDE_RANGE / 20 - 1);
        return index;
    }

    static int setFontAndGetNumShift(int diameter, int size, MPlot MP, LayerT5 layer) {
        int numShift = (int)((double)diameter * 0.45);
        if (size < 100) {
            MP.gc.setFont(layer.getNumberFontSmall());
        } else if (size < 1000) {
            MP.gc.setFont(layer.getNumberFontMedium());
            numShift = (int)((double)diameter * 0.3);
        } else {
            MP.gc.setFont(layer.getNumberFontLarge());
            numShift = (int)((double)diameter * 0.2);
        }
        return numShift;
    }

    static int getZoomLevel(double zoom) {
        zoom *= 100.0;
        int zoomLevel = 0;
        if (zoom < 3.0) {
            zoomLevel = 5;
        } else if (zoom < 10.0) {
            zoomLevel = 1;
        } else if (zoom < 20.0) {
            zoomLevel = 2;
        } else if (zoom < 75.0) {
            zoomLevel = 4;
        }
        return zoomLevel;
    }

    static void drawGrouping(Line lin, int zoomLevel, List<LayerT5> layers, MPlot MP) {
        if (MP == null) {
            return;
        }
        if (zoomLevel >= 5) {
            Midas.log("Warning, drawing region grouping when zoomed in to far, running full draw on all LayerT5s", 1);
            for (LayerT5 layer : layers) {
                layer.draw(0);
            }
            return;
        }
        Color currentColor = MP.gc.getColor();
        Font currentFont = MP.gc.getFont();
        int numX = MPlot.LONGITUDE_RANGE / 20;
        int xMinIndex = Math.max(RegionGroup.getXIndex(MP.rx1), 0) % numX;
        int yMinIndex = Math.max(RegionGroup.getYIndex(MP.ry1), 0);
        int yMaxIndex = Math.min(RegionGroup.getYIndex(MP.ry2), MPlot.LATITUDE_RANGE / 20 - 1);
        int i = xMinIndex;
        for (int k = 0; k < numX; ++k) {
            RegionGroup.drawXRegionPointGroupings(lin, zoomLevel, layers, MP, i, yMinIndex, yMaxIndex, currentColor, currentFont);
            i = (i + 1) % numX;
        }
    }

    private static void drawXRegionPointGroupings(Line lin, int zoomLevel, List<LayerT5> layers, MPlot MP, int i, int yMinIndex, int yMaxIndex, Color currentColor, Font currentFont) {
        for (int j = yMinIndex; j <= yMaxIndex; ++j) {
            ArrayList<RegionGroup> regionGroups = new ArrayList<RegionGroup>();
            for (LayerT5 t5 : layers) {
                RegionGroup regionGroup = t5.regionGroups[i][j];
                if (regionGroup == null) continue;
                regionGroups.add(regionGroup);
            }
            RegionGroup.drawRegionPointGroupings(zoomLevel, lin, regionGroups, i, j, MP);
            MP.gc.setColor(currentColor);
            MP.gc.setFont(currentFont);
        }
    }
}

