/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.util.Stack;
import nxm.sys.libg.Line;
import nxm.sys.libg.Point3D;

public class Region {
    Point3D[] points = new Point3D[50];
    private Stack<Integer> pointsRemoved = new Stack();
    private int numPointsInRegion = 0;
    double minX = Double.MAX_VALUE;
    double maxX = -1.7976931348623157E308;
    double minY = Double.MAX_VALUE;
    double maxY = -1.7976931348623157E308;

    public int addPoint(Point3D point) {
        if (point.getPosLon() > this.maxX) {
            this.maxX = point.getPosLon();
        }
        if (point.getPosLon() > this.minX) {
            this.minX = point.getPosLon();
        }
        if (point.getPosLat() > this.maxY) {
            this.maxY = point.getPosLat();
        }
        if (point.getPosLat() > this.minY) {
            this.minY = point.getPosLat();
        }
        int index = this.numPointsInRegion;
        boolean grabbedIndexFromPointsRemoved = false;
        if (this.points.length <= this.numPointsInRegion) {
            if (this.pointsRemoved.size() > 0) {
                index = this.pointsRemoved.pop();
                grabbedIndexFromPointsRemoved = true;
            } else {
                Point3D[] tmp = new Point3D[2 * this.points.length];
                System.arraycopy(this.points, 0, tmp, 0, this.points.length);
                this.points = tmp;
            }
        }
        this.points[index] = point;
        if (!grabbedIndexFromPointsRemoved) {
            ++this.numPointsInRegion;
        }
        return index;
    }

    public void removePoint(int index) {
        if (index >= this.points.length) {
            return;
        }
        if (this.points[index] == null) {
            return;
        }
        this.points[index] = null;
        this.pointsRemoved.add(index);
    }

    public int getNumPtsInRegion() {
        return this.getNumPointsInRegion();
    }

    int countPointsInRange(double x1, double x2, double y1, double y2) {
        int pointCount = 0;
        for (int i = 0; i < this.numPointsInRegion; ++i) {
            Point3D point = this.points[i];
            if (point == null || !(x1 <= point.getPosLon()) || !(x2 >= point.getPosLon()) || !(y1 <= point.getPosLat()) || !(y2 >= point.getPosLat())) continue;
            ++pointCount;
        }
        return pointCount;
    }

    public int getNumPointsInRegion() {
        return this.numPointsInRegion - this.pointsRemoved.size();
    }

    void drawAllPoints(Line lin) {
        for (int k = 0; k < this.numPointsInRegion; ++k) {
            if (this.points[k] == null) continue;
            this.points[k].layer.drawPoint(lin, this.points[k], null, 255);
        }
    }
}

