/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.libg.MPlot;

@InternalUseOnly
public class PopUpHTML {
    String label;
    private JFrame frame;
    private static Dimension DEFAULT_MIN_SIZE = new Dimension(250, 200);
    private static Dimension DEFAULT_MAX_SIZE = new Dimension(600, 600);

    public PopUpHTML(Table objInfo, MPlot MP) {
        this(objInfo, MP, MP.MW.theme.cwfg, DEFAULT_MIN_SIZE, DEFAULT_MAX_SIZE);
    }

    public PopUpHTML(Table objInfo, MPlot MP, Color valueColor, Dimension minSize, Dimension maxSize) {
        Object name = objInfo.get("NAME");
        this.label = name == null ? "" : String.valueOf(objInfo.get("NAME"));
        this.frame = new JFrame(this.label);
        Point mousePoint = MP.panel.getLocationOnScreen();
        int xPos = mousePoint.x;
        int yPos = mousePoint.y;
        this.frame.setDefaultCloseOperation(1);
        PopupPanel myPopup = new PopupPanel(objInfo, valueColor);
        int w = Math.min(maxSize.width, Math.max(minSize.width, myPopup.getPreferredSize().width));
        int h = Math.min(maxSize.height, Math.max(minSize.height, myPopup.getPreferredSize().height));
        this.frame.setSize(w, h);
        this.frame.setLocation(xPos, yPos);
        this.frame.setContentPane(myPopup);
        this.frame.setVisible(true);
    }

    public void close() {
        this.frame.dispatchEvent(new WindowEvent(this.frame, 201));
        if (Shell.needRemoveNotifyToAvoidJVMHang()) {
            this.frame.removeNotify();
        }
    }

    private class PopupPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JScrollPane scrollPane;

        public PopupPanel(Table objInfo, Color valueColor) {
            this.setLayout(new GridLayout(1, 1));
            String labelText = this.setupText(objInfo, valueColor);
            this.display(labelText);
        }

        private String setupText(Table objInfo, Color fontColor) {
            String fontColorStr = Integer.toHexString(fontColor.getRGB()).substring(2);
            String displayText = "<html>";
            displayText = displayText + Table.toHTMLTable(objInfo, fontColorStr);
            displayText = displayText + "</html>";
            return displayText;
        }

        private void display(String labelText) {
            JLabel textDisplay = new JLabel(labelText, 0);
            textDisplay.setHorizontalTextPosition(0);
            textDisplay.setVerticalTextPosition(3);
            this.scrollPane = new JScrollPane(textDisplay);
            this.add(this.scrollPane);
            this.setVisible(true);
        }
    }
}

