/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import javax.swing.JPanel;
import nxm.sys.libg.GraphicsUtil;
import nxm.sys.libg.MWindow;
import nxm.sys.libg.Theme;

class MText
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener,
FocusListener {
    public static final String flagsList = "Multiple,Fifo,Tree,Columns,NoSelect,NoHilite,BackLite,Input,Text,Wrap,Color,Banner,AddPlus";
    public static final int MULT = 1;
    public static final int FIFO = 2;
    public static final int TREE = 4;
    public static final int COLS = 8;
    public static final int NOSEL = 16;
    public static final int NOHIL = 32;
    public static final int BACKL = 64;
    public static final int INPUT = 128;
    public static final int TEXT = 256;
    public static final int WRAP = 512;
    public static final int COLOR = 1024;
    public static final int BANNER = 2048;
    public static final int ADDPLUS = 4096;
    public static final int LOGGER = 8192;
    int flags;
    Font font;
    Theme theme;
    int rows;
    int screenRows;
    int cols;
    String[] line;
    int items;
    int maxlen = 0;
    int tw = 10;
    int th = 20;
    int ta = 10;
    int bh = 0;
    int selecti1 = -1;
    int selecti2 = -1;
    int selectc1 = -1;
    int selectc2 = -1;
    int selecti1_;
    int selecti2_;
    int selectc1_;
    int selectc2_;
    int cw;
    int inrow;
    int nr;
    int si = 0;
    int sr = 0;
    int mr = 1;
    int sv = 5;
    int scrollBarWidth = this.sv * 3;
    boolean hasScroll;
    boolean dragScroll;
    boolean dragSelect;
    ActionListener actionListener;
    boolean refreshI;
    boolean refreshO;
    int[] row2line;
    String banner;
    String prompt;
    String input;
    int cursor = -1;
    int posi;
    int posc;
    int wraplen;
    MWindow MW;

    public MText(int lines, int rows, int cols, int fontsize, Theme theme, int flags) {
        this.setFlags(flags);
        this.setFontSize(fontsize);
        this.setTheme(theme);
        this.setSize(cols * this.tw, rows * this.th);
        this.setLines(lines);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public void addActionListener(ActionListener obj) {
        this.actionListener = obj;
    }

    private void refreshI() {
        this.refreshI = true;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void refreshO() {
        this.refreshO = true;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void setMWindow(MWindow mw) {
        this.MW = mw;
        this.theme = this.MW.theme;
    }

    public void setFontSize(int size) {
        this.font = new Font("Monospaced", 0, size);
        FontMetrics fm = this.getFontMetrics(this.font);
        this.tw = fm.stringWidth("0");
        this.th = fm.getHeight();
        this.ta = fm.getAscent();
    }

    public void setLines(int lines) {
        String[] oline = this.line;
        this.line = new String[lines + 1];
        if (oline != null) {
            for (int i = 0; i <= this.items; ++i) {
                this.line[i] = oline[i];
            }
        }
        this.items = 0;
        this.maxlen = 0;
    }

    public void setPrompt(String text) {
        this.prompt = text;
        this.refreshI();
    }

    public void setInput(String text) {
        this.input = text;
        this.cursor = text.length();
        this.refreshI();
    }

    public String getInput() {
        return this.input;
    }

    public void setBanner(String text) {
        this.banner = text;
        this.refreshO();
    }

    public String getBanner() {
        return this.banner;
    }

    public void addText(String text) {
        int lf = text.indexOf(10);
        if (this.items == 0) {
            this.line[++this.items] = "";
        }
        while (lf >= 0) {
            int n = this.items;
            this.line[n] = this.line[n] + text.substring(0, lf);
            this.add("");
            text = text.substring(lf + 1);
            lf = text.indexOf(10);
        }
        int n = this.items;
        this.line[n] = this.line[n] + text;
        this.refreshO();
    }

    public void add(String text) {
        boolean full;
        boolean fifo = (this.flags & 2) != 0;
        boolean bl = full = this.items + 1 >= this.line.length;
        if (full && fifo) {
            for (int i = 0; i < this.items; ++i) {
                this.line[i] = this.line[i + 1];
            }
            this.setLine(this.items, text);
            return;
        }
        if (full) {
            this.setLines(this.line.length * 2);
        }
        this.setLine(++this.items, text);
    }

    private int getNumItemsWithWrap(int startIndex) {
        int numRowsWithWrap = 0;
        for (int i = startIndex; i < this.items; ++i) {
            numRowsWithWrap += this.getNbrWraps(this.line[i]) - 1;
        }
        return numRowsWithWrap;
    }

    public int getNbrWraps(String text) {
        if (text == null || text.length() == 0) {
            return 1;
        }
        return (int)Math.ceil((float)text.length() / (float)this.getNumCharsWidth());
    }

    private int getNumCharsWidth() {
        int colWidth = (this.getWidth() - (this.isScroll() ? this.scrollBarWidth : 0)) / this.getNumSplitScreenColumns();
        return Math.max(2, colWidth / this.tw - 1);
    }

    private int getNumSplitScreenColumns() {
        int numberOfRows = Math.max(1, this.rows);
        int numSplitScreen = Math.max(1, Math.min((this.items - 1) / numberOfRows + 1, this.cols / (this.maxlen + 2)));
        if ((this.flags & 8) == 0) {
            numSplitScreen = 1;
        }
        return numSplitScreen;
    }

    private int getPromptRows() {
        if ((this.flags & 0x2000) != 0) {
            return 0;
        }
        return this.getNbrWraps(this.line[0]);
    }

    public String getLine(int i) {
        if (i < 0 || i > this.items) {
            return null;
        }
        return this.line[i];
    }

    public void replace(String text) {
        this.setLine(this.items, text);
    }

    public void setLine(int i, String text) {
        if (i < 0 || i > this.items) {
            return;
        }
        this.line[i] = text;
        this.maxlen = Math.max(this.maxlen, text.length());
        this.resetScreenIndex();
        this.refreshO();
    }

    @Override
    public void removeAll() {
        for (int i = 1; i <= this.items; ++i) {
            this.line[i] = null;
        }
        this.maxlen = 0;
        this.sr = 0;
        this.si = 0;
        this.items = 0;
        this.selectc2 = -1;
        this.selectc1 = -1;
        this.selecti2 = -1;
        this.selecti1 = -1;
        this.refreshO();
    }

    public void setFlags(int flags) {
        this.flags = flags;
        this.refreshO();
    }

    public int getFlags() {
        return this.flags;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
        this.repaint();
    }

    public void select(int item) {
        this.select(item, -1);
    }

    public void select(int item, int ich) {
        if ((this.flags & 0x10) != 0) {
            return;
        }
        if (item < 0 || item > this.items) {
            return;
        }
        String text = this.line[item];
        int len = text.length();
        if (item == this.selecti1 && (ich < 0 || ich >= len || ich >= this.selectc1 && ich < this.selectc2)) {
            if (this.selectc1 == 0 && this.selectc2 == len) {
                this.selecti2 = -1;
                this.selecti1 = -1;
            } else {
                this.selectc1 = 0;
                this.selectc2 = len;
            }
        } else {
            this.selecti1 = this.selecti2 = item;
            this.selectc1 = 0;
            this.selectc2 = len;
            if ((this.flags & 0x100) != 0 && ich >= 0 && ich < len && text.charAt(ich) > ' ') {
                this.selectc1 = ich;
                while (this.selectc1 > 0 && text.charAt(this.selectc1 - 1) > ' ') {
                    --this.selectc1;
                }
                this.selectc2 = ich;
                while (this.selectc2 < len && text.charAt(this.selectc2) > ' ') {
                    ++this.selectc2;
                }
            }
        }
        if (this.actionListener != null) {
            ActionEvent e = new ActionEvent(this, 0, "SELECT", this.selecti1);
            this.actionListener.actionPerformed(e);
        }
        this.copy(1);
        this.refreshO();
    }

    public void copy() {
        this.copy(0);
    }

    private void copy(int mode) {
        if ((this.flags & 0x100) != 0) {
            if (mode == 1) {
                GraphicsUtil.toSystemSelection(this.getSelectedItem());
            } else {
                GraphicsUtil.toSystemClipboard(this.getSelectedItem());
            }
        }
    }

    public void deselect(int item) {
        this.selecti2 = -1;
        this.selecti1 = -1;
        this.refreshO();
    }

    public String getSelectedItem() {
        String s = null;
        if (this.selecti1 >= 0) {
            if (this.selecti1 == this.selecti2) {
                s = this.line[this.selecti1].substring(this.selectc1, this.selectc2);
            } else {
                for (int i = this.selecti1; i <= this.selecti2; ++i) {
                    s = i == this.selecti1 ? this.line[i].substring(this.selectc1) + "\n" : (i == this.selecti2 ? s + this.line[i].substring(0, this.selectc2) : s + this.line[i] + "\n");
                }
            }
        }
        return s;
    }

    public String[] getSelectedItems() {
        return null;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (g != null && Theme.getOption(32)) {
            super.paintComponent(g);
        }
        this.bh = (this.flags & 0x800) != 0 ? this.th + 6 : 0;
        boolean isInput = (this.flags & 0x80) != 0;
        boolean inputOnly = isInput && this.refreshI && !this.refreshO;
        this.refreshI = false;
        this.refreshO = false;
        int w = this.getWidth();
        this.cols = Math.max(0, (w - this.scrollBarWidth) / this.tw);
        this.calcAvailableScreenRows();
        this.nr = Math.max(1, this.rows);
        int numSplitScreensCols = this.getNumSplitScreenColumns();
        this.mr = Math.max(0, (this.items - 1) / numSplitScreensCols) + 1;
        this.setHasScroll();
        if (!this.isScroll()) {
            this.sr = 0;
            this.si = 0;
        }
        if (this.si > 0) {
            this.sr = this.si / numSplitScreensCols;
            this.si = this.sr * numSplitScreensCols;
        }
        this.cw = (w - (this.isScroll() ? this.scrollBarWidth : 0)) / numSplitScreensCols;
        int alen = this.getNumCharsWidth();
        this.wraplen = alen - 2;
        if (g == null) {
            return;
        }
        g.setFont(this.font);
        if (inputOnly) {
            this.paintInput(g);
            return;
        }
        g.setColor(this.theme.cwbg);
        g.drawLine(0, 1, w - 1, 1);
        g.drawLine(0, 2, w - 1, 2);
        if (this.isScroll()) {
            this.paintScroll(g);
        }
        if (this.bh > 0) {
            this.paintBanner(g);
        }
        if (this.row2line == null || this.row2line.length != this.nr) {
            this.row2line = new int[this.nr];
        }
        int ir = 0;
        int wrap = 0;
        int ic = 0;
        for (int lineIndex = this.si + 1; lineIndex <= this.items; ++lineIndex) {
            int x = ic * this.cw;
            int y = ir * this.th + this.th + this.bh;
            this.paintLine(g, lineIndex, x, y, alen, wrap);
            if (ic == 0) {
                this.row2line[ir] = lineIndex;
            }
            if (++ic >= numSplitScreensCols) {
                ic = 0;
                ++ir;
            }
            if (ir == this.nr) break;
            if ((this.flags & 0x200) != 0 && this.line[lineIndex] != null && wrap + alen < this.line[lineIndex].length()) {
                wrap += this.wraplen;
                --lineIndex;
                continue;
            }
            wrap = 0;
        }
        int y = ir * this.th + this.th + this.bh - this.ta;
        g.setColor(this.theme.cwbg);
        g.fillRect(0, y, w - 1 - (this.isScroll() ? this.scrollBarWidth : 0), this.getHeight() - y);
        this.setInputRowIndex(ir);
        if (isInput) {
            this.paintInput(g);
        }
        g.setColor(this.theme.cwms);
        g.drawLine(1, 0, w - 3, 0);
        g.drawLine(1, this.getHeight() - 2, w - 3, this.getHeight() - 2);
        for (int i = 1; i < numSplitScreensCols; ++i) {
            g.drawLine(i * this.cw, this.bh + this.tw, i * this.cw, this.getHeight() - this.tw - 1);
        }
        while (ir < this.row2line.length) {
            this.row2line[ir] = -1;
            ++ir;
        }
    }

    private void setInputRowIndex(int index) {
        this.inrow = this.isScroll() ? ((this.flags & 0x2000) != 0 ? this.screenRows : this.screenRows - this.getPromptRows() + 1) : this.items + this.getNumItemsWithWrap(1) + 1;
    }

    private void calcAvailableScreenRows() {
        this.rows = Math.max(0, (this.getHeight() - this.bh - this.th - this.ta) / this.th);
        this.screenRows = this.rows + 1;
    }

    private void paintLine(Graphics g, int i, int x, int y, int alen, int off) {
        int tl;
        String text = this.line[i];
        g.setColor(this.theme.cwbg);
        g.fillRect(x, y - this.ta, this.cw - 1, this.th);
        if (text == null) {
            return;
        }
        x += this.tw;
        Color c = this.theme.cwfg;
        if ((this.flags & 0x400) != 0) {
            if (text.startsWith("INFO:")) {
                c = Color.green;
            } else if (text.startsWith("WARN:")) {
                c = Color.yellow;
            } else if (text.startsWith("ERROR:")) {
                c = Color.red;
            }
        }
        if (off > 0) {
            text = text.substring(off);
        }
        if ((tl = text.length()) > alen) {
            tl = alen - 2;
            text = text.substring(0, tl);
            if ((this.flags & 0x1000) != 0) {
                text = text + " +";
            }
        }
        if (i >= this.selecti1 && i <= this.selecti2) {
            int c1 = Math.max(0, Math.min(tl, i == this.selecti1 ? this.selectc1 - off : 0));
            int c2 = Math.max(0, Math.min(tl, i == this.selecti2 ? this.selectc2 - off : tl));
            if ((this.flags & 0x40) != 0) {
                g.setColor(this.theme.cwfh);
                g.fillRect(x + c1 * this.tw, y - this.ta, (c2 - c1) * this.tw, this.th);
                g.setColor(c);
                g.drawString(text, x, y);
            } else {
                g.setColor(c);
                g.drawString(text, x, y);
                g.setColor(this.theme.cwfh);
                g.drawString(text.substring(c1, c2), x + c1 * this.tw, y);
            }
        } else {
            if (i == 0) {
                int pl = Math.min(Math.min(alen, this.prompt.length()), text.length());
                g.setColor(this.theme.cwfh);
                g.drawString(text.substring(0, pl), x, y);
                text = text.substring(pl);
                x += this.tw * pl;
            }
            g.setColor(c);
            g.drawString(text, x, y);
        }
    }

    private void paintBanner(Graphics g) {
        int x = this.tw;
        int y = this.th;
        int w = this.getWidth() - (this.isScroll() ? this.scrollBarWidth - 2 : 2);
        int h = this.bh;
        if (this.banner == null) {
            this.banner = "Null Banner";
        }
        g.setColor(this.theme.cwms);
        g.fillRect(2, 0, w - 2, h);
        g.setColor(this.theme.cwfh);
        g.drawString(this.banner, x, y);
    }

    private void paintInput(Graphics g) {
        this.line[0] = this.prompt;
        if (this.input != null) {
            this.line[0] = this.line[0] + this.input;
        }
        if (this.line[0] == null) {
            return;
        }
        int lp = this.prompt.length();
        int x = 0;
        int y = this.inrow * this.th + this.bh;
        int w = this.getWidth() - x - this.tw - (this.isScroll() ? this.scrollBarWidth : 4);
        int alen = (w - 2) / this.tw - 1;
        this.paintLine(g, 0, x, y, alen, 0);
        if (!this.hasFocus()) {
            return;
        }
        g.setColor(this.theme.cwfh);
        if ((x += (this.cursor + lp + 1) * this.tw) < w) {
            g.drawLine(x, y - 2 * this.th / 3, x, y);
        }
        g.setColor(this.theme.cwfg);
    }

    private void paintScroll(Graphics g) {
        int x = this.getWidth() - this.scrollBarWidth / 2 - 2;
        int y = 0;
        int w = this.scrollBarWidth;
        int h = this.getHeight() - 2;
        double f = (double)this.sr / (double)(this.mr - this.nr);
        int flags = 6 | (this.dragScroll ? 1 : 0);
        MWindow.drawVSlider(x, y, w, h, f, flags, g, this.theme);
    }

    public void setScroll(int index) {
        this.paint(null);
        if (index < 0) {
            index = Math.max(0, this.items - this.rows);
        } else if (index >= this.items) {
            index = this.items - 1;
        }
        this.si = this.sr = index;
        this.refreshO();
    }

    private boolean updateScroll(int y) {
        this.dragScroll = true;
        int h = this.getHeight() - this.scrollBarWidth - 6;
        if (h < this.th) {
            return false;
        }
        int r = (y - this.scrollBarWidth / 2 - 3) * this.mr / h;
        int i = r * this.getNumSplitScreenColumns();
        if (i < 0 || i >= this.items) {
            return false;
        }
        this.si = i;
        this.sr = r;
        return true;
    }

    private void setHasScroll() {
        this.hasScroll = this.items + this.getNumItemsWithWrap(1) > this.getNumSplitScreenColumns() * this.nr;
    }

    public boolean isScroll() {
        return this.hasScroll;
    }

    private void resetScreenIndex() {
        this.si = this.sr = this.calcBeginLineIndex(true) - 1;
    }

    private int calcBeginLineIndex(boolean includeWraps) {
        int numDispRowsForData = this.screenRows - this.getPromptRows();
        int beginLineIdx = Math.max(0, this.items - numDispRowsForData) + 1;
        if (includeWraps) {
            int wrapLines = 0;
            int count = this.items + 1;
            for (int idx = this.items; idx >= beginLineIdx && (wrapLines += this.getNbrWraps(this.line[idx])) <= numDispRowsForData; --idx) {
                --count;
            }
            beginLineIdx = count;
        }
        return Math.max(1, beginLineIdx);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if ((this.flags & 0x80) == 0) {
            return;
        }
        int keycode = e.getKeyCode();
        char keychar = e.getKeyChar();
        boolean cc = e.isControlDown();
        String action = null;
        int modifier = 0;
        if (keycode == 10) {
            action = "ENTER";
            this.resetScreenIndex();
        } else if (keycode == 8 && this.cursor > 0) {
            this.input = this.input.substring(0, this.cursor - 1) + this.input.substring(this.cursor);
            --this.cursor;
            this.refreshI();
        } else if (keycode == 127 && this.selecti1 == 0) {
            int i1 = Math.max(0, this.selectc1 - this.prompt.length());
            int i2 = Math.max(0, this.selectc2 - this.prompt.length());
            this.input = this.input.substring(0, i1) + this.input.substring(i2);
            this.selecti2 = -1;
            this.selecti1 = -1;
            this.cursor = i1;
            this.refreshI();
        } else if (keycode == 127 && this.cursor < this.input.length()) {
            this.input = this.input.substring(0, this.cursor) + this.input.substring(this.cursor + 1);
            this.refreshI();
        } else if (keycode == 39 || cc && keycode == 70) {
            this.cursor = Math.min(this.input.length(), this.cursor + 1);
            this.refreshI();
        } else if (keycode == 37) {
            this.cursor = Math.max(0, this.cursor - 1);
            this.refreshI();
        } else if (keycode == 38) {
            modifier = e.isShiftDown() ? -2 : -1;
            action = "POPCODE";
        } else if (keycode == 40) {
            modifier = e.isShiftDown() ? 2 : 1;
            action = "POPCODE";
        } else if (keycode == 35 || cc && keycode == 69) {
            this.cursor = this.input.length();
            this.refreshI();
        } else if (keycode == 36 || cc && (keycode == 65 || keycode == 72)) {
            this.cursor = 0;
            this.refreshI();
        } else if (cc && keycode == 85) {
            this.setInput("");
        } else if (cc && keycode == 68) {
            action = "INTERRUPT";
        } else if (cc && keycode == 80) {
            if (this.MW == null) {
                action = "POP";
            }
        } else if (cc && keycode == 67) {
            String selectedText = this.getSelectedItem();
            if (selectedText == null || selectedText.length() <= 0) {
                this.addText("INFO: Use Ctrl-D=Interrupt, Ctrl-C=CopySelectedText\n");
            } else {
                this.copy();
            }
        } else if (cc && keycode == 86) {
            this.paste();
        } else if (keychar >= ' ' && keychar <= '~' && !cc) {
            this.input = this.input.substring(0, this.cursor) + keychar + this.input.substring(this.cursor);
            ++this.cursor;
            if (this.cursor == 1) {
                action = "KEYPRESS";
            }
            this.refreshI();
        }
        if (this.actionListener != null && action != null) {
            ActionEvent ae = new ActionEvent(this, 0, action, modifier);
            this.actionListener.actionPerformed(ae);
        }
    }

    public void addInput(String text) {
        this.input = this.input.substring(0, this.cursor) + text + this.input.substring(this.cursor);
        this.cursor += text.length();
        this.refreshI();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.refreshI();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.refreshI();
    }

    private boolean hit(int x, int y) {
        int i;
        int ic = Math.max(0, Math.min(this.getNumSplitScreenColumns() - 1, (x - this.tw) / this.cw));
        int ir = (y - this.bh) / this.th;
        int c = (x - this.tw - ic * this.cw) / this.tw;
        this.posi = this.posc = (i = -1);
        if ((this.flags & 0x80) != 0 && ir == this.inrow && c < this.line[0].length()) {
            i = 0;
        } else if (ir >= 0 && ir < this.nr) {
            i = this.row2line[ir] + ic;
        }
        if (i < 0 || i > this.items) {
            return false;
        }
        while (ir > 0 && this.row2line[ir - 1] == this.row2line[ir]) {
            c += this.wraplen;
            --ir;
        }
        this.posi = i;
        this.posc = Math.max(0, Math.min(this.line[i].length(), c));
        return true;
    }

    private void startSelect(int x, int y) {
        if (this.hit(x, y)) {
            this.select(this.posi, this.posc);
        }
    }

    private boolean updateSelect(int x, int y) {
        boolean paint = false;
        this.hit(x, y);
        if (this.posi < 0 || this.posi > this.items || this.line[this.posi] == null) {
            return paint;
        }
        if (this.dragSelect) {
            paint = this.posi != this.selecti2_ || this.posc != this.selectc2_;
            this.selecti2_ = this.posi;
            this.selectc2_ = this.posc;
        } else {
            this.selecti1_ = this.selecti2_ = this.posi;
            this.selectc1_ = this.selectc2_ = this.posc;
            this.dragSelect = true;
        }
        if (this.selecti2_ < this.selecti1_ || this.selecti2_ == this.selecti1_ && this.selectc2_ <= this.selectc1_) {
            this.selecti1 = this.selecti2_;
            this.selectc1 = this.selectc2_;
            this.selecti2 = this.selecti1_;
            this.selectc2 = this.selectc1_;
        } else {
            this.selecti1 = this.selecti1_;
            this.selectc1 = this.selectc1_;
            this.selecti2 = this.selecti2_;
            this.selectc2 = this.selectc2_;
        }
        if (paint) {
            this.copy(1);
        }
        return paint;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getPoint().x;
        int y = e.getPoint().y;
        int w = this.getWidth();
        if (this.event2button(e) != 1) {
            return;
        }
        if (this.isScroll() && x > w - this.scrollBarWidth && this.updateScroll(y)) {
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.dragScroll) {
            this.dragScroll = false;
            this.repaint();
        }
        this.dragSelect = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int x = e.getPoint().x;
        int y = e.getPoint().y;
        int button = this.event2button(e);
        if (button == 1) {
            if (y < this.bh) {
                ActionEvent ae = new ActionEvent(this, 0, "BANNER", button);
                if (this.actionListener != null) {
                    this.actionListener.actionPerformed(ae);
                }
            } else if (x < this.cw * this.getNumSplitScreenColumns()) {
                this.startSelect(x, y);
            }
        } else if (button == 2 && (this.flags & 0x80) != 0) {
            this.paste(1);
        } else {
            ActionEvent ae = new ActionEvent(this, 0, "BUTTON", button);
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(ae);
            }
        }
    }

    public void paste() {
        this.paste(0);
    }

    private void paste(int mode) {
        String text;
        if ((this.flags & 0x80) == 0) {
            return;
        }
        String string = text = mode == 1 ? GraphicsUtil.fromSystemSelection() : GraphicsUtil.fromSystemClipboard();
        if (text != null) {
            this.addInput(text);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.MW == null) {
            return;
        }
        Rectangle pos = this.getBounds();
        this.MW.px = pos.x + e.getPoint().x;
        this.MW.py = pos.y + e.getPoint().y;
    }

    private void mouseMovedAction() {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.event2button(e) != 1) {
            return;
        }
        int x = e.getPoint().x;
        int y = e.getPoint().y;
        if (this.dragScroll) {
            if (this.updateScroll(y)) {
                this.repaint();
            }
        } else if ((this.flags & 0x100) != 0 && this.updateSelect(x, y)) {
            this.repaint();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() > 0) {
            int beginLineIdx = this.calcBeginLineIndex(true);
            if (this.si < beginLineIdx - 1) {
                if (this.si - 1 < beginLineIdx) {
                    this.resetScreenIndex();
                } else {
                    ++this.si;
                }
                this.repaint();
            }
        } else if (this.si > 0) {
            --this.si;
            this.repaint();
        }
    }

    private int event2button(AWTEvent e) {
        MouseEvent me = (MouseEvent)e;
        int button = me.getButton();
        int modifiers = me.getModifiersEx();
        if (button == 0) {
            button = (modifiers & 0x400) != 0 ? 1 : ((modifiers & 0x800) != 0 ? 2 : ((modifiers & 0x1000) != 0 ? 3 : 1));
        } else if (button > 3) {
            button = 1;
        }
        if (me.isShiftDown()) {
            button += 100;
        }
        if (me.isControlDown()) {
            button += 200;
        }
        return button;
    }
}

