/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Time;
import nxm.sys.libg.GraphicsUtil;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MJFrameModSwap;
import nxm.sys.libg.MWindow;
import nxm.sys.libg.Theme;

public class MJFrame
extends JFrame
implements MJFrameModSwap {
    private static final long serialVersionUID = 2012021010311L;
    @InternalUseOnly
    public static final String UNSERIALIZABLE_MJFRAME_OBJECT_MESSAGE = "nxm.sys.libg.MJFrame does NOT currently support Java Serialization";
    transient MWindow MW;
    private transient MBox pos;
    private MBox fpos;
    public static Insets insets;

    public MJFrame(String name, MBox pos) {
        this(name, pos, (String)null);
    }

    public MJFrame(String name, MBox pos, String display2) {
        this(name, pos, MJFrame.getDisplay(display2));
    }

    public MJFrame(String name, MBox pos, GraphicsConfiguration display2) {
        super(name, display2);
        this.setupFrame(pos, name);
    }

    private void setupFrame(MBox pos, String name) {
        this.pos = pos;
        if (!Theme.getOption(32)) {
            RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        }
        if (Theme.graphicsDelay > 0.0) {
            Time.pause(Theme.graphicsDelay);
        }
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.setBounds(pos);
        this.setDefaultCloseOperation(0);
    }

    @Override
    public void setBounds(MBox pos) {
        this.fpos = new MBox(pos);
        if (insets != null) {
            this.fpos.x -= MJFrame.insets.left;
            this.fpos.y -= MJFrame.insets.top;
            this.fpos.w += MJFrame.insets.left + MJFrame.insets.right;
            this.fpos.h += MJFrame.insets.top + MJFrame.insets.bottom;
        }
        super.setBounds(this.fpos.x, this.fpos.y, this.fpos.w, this.fpos.h);
    }

    public MBox getFullBounds() {
        return this.fpos;
    }

    @Override
    public void resizePanel() {
        GraphicsUtil.invokeLater(() -> {
            if (this.MW == null || this.MW.panel == null) {
                return;
            }
            if (insets == null) {
                this.MW.panel.setBounds(0, 0, this.pos.w, this.pos.h);
            } else {
                this.MW.panel.setBounds(MJFrame.insets.left, MJFrame.insets.top, this.pos.w, this.pos.h);
            }
        });
    }

    @Override
    public Dimension getSize() {
        Dimension d = super.getSize();
        if (insets == null) {
            return d;
        }
        return d;
    }

    @Override
    public void display(int mode) {
        if (mode >= 0) {
            this.setVisible(true);
        }
        if (mode == -3) {
            this.setVisible(false);
        }
        if (mode == 1) {
            this.setExtendedState(0);
            this.setState(0);
            this.toFront();
        }
        if (mode == 0) {
            this.toBack();
        }
        if (mode == -1) {
            this.setState(1);
        }
        if (mode == 2) {
            this.setExtendedState(6);
            this.setState(0);
            this.toFront();
        }
    }

    private void process(String name, int info, Object data) {
        if (this.MW != null) {
            this.MW.process(name, info, data);
        }
    }

    @Override
    public void setMWindow(MWindow mw) {
        this.MW = mw;
    }

    @Override
    public MWindow getMWindow() {
        return this.MW;
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.MW == null || insets == null) {
            return;
        }
        Point p = this.getLocation();
        this.MW.pos.x = p.x + MJFrame.insets.left;
        this.MW.pos.y = p.y + MJFrame.insets.top;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.MW != null) {
            GraphicsUtil.invokeLater(() -> {
                if (this.MW.panel != null) {
                    this.MW.panel.setSize(this.getSize());
                }
            });
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        insets = this.getInsets();
        this.setBounds(this.pos);
        this.process("WINDOW", 1, "OPENED");
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.process("WINDOW", -1, "ICONIFIED");
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.process("WINDOW", 1, "DEICONIFIED");
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.process("WINDOW", 0, "CLOSING");
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    public static final GraphicsConfiguration getDisplay(String display2) {
        GraphicsConfiguration gconf = null;
        if (display2 != null) {
            try {
                int device = Integer.parseInt(display2);
                boolean config = false;
                gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[device].getConfigurations()[0];
            }
            catch (HeadlessException | NumberFormatException exception) {
                Shell.warning("Unable to connect to display '" + display2 + "':" + exception);
            }
        }
        return gconf;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        throw new UnsupportedOperationException(UNSERIALIZABLE_MJFRAME_OBJECT_MESSAGE);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException(UNSERIALIZABLE_MJFRAME_OBJECT_MESSAGE);
    }
}

