/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MWindow;

public class MImage
implements ImageObserver {
    public Image image;
    public ColorModel colormodel;
    public MemoryImageSource source;
    public int w;
    public int h;
    private MWindow MW;
    private byte[] buf;
    private int[] bufARGB;

    public MImage(MWindow MW, int width, int height, byte[] buf, Color[] colors, int[] rgbBuf) {
        this.MW = MW;
        this.w = width;
        this.h = height;
        if (rgbBuf != null) {
            if (buf != null || colors != null) {
                throw new MidasException("MImage: When using rgbBuf, need to set buf=null and colors=null, given buf=" + buf + " colors=" + colors + ".");
            }
            this.bufARGB = rgbBuf;
            this.source = new MemoryImageSource(this.w, this.h, rgbBuf, 0, this.w);
        } else {
            this.buf = buf;
            this.setColors(colors);
            this.source = new MemoryImageSource(this.w, this.h, this.colormodel, buf, 0, this.w);
        }
        this.source.setAnimated(true);
        this.image = MW.panel.createImage(this.source);
    }

    public MImage(MWindow MW, int width, int height, byte[] buf, Color[] colors) {
        this(MW, width, height, buf, colors, null);
    }

    public MImage(MWindow MW, int width, int height, int[] buf) {
        this(MW, width, height, null, null, buf);
    }

    public void setColors(Color[] colors) {
        if (this.bufARGB != null) {
            Shell.warning("MImage: Can not use MImage.setColors() when rgbBuf is being used.");
            return;
        }
        this.colormodel = MColor.getColorModel(colors);
        if (this.source != null) {
            this.source.newPixels(this.buf, this.colormodel, 0, this.w);
        }
    }

    @Deprecated
    public void draw(int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        this.draw(this.MW.g, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
    }

    public void draw(Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        g.drawImage(this.image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
    }
}

