/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import nxm.sys.inc.Installation;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.XmlFile;
import nxm.sys.libg.LayerMap;
import nxm.sys.libg.LayerWmsConfig;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MJPopup;

public class LayerWMS
extends LayerMap {
    static final String CRS_KEY = "LOCAL_CRS";
    static final String STYLE_KEY = "LOCAL_STYLE";
    static final String STYLES_KEY = "LOCAL_STYLES";
    static final String LAYERS_KEY = "LOCAL_LAYERS";
    static final String ENABLED_KEY = "LOCAL_ENABLED";
    private static final String DEF_BGCOLOR = "0x000066";
    private static final String WMS_111 = "1.1.1";
    private static final String WMS_130 = "1.3.0";
    private static final String EX_XML = "XML";
    private static final String EX_INIMAGE = "INIMAGE";
    private static final String EX_BLANK = "BLANK";
    private static final String EX_MIMEPRE = "application/vnd.ogc.se_";
    private static final String XLINK_XLINK = "http://www.w3.org/1999/xlink";
    private static final String XLINK_TYPE = "simple";
    private static final int DEFAULT_MAX_TRYS = 1;
    private static final int DOWNLOAD_THREADS = 32;
    private static final int OLD_DOWNLOAD_THREADS = 4;
    private static boolean useOldDownloadThreadsDefault = false;
    private static final String GEOWEBCACHE_CRS = "EPSG:4326";
    private static final String[] INHERIT_REP_KEYS = new String[]{"EX_GEOGRAPHICBOUNDINGBOX", "BOUNDINGBOX", "DIMENSION", "ATTRIBUTION", "MINSCALEDENOMINATOR", "MAXSCALEDENOMINATOR", "QUERYABLE", "CASCADED", "OPAQUE", "NOSUBSETS", "FIXEDWIDTH", "FIXEDHEIGHT"};
    private static final String[] INHERIT_ADD_KEYS = new String[]{"LOCAL_STYLES"};
    public static final String WMS_VERSIONS = "1.1.1,1.3.0";
    public static final String IMAGE_TYPES = "image/jpeg,image/gif,image/png";
    public static final String EXCEPTION_TYPES = "BLANK,XML,INIMAGE";
    protected String requestedVersion = "";
    protected String supVersions = "1.1.1,1.3.0";
    protected String supImageTypes = "image/jpeg,image/gif,image/png";
    protected String supExceptionTypes = "BLANK,XML,INIMAGE";
    protected String wmsVersion = null;
    protected String wmsFormat = null;
    protected String wmsExceptions = null;
    protected String wmsGetMapUrl = null;
    protected Color wmsBgColor = null;
    protected boolean wmsTransparent = false;
    protected int wmsMaxWidth = Integer.MAX_VALUE;
    protected int wmsMaxHeight = Integer.MAX_VALUE;
    protected Table capabilities = null;
    protected Table allLayersTable = null;
    protected Vector<Table> allLayersList = null;
    protected Vector<Table> allLocalCrs = null;
    protected int hiResMultiplier = 2;
    protected String status = null;
    protected LayerWmsConfig configPanel = null;
    protected JFrame configFrame = null;
    protected String pendingLayers = null;
    private String pendingLayer = null;
    private String[] layersSet = null;
    private GraphicsDevice gdev = null;
    private boolean popped = false;
    private boolean autoConnect = true;
    private boolean allowSpaceAsDelimInSetLayers = Installation.ApplyBugFix.PLOT_LAYERWMS_ALLOW_SPACE_AS_DELIMITER;
    private boolean requiringExceptionElementBlock = false;
    private boolean ignoreHREF = false;
    private double[] transitions = null;
    private boolean usingGWCGridsetLevels = false;
    private static String urlWMSCoordSys;
    private static final int GWC_BOUNDS_ZOOM_LEVEL = 12;
    private static final double GWC_NUM_GRID_BOUNDS;
    private static double[] gwcCompatibleGridBounds;
    public static final String debugList = "Capabilities,URLs,Transitions";
    private static final String ucDebugList;
    public static final int D_CAPABILITIES = 1;
    public static final int D_URLS = 2;
    public static final int D_TRANSITIONS = 4;
    private int debugOptions = 0;
    private static boolean gwcCompatibilityChecking;
    private static boolean gwcCompatibleURLs;

    public LayerWMS() {
        super("WMS");
        this.setCoordRefSystems(null);
        int numDownloadThreads = useOldDownloadThreadsDefault ? 4 : 32;
        this.setDownloadThreads(numDownloadThreads);
        this.status = "Not connected, URL not set yet.";
    }

    @Override
    public Table getConfig() {
        String bg;
        Table tbl = super.getConfig();
        String lay = this.getLayers();
        String string = bg = this.wmsBgColor == null ? null : MColor.toString(this.wmsBgColor);
        if (lay != null) {
            tbl.put("LAYERS", (Object)lay);
        }
        if (bg != null) {
            tbl.put("BGCOLOR", (Object)bg);
        }
        if (this.wmsTransparent) {
            tbl.put("TRANSPARENT", this.wmsTransparent);
        }
        if (this.transitions != null) {
            tbl.put("TRANSITIONS", (Object)Arrays.toString(this.transitions));
        }
        if (this.getGeoWebCache()) {
            tbl.put("GEOWEBCACHE", true);
        }
        return tbl;
    }

    @Override
    public void setURL(String url) {
        if (url == null) {
            this.disconnect();
        }
        url = this.updateMapServerList(url);
        super.setURL(url);
        if (this.mapServer == null) {
            for (String wmsUrl : this.mapServerList) {
                super.setURL(wmsUrl);
                if (this.mapServer == null) continue;
                if (this.autoConnect) {
                    this.connect();
                }
                return;
            }
            this.status = "Not Connected";
        } else if (this.autoConnect) {
            this.connect();
        }
    }

    public void connect() {
        if (this.mapServer == null) {
            for (String wmsUrl : this.mapServerList) {
                super.setURL(wmsUrl);
                if (this.mapServer == null) continue;
                break;
            }
            if (this.mapServer == null) {
                this.status = "Not Connected";
                this.warn("Map Server URL not set or unreachable. Please call setURL(String URL) with appropriate WMS Sevrer URL.");
                return;
            }
        }
        this.status = "Connecting to " + this.getHostPort();
        this.wmsVersion = null;
        this.loadCapabilities();
        this.checkInit();
        this.setNeedsRescale(true);
    }

    @Override
    public void disconnect() {
        this.wmsVersion = null;
        this.mapServer = null;
        this.setNeedsRescale(true);
        this.refresh();
    }

    public void setAutoConnect(boolean newVal) {
        this.autoConnect = newVal;
    }

    public boolean isAutoConnect() {
        return this.autoConnect;
    }

    String getStatus() {
        return this.status;
    }

    public int getHiResMultiplier() {
        return this.hiResMultiplier;
    }

    public void setHiResMultiplier(int mult) {
        this.warn("HiResMultiplier has been changed from " + this.hiResMultiplier + " to " + mult + ". You should NEVER need to use this method!");
        this.hiResMultiplier = mult;
    }

    @Deprecated
    @InternalUseOnly
    public void setInternalParams(Table tbl) {
        this.warn("************************ WARNING ************************");
        this.warn("* LayerWMS: Internal parameters are being overridden.   *");
        this.warn("*   This may cause LayerWMS to malfunction, use at your *");
        this.warn("*   own risk!                                           *");
        this.warn("*********************************************************");
        this.supVersions = tbl.getS("WMS_VERSIONS", this.supVersions);
        this.supImageTypes = tbl.getS("IMAGE_TYPES", this.supImageTypes);
        this.supExceptionTypes = tbl.getS("EXCEPTION_TYPES", this.supExceptionTypes);
        this.setRequestedVersion(this.requestedVersion);
    }

    public synchronized void setCoordRefSystems(Object table) {
        Table tbl;
        if (table == null) {
            table = XmlFile.fastXmlFileToTable(this.midas, urlWMSCoordSys);
        }
        if ((tbl = Convert.o2t(table, this.midas)) == null) {
            throw new MidasException("LayerWMS: Unable to load CRS from " + table);
        }
        this.allLocalCrs = new Vector();
        String[] keys = tbl.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            this.allLocalCrs.add(tbl.getTable(keys[i]));
        }
    }

    @InternalUseOnly
    public synchronized void setByNameCRSs(String crsNames) {
        Table origTable = XmlFile.fastXmlFileToTable(this.midas, urlWMSCoordSys);
        if (StringUtil.isEmpty(crsNames)) {
            this.allLocalCrs = new Vector();
            String[] keys = origTable.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                this.allLocalCrs.add(origTable.getTable(keys[i]));
            }
        } else {
            Table nameKey = new Table();
            for (String key : origTable) {
                Table crsTableEntry = Convert.o2t(origTable.get(key));
                String name = crsTableEntry.get("NAME").toString();
                nameKey.put(name, (Object)key);
            }
            String[] selectedCRSs = crsNames.split(",");
            this.allLocalCrs = new Vector();
            for (String crsName : selectedCRSs) {
                String origKey = nameKey.get(crsName.trim()).toString();
                Table crsTable = origTable.getTable(origKey);
                if (crsTable == null) continue;
                this.allLocalCrs.add(crsTable);
            }
        }
    }

    public synchronized Table getCoordRefSystems() {
        Table tbl = new Table();
        for (int i = 0; i < this.allLocalCrs.size(); ++i) {
            Table crs = this.allLocalCrs.get(i);
            tbl.put("CRS_" + i, (Object)crs.copy());
        }
        return tbl;
    }

    public void setTransparent(boolean transparent) {
        if (this.wmsTransparent != transparent) {
            this.wmsTransparent = transparent;
            this.refresh();
        }
    }

    public boolean getTransparent() {
        return this.wmsTransparent;
    }

    public void setBgColor(Object color) {
        Color bgcolor = MColor.getColor(color);
        if (bgcolor != this.wmsBgColor) {
            this.wmsBgColor = bgcolor;
            this.refresh();
        }
    }

    public String getBgColor() {
        if (this.getGeoWebCache()) {
            return Color.WHITE.toString();
        }
        return this.wmsBgColor == null ? DEF_BGCOLOR : MColor.toString(this.wmsBgColor);
    }

    private String getBgColorHex() {
        String bgcolor = DEF_BGCOLOR;
        if (this.wmsBgColor != null) {
            int rgb = 0xFFFFFF & this.wmsBgColor.getRGB();
            bgcolor = "0x" + StringUtil.padLeft(Integer.toHexString(rgb), 6, '0');
        }
        return bgcolor;
    }

    @Override
    public boolean isConnected() {
        return this.wmsVersion != null;
    }

    public Table getCapabilities() {
        return this.capabilities.copy();
    }

    @Override
    public void findRange() {
        super.findRange();
        if (this.allLayersList != null) {
            boolean rangeSet = false;
            Vector layersList = (Vector)this.allLayersList.clone();
            for (Table info : layersList) {
                Table boundingBox = info.getTable("EX_GEOGRAPHICBOUNDINGBOX");
                if (boundingBox == null) continue;
                if (!rangeSet) {
                    rangeSet = true;
                    this.x1 = boundingBox.getD("WESTBOUNDLONGITUDE", this.x1);
                    this.x2 = boundingBox.getD("EASTBOUNDLONGITUDE", this.x2);
                    this.y1 = boundingBox.getD("SOUTHBOUNDLATITUDE", this.y1);
                    this.y2 = boundingBox.getD("NORTHBOUNDLATITUDE", this.y2);
                    continue;
                }
                this.x1 = Math.min(this.x1, boundingBox.getD("WESTBOUNDLONGITUDE", this.x1));
                this.x2 = Math.max(this.x2, boundingBox.getD("EASTBOUNDLONGITUDE", this.x2));
                this.y1 = Math.min(this.y1, boundingBox.getD("SOUTHBOUNDLATITUDE", this.y1));
                this.y2 = Math.max(this.y2, boundingBox.getD("NORTHBOUNDLATITUDE", this.y2));
            }
        }
        this.a1 = this.y1;
        this.a2 = this.y2;
    }

    Table getAllLayersTable() {
        return this.allLayersTable;
    }

    List<Table> getAllLayersList() {
        return this.allLayersList;
    }

    Table getAvailableLayer(String key) {
        return key.equals("") ? this.getAllLayersTable() : this.getAllLayersTable().getTable(key);
    }

    synchronized Table findAvailableLayer(String name) {
        int index;
        Table layer;
        Table table = layer = name.equals("") ? this.getAllLayersTable() : null;
        if (layer == null && (index = this.findLayer(name)) >= 0) {
            layer = this.allLayersList.get(index);
        }
        return layer;
    }

    Table findAvailableLayer(int index) {
        Table layer = null;
        if (this.allLayersList != null && index >= 0 && index < this.allLayersList.size()) {
            layer = this.allLayersList.get(index);
        }
        return layer;
    }

    private int findLayer(String name) {
        int index = -1;
        for (int i = 0; index < 0 && i < this.allLayersList.size(); ++i) {
            Table lay = this.allLayersList.get(i);
            String layName = lay.getS("NAME");
            if (!name.equals(layName)) continue;
            index = i;
        }
        return index;
    }

    String findLayerKey(String name) {
        String key = null;
        key = name == null ? null : (name.equals("") ? "" : this.findLayerKey(name, this.allLayersTable, ""));
        return key;
    }

    private synchronized String findLayerKey(String name, Table layer, String prefix) {
        Table layers = layer == null ? null : layer.getTable(LAYERS_KEY);
        String key = null;
        String layName = layer.getS("NAME", null);
        if (layName != null && layName.equals(name)) {
            key = prefix;
        } else if (layers != null) {
            String[] keys = layers.getKeys();
            for (int i = 0; key == null && i < keys.length; ++i) {
                String tag = "LOCAL_LAYERS." + keys[i];
                String dot = prefix.length() == 0 ? "" : ".";
                key = this.findLayerKey(name, layers.getTable(keys[i]), prefix + dot + tag);
            }
        }
        return key;
    }

    synchronized boolean moveAvailableLayer(String name, int index) {
        boolean move;
        int from = this.findLayer(name);
        int to = index < from ? index : index - 1;
        boolean bl = move = from >= 0 && from != index;
        if (move) {
            Table layer = this.allLayersList.remove(from);
            this.allLayersList.insertElementAt(layer, to);
            this.refresh();
        }
        return move;
    }

    public void setLayers(String layerList) {
        if (layerList == null) {
            layerList = "";
        }
        this.layersSet = layerList.split(",");
        if (!this.checkInit()) {
            this.pendingLayers = layerList;
        } else {
            if (this.transitions != null) {
                this.warn("Layer transitions are being turned off, as layers are being overriden after initial setup. New layerList:" + layerList);
                this.transitions = null;
            }
            this.doSetLayers(layerList);
            this.refresh();
        }
    }

    private void doSetLayers(String layerList) {
        layerList.replace('|', ',');
        Parser parser = new Parser(layerList);
        parser.setUseSpaceDelimiter(this.isAllowSpaceAsDelimiter());
        for (int i = 1; i <= parser.elements(); ++i) {
            String layer = parser.get(i);
            String style = "";
            boolean reorder = true;
            boolean enabled = true;
            boolean toggle = false;
            if (layer.startsWith("-")) {
                reorder = false;
                enabled = false;
                layer = layer.substring(1);
            } else if (layer.startsWith("+")) {
                reorder = false;
                enabled = true;
                layer = layer.substring(1);
            } else if (layer.startsWith("~")) {
                reorder = false;
                toggle = true;
                layer = layer.substring(1);
            } else if (i == 1) {
                this.doSetAllLayers(false, "");
            }
            int index = layer.indexOf(47);
            if (index > 0) {
                style = layer.substring(index + 1);
                layer = layer.substring(0, index);
            }
            if (layer.equals("*")) {
                this.doSetAllLayers(enabled, style);
                continue;
            }
            Table info = this.findAvailableLayer(layer);
            if (info == null) {
                info = this.findAvailableLayer(layer.trim());
            }
            if (info == null) {
                this.warn("Unknown layer '" + layer + "' in '" + layerList + "', note that layer names are case-sensitive.");
                continue;
            }
            if (toggle) {
                enabled = !info.getState(ENABLED_KEY, false);
            }
            info.put(ENABLED_KEY, enabled);
            info.put(STYLE_KEY, (Object)style);
            if (!enabled || !reorder) continue;
            this.allLayersList.remove(info);
            this.allLayersList.add(info);
        }
    }

    private void doSetAllLayers(boolean enabled, String style) {
        for (int i = 0; i < this.allLayersList.size(); ++i) {
            Table info = this.allLayersList.get(i);
            info.put(ENABLED_KEY, enabled);
            info.put(STYLE_KEY, (Object)style);
        }
    }

    public String getAllStyles(String layer) {
        if (layer.indexOf(47) > 0) {
            layer = layer.substring(0, layer.indexOf(47));
        }
        String styles = null;
        Table info = this.findAvailableLayer(layer);
        if (info == null) {
            if (this.isConnected()) {
                this.warn("Unknown layer='" + layer + "', note that layers are case-sensitive.");
            }
        } else {
            Table tbl = info.getTable(STYLES_KEY);
            String[] keys = tbl.getKeys();
            StringBuilder list3 = new StringBuilder();
            for (int i = 0; i < keys.length; ++i) {
                if (i != 0) {
                    list3.append(',');
                }
                list3.append(tbl.getTable(keys[i]).getS("NAME"));
            }
            styles = list3.toString();
        }
        return styles;
    }

    public String getAllLayers() {
        return this.checkInit() ? this.getLayers(true) : null;
    }

    public String getLayers() {
        return this.getLayers(false);
    }

    private String getLayers(boolean all) {
        StringBuilder layers = new StringBuilder();
        if (!this.checkInit()) {
            if (this.transitions == null || all || this.pendingLayer == null) {
                layers.append(this.pendingLayers);
            } else {
                layers.append(this.pendingLayer);
            }
        } else {
            for (int i = this.allLayersList.size() - 1; i >= 0; --i) {
                Table layer = this.allLayersList.get(i);
                String name = layer.getS("NAME");
                String style = layer.getS(STYLE_KEY, "");
                boolean enabled = layer.getState(ENABLED_KEY);
                if (name == null || !all && !enabled) continue;
                if (layers.length() > 0) {
                    layers.append(',');
                }
                layers.append(name);
                if (style == null || style.length() <= 0) continue;
                layers.append("/").append(style);
            }
        }
        return layers.toString();
    }

    private synchronized String[] getEnabledLayersAndStyles() {
        StringBuilder layers = new StringBuilder();
        StringBuilder styles = new StringBuilder();
        Vector<Table> validCrs = new Vector<Table>(this.allLocalCrs);
        if (this.checkInit()) {
            for (int i = 0; i < this.allLayersList.size(); ++i) {
                Table layer = this.allLayersList.get(i);
                String name = layer.getS("NAME");
                String style = layer.getS(STYLE_KEY, "");
                String crs = layer.getS(CRS_KEY, "");
                boolean enabled = layer.getState(ENABLED_KEY);
                if (name == null || !enabled) continue;
                if (style == null) {
                    style = "";
                }
                if (layers.length() > 0) {
                    layers.append(',');
                    styles.append(',');
                }
                layers.append(StringUtil.encodePercentEncoding(name));
                styles.append(StringUtil.encodePercentEncoding(style));
                this.updateValidCrs(validCrs, crs);
            }
        } else if (this.transitions == null || this.pendingLayer == null) {
            layers.append(this.pendingLayers);
        } else {
            layers.append(this.pendingLayer);
        }
        String crsChoice = this.getGeoWebCache() ? this.preferGeoWebCacheCRS(validCrs) : this.getFirstValid(validCrs);
        return new String[]{layers.toString(), styles.toString(), crsChoice};
    }

    private void updateValidCrs(List<Table> allValid, String layValid) {
        for (int i = 0; i < allValid.size(); ++i) {
            Table crs = allValid.get(i);
            if (crs == null) continue;
            String name = crs.getS("NAME", null);
            boolean allow = crs.getState("ALLOW", false);
            int index = -1;
            if (allow && name != null) {
                index = Parser.find(layValid, name, -1) - 1;
            }
            if (index >= 0) continue;
            allValid.set(i, null);
        }
    }

    private String getFirstValid(List<Table> allValid) {
        String name = null;
        for (Table crs : allValid) {
            if (crs != null && (name = crs.getS("NAME", null)) != null) break;
        }
        return name;
    }

    private String preferGeoWebCacheCRS(List<Table> allValid) {
        String firstValid = null;
        String name = null;
        for (Table crs : allValid) {
            if (crs == null || (name = crs.getS("NAME", null)) == null) continue;
            if (GEOWEBCACHE_CRS.equals(name)) break;
            if (firstValid == null) {
                firstValid = name;
            }
            name = null;
        }
        if (name == null) {
            name = firstValid;
            this.info("Using CRS " + name + " since GeoWebCache standard " + GEOWEBCACHE_CRS + " is not supported.");
        }
        return name;
    }

    private synchronized boolean checkInit() {
        if (this.pendingLayers != null) {
            this.doSetLayers(this.pendingLayers);
            this.pendingLayers = null;
        }
        return this.allLayersList != null;
    }

    private Dimension getImageDimension(int width, int height, boolean hiRes, boolean warn) {
        Dimension dim;
        if (width > this.wmsMaxWidth || height > this.wmsMaxHeight) {
            double ratio = (double)height / (double)width;
            double limitW = ratio / (double)this.wmsMaxHeight;
            double maxW = Math.min((double)this.wmsMaxWidth, (double)this.wmsMaxHeight / ratio);
            int w = (int)Math.max((double)this.wmsMaxWidth, maxW);
            int h = (int)(ratio * (double)w);
            dim = new Dimension(w, h);
            if (warn) {
                this.warn("Image size of " + width + "x" + height + " pixels exceeds server limit of " + this.wmsMaxWidth + "x" + this.wmsMaxHeight + " using " + w + "x" + h);
            }
        } else {
            dim = hiRes ? this.getImageDimension(width * this.hiResMultiplier, height * this.hiResMultiplier, false, false) : new Dimension(width, height);
        }
        return dim;
    }

    @Override
    protected int drawArea(double minLon, double maxLon, double minLat, double maxLat, int width, int height, boolean hiRes, String pos) {
        String version = this.wmsVersion;
        if (version != null) {
            boolean blank;
            Dimension dim = this.getImageDimension(width, height, hiRes, this.debug);
            String bounds = "" + minLon + "," + minLat + "," + maxLon + "," + maxLat;
            double level = 0.0;
            if (this.transitions != null) {
                level = this.usingGWCGridsetLevels ? (this.gwcLevel != 0 ? (double)this.gwcLevel : (double)this.calcTileLevel(minLon, maxLon, minLat, maxLat, width, height, hiRes)[0]) : this.calculateWMSLevel(maxLon - minLon, maxLat - minLat, width, height);
                this.updateEnabledLayer(level);
            } else if (this.MP.isDisplayingWMSLevel()) {
                level = this.calculateWMSLevel(maxLon - minLon, maxLat - minLat, width, height);
            }
            this.MP.setWMSLevel(level);
            String[] layersAndStyles = this.getEnabledLayersAndStyles();
            String layers = layersAndStyles[0];
            boolean bl = blank = layers.length() == 0;
            if (blank) {
                if (this.debug) {
                    this.info("GetMap url = <blank>");
                }
            } else {
                int numRetrys;
                BufferedImage img;
                String urlBGCOLOR;
                String transparent;
                String styles = layersAndStyles[1];
                String crs = layersAndStyles[2];
                String url = null;
                String bgcolor = this.getBgColorHex();
                String string = transparent = this.wmsTransparent ? "TRUE" : "FALSE";
                if (crs == null) {
                    this.warn("Warning no matching CRS for layers " + layers);
                    crs = GEOWEBCACHE_CRS;
                }
                String string2 = urlBGCOLOR = this.getGeoWebCache() ? "" : "&BGCOLOR=" + bgcolor;
                if (version.equals(WMS_130)) {
                    Table crsTable = null;
                    for (Table t : this.allLocalCrs) {
                        String n;
                        if (t == null || !crs.equalsIgnoreCase(n = t.getS("NAME", null))) continue;
                        crsTable = t;
                        break;
                    }
                    if (null != crsTable && crsTable.getS("X", "").equalsIgnoreCase("latitude")) {
                        bounds = "" + minLat + "," + minLon + "," + maxLat + "," + maxLon;
                    }
                    url = this.wmsGetMapUrl + "VERSION=" + version + "&REQUEST=GetMap&CRS=" + crs + "&BBOX=" + bounds + "&WIDTH=" + dim.width + "&HEIGHT=" + dim.height + "&LAYERS=" + layers + "&STYLES=" + styles + "&FORMAT=" + this.wmsFormat + "&EXCEPTIONS=" + this.wmsExceptions + urlBGCOLOR + "&TRANSPARENT=" + transparent + "&TILED=" + this.getUseTiles();
                } else if (version.equals(WMS_111)) {
                    url = this.wmsGetMapUrl + "VERSION=" + version + "&REQUEST=GetMap&SRS=" + crs + "&BBOX=" + bounds + "&WIDTH=" + dim.width + "&HEIGHT=" + dim.height + "&LAYERS=" + layers + "&STYLES=" + styles + "&FORMAT=" + this.wmsFormat + "&EXCEPTIONS=" + LayerWMS.getExceptionMimeType(this.wmsExceptions) + urlBGCOLOR + "&TRANSPARENT=" + transparent + "&TILED=" + this.getUseTiles();
                } else {
                    throw new MidasException("Unknown WMS protocol version " + version);
                }
                if ((this.debugOptions & 2) != 0) {
                    this.midas.info("[DEBUG URLS] url:" + url);
                }
                if (gwcCompatibilityChecking) {
                    gwcCompatibleURLs &= this.gwcCompatibilityCheck(crs, layers, dim, minLon, maxLon, minLat, maxLat, urlBGCOLOR);
                }
                if (this.wmsVersion != null && (img = this.requestImage(url, numRetrys = Math.max(1, this.numRetriesIfBGColor + 1), false, dim.width, dim.height)) != null) {
                    this.drawImage(img, minLon, maxLon, minLat, maxLat);
                }
            }
        }
        return 0;
    }

    private boolean gwcCompatibilityCheck(String crs, String layers, Dimension dim, double minLon, double maxLon, double minLat, double maxLat, String urlBGcolor) {
        double[] bounds;
        boolean validURL = true;
        if (!crs.equals(GEOWEBCACHE_CRS) || layers.contains(",") || dim.getWidth() != 256.0 || dim.getHeight() != 256.0 || !urlBGcolor.equals("")) {
            return false;
        }
        for (double bound : bounds = new double[]{minLon, maxLon, minLat, maxLat}) {
            if (bound < 0.0) {
                bound *= -1.0;
            }
            if (Arrays.binarySearch(gwcCompatibleGridBounds, bound) >= 0 || !(maxLon - minLon >= gwcCompatibleGridBounds[1])) continue;
            return false;
        }
        return validURL;
    }

    private double calculateWMSLevel(double widthDegrees, double heightDegrees, int widthPixels, int heightPixels) {
        double diag2Degrees = widthDegrees * widthDegrees + heightDegrees * heightDegrees;
        double diag2Pixels = widthPixels * widthPixels + heightPixels * heightPixels;
        double pix2Degrees = diag2Pixels / diag2Degrees;
        return pix2Degrees;
    }

    private void updateEnabledLayer(double level) {
        int transitionLocation;
        boolean transitionsDebug;
        boolean bl = transitionsDebug = (this.debugOptions & 4) != 0;
        if (transitionsDebug) {
            this.midas.info("[DEBUG TRANSITIONS] LayerWMS.updateEnabledLayer pix2Degrees:" + level);
        }
        int activeLayer = (transitionLocation = Arrays.binarySearch(this.transitions, level)) < 0 ? Math.abs(transitionLocation) - 1 : transitionLocation + 1;
        activeLayer = Math.min(activeLayer, this.layersSet.length - 1);
        if (this.allLayersList != null) {
            String activeLayerName;
            int indexStyle = this.layersSet[activeLayer].indexOf("/");
            String string = activeLayerName = indexStyle < 0 ? this.layersSet[activeLayer] : this.layersSet[activeLayer].substring(0, indexStyle);
            if (transitionsDebug) {
                this.midas.info("[DEBUG TRANSITIONS] LayerWMS.updateEnabledLayer using allLayersList active layer:" + activeLayer + " name:" + activeLayerName);
            }
            activeLayer = this.findLayer(activeLayerName);
            for (String layerInfo : this.layersSet) {
                indexStyle = layerInfo.indexOf("/");
                String layerName = indexStyle < 0 ? layerInfo : layerInfo.substring(0, indexStyle);
                int layerIndex = this.findLayer(layerName);
                boolean enabled = layerIndex == activeLayer;
                Table lay = this.allLayersList.get(layerIndex);
                lay.put(ENABLED_KEY, enabled);
            }
        } else {
            if (transitionsDebug) {
                this.midas.info("[DEBUG TRANSITIONS] LayerWMS.updateEnabledLayer active layer:" + activeLayer);
            }
            this.pendingLayer = this.layersSet[activeLayer];
        }
    }

    private static String getExceptionMimeType(String type) {
        return EX_MIMEPRE + type.toLowerCase();
    }

    private static String getExceptionName(String mimeType) {
        if (EX_MIMEPRE.length() > mimeType.length()) {
            return "INVALID";
        }
        return mimeType.substring(EX_MIMEPRE.length()).toUpperCase();
    }

    private static String[] getExceptionNames(String[] mimeTypes) {
        String[] names = new String[mimeTypes.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = LayerWMS.getExceptionName(mimeTypes[i]);
        }
        return names;
    }

    @Override
    protected HttpURLConnection openConnection(String url) throws IOException {
        String type;
        HttpURLConnection conn = super.openConnection(url);
        List<String> content = conn.getHeaderFields().get("Content-Type");
        if (content == null) {
            content = conn.getHeaderFields().get("Content-type");
        }
        String string = type = content == null ? null : content.toString();
        if (this.wmsExceptions.equals(EX_XML) && type == null) {
            throw new LayerMap.MapServerException("Content-Type is not set.", false);
        }
        if (type.equals("[text/xml]") || type.startsWith("[text/xml;") || type.equals("[application/vnd.ogc.se_xml]")) {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder msg = new StringBuilder();
                String line = null;
                while ((line = in.readLine()) != null) {
                    msg.append('\n').append(line);
                }
                throw new LayerMap.MapServerException(msg.toString(), false);
            }
            catch (LayerMap.MapServerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new LayerMap.MapServerException("Unable to load XML exception info.", e, false);
            }
        }
        if (type.equals("[application/vnd.ogc.se_inimage]")) {
            throw new LayerMap.MapServerException("Exception described in image.", true);
        }
        if (type.equals("[application/vnd.ogc.se_blank]")) {
            throw new LayerMap.MapServerException("Unknown server exception, image is blank.", false);
        }
        return conn;
    }

    private void loadCapabilities() {
        String requestedAtEnd = this.requestedVersion == null || this.requestedVersion.isEmpty() ? "" : "," + this.requestedVersion;
        Parser versions = new Parser(this.supVersions + requestedAtEnd);
        int index = versions.elements();
        String serverVer = null;
        try {
            while (index > 0 && this.wmsVersion == null) {
                String localVer = versions.get(index);
                if (serverVer == null || StringUtil.compareVersions(localVer, serverVer) < 0) {
                    String url = this.mapServer + "?VERSION=" + localVer + "&REQUEST=GetCapabilities&SERVICE=WMS";
                    String timeoutQual = "{CONNECTTIMEOUT=" + this.connectTimeout + ",TIMEOUT=" + this.readTimeout + "}";
                    if (this.debug) {
                        this.info("GetCapabilities url = " + url + " timeouts=" + timeoutQual);
                    }
                    this.capabilities = XmlFile.fastXmlFileToTable(this.midas, url + timeoutQual);
                    if ((this.debugOptions & 1) != 0) {
                        this.midas.info("[DEBUG CAPABILITIES] LayerWMS.loadCapabilities :" + this.capabilities);
                    }
                    serverVer = this.capabilities.getS("VERSION");
                }
                if (serverVer == null) {
                    index = -1;
                    continue;
                }
                int comp = StringUtil.compareVersions(localVer, serverVer);
                if (comp == 0) {
                    this.wmsVersion = localVer;
                    continue;
                }
                if (comp < 0) {
                    index = -1;
                    continue;
                }
                --index;
            }
            if (serverVer == null) {
                throw new MidasException("Server does not support the same OpenGIS WMS protocol version as the client.");
            }
            Table getMap = this.getCapTable("CAPABILITY.REQUEST.GETMAP");
            if (getMap == null) {
                throw new MidasException("Could not find GETMAP section in the server capabilities.");
            }
            this.wmsFormat = this.getBest(this.supImageTypes, this.getAllS(getMap, "FORMAT"));
            if (this.wmsFormat == null) {
                throw new MidasException("Server does not support any of the image formats supported by the client.");
            }
            Table httpGet = this.getCapTable("CAPABILITY.REQUEST.GETMAP.DCPTYPE.HTTP.GET.ONLINERESOURCE");
            if (httpGet == null) {
                this.warn("Could not find online resource for GetMap");
                this.wmsGetMapUrl = this.mapServer + "?";
            } else {
                String xlink = httpGet.getS("XLINK:XLINK", XLINK_XLINK);
                String href = httpGet.getS("XLINK:HREF", null);
                String type = httpGet.getS("XLINK:TYPE", XLINK_TYPE);
                this.wmsGetMapUrl = this.checkGetMapHref(href);
                if (!xlink.equals(XLINK_XLINK)) {
                    this.warn("Invalid xlink for GetMap, xlink:xlink=" + xlink);
                }
                if (!type.equals(XLINK_TYPE)) {
                    this.warn("Invalid type for GetMap, xlink:type=" + type);
                }
            }
            this.loadWmsLayers(this.getCapTable("CAPABILITY.LAYER"));
            Table service = this.getCapTable("SERVICE");
            if (service != null) {
                try {
                    this.wmsMaxWidth = service.getL("MAXWIDTH", Integer.MAX_VALUE);
                    this.wmsMaxHeight = service.getL("MAXHEIGHT", Integer.MAX_VALUE);
                }
                catch (Exception e) {
                    this.warn("An incorrect value received from geoServer for maxwidth: " + this.wmsMaxWidth + " or maxheight: " + this.wmsMaxHeight);
                    this.wmsMaxWidth = Integer.MAX_VALUE;
                    this.wmsMaxHeight = Integer.MAX_VALUE;
                }
            }
            Table exception = this.getCapTable("CAPABILITY.EXCEPTION");
            String[] formats = this.getAllS(exception, "FORMAT");
            boolean isWMS111_server = WMS_111.equals(this.wmsVersion);
            if (isWMS111_server) {
                formats = LayerWMS.getExceptionNames(formats);
            }
            this.wmsExceptions = this.getBest(this.supExceptionTypes, formats);
            if (this.wmsExceptions == null && !this.requiringExceptionElementBlock) {
                this.wmsExceptions = EX_XML;
            } else {
                if (this.wmsExceptions == null && !isWMS111_server) {
                    formats = LayerWMS.getExceptionNames(formats);
                    this.wmsExceptions = this.getBest(this.supExceptionTypes, formats);
                    if (WMS_130.equals(this.wmsVersion)) {
                        this.warn("Server claims to be WMS 1.3.0 but is using WMS 1.1.1 exception format: " + this.mapServer);
                    }
                }
                if (this.wmsExceptions == null) {
                    throw new MidasException("Server does not support any of the exception formats supported by the client.");
                }
            }
        }
        catch (Exception e) {
            this.warn("Unable to connect to server on " + this.mapServer + " due to:\n    " + e + "\n    " + e.getCause());
            this.wmsVersion = null;
            this.status = "Unable to connect to " + this.getHostPort();
        }
        if (this.wmsVersion != null) {
            this.status = "Connected to " + this.getHostPort() + " (WMS " + this.wmsVersion + ")";
        }
    }

    private String checkGetMapHref(String href) {
        String url = null;
        if (href != null) {
            if ((href = href.replaceAll("&amp;", "&")).endsWith("?") || href.indexOf("?") > 0 && href.endsWith("&")) {
                url = href;
            } else {
                url = href.indexOf("?") > 0 ? href + "&" : href + "?";
                this.warn("GetCapabilities for '" + this.mapServer + "' specified invalid href for GetMap requests (xlink:href='" + href + "'), will try using '" + url + "'.");
            }
        }
        try {
            if (this.ignoreHREF) {
                url = this.mapServer + "?";
            }
            this.checkReachable(url);
        }
        catch (MidasException e) {
            String getCapabilitiesHREF = url;
            url = this.mapServer + "?";
            this.warn(e.getMessage());
            this.warn("Unable to use URL specified in GetCapabilities for GetMap requests: " + getCapabilitiesHREF + "\n       will try using '" + url + "'.");
        }
        return url;
    }

    @Override
    public void configure() {
        this.setConfigPanelVisible(true);
    }

    @Override
    public void close() {
        if (this.configFrame != null && Shell.needRemoveNotifyToAvoidJVMHang()) {
            this.configFrame.removeNotify();
        }
        super.close();
        this.setConfigPanelVisible(false);
    }

    public void setConfigPanelVisible(boolean visible) {
        if (this.isConnected()) {
            if (this.configFrame != null && (this.MP.isPopped() != this.popped || this.MP.isPopped() && this.gdev != this.MP.getPopDevice())) {
                this.configFrame = null;
            }
            if (this.configFrame == null && visible) {
                this.checkInit();
                this.configPanel = new LayerWmsConfig(this);
                if (this.MP.isPopped()) {
                    this.gdev = this.MP.getPopDevice();
                    if (this.gdev == null) {
                        this.gdev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                    }
                    this.configFrame = new JFrame("LayerWMS Configuration", this.gdev.getDefaultConfiguration());
                    this.popped = true;
                } else {
                    this.configFrame = new JFrame("LayerWMS Configuration");
                    this.popped = false;
                }
                this.configFrame.getContentPane().add(this.configPanel);
                this.configFrame.pack();
            }
            if (this.configFrame != null && this.configFrame.isVisible() != visible) {
                if (visible && this.MP != null && this.MP.getPanel() != null) {
                    Point point = this.MP.getPanel().getLocationOnScreen();
                    point.x += 20;
                    point.y += 20;
                    this.configFrame.setLocation(point);
                }
                this.configFrame.setVisible(visible);
            }
        } else {
            if (this.configFrame != null) {
                this.configFrame.setVisible(false);
            }
            if (visible) {
                String message = "LayerWMS: " + this.getStatus();
                MJPopup mjpopup = MJPopup.createOk(this.MP.getPanel(), "LayerWMS Configuration", 0, message);
                mjpopup.display(0);
                this.warn("LayerWMS:" + this.name + "  unable to display configuration panel: " + this.getStatus());
            }
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.configFrame != null && this.configFrame.isVisible()) {
            this.configPanel.refreshConfig();
        }
    }

    private void loadWmsLayers(Table tbl) {
        this.allLayersList = new Vector();
        this.allLayersTable = this.getWmsLayer(tbl, null, this.allLayersList);
    }

    private Table getWmsLayer(Table tbl, Table inheritFrom, Vector<Table> flatView) {
        Table scaleHint;
        String[] inheritAddKeys = new String[]{STYLES_KEY};
        if (tbl == null) {
            return null;
        }
        Table layer = new Table();
        Table layers = new Table();
        Table styles = new Table();
        String crs = "";
        String tempCrs = "";
        flatView.add(layer);
        layer.put(LAYERS_KEY, (Object)layers);
        layer.put(STYLES_KEY, (Object)styles);
        layer.put(ENABLED_KEY, false);
        layer.put(STYLE_KEY, (Object)"");
        if (inheritFrom != null) {
            this.copyTableValues(INHERIT_REP_KEYS, inheritFrom, layer);
            this.copyTableTables(INHERIT_ADD_KEYS, inheritFrom, layer);
            crs = inheritFrom.getS(CRS_KEY);
        }
        layer.merge(tbl);
        crs = this.mergeLists(crs, this.extractStrings("CRS", layer));
        crs = this.mergeLists(crs, this.extractStrings("SRS", layer));
        layer.put(CRS_KEY, (Object)crs);
        Table bounds = layer.getTable("LATLONBOUNDINGBOX");
        if (bounds != null) {
            layer.rename("LATLONBOUNDINGBOX", "EX_GEOGRAPHICBOUNDINGBOX");
            bounds.rename("MINY", "SOUTHBOUNDLATITUDE");
            bounds.rename("MAXY", "NORTHBOUNDLATITUDE");
            bounds.rename("MINX", "WESTBOUNDLONGITUDE");
            bounds.rename("MAXX", "EASTBOUNDLONGITUDE");
        }
        if ((scaleHint = layer.getTable("SCALEHINT")) != null) {
            layer.remove("SCALEHINT");
            layer.put("MINSCALEDENOMINATOR", 1.0 / scaleHint.getD("MIN"));
            layer.put("MAXSCALEDENOMINATOR", 1.0 / scaleHint.getD("MAX"));
        }
        this.extractFixAndCopy("STYLE", "NAME", layer, styles);
        Object[] allLayers = this.extractAll(layer, "LAYER");
        for (int i = 0; i < allLayers.length; ++i) {
            Table subLay = this.getWmsLayer((Table)allLayers[i], layer, flatView);
            String name = subLay.getS("NAME");
            layers.put(LayerWMS.fixName(name), (Object)subLay);
        }
        return layer;
    }

    private String mergeLists(String first, String last) {
        String str;
        if (first.length() == 0) {
            str = last;
        } else if (last.length() == 0) {
            str = first;
        } else {
            Parser parser = new Parser(last);
            str = first;
            for (int i = 1; i <= parser.elements(); ++i) {
                String elem = parser.get(i);
                if (Parser.find(str, elem, -1) <= 0) continue;
                str = str + "," + elem;
            }
        }
        return str;
    }

    private void copyTableValues(String[] keys, Table src, Table dest) {
        for (int i = 0; i < keys.length; ++i) {
            Object val = src.get(keys[i]);
            if (val == null) continue;
            dest.put(keys[i], val);
        }
    }

    private void copyTableTables(String[] keys, Table src, Table dest) {
        for (int i = 0; i < keys.length; ++i) {
            Table srcTable = src.getTable(keys[i]);
            Table destTable = dest.getTable(keys[i]);
            if (destTable == null) continue;
            srcTable.merge(destTable);
        }
    }

    private void copyTableString(String[] keys, Table src, Table dest) {
        for (int i = 0; i < keys.length; ++i) {
            String sStr = src.getS(keys[i], "");
            String dStr = dest.getS(keys[i], "");
            src.put(keys[i], (Object)(sStr + dStr));
        }
    }

    private void extractFixAndCopy(String tableKey, String nameKey, Table src, Table dest) {
        Object[] tables = this.extractAll(src, tableKey);
        for (int i = 0; i < tables.length; ++i) {
            Table tbl = (Table)tables[i];
            String name = tbl.getS(nameKey);
            dest.put(LayerWMS.fixName(name), (Object)tbl);
        }
    }

    private static String fixName(String name) {
        return name == null ? null : name.replaceAll("[^A-Za-z0-9_]", "_").toUpperCase();
    }

    private String[] getAllS(Table tab, String key) {
        ArrayList<String> values = new ArrayList<String>();
        String val = tab.getS(key);
        if (val != null) {
            values.add(val);
        } else {
            for (int i = 1; i == 1 || val != null; ++i) {
                val = tab.getS(key + "_" + i);
                if (val == null) continue;
                values.add(val);
            }
        }
        return values.toArray(StringUtil.EMPTY_STRING_ARRAY);
    }

    private Object[] extractAll(Table tab, String key) {
        ArrayList<Object> values = new ArrayList<Object>();
        Object val = tab.get(key);
        if (val != null) {
            values.add(val);
            tab.remove(key);
        } else {
            for (int i = 1; i == 1 || val != null; ++i) {
                String tag = key + "_" + i;
                val = tab.get(tag);
                if (val == null) continue;
                values.add(val);
                tab.remove(tag);
            }
        }
        return values.toArray();
    }

    private String extractStrings(String tableKey, Table src) {
        return StringUtil.join(this.extractAll(src, tableKey), ",");
    }

    private String getBest(String list3, String[] options) {
        String value = null;
        int index = -1;
        for (int i = 0; i < options.length; ++i) {
            int idx = Parser.find(list3, options[i], -1);
            if (idx <= index) continue;
            index = idx;
            value = options[i];
        }
        return value;
    }

    private Table getCapTable(String key) {
        return this.capabilities == null ? null : this.capabilities.getTable(key);
    }

    private String getCapS(String key) {
        return this.capabilities == null ? null : this.capabilities.getS(key);
    }

    @Deprecated
    public boolean isAllowSpaceAsDelimiter() {
        return this.allowSpaceAsDelimInSetLayers;
    }

    @Deprecated
    public void setAllowSpaceAsDelimiter(boolean value) {
        this.allowSpaceAsDelimInSetLayers = value;
    }

    public void setRequiringExceptionElementBlock(boolean required) {
        this.requiringExceptionElementBlock = required;
    }

    public boolean isRequiringExceptionElementBlock() {
        return this.requiringExceptionElementBlock;
    }

    public void setRequestedVersion(String requestedVersion) {
        boolean requestedIsSupported;
        if (requestedVersion == null || requestedVersion.isEmpty()) {
            this.requestedVersion = "";
        }
        this.requestedVersion = (requestedIsSupported = this.isRequestedVersionSupported(requestedVersion)) ? requestedVersion : "";
    }

    private boolean isRequestedVersionSupported(String requestedVersion) {
        boolean requestedIsSupported = false;
        try {
            requestedIsSupported = Arrays.asList(this.supVersions.split(",")).contains(requestedVersion);
        }
        catch (Exception e) {
            requestedIsSupported = false;
        }
        if (!requestedIsSupported) {
            this.warn("Requested Version (" + requestedVersion + ") is not listed in supported versions {" + this.supVersions + "}, so version request is not active");
        }
        return requestedIsSupported;
    }

    public void setUseOldDownloadThreadsDefault(boolean useOld) {
        useOldDownloadThreadsDefault = useOld;
    }

    public void setIgnoreHREF(boolean ignoreGetCapabilitiesHREF) {
        this.ignoreHREF = ignoreGetCapabilitiesHREF;
    }

    public void setTransitions(String transitionsString) {
        if (StringUtil.isEmpty(transitionsString)) {
            this.transitions = null;
            return;
        }
        String[] values = transitionsString.split(",");
        this.transitions = new double[values.length];
        this.usingGWCGridsetLevels = values[0].startsWith("L");
        try {
            for (int i = 0; i < values.length; ++i) {
                boolean isGWCLevel = values[i].startsWith("L");
                this.usingGWCGridsetLevels |= isGWCLevel;
                String strTransition = isGWCLevel ? values[i].substring(1) : values[i];
                this.transitions[i] = Double.valueOf(strTransition);
            }
        }
        catch (NumberFormatException npe) {
            this.warn("LayerWMS could not set layer transitions, as one value or more is not a double: " + transitionsString);
            this.transitions = null;
        }
    }

    @InternalUseOnly
    public static void setGwcCompatibilityChecking(boolean checkingEnabled) {
        if (gwcCompatibilityChecking != checkingEnabled && (gwcCompatibilityChecking = checkingEnabled)) {
            gwcCompatibleURLs = true;
            if (gwcCompatibleGridBounds == null) {
                LayerWMS.initGwcCompatibleBounds();
            }
        }
    }

    @InternalUseOnly
    public static boolean getGwcCompatibilityChecking() {
        return gwcCompatibilityChecking;
    }

    private static void initGwcCompatibleBounds() {
        gwcCompatibleGridBounds = new double[(int)GWC_NUM_GRID_BOUNDS + 1];
        LayerWMS.gwcCompatibleGridBounds[0] = 0.0;
        double gridSeparation = (double)GWC_4326_X_MAX / GWC_NUM_GRID_BOUNDS;
        for (int i = 1; i < gwcCompatibleGridBounds.length; ++i) {
            LayerWMS.gwcCompatibleGridBounds[i] = gwcCompatibleGridBounds[i - 1] + gridSeparation;
        }
    }

    @InternalUseOnly
    public static boolean getGwcCompatibleURLs() {
        return gwcCompatibleURLs;
    }

    @Override
    public void setDebug(String arg) {
        if ((arg = arg.replace('|', ',')).startsWith(",")) {
            arg = arg.substring(1);
        }
        if (arg.endsWith(",")) {
            arg = arg.substring(0, arg.length() - 1);
        }
        String[] args = arg.split(",");
        String wmsDebug = "";
        String mapDebug = "";
        for (String debugOpt : args) {
            if (ucDebugList.contains(debugOpt.toUpperCase())) {
                if (wmsDebug.isEmpty()) {
                    wmsDebug = debugOpt;
                    continue;
                }
                wmsDebug = wmsDebug + "|" + debugOpt;
                continue;
            }
            mapDebug = mapDebug.isEmpty() ? debugOpt : mapDebug + "|" + debugOpt;
        }
        if (!mapDebug.isEmpty()) {
            super.setDebug(mapDebug);
        }
        if (!wmsDebug.isEmpty()) {
            this.debugOptions = Parser.mask(debugList, wmsDebug, this.debugOptions);
        }
    }

    static {
        GWC_NUM_GRID_BOUNDS = Math.pow(2.0, 13.0);
        gwcCompatibleGridBounds = null;
        ucDebugList = debugList.toUpperCase();
        gwcCompatibilityChecking = false;
        ClassLoader loader = LayerWMS.class.getClassLoader();
        urlWMSCoordSys = FileUtil.changePathSeparator(loader.getResource("nxm/sys/cfg/wms_coord_sys.xml").toString(), "/");
    }
}

