/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.ShapeFile;
import nxm.sys.lib.Table;
import nxm.sys.libg.GeometricUtil;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Line;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.MPoint;
import nxm.sys.libg.Pix;
import nxm.sys.libg.Theme;
import nxm.sys.prim.plot;

public class LayerShape
extends Layer {
    public static final int COLORS_MONOCHROME = 1;
    public static final int COLORS_MOD_5 = 2;
    public static final int COLORS_MOD_N = 3;
    public static final int COLORS_MIN_ADJ = 4;
    public static final int COLORS_ON_SELECT = 5;
    public static final int COLORS_DEFAULT = 4;
    public static final String coloringModes = "Mono,Mod5,ModN,MinAdj,OnSelect";
    public static final Color DEFAULT_BORDER_COLOR = Color.lightGray;
    public static final Color DEFAULT_POINT_COLOR = MColor.getColor(0, 75, 0);
    private Color colorBorder = DEFAULT_BORDER_COLOR;
    private boolean needsColorUpdate = true;
    private int coloringMode = 4;
    private int contrast = 50;
    private int brightness = 50;
    private int alpha = 255;
    private int selectedIndex = -1;
    private Color[] adjustedColors = null;
    public float[] fbuf;
    public int dim = 2;
    private ShapeFile.Shape[] shapes;
    private double[] dtmp = new double[6];
    private ShapeFile sf;
    private Pix pix;
    private ShapePix spix;
    private int maxPixels;
    private String label;
    private double xmin;
    private double ymin;
    private double xmax;
    private double ymax;
    private double lat;
    private double lon;
    private double tlreg = 10.0;
    private int debug = 0;

    public LayerShape() {
        this(8);
    }

    public LayerShape(int cmap) {
        super("SHAPE");
        this.setColorMap(cmap);
    }

    @Override
    protected void init(plot p, String layerName, int layerIndex, Layer oldLayer) {
        super.init(p, layerName, layerIndex, oldLayer);
        if (!Theme.getOption(4) || !Theme.getOption(32)) {
            this.MP.setOptions("+BS");
        }
    }

    @Override
    public int getDefaultView() {
        return 11;
    }

    @Override
    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        if (tab != null) {
            this.label = tab.getS("LABEL");
            int n = this.coloringMode = tab.get("COLOR") != null ? 1 : 4;
            if (this.label != null) {
                tab.remove("LABEL");
            } else {
                this.label = "";
            }
            if (tab.get("DEBUG") != null) {
                this.debug = tab.getL("DEBUG", -1);
                tab.remove("DEBUG");
            }
        } else {
            this.label = "";
            this.coloringMode = 4;
        }
        super.setFile(pf);
        this.sf = (ShapeFile)pf;
        if (this.sf.shapeType == 1) {
            this.line.setRadius(3);
            this.line.setSymbol("CROSS");
            this.line.getSymbol().setSize(4);
            this.line.setType(33);
            this.line.setColor(DEFAULT_POINT_COLOR);
            if (this.coloringMode == 1) {
                this.line.setColor(Color.RED);
            }
            if (this.coloringMode == 4) {
                this.coloringMode = 3;
            }
        } else if (this.sf.shapeType == 3 && this.coloringMode == 4) {
            this.coloringMode = 3;
        }
        this.xmin = 0.0;
        this.xmax = 0.0;
        this.ymin = 0.0;
        this.ymax = 0.0;
        this.lat = -1.0;
        this.lon = -1.0;
        this.needsColorUpdate = true;
        return true;
    }

    @Override
    public int getData(int mode) {
        if (this.pf == null || !this.pf.isOpen() || this.ndata > 0) {
            return 0;
        }
        this.shapes = this.sf.getShapes();
        this.ndata = this.shapes.length;
        for (int i = 0; i < this.ndata; ++i) {
            if (this.shapes[i].maxPartLength <= this.maxPixels) continue;
            this.maxPixels = this.shapes[i].maxPartLength;
        }
        this.pix = new Pix(this.maxPixels, 0);
        if (this.label.length() > 0) {
            String[] labs = this.sf.dbf.getElementArray(this.label);
            if (labs != null) {
                if (labs.length != this.ndata) {
                    this.sf.M.warning("Number of DBF fields " + labs.length + " does not match shapes " + this.ndata);
                    this.label = "";
                } else {
                    for (int i = 0; i < this.ndata; ++i) {
                        this.shapes[i].label = labs[i];
                    }
                }
            } else {
                this.sf.M.warning("Could not find label field: " + this.label);
                this.label = "";
            }
        }
        this.needsColorUpdate = true;
        return 1;
    }

    @Override
    public void process() {
    }

    @Override
    public void findRange() {
        this.x1 = this.sf.x1;
        this.x2 = this.sf.x2;
        this.y1 = this.sf.y1;
        this.y2 = this.sf.y2;
        this.a1 = this.y1;
        this.a2 = this.y2;
    }

    @Override
    public void draw(int flag) {
        super.draw(flag);
        if (this.MP.gc == null) {
            return;
        }
        if (this.needsColorUpdate) {
            this.updateColors();
        }
        boolean recalcPolys = false;
        Line lin = this.line.copy();
        Color color = this.colors[1];
        if (this.ndata <= 0) {
            return;
        }
        if (this.label.length() > 0) {
            if (this.MP.view == 13 && (this.lat != this.MP.viewGeo.lat || this.lon != this.MP.viewGeo.lon)) {
                this.lat = this.MP.viewGeo.lat;
                this.lon = this.MP.viewGeo.lon;
                recalcPolys = true;
            }
            if (this.xmin != this.MP.rx1 || this.xmax != this.MP.rx2 || this.ymin != this.MP.ry1 || this.ymax != this.MP.ry2) {
                this.xmin = this.MP.rx1;
                this.xmax = this.MP.rx2;
                this.ymin = this.MP.ry1;
                this.ymax = this.MP.ry2;
                recalcPolys = true;
            }
            if (recalcPolys) {
                if (this.debug > 0) {
                    System.out.println("Creating new ShapePix, must recalc polys");
                }
                this.spix = new ShapePix(this.MP.ix1, this.MP.iy1, this.MP.ix2, this.MP.iy2, this.ndata, this.debug);
            }
        }
        for (int ishape = 0; ishape < this.ndata && !this.MP.cancel; ++ishape) {
            boolean added;
            ShapeFile.Shape s = this.shapes[ishape];
            if (s.shapeType == 1) {
                double vreg;
                this.MP.gc.setColor(this.getColor());
                if (this.MP.is2D) {
                    double vreg2;
                    int ix = this.MP.getix(s.x1);
                    int iy = this.MP.getiy(s.y1);
                    lin.getSymbol().draw(ix, iy, this.MP.gc);
                    if (this.label.length() > 0 && s.label != null && (vreg2 = Math.min(this.MP.rx2 - this.MP.rx1, this.MP.ry2 - this.MP.ry1)) <= this.tlreg) {
                        int r = lin.getRadius();
                        int xoff = 2 + r;
                        this.MP.gc.drawString(s.label, ix + xoff, iy + r);
                    }
                }
                if (this.MP.view != 13 && this.MP.view != 9) continue;
                this.dtmp[0] = s.x1;
                this.dtmp[1] = s.y1;
                this.MP.viewer.rwc2pix(this.dtmp, 0, 3, 1, this.pix);
                lin.getSymbol().draw(this.pix.x[0], this.pix.y[0], this.MP.gc);
                if (this.label.length() <= 0 || s.label == null || !((vreg = 50.0 * Math.min(this.MP.rx2 - this.MP.rx1, this.MP.ry2 - this.MP.ry1)) <= this.tlreg)) continue;
                int r = lin.getRadius();
                int xoff = 2 + r;
                this.MP.gc.drawString(s.label, this.pix.x[0] + xoff, this.pix.y[0] + r);
                continue;
            }
            if (s.shapeType == 0) continue;
            int[] bbox = new int[]{0, 0, 0, 0};
            for (int ipart = 0; ipart < s.numParts; ++ipart) {
                int j = s.parts[ipart];
                int npts = ipart < s.numParts - 1 ? s.parts[ipart + 1] - j : s.numPoints - j;
                if (this.MP.view == 14) {
                    if (s.x1 >= this.MP.rx2 || s.y1 >= this.MP.ry2 || s.x2 <= this.MP.rx1 && s.x1 + (double)MPlot.LONGITUDE_RANGE >= this.MP.rx2 || s.y2 <= this.MP.ry1) {
                        continue;
                    }
                } else if (this.MP.is2D) {
                    if (s.x1 >= this.MP.rx2 || s.y1 >= this.MP.ry2 || s.x2 <= this.MP.rx1 || s.y2 <= this.MP.ry1) {
                        continue;
                    }
                } else if (this.MP.view == 13 || this.MP.view == 9) {
                    this.dtmp[0] = s.x1;
                    this.dtmp[1] = s.y1;
                    this.dtmp[2] = s.x2;
                    this.dtmp[3] = s.y2;
                    int i = this.MP.viewer.rwc2pix(this.dtmp, 0, this.dim, 2, this.MP.tpix);
                    if (i == 0 && this.dim == 2) {
                        this.dtmp[0] = s.x1;
                        this.dtmp[1] = s.y2;
                        this.dtmp[2] = s.x2;
                        this.dtmp[3] = s.y1;
                        i = this.MP.viewer.rwc2pix(this.dtmp, 0, this.dim, 2, this.MP.tpix);
                    }
                    if (i == 0) continue;
                }
                if (s.getColor() != null) {
                    color = this.adjustedColors[ishape];
                }
                if (s.shapeType == 5) {
                    lin.setType(1);
                    lin.setColor(this.colorBorder);
                    if (color != null && this.alpha != 0) {
                        lin.setType(9);
                        lin.setFillColor(color);
                    }
                } else {
                    lin.setType(1);
                    lin.setColor(color);
                }
                if (this.MP.view != 14) {
                    int off = j * this.dim;
                    while (npts > 0) {
                        int n = this.MP.viewer.rwc2pix(s.points, off, this.dim, npts, this.pix);
                        bbox = this.pix.getXYMinMax(bbox, n);
                        if (this.MP.xvy) {
                            this.MP.drawPixels(this.pix.y, this.pix.x, n, lin);
                        } else {
                            this.MP.drawPixels(this.pix.x, this.pix.y, n, lin);
                        }
                        if (this.pix.save) {
                            if (this.MP.xvy) {
                                this.MP.drawPixels(this.pix.sy, this.pix.sx, this.pix.n, lin);
                            } else {
                                this.MP.drawPixels(this.pix.sx, this.pix.sy, this.pix.n, lin);
                            }
                        }
                        npts -= this.pix.off;
                        off += this.dim * this.pix.off;
                    }
                    continue;
                }
                double[] rwcView = new double[]{this.MP.rx1, this.MP.ry1, this.MP.rx2, this.MP.ry2};
                double[] rwcViewShift = new double[]{this.MP.rx1 - 360.0, this.MP.rx2 - 360.0};
                int off = j * this.dim;
                while (npts > 0) {
                    double[] shapeBounds = new double[]{s.x1, s.y1, s.x2, s.y2};
                    if (GeometricUtil.boxIntersect(shapeBounds, rwcView) || GeometricUtil.xIntersect(shapeBounds, rwcViewShift)) {
                        int n = this.MP.viewer.rwc2pix(s.points, off, this.dim, npts, this.pix, lin.isTypeSet(8));
                        bbox = this.pix.getXYMinMax(bbox, n);
                        if (this.MP.xvy) {
                            this.MP.drawPixels(this.pix.y, this.pix.x, n, lin);
                        } else {
                            this.MP.drawPixels(this.pix.x, this.pix.y, n, lin);
                        }
                        if (this.pix.save) {
                            if (this.MP.xvy) {
                                this.MP.drawPixels(this.pix.sy, this.pix.sx, this.pix.n, lin);
                            } else {
                                this.MP.drawPixels(this.pix.sx, this.pix.sy, this.pix.n, lin);
                            }
                            this.pix.save = false;
                        }
                    }
                    npts -= this.pix.off;
                    off += this.dim * this.pix.off;
                }
            }
            if (!recalcPolys || !(added = this.spix.addPoly(bbox, ishape)) || this.debug <= 0) continue;
            System.out.println("Added: " + s.label);
        }
    }

    private void updateAdjustedColors() {
        if (this.shapes == null) {
            this.needsColorUpdate = true;
            return;
        }
        for (int i = 0; i < this.shapes.length; ++i) {
            Color color = this.shapes[i].getColor();
            int rgb = color.getRGB();
            int x = MColor.adjustColor(rgb, this.contrast, this.brightness, this.alpha, false);
            this.adjustedColors[i] = new Color(x, true);
        }
    }

    public double getTLReg() {
        return this.tlreg;
    }

    public void setTLReg(double value) {
        this.tlreg = value;
    }

    @Override
    public String getReadOut(Position mp) {
        int i;
        int npts;
        int j;
        ShapeFile.Shape s;
        boolean recalcPolys = false;
        if (this.label.length() == 0 || this.spix == null || this.ndata <= 0) {
            return null;
        }
        if (this.MP.view == 13 && (this.lat != this.MP.viewGeo.lat || this.lon != this.MP.viewGeo.lon)) {
            this.lat = this.MP.viewGeo.lat;
            this.lon = this.MP.viewGeo.lon;
            recalcPolys = true;
        }
        if (this.xmin != this.MP.rx1 || this.xmax != this.MP.rx2 || this.ymin != this.MP.ry1 || this.ymax != this.MP.ry2) {
            this.xmin = this.MP.rx1;
            this.xmax = this.MP.rx2;
            this.ymin = this.MP.ry1;
            this.ymax = this.MP.ry2;
            recalcPolys = true;
        }
        if (recalcPolys) {
            if (this.debug > 0) {
                System.out.println("getReadOut: Creating new ShapePix, must recalc polys");
            }
            this.spix = new ShapePix(this.MP.ix1, this.MP.iy1, this.MP.ix2, this.MP.iy2, this.ndata, this.debug);
            for (int ishape = 0; ishape < this.ndata; ++ishape) {
                s = this.shapes[ishape];
                if (s.shapeType == 1 || s.shapeType == 0) continue;
                int[] bbox = new int[]{0, 0, 0, 0};
                for (int ipart = 0; ipart < s.numParts; ++ipart) {
                    j = s.parts[ipart];
                    npts = ipart < s.numParts - 1 ? s.parts[ipart + 1] - j : s.numPoints - j;
                    if (this.MP.is2D) {
                        if (s.x1 >= this.MP.rx2 || s.y1 >= this.MP.ry2 || s.x2 <= this.MP.rx1 || s.y2 <= this.MP.ry1) {
                            continue;
                        }
                    } else if (this.MP.view == 13 || this.MP.view == 9) {
                        this.dtmp[0] = s.x1;
                        this.dtmp[1] = s.y2;
                        this.dtmp[2] = s.x2;
                        this.dtmp[3] = s.y1;
                        i = this.MP.viewer.rwc2pix(this.dtmp, 0, this.dim, 2, this.MP.tpix);
                        if (i == 0 && this.dim == 2) {
                            this.dtmp[0] = s.x1;
                            this.dtmp[1] = s.y2;
                            this.dtmp[2] = s.x2;
                            this.dtmp[3] = s.y1;
                            i = this.MP.viewer.rwc2pix(this.dtmp, 0, this.dim, 2, this.MP.tpix);
                        }
                        if (i == 0) continue;
                    }
                    int off = j * this.dim;
                    while (npts > 0) {
                        int n = this.MP.viewer.rwc2pix(s.points, off, this.dim, npts, this.pix);
                        bbox = this.pix.getXYMinMax(bbox, ishape);
                        npts -= this.pix.off;
                        off += this.dim * this.pix.off;
                    }
                }
                boolean added = this.spix.addPoly(bbox, ishape);
                if (!added || this.debug <= 0) continue;
                System.out.println("Added: " + s.label);
            }
        }
        if (this.MP.view == 13) {
            this.dtmp[0] = mp.lon;
            this.dtmp[1] = mp.lat;
        } else {
            this.dtmp[0] = mp.x;
            this.dtmp[1] = mp.y;
        }
        MPoint pt = new MPoint();
        this.MP.viewer.rwc2pix(this.dtmp, pt);
        if (this.debug > 2) {
            System.out.println("GetReadOut Point  [ " + mp + " ] = [" + pt.x + "," + pt.y + "]");
        }
        for (i = 0; i < this.shapes.length; ++i) {
            s = this.shapes[i];
            if (this.debug > 2) {
                System.out.println("checking : " + s.label);
            }
            for (int ipart = 0; ipart < s.numParts; ++ipart) {
                j = s.parts[ipart];
                int off = j * this.dim;
                npts = ipart < s.numParts - 1 ? s.parts[ipart + 1] - j : s.numPoints - j;
                int n = this.MP.viewer.rwc2pix(s.points, off, this.dim, npts, this.pix);
                Polygon p = new Polygon(this.pix.x, this.pix.y, n);
                if (!p.contains(pt.x, pt.y)) continue;
                return s.label;
            }
        }
        return null;
    }

    private void updateColors() {
        if (this.shapes == null || !this.needsColorUpdate || this.alpha == 0) {
            return;
        }
        switch (this.coloringMode) {
            case 1: {
                for (int i = 0; i < this.shapes.length; ++i) {
                    this.shapes[i].setColor(this.colors[1]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.shapes.length; ++i) {
                    this.shapes[i].setColor(this.colors[i % 5 + 1]);
                }
                break;
            }
            case 3: {
                int n = this.colors.length - 1;
                for (int i = 0; i < this.shapes.length; ++i) {
                    this.shapes[i].setColor(this.colors[i % n + 1]);
                }
                break;
            }
            case 4: {
                this.updateAdjColors();
                break;
            }
            case 5: {
                for (int i = 0; i < this.shapes.length; ++i) {
                    this.shapes[i].setColor(this.colors[0]);
                }
                if (this.selectedIndex < 0 || this.selectedIndex >= this.shapes.length) break;
                this.shapes[this.selectedIndex].setColor(this.colors[1]);
                break;
            }
            default: {
                this.warning("LayerShape: Unknown coloring mode given (" + this.coloringMode + "), using default.");
                this.coloringMode = 4;
                this.updateColors();
            }
        }
        if (this.adjustedColors == null) {
            this.adjustedColors = new Color[this.shapes.length];
        }
        this.updateAdjustedColors();
        this.needsColorUpdate = false;
    }

    private void updateAdjColors() {
        int i;
        double proximityFactor = 10.0;
        for (int i2 = 0; i2 < this.shapes.length; ++i2) {
            this.shapes[i2].setColor(null);
        }
        HashMap points = new HashMap();
        ArrayList[] neighbors = new ArrayList[this.shapes.length];
        for (i = 0; i < this.shapes.length; ++i) {
            for (int j = 0; this.shapes[i].points != null && j < this.shapes[i].points.length; j += 2) {
                int x = (int)(proximityFactor * this.shapes[i].points[j + 0]);
                int y = (int)(proximityFactor * this.shapes[i].points[j + 1]);
                Point point = new Point(x, y);
                ArrayList<Integer> matches = (ArrayList<Integer>)points.get(point);
                Integer index = i;
                if (matches == null) {
                    matches = new ArrayList<Integer>();
                    points.put(point, matches);
                } else {
                    if (neighbors[i] == null) {
                        neighbors[i] = new ArrayList();
                    }
                    for (Object e : matches) {
                        if (e.equals(index) || neighbors[i].contains(e)) continue;
                        neighbors[i].add(e);
                    }
                }
                matches.add(index);
            }
        }
        for (i = this.shapes.length - 1; i >= 0; --i) {
            if (this.shapes[i].getColor() != null) continue;
            this.colorAdj(neighbors, i, null);
        }
    }

    private boolean colorAdj(ArrayList<Object>[] neighbors, int index, Color badColor) {
        for (int i = 1; i < this.colors.length; ++i) {
            if (this.colors[i] == badColor) continue;
            boolean ok = true;
            if (neighbors[index] != null) {
                for (int j = 0; j < neighbors[index].size() && ok; ++j) {
                    int next = ((Number)neighbors[index].get(j)).intValue();
                    ok = this.shapes[next].getColor() == null ? this.colorAdj(neighbors, next, this.colors[i]) : this.shapes[next].getColor() != this.colors[i];
                }
            }
            if (!ok) continue;
            this.shapes[index].setColor(this.colors[i]);
            return true;
        }
        this.shapes[index].setColor(this.colors[this.colors.length - 1]);
        return false;
    }

    public void setColoringMode(int mode) {
        if (this.coloringMode != mode) {
            this.coloringMode = mode;
            this.needsColorUpdate = true;
            this.refresh();
        }
    }

    public void setColoringMode(String mode) {
        int i = mode.toUpperCase().startsWith("DEF") ? 4 : Parser.find(coloringModes, mode, 4);
        if (i <= 0) {
            this.warning("LayerShape: Unknown coloring mode (" + mode + "), using default.");
            this.warning("LayerShape: Valid coloring modes are Mono,Mod5,ModN,MinAdj,OnSelect.");
            i = 4;
        }
        this.setColoringMode(i);
    }

    public int getColoringMode() {
        return this.coloringMode;
    }

    @Override
    public void setColorMap(Color[] colors) {
        super.setColorMap(colors);
        this.needsColorUpdate = true;
        this.refresh();
    }

    public void setColorTable(Table colTab) {
        Table.Iterator ti = colTab.iterator();
        while (ti.getNext()) {
            String key = ti.getKey();
            Object obj = ti.getValue();
            try {
                if (key.equals("POINT")) {
                    this.line.setColor(MColor.getColor(obj));
                } else if (key.equals("BORDER")) {
                    this.colorBorder = MColor.getColor(obj);
                } else {
                    this.warning(" " + this + " setColorTable: Invalid color key " + key);
                }
                this.refresh();
            }
            catch (Exception e) {
                this.warning("Could not convert " + obj + " to a color");
            }
        }
    }

    public Table getColorTable() {
        return this.getColorTable(false);
    }

    public Table getColorTable(boolean doColorObj) {
        Table colTab = new Table();
        if (doColorObj) {
            colTab.put("POINT", (Object)this.getColor());
            colTab.put("BORDER", (Object)this.colorBorder);
        } else {
            colTab.put("POINT", (Object)MColor.toString(this.getColor()));
            colTab.put("BORDER", (Object)MColor.toString(this.colorBorder));
        }
        return colTab;
    }

    public void setContrast(int percent) {
        if (percent != this.contrast) {
            this.contrast = Math.max(0, Math.min(100, percent));
            this.updateAdjustedColors();
            this.refresh();
        }
    }

    public float getContrast() {
        return this.contrast;
    }

    public void setBrightness(int percent) {
        if (percent != this.brightness) {
            this.brightness = Math.max(0, Math.min(100, percent));
            this.updateAdjustedColors();
            this.refresh();
        }
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setOpaqueness(int percent) {
        int val = MColor.pct2alpha(percent);
        this.setAlpha(val);
    }

    public int getOpaqueness() {
        return MColor.alpha2pct(this.alpha);
    }

    public void setAlpha(int newAlpha) {
        if (newAlpha != this.alpha) {
            this.alpha = Math.max(0, Math.min(255, newAlpha));
            this.updateAdjustedColors();
            this.refresh();
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setSelectedIndex(int index) {
        if (this.selectedIndex != index) {
            this.selectedIndex = index;
            this.needsColorUpdate = true;
            this.refresh();
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedValue(String value) {
        this.setSelectedValue(this.label, value, true);
    }

    public void setSelectedValue(String tag, String value, boolean ignoreCase) {
        int index = -1;
        if (tag.length() <= 0) {
            this.sf.M.warning("Can not select value '" + value + "', no tag/label specified.");
        } else {
            String[] labs = this.sf.dbf.getElementArray(tag);
            if (labs != null) {
                if (labs.length != this.ndata) {
                    this.sf.M.warning("Number of DBF fields " + labs.length + " does not match shapes " + this.ndata);
                } else {
                    for (int i = 0; i < this.ndata && index == -1; ++i) {
                        if (!labs[i].equals(value) && (!ignoreCase || !labs[i].equalsIgnoreCase(value))) continue;
                        index = i;
                    }
                }
            } else {
                this.sf.M.warning("Could not find label field: " + tag);
            }
        }
        this.setSelectedIndex(index);
    }

    public static Layer getLayer() {
        return new LayerShape();
    }

    private static class ShapePix {
        int npoly;
        int xmin;
        int xmax;
        int ymin;
        int ymax;
        int[][] v;
        Rectangle[] r;
        private int debug = 0;

        public ShapePix(int ix1, int iy1, int ix2, int iy2, int n, int dbg) {
            this.debug = dbg;
            int x = ix2 - ix1 + 1;
            int y = iy2 - iy1 + 1;
            this.xmin = ix1;
            this.xmax = ix2;
            this.ymin = iy1;
            this.ymax = iy2;
            this.npoly = n;
            this.v = new int[4][this.npoly + 1];
            this.r = new Rectangle[4];
            int k = 0;
            int dw = x / 2;
            int dh = y / 2;
            int ys = iy1;
            for (int i = 0; i < 2; ++i) {
                int xs = ix1;
                for (int j = 0; j < 2 && k < this.r.length && k < this.v.length; ++k, ++j) {
                    this.r[k] = new Rectangle(xs, ys, dw, dh);
                    if (this.debug > 0) {
                        System.out.println("Creating rectangle: " + k + " = [ " + xs + "," + ys + "] width = " + dw + ", height = " + dh);
                    }
                    this.v[k][0] = 1;
                    xs += dw;
                }
                ys += dh;
            }
        }

        public boolean addPoly(int[] bbox, int idx) {
            int x1 = bbox[0];
            int y1 = bbox[1];
            int x2 = bbox[2];
            int y2 = bbox[3];
            boolean retVal = false;
            int h = Math.abs(y2 - y1 + 1);
            int w = Math.abs(x2 - x1 + 1);
            Rectangle test = new Rectangle(x1, y1, w, h);
            if (this.debug > 0) {
                System.out.println("poly " + idx + " x1 = " + x1 + ", y1 = " + y1 + ", x2 = " + x2 + ", y2 = " + y2);
            }
            for (int i = 0; i < 4 && i < this.v.length && i < this.r.length; ++i) {
                if (!test.intersects(this.r[i])) continue;
                this.v[i][this.v[i][0]] = idx;
                int[] nArray = this.v[i];
                nArray[0] = nArray[0] + 1;
                if (this.debug > 0) {
                    System.out.println("adding poly " + idx + " to " + i + ", total = " + this.v[i][0] + " max = " + this.npoly);
                }
                retVal = true;
            }
            return retVal;
        }

        public int[] getIndexArray(int ix, int iy) {
            if (ix < this.xmin || ix > this.xmax || iy < this.ymin || iy > this.ymax) {
                return null;
            }
            for (int i = 0; i < 4 && i < this.r.length && i < this.v.length; ++i) {
                if (!this.r[i].contains(ix, iy)) continue;
                return this.v[i];
            }
            return null;
        }

        public void setDebug(int d) {
            this.debug = d;
        }
    }
}

