/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import nxm.sys.lib.MidasException;
import nxm.sys.libg.LayerMulti;
import nxm.sys.libg.Line;
import nxm.sys.libg.MColor;

public class LayerScatter
extends LayerMulti {
    protected int X = -1;
    protected int Y = -1;

    public LayerScatter() {
        super("Scatter");
        this.setTraces("|X|Y|");
        this.line.setColor(MColor.getColorByIndex(1));
    }

    public void setX(String value) {
        this.setTraces("|" + value + "|" + this.getY() + "|");
        if (this.MP != null) {
            this.MP.setXAxisLabel(value);
        }
    }

    public void setY(String value) {
        this.setTraces("|" + this.getX() + "|" + value + "|");
        if (this.MP != null) {
            this.MP.setYAxisLabel(value);
        }
    }

    public String getX() {
        String traces = this.getTraces();
        int idx = traces.indexOf(124, 1);
        return traces.substring(1, idx);
    }

    public String getY() {
        String traces = this.getTraces();
        int idx = traces.indexOf(124, 1);
        return traces.substring(idx + 1, traces.length() - 1);
    }

    @Override
    public void setTraces(String traces) {
        if (traces == null || traces.equals("*")) {
            super.setTraces("|X|Y|");
        } else {
            if (!traces.startsWith("|")) {
                traces = "|" + traces;
            }
            if (!traces.endsWith("|")) {
                traces = traces + "|";
            }
            int i = traces.indexOf(124, 1);
            int j = traces.lastIndexOf(124, traces.length() - 2);
            if (i < 0 || i != j) {
                throw new MidasException("Illegal column/trace specification for scatter plot '" + traces + "'. Expected form of '|X|Y|'");
            }
            super.setTraces(traces);
        }
    }

    @Override
    protected void updateRecData(double[][] dbuf, int size) {
        String xName = this.getX();
        String yName = this.getY();
        this.X = -1;
        this.Y = -1;
        for (int col = 0; col < dbuf.length; ++col) {
            if (!this.show(col)) {
                dbuf[col] = null;
            } else if (dbuf[col] == null) {
                dbuf[col] = new double[size];
            } else if (dbuf[col].length != size) {
                dbuf[col] = new double[size];
            }
            if (this.X < 0 && xName.equals(this.recNames[col])) {
                this.X = col;
            }
            if (this.Y >= 0 || !yName.equals(this.recNames[col])) continue;
            this.Y = col;
        }
        if (this.X < 0 && this.Y < 0) {
            this.warning("Could not find column X='" + xName + "' or Y='" + yName + "'");
            this.X = 0;
            this.Y = 0;
            dbuf[0] = new double[size];
        } else if (this.X < 0) {
            this.warning("Could not find column X='" + xName + "'");
            this.X = this.Y;
        } else if (this.Y < 0) {
            this.warning("Could not find column Y='" + yName + "'");
            this.Y = this.X;
        }
    }

    @Override
    public void findRange() {
        int npts;
        super.findRange();
        int n = npts = this.ndata > this.size && this.realtime ? this.size : this.ndata;
        if (npts < 1) {
            this.x1 = 0.0;
            this.x2 = 1.0;
            this.y1 = 0.0;
            this.y2 = 1.0;
        } else if (npts == 1) {
            this.x1 = this.recData[this.X][0] - 0.5;
            this.x2 = this.recData[this.X][0] + 0.5;
            this.y1 = this.recData[this.Y][0] - 0.5;
            this.y2 = this.recData[this.Y][0] + 0.5;
        } else {
            this.x1 = this.recData[this.X][0];
            this.x2 = this.recData[this.X][0];
            this.y1 = this.recData[this.Y][0];
            this.y2 = this.recData[this.Y][0];
            for (int i = 1; i < npts; ++i) {
                this.x1 = Math.min(this.x1, this.recData[this.X][i]);
                this.x2 = Math.max(this.x2, this.recData[this.X][i]);
                this.y1 = Math.min(this.y1, this.recData[this.Y][i]);
                this.y2 = Math.max(this.y2, this.recData[this.Y][i]);
            }
        }
        this.z1 = 0.0;
        this.z2 = 1.0;
        this.a1 = this.y1;
        this.a2 = this.y2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(int flag) {
        if (!this.lock()) {
            return;
        }
        try {
            int i21;
            this.clearNeedRefresh();
            this.isReset = false;
            Line lin = this.line.copy();
            int npts = this.ndata > this.size && this.realtime ? this.size : this.ndata;
            int i1 = 0;
            int i2 = npts;
            if (this.size > 0) {
                i2 = this.frame;
            }
            if ((i21 = i2 - i1) <= 0) {
                return;
            }
            double[] dbuf = new double[npts * 2];
            int i = 0;
            int j = 0;
            while (i < npts) {
                dbuf[j] = this.recData[this.X][i];
                dbuf[j + 1] = this.recData[this.Y][i];
                ++i;
                j += 2;
            }
            this.MP.drawLine(dbuf, 0, 2, this.ndata, lin, 32, false);
            this.frameDrawn = true;
        }
        finally {
            this.unlock();
        }
    }
}

