/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.image.BufferedImage;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.libg.LayerMap;

public class LayerNMS
extends LayerMap {
    private static final String PROTOCOL = "NMS_1";
    private static final boolean CHECK_LENGTH = true;
    private static final int MAX_TRYS = 3;
    protected String options = "DEF";
    protected String optionsStr = "DEF";
    protected String background = "NONE";

    public LayerNMS() {
        super("NMS");
        this.setDownloadThreads(8);
    }

    @Override
    protected boolean getDefUseTile() {
        return true;
    }

    @Override
    protected int getDefTileLevels() {
        return 32;
    }

    @Override
    protected int getDefTileWidth() {
        return 256;
    }

    @Override
    protected int getDefTileHeight() {
        return 256;
    }

    @Override
    public void setUseTiles(boolean tile) {
        if (!tile) {
            this.warn("This service requires the use of tiles. UseTiles can not be changed to false.");
        }
        super.setUseTiles(true);
    }

    @Override
    public boolean isConnected() {
        return this.getURL() != null;
    }

    public void setBackground(String bg) {
        if (!bg.equalsIgnoreCase(this.background)) {
            this.background = bg;
            this.refresh();
        }
    }

    public String getBackground() {
        return this.background;
    }

    public void setOptions(String opts) {
        if (!opts.equalsIgnoreCase(this.options)) {
            Object[] optItems = opts.toUpperCase().split("[|]");
            for (int i = 0; i < optItems.length; ++i) {
                if (optItems[i].startsWith("-")) {
                    optItems[i] = "NO" + ((String)optItems[i]).substring(1);
                    continue;
                }
                if (!((String)optItems[i]).startsWith("+")) continue;
                optItems[i] = "ADD" + ((String)optItems[i]).substring(1);
            }
            this.options = opts;
            this.optionsStr = StringUtil.join(optItems, "+");
            this.refresh();
        }
    }

    public String getOptions() {
        return this.options;
    }

    @Override
    protected int drawArea(double minLon, double maxLon, double minLat, double maxLat, int width, int height, boolean hiRes, String pos) {
        String url = this.mapServer + "?ver=" + PROTOCOL + "&background=" + this.background + "&options=" + this.optionsStr + "&v=3&t=" + pos;
        BufferedImage img = this.requestImage(url, 3, true, width, height);
        if (img != null) {
            this.drawImage(img, minLon, maxLon, minLat, maxLat);
        }
        return 0;
    }

    @Override
    public Table getConfig() {
        Table tbl = super.getConfig();
        tbl.put("BACKGROUND", (Object)this.getBackground());
        tbl.put("OPTIONS", (Object)this.getOptions());
        return tbl;
    }
}

