/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Table;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Line;
import nxm.sys.libg.MColor;

public class LayerMulti
extends Layer {
    protected static final int OVERLAP = 1;
    protected double[][] recData;
    protected String[] recNames;
    protected String showColumns = "*";
    protected boolean showColsChanged;
    protected Table[] rowBuf;
    protected int lastRow;
    protected int recIndex;
    protected int recSize;
    protected boolean frameReady;
    protected boolean frameDrawn;
    protected double minY = 0.0;
    protected double maxY = 1.0;
    protected boolean rereadFile;
    private volatile boolean lock = false;

    public LayerMulti() {
        this("Multi");
    }

    protected LayerMulti(String name) {
        super(name);
    }

    private LayerMulti(int ncolors) {
        this();
        this.setColorMap(6, ncolors);
    }

    @Override
    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        int ps;
        DataFile df;
        this.setFile(pf);
        if (this.pfnh == null) {
            this.warning("LayerMulti requires file to implement the PlotFileNH interface");
            return false;
        }
        int nels = (int)pf.getSize();
        int numRec = this.pfnh.getRecordDefCount();
        this.setXAxis(pf.getXStart(), pf.getXDelta());
        this.setColorMap(6, numRec);
        this.recData = new double[numRec][];
        this.recIndex = 0;
        String[] names = new String[numRec];
        for (int i = 0; i < numRec; ++i) {
            Table recDefTab = this.pfnh.getRecordDef(i);
            names[i] = recDefTab.getS("NAME");
        }
        this.setRecNames(names);
        this.showColsChanged = true;
        if (this.pfnh instanceof DataFile && (df = (DataFile)pf).isPipe() && (nels > (ps = (int)((double)df.getPipeSize() / df.getBPE())) || nels == 0)) {
            nels = ps;
        }
        int lps = MA.getL("/LPS", nels);
        int lpb = MA.getL("/LPB", -1);
        if (this.realtime) {
            lpb = lps;
        } else if (lpb < 0) {
            lpb = Math.min(lps, 1024);
        }
        int tl = lpb;
        this.rowBuf = new Table[tl + 1];
        this.setSize(lpb);
        this.setFrame(lps);
        this.isPaged = !this.realtime && lpb < lps;
        this.frameReady = false;
        this.frameDrawn = false;
        this.lastRow = 0;
        return true;
    }

    protected boolean getDrawFrame() {
        return this.frameReady && !this.frameDrawn;
    }

    @Override
    public boolean getNeedRefresh() {
        return super.getNeedRefresh();
    }

    public void setColorTable(Table colorTab) {
        if (colorTab == null || colorTab.isEmpty()) {
            return;
        }
        Color defaultColor = null;
        Object globalDefault = colorTab.getKey("_GLOBAL_");
        if (globalDefault != null) {
            defaultColor = MColor.getColor(globalDefault);
        }
        for (int i = 0; i < this.recNames.length && i < this.colors.length + 1; ++i) {
            String colname = this.recNames[i];
            Color color = defaultColor;
            if (!colname.equals("_" + i + "_") && colorTab.containsKey(colname)) {
                color = MColor.getColor(colorTab.get(colname));
            }
            if (color == null) continue;
            this.colors[i + 1] = color;
        }
        this.refresh();
    }

    public Table getColorTable() {
        Table tbl = new Table();
        for (int i = 0; i < this.recNames.length && i < this.colors.length + 1; ++i) {
            String colname = this.recNames[i];
            if (colname.equals("_" + i + "_")) continue;
            tbl.setKey(colname, MColor.toString(this.colors[i + 1]));
        }
        return tbl;
    }

    public final void setColumns(String columns) {
        this.setTraces(columns);
    }

    public final String getColumns() {
        return this.getTraces();
    }

    public void setTraces(String traces) {
        if (traces == null) {
            traces = "*";
        }
        if (!traces.equals("*")) {
            if (!traces.startsWith("|")) {
                traces = "|" + traces;
            }
            if (!traces.endsWith("|")) {
                traces = traces + "|";
            }
        }
        if (!traces.equals(this.showColumns)) {
            this.showColumns = traces;
            this.showColsChanged = true;
            this.refresh();
        }
    }

    public String getTraces() {
        return this.showColumns;
    }

    protected void setRecNames(String[] names) {
        if (names == null) {
            names = new String[]{};
        }
        this.recNames = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.recNames[i] = names[i] == null ? "_" + i + "_" : (names[i].length() == 0 ? "_" + i + "_" : names[i]);
        }
    }

    protected boolean show(int col) {
        if (this.showColumns.equals("*")) {
            return true;
        }
        if (col < this.recNames.length && this.showColumns.indexOf("|" + this.recNames[col] + "|") >= 0) {
            return true;
        }
        return this.showColumns.indexOf("|_" + col + "_|") >= 0;
    }

    protected void updateRecData(double[][] buf, int size) {
        for (int col = 0; col < buf.length; ++col) {
            if (!this.show(col)) {
                buf[col] = null;
                continue;
            }
            if (buf[col] == null) {
                buf[col] = new double[size];
                continue;
            }
            if (buf[col].length == size) continue;
            buf[col] = new double[size];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getData(int mode) {
        int stat = 0;
        if (this.pf == null || !this.pf.isOpen() || this.rowBuf == null || this.isDone || this.getDrawFrame()) {
            return stat;
        }
        if (!this.lock()) {
            return stat;
        }
        try {
            this.frameReady = false;
            this.frameDrawn = false;
            if (this.rereadFile && !this.realtime) {
                this.pf.seek(0.0);
                this.ndata = 0;
                this.rereadFile = false;
            }
            double avail = this.pf.avail();
            int ndo = (int)Math.min(avail, (double)(this.rowBuf.length - 1));
            this.fseek = this.pf.seek();
            if (ndo > 0) {
                int count = 0;
                if (this.fseek > 0.0 && this.rowBuf[this.lastRow] != null && !this.realtime) {
                    this.rowBuf[count++].merge(this.rowBuf[this.lastRow]);
                    this.fseek -= 1.0;
                }
                for (int i = 0; i < ndo; ++i) {
                    if (this.rowBuf[count] == null) {
                        this.rowBuf[count] = new Table(3, 0);
                    }
                    this.rowBuf[count].clear();
                    this.pfnh.readDataTable(this.rowBuf[count]);
                    ++count;
                }
                this.lastRow = count - 1;
                this.process(count);
                stat = this.getNeedRefresh() ? 1 : (this.isReset ? 1 : (this.isPaged ? 2 : this.defmode));
                this.frameReady = true;
            } else if (this.isPaged) {
                this.pf.seek(this.pf.getSize());
                this.setXStart(this.pf.getStart());
                this.ndata = 0;
            } else if (!this.realtime) {
                stat = 0;
            } else if (this.pf.isStream() && !this.pf.isStreaming()) {
                stat = -1;
            }
        }
        finally {
            this.unlock();
        }
        return stat;
    }

    protected synchronized boolean lock() {
        if (this.lock) {
            return false;
        }
        this.lock = true;
        return this.lock;
    }

    protected synchronized void unlock() {
        this.lock = false;
    }

    @Override
    public void process(int elem) {
        if (this.showColsChanged) {
            this.showColsChanged = false;
            this.updateRecData(this.recData, this.size + 1);
            if (!this.realtime) {
                this.ndata = 0;
            }
        }
        if (this.realtime) {
            this.recIndex = this.table2da(this.rowBuf, this.recIndex, elem, this.recData);
            this.ndata = this.recSize = Math.min(this.size + 1, this.recSize + elem);
        } else {
            this.table2da(this.rowBuf, 0, elem, this.recData);
            this.recSize = this.ndata = elem;
        }
        this.frameReady = true;
    }

    private int table2da(Table[] tabBuf, int start, int nrows, double[][] buffer) {
        boolean isFirst = this.fseek == 0.0;
        int end = start;
        for (int col = 0; col < buffer.length; ++col) {
            double[] buf = buffer[col];
            if (buf == null) continue;
            int num = start;
            int len = buf.length;
            if (this.realtime) {
                --len;
            }
            for (int row = 0; row < nrows; ++row) {
                double val = this.convertData(tabBuf[row], this.recNames[col], this.MP.mode);
                buf[num++] = val;
                if (isFirst) {
                    this.minY = this.maxY = val;
                    isFirst = false;
                }
                if (val < this.minY) {
                    this.minY = val;
                }
                if (val > this.maxY) {
                    this.maxY = val;
                }
                if (num < len) continue;
                num = 0;
            }
            end = num;
        }
        return end;
    }

    private double convertData(Table tbl, String key, int mode) {
        int spa;
        double val0;
        Data dat = tbl.getData(key);
        if (dat == null) {
            val0 = tbl.getD(key);
            spa = 1;
        } else {
            Number num0 = dat.getNumber(0);
            if (num0 == null) {
                val0 = tbl.getD(key);
                spa = 1;
            } else {
                val0 = num0.doubleValue();
                spa = dat.spa;
            }
        }
        double scale = LayerMulti.getScaleFactor(spa, mode);
        if (spa == 1) {
            switch (mode) {
                case 7: {
                    return scale * Math.log(Math.max(1.0E-10, Math.abs(val0)));
                }
                case 8: {
                    return scale * Math.log(Math.max(1.0E-10, Math.abs(val0)));
                }
            }
            return val0;
        }
        if (spa == 2) {
            double val1 = dat.getNumber(1).doubleValue();
            switch (mode) {
                case 1: {
                    return Math.sqrt(val0 * val0 + val1 * val1);
                }
                case 2: {
                    return scale * Math.atan2(val1, val0);
                }
                case 7: {
                    return scale * Math.log(Math.max(1.0E-20, val0 * val0 + val1 * val1));
                }
                case 8: {
                    return scale * Math.log(Math.max(1.0E-20, val0 * val0 + val1 * val1));
                }
                case 3: {
                    return val0;
                }
                case 9: {
                    return val0;
                }
                case 4: {
                    return val1;
                }
                case 10: {
                    return val1;
                }
            }
            return val0;
        }
        if (spa == 3) {
            double val1 = dat.getNumber(1).doubleValue();
            double val2 = dat.getNumber(2).doubleValue();
            switch (mode) {
                case 1: {
                    return Math.sqrt(val0 * val0 + val1 * val1 + val2 * val2);
                }
                case 3: {
                    return val0;
                }
                case 9: {
                    return val0;
                }
                case 4: {
                    return val1;
                }
                case 10: {
                    return val1;
                }
                case 11: {
                    return val2;
                }
            }
            return val0;
        }
        return val0;
    }

    @Override
    public void findRange() {
        super.findRange();
        double xs = this.xstart;
        if (this.xdelta < 0.0) {
            this.x1 = xs + (double)(this.frame - 1) * this.xdelta;
            this.x2 = xs;
        } else {
            this.x1 = xs;
            this.x2 = xs + (double)(this.frame - 1) * this.xdelta;
        }
        this.y1 = this.minY;
        this.y2 = this.maxY;
        if (this.x1 == this.x2) {
            this.x2 = this.x1 + this.xdelta;
        }
        if (this.y1 == this.y2) {
            this.y1 -= 0.5;
            this.y2 += 0.5;
        }
        this.a1 = this.y1;
        this.a2 = this.y2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(int flag) {
        if (!this.lock()) {
            return;
        }
        try {
            double xs;
            int npts;
            super.draw(flag);
            if (flag != 0 && !this.getDrawFrame()) {
                return;
            }
            Line lin = this.line.copy();
            int n = npts = this.ndata > this.size && this.realtime ? this.size : this.ndata;
            if (this.realtime) {
                xs = this.xstart;
                this.MP.setColor(this.MP.theme.cfg);
                if (this.MP.xvy) {
                    double yd = (this.maxY - this.minY) / (double)this.size;
                    double ys1 = this.ystart + yd * (double)this.recIndex;
                    if (this.recIndex > 0) {
                        ys1 -= yd;
                    }
                    this.MP.drawHorizontal(this.maxY - ys1 - this.minY);
                } else {
                    double xs1 = xs + this.xdelta * (double)this.recIndex;
                    if (this.recIndex > 0) {
                        xs1 -= this.xdelta;
                    }
                    this.MP.drawVertical(xs1);
                }
            } else if (this.fseek >= (double)this.frame) {
                if (this.isPaged && npts <= 0) {
                    npts = this.recSize;
                    xs = this.xstart + this.xdelta * (this.fseek - (double)npts);
                } else {
                    xs = this.xstart;
                }
            } else {
                xs = this.xstart + this.xdelta * this.fseek;
            }
            for (int irec = 0; irec < this.recData.length; ++irec) {
                if (this.recData[irec] == null) continue;
                lin.setColor(this.colors[irec % (this.colors.length - 1) + 1]);
                this.MP.drawLine(this.recData[irec], 0, 1, npts, lin, xs, this.xdelta);
            }
            this.frameDrawn = true;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean reset() {
        this.rereadFile = true;
        if (!this.realtime) {
            this.minY = 0.0;
            this.maxY = 1.0;
        }
        return super.reset();
    }

    @Override
    public void refresh() {
        this.rereadFile = true;
        super.refresh();
    }

    public static Layer getLayer() {
        return new LayerMulti();
    }
}

