/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.image.BufferedImage;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.ImageFile;
import nxm.sys.lib.Table;
import nxm.sys.libg.Layer;
import nxm.sys.prim.plot;

public class LayerImage
extends Layer {
    BufferedImage bi;

    public LayerImage() {
        super("Image");
        this.typeClass = 7;
    }

    @Override
    protected void init(plot p, String layerName, int layerIndex, Layer oldLayer) {
        super.init(p, layerName, layerIndex, oldLayer);
        if ((this.MP.initValues & 1) != 1) {
            this.MP.setAxis("FRAME");
        }
        p.setImageFlag(true);
    }

    @Override
    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        this.setFile(pf);
        ImageFile imf = (ImageFile)pf;
        this.bi = imf.readImage();
        this.size = imf.getYFrame();
        this.frame = imf.getXFrame();
        this.xstart = imf.getXStart();
        this.xdelta = imf.getXDelta();
        this.ystart = imf.getYStart();
        this.ydelta = imf.getYDelta();
        return true;
    }

    @Override
    public void process() {
    }

    @Override
    public void findRange() {
        double t;
        this.x1 = this.xstart - this.xdelta / 2.0;
        this.x2 = this.x1 + (double)this.frame * this.xdelta;
        if (this.x1 > this.x2) {
            t = this.x1;
            this.x1 = this.x2;
            this.x2 = t;
        }
        this.y1 = this.ystart - this.ydelta / 2.0;
        this.y2 = this.y1 + (double)this.size * this.ydelta;
        if (this.y1 > this.y2) {
            t = this.y1;
            this.y1 = this.y2;
            this.y2 = t;
        }
        this.z1 = 0.0;
        this.z2 = 1.0;
        this.a1 = this.y1;
        this.a2 = this.y2;
    }

    @Override
    public void findFullRange() {
        this.fx1 = this.x1;
        this.fx2 = this.x2;
        this.fy1 = this.y1;
        this.fy2 = this.y2;
        this.fz1 = this.z1;
        this.fz2 = this.z2;
        if (this.pf != null && !this.realtime) {
            this.fx1 = this.pf.getXStart();
            this.fx2 = this.fx1 + (double)this.frame * this.pf.getXDelta();
            if (this.fx1 > this.fx2) {
                double t = this.fx1;
                this.fx1 = this.fx2;
                this.fx2 = t;
            }
        }
    }

    @Override
    public void draw(int flag) {
        super.draw(flag);
        this.MP.drawImage(this.bi, null, false, this.xstart, this.xdelta, this.frame, this.ystart, this.ydelta, this.size);
    }

    public BufferedImage getBufferedImage() {
        return this.bi;
    }

    @Override
    public void invertColorMap() {
        short[] invert = new short[256];
        for (int ii = 0; ii < 256; ++ii) {
            invert[ii] = (short)(255 - ii);
        }
        LookupOp invertOp = new LookupOp(new ShortLookupTable(0, invert), null);
        invertOp.filter(this.bi, this.bi);
        this.refresh();
    }

    public static Layer getLayer() {
        return new LayerImage();
    }
}

