/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.GeoJSONFile;
import nxm.sys.lib.GeoJSONObjects;
import nxm.sys.lib.GeodeticUtil;
import nxm.sys.lib.Message;
import nxm.sys.lib.Position;
import nxm.sys.lib.Table;
import nxm.sys.libg.GraphicsUtil;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Line;
import nxm.sys.libg.MColor;
import nxm.sys.libg.Pix;
import nxm.sys.libg.PopUpHTML;
import nxm.sys.prim.plot;

@InternalUseOnly(value="Experimental Prototype in NeXtMidas 4.1.3")
public class LayerGeoJSON
extends Layer {
    public static final String supportedElements = "coordinates,feature,features,featurecollection,geometries,geometry,geometrycollection,linestring,multipoint,multilinestring,multipolygon,point,polygon,properties,name,type";
    private static final Set<String> supportedElems = new HashSet<String>(Arrays.asList("coordinates,feature,features,featurecollection,geometries,geometry,geometrycollection,linestring,multipoint,multilinestring,multipolygon,point,polygon,properties,name,type".split("\\s*,\\s*")));
    GeoJSONFile jsonFile;
    boolean tryingKMLApproach = false;
    boolean fillInnerPolysToo = true;
    private static final double PIXEL_MAX_RANGE = 625.0;
    private final int DEFAULT_LINE_WIDTH = 2;
    private final int DEFAULT_TEXT_SIZE = 12;
    private final int DEFAULT_POINT_SIZE = 4;
    private final String DEFAULT_POINT_SYMBOL = "Circle";
    static final Color DEFAULT_POINT_COLOR;
    static final Color DEFAULT_LINE_COLOR;
    static final Color DEFAULT_POLYGON_COLOR;
    static final Color DEFAULT_POLYGON_FILLED_COLOR;
    static final Color DEFAULT_POLYGON_INNER_FILLED_COLOR;
    private final String[] LABEL_POSITIONS = new String[]{"TOPR", "TOP", "BOTTOMR", "BOTTOM", "RIGHT"};
    private final String DEFAULT_LABEL_POS = "TOPR";
    private String labelPos = "TOPR";
    private int npts;
    private boolean polygonFill = false;
    private boolean polygonOutline = true;
    private Color polyFillColor = DEFAULT_POLYGON_FILLED_COLOR;
    private Color polyInFillColor = DEFAULT_POLYGON_INNER_FILLED_COLOR;
    private Color lineColor = DEFAULT_LINE_COLOR;
    private int lineWidth = 2;
    private int textSize = 12;
    private float labelScale = 1.0f;
    private Color labelColor = DEFAULT_POINT_COLOR;
    private String pointSymbol = "Circle";
    private int pointSize = 4;
    private boolean showLabel = true;
    private boolean allowPopups = true;
    private GeoJSONObjects objects = null;
    private boolean fileProcessed = false;
    private Color selectColor = Color.RED;
    private PopUpHTML htmlPopup;
    private boolean activePopup;
    private GeoJSONObjects.GeoJSONObject selectedObject;
    private GeoJSONObjects.GeoJSONGroup selectedGroup;
    private Pix pix;
    private boolean sendSelectMessages = false;
    private MessageHandler mwMsgHandler = null;

    public LayerGeoJSON() {
        this.name = "GeoJSON";
        this.line.setRadius(3);
        this.line.setSymbol(this.getPointSymbol());
        this.line.getSymbol().setSize(this.getPointSize());
        this.line.setType(1);
        this.line.setColor(DEFAULT_POINT_COLOR);
        this.x1 = 180.0;
        this.x2 = -180.0;
        this.y1 = 90.0;
        this.y2 = -90.0;
        this.z1 = 0.0;
        this.z2 = 10000.0;
        this.pix = new Pix(1, 0);
    }

    public LayerGeoJSON(int cmap) {
        this();
        this.setColorMap(cmap);
        this.name = "GeoJSON";
    }

    @Override
    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        boolean status = true;
        status = this.checkFileType(pf);
        if (status) {
            String pos;
            super.setFile(pf);
            this.jsonFile = (GeoJSONFile)pf;
            if (tab != null && (pos = tab.getS("LABELPOS", null)) != null) {
                this.setLabelPos(pos);
            }
        } else {
            this.warning("File " + pf.getName() + " is not recognized as a GeoJSON file");
        }
        return status;
    }

    private boolean checkFileType(PlotFile pf) {
        return pf instanceof GeoJSONFile;
    }

    @Override
    public void processMouseMessage(Message msg, int type) {
        if (!this.isVisible() || msg.data == "NULL") {
            return;
        }
        if (!(msg.quals instanceof Table)) {
            return;
        }
        Table quals = (Table)msg.quals;
        if (!(quals.get("ORIG_MSG_DATA") instanceof MouseEvent)) {
            return;
        }
        if (this.activePopup) {
            this.closeCurrentPopup();
        }
        MouseEvent me = (MouseEvent)quals.get("ORIG_MSG_DATA");
        Point selPoint = me.getPoint();
        Position pos = (Position)msg.getData();
        if (this.MP.isLatLonView()) {
            for (GeoJSONObjects.GeoJSONPolygon polygon : this.objects.getGeoJSONPolygons()) {
                boolean insidePoly = GeodeticUtil.insidePolygon(pos, polygon.getAtomsPerElem(), polygon.getOuterBoundary(), polygon.getInnerBoundaries());
                if (!insidePoly) continue;
                this.setSelectedObject(polygon);
                if (GraphicsUtil.isCtrlLMB(msg)) {
                    this.drawPopup(polygon);
                }
                return;
            }
        }
        GeoJSONObjects.GeoJSONFeature tempSelected = null;
        int mdist = 625;
        for (GeoJSONObjects.GeoJSONLineString lineString : this.objects.getGeoJSONLineStrings()) {
            double[] lsCoords = lineString.getCoords();
            int ape = lineString.getAtomsPerElem();
            for (int lsIdx = 0; lsIdx < lsCoords.length; lsIdx += ape) {
                int dist = this.getPointDistanceFromClick(selPoint.x, selPoint.y, Arrays.copyOfRange(lsCoords, lsIdx, lsIdx + ape));
                if (dist >= mdist) continue;
                mdist = dist;
                tempSelected = lineString;
            }
        }
        for (GeoJSONObjects.GeoJSONPoint point : this.objects.getGeoJSONPoints()) {
            int dist = this.getPointDistanceFromClick(selPoint.x, selPoint.y, point.getCoords());
            if (dist >= mdist) continue;
            mdist = dist;
            tempSelected = point;
        }
        this.setSelectedObject(tempSelected);
        if (this.selectedObject != null && GraphicsUtil.isCtrlLMB(msg)) {
            this.drawPopup(tempSelected);
        }
    }

    private int getPointDistanceFromClick(int x, int y, double[] point) {
        int dist = Integer.MAX_VALUE;
        this.MP.viewer.rwc2pix(point, 0, point.length, 1, this.pix);
        int ix = this.pix.x[0];
        int iy = this.pix.y[0];
        if (ix >= this.MP.ix1 && ix <= this.MP.ix2 && iy >= this.MP.iy1 && iy <= this.MP.iy2) {
            int dx = ix - x;
            int dy = iy - y;
            dist = dx * dx + dy * dy;
        }
        return dist;
    }

    private void drawPopup(GeoJSONObjects.GeoJSONObject geoJSONObject) {
        if (geoJSONObject == null) {
            return;
        }
        if (this.activePopup) {
            this.closeCurrentPopup();
        }
        if (this.selectedGroup != null) {
            Table popupTbl = new Table();
            popupTbl.setFlags(popupTbl.getFlagsInt() | 1 | 0x40);
            popupTbl.addIfNotPresent(this.selectedObject.toTable());
            popupTbl.addIfNotPresent(this.selectedGroup.toTable());
            this.htmlPopup = new PopUpHTML(popupTbl, this.MP);
        } else {
            this.htmlPopup = new PopUpHTML(geoJSONObject.toTable(), this.MP);
        }
        this.activePopup = true;
    }

    private void closeCurrentPopup() {
        if (this.htmlPopup != null) {
            this.htmlPopup.close();
        }
        this.activePopup = false;
    }

    @Override
    public void close() {
        super.close();
        this.setSelectedObject(null);
        this.activePopup = false;
        this.closeCurrentPopup();
    }

    public void setAllowPopups(boolean val) {
        this.allowPopups = val;
    }

    public boolean isAllowPopups() {
        return this.allowPopups;
    }

    @Override
    public int getData(int flag) {
        if (this.pf == null || !this.pf.isOpen()) {
            return 0;
        }
        if (!this.fileProcessed) {
            this.objects = this.jsonFile.getGeoJSONObjects();
            this.updateRange();
        }
        return 0;
    }

    protected void updateRange() {
        int i;
        int ape;
        double[] coords;
        for (GeoJSONObjects.GeoJSONPolygon poly : this.objects.getGeoJSONPolygons()) {
            coords = poly.getCoords();
            ape = poly.getAtomsPerElem();
            for (i = 0; i < coords.length; i += ape) {
                this.updateXRange(coords[i]);
                this.updateYRange(coords[i + 1]);
            }
        }
        for (GeoJSONObjects.GeoJSONLineString line : this.objects.getGeoJSONLineStrings()) {
            coords = line.getCoords();
            ape = line.getAtomsPerElem();
            for (i = 0; i < coords.length; i += ape) {
                this.updateXRange(coords[i]);
                this.updateYRange(coords[i + 1]);
            }
        }
        for (GeoJSONObjects.GeoJSONPoint point : this.objects.getGeoJSONPoints()) {
            coords = point.getCoords();
            ape = point.getAtomsPerElem();
            for (i = 0; i < coords.length; i += ape) {
                this.updateXRange(coords[i]);
                this.updateYRange(coords[i + 1]);
            }
        }
        if (!this.fileProcessed) {
            this.MP.rescale(true);
            this.fileProcessed = true;
        }
    }

    protected void updateXRange(double xval) {
        if (xval < this.x1) {
            this.x1 = Math.floor(xval);
        }
        if (xval > this.x2) {
            this.x2 = Math.ceil(xval);
        }
    }

    protected void updateYRange(double yval) {
        if (yval < this.y1) {
            this.y1 = Math.floor(yval);
        }
        if (yval > this.y2) {
            this.y2 = Math.ceil(yval);
        }
    }

    @Override
    public void draw(int mode) {
        super.draw(mode);
        this.drawGeoJSONObjects(this.objects);
    }

    public void setPolygonOutline(boolean polygonOutline) {
        this.polygonOutline = polygonOutline;
    }

    public boolean getPolygonOutline() {
        return this.polygonOutline;
    }

    public void setPolygonFill(boolean doFill) {
        this.polygonFill = doFill;
    }

    public boolean getPolygonFill() {
        return this.polygonFill;
    }

    public boolean isPolygonFill() {
        return this.getPolygonFill();
    }

    private Color getColorFromObject(Object value) {
        if (value instanceof String && value.toString().length() == 0) {
            return null;
        }
        if (value instanceof String && "NONE".equalsIgnoreCase((String)value)) {
            return null;
        }
        return MColor.getColor(value);
    }

    public void setSelectColor(Object value) {
        this.setSelectColor(this.getColorFromObject(value));
    }

    public void setSelectColor(Color c) {
        if (c == null) {
            return;
        }
        if (!this.selectColor.equals(c)) {
            this.selectColor = c;
            this.refresh();
        }
    }

    public Color getSelectColor() {
        return this.selectColor;
    }

    public void setPolygonFillColor(Object value) {
        this.setPolygonFillColor(this.getColorFromObject(value));
    }

    public void setPolygonFillColor(Color color) {
        this.polyFillColor = color;
    }

    public Color getPolygonFillColor() {
        return this.polyFillColor;
    }

    public void setLineColor(Object value) {
        this.setLineColor(this.getColorFromObject(value));
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    @InternalUseOnly(value="currently unused")
    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    @InternalUseOnly(value="currently unused")
    public int getLineWidth() {
        return this.lineWidth;
    }

    @InternalUseOnly(value="currently unused")
    public void setLabelScale(float scale) {
        this.labelScale = scale;
    }

    @InternalUseOnly(value="currently unused")
    public float getLabelScale() {
        return this.labelScale;
    }

    @InternalUseOnly(value="currently unused")
    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    @InternalUseOnly(value="currently unused")
    public Color getLabelColor() {
        return this.labelColor;
    }

    @InternalUseOnly(value="currently unused")
    public void setTextSize(int size) {
        this.textSize = size;
    }

    @InternalUseOnly(value="currently unused")
    public int getTextSize() {
        return this.textSize;
    }

    @InternalUseOnly(value="currently unused")
    public boolean isShowLabel() {
        return this.showLabel;
    }

    @InternalUseOnly(value="currently unused")
    public void setShowLabel(boolean show) {
        this.showLabel = show;
    }

    public String getPointSymbol() {
        return this.pointSymbol;
    }

    public void setPointSymbol(String symbol) {
        if ("Aero,Arrow,Circle,Cross,Diamond,Dot,Plus,Square,Star,Triangle,UTri,DTri,RTri,LTri,A,B,C,D,Ascii-XYZ,None".indexOf(symbol) >= 0) {
            this.pointSymbol = symbol;
        } else {
            this.warning("Invalid symbol: " + symbol + ". Symbol must be in " + "Aero,Arrow,Circle,Cross,Diamond,Dot,Plus,Square,Star,Triangle,UTri,DTri,RTri,LTri,A,B,C,D,Ascii-XYZ,None");
        }
    }

    @InternalUseOnly(value="currently unused")
    public String getLabelPos() {
        return this.labelPos;
    }

    @InternalUseOnly(value="currently unused")
    public void setLabelPos(String pos) {
        if (pos == null) {
            return;
        }
        pos = pos.toUpperCase();
        for (int index = 0; index < this.LABEL_POSITIONS.length; ++index) {
            if (!this.LABEL_POSITIONS[index].equals(pos)) continue;
            this.labelPos = pos;
            return;
        }
        String labelString = "'";
        for (int index = 0; index < this.LABEL_POSITIONS.length; ++index) {
            labelString = labelString + this.LABEL_POSITIONS[index] + "', '";
        }
        this.warning("Invalid Label Position: " + pos + ". Position must be in " + labelString.substring(0, labelString.length() - 3) + ".");
    }

    @InternalUseOnly(value="currently unused")
    public int getPointSize() {
        return this.pointSize;
    }

    @InternalUseOnly(value="currently unused")
    public void setPointSize(int pointSize) {
        this.pointSize = pointSize;
    }

    @InternalUseOnly
    public GeoJSONObjects getGeoJSONObjects() {
        return this.objects;
    }

    @InternalUseOnly
    public void setGeoJSONObjects(GeoJSONObjects objs) {
        this.objects = objs;
    }

    private void drawGeoJSONObjects(GeoJSONObjects objects) {
        if (objects == null) {
            return;
        }
        this.drawPoints(objects.getGeoJSONPoints());
        this.drawLineStrings(objects.getGeoJSONLineStrings());
        this.drawPolygons(objects.getGeoJSONPolygons());
    }

    private void drawPoints(ArrayList<GeoJSONObjects.GeoJSONPoint> points) {
        Line myLine = this.line.copy();
        for (GeoJSONObjects.GeoJSONPoint point : points) {
            int offset = 0;
            this.npts = 1;
            boolean selected = this.isInSelectedGroup(point) || this.isSelectedObject(point);
            Color _color = selected ? this.selectColor : this.line.getColor();
            myLine.setColor(_color);
            myLine.setType("Symbol");
            this.line.getSymbol().setSize(4);
            this.MP.drawLineLonLat(point.getCoords(), offset, point.getAtomsPerElem(), this.npts, myLine);
        }
    }

    private void drawLineStrings(ArrayList<GeoJSONObjects.GeoJSONLineString> lineStrings) {
        Line myLine = this.line.copy();
        for (GeoJSONObjects.GeoJSONLineString lineString : lineStrings) {
            double[] flatCoords = lineString.getCoords();
            int offset = 0;
            this.npts = flatCoords.length / lineString.getAtomsPerElem();
            boolean selected = this.isInSelectedGroup(lineString) || this.isSelectedObject(lineString);
            Color _color = selected ? this.selectColor : this.lineColor;
            myLine.setColor(_color);
            myLine.setType(33);
            this.line.getSymbol().setSize(4);
            this.MP.drawLineLonLat(flatCoords, offset, lineString.getAtomsPerElem(), this.npts, myLine);
        }
    }

    private void drawPolygons(ArrayList<GeoJSONObjects.GeoJSONPolygon> polygons) {
        Line myOutlineLine = this.line.copy();
        myOutlineLine.setThickness(2);
        Line myFillLine = this.line.copy();
        myFillLine.setType(this.line.getType() + "Fill");
        myFillLine.setColor(this.polyFillColor);
        Line myInnerFillLine = myFillLine.copy();
        myInnerFillLine.setColor(this.polyInFillColor);
        for (GeoJSONObjects.GeoJSONPolygon polygon : polygons) {
            double[] boundaries;
            boolean selected;
            int ape = polygon.getAtomsPerElem();
            int offset = 0;
            int numInnerRings = polygon.getInnerBoundaries() == null ? 0 : polygon.getInnerBoundaries().length;
            boolean fillingPolygon = polygon.getFill() || this.polygonFill;
            boolean bl = selected = this.isInSelectedGroup(polygon) || this.isSelectedObject(polygon);
            if (!fillingPolygon || numInnerRings > 1 && this.fillInnerPolysToo) {
                double[] outerBoundary = polygon.getCoords();
                this.npts = outerBoundary.length / ape;
                if (fillingPolygon) {
                    this.MP.drawLineLonLat(outerBoundary, offset, ape, this.npts, myFillLine);
                }
                if (!fillingPolygon || this.polygonOutline) {
                    Color _color = selected ? this.selectColor : this.lineColor;
                    myOutlineLine.setColor(_color);
                    this.MP.drawLineLonLat(outerBoundary, offset, ape, this.npts, myOutlineLine);
                }
                if (polygon.getInnerBoundaries() == null) continue;
                myOutlineLine.setThickness(1);
                for (Object innerBoundary : (Color)polygon.getInnerBoundaries()) {
                    this.npts = ((Object)innerBoundary).length / ape;
                    if (fillingPolygon) {
                        this.MP.drawLineLonLat((double[])innerBoundary, offset, ape, this.npts, myInnerFillLine);
                    }
                    if (fillingPolygon && !this.polygonOutline) continue;
                    Color _color = selected ? this.selectColor : this.lineColor;
                    myOutlineLine.setColor(_color);
                    this.MP.drawLineLonLat((double[])innerBoundary, offset, ape, this.npts, myOutlineLine);
                }
                continue;
            }
            int totalLength = polygon.getCoords().length;
            if (polygon.getInnerBoundaries() == null) {
                boundaries = polygon.getCoords();
            } else {
                for (double[] innerBoundary : polygon.getInnerBoundaries()) {
                    totalLength += innerBoundary.length;
                }
                boundaries = this.combineOuterInnerPolygons(polygon, numInnerRings, totalLength);
            }
            this.npts = totalLength / ape;
            this.MP.drawLineLonLat(boundaries, offset, ape, this.npts, myFillLine);
            if (!this.polygonOutline) continue;
            double[] outerBoundary = polygon.getCoords();
            this.npts = outerBoundary.length / ape;
            Color _color = selected ? this.selectColor : this.lineColor;
            myOutlineLine.setColor(_color);
            this.MP.drawLineLonLat(outerBoundary, offset, ape, this.npts, myOutlineLine);
        }
    }

    private boolean isInSelectedGroup(GeoJSONObjects.GeoJSONFeature geoJsonFeature) {
        return this.selectedGroup != null && geoJsonFeature.getGroup() == this.selectedGroup;
    }

    private boolean isSelectedObject(GeoJSONObjects.GeoJSONObject geoJsonObject) {
        return geoJsonObject == this.selectedObject;
    }

    private double[] combineOuterInnerPolygons(GeoJSONObjects.GeoJSONPolygon polygon, int numInnerRings, int totalLength) {
        double[] coordsCombined;
        if (numInnerRings > 1 && this.tryingKMLApproach) {
            coordsCombined = this.combinePolygons(polygon, numInnerRings, totalLength);
        } else {
            coordsCombined = new double[totalLength];
            System.arraycopy(polygon.getCoords(), 0, coordsCombined, 0, polygon.getCoords().length);
            int copyIdx = polygon.getCoords().length;
            for (double[] innerBoundary : polygon.getInnerBoundaries()) {
                System.arraycopy(innerBoundary, 0, coordsCombined, copyIdx, innerBoundary.length);
                copyIdx += innerBoundary.length;
            }
        }
        return coordsCombined;
    }

    private double[] combinePolygons(GeoJSONObjects.GeoJSONPolygon polygon, int innerRings, int totalLength) {
        double[] outerCoords = polygon.getCoords();
        int outerLength = outerCoords.length;
        if (innerRings == 0) {
            return outerCoords;
        }
        int tmpPos = 0;
        int endPathCounter = 0;
        double[] coordsCombined = new double[totalLength += 3 * (innerRings - 1)];
        double[] endPath = new double[(innerRings - 1) * 3];
        int xx = 0;
        while (xx < outerLength) {
            coordsCombined[tmpPos] = outerCoords[xx];
            ++xx;
            ++tmpPos;
        }
        for (xx = 0; xx < innerRings; ++xx) {
            double[] tmpCoords = polygon.getInnerBoundaries()[xx];
            int yy = 0;
            while (yy < tmpCoords.length) {
                coordsCombined[tmpPos] = tmpCoords[yy];
                ++yy;
                ++tmpPos;
            }
            if (xx >= innerRings - 1) continue;
            endPathCounter = endPath.length - 3 * xx - 3;
            endPath[endPathCounter] = coordsCombined[tmpPos - 3];
            endPath[endPathCounter + 1] = coordsCombined[tmpPos - 2];
            endPath[endPathCounter + 2] = coordsCombined[tmpPos - 1];
        }
        xx = 0;
        while (xx < endPath.length) {
            coordsCombined[tmpPos] = endPath[xx];
            ++xx;
            ++tmpPos;
        }
        return coordsCombined;
    }

    @Override
    public void findRange() {
    }

    @Override
    public void findFullRange() {
        this.fx1 = this.x1;
        this.fx2 = this.x2;
        this.fy1 = this.y1;
        this.fy2 = this.y2;
        this.fz1 = this.z1;
        this.fz2 = this.z2;
    }

    private String getSelectionInfo() {
        StringBuilder selection = new StringBuilder(this.selectedObject.toString());
        if (this.selectedGroup != null) {
            selection.append(",\n").append(this.selectedGroup.toString());
        }
        return selection.toString();
    }

    private void setSelectedObject(GeoJSONObjects.GeoJSONObject geoJSONObject) {
        if (geoJSONObject != this.selectedObject) {
            String previousSelectionInfo = this.selectedObject != null ? this.getSelectionInfo() : null;
            this.selectedObject = geoJSONObject;
            boolean newObjectNull = geoJSONObject == null;
            GeoJSONObjects.GeoJSONGroup geoJSONGroup = this.selectedGroup = !newObjectNull && this.selectedObject instanceof GeoJSONObjects.GeoJSONFeature ? ((GeoJSONObjects.GeoJSONFeature)this.selectedObject).getGroup() : null;
            if (newObjectNull && this.activePopup) {
                this.closeCurrentPopup();
            }
            this.refresh();
            if (this.sendSelectMessages) {
                if (this.mwMsgHandler == null) {
                    this.mwMsgHandler = ((plot)this.MP.mh).getMessageHandler();
                }
                if (this.mwMsgHandler != null) {
                    if (previousSelectionInfo != null) {
                        this.mwMsgHandler.processMessage(new Message("DESELECT", 0, previousSelectionInfo, this.mwMsgHandler, this.MP.mh));
                    }
                    if (this.selectedObject != null) {
                        this.mwMsgHandler.processMessage(new Message("SELECT", 0, this.getSelectionInfo(), this.mwMsgHandler, this.MP.mh));
                    }
                }
            }
        }
    }

    @Override
    public void setEnable(int value) {
        boolean layerHidden;
        if ((this.enable & 1) == 0 != (layerHidden = (value & 1) == 0)) {
            if (this.mwMsgHandler == null) {
                this.mwMsgHandler = ((plot)this.MP.mh).getMessageHandler();
            }
            if (this.selectedObject != null) {
                if (layerHidden) {
                    if (this.activePopup && this.htmlPopup != null) {
                        this.closeCurrentPopup();
                        this.activePopup = true;
                    }
                    if (this.mwMsgHandler != null) {
                        this.mwMsgHandler.processMessage(new Message("DESELECT", 0, this.getSelectionInfo(), this.mwMsgHandler, this.MP.mh));
                    }
                } else {
                    if (this.activePopup) {
                        this.drawPopup(this.selectedObject);
                    }
                    if (this.mwMsgHandler != null) {
                        this.mwMsgHandler.processMessage(new Message("SELECT", 0, this.getSelectionInfo(), this.mwMsgHandler, this.MP.mh));
                    }
                }
            }
        }
        super.setEnable(value);
    }

    public void setSelectMessages(String sendSelectMessages) {
        this.setSelectMessages(sendSelectMessages.toLowerCase().startsWith("t"));
    }

    public void setSelectMessages(boolean sendSelectMessages) {
        this.sendSelectMessages = sendSelectMessages;
    }

    @Override
    public boolean clear() {
        this.objects = null;
        this.setSelectedObject(null);
        this.refresh();
        return true;
    }

    public static Layer getLayer() {
        return new LayerGeoJSON();
    }

    static {
        DEFAULT_LINE_COLOR = DEFAULT_POINT_COLOR = Color.GREEN;
        DEFAULT_POLYGON_COLOR = DEFAULT_POINT_COLOR;
        DEFAULT_POLYGON_FILLED_COLOR = new Color(6737322);
        DEFAULT_POLYGON_INNER_FILLED_COLOR = Color.BLACK;
    }
}

