/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JScrollPane;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Shell;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MJTextArea;
import nxm.sys.libg.Theme;

public class GText
extends GWidget {
    private MJTextArea mjtext;
    private JScrollPane scrollPane;
    private static boolean fixTimingIssueWithTextWidth = true;

    public GText(Object parent, String name, String text, int aw, int ah, int flags, MessageHandler mh) {
        super("GText", parent, name, flags, mh);
        this.open(name, aw, ah, text);
        this.addTo(parent);
    }

    public void open(String name, int aw, int ah, String text) {
        this.open();
        super.open(name, aw * this.tw, ah * this.th + this.ta);
        this.setupTextArea(text, ah, aw);
    }

    public void setupTextArea(String text, int ah, int aw) {
        if (this.headless) {
            return;
        }
        this.mjtext = new MJTextArea(text, ah, aw);
        this.mjtext.setEditable(false);
        this.mjtext.setBackground(this.theme.cwbg);
        this.mjtext.setForeground(this.theme.cwfg);
        if (Shell.osname.equals("Linux")) {
            this.scrollPane = new JScrollPane(this.mjtext);
            this.scrollPane.setVerticalScrollBarPolicy(20);
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.panel.add(this.scrollPane);
        } else {
            this.panel.add(this.mjtext);
        }
        this.setBounds();
    }

    @Override
    @ProvisionalUseOnly(value="Treat this as protected and should only be called by subclass paintComponent methods")
    public void paintComponent(Graphics g) {
        this.getMJTextArea().setAttributesGW(this);
        super.paintComponent(g);
        this.paintTitle(g);
    }

    public void paintTitle(Graphics g) {
        if (g == null || this.bw == 0) {
            return;
        }
        int bf = 0;
        if (this.is(32)) {
            bf = -6;
        }
        this.shadowbox(g, 0, 0, this.pos.w, this.pos.h, bf);
        if (this.titleh > 0) {
            int lh = this.bw + this.titleh;
            this.shadowbox(g, 0, 0, this.pos.w, lh, -5);
            g.setColor(this.isEnabled() ? this.theme.cwfh : this.disabledColor);
            g.drawString(this.title, this.pos.w / 2 - this.titlew / 2, this.titleh / 2 + this.ta / 2);
        }
        g.setColor(this.isEnabled() ? this.theme.cfg : this.disabledColor);
        this.panel.revalidate();
    }

    @Override
    public void setWidgetTheme(Object o) {
        super.setWidgetTheme(o);
        if (this.headless) {
            return;
        }
        this.mjtext.setForeground(this.theme.getWidgetForeground());
        this.mjtext.setBackground(this.theme.getWidgetBackground());
    }

    @Override
    public void resize(int mode) {
        super.resize(mode);
        this.setBounds();
    }

    private void setBounds() {
        this.mjtext.setBounds(this.bw, this.bw + this.titleh, this.pw, this.ph);
        if (this.scrollPane != null) {
            this.scrollPane.setBounds(this.bw, this.bw + this.titleh, this.pw, this.ph);
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (fixTimingIssueWithTextWidth && this.scrollPane != null && this.scrollPane.getVerticalScrollBar().isVisible()) {
            this.pw = w - this.bw - this.bw;
            this.ph = h - this.bw - this.bw - this.titleh;
            this.mjtext.setBounds(this.bw, this.bw + this.titleh, this.pw, this.ph);
            this.scrollPane.setBounds(this.bw, this.bw + this.titleh, this.pw, this.ph);
        }
    }

    @Override
    public void setValue(String value) {
        this.mjtext.setText(value);
    }

    @Override
    public Object getValue() {
        return this.mjtext.getText();
    }

    @Override
    public void setTheme(Theme theme) {
        super.setTheme(theme);
        if (this.mjtext != null) {
            this.mjtext.setBackground(theme.cwbg);
            this.mjtext.setForeground(theme.cwfg);
        }
    }

    @Override
    public boolean isStretchable() {
        return true;
    }

    public MJTextArea getMJTextArea() {
        return this.mjtext;
    }

    public void setSelectedTextColor(Color c) {
        this.mjtext.setSelectedTextColor(c);
    }

    public Color getSelectedTextColor() {
        return this.mjtext.getSelectedTextColor();
    }

    public void setSelectionColor(Color c) {
        this.mjtext.setSelectionColor(c);
    }

    public Color getSelectionColor() {
        return this.mjtext.getSelectionColor();
    }

    public void setSelectedTextColor(String color) {
        this.setSelectedTextColor(MColor.getColor(color));
    }

    public String getSelectedTextColorString() {
        return MColor.toString(this.getSelectedTextColor());
    }

    public void setSelectionColor(String c) {
        this.setSelectionColor(MColor.getColor(c));
    }

    public String getSelectionColorString() {
        return MColor.toString(this.getSelectionColor());
    }

    @ProvisionalUseOnly(value="temporary means of backing out fix")
    public static void setFixTimingIssueWithTextWidth(String useFix) {
        fixTimingIssueWithTextWidth = useFix.toLowerCase().equals("true");
    }
}

