/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Message;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Query;
import nxm.sys.lib.Table;
import nxm.sys.libg.GDialog;
import nxm.sys.libg.GList;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.GValue;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MPlot;

public class GQuery
extends GDialog {
    public static final String flagsList = GWidget.flagsList + ",Filter";
    public static final int FILTER = 256;
    private int maxitems = 128;
    private int maxwidth = 120;
    private Query query;
    private GList plist;

    public GQuery(Object parent, String name, Object obj, String list3, int flags, MessageHandler mh) {
        super(null, name, -50, -10, "Back,Pop,Redo,Exit", "Back,Pop,Redo", flags, mh);
        if (parent instanceof MPlot) {
            ++((MPlot)parent).popupCount;
        }
        this.open(name, list3, obj);
        this.addTo(parent);
    }

    public GQuery(Object parent, String name, Object obj, int flags, MessageHandler mh) {
        this(parent, name, obj, null, flags, mh);
    }

    public void open(String name, String list3, Object obj) {
        super.open();
        this.query = new Query(obj, list3, this.maxitems);
        this.setMaxWidgets(1);
        this.plist = new GList((Object)this, "Properties", "Properties", 40, 10, 16384, (MessageHandler)this);
        this.formPropertiesList();
    }

    private void formPropertiesList() {
        this.query.parse();
        this.evalPropertiesList();
    }

    private void evalPropertiesList() {
        this.query.evaluate();
        int items = this.query.getItems();
        this.plist.removeItems();
        for (int i = 0; i < items; ++i) {
            String tmp = this.query.getName(i);
            tmp = this.query.getSetMethod(i) != null ? tmp + " => " : tmp + " = ";
            if ((tmp = tmp + this.query.getValue(i)).length() > this.maxwidth) {
                tmp = tmp.substring(0, this.maxwidth);
            }
            this.plist.addItem(tmp);
        }
    }

    @Override
    public int processMessage(Message msg) {
        if (this.status != -3) {
            if (msg.name.equals("DIALOG")) {
                String action = (String)msg.data;
                if (action.equals("BACK")) {
                    this.back(false);
                }
                if (action.equals("POP")) {
                    this.back(true);
                } else if (action.equals("REDO")) {
                    this.formPropertiesList();
                } else if (action.equals("EXIT")) {
                    this.close();
                }
            } else if (msg.name.equals("PROPERTIES")) {
                this.select(msg.info - 1);
            } else {
                this.query.setObject(msg.name, msg.data);
                this.evalPropertiesList();
                this.refresh();
            }
        }
        return -1;
    }

    private void select(int i) {
        block28: {
            Object obj = this.query.getObject();
            String key = this.query.getName(i);
            Method get = this.query.getGetMethod(i);
            Method set = this.query.getSetMethod(i);
            boolean hss = this.query.getSetStringMethod(i) != null;
            try {
                Object object = this.query.getObject(i);
                if (object instanceof Hashtable || object instanceof KeyVector || object instanceof Table) {
                    this.newQuery(key, object);
                    break block28;
                }
                if (set == null && get != null) {
                    if (!(object instanceof String)) {
                        this.newQuery(key, object);
                    }
                    break block28;
                }
                if (object instanceof String || object == null) {
                    String menuList = null;
                    String value = (String)object;
                    String fieldname = key.toLowerCase() + "List";
                    if (obj instanceof Keyable) {
                        menuList = (String)((Keyable)obj).getKey(fieldname.toUpperCase());
                    }
                    if (menuList == null) {
                        try {
                            Field field = obj.getClass().getField(fieldname);
                            menuList = (String)field.get(obj);
                        }
                        catch (Exception field) {
                            // empty catch block
                        }
                    }
                    if (menuList == null) {
                        new GPrompt(this.plist, key, value, 0, (MessageHandler)this);
                    } else if (value.charAt(0) == '|') {
                        int def = Parser.mask(menuList, value, 0);
                        new GMenu(this.plist, key, menuList, def, 0x100400, this);
                    } else {
                        int def = Parser.find(menuList, value, 0);
                        new GMenu(this.plist, key, menuList, def, 0, this);
                    }
                    break block28;
                }
                double val = 0.0;
                double dval = 1.0;
                char type = 'L';
                if (object instanceof Double) {
                    val = (Double)object;
                    type = 'D';
                    dval = 0.1 * val;
                } else if (object instanceof Float) {
                    val = ((Float)object).doubleValue();
                    type = 'F';
                    dval = 0.1 * val;
                } else if (object instanceof Integer) {
                    val = ((Integer)object).doubleValue();
                } else if (object instanceof Short) {
                    val = ((Short)object).doubleValue();
                } else if (object instanceof Byte) {
                    val = ((Byte)object).doubleValue();
                } else {
                    type = 'O';
                }
                if (type != 'O') {
                    new GValue(this.plist, key, val, val, val, dval, type, 0, this);
                } else if (hss) {
                    new GPrompt(this.plist, key, object.toString(), 0, (MessageHandler)this);
                } else {
                    this.newQuery(key, object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void newQuery(String key, Object object) {
        Query newquery = new Query(object, null, this.maxitems);
        newquery.parent = this.query;
        this.query = newquery;
        this.setTitle(this.title + "." + key);
        this.formPropertiesList();
    }

    private void back(boolean pop) {
        if (this.query.parent == null) {
            return;
        }
        int i = this.title.lastIndexOf(46);
        String key = this.title.substring(i + 1);
        if (pop) {
            new GQuery((Object)this.MW, this.title, this.query.getObject(), null, this.flags, this.mh);
        }
        this.setTitle(this.title.substring(0, i));
        this.query = this.query.parent;
        this.formPropertiesList();
    }
}

