/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.libg.GFiles;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MJPasswordField;
import nxm.sys.libg.MJTextField;

public class GPrompt
extends GWidget
implements ActionListener {
    private String seed;
    private JTextField jtexti;
    private int pw;
    private int maxheight;
    private int maxwidthl;
    private int digits = 10;
    private int mouseMode = 0;
    private boolean edit = true;
    private boolean isSetup = false;
    private MBox bp;
    private MBox bt;
    private MBox bc;
    private int aw;
    private int ah;
    private String raux;
    private String filt;
    private GFiles gf = null;
    public static final String flagsList = GWidget.flagsList + ",Password,LimitChars,NoWarn";
    public static final int PASSWORD = 256;
    public static final int LIMITCHARS = 512;
    public static final int NOWARN = 1024;

    public GPrompt(Object parent, String name, String seed, int digits, int flags, MessageHandler mh) {
        super("GPrompt", parent, name, flags, mh);
        this.open(name, seed, digits);
        this.addTo(parent);
    }

    public GPrompt(Object parent, String name, String seed, int flags, MessageHandler mh) {
        super("GPrompt", parent, name, flags, mh);
        this.open(name, seed, this.digits);
        this.addTo(parent);
    }

    public GPrompt(Object parent, String name, String seed, String filt, String raux, Midas M, int aw, int ah, int flags, MessageHandler mh) {
        super("GFile", parent, name, flags, mh);
        this.filt = filt;
        this.raux = raux;
        this.M = M;
        this.aw = aw;
        this.ah = ah;
        this.open(name, seed, this.digits);
        this.addTo(parent);
    }

    @Override
    public void setWidgetTheme(Object o) {
        super.setWidgetTheme(o);
        if (this.jtexti != null) {
            this.jtexti.setForeground(this.theme.cwfg);
            this.jtexti.setBackground(this.theme.cwbg);
        }
    }

    public void open(String name, String seed, int digits) {
        super.open();
        this.digits = digits;
        this.seed = this.is(512) ? this.truncateText(seed, digits, true) : seed;
        this.pw = this.stringWidth(this.title);
        this.setupTextField();
        this.resize(1);
    }

    public void setupTextField() {
        this.edit = !this.is(1) && !this.is(8);
        this.setup();
        if (this.headless) {
            return;
        }
        this.jtexti = this.is(256) && !this.isFileChooser() ? new MJPasswordField(this.seed, this.digits) : new MJTextField(this.seed, this.digits);
        this.jtexti.setFont(this.font);
        this.jtexti.setForeground(this.theme.cwfg);
        this.jtexti.setBackground(this.theme.cwbg);
        this.jtexti.addActionListener(this);
        if (this.edit) {
            this.panel.add((Component)this.jtexti, 0);
            this.jtexti.requestFocus();
        }
        if (this.is(512)) {
            this.jtexti.setDocument(new MPlainDocument(this.digits));
        }
    }

    @Override
    public void setup() {
        int h = this.th + this.ta - (this.edit ? 0 : this.compression);
        this.bw = this.is(32) ? 0 : 4;
        this.bp = new MBox(this.bw + this.tw, this.bw, this.pw, h);
        this.bc = new MBox(this.bp.x + this.bp.w, this.bw, this.th + this.tw, h);
        this.bt = new MBox(this.bc.x + this.bc.w, this.bw, this.tw * this.digits, h);
        this.bbox = new MBox(this.bt.x - 3, this.bt.y + this.ta / 2 + 2, this.bt.w + 5, this.bt.h - this.ta / 2 - 6);
        this.pos.w = this.bt.x + this.bt.w + this.tw + this.bw;
        if (this.fixWidth > this.pos.w) {
            this.pos.w = this.fixWidth;
            this.bt.w = this.pos.w - this.bt.x - this.bt.w - this.bw;
        }
        this.pos.h = this.bw + h + this.bw;
        this.layout();
        this.isSetup = true;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        this.pw = this.titlew = this.stringWidth(title);
        if (this.isSetup) {
            this.setup();
            this.refresh();
        }
    }

    @Override
    public void resize(int mode) {
        super.resize(mode);
        this.bt.w = this.pos.w - this.bt.x - this.bw - this.tw;
        this.placeTextInput(this.bc, this.jtexti);
    }

    @Override
    @Deprecated
    public void paint() {
        this.refresh();
    }

    @Override
    @ProvisionalUseOnly(value="Treat this as protected and should only be called by subclass paintComponent methods")
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int bf = 0;
        if (this.is(32)) {
            bf = -2;
        }
        this.shadowbox(g, 0, 0, this.pos.w, this.pos.h, bf);
        int ty = this.pos.h / 2 + this.ta / 2;
        this.setColor(g, this.theme.cwti);
        this.setTextClip(g, this.panel, this.title, this.bt.x);
        g.drawString(this.title, this.bp.x, ty);
        this.setColor(g, this.theme.cwfg);
        if (!this.edit) {
            String tmpstr = this.jtexti instanceof MJPasswordField ? this.getFillChars() : this.seed;
            this.setTextClip(g, this.panel, tmpstr, this.bt.x);
            g.drawString(tmpstr, this.bt.x, ty);
        }
        this.setValueBox(this.bt.x - 3, this.bt.y + this.ta / 2, this.bt.w + 5, this.bt.h - this.ta / 2 - 4);
        this.drawValueBox(g, 1);
        this.drawArrows(g);
    }

    private String getFillChars() {
        if (!(this.jtexti instanceof MJPasswordField)) {
            return this.seed;
        }
        return StringUtil.padRight("", this.seed.length(), ((MJPasswordField)this.jtexti).getEchoChar());
    }

    private void drawArrows(Graphics g) {
        this.drawDiamond(g, this.bc.x + this.bc.w / 2, this.bc.y + this.bc.h / 2, this.tw * 2 / 3, this.mouseMode);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String text = this.jtexti.getText();
        this.panel.remove(this.jtexti);
        this.panel.requestFocus();
        this.seed = text;
        this.edit = false;
        this.setup();
        this.sendMessage();
        if (!this.is(1)) {
            this.close();
        }
    }

    @Override
    public void setAction(String text) {
        this.setActionType();
        this.setValue(text);
        this.sendMessage();
    }

    @Override
    public void setValue(String value) {
        if (this.is(512)) {
            value = this.truncateText(value, this.digits, true);
        }
        this.seed = value;
        this.refresh();
    }

    @Override
    public Object getValue() {
        return this.seed;
    }

    private String truncateText(String text, int limit, boolean feedback) {
        if (this.isFileChooser()) {
            return text;
        }
        if (text.length() <= limit) {
            return text;
        }
        String result = text.substring(0, limit);
        if (feedback) {
            Shell.info("GPrompt: Input text '" + result + "' truncated due to limit of " + limit + " characters");
        }
        return result;
    }

    private void sendMessage() {
        if (this.is(0x20000000)) {
            this.M.results.put(this.monitorName, (Object)this.seed);
        }
        this.sendWidgetMessage(this.label, this.actionType, this.seed);
    }

    @Override
    public boolean poll() {
        if (this.monitorName == null || !this.is(0x20000000)) {
            return false;
        }
        String newval = this.M.results.getS(this.monitorName);
        if (newval == null || newval.equals(this.seed)) {
            return false;
        }
        this.setValue(newval);
        this.sendWidgetMessage(this.label, -1, newval);
        return true;
    }

    @Override
    public String getLegend() {
        if (this.mouseMode == 0) {
            return "";
        }
        if (this.mouseMode == 4) {
            return "(MM=Configure)";
        }
        return "(LM=Edit,RM=Edit)";
    }

    @Override
    public int processEventMessage(String name, int info, Object data) {
        if (name.equals("POINTER")) {
            int mm = info < 0 || this.is(8) ? 0 : (this.px > this.bc.x + this.bc.w ? 8 : 4);
            if (mm != this.mouseMode) {
                this.mouseMode = mm;
                this.refresh(this.bc);
                if (info == 0) {
                    info = 1;
                }
            }
            if (this.is(128) && Math.abs(info) == 9) {
                this.refreshValue();
            }
            this.formatReadOut(info);
        }
        if (!name.equals("BUTTON")) {
            return -1;
        }
        if (info == 3 && !this.is(1)) {
            this.sendMessage();
            this.close();
        } else if (info == 1 && this.px > this.bc.x && this.isFileChooser()) {
            this.gf = new GFiles(this.parent, "GFILE", this.seed, this.filt, this.raux, this.M, this.aw, this.ah, this.flags & 0xFFFFFFFE, this);
        } else if (info == 2 && this.px < this.bc.x) {
            this.configure();
        } else if (info > 0 && this.px > this.bt.x && !this.is(8) && !this.edit) {
            this.edit = true;
            this.setup();
            this.jtexti.setText(this.seed);
            this.panel.add((Component)this.jtexti, 0);
            this.placeTextInput(this.bc, this.jtexti);
            this.jtexti.requestFocus();
        }
        return 1;
    }

    public boolean isFileChooser() {
        return this.filt != null && this.raux != null;
    }

    @Override
    public int processMessage(Message msg) {
        if (this.status != -3) {
            if (msg.name.equals("GPROMPT.CFG")) {
                this.flags = msg.info;
                this.setup();
                this.refresh();
            } else if (msg.name.equals("GFILE")) {
                this.filt = this.gf.getFilter();
                this.raux = this.gf.getAuxList();
                this.setAction((String)msg.data);
                if (!this.is(1)) {
                    this.close();
                }
            } else {
                return super.processMessage(msg);
            }
        }
        return -1;
    }

    public void setAux(String aux) {
        this.raux = aux;
    }

    public String getAux() {
        return this.raux;
    }

    public void setFilter(String filt) {
        this.filt = filt;
    }

    public String getFilter() {
        return this.filt;
    }

    public String getSeed() {
        return this.seed;
    }

    public int getDigits() {
        return this.digits;
    }

    @Override
    public String toString() {
        return this.toList((String)this.getValue(), "");
    }

    public void setSelectedTextColor(Color c) {
        this.jtexti.setSelectedTextColor(c);
    }

    public Color getSelectedTextColor() {
        return this.jtexti.getSelectedTextColor();
    }

    public void setSelectionColor(Color c) {
        this.jtexti.setSelectionColor(c);
    }

    public Color getSelectionColor() {
        return this.jtexti.getSelectionColor();
    }

    public void setSelectedTextColor(String color) {
        this.setSelectedTextColor(MColor.getColor(color));
    }

    public String getSelectedTextColorString() {
        return MColor.toString(this.getSelectedTextColor());
    }

    public void setSelectionColor(String c) {
        this.setSelectionColor(MColor.getColor(c));
    }

    public String getSelectionColorString() {
        return MColor.toString(this.getSelectionColor());
    }

    public class MPlainDocument
    extends PlainDocument {
        private static final long serialVersionUID = 2012021000311L;
        private int limit;

        public MPlainDocument(int limit) {
            this.limit = limit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= this.limit) {
                super.insertString(offset, str, attr);
            } else if ((GPrompt.this.flags & 0x400) == 0) {
                GPrompt.this.M.warning("GPrompt: Text not accepted. Character limit of " + GPrompt.this.digits + " has been reached.");
            }
        }
    }
}

