/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.util.concurrent.ConcurrentHashMap;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Shell;
import nxm.sys.libg.Feature;
import nxm.sys.libg.FeatureGroup;

@InternalUseOnly(value="Prototype")
public class FeatureGroupMap
extends ConcurrentHashMap<String, FeatureGroup> {
    private static final long serialVersionUID = 2070042463608891913L;

    public void addFeatureToGroup(Feature feature, FeatureGroup featureGroup) {
        if (!this.containsKey(feature.getGroup())) {
            this.put(feature.getGroup(), featureGroup);
        }
        ((FeatureGroup)this.get(feature.getGroup())).addFeature(feature);
    }

    @InternalUseOnly
    public void moveFeatureToGroup(String oldGroup, Feature feature) {
        String newGroup;
        FeatureGroup fg = (FeatureGroup)this.get(oldGroup);
        if (fg != null) {
            fg.removeFeature(feature);
        }
        FeatureGroup fGroup = this.contains(newGroup = feature.getGroup()) ? (FeatureGroup)this.get(newGroup) : new FeatureGroup(feature);
        this.addFeatureToGroup(feature, fGroup);
    }

    @InternalUseOnly
    public void moveAllFeatures(String oldGroup, String newGroup) {
        if (oldGroup.equals(newGroup)) {
            return;
        }
        if (!this.containsKey(oldGroup)) {
            Shell.warning("No group " + oldGroup + " found.");
            return;
        }
        ((FeatureGroup)this.get(oldGroup)).moveAllFeaturesToNewGroup(newGroup);
    }
}

