/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.lang.reflect.Method;
import java.util.ArrayList;
import nxm.sys.inc.IDable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.ShellParent;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Import;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.OptionTree;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;

public final class XmUtil {
    private static final String XMSHELLPARENT = "nxm.sys.libxm.XmShellParent";
    public static final int LENGTH_MQH = 32;
    public static final int LENGTH_MQH_H = 120;
    public static final byte SLOTS_MQH = 4;
    public static final byte SLOTS_MQH_H = 15;
    public static final int LENGTH_MQD = 8192;
    private static final XmMessageHandler[] MSG_HANDLER = XmUtil.createXmMsgHandlers();
    private static final String[] xmSymbolNames = new String[]{"NULL", "DOT", "CIRCLE", "SQUARE", "PLUS", "CROSS", "UTRI", "DTRI"};
    public static final int NAMED_AUX = Integer.MIN_VALUE;
    public static final String NAMED_AUX_STR = Integer.toString(Integer.MIN_VALUE);
    private static final boolean OLD_NEXTOPT = true;
    public static final int MAX_AUX_NUM = 0xFFFFFF;
    public static final int XM_AUX_FLAG = 0x1000000;
    public static final int NXM_AUX_FLAG = 0x2000000;
    public static final int OLD_AUX_FLAG = 0x4000000;
    public static final int GENMSG_TBL = 1;
    public static final int GENMSG_INC = 2;

    private XmUtil() {
    }

    private static boolean isXMidasRunning() {
        ShellParent shellParent = Shell.getCurrent().parent;
        return shellParent != null && shellParent.getClass().getName().equals(XMSHELLPARENT);
    }

    private static int _idx(int NCOMP, int a, int b) {
        if (a < 1 || a > NCOMP) {
            throw new ArrayIndexOutOfBoundsException(a - 1);
        }
        if (b < 1) {
            throw new ArrayIndexOutOfBoundsException(b - 1);
        }
        return a - 1 + (b - 1) * NCOMP;
    }

    private static int interpd(int NIN, double TSTRI, double TDELI, double[] TVIN, int NOUT, double TSTRO, double TDELO, double[] TVOUT, int NCOMP, int NORDER) {
        int MAXL = 100;
        double[] A0 = new double[101];
        double[] A1 = new double[101];
        double[] A2 = new double[101];
        double[] A3 = new double[101];
        int NERR = 0;
        int KLAST = -1;
        double TDELINV = 1.0 / TDELI;
        boolean HOLD = false;
        boolean LINEAR = false;
        for (int NVEC = 1; NVEC <= NOUT; ++NVEC) {
            int N;
            double TT = TSTRO + (double)(NVEC - 1) * TDELO;
            int K = (int)((TT - TSTRI) * TDELINV + 1.0);
            K = Math.max(K, 0);
            K = Math.min(K, NIN);
            int KK = Math.max(K, 1);
            double T = (TT - ((double)(K - 1) * TDELI + TSTRI)) * TDELINV;
            if (K != KLAST) {
                HOLD = NORDER == 0 || K == 0 || K == NIN;
                LINEAR = NORDER == 1 || K == 1 || K == NIN - 1;
                for (N = 1; N <= NCOMP; ++N) {
                    double aa3;
                    double aa1;
                    double aa0;
                    A0[N] = aa0 = TVIN[XmUtil._idx(NCOMP, N, KK)];
                    if (HOLD) continue;
                    double yy1 = TVIN[XmUtil._idx(NCOMP, N, K + 1)];
                    A1[N] = yy1 - aa0;
                    if (LINEAR) continue;
                    A1[N] = aa1 = 0.5 * (yy1 - TVIN[XmUtil._idx(NCOMP, N, K - 1)]);
                    A3[N] = aa3 = 0.5 * (TVIN[XmUtil._idx(NCOMP, N, K + 2)] + 3.0 * aa0) - yy1 - yy1 + aa1;
                    A2[N] = yy1 - aa1 - aa3 - aa0;
                }
            }
            for (N = 1; N <= NCOMP; ++N) {
                double s = A0[N];
                if (!HOLD) {
                    s += A1[N] * T;
                    if (!LINEAR) {
                        s += T * T * (A2[N] + A3[N] * T);
                    }
                }
                TVOUT[XmUtil._idx((int)NCOMP, (int)N, (int)NVEC)] = s;
            }
            KLAST = K;
            if (HOLD) {
                NERR = 2;
            }
            if (!LINEAR) continue;
            NERR = Math.max(NERR, 1);
        }
        return NERR;
    }

    private static int interp(int NIN, double TSTRI, double TDELI, float[] TVIN, int NOUT, double TSTRO, double TDELO, float[] TVOUT, int NCOMP, int NORDER) {
        int MAXL = 100;
        float[] A0 = new float[101];
        float[] A1 = new float[101];
        float[] A2 = new float[101];
        float[] A3 = new float[101];
        int NERR = 0;
        int KLAST = -1;
        double TDELINV = 1.0 / TDELI;
        boolean HOLD = false;
        boolean LINEAR = false;
        for (int NVEC = 1; NVEC <= NOUT; ++NVEC) {
            int N;
            double TT = TSTRO + (double)(NVEC - 1) * TDELO;
            int K = (int)((TT - TSTRI) * TDELINV + 1.0);
            K = Math.max(K, 0);
            K = Math.min(K, NIN);
            int KK = Math.max(K, 1);
            double T = (TT - ((double)(K - 1) * TDELI + TSTRI)) * TDELINV;
            if (K != KLAST) {
                HOLD = NORDER == 0 || K == 0 || K == NIN;
                LINEAR = NORDER == 1 || K == 1 || K == NIN - 1;
                for (N = 1; N <= NCOMP; ++N) {
                    float aa0;
                    A0[N] = aa0 = TVIN[XmUtil._idx(NCOMP, N, KK)];
                    if (HOLD) continue;
                    float yy1 = TVIN[XmUtil._idx(NCOMP, N, K + 1)];
                    A1[N] = yy1 - aa0;
                    if (LINEAR) continue;
                    double aa1 = 0.5 * (double)(yy1 - TVIN[XmUtil._idx(NCOMP, N, K - 1)]);
                    A1[N] = (float)aa1;
                    double aa3 = 0.5 * ((double)TVIN[XmUtil._idx(NCOMP, N, K + 2)] + 3.0 * (double)aa0) - (double)yy1 - (double)yy1 + aa1;
                    A3[N] = (float)aa3;
                    A2[N] = (float)((double)yy1 - aa1 - aa3 - (double)aa0);
                }
            }
            for (N = 1; N <= NCOMP; ++N) {
                float s = A0[N];
                if (!HOLD) {
                    s = (float)((double)s + (double)A1[N] * T);
                    if (!LINEAR) {
                        s = (float)((double)s + T * T * ((double)A2[N] + (double)A3[N] * T));
                    }
                }
                TVOUT[XmUtil._idx((int)NCOMP, (int)N, (int)NVEC)] = s;
            }
            KLAST = K;
            if (HOLD) {
                NERR = 2;
            }
            if (!LINEAR) continue;
            NERR = Math.max(NERR, 1);
        }
        return NERR;
    }

    public static int interpd(int NIN, double TSTRI, double TDELI, Data TVIN, int NOUT, double TSTRO, double TDELO, Data TVOUT, int NCOMP, int NORDER) {
        double[] _TVIN = TVIN.castD(true);
        double[] _TVOUT = TVOUT.castD(false);
        int NERR = XmUtil.interpd(NIN, TSTRI, TDELI, _TVIN, NOUT, TSTRO, TDELO, _TVOUT, NCOMP, NORDER);
        TVIN.uncast(_TVIN, false);
        TVOUT.uncast(_TVOUT, true);
        return NERR;
    }

    public static int interp(int NIN, double TSTRI, double TDELI, Data TVIN, int NOUT, double TSTRO, double TDELO, Data TVOUT, int NCOMP, int NORDER) {
        float[] _TVIN = TVIN.castF(true);
        float[] _TVOUT = TVOUT.castF(false);
        int NERR = XmUtil.interp(NIN, TSTRI, TDELI, _TVIN, NOUT, TSTRO, TDELO, _TVOUT, NCOMP, NORDER);
        TVIN.uncast(_TVIN, false);
        TVOUT.uncast(_TVOUT, true);
        return NERR;
    }

    private static XmMessageHandler[] createXmMsgHandlers() {
        XmMessageHandler[] handlers = new XmMessageHandler[128];
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i] = XmUtil.isXMidasRunning() ? new XmMessageHandler(i) : null;
        }
        return handlers;
    }

    static String getCMsgTypeDef(String type, String name, boolean cpp) {
        switch (type.charAt(0)) {
            case 'B': {
                return "int_1        " + name;
            }
            case 'I': {
                return "int_2        " + name;
            }
            case 'L': {
                return "int_4        " + name;
            }
            case 'X': {
                return "int_8        " + name;
            }
            case 'F': {
                return "real_4       " + name;
            }
            case 'D': {
                return "real_8       " + name;
            }
            case 'A': {
                if (cpp) {
                    return "fstring<8>   " + name;
                }
                return "char         " + name + "[8]";
            }
            case 'Z': {
                if (cpp) {
                    return "fstring<256>   " + name;
                }
                return "char         " + name + "[256]";
            }
            case 'S': {
                if (cpp) {
                    return "fstring<" + XmUtil.getBytesForMsgType(type) + ">  " + name;
                }
                return "char         " + name + "[" + XmUtil.getBytesForMsgType(type) + "]";
            }
        }
        throw new MidasException("Unknown data type '" + type + "'.");
    }

    public static String getFortranMsgTypeDef(String type) {
        switch (type.charAt(0)) {
            case 'B': {
                return "byte";
            }
            case 'I': {
                return "integer*2";
            }
            case 'L': {
                return "integer*4";
            }
            case 'X': {
                return "integer*8";
            }
            case 'F': {
                return "real*4";
            }
            case 'D': {
                return "real*8";
            }
            case 'A': {
                return "character*8";
            }
            case 'Z': {
                return "character*256";
            }
            case 'S': {
                return "character*" + XmUtil.getBytesForMsgType(type);
            }
        }
        throw new MidasException("Unknown data type '" + type + "'.");
    }

    public static int getBytesForMsgType(String type) {
        char msgType = type.charAt(0);
        if (Data.validType(msgType)) {
            return Data.getBPS(msgType);
        }
        switch (type.charAt(0)) {
            case 'S': 
            case 'U': {
                return type.length() == 1 ? 1 : Convert.o2l(type.substring(2, type.length() - 1));
            }
        }
        throw new MidasException("Unknown data type '" + type + "'.");
    }

    public static MessageHandler getXmMessageHandler(Object id) {
        if (id instanceof XmMessageHandler) {
            return (XmMessageHandler)id;
        }
        if (id == null) {
            return null;
        }
        String str = id.toString();
        if (str.length() < 4 || !str.toUpperCase().startsWith("XM.")) {
            return null;
        }
        String num = str.substring(3);
        if (!StringUtil.isInteger(num)) {
            return null;
        }
        int xmId = Convert.s2l(num);
        if (xmId < 0 || xmId > 127) {
            return null;
        }
        return MSG_HANDLER[xmId];
    }

    public static String getXmSymbolName(int id) {
        if (id >= 0 && id < xmSymbolNames.length) {
            return xmSymbolNames[id];
        }
        return null;
    }

    public static String[] getXmSymbolNames() {
        return xmSymbolNames;
    }

    public static String checkAuxName(String name) {
        String prefix = "";
        String aux = name;
        if (aux.startsWith("-")) {
            aux = aux.substring(1);
            prefix = "-";
        } else if (aux.startsWith("+")) {
            aux = aux.substring(1);
            prefix = "+";
        }
        if (name.equals(NAMED_AUX_STR)) {
            name = null;
        } else if (StringUtil.isInteger(aux)) {
            int num = Convert.o2l(aux);
            name = prefix + XmUtil.getAuxName(num);
        }
        return name;
    }

    public static String getAuxName(int num) {
        return XmUtil.getAuxName(num, true);
    }

    public static synchronized String getAuxName(int num, boolean error) {
        String name = XmUtil.nxmAuxNumToName(num);
        if (name == null && Shell.isNeXtOpt()) {
            if (num == 0) {
                name = "CWD";
            } else if (num == 98) {
                name = "HOMEPATH";
            } else if (num == 99) {
                name = "DAT";
            } else if (num == 0x4000000) {
                name = "RAM";
            } else if (num == 0x4000001) {
                name = "XMPIPE";
            } else if (num == 0x4000002) {
                name = "HOME";
            } else {
                throw new MidasException("Can not map AUX number to name in X-Midas at this time.");
            }
        }
        if (error && name == null) {
            throw new MidasException("Illegal AUX number " + num);
        }
        return name;
    }

    public static synchronized int getAuxNumber(String name) {
        if (name.equals("READ")) {
            throw new MidasException("Invalid AUX name '" + name + "'.");
        }
        if (name.equals("WRITE")) {
            throw new MidasException("Invalid AUX name '" + name + "'.");
        }
        if (name.equals("ALL")) {
            throw new MidasException("Invalid AUX name '" + name + "'.");
        }
        int num = XmUtil.nxmAuxNameToNum(name);
        if (num < 0 && Shell.isNeXtOpt()) {
            if (name.equals("CWD")) {
                num = 0;
            } else if (name.equals("HOMEPATH")) {
                num = 98;
            } else if (name.equals("DAT")) {
                num = 99;
            } else if (name.equals("RAM")) {
                num = 0x4000000;
            } else if (name.equals("XMPIPE")) {
                num = 0x4000001;
            } else if (name.equals("HOME")) {
                num = 0x4000002;
            } else if (StringUtil.isInteger(name)) {
                num = Convert.o2l(name);
            } else {
                throw new MidasException("Can not map AUX name '" + name + "' X-Midas AUX number at this time.");
            }
        }
        return num;
    }

    public static String getAuxAlias(String name) {
        String alias = null;
        if (name.equals("READ")) {
            throw new MidasException("Invalid AUX name '" + name + "'.");
        }
        if (name.equals("WRITE")) {
            throw new MidasException("Invalid AUX name '" + name + "'.");
        }
        if (name.equals("ALL")) {
            throw new MidasException("Invalid AUX name '" + name + "'.");
        }
        alias = name.equals("0") ? "CWD" : (name.equals("98") ? "HOMEPATH" : (name.equals("99") ? "DAT" : (name.equals("CWD") ? "0" : (name.equals("HOMEPATH") ? "98" : (name.equals("DAT") ? "99" : (name.startsWith("_") && name.endsWith("_") ? null : null))))));
        if (alias != null && XmUtil.auxExists(alias)) {
            alias = null;
        }
        return alias;
    }

    private static int nxmAuxNameToNum(String name) {
        int num = name.equals("CWD") && !XmUtil.auxExists("0") ? 0 : (name.equals("HOMEPATH") && !XmUtil.auxExists("98") ? 98 : (name.equals("DAT") && !XmUtil.auxExists("99") ? 99 : (StringUtil.isNumber(name) ? Convert.s2l(name) : Integer.MIN_VALUE)));
        return num;
    }

    private static String nxmAuxNumToName(int num) {
        String name = num == 0 && !XmUtil.auxExists("0") ? "CWD" : (num == 98 && !XmUtil.auxExists("98") ? "HOMEPATH" : (num == 99 && !XmUtil.auxExists("99") ? "DAT" : Integer.toString(num)));
        return name;
    }

    private static boolean auxExists(String aux) {
        Table resTable = Shell.getSharedMidasContext().getResults();
        Table auxTable = resTable.getTable("AUX");
        return auxTable.containsKey(aux);
    }

    public static void genmsg(Midas midas, String xmdisk, String opt, String path, int fmt) {
        if (opt == null) {
            throw new MidasException("GenMsg: Unknown option OPT=" + opt);
        }
        if (opt.length() <= 0) {
            throw new MidasException("GenMsg: Unknown option OPT=" + opt);
        }
        String addOpt = xmdisk == null ? "SYS,XBC" : "SYS";
        Table inFiles = new Table();
        Parser parser = new Parser(opt + "," + path + "," + addOpt);
        parser.clean(true);
        for (int i = 1; i <= parser.elements(); ++i) {
            TextFile tf;
            String inOpt = parser.get(i).toUpperCase();
            if (inOpt.length() <= 1 || (tf = XmUtil.openFile(midas, xmdisk, "messages.cfg", "cfg", inOpt, true)) == null) continue;
            if (inFiles.containsKey(inOpt)) {
                tf.close();
                continue;
            }
            inFiles.put(inOpt, (Object)tf);
        }
        Table msgdefs = new Table();
        String[] opts = inFiles.getKeys();
        for (int i = opts.length - 1; i >= 0; --i) {
            TextFile file = (TextFile)inFiles.get(opts[i]);
            XmUtil.processInputFile(midas, msgdefs, file, opts[i]);
            file.close();
        }
        if ((fmt & 1) != 0) {
            if (xmdisk == null) {
                XmUtil.writeMessagesTbl(midas, xmdisk, msgdefs, opt, path, inFiles.getKeyList());
            } else {
                XmUtil.writeQmessagesTbl(midas, xmdisk, msgdefs, opt, path, inFiles.getKeyList());
            }
        }
        if ((fmt & 2) != 0) {
            String[] configOpts = inFiles.getKeys();
            XmUtil.writeQmessagesInc(midas, xmdisk, msgdefs, opt);
            XmUtil.writeQmessdeclInc(midas, xmdisk, msgdefs, opt, configOpts);
            XmUtil.writeQmessdefInc(midas, xmdisk, msgdefs, opt, configOpts);
            XmUtil.writeQmessdeclHeader(midas, xmdisk, msgdefs, opt, configOpts);
            XmUtil.writeQmessdefHeader(midas, xmdisk, msgdefs, opt, configOpts, false);
            XmUtil.writeQmessdefHeader(midas, xmdisk, msgdefs, opt, configOpts, true);
        }
    }

    private static void processInputFile(Midas midas, Table msgdefs, TextFile file, String opt) {
        Table curdef = null;
        Table curtags = null;
        String shared = null;
        String line = file.read();
        String next = file.read();
        while (line != null) {
            String comment;
            line = line.trim();
            if ((line = line.replace('\t', ' ')).startsWith("&")) {
                throw new MidasException("CONVERT: Can not handle line-continuations yet.");
            }
            int commentStart = line.indexOf(33);
            if (commentStart >= 0) {
                comment = line.substring(commentStart + 1).trim();
                line = line.substring(0, commentStart).trim().replace('\"', '\'');
            } else {
                line = line.trim();
                comment = null;
            }
            while (line != null && line.length() > 0) {
                String more;
                int commaPos = line.indexOf(44);
                if (commaPos > 0) {
                    more = line.substring(commaPos + 1).trim();
                    line = line.substring(0, commaPos).trim();
                } else {
                    more = null;
                }
                String lineUC = line.toUpperCase();
                if (line.length() != 0) {
                    if (lineUC.startsWith("NAME ")) {
                        if (curdef != null) {
                            XmUtil.updateTypeStr(curdef);
                        }
                        curdef = new Table();
                        curtags = new Table();
                        shared = "";
                        String tag = lineUC.substring(5).trim();
                        if (msgdefs.containsKey(tag)) {
                            midas.warning("Message /" + tag + "/ overridden by definition in " + opt + " option.");
                        }
                        msgdefs.setKey(tag, curdef);
                        curdef.setKey("TAGS", curtags);
                        String name = tag;
                        if (name.endsWith("INFO")) {
                            name = "=" + name.substring(0, name.length() - 4);
                        }
                        if (name.length() > 8) {
                            name = name.substring(0, 8);
                        }
                        curdef.setKey("NAME", name);
                        if (comment != null) {
                            curdef.setKey("COMMENT", comment);
                        }
                    } else {
                        if (curdef == null || curtags == null) {
                            throw new MidasException("Illegal definition " + line);
                        }
                        if (lineUC.startsWith("USES ")) {
                            shared = XmUtil.copySharedTags(msgdefs, curtags, shared, lineUC.substring(5).trim());
                        } else if (lineUC.startsWith("INFOALIAS ")) {
                            curdef.setKey("INFOALIAS", lineUC.substring(10).trim());
                        } else if (lineUC.equals("SHARED")) {
                            curdef.setKey("SHARED", shared);
                            shared = null;
                        } else {
                            int nameStart = line.indexOf(58);
                            Table tbl = new Table();
                            String type = lineUC.substring(0, nameStart);
                            String name = lineUC.substring(nameStart + 1);
                            tbl.setKey("TYPE", type);
                            if (comment != null) {
                                tbl.setKey("COMMENT", comment);
                            }
                            curtags.setKey(name, tbl);
                            if (shared != null) {
                                shared = shared.length() == 0 ? name : shared + "," + name;
                            }
                        }
                    }
                }
                line = more;
            }
            if (curdef != null) {
                XmUtil.updateTypeStr(curdef);
            }
            line = next;
            next = file.read();
        }
    }

    private static void updateTypeStr(Table def) {
        Table tags = def.getTable("TAGS");
        String[] tagNames = tags.getKeys();
        String lastTypeStr = null;
        int lastTypeMult = 0;
        int byteCount = 0;
        char type = ' ';
        StringBuilder types = new StringBuilder();
        for (int j = 0; j < tagNames.length; ++j) {
            String typeStr = tags.getTable(tagNames[j]).getS("TYPE");
            byteCount += XmUtil.getBytesForMsgType(typeStr);
            if (j == 0) {
                type = typeStr.length() == 1 ? (char)typeStr.charAt(0) : (char)'H';
            } else if (typeStr.length() != 1 || typeStr.charAt(0) != type) {
                type = 'H';
            }
            if (lastTypeStr == null) {
                lastTypeStr = typeStr;
                lastTypeMult = 1;
                continue;
            }
            if (typeStr.equals(lastTypeStr)) {
                ++lastTypeMult;
                continue;
            }
            if (lastTypeStr != null) {
                if (lastTypeMult > 1) {
                    types.append(lastTypeMult);
                }
                types.append(lastTypeStr);
            }
            lastTypeStr = typeStr;
            lastTypeMult = 1;
        }
        if (lastTypeStr != null) {
            if (lastTypeMult > 1) {
                types.append(lastTypeMult);
            }
            types.append(lastTypeStr);
        }
        def.setKey("TYPE", Character.toString(type));
        if (type == 'H') {
            def.setKey("NSLOTS", Integer.toString((byteCount + 7) / 8 + 15));
            def.setKey("NHSLOTS", Integer.toString(15));
            def.setKey("TYPES", types.toString());
        } else {
            def.setKey("NSLOTS", Integer.toString((byteCount + 7) / 8 + 4));
            def.setKey("NHSLOTS", Integer.toString(4));
        }
    }

    private static String copySharedTags(Table msgdefs, Table curtags, String shared, String name) {
        Table def = msgdefs.getTable(name);
        if (def != null) {
            String sharedTags = def.getS("SHARED");
            if (sharedTags != null && sharedTags.length() > 0) {
                Table tags = def.getTable("TAGS");
                String[] tagNames = sharedTags.split(",");
                for (int i = 0; i < tagNames.length; ++i) {
                    curtags.setKey(tagNames[i], tags.getTable(tagNames[i]));
                }
                if (shared != null) {
                    shared = shared.length() == 0 ? sharedTags : shared + ", " + sharedTags;
                }
            }
        } else {
            throw new MidasException("Can not include " + name + " for USES " + name);
        }
        return shared;
    }

    private static TextFile openFile(Midas midas, String xmdisk, String name, String area, String opt, boolean input) {
        String optPath;
        Table allOpts = OptionTree.getAllOptions(midas);
        String fname = null;
        int flags = input ? 33 : 4130;
        String optUC = opt.toUpperCase();
        opt = opt.toLowerCase();
        area = area.toLowerCase();
        if (xmdisk != null && opt.equals("sys")) {
            fname = xmdisk + "/xm/" + area + "/" + name;
        } else if (xmdisk != null && opt.equals("nxm")) {
            fname = "nxm.sys." + area + "." + name;
        } else if (allOpts.containsKey(optUC)) {
            fname = "nxm." + opt + "." + area + "." + name;
        } else if (xmdisk != null && (optPath = Import.getEnv("XMAREA_" + optUC)) != null) {
            midas.warning("Option tree " + optUC + " not defined in NeXtMidas, using " + optPath + " for now.");
            fname = optPath + "/" + area + "/" + name;
        }
        if (fname == null) {
            throw new MidasException("Option tree " + optUC + " undefined.");
        }
        FileName fnFname = new FileName(fname, FileName.FNCase.KeepCase);
        TextFile file = new TextFile(fnFname);
        file.open(flags);
        if (!file.open()) {
            if (!input) {
                throw new MidasException("GENNMMSG: Can not open output file " + file.getURL());
            }
            file = null;
        } else if (!input) {
            midas.info("Creating " + file.getURL());
        }
        return file;
    }

    private static void writeMessagesTbl(Midas midas, String xmdisk, Table msgdefs, String opt, String path, String configOpts) {
        TextFile tf = XmUtil.openFile(midas, xmdisk, "messages.tbl", "cfg", opt, false);
        tf.writeln("!");
        tf.writeln("! ** This file was autogenerated by CONVERT " + opt + " MSGCFG2TBL **");
        tf.writeln("! ** DO NOT MODIFY! **");
        tf.writeln("!");
        tf.writeln("! Contains the NeXtMidas message mappings for X-Midas messages.");
        tf.writeln("! These mappings are used when running an X-Midas command from");
        tf.writeln("! NeXtMidas using the XBC option tree. Please see qmessages.tbl");
        tf.writeln("! (if present) for message mapping used when NeXtMidas is run as");
        tf.writeln("! an X-Midas option tree.");
        tf.writeln("!");
        tf.writeln("! FOR     OPT : " + opt);
        tf.writeln("! CURRENT PATH: " + path);
        tf.writeln("! Option trees with messages.cfg in PATH: " + configOpts);
        tf.writeln("!");
        msgdefs.toTextFile(tf);
        tf.close();
    }

    private static void writeQmessagesTbl(Midas midas, String xmdisk, Table msgdefs, String opt, String path, String configOpts) {
        TextFile tf = XmUtil.openFile(midas, xmdisk, "qmessages.tbl", "cfg", opt, false);
        tf.writeln("!");
        tf.writeln("! ** This file was autogenerated by CONVERT " + opt + " MSGCFG2TBL **");
        tf.writeln("! ** DO NOT MODIFY! **");
        tf.writeln("!");
        tf.writeln("! Contains the NeXtMidas message mappings for X-Midas messages.");
        tf.writeln("! These mappings are used when NeXtMidas is running an X-Midas");
        tf.writeln("! option tree. Please see messages.tbl (if present) for message");
        tf.writeln("! mapping used by the XBC option tree.");
        tf.writeln("!");
        tf.writeln("! FOR     OPT : " + opt);
        tf.writeln("! CURRENT PATH: " + path);
        tf.writeln("! Option trees with messages.cfg in PATH: " + configOpts);
        tf.writeln("!");
        msgdefs.toTextFile(tf);
        tf.close();
    }

    private static void writeQmessagesInc(Midas midas, String xmdisk, Table msgdefs, String opt) {
        TextFile tf = XmUtil.openFile(midas, xmdisk, "qmessages.inc", "inc", opt, false);
        tf.writeln("c************");
        tf.writeln("c  Description: Contains common X-Midas system message definitions,");
        tf.writeln("c  declared structures of their types, and the bit values used by MSGMASK");
        tf.writeln("c************");
        tf.writeln("");
        tf.writeln("");
        tf.writeln("\tinclude 'qmessdef.inc'");
        tf.writeln("\tinclude 'qmessdecl.inc'");
        tf.writeln("\tinclude 'msgmask.inc'");
        tf.close();
    }

    private static void writeFortranHeaderComments(TextFile tf, String opt, String[] configOpts) {
        tf.writeln("c");
        tf.writeln("c Automatically generated by CONVERT " + opt + " MSGCFG2INC");
        tf.writeln("c");
        tf.writeln("c Configuration: " + opt);
        for (String option : configOpts) {
            tf.writeln("c   Option " + option + " from " + Shell.getOptPath(option, "cfg") + "messages.cfg");
        }
    }

    private static void writeQmessdeclInc(Midas midas, String xmdisk, Table msgdefs, String opt, String[] configOpts) {
        TextFile tf = XmUtil.openFile(midas, xmdisk, "qmessdecl.inc", "inc", opt, false);
        String[] keys = msgdefs.getKeys();
        XmUtil.writeFortranHeaderComments(tf, opt, configOpts);
        tf.writeln("");
        for (String key : keys) {
            String name = "MQH_" + key;
            if (name.length() < 15) {
                tf.writeln("\trecord /" + name + "/\t\t" + name);
                continue;
            }
            tf.writeln("\trecord /" + name + "/\t" + name);
        }
        tf.writeln("");
        tf.writeln("\trecord /MQ_HEADER/\tMQH");
        tf.writeln("\trecord /MQ_DATA/\tMQD");
        tf.close();
    }

    private static void writeQmessdefInc(Midas midas, String xmdisk, Table msgdefs, String opt, String[] configOpts) {
        TextFile tf = XmUtil.openFile(midas, xmdisk, "qmessdef.inc", "inc", opt, false);
        boolean INFO = false;
        boolean MODE = false;
        ArrayList<String> mapping = new ArrayList<String>();
        String[] keys = msgdefs.getKeys();
        int lengthMqh = 0;
        int lengthMqd = 0;
        XmUtil.writeFortranHeaderComments(tf, opt, configOpts);
        tf.writeln("");
        tf.writeln("\tinclude 'queue.inc'");
        tf.writeln("");
        for (int i = 0; i < keys.length; ++i) {
            Table def = msgdefs.getTable(keys[i]);
            Table tags = def.getTable("TAGS");
            String[] tagNames = tags.getKeys();
            int ndata = tagNames.length;
            char type = (def.getS("TYPE", "") + " ").charAt(0);
            short nslots = def.getI("NSLOTS");
            short nhslots = def.getI("NHSLOTS");
            String name = def.getS("NAME");
            String alias = def.getS("INFOALIAS", "info").toLowerCase();
            String types = def.getS("TYPES", "");
            int ntype = types.length();
            lengthMqh = Math.max(lengthMqh, nhslots * 8);
            lengthMqd = 8192;
            tf.writeln("\tSTRUCTURE /MQH_" + keys[i] + "/");
            tf.writeln("\t  integer*4\treader");
            tf.writeln("\t  integer*2\tnslots\t/" + nslots + "/");
            tf.writeln("\t  character*1\ttype\t/'" + type + "'/");
            tf.writeln("\t  byte\t\tnhslots\t/" + nhslots + "/");
            tf.writeln("\t  integer*4\tsender");
            tf.writeln("\t  integer*4\tndata\t/" + ndata + "/");
            tf.writeln("\t  integer*4\t" + alias + "\t/" + 0 + "/");
            tf.writeln("\t  integer*4\tmode\t/0/");
            tf.writeln("\t  character*8\tname\t/'" + name + "'/");
            if (type == 'H') {
                tf.writeln("\t  integer*2\tntype\t/" + ntype + "/");
                tf.writeln("\t  character*86\ttypes\t/'" + types + "'/");
            }
            tf.writeln("\tEND STRUCTURE");
            tf.writeln("");
            if (tagNames.length > 0) {
                tf.writeln("\tSTRUCTURE /MQD_" + keys[i] + "/");
                for (String tagName : tagNames) {
                    String typeDef = XmUtil.getFortranMsgTypeDef(tags.getTable(tagName).getS("TYPE"));
                    tf.writeln("\t  " + typeDef + "\t" + tagName.toLowerCase());
                }
                tf.writeln("\tEND STRUCTURE");
                mapping.add("\t    MAP");
                mapping.add("\t      RECORD /MQD_" + keys[i] + "/ " + keys[i]);
                mapping.add("\t    END MAP");
            }
            tf.writeln("");
        }
        tf.writeln("\tinteger*4\tL_mqh, L_mqd");
        tf.writeln("\tparameter (L_mqh=" + lengthMqh + ")");
        tf.writeln("\tparameter (L_mqd = " + lengthMqd + ")");
        tf.writeln("");
        tf.writeln("\tSTRUCTURE /MQ_DATA/");
        tf.writeln("\t  UNION");
        for (String mappingStr : mapping) {
            tf.writeln(mappingStr);
        }
        tf.writeln("\t    MAP");
        tf.writeln("\t      byte\tbbuf(L_mqd)");
        tf.writeln("\t    END MAP");
        tf.writeln("\t    MAP");
        tf.writeln("\t      integer*2\tibuf(L_mqd/2)");
        tf.writeln("\t    END MAP");
        tf.writeln("\t    MAP");
        tf.writeln("\t      integer*4\tlbuf(L_mqd/4)");
        tf.writeln("\t    END MAP");
        tf.writeln("\t    MAP");
        tf.writeln("\t      real*4\tfbuf(L_mqd/4)");
        tf.writeln("\t    END MAP");
        tf.writeln("\t    MAP");
        tf.writeln("\t      real*8\tdbuf(L_mqd/8)");
        tf.writeln("\t    END MAP");
        tf.writeln("\t    MAP");
        tf.writeln("\t      character*8\tabuf(L_mqd/8)");
        tf.writeln("\t    END MAP");
        tf.writeln("\t    MAP");
        tf.writeln("\t      character*(L_mqd)\tsbuf");
        tf.writeln("\t    END MAP");
        tf.writeln("\t  END UNION");
        tf.writeln("\tEND STRUCTURE");
        tf.close();
    }

    private static String getPoundDefineName(String filename) {
        return "XM_" + filename.replace('.', '_').toUpperCase() + "_";
    }

    private static String toCharArray(String str, int outlen) {
        StringBuilder sb = new StringBuilder(outlen * 4 + 2);
        sb.append('{');
        int strlen = str.length();
        char ch = strlen > 0 ? (char)str.charAt(0) : (char)' ';
        sb.append('\'').append(ch).append('\'');
        for (int i = 1; i < outlen; ++i) {
            ch = i < strlen ? (char)str.charAt(i) : (char)' ';
            sb.append(",'").append(ch).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }

    private static void writeCHeaderComments(TextFile tf, String opt, String[] configOpts) {
        tf.writeln("/*");
        tf.writeln(" * Automatically generated by CONVERT " + opt + " MSGCFG2INC");
        tf.writeln(" *");
        tf.writeln(" * Configuration: " + opt);
        for (String option : configOpts) {
            tf.writeln(" *   Option " + option + " from " + Shell.getOptPath(option, "cfg") + "messages.cfg");
        }
        tf.writeln(" */");
    }

    private static void writeQmessdeclHeader(Midas midas, String xmdisk, Table msgdefs, String opt, String[] configOpts) {
        String poundDefineName = XmUtil.getPoundDefineName("qmessdecl.h");
        TextFile tf = XmUtil.openFile(midas, xmdisk, "qmessdecl.h", "inc", opt, false);
        tf.writeln("#ifndef " + poundDefineName);
        tf.writeln("");
        XmUtil.writeCHeaderComments(tf, opt, configOpts);
        tf.writeln("");
        tf.writeln("#ifdef __cplusplus");
        tf.writeln("#include \"qmessdef.hh\"");
        tf.writeln("#else");
        tf.writeln("#include \"qmessdef.h\"");
        tf.writeln("#endif");
        tf.writeln("");
        String[] keys = msgdefs.getKeys();
        tf.writeln("#ifdef __cplusplus");
        tf.writeln("");
        for (String key : keys) {
            tf.writeln("static mqh_" + StringUtil.padRight(key, 23) + " MQH_" + key + ";");
        }
        tf.writeln("");
        tf.writeln("static MQ_HEADER MQH;");
        tf.writeln("static MQ_DATA   MQD;");
        tf.writeln("");
        tf.writeln("#else");
        tf.writeln("");
        for (String key : keys) {
            tf.writeln("static mqh_" + StringUtil.padRight(key, 23) + " MQH_" + key + " = mqh_" + key + "_INIT;");
        }
        tf.writeln("");
        tf.writeln("static mq_HEADER MQH;");
        tf.writeln("static mq_DATA   MQD;");
        tf.writeln("");
        tf.writeln("#define mqd MQD.MQD_UNION");
        tf.writeln("#endif");
        tf.writeln("");
        tf.writeln("#define " + poundDefineName);
        tf.writeln("#endif /* " + poundDefineName + " */");
        tf.close();
    }

    private static void writeQmessdefHeader(Midas midas, String xmdisk, Table msgdefs, String opt, String[] configOpts, boolean cpp) {
        String outfilename = "qmessdef" + (cpp ? ".hh" : ".h");
        String poundDefineName = XmUtil.getPoundDefineName(outfilename);
        TextFile tf = XmUtil.openFile(midas, xmdisk, outfilename, "inc", opt, false);
        boolean INFO = false;
        boolean MODE = false;
        boolean SENDER = false;
        boolean READER = false;
        ArrayList<String> mapping = new ArrayList<String>();
        String[] keys = msgdefs.getKeys();
        int lengthMqh = 0;
        int lengthMqd = 0;
        if (cpp) {
            tf.writeln("// -*- C++ -*-");
        }
        tf.writeln("#ifndef " + poundDefineName);
        tf.writeln("");
        XmUtil.writeCHeaderComments(tf, opt, configOpts);
        tf.writeln("");
        if (cpp) {
            tf.writeln("#include <queue.h>");
        } else {
            tf.writeln("#include \"queue.h\"");
        }
        tf.writeln("");
        for (String key : keys) {
            Table def = msgdefs.getTable(key);
            Table tags = def.getTable("TAGS");
            String[] tagNames = tags.getKeys();
            int ndata = tagNames.length;
            char type = (def.getS("TYPE", "") + " ").charAt(0);
            short nslots = def.getI("NSLOTS");
            short nhslots = def.getI("NHSLOTS");
            String name = def.getS("NAME");
            String alias = def.getS("INFOALIAS", "info").toLowerCase();
            String types = def.getS("TYPES", "");
            int ntype = types.length();
            lengthMqh = Math.max(lengthMqh, nhslots * 8);
            lengthMqd = 8192;
            if (cpp) {
                tf.writeln("");
                tf.writeln("struct mqh_" + key + " : public MQ_HEADER {");
                if (!"info".equals(alias)) {
                    tf.writeln("  int_4& " + alias + "; // .info field alias");
                    tf.writeln("  mqh_" + key + " () : ");
                    tf.writeln("  " + alias + "(info)");
                } else {
                    tf.writeln("  mqh_" + key + " ()");
                }
                tf.writeln("  {");
                tf.writeln("    nslots = " + nslots + ";");
                tf.writeln("    type = '" + type + "';");
                tf.writeln("    nhslots = " + nhslots + ";");
                tf.writeln("    ndata = " + ndata + ";");
                tf.writeln("    " + alias + " = " + 0 + ";");
                tf.writeln("    mode = 0;");
                tf.writeln("    name = \"" + name + "\";");
                if (type == 'H') {
                    tf.writeln("    ntype = " + ntype + ";");
                    tf.writeln("    types = \"" + types + "\";");
                }
                tf.writeln("  }");
                tf.writeln("};");
            } else {
                tf.writeln("");
                tf.writeln("typedef struct");
                tf.writeln("{");
                tf.writeln("  int_4        reader;");
                tf.writeln("  int_2        nslots;");
                tf.writeln("  char         type;");
                tf.writeln("  int_1        nhslots;");
                tf.writeln("  int_4        sender;");
                tf.writeln("  int_4        ndata;");
                tf.writeln("  int_4        " + alias + ";");
                tf.writeln("  int_4        mode;");
                tf.writeln("  char         name[8];");
                if (type == 'H') {
                    tf.writeln("  int_2        ntype;");
                    tf.writeln("  char         types[86];");
                }
                tf.writeln("} mqh_" + key + ";");
                tf.writeln("");
                tf.writeln("#define mqh_" + key + "_INIT {" + 0 + "," + nslots + "," + type + "," + nhslots + "," + 0 + "," + ndata + "," + 0 + "," + 0 + "," + XmUtil.toCharArray(name, 8) + "," + ntype + "," + XmUtil.toCharArray(types, 86));
            }
            tf.writeln("");
            if (tagNames.length > 0) {
                if (cpp) {
                    tf.writeln("struct MQD_" + key + " {");
                } else {
                    tf.writeln("typedef struct \n{");
                }
                for (String tagName : tagNames) {
                    String tagType = tags.getTable(tagName).getS("TYPE");
                    String typeDef = XmUtil.getCMsgTypeDef(tagType, tagName.toLowerCase(), cpp);
                    tf.writeln("  " + typeDef + ";");
                }
                if (cpp) {
                    tf.writeln("};");
                } else {
                    tf.writeln("} MQD_" + key + ";");
                }
                mapping.add("      MQD_" + StringUtil.padRight(key, 23) + " " + key + ";");
            }
            tf.writeln("");
        }
        tf.writeln("");
        tf.writeln("#define L_mqh " + lengthMqh);
        tf.writeln("#define L_mqd " + lengthMqd);
        tf.writeln("");
        tf.writeln("");
        if (cpp) {
            tf.writeln("union MQ_DATA {");
        } else {
            tf.writeln("typedef struct");
            tf.writeln("{");
            tf.writeln("  union");
            tf.writeln("  {");
        }
        for (String mappingStr : mapping) {
            tf.writeln(mappingStr);
        }
        tf.writeln("");
        tf.writeln("      int_1                   bbuf[L_mqd];");
        tf.writeln("      int_2                   ibuf[L_mqd/2];");
        tf.writeln("      int_4                   lbuf[L_mqd/4];");
        tf.writeln("      real_4                  fbuf[L_mqd/4];");
        tf.writeln("      real_8                  dbuf[L_mqd/8];");
        if (cpp) {
            tf.writeln("      fstring<8>              abuf[L_mqd/8];");
            tf.writeln("      fstring<L_mqd>          sbuf;");
            tf.writeln("}; // end union MQ_DATA");
        } else {
            tf.writeln("      char                    abuf[L_mqd];");
            tf.writeln("      char                    sbuf[L_mqd];");
            tf.writeln("  } MQD_UNION;");
            tf.writeln("#ifdef __cplusplus");
            tf.writeln("} MQ_DATA;");
            tf.writeln("#else");
            tf.writeln("} mq_DATA;");
            tf.writeln("#endif");
        }
        tf.writeln("");
        tf.writeln("#define " + poundDefineName);
        tf.writeln("#endif /* " + poundDefineName + " */");
        tf.close();
    }

    private static class XmMessageHandler
    implements MessageHandler,
    IDable {
        final int id;

        public XmMessageHandler(int xmId) {
            this.id = xmId;
        }

        @Override
        public int processMessage(Message msg) {
            try {
                Class<?> clazz = Class.forName(XmUtil.XMSHELLPARENT);
                Method method = clazz.getMethod("sendXmMessage", Integer.TYPE, Message.class);
                method.invoke(null, this.id, msg);
                return 1;
            }
            catch (Exception e) {
                throw new MidasException("Message: Unable to send message '" + msg + "' to X-Midas: " + e, e);
            }
        }

        @Override
        public String getID() {
            return "XM." + this.id;
        }

        public String toString() {
            return "XM." + this.id;
        }
    }
}

