/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.filechooser.FileSystemView;

final class WindowsAltFileSystemView
extends FileSystemView {
    private static final WindowsAltFileSystemView LIST_ROOTS_VIEWER = new WindowsAltFileSystemView();

    WindowsAltFileSystemView() {
    }

    @Override
    public boolean isRoot(File f) {
        if (!f.isAbsolute()) {
            return false;
        }
        String parentPath = f.getParent();
        if (parentPath == null) {
            return true;
        }
        File parent = new File(parentPath);
        return parent.equals(f);
    }

    @Override
    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir == null) {
            throw new IOException("Containing directory is null:");
        }
        File newFolder = null;
        newFolder = this.createFileObject(containingDir, "New Folder");
        for (int i = 2; newFolder.exists() && i < 100; ++i) {
            newFolder = this.createFileObject(containingDir, "New Folder (" + i + ")");
        }
        if (newFolder.exists()) {
            throw new IOException("Directory already exists:" + newFolder.getAbsolutePath());
        }
        newFolder.mkdirs();
        return newFolder;
    }

    @Override
    public boolean isHiddenFile(File f) {
        return false;
    }

    @Override
    public File[] getRoots() {
        Vector<FileSystemRoot> rootsVector = new Vector<FileSystemRoot>();
        FileSystemRoot floppy = new FileSystemRoot("A:\\");
        rootsVector.addElement(floppy);
        for (char c = 'C'; c <= 'Z'; c = (char)((char)(c + 1))) {
            char[] device = new char[]{c, ':', '\\'};
            String deviceName = new String(device);
            FileSystemRoot deviceFile = new FileSystemRoot(deviceName);
            if (deviceFile == null || !deviceFile.exists()) continue;
            rootsVector.addElement(deviceFile);
        }
        Object[] roots = new File[rootsVector.size()];
        rootsVector.copyInto(roots);
        return roots;
    }

    public static final File[] listRoots() {
        return LIST_ROOTS_VIEWER.getRoots();
    }

    class FileSystemRoot
    extends File {
        private static final long serialVersionUID = 2012020800311L;

        public FileSystemRoot(File f) {
            super(f, "");
        }

        public FileSystemRoot(String s) {
            super(s);
        }

        @Override
        public boolean isDirectory() {
            return true;
        }
    }
}

