/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.net.URL;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.ShellParent;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.OptionTree;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Terminal;

public class Webstart
implements ShellParent {
    private URL codebase = null;

    @InternalUseOnly(value="Since NeXtMidas 3.7.1 - This should never be called directly")
    public static void main(String ... args) {
        int exitCode = 0;
        try {
            Shell.runNew(new Webstart(), StringUtil.join(args, " "), false);
        }
        catch (Throwable t) {
            exitCode = 1;
            t.printStackTrace();
        }
        finally {
            System.exit(exitCode);
        }
    }

    @Deprecated
    @InternalUseOnly(value="Since NeXtMidas 3.7.1 - This should be private.")
    public Webstart() {
        this.initCodebase();
    }

    @Deprecated
    @InternalUseOnly(value="Since NeXtMidas 3.7.1 - This should be private.")
    protected void initCodebase() {
        if (this.codebase != null) {
            return;
        }
        try {
            Object basicSvc = KeyObject.invokeStaticMethod("javax.jnlp.ServiceManager", "lookup", new Object[]{"javax.jnlp.BasicService"});
            this.codebase = (URL)KeyObject.invokeInstanceMethod(basicSvc, "getCodeBase", new Object[0]);
            if (this.codebase == null) {
                System.err.println("WARN: Webstart.initCodebase() unable to get codebase for this application.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getAux() {
        String defAux = "HOME HOME|RAM|DAT";
        String aux = System.getProperty("AUX");
        if (aux == null) {
            aux = "HOME HOME|RAM|DAT";
        }
        return aux;
    }

    public URL getCodeBase() {
        return this.codebase;
    }

    @Override
    public String getNmRoot() {
        return OptionTree.findOptRoot("SYS");
    }

    @Override
    public String getOpts() {
        String opts = Shell.getProperty("OPTS");
        return OptionTree.getOptsHelper(opts, this, true);
    }

    @Override
    public String getCWD() {
        if (this.codebase == null) {
            return null;
        }
        String file = this.codebase.toString();
        int i = file.indexOf(63);
        if (i >= 0) {
            file = file.substring(0, i);
        }
        return file;
    }

    @Override
    public String getNMS() {
        return Shell.getProperty("NMSTARTUP.USER");
    }

    @Override
    public String getHome() {
        return null;
    }

    @Override
    public String getServer() {
        if (this.codebase == null) {
            return null;
        }
        return this.codebase.getHost();
    }

    @Override
    public String getTheme() {
        return Shell.getProperty("ENV.THEME");
    }

    @Override
    public String getStyle() {
        return Shell.getProperty("ENV.STYLE");
    }

    @Override
    public Terminal getTerminal() {
        return null;
    }

    public String toString() {
        return "Webstart\n\tcodebase : " + this.getCodeBase() + "\n\tcwd      : " + this.getCWD();
    }
}

