/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.MidasException;

public class UrlResource
extends IOResource {
    private URL url;
    private URLConnection urlConn;
    private InputStream in;
    private OutputStream out;

    public String toString() {
        return "UrlResource: " + this.getURL();
    }

    @Override
    public void setURL(String urlstr) {
        try {
            this.url = new URI(urlstr).toURL();
            urlstr = this.url.toExternalForm();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new MidasException("UrlResource: Error accessing URL=" + urlstr, e);
        }
        super.setURL(urlstr);
    }

    @Override
    public boolean exists() {
        if (this.url == null) {
            return false;
        }
        try {
            return this.url.openConnection() != null;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    protected URLConnection openConnection(URL url, int dir) throws IOException {
        double timeout = 0.0;
        double connectTimeout = 0.0;
        if (this.qualTable != null) {
            timeout = this.qualTable.getD("TIMEOUT", 0.0);
            connectTimeout = this.qualTable.getD("CONNECTTIMEOUT", timeout);
        }
        URLConnection conn = url.openConnection();
        if (timeout > 0.0) {
            int rtimeout = (int)(timeout * 1000.0);
            conn.setReadTimeout(rtimeout);
            if (rtimeout != conn.getReadTimeout()) {
                this.M.warning("This platform is unable to set timeout for " + url + " to " + rtimeout + " ms using " + conn.getReadTimeout() + " ms.");
            }
        }
        if (connectTimeout > 0.0) {
            int ctimeout = (int)(connectTimeout * 1000.0);
            conn.setConnectTimeout(ctimeout);
            if (ctimeout != conn.getConnectTimeout()) {
                this.M.warning("This platform is unable to set timeout for " + url + " to " + ctimeout + " ms using " + conn.getConnectTimeout() + " ms.");
            }
        }
        if (dir <= 0) {
            conn.setDoInput(true);
        }
        if (dir >= 0) {
            conn.setDoOutput(true);
        }
        return conn;
    }

    @Override
    public boolean open() {
        this.isOpen = false;
        try {
            this.urlConn = this.openConnection(this.url, this.dir);
            if (this.dir <= 0) {
                this.in = this.urlConn.getInputStream();
            }
            if (this.dir >= 0) {
                this.out = this.urlConn.getOutputStream();
            }
            this.isOpen = true;
            if (this.offset != 0L) {
                this.seek(0L, this.offset);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.isOpen;
    }

    @Override
    public boolean close() {
        boolean stat = true;
        stat &= this.closeIO(this.in);
        stat &= this.closeIO(this.out);
        this.in = null;
        this.out = null;
        this.urlConn = null;
        this.offset = 0L;
        this.isOpen = false;
        return stat;
    }

    @Override
    public long getLength() {
        return this.urlConn.getContentLength();
    }

    private void seek(long offset, long off) {
        try {
            if (this.in != null) {
                this.in.skip(off - offset);
            }
            offset = off;
        }
        catch (IOException e) {
            throw new MidasException("Unable to seek to " + off + " URL=" + this.url, e);
        }
    }

    @Override
    public boolean seek(long off) {
        if (this.isOpen && off != this.offset) {
            if (off > this.offset) {
                this.seek(this.offset, off);
            } else {
                this.close();
                this.offset = off;
                this.open();
            }
        }
        return true;
    }

    @Override
    public long avail() {
        if (this.in == null) {
            return 0L;
        }
        try {
            return this.in.available();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public int read(byte[] buf, int boff, int bytes) {
        if (this.in == null) {
            return -1;
        }
        int status = 0;
        int off = boff;
        while (bytes > 0) {
            try {
                status = this.in.read(buf, off, bytes);
            }
            catch (IOException e) {
                status = -1;
            }
            if (status <= 0) break;
            bytes -= status;
            off += status;
        }
        bytes = off - boff;
        if (status < 0 && bytes == 0) {
            return status;
        }
        this.offset += (long)bytes;
        return bytes;
    }

    @Override
    public int write(byte[] buf, int boff, int bytes) {
        if (this.out == null) {
            return -1;
        }
        try {
            this.out.write(buf, boff, bytes);
        }
        catch (IOException e) {
            return -1;
        }
        this.offset += (long)bytes;
        return bytes;
    }

    @Override
    public long lastModified() {
        long utcSecs = this.urlConn == null ? 0L : this.urlConn.getLastModified();
        return utcSecs;
    }
}

