/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MidasColor;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Results;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;

@InternalUseOnly(value="User code should reference libg.Theme, unless the user would like to break a dependency on our graphical code.")
public class Theme
extends MetalTheme
implements Cloneable {
    @InternalUseOnly
    public static final Color DARK_BLUE;
    @InternalUseOnly
    public static final Color DARK_GRAY;
    @InternalUseOnly
    public static final Color BLUE;
    @InternalUseOnly
    public static final Color STRONG_ORANGE;
    private static final Color BLACK;
    private static final Color GRAY;
    private static final Color WHITE;
    public static HashMap<String, String> UIManagerKeysMapping;
    private static final String[][] METAL_THEMES;
    public static final String propertyList = "Name,Descr,Inline,Font,Cbg,Cfg,Cwbg,Cwfg,Cwti,Cwfh,Cwts,Cwbs";
    private static Font DEFAULT_FONT;
    private static Theme DEFAULT_THEME;
    private static Theme globalTheme;
    private static final Class<?> LIBG_THEME_CLASS;
    private static final Class<?> CLAZZ_FOR_THEME_TO_INSTANTIATE;
    private static Constructor<?> THEME_CONSTRUCTOR;
    private static Theme libgGlobalTheme;
    public static final String nameList = "DeskTop,Default,WoB,GoB,BoW,MnM,Browser,Gear1,Gear2,Gear3,Gear4,Nak";
    public static final String defaultTheme = "GEAR3";
    private static boolean headless;
    private static int headlessInitStatus;
    private static boolean initialized;
    public static final String optionsList = "Headless,AWT,Swing,RealTime,Mobile,SwingDB,SwingWidgets,SwingPopups,NoSLAF,NoXLAF,InitOnLoad,Debug,HeadlessDetected,SwingLegacy,Contrast";
    public static final int HEADLESS = 1;
    public static final int AWT = 2;
    public static final int SWING = 4;
    public static final int REALTIME = 8;
    public static final int MOBILE = 16;
    public static final int SWINGDB = 32;
    public static final int SWINGWIDGETS = 64;
    public static final int SWINGPOPUPS = 128;
    public static final int NOSLAF = 256;
    public static final int NOXLAF = 512;
    public static final int INITONLOAD = 1024;
    public static final int DEBUG = 2048;
    public static final int HEADLESSDETECTED = 4096;
    public static final int SWINGLEGACY = 8192;
    public static final int CONTRAST = 16384;
    private static int options;
    private static Table definedThemes;
    public String name;
    public String descr;
    public boolean inline;
    private Font font;
    public Color Cblack;
    public Color Cgray;
    public Color Cwhite;
    public Color cbg;
    public Color cfg;
    public Color cwbg;
    public Color cwfg;
    public Color cwti;
    public Color cwfh;
    public Color cwbh;
    public Color cwts;
    public Color cwbs;
    public Color cwms;
    public Color cbgx;
    public static final String[][] COMPONENT_LIST;
    public static final String THEME_COMPONENT_CBG = "cbg";
    public static final String THEME_COMPONENT_CFG = "cfg";
    public static final String THEME_COMPONENT_CWBG = "cwbg";
    public static final String THEME_COMPONENT_CWFG = "cwfg";
    public static final String THEME_COMPONENT_CWTI = "cwti";
    public static final String THEME_COMPONENT_CWFH = "cwfh";
    public static final String THEME_COMPONENT_CWBH = "cwbh";
    public static final String THEME_COMPONENT_CWTS = "cwts";
    public static final String THEME_COMPONENT_CWBS = "cwbs";
    public static final String THEME_COMPONENT_CWMS = "cwms";
    public static final String THEME_COMPONENT_CBGX = "cbgx";
    static final double DEFAULT_VISIBILITY_TOLERANCE = 0.077;
    private double visibilityTolerance = 0.077;
    public static final int VISIBILITY_TEST_IDX_NAME = 0;
    public static final int VISIBILITY_TEST_IDX_COMPONENT_1 = 1;
    public static final int VISIBILITY_TEST_IDX_COMPONENT_2 = 2;
    public static final int VISIBILITY_TEST_IDX_SOLUTION = 3;
    public static final String VISIBILITY_TEST_SOLUTION_INVERT = "Invert";
    public static final String VISIBILITY_TEST_SOLUTION_BLEND = "Blend";
    public static double graphicsDelay;

    public static void initialize() {
        Table MR;
        String tn;
        Class<?> clazz;
        if (initialized) {
            return;
        }
        initialized = true;
        Shell shell = Shell.getCurrent();
        final Midas midas = shell == null ? null : shell.M;
        Theme.initHeadlessStatus();
        DEFAULT_FONT = new Font("Monospaced", 0, 12);
        Theme.initThemes(midas);
        try {
            clazz = Class.forName("nxm.sys.libg.Theme");
        }
        catch (ClassNotFoundException e1) {
            clazz = null;
        }
        if (clazz != null) {
            try {
                DEFAULT_THEME = (Theme)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            DEFAULT_THEME = (Theme)definedThemes.get("DEFAULT");
        }
        globalTheme = DEFAULT_THEME;
        if (midas != null && (tn = (MR = midas.getResults()).getS("ENV.THEME")) != null) {
            try {
                Theme.setGlobalTheme(tn, null);
            }
            catch (Exception e) {
                midas.warning("Theme: Cannot set global theme to ENV.THEME=" + tn + "  exception=" + e);
            }
            MR.put("ENV.GRAPHICS", (Object)Theme.getOptions(), 16);
        }
        if (Theme.getOption(512) && !headless && midas != null) {
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Theme.lookAndFeelChanged(midas);
                }
            });
        }
    }

    public static Theme global() {
        Theme.initialize();
        return globalTheme;
    }

    public static String[] getThemeNames() {
        Theme.initialize();
        Object[] themes = Theme.definedThemes.iterator().values;
        String[] names = new String[themes.length];
        for (int i = 0; i < themes.length; ++i) {
            names[i] = ((Theme)themes[i]).getName();
        }
        return names;
    }

    public static void setOptions(int arg) {
        options = arg;
    }

    public static void setOptions(String arg) {
        Theme.setOptions(Parser.mask(optionsList, arg, options));
    }

    public static String getOptions() {
        return Parser.mask2s(optionsList, options);
    }

    public static boolean getOption(int mask) {
        return (options & mask) != 0;
    }

    private static void lookAndFeelChanged(Midas midas) {
        String globalTheme = Theme.getGlobalTheme();
        String currentTheme = Theme.getCurrentTheme();
        if (currentTheme == null) {
            return;
        }
        if (globalTheme.equalsIgnoreCase("JAVA")) {
            globalTheme = "METAL";
        }
        if (currentTheme.equalsIgnoreCase("JAVA")) {
            currentTheme = "METAL";
        }
        if (!globalTheme.equalsIgnoreCase(currentTheme)) {
            midas.warning("THEME: Global look and feel illegally changed from '" + Theme.getGlobalTheme() + "' to '" + Theme.getCurrentTheme() + "' without using the methods in Theme.");
        }
    }

    private static String getCurrentTheme() {
        LookAndFeel look = UIManager.getLookAndFeel();
        String name = null;
        if (look instanceof MetalLookAndFeel) {
            MetalTheme metalTheme = MetalLookAndFeel.getCurrentTheme();
            if (metalTheme.getClass().equals(DefaultMetalTheme.class)) {
                name = "Metal";
            } else if (metalTheme instanceof Theme) {
                name = ((Theme)metalTheme).getName();
            } else {
                name = metalTheme.getClass().getName();
                int index = Math.max(name.lastIndexOf("."), name.lastIndexOf("$"));
                if (index > 0 && (name = name.substring(index + 1)).endsWith("Theme")) {
                    name = name.substring(0, name.length() - 5);
                }
            }
        } else {
            name = look.getName();
        }
        return name;
    }

    public Theme() {
        this.setByName("DEFAULT");
    }

    @InternalUseOnly
    public Theme(String name, String descr) {
        if (name == null) {
            this.name = "Anonymous";
            this.descr = "An anonymous theme.";
        } else {
            this.name = name;
            this.descr = descr != null ? descr : "A theme for NeXtMidas.";
        }
        String names = ",DeskTop,Default,WoB,GoB,BoW,MnM,Browser,Gear1,Gear2,Gear3,Gear4,Nak,";
        String match = "," + name + ",";
        if (",DeskTop,Default,WoB,GoB,BoW,MnM,Browser,Gear1,Gear2,Gear3,Gear4,Nak,".indexOf(match) >= 0) {
            this.setByName(name.toUpperCase());
            this.name = name;
        }
    }

    private Theme(Theme theme, String name, String descr, boolean inline, Font font, Color cbg, Color cfg, Color cwbg, Color cwfg, Color cwti, Color cwfh, Color cwts, Color cwbs) {
        this(theme, name, descr, inline, font, cbg, cfg, Color.black, Color.gray, Color.white, cbg, cfg, cwbg, cwfg, cwti, cwfh, cwts, cwbs);
    }

    private Theme(Theme theme, String name, String descr, boolean inline, Font font, Color Cbg, Color Cfg, Color Cblack, Color Cgray, Color Cwhite, Color cbg, Color cfg, Color cwbg, Color cwfg, Color cwti, Color cwfh, Color cwts, Color cwbs) {
        this(name, descr);
        if (theme == null) {
            theme = DEFAULT_THEME;
        }
        this.font = DEFAULT_FONT;
        this.Cblack = Cblack != null ? Cblack : theme.Cblack;
        this.Cgray = Cgray != null ? Cgray : theme.Cgray;
        this.Cwhite = Cwhite != null ? Cwhite : theme.Cwhite;
        this.cbg = cbg != null ? cbg : theme.cbg;
        this.cfg = cfg != null ? cfg : theme.cfg;
        this.cwbg = cwbg != null ? cwbg : theme.cwbg;
        this.cwfg = cwfg != null ? cwfg : theme.cwfg;
        this.cwti = cwti != null ? cwti : theme.cwti;
        this.cwfh = cwfh != null ? cwfh : theme.cwfh;
        this.cwts = cwts != null ? cwts : theme.cwts;
        this.cwbs = cwbs != null ? cwbs : theme.cwbs;
        this.cwms = MidasColor.getColorMix(this.cwbg, this.cwts, 0.5);
        this.cbgx = this.cbg;
        this.setInline(inline);
    }

    private void fromTheme(Theme theme) {
        this.font = theme.font;
        this.Cblack = theme.Cblack;
        this.Cgray = theme.Cgray;
        this.Cwhite = theme.Cwhite;
        this.cbg = theme.cbg;
        this.cfg = theme.cfg;
        this.cwbg = theme.cwbg;
        this.cwfg = theme.cwfg;
        this.cwti = theme.cwti;
        this.cwfh = theme.cwfh;
        this.cwts = theme.cwts;
        this.cwbs = theme.cwbs;
        this.cwms = MidasColor.getColorMix(this.cwbg, this.cwts, 0.5);
        this.cbgx = this.cbg;
        this.inline = false;
    }

    protected Theme(Table table) {
        this(Theme.getTheme(table.getS("THEME")), table.getS("NAME"), table.getS("DESCR"), false, null, Theme.getColor("CBG", table), Theme.getColor("CFG", table), Theme.getColor("CWBG", table), Theme.getColor("CWFG", table), Theme.getColor("CWTI", table), Theme.getColor("CWFH", table), Theme.getColor("CWTS", table), Theme.getColor("CWBS", table));
    }

    @InternalUseOnly
    public Theme(String name, UIDefaults prop) {
        this(null, name, "A theme to match the Java/Swing '" + name + "' Look and Feel.", false, null, prop.getColor("control"), prop.getColor("controlText"), prop.getColor("control"), prop.getColor("controlText"), prop.getColor("controlText"), prop.getColor("controlHighlight"), prop.getColor("controlShadow"), prop.getColor("controlLightShadow") != null ? prop.getColor("controlLightShadow") : prop.getColor("controlDkShadow"));
    }

    private static final Theme[] getLegacyThemes() {
        try {
            return new Theme[]{(Theme)THEME_CONSTRUCTOR.newInstance("DeskTop", "A desktop-like theme for NeXtMidas."), (Theme)THEME_CONSTRUCTOR.newInstance("Default", "The default NeXtMidas theme."), (Theme)THEME_CONSTRUCTOR.newInstance("WoB", "A white on black theme for NeXtMidas."), (Theme)THEME_CONSTRUCTOR.newInstance("GoB", "A gray on black theme for NeXtMidas."), (Theme)THEME_CONSTRUCTOR.newInstance("BoW", "A black on white theme for NeXtMidas."), (Theme)THEME_CONSTRUCTOR.newInstance("MnM", "A theme for mobile iPhone clients."), (Theme)THEME_CONSTRUCTOR.newInstance("Browser", "A web-browser-like theme for NeXtMidas."), (Theme)THEME_CONSTRUCTOR.newInstance("Gear1", "A NeXtMidas theme."), (Theme)THEME_CONSTRUCTOR.newInstance("Gear2", "A NeXtMidas theme: Gear1 except widget fg and title color is orange."), (Theme)THEME_CONSTRUCTOR.newInstance("Gear3", "A common NeXtMidas theme: Gear2 except widget bg is black."), (Theme)THEME_CONSTRUCTOR.newInstance("Gear4", "A NeXtMidas theme: Gear3 except widget highlight is a slightly brighter blue."), (Theme)THEME_CONSTRUCTOR.newInstance("Nak", "A NeXtMidas theme.")};
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }

    private static final Theme[] getDefaultThemes(Midas midas) {
        UIManager.LookAndFeelInfo[] lookAndFeels;
        ArrayList<Theme> themes = new ArrayList<Theme>();
        for (UIManager.LookAndFeelInfo lafinfo : lookAndFeels = Theme.getLookAndFeels()) {
            try {
                Theme theme = Theme.getThemeFor(lafinfo, midas);
                if (theme != null) {
                    themes.add(theme);
                    continue;
                }
                Theme.warn(midas, "Theme: Not adding to themes list: " + lafinfo.getName() + " " + lafinfo.getClassName(), null);
            }
            catch (Exception e) {
                if (e instanceof UnsupportedLookAndFeelException) {
                    Theme.warn(midas, "Theme: Unsupported lookandfeel " + lafinfo, e);
                    continue;
                }
                Theme.warn(midas, "Theme: Unable to add to themes list: " + lafinfo, e);
            }
        }
        for (int i = 0; i < METAL_THEMES.length; ++i) {
            try {
                if (StringUtil.compareVersions(METAL_THEMES[i][0], Shell.getJavaVersion()) > 0) continue;
                MetalTheme theme = (MetalTheme)Class.forName(METAL_THEMES[i][2]).getConstructor(new Class[0]).newInstance(new Object[0]);
                themes.add(Theme.getThemeFor(METAL_THEMES[i][1], theme));
                continue;
            }
            catch (Exception e) {
                Theme.warn(midas, "Theme: Unable to add to themes list: name=" + METAL_THEMES[i][1] + " class=" + METAL_THEMES[i][2], e);
            }
        }
        return themes.toArray(new Theme[0]);
    }

    public Theme copy() {
        try {
            return (Theme)this.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Theme getTheme(String name) {
        Theme.initialize();
        try {
            Theme theme = (Theme)definedThemes.get(name.toUpperCase());
            return theme != null ? (Theme)theme.clone() : null;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This should be impossible, Theme is Clonable.", e);
        }
    }

    static Theme getThemeSafeVersion(String name) {
        Theme theme;
        Theme theme2 = theme = name != null ? Theme.getTheme(name) : null;
        if (theme == null) {
            theme = DEFAULT_THEME;
            Shell.warning("Theme '" + name + "' not found. Available themes include: " + StringUtil.join(Theme.getThemeNames()) + ".");
        }
        return theme;
    }

    public String toString() {
        return this.name + ": " + this.descr;
    }

    public String toString(boolean verbose) {
        if (verbose) {
            return "Name     " + this.name + "\nDescr   " + this.descr + "\ncbg     " + this.cbg + "\ncfg     " + this.cfg + "\ncwbg    " + this.cwbg + "\ncwfg    " + this.cwfg + "\ncwti    " + this.cwti + "\ncwfh    " + this.cwfh + "\ncwts    " + this.cwts + "\ncwbs    " + this.cwts;
        }
        return this.toString();
    }

    public void setByName(String themeName) {
        this.name = themeName.toUpperCase();
        this.Cwhite = WHITE;
        this.Cgray = GRAY;
        this.Cblack = BLACK;
        this.font = DEFAULT_FONT;
        this.cbg = this.Cwhite;
        this.cfg = this.Cblack;
        if (!this.name.startsWith("DES")) {
            if (this.name.startsWith("DEF")) {
                this.cbg = this.Cwhite;
                this.cfg = this.Cblack;
            } else if (this.name.startsWith("GOB")) {
                this.cbg = this.Cblack;
                this.cfg = this.Cgray;
            } else if (this.name.startsWith("WOB")) {
                this.cbg = this.Cblack;
                this.cfg = this.Cwhite;
            } else if (this.name.startsWith("MNM")) {
                this.cbg = this.Cblack;
                this.cfg = DARK_GRAY;
            } else if (this.name.startsWith("BOW")) {
                this.cbg = this.Cwhite;
                this.cfg = this.Cblack;
            } else if (this.name.startsWith("BRO")) {
                this.cbg = this.Cwhite;
                this.cfg = this.Cblack;
            } else if (!this.name.startsWith("GEAR") && !this.name.startsWith("NAK")) {
                Theme theme = Theme.getThemeSafeVersion(themeName);
                this.fromTheme(theme);
                return;
            }
        }
        if (this.name.startsWith("BRO")) {
            this.cwbg = this.Cwhite;
            this.cwts = Color.white;
            this.cwbs = Color.gray;
            this.cwfg = Color.black;
            this.cwti = Color.black;
            this.cwfh = Color.blue;
        } else if (this.name.startsWith("BOW")) {
            this.cwbg = Color.lightGray;
            this.cwts = Color.white;
            this.cwbs = Color.gray;
            this.cwfg = Color.black;
            this.cwti = Color.black;
            this.cwfh = Color.blue;
        } else if (this.name.startsWith("WOB")) {
            this.cwbg = this.cbg;
            this.cwts = new Color(0x303030);
            this.cwbs = new Color(0x101008);
            this.cwfh = new Color(6990544);
            this.cwfg = this.cfg;
            this.cwti = this.cfg;
        } else if (this.name.startsWith("GOB")) {
            this.cwbg = this.cbg;
            this.cwts = new Color(0x303030);
            this.cwbs = new Color(0x101008);
            this.cwfh = new Color(6990544);
            this.cwfg = this.cfg;
            this.cwti = this.cfg;
        } else if (this.name.startsWith("MNM")) {
            this.cwbg = this.cbg;
            this.cwts = new Color(0x303030);
            this.cwbs = new Color(0x101010);
            this.cwfh = new Color(6990544);
            this.cwfg = this.cfg;
            this.cwti = this.cfg;
        } else if (this.name.startsWith("GEAR")) {
            this.cwbg = new Color(0x202020);
            this.cwts = new Color(0x606060);
            this.cwbs = new Color(0x101010);
            this.cwfh = DARK_BLUE;
            if (this.name.equals("GEAR4")) {
                this.cwfh = BLUE;
            }
            this.cwbh = this.cwts;
            this.cwfg = DARK_GRAY;
            this.cwti = DARK_GRAY;
            if (this.name.equals("GEAR2")) {
                this.cwfg = STRONG_ORANGE;
                this.cwti = STRONG_ORANGE;
            }
            if (this.name.equals(defaultTheme) || this.name.equals("GEAR4")) {
                this.cwfg = STRONG_ORANGE;
                this.cwti = STRONG_ORANGE;
                this.cwbg = this.Cblack;
            }
            this.cbg = this.cwbg;
            this.cfg = this.cwfg;
        } else if (this.name.startsWith("NAK")) {
            this.cwbg = new Color(3417120);
            this.cwts = new Color(0x706060);
            this.cwbs = new Color(0x201010);
            this.cwfh = new Color(3828384);
            this.cwfg = STRONG_ORANGE;
            this.cwti = STRONG_ORANGE;
            this.cbg = this.cwbg;
            this.cfg = this.cwfg;
        } else {
            this.cwbg = new Color(0x343440);
            this.cwts = new Color(0x606070);
            this.cwbs = new Color(0x101020);
            this.cwfh = new Color(4231392);
            this.cwfg = new Color(0xA0A0B0);
            this.cwti = new Color(0xA0A0B0);
        }
        this.cbgx = this.cbg;
        this.cwms = MidasColor.getColorMix(this.cwbg, this.cwts, 0.5);
        if (this.inline) {
            this.cbg = this.cwbg;
        }
        if (Theme.getOption(2048)) {
            System.out.println("---------------------------------");
            System.out.println("  " + this.name);
            System.out.println("---------------------------------");
            System.out.println("this.Cblack = " + MidasColor.toString(this.Cblack));
            System.out.println("this.Cgray  = " + MidasColor.toString(this.Cgray));
            System.out.println("this.Cwhite = " + MidasColor.toString(this.Cwhite));
            System.out.println("this.cbg    = " + MidasColor.toString(this.cbg));
            System.out.println("this.cfg    = " + MidasColor.toString(this.cfg));
            System.out.println("this.cwbg   = " + MidasColor.toString(this.cwbg));
            System.out.println("this.cwfg   = " + MidasColor.toString(this.cwfg));
            System.out.println("this.cwti   = " + MidasColor.toString(this.cwti));
            System.out.println("this.cwfh   = " + MidasColor.toString(this.cwfh));
            System.out.println("this.cwts   = " + MidasColor.toString(this.cwts));
            System.out.println("this.cwbs   = " + MidasColor.toString(this.cwbs));
            System.out.println("this.cwms   = " + MidasColor.toString(this.cwms));
            System.out.println("this.cbgx   = " + MidasColor.toString(this.cbgx));
        }
    }

    public void createTheme(Table table) {
        if (table != null) {
            this.cbg = Theme.getColor("CBG", table, this.cbg);
            this.cfg = Theme.getColor("CFG", table, this.cfg);
            this.cwbg = Theme.getColor("CWBG", table, this.cwbg);
            this.cwfg = Theme.getColor("CWFG", table, this.cwfg);
            this.cwti = Theme.getColor("CWTI", table, this.cwfg);
            this.cwfh = Theme.getColor("CWFH", table, this.cwfh);
            this.cwbh = Theme.getColor("CWBH", table, this.cwbh);
            this.cwts = Theme.getColor("CWTS", table, this.cwts);
            this.cwbs = Theme.getColor("CWBS", table, this.cwbs);
            this.cwms = Theme.getColor("CWMS", table, this.cwms);
        }
    }

    public void setInline(boolean inline) {
        this.inline = inline;
        this.cbg = inline ? this.cwbg : this.cbgx;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescr() {
        return this.descr;
    }

    public boolean getInline() {
        return this.inline;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getBackground() {
        return this.cbg;
    }

    public Color getCbg() {
        return this.getBackground();
    }

    public Color getForeground() {
        return this.cfg;
    }

    public Color getCfg() {
        return this.getForeground();
    }

    public Color getWidgetBackground() {
        return this.cwbg;
    }

    public Color getCwbg() {
        return this.getWidgetBackground();
    }

    public Color getWidgetForeground() {
        return this.cwfg;
    }

    public Color getCwfg() {
        return this.getWidgetForeground();
    }

    public Color getCwti() {
        return this.getWidgetTitle();
    }

    public void setCwti(Color color) {
        this.setWidgetTitle(color);
    }

    public void setCwti(String color) {
        this.setWidgetTitle(color);
    }

    public Color getWidgetTitle() {
        return this.cwti;
    }

    public void setWidgetTitle(Color color) {
        this.cwti = color;
    }

    public void setWidgetTitle(String color) {
        this.setWidgetTitle(MidasColor.getColor(color));
    }

    public Color getWidgetForegroundHighlight() {
        return this.cwfh;
    }

    public Color getCwfh() {
        return this.getWidgetForegroundHighlight();
    }

    public Color getWidgetTopShade() {
        return this.cwts;
    }

    public Color getCwts() {
        return this.getWidgetTopShade();
    }

    public Color getWidgetBottomShade() {
        return this.cwbs;
    }

    public Color getCwbs() {
        return this.getWidgetBottomShade();
    }

    public Color getWidgetMiddleShade() {
        return this.cwms;
    }

    public Color getCwms() {
        return this.cwms;
    }

    public Color getCwbh() {
        return this.cwbh;
    }

    public Color getCbgx() {
        return this.cbgx;
    }

    public Color getColor(String name) {
        name = name.toLowerCase();
        if (!Theme.getComponentList().contains(name)) {
            return null;
        }
        if (name.equals(THEME_COMPONENT_CWMS)) {
            return this.getCwms();
        }
        if (name.equals(THEME_COMPONENT_CWFG)) {
            return this.getCwfg();
        }
        if (name.equals(THEME_COMPONENT_CWTI)) {
            return this.getCwti();
        }
        if (name.equals(THEME_COMPONENT_CBG)) {
            return this.getCbg();
        }
        if (name.equals(THEME_COMPONENT_CFG)) {
            return this.getCfg();
        }
        if (name.equals(THEME_COMPONENT_CWBG)) {
            return this.getCwbg();
        }
        if (name.equals(THEME_COMPONENT_CBGX)) {
            return this.getCbgx();
        }
        if (name.equals(THEME_COMPONENT_CWBH)) {
            return this.getCwbh();
        }
        if (name.equals(THEME_COMPONENT_CWBS)) {
            return this.getCwbs();
        }
        if (name.equals(THEME_COMPONENT_CWFH)) {
            return this.getCwfh();
        }
        if (name.equals(THEME_COMPONENT_CWTS)) {
            return this.getCwts();
        }
        return null;
    }

    private static Color getColor(String name, Table table) {
        return Theme.getColor(name, table, null);
    }

    private static Color getColor(String name, Table table, Color def) {
        Object obj = table.get(name);
        return obj == null ? def : MidasColor.getColor(obj);
    }

    @InternalUseOnly
    public void setColor(String name, Color newColor) {
        if ((name = name.toLowerCase()).equals(THEME_COMPONENT_CWMS)) {
            this.cwms = newColor;
        } else if (name.equals(THEME_COMPONENT_CWFG)) {
            this.cwfg = newColor;
        } else if (name.equals(THEME_COMPONENT_CWTI)) {
            this.cwti = newColor;
        } else if (name.equals(THEME_COMPONENT_CBG)) {
            this.cbg = newColor;
        } else if (name.equals(THEME_COMPONENT_CFG)) {
            this.cfg = newColor;
        } else if (name.equals(THEME_COMPONENT_CWBG)) {
            this.cwbg = newColor;
        } else if (name.equals(THEME_COMPONENT_CBGX)) {
            this.cbgx = newColor;
        } else if (name.equals(THEME_COMPONENT_CWBH)) {
            this.cwbh = newColor;
        } else if (name.equals(THEME_COMPONENT_CWBS)) {
            this.cwbs = newColor;
        } else if (name.equals(THEME_COMPONENT_CWFH)) {
            this.cwfh = newColor;
        } else if (name.equals(THEME_COMPONENT_CWTS)) {
            this.cwts = newColor;
        }
    }

    @InternalUseOnly
    public static String getComponentList() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int ii = 0; ii < COMPONENT_LIST.length; ++ii) {
            sb.append(COMPONENT_LIST[ii][0]);
            if (first) {
                first = false;
                continue;
            }
            sb.append(",");
        }
        return sb.toString();
    }

    @InternalUseOnly
    public String getComponentDescription(String name) {
        String description = null;
        name = name.toLowerCase();
        for (int ii = 0; ii < COMPONENT_LIST.length; ++ii) {
            if (!COMPONENT_LIST[ii][0].equals(name)) continue;
            return COMPONENT_LIST[ii][1];
        }
        return description;
    }

    Double colorDifference(String colorStr1, String colorStr2) {
        Color color1 = this.getColor(colorStr1);
        Color color2 = this.getColor(colorStr2);
        if (color1 == null || color2 == null) {
            return null;
        }
        return MidasColor.colorDifference(color1, color2);
    }

    @InternalUseOnly
    public static Theme getThemeFor(UIManager.LookAndFeelInfo lafInfo) throws Exception {
        return Theme.getThemeFor(lafInfo, null);
    }

    private static Theme getThemeFor(UIManager.LookAndFeelInfo lafInfo, Midas midas) throws Exception {
        String lafName = lafInfo.getName();
        if ("GTK+".equals(lafName) && midas == null) {
            return null;
        }
        try {
            UIManager.setLookAndFeel(lafInfo.getClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
            lafName = "Nimbus";
        }
        LookAndFeel laf = UIManager.getLookAndFeel();
        Constructor<?> themeCon = CLAZZ_FOR_THEME_TO_INSTANTIATE.getConstructor(String.class, UIDefaults.class);
        return (Theme)themeCon.newInstance(lafName, laf.getDefaults());
    }

    private static Theme getThemeFor(String name, MetalTheme jTheme) throws Exception {
        MetalLookAndFeel laf = new MetalLookAndFeel();
        MetalLookAndFeel.setCurrentTheme(jTheme);
        UIManager.setLookAndFeel(laf);
        UIDefaults lafDefaults = ((LookAndFeel)laf).getDefaults();
        Constructor<?> themeCon = CLAZZ_FOR_THEME_TO_INSTANTIATE.getConstructor(String.class, UIDefaults.class);
        Theme result = (Theme)themeCon.newInstance(name, lafDefaults);
        return result;
    }

    private static UIManager.LookAndFeelInfo[] getLookAndFeels() {
        ArrayList<UIManager.LookAndFeelInfo> plafs = new ArrayList<UIManager.LookAndFeelInfo>();
        plafs.addAll(Arrays.asList(UIManager.getInstalledLookAndFeels()));
        LookAndFeel[] auxPlafs = UIManager.getAuxiliaryLookAndFeels();
        if (auxPlafs != null) {
            for (LookAndFeel auxLaf : auxPlafs) {
                plafs.add(new UIManager.LookAndFeelInfo(auxLaf.getName(), auxLaf.getClass().getName()));
            }
        }
        return plafs.toArray(new UIManager.LookAndFeelInfo[0]);
    }

    private static String getLookAndFeelClassName(String name) {
        UIManager.LookAndFeelInfo[] plafs;
        for (UIManager.LookAndFeelInfo lafInfo : plafs = Theme.getLookAndFeels()) {
            if (!lafInfo.getName().equalsIgnoreCase(name)) continue;
            return lafInfo.getClassName();
        }
        return null;
    }

    private static String getMetalThemeClassName(String name) {
        for (int i = 0; i < METAL_THEMES.length; ++i) {
            if (!METAL_THEMES[i][1].equalsIgnoreCase(name)) continue;
            return METAL_THEMES[i][2];
        }
        return null;
    }

    public static String getGlobalTheme() {
        return globalTheme != null ? globalTheme.getName() : null;
    }

    public static void setGlobalTheme(String themeName) throws UnsupportedLookAndFeelException, IllegalArgumentException {
        Theme.setGlobalTheme(themeName, Shell.getSharedMidasContext());
    }

    public static void setGlobalTheme(String themeName, Midas midas) throws UnsupportedLookAndFeelException, IllegalArgumentException {
        if (headless) {
            return;
        }
        if (Theme.getOption(256)) {
            return;
        }
        Theme theme = Theme.getTheme(themeName);
        String clazz = Theme.getLookAndFeelClassName(themeName);
        String mTheme = Theme.getMetalThemeClassName(themeName);
        if (theme != null) {
            if (clazz == null) {
                clazz = MetalLookAndFeel.class.getName();
            }
        } else {
            String lafNames = StringUtil.join(Theme.getThemeNames());
            throw new IllegalArgumentException("The '" + themeName + "' Look & Feel is not recognized. Available options include: " + lafNames + ".");
        }
        try {
            if (mTheme != null) {
                try {
                    MetalTheme metalTheme = (MetalTheme)Class.forName(mTheme).getConstructor(new Class[0]).newInstance(new Object[0]);
                    MetalLookAndFeel.setCurrentTheme(metalTheme);
                }
                catch (Exception e) {
                    MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                }
            } else {
                MetalLookAndFeel.setCurrentTheme(theme);
            }
            globalTheme = theme;
            if (midas != null) {
                ((Results)midas.getResults()).put("ENV.THEME", (Object)Theme.getGlobalTheme(), 16);
            }
            UIManager.setLookAndFeel(clazz);
            globalTheme.adjustThemeColorVisibilityIssues(midas, false);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load the required Look & Feel class (" + clazz + ").", e);
        }
    }

    @InternalUseOnly
    public void adjustThemeColorVisibilityIssues(Midas midas, boolean supressConsoleWarning) {
        List<List<String>> tests = Theme.getThemeVisibilityTests();
        List<Integer> themeWarnings = this.getColorVisibilityWarnings(midas, tests);
        for (Integer themeWarning : themeWarnings) {
            int idx = themeWarning;
            List<String> test = tests.get(idx);
            this.adjustPoorVisibility(midas, test, supressConsoleWarning);
        }
    }

    @InternalUseOnly
    public List<String> warnThemeColorVisibility(Midas midas, boolean supressConsole) {
        List<List<String>> colorVisibilityTests = Theme.getThemeVisibilityTests();
        ArrayList<String> visibilityWarnings = new ArrayList<String>();
        List<Integer> warningsIdxs = this.getColorVisibilityWarnings(midas, colorVisibilityTests);
        for (Integer testIdx : warningsIdxs) {
            List<String> test = colorVisibilityTests.get(testIdx);
            String msg = "Theme " + this.name + ": Visibility test for '" + test.get(0) + "' indicates poor color combination";
            visibilityWarnings.add(msg);
            if (supressConsole) continue;
            Theme.warn(midas, msg, null);
        }
        return visibilityWarnings;
    }

    private static List<List<String>> getThemeVisibilityTests() {
        ArrayList<List<String>> tests = new ArrayList<List<String>>();
        tests.add(Theme.buildVisibilityTest("Unselected menu item", THEME_COMPONENT_CWBG, THEME_COMPONENT_CWFG, VISIBILITY_TEST_SOLUTION_BLEND));
        tests.add(Theme.buildVisibilityTest("Selected menu item/Shellgui input promp", THEME_COMPONENT_CWBG, THEME_COMPONENT_CWFH, VISIBILITY_TEST_SOLUTION_BLEND));
        tests.add(Theme.buildVisibilityTest("Menu title", THEME_COMPONENT_CWBG, THEME_COMPONENT_CWTI, VISIBILITY_TEST_SOLUTION_BLEND));
        return tests;
    }

    private static List<String> buildVisibilityTest(String name, String component1, String component2, String solution) {
        ArrayList<String> newtest = new ArrayList<String>();
        newtest.add(0, name);
        newtest.add(1, component1);
        newtest.add(2, component2);
        newtest.add(3, solution);
        return newtest;
    }

    private void adjustPoorVisibility(Midas midas, List<String> test, boolean supressConsoleWarning) {
        String testName = test.get(0);
        String component1 = test.get(1);
        String component2 = test.get(2);
        String solution = test.get(3);
        Color color1 = this.getColor(component1);
        Color color2 = this.getColor(component2);
        String msg = "";
        if (solution.equals(VISIBILITY_TEST_SOLUTION_INVERT)) {
            Color newColor = MidasColor.invert(color1);
            this.setColor(component2, newColor);
            msg = "Altering color of " + component2 + " to improve " + testName;
        } else if (solution.equals(VISIBILITY_TEST_SOLUTION_BLEND)) {
            Color newColor = MidasColor.invert(color1);
            newColor = MidasColor.blend(newColor, color2);
            this.setColor(component2, newColor);
            msg = "Altering color of " + component2 + " to improve " + testName;
        }
        if (!supressConsoleWarning) {
            Theme.warn(midas, msg, null);
        }
    }

    private List<Integer> getColorVisibilityWarnings(Midas midas, List<List<String>> visibilityTests) {
        ArrayList<Integer> visibilityWarnings = new ArrayList<Integer>();
        for (int ii = 0; ii < visibilityTests.size(); ++ii) {
            List<String> test = visibilityTests.get(ii);
            Double deltaInputPrompt = this.colorDifference(test.get(1), test.get(2));
            if (deltaInputPrompt == null || !(deltaInputPrompt < this.visibilityTolerance)) continue;
            visibilityWarnings.add(ii);
        }
        return visibilityWarnings;
    }

    @InternalUseOnly
    public double getVisibilityTolerance() {
        return this.visibilityTolerance;
    }

    @InternalUseOnly
    public void setVisibilityTolerance(double visibilityTolerance) {
        this.visibilityTolerance = visibilityTolerance;
    }

    @Deprecated
    public static void initThemes() {
        Theme.initialize();
    }

    @InternalUseOnly
    private static void initThemes(Midas midas) {
        try {
            Theme[] legacyThemes;
            for (Theme legacyTheme : legacyThemes = Theme.getLegacyThemes()) {
                definedThemes.put(legacyTheme.getName().toUpperCase(), (Object)legacyTheme);
            }
        }
        catch (Exception e) {
            Theme.warn(midas, "Theme: Unable to initialize legacy themes.", e);
        }
        if (headless) {
            return;
        }
        if (Theme.getOption(256)) {
            return;
        }
        try {
            Theme[] defaultThemes = Theme.getDefaultThemes(midas);
            for (Theme defaultTheme : defaultThemes) {
                definedThemes.put(defaultTheme.getName().toUpperCase(), (Object)defaultTheme);
            }
        }
        catch (Exception e) {
            Theme.warn(midas, "Theme: Unable to initialize default themes.", e);
        }
    }

    private static void initHeadlessStatus() {
        Shell shell = Shell.getCurrent();
        if (Theme.getOption(1)) {
            headless = true;
            return;
        }
        try {
            String headlessProp = System.getProperty("HEADLESS");
            if (headlessProp != null && !headlessProp.equals("AUTO")) {
                headless = StringUtil.isTrue(headlessProp);
                return;
            }
        }
        catch (Exception e) {
            if (Theme.getOption(2048)) {
                e.printStackTrace();
            }
            System.err.println("Theme: Cannot get HEADLESS property.");
            headless = true;
            headlessInitStatus |= 1;
        }
        if (!headless) {
            try {
                headless = Toolkit.getDefaultToolkit() == null;
            }
            catch (Throwable t) {
                if (Theme.getOption(2048)) {
                    t.printStackTrace();
                }
                System.out.println("WARN: " + t.getMessage());
                headless = true;
                headlessInitStatus |= 2;
            }
        }
        if (!headless) {
            try {
                GraphicsEnvironment graphicsEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
                headless = graphicsEnv.isHeadlessInstance() || GraphicsEnvironment.isHeadless();
            }
            catch (Throwable t) {
                if (Theme.getOption(2048)) {
                    t.printStackTrace();
                }
                headless = true;
                headlessInitStatus |= 4;
            }
        }
        if (headless) {
            Theme.setOptions("+HEADLESSDETECTED");
        }
    }

    public static boolean isHeadless() {
        Theme.initialize();
        return headless || Theme.getOption(1) || Theme.getOption(4096);
    }

    @InternalUseOnly
    public static int getHeadlessInitStatus() {
        return headlessInitStatus;
    }

    @Override
    public FontUIResource getControlTextFont() {
        return Theme.wrap(this.font);
    }

    @Override
    public FontUIResource getMenuTextFont() {
        return Theme.wrap(this.font);
    }

    @Override
    public FontUIResource getSubTextFont() {
        return Theme.wrap(this.font);
    }

    @Override
    public FontUIResource getSystemTextFont() {
        return Theme.wrap(this.font);
    }

    @Override
    public FontUIResource getUserTextFont() {
        return Theme.wrap(this.font);
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        return Theme.wrap(this.font);
    }

    @Override
    public ColorUIResource getBlack() {
        return Theme.wrap(this.cwfg);
    }

    @Override
    public ColorUIResource getControlTextColor() {
        return Theme.wrap(this.cfg);
    }

    @Override
    protected ColorUIResource getPrimary1() {
        return Theme.wrap(this.cfg);
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return Theme.wrap(this.cwfh);
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return Theme.wrap(this.cwfh);
    }

    @Override
    protected ColorUIResource getSecondary1() {
        return Theme.wrap(this.cwms);
    }

    @Override
    protected ColorUIResource getSecondary2() {
        return Theme.wrap(this.cwts);
    }

    @Override
    protected ColorUIResource getSecondary3() {
        return Theme.wrap(this.cbg);
    }

    @Override
    public ColorUIResource getSystemTextColor() {
        return Theme.wrap(this.cfg);
    }

    @Override
    public ColorUIResource getUserTextColor() {
        return Theme.wrap(this.cfg);
    }

    @Override
    public ColorUIResource getWhite() {
        return Theme.wrap(this.cbgx);
    }

    private static FontUIResource wrap(Font font) {
        return new FontUIResource(font);
    }

    private static ColorUIResource wrap(Color color) {
        return new ColorUIResource(color);
    }

    @InternalUseOnly
    public static void loadUIManagerMap() {
        HashMap<String, String> hash = new HashMap<String, String>(600, 25.0f);
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String uKey = key.toUpperCase();
            hash.put(uKey, key);
        }
        UIManagerKeysMapping = hash;
    }

    @InternalUseOnly
    public static HashMap<String, String> getUIManagerMapping() {
        return UIManagerKeysMapping;
    }

    public static Table updateUIManager(Table tab) {
        String[] tabKeys;
        if (tab == null) {
            return null;
        }
        boolean valid = true;
        if (UIManagerKeysMapping == null) {
            Theme.loadUIManagerMap();
        }
        HashMap<String, String> hash = Theme.getUIManagerMapping();
        tab.setMode(4);
        for (String key : tabKeys = tab.getKeys()) {
            String[] tmpTabKeys;
            Object obj = tab.get(key);
            if (!(obj instanceof Table)) continue;
            Table tmpTab = (Table)obj;
            for (String subTabKey : tmpTabKeys = tmpTab.getKeys()) {
                String cmd = key + "." + subTabKey;
                Object value = tmpTab.get(subTabKey);
                valid = (cmd = hash.get(cmd)) == null ? false : Theme.updateUIManager(cmd, value);
                if (valid) continue;
                Shell.warning("Theme: unable to update Swing UIManager with inputs: " + key + "." + subTabKey + ", " + value);
                String tmp = UIManager.get(cmd).toString();
                if (tmp == null) continue;
                tmpTab.remove(subTabKey);
                tmpTab.put(subTabKey, (Object)tmp.toString());
            }
        }
        return tab;
    }

    public static boolean updateUIManager(String key, Object value) {
        String sVal = value.toString();
        boolean valid = true;
        try {
            String type = UIManager.get(key).getClass().getSimpleName();
            if (type.equalsIgnoreCase("Integer")) {
                UIManager.put(key, Integer.valueOf(sVal));
            } else if (type.equalsIgnoreCase("Float")) {
                UIManager.put(key, Float.valueOf(sVal));
            } else if (type.equalsIgnoreCase("Double")) {
                UIManager.put(key, Double.valueOf(sVal));
            } else if (type.equalsIgnoreCase("Long")) {
                UIManager.put(key, Long.valueOf(sVal));
            } else if (type.equalsIgnoreCase("Boolean")) {
                UIManager.put(key, Boolean.valueOf(sVal));
            } else if (type.equalsIgnoreCase("Char") || type.equalsIgnoreCase("String")) {
                UIManager.put(key, value);
            } else if (type.equalsIgnoreCase("Byte")) {
                UIManager.put(key, Byte.valueOf(sVal));
            } else if (type.equalsIgnoreCase("Short")) {
                UIManager.put(key, Short.valueOf(sVal));
            } else if (type.equalsIgnoreCase("ColorUIResource")) {
                UIManager.put(key, Theme.wrap(MidasColor.getColor(value)));
            } else if (type.equalsIgnoreCase("Boolean")) {
                UIManager.put(key, Boolean.valueOf(sVal));
            } else if (type.equalsIgnoreCase("Color")) {
                UIManager.put(key, MidasColor.getColor(value));
            } else if (type.equalsIgnoreCase("Dimension")) {
                Dimension d = (Dimension)value;
                UIManager.put(key, d);
            } else if (type.equalsIgnoreCase("Font") || type.equalsIgnoreCase("FontUIResource")) {
                Font f = new Font(sVal, DEFAULT_FONT.getStyle(), DEFAULT_FONT.getSize());
                UIManager.put(key, Theme.wrap(f));
            } else if (!type.equalsIgnoreCase("ImageIconUIResource")) {
                UIManager.put(key, value);
            }
        }
        catch (Exception ex) {
            valid = false;
        }
        return valid;
    }

    public static void setScrollBarWidth(int w) {
        UIManager.put("ScrollBar.width", w);
    }

    public static int getScrollBarWidth() {
        return UIManager.getInt("ScrollBar.width");
    }

    public static void setScrollBarColor(String c) {
        Theme.setScrollBarColor(MidasColor.getColor(c));
    }

    public static void setScrollBarColor(Color c) {
        UIManager.put("ScrollBar.thumb", Theme.wrap(Color.white));
    }

    private static void warn(Midas midas, CharSequence msg, Throwable throwable) {
        if (midas != null) {
            midas.printStackTrace(msg, throwable, false, 1);
        } else {
            System.err.println(msg);
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
    }

    static {
        Class<?> libgThemeClass;
        DARK_BLUE = new Color(2779808);
        DARK_GRAY = new Color(0xA0A0A0);
        BLUE = new Color(3110842);
        STRONG_ORANGE = new Color(0xC88000);
        BLACK = new Color(526344);
        GRAY = new Color(0x808080);
        WHITE = new Color(0xD0D0D0);
        UIManagerKeysMapping = null;
        METAL_THEMES = new String[][]{{"1.4.0", "Java", "javax.swing.plaf.metal.DefaultMetalTheme"}, {"1.4.0", "Metal", "javax.swing.plaf.metal.DefaultMetalTheme"}, {"1.5.0", "Ocean", "javax.swing.plaf.metal.OceanTheme"}};
        try {
            libgThemeClass = Class.forName("nxm.sys.libg.Theme");
        }
        catch (ClassNotFoundException e) {
            libgThemeClass = null;
        }
        LIBG_THEME_CLASS = libgThemeClass;
        CLAZZ_FOR_THEME_TO_INSTANTIATE = LIBG_THEME_CLASS != null ? LIBG_THEME_CLASS : Theme.class;
        try {
            THEME_CONSTRUCTOR = CLAZZ_FOR_THEME_TO_INSTANTIATE.getConstructor(String.class, String.class);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            System.out.println("WARNING: unable to get Theme constructor " + ex);
            THEME_CONSTRUCTOR = null;
        }
        headless = false;
        headlessInitStatus = 0;
        initialized = false;
        options = 8420;
        definedThemes = new Table();
        COMPONENT_LIST = new String[][]{{THEME_COMPONENT_CBG, "Background color."}, {THEME_COMPONENT_CFG, "Foreground color."}, {THEME_COMPONENT_CWBG, "Widget background color."}, {THEME_COMPONENT_CWFG, "Widget foreground color."}, {THEME_COMPONENT_CWTI, "Widget title color."}, {THEME_COMPONENT_CWFH, "Widget foreground highlight color."}, {THEME_COMPONENT_CWBH, "Widget background highlight color."}, {THEME_COMPONENT_CWTS, "Widget shadow color (top)."}, {THEME_COMPONENT_CWBS, "Widget shadow color (bottom)."}, {THEME_COMPONENT_CWMS, "Menu shading"}, {THEME_COMPONENT_CBGX, "Background shading"}};
        graphicsDelay = 0.0;
        try {
            double delay;
            String graphicsDelayProp;
            String graphicsProp = System.getProperty("GRAPHICS");
            if (graphicsProp != null) {
                Theme.setOptions(graphicsProp);
            }
            if ((graphicsDelayProp = System.getProperty("GRAPHICSDELAY")) != null && (delay = Double.parseDouble(graphicsDelayProp)) > 0.0) {
                graphicsDelay = delay;
            }
        }
        catch (Exception e) {
            Theme.warn(null, "Theme: Cannot get GRAPHICS property.", e);
        }
        if (Theme.getOption(1024)) {
            Theme.initialize();
        }
    }
}

