/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Command;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.Dictionary;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;

public class Terminal
implements Appendable {
    public static final int INPUT_NO_ESC = 2;
    public static final int INPUT_TAB_COMPLETE = 1;
    public static final int INPUT_NORMAL = 0;
    public static final int INPUT_CHAR = -1;
    public static final int INPUT_CHAR_CLEAR = -2;
    public static final int INPUT_RETURN = -3;
    public Midas M;
    protected int morestat = -1;
    private String morestr;
    private String morespaces;
    public TextFile archiver = null;
    public Command messager = null;
    public Terminal leach = null;
    public boolean echo = true;
    protected static final int DEFAULT_ROW_COUNT = 32;
    protected static final int DEFAULT_COL_COUNT = 80;
    public static final int INIT = 1;
    public static final int FLUSH = 2;
    public static final int EXIT = 9;
    private int rows = 32;
    private int columns = 80;
    private Formatter formatter;
    private InputStream in;
    private OutputStream out;
    private Shell shell = null;
    private static final String[] CWD_ONLY = new String[]{"CWD"};

    public Terminal() {
        this(null, System.in, System.out, 32, 80);
    }

    public Terminal(Midas midas) {
        this(midas, System.in, System.out, 32, 80);
    }

    public Terminal(InputStream in, OutputStream out) {
        this(null, in, out, 32, 80);
    }

    protected Terminal(Midas midas, int rows, int cols) {
        this(midas, System.in, System.out, rows, cols);
    }

    public Terminal(Midas midas, InputStream in, OutputStream out, int rows, int cols) {
        this.M = midas;
        this.in = in;
        this.out = out;
        this.rows = rows;
        this.columns = cols;
    }

    public String read() {
        return this.getInput("", "", -1);
    }

    public String readln() {
        return this.getInput("", "", 0);
    }

    public synchronized void write(CharSequence text) {
        String textstr;
        String string = textstr = text == null ? null : text.toString();
        if (this.messager != null) {
            this.messager.processMessage("TEXT", 0, textstr);
        }
        if (this.archiver != null) {
            this.archiver.write(textstr);
        }
        if (this.echo) {
            if (this.leach != null) {
                this.leach.write(textstr);
            } else {
                this.print(textstr);
            }
        }
    }

    public void writeln(CharSequence text) {
        this.write(text + "\n");
    }

    public void println(CharSequence text) {
        this.print(text + "\n");
    }

    public synchronized void print(String text) {
        try {
            this.out.write(text.getBytes());
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getInput(String prompt, String seed) {
        return this.getInput(prompt, seed, 0);
    }

    public String getInput(String prompt, String seed, int flags) {
        if (this.leach != null) {
            return this.leach.getInput(prompt, seed, flags);
        }
        int i = 0;
        int n = 0;
        int maxbuf = 1024;
        char[] buffer = new char[maxbuf];
        this.print(prompt);
        while (true) {
            try {
                i = this.in.read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (i == -1 || i == 13) continue;
            if (i == 10 || n >= maxbuf) {
                return new String(buffer, 0, n);
            }
            buffer[n++] = (char)i;
        }
    }

    public final String getInputTabComplete(String prompt, String seed) {
        boolean complete = true;
        boolean autolist = true;
        String input = null;
        if (!complete) {
            input = this.getInput(prompt, seed, 0);
        } else {
            input = this.getInput(prompt, seed, 1);
            while (input != null && input.endsWith("\t")) {
                String str = input.substring(0, input.length() - 1);
                String[] tabComplete = this.tabComplete(str);
                if (tabComplete == null) {
                    input = this.getInput(prompt, str, 1);
                    continue;
                }
                if (autolist) {
                    for (int i = 1; i < tabComplete.length; ++i) {
                        this.print("    " + tabComplete[i] + "\n");
                    }
                } else {
                    Shell.beep();
                }
                input = this.getInput(prompt, tabComplete[0], 1);
            }
        }
        return input;
    }

    public int getInterrupt() {
        return 0;
    }

    public void setInterrupt(int value) {
    }

    public int getRows() {
        int rowCount = this.rows;
        if (rowCount <= 0) {
            rowCount = this.getRowCount();
        }
        if (rowCount <= 0) {
            rowCount = 32;
        }
        return rowCount;
    }

    public int getColumns() {
        int colCount = this.columns;
        if (colCount <= 0) {
            colCount = this.getColCount();
        }
        if (colCount <= 0) {
            colCount = 80;
        }
        return colCount;
    }

    protected int getRowCount() {
        return -1;
    }

    protected int getColCount() {
        return -1;
    }

    public void setRows(int r) {
        this.rows = r;
    }

    public void setColumns(int c) {
        this.columns = c;
    }

    public boolean more(int func) {
        if (func == 1) {
            this.morestat = this.getRows() - 1;
            this.morestr = "";
            this.morespaces = "                              ";
        } else if (func == 2) {
            if (this.morestr.length() > 0) {
                this.more(this.morestr);
            }
            this.morestr = "";
        } else if (func == 9) {
            if (this.morestr.length() > 0) {
                this.more(this.morestr);
            }
            this.morestat = -1;
        }
        return this.morestat >= 0;
    }

    public boolean more() {
        return this.morestat >= 0;
    }

    public void more(String text) {
        if (this.morestat >= 0 && this.morestat == 0) {
            String ans = this.getInput("Press RETURN=NextLine, SPACE=NextPage, or Q=Quit: ", "", -2);
            this.morestat = ans.startsWith("q") ? -1 : (ans.startsWith("Q") ? -1 : (ans.equals("\n") ? 1 : this.getRows() - 1));
        }
        if (this.morestat > 0) {
            --this.morestat;
            this.writeln(text);
            if (this.M.logger != null) {
                this.M.logger.processMessage(this.M, null, text, null);
            }
        }
    }

    public void more(CharSequence text) {
        this.more("" + text);
    }

    public void more(String text, int columnwidth) {
        int i;
        int width = this.getColumns();
        if (this.morestr.length() + Math.max(columnwidth, text.length()) > width) {
            if (this.morestr.endsWith(" ")) {
                int len;
                for (len = this.morestr.length(); len > 0 && this.morestr.charAt(len - 1) == ' '; --len) {
                }
                this.morestr = this.morestr.substring(0, len);
            }
            this.more(this.morestr);
            this.morestr = "";
        }
        for (i = columnwidth - text.length(); i <= 0; i += columnwidth) {
        }
        this.morestr = this.morestr + text + this.morespaces.substring(0, i);
    }

    public void moreString(String text) {
        this.moreString(StringUtil.cleanSplit(text, "\n"));
    }

    public final void moreString(String ... lines) {
        this.moreString(lines, 0, lines.length - 1);
    }

    public final void moreString(String[] lines, int start, int end) {
        if (lines == null) {
            return;
        }
        start = Math.max(start, 0);
        end = Math.min(end, lines.length);
        this.more(1);
        for (int i = start; this.more() && i <= end; ++i) {
            this.more(lines[i]);
        }
        this.more(9);
    }

    public boolean isExtCmdSupported() {
        return true;
    }

    public synchronized Terminal format(String format, Object ... args) {
        if (this.formatter == null) {
            this.formatter = new Formatter(this);
        }
        this.formatter.format(format, args);
        return this;
    }

    public Terminal printf(String format, Object ... args) {
        return this.format(format, args);
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.write(csq);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.write(String.valueOf(c));
        return this;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public InputStream setInputStream(InputStream instream) {
        InputStream prevInStream = this.in;
        this.in = instream;
        return prevInStream;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public OutputStream setOutputStream(OutputStream outstream) {
        OutputStream prevOutStream = this.out;
        this.out = outstream;
        return prevOutStream;
    }

    public Shell getShell() {
        return this.shell;
    }

    @InternalUseOnly
    public void setShell(Shell shell) {
        this.shell = shell;
    }

    private String[] tabComplete(String input) {
        List<String> matches = null;
        String[] results = null;
        boolean keepCase = false;
        Parser parser = new Parser(input.trim());
        int index = parser.elements();
        String last = null;
        if (index >= 1 && !input.endsWith(" ")) {
            last = parser.get(index);
            if (index == 1) {
                if (last.startsWith("%")) {
                    matches = this.findMatches(Dictionary.findPercentMacros(this.M), last.toUpperCase(), null);
                } else {
                    matches = this.M.dictionary.findMatches(this.M, last.toUpperCase());
                    if (matches.size() == 1) {
                        String cmdName = matches.get(0);
                        if (last.indexOf(59) < 0) {
                            cmdName = this.M.dictionary.findName(cmdName);
                        }
                        matches.set(0, cmdName + " ");
                    }
                }
            } else if (last.length() != 0 && last.lastIndexOf("^") <= 0) {
                if (last.startsWith("^")) {
                    matches = this.findMatches(this.M.results, last, "");
                } else {
                    String first = parser.get(1).toUpperCase();
                    String command = first.indexOf(47) <= 1 ? first : first.substring(0, first.lastIndexOf(47));
                    boolean osCommand = command.charAt(0) != '%' && this.M.dictionary.findMatch(command) < 0;
                    boolean url = last.indexOf(":") > 2;
                    boolean firstIsLetter = Character.isLetter(last.charAt(0));
                    boolean qualsOrTrimmers = last.indexOf(123) >= 0 || last.indexOf(40) >= 0;
                    boolean nxmDot = last.startsWith("nxm.");
                    matches = new ArrayList<String>();
                    keepCase = true;
                    if (firstIsLetter && !url && !osCommand && !qualsOrTrimmers) {
                        matches.addAll(this.findMatches(this.M.results, last, ""));
                    }
                    if (!(matches.size() != 0 || qualsOrTrimmers || nxmDot && !osCommand)) {
                        String fname = last;
                        String ext = null;
                        if (fname.indexOf(46) > 0) {
                            ext = fname.substring(fname.indexOf(46) + 1);
                            fname = fname.substring(0, fname.indexOf(46));
                        }
                        matches.addAll(this.findFiles(fname, ext, osCommand));
                        if (matches.size() == 0 && ext != null) {
                            matches.addAll(this.findFiles(last, null, osCommand));
                        }
                    }
                }
            }
        }
        if (matches != null && matches.size() > 0 && last != null) {
            String prefix;
            int end = input.lastIndexOf(last);
            String string = prefix = end >= 0 ? input.substring(0, end) : null;
            if (matches.size() == 1) {
                results = new String[]{prefix + matches.get(0)};
            } else if (prefix != null) {
                results = new String[matches.size() + 1];
                int count = this.findCommonCharCount(matches, last.length(), !keepCase);
                results[0] = prefix + matches.get(0).substring(0, count);
                for (int i = 1; i < results.length; ++i) {
                    results[i] = matches.get(i - 1);
                }
            }
        }
        return results;
    }

    private int findCommonCharCount(List<String> strs, int startLen, boolean ignoreCase) {
        String str = strs.get(0);
        for (int ii = 1; ii < strs.size() && str.length() > startLen; ++ii) {
            String next = strs.get(ii);
            if (str.length() > next.length()) {
                str = str.substring(0, next.length());
            } else {
                next = next.substring(0, str.length());
            }
            while (str.length() > startLen && !this.equals(str, next, ignoreCase)) {
                next = next.substring(0, str.length() - 1);
                str = str.substring(0, str.length() - 1);
            }
        }
        return str.length();
    }

    private boolean equals(String str1, String str2, boolean ignoreCase) {
        return ignoreCase ? str1.equalsIgnoreCase(str2) : str1.equals(str2);
    }

    private List<String> findMatches(String[] keys, String prefix, String name) {
        ArrayList<String> matches = new ArrayList<String>();
        String prefixUC = prefix.toUpperCase();
        for (String key : keys) {
            if (!key.startsWith(prefixUC)) continue;
            if (name == null) {
                matches.add(key + " ");
                continue;
            }
            matches.add(name + key + " ");
        }
        return matches;
    }

    private List<String> findMatches(Table tbl, String prefix, String name) {
        boolean caret = prefix.startsWith("^");
        if (caret) {
            prefix = prefix.substring(1);
        }
        String prefixUC = prefix.toUpperCase();
        List<String> matches = null;
        if (prefix.indexOf(46) > 0) {
            String tblName = prefixUC.substring(0, prefixUC.indexOf(46));
            String tagName = prefixUC.substring(prefixUC.indexOf(46) + 1);
            Table table = tbl.getTable(tblName);
            if (table != null) {
                String tname = caret ? "^" + name : name;
                matches = this.findMatches(table, tagName, tname + tblName + ".");
            } else {
                matches = new ArrayList();
            }
        } else {
            String[] keys = tbl.getKeys();
            matches = new ArrayList<String>();
            for (int i = 0; i < keys.length; ++i) {
                if (!keys[i].startsWith(prefixUC)) continue;
                String tname = name + keys[i];
                if (caret) {
                    tname = "^" + tname;
                }
                if (!(tbl.get(keys[i]) instanceof Table)) {
                    tname = tname + " ";
                }
                matches.add(tname);
            }
        }
        return matches;
    }

    private List<String> findFiles(String fname, String ext, boolean noAux) {
        if (ext == null) {
            fname = fname + "*";
            ext = "*";
        } else {
            ext = ext + "*";
        }
        ArrayList<String> matches = new ArrayList<String>();
        boolean isRootDir = fname.startsWith(File.separator);
        if (fname.length() > 2 && Character.isLetter(fname.charAt(0)) && fname.charAt(1) == ':') {
            isRootDir = true;
        }
        if (isRootDir) {
            int index = fname.lastIndexOf(File.separatorChar);
            String path = fname.substring(0, index + 1);
            String file = fname.substring(index + 1);
            this.addFilesToList(matches, path, file, ext, null, true);
        } else {
            String[] keys;
            for (String key : keys = noAux ? CWD_ONLY : this.M.io.getReadAux()) {
                if (Shell.getCurrent().isExcludedAux(key)) continue;
                String append = matches.size() == 0 ? null : "{AUX=" + key + "}";
                this.addFilesToList(matches, this.M.io.getAuxPath(key), fname, ext, append, false);
            }
        }
        return matches;
    }

    private void addFilesToList(List<String> matches, String path, String fname, String ext, String append, boolean noAux) {
        String[] files = this.M.io.listFiles(path, fname, ext);
        if (files != null) {
            for (int j = 0; j < files.length; ++j) {
                String file = files[j];
                if (noAux) {
                    file = path + file;
                    if (!CoreIO.isDirectoryName(file)) {
                        file = file + " ";
                    }
                } else {
                    file = append != null ? file + append + " " : file + " ";
                }
                matches.add(file);
            }
        }
        if (noAux && ext.equals("*")) {
            this.addFilesToList(matches, path, fname, "dir", append, noAux);
        }
    }
}

