/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import nxm.sys.inc.AsciiMap;
import nxm.sys.inc.Filter;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.KeyableByType;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.Tablizable;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.JsonUtilities;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Results;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;

public class Table
implements KeyableByType,
AsciiMap,
Externalizable,
Map<String, Object>,
Tablizable,
Iterable<String> {
    private static final long serialVersionUID = -732556679284448385L;
    public static final int FB = 1;
    public static final int KV = 2;
    public static final int HT = 3;
    public static final int HM = 4;
    public static final int LHM = 5;
    public static final int SLHM = 6;
    public static final int TM = 7;
    public static final int STM = 8;
    public static final int MAP = 9;
    public static final int KEY = 10;
    public static final int CHM = 11;
    private static final int FIRST_MODE = 1;
    private static final int LAST_MODE = 11;
    public static final String tableModesList = "FB,KV,HT,HM,LHM,SLHM,TM,STM,MAP,KEY,CHM";
    public static final String modeList = "FromBytes,KeyVector,Hashtable,HashMap,LinkedHashMap,SynchronizedLinkedHashMap,TreeMap,SynchronizedTreeMap,Map,Keyable,ConcurrentHashMap";
    public static final int AUTOREADPREV = 1;
    public static final int AUTOWRITEPREV = 2;
    public static final int ADD = 4;
    public static final int READONLY = 8;
    public static final int FORCE = 16;
    public static final int ADDROOT = 32;
    public static final int CASESENSITIVE = 64;
    public static final int EXCEPTION_ON_NULL = 128;
    public static final int DISABLE_ESCAPE_SEQUENCES = 256;
    public static final int ONLY_DOT_INTO_SUBTABLES = 512;
    public static final int CHECK_MALFORMED = 1024;
    public static final int SERIALIZE_TIME_AS_TCOLON = 2048;
    public static final int IGNORE_EMPTY_INSERTS = 4096;
    public static final int INLINE_TYPE_CONVERSION = 8192;
    @InternalUseOnly(value="Since NeXtMidas 3.7.0: This flag should only be set by nxm.sys.lib.Results")
    public static final int INLINE_RESULTS_CONVERSION = 16384;
    public static final int PERMIT_NULL = 32768;
    public static final int KEEP_JAVA_NUMERIC_TYPE = 65536;
    public static final int SERIALIZE_WITH_ORIGINAL_FLAGS = 131072;
    public static final int DISABLE_CONSISTENT_HANDLING_OF_WHITESPACE = 262144;
    public static final int ONLY_JAVA_NUMERIC_SERIALIZATION = 524288;
    public static final int QUOTED_KEYS_SERIALIZATION = 0x100000;
    @InternalUseOnly
    public static final int ALLOW_DOTS_IN_KEYS = 0x200000;
    public static final int CONTRADICTORY_NULL_FLAGS = 32896;
    public static final String flagsList = "AutoReadPrev,AutoWritePrev,Add,ReadOnly,Force,AddRoot,CaseSensitive,ExceptionOnNull,DisableEscapeSequences,OnlyDotIntoSubTables,CheckMalformed,SerializeTimeAsTColon,IgnoreEmptyInserts,InlineTypeConversion,InlineResultsConversion,PermitNull,KeepJavaNumericType,SerializeWithOriginalFlags,DisableConsistentHandlingOfWhiteSpace,OnlyJavaNumericSerialization,QuotedKeysSerialization,AllowDotsInKeys";
    private static int defaultMode = 6;
    private static int defaultFlags = 1;
    @InternalUseOnly
    public static String SAVESTATE_KEY_DOT_SUBSTITUTE;
    private static String saveStateKeyDotSubstitute;
    private int genericMode = 1;
    private int specificMode = 1;
    private byte[] fb;
    private transient KeyVector kv;
    private transient Keyable kbl;
    private transient Map<String, Object> map;
    private transient Listener listener;
    private Table prev;
    protected int flags;
    private transient Enum en;
    protected transient Object ref;
    protected transient Map<String, Function> fht;
    private boolean caretEnabled = true;
    private static boolean doNotAllowRandomParen;

    public Table() {
        this(defaultMode, defaultFlags);
    }

    public Table(int mode) {
        this(mode, defaultFlags);
    }

    public Table(int mode, int flags) {
        boolean currentNotNull;
        this.setMode(mode);
        boolean bl = currentNotNull = Shell.getCurrent() != null;
        if (currentNotNull && Shell.getMidasContext().io.isOptionSet(CoreIO.IOOptions.FavorJavaBehaviorOverTraditionalMidasBehavior)) {
            this.setFlags(flags | 0x10000 | 0x80000);
        } else {
            this.setFlags(flags);
        }
        if (currentNotNull && Shell.getMidasContext().io.isOptionSet(CoreIO.IOOptions.DisableResultUsageWithCaretInTable)) {
            this.caretEnabled = false;
        }
    }

    public Table(String mode, String flags) {
        this(Table.modeStrToNum(mode), Parser.mask(flagsList, flags, defaultFlags));
    }

    public Table(String string) {
        this(1);
        if (string != null) {
            this.fromBytes(string.getBytes());
        }
    }

    public Table(String string, int flags) {
        this(1, flags);
        if (string != null) {
            this.fromBytes(string.getBytes());
        }
    }

    public Table(byte[] bytes) {
        this(1);
        if (bytes != null && bytes.length > 0) {
            this.fromBytes(bytes);
        }
    }

    public Table(byte[] bytes, int start, int len) {
        this(1);
        if (bytes != null && bytes.length > 0 && start >= 0 && len <= bytes.length - start) {
            this.fromBytes(bytes, start, start + len);
        }
    }

    public Table(TextFile tf) {
        this(1);
        this.fromTextFile(tf);
    }

    public Table(TextFile tf, int flags) {
        this(1, flags);
        this.fromTextFile(tf, flags);
    }

    @Deprecated
    public Table(Hashtable<String, ?> ht) {
        this(1);
        this.fromTable(ht);
    }

    public Table(Map<String, ?> map) {
        this.putAll(map);
    }

    public Table(String string, boolean load) {
        this(1);
        if (string == null) {
            return;
        }
        if (!load) {
            this.fromBytes(string.getBytes());
        } else {
            this.fromBytes(string.getBytes(), 0, string.length());
        }
    }

    private static int modeStrToNum(String mode) {
        if (mode.equalsIgnoreCase("DEFAULT") || mode.equalsIgnoreCase("DEF")) {
            return defaultMode;
        }
        int m = Parser.find(tableModesList, mode, -1);
        if (m < 0) {
            m = Parser.find(modeList, mode, -1);
        }
        if (m < 0) {
            throw new MidasException("Table: Invalid mode '" + mode + "' expected one of '" + modeList + "'.");
        }
        return m;
    }

    public static int getDefaultModeInt() {
        return defaultMode;
    }

    public static String getDefaultModeName() {
        return Parser.get(tableModesList, Table.getDefaultModeInt());
    }

    public static String getDefaultMode() {
        return Parser.get(modeList, Table.getDefaultModeInt());
    }

    public static void setDefaultMode(String newMode) {
        Table.setDefaultMode(Table.modeStrToNum(newMode));
    }

    public static void setDefaultMode(int newMode) {
        if (newMode == 1) {
            throw new MidasException("Table: Default table mode can not be set to FB.");
        }
        if (newMode < 1 || newMode > 11) {
            throw new MidasException("Table: Unknown table mode " + newMode + ".");
        }
        defaultMode = newMode;
    }

    public void setMode(String newMode) {
        this.setMode(Table.modeStrToNum(newMode));
    }

    public int getModeInt() {
        return this.specificMode;
    }

    public String getMode() {
        return Parser.get(modeList, this.getModeInt());
    }

    public String getModeName() {
        return Parser.get(tableModesList, this.getModeInt());
    }

    public boolean isMode(int mode) {
        if (mode == this.specificMode) {
            return true;
        }
        if (mode == 9) {
            return this.genericMode == 9;
        }
        if (mode == 10) {
            return this.genericMode == 10 || this.genericMode == 2;
        }
        return false;
    }

    public boolean isMode(String mode) {
        return this.isMode(Table.modeStrToNum(mode));
    }

    public void setMode(int newMode) {
        if (this.isMode(newMode)) {
            return;
        }
        if (newMode == 1) {
            this.fb = this.toBytes();
            this.specificMode = 1;
            this.genericMode = 1;
            return;
        }
        int oldMode = this.genericMode;
        byte[] oldFB = this.fb;
        KeyVector oldKV = this.kv;
        Map<String, Object> oldMAP = this.map;
        Keyable oldKEY = this.kbl;
        this.fb = null;
        this.kv = null;
        this.map = null;
        this.kbl = null;
        if (newMode == 9) {
            newMode = 6;
        }
        if (newMode == 10) {
            newMode = 2;
        }
        this.specificMode = newMode;
        switch (newMode) {
            case 2: {
                this.genericMode = 2;
                this.kv = new KeyVector(32);
                break;
            }
            case 3: {
                this.genericMode = 9;
                this.map = new Hashtable<String, Object>();
                break;
            }
            case 4: {
                this.genericMode = 9;
                this.map = new HashMap<String, Object>();
                break;
            }
            case 5: {
                this.genericMode = 9;
                this.map = new LinkedHashMap<String, Object>();
                break;
            }
            case 6: {
                this.genericMode = 9;
                this.map = Collections.synchronizedMap(new LinkedHashMap());
                break;
            }
            case 7: {
                this.genericMode = 9;
                this.map = new TreeMap<String, Object>();
                break;
            }
            case 8: {
                this.genericMode = 9;
                this.map = Collections.synchronizedMap(new TreeMap());
                break;
            }
            case 11: {
                this.genericMode = 9;
                this.map = new ConcurrentHashMap<String, Object>();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown table mode " + newMode);
            }
        }
        switch (oldMode) {
            case 1: {
                if (oldFB == null) break;
                this.fromBytes(oldFB, 0, oldFB.length);
                break;
            }
            case 2: {
                this.merge(oldKV);
                break;
            }
            case 9: {
                this.putAll(oldMAP);
                break;
            }
            case 10: {
                this.merge(oldKEY);
            }
        }
    }

    public Object getCore() {
        Object obj = null;
        switch (this.genericMode) {
            case 1: {
                obj = this.fb;
                break;
            }
            case 2: {
                obj = this.kv;
                break;
            }
            case 9: {
                obj = this.map;
                break;
            }
            case 10: {
                obj = this.kbl;
            }
        }
        return obj;
    }

    private void checkModeFB() {
        if (this.genericMode <= 1) {
            this.setMode(defaultMode);
        }
    }

    @Override
    public Object getKey(String key) throws NullPointerException {
        int len;
        if (key.equals("Prev") || key.equals("Keys") || key.equals("List") || key.equals("Size")) {
            Shell.deprecate("getKey('" + key + "') is deprecated. Use getKey('GET" + key.toUpperCase() + "').");
        }
        if ((len = key.length()) != 7 && len != 4) {
            return this.getx(key);
        }
        if (key.equalsIgnoreCase("GETPREV") || key.equals("Prev")) {
            return this.getPrevious();
        }
        if (key.equalsIgnoreCase("GETKEYS") || key.equals("Keys")) {
            return this.getKeys();
        }
        if (key.equalsIgnoreCase("GETLIST") || key.equals("List")) {
            return this.getKeyList();
        }
        if (key.equalsIgnoreCase("GETSIZE") || key.equals("Size")) {
            return this.size();
        }
        if (key.equalsIgnoreCase("GETCORE") || key.equals("Core")) {
            return this.getCore();
        }
        return this.getx(key);
    }

    @Override
    public Object setKey(String key, Object value) {
        this.put(key, value);
        return (0x2000 & this.flags) == 0 ? value : this.get(key);
    }

    public final Object remove(String key) throws NullPointerException {
        return this.remove(key, 0);
    }

    public synchronized Object remove(String key, int attr) throws NullPointerException {
        String keyroot;
        Object root;
        int i;
        Object oldVal;
        if ((this.flags & 8) != 0 && (attr & 0x10) == 0) {
            Shell.warning("Must use FORCE flag to remove tag=" + key + " from ReadOnly table");
            return null;
        }
        if (key == null) {
            return null;
        }
        Object getxVal = this.getx(key);
        if ((this.flags & 0x200000) == 0 || getxVal == null) {
            oldVal = this.get(key);
            i = key.indexOf(46);
        } else {
            oldVal = getxVal;
            i = -1;
        }
        this.checkModeFB();
        if (i > 0 && (root = this.getx(keyroot = key.substring(0, i))) instanceof Table) {
            ((Table)root).remove(key.substring(i + 1), attr);
            return oldVal;
        }
        if (key.length() > 0) {
            switch (this.genericMode) {
                case 10: {
                    this.kbl.setKey(key, null);
                    break;
                }
                case 2: {
                    this.kv.remove(key);
                    break;
                }
                case 9: {
                    if (this.en != null && this.en.iter != null) {
                        this.en.iter.remove();
                        break;
                    }
                    this.map.remove(key);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown table mode " + this.genericMode));
                }
            }
        }
        return oldVal;
    }

    @Override
    public final Object put(String key, Object value) throws NullPointerException {
        return this.put(key, value, 0, this.ref);
    }

    public final Object put(String key, Object value, int attr) throws NullPointerException {
        return this.put(key, value, attr, this.ref);
    }

    public final Object put(String key, Object value, Object ref) throws NullPointerException {
        return this.put(key, value, 0, ref);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object put(String key, Object value, int attr, Object ref) throws RuntimeException {
        Object object;
        int i;
        int allFlags = this.flags | attr;
        if ((allFlags & 0x1000) != 0) {
            if (key == null) return null;
            if (key.isEmpty()) {
                return null;
            }
        }
        if (key == null) {
            throw new IllegalArgumentException("Table Key=null not allowed");
        }
        if ((allFlags & 0x2000) != 0 && key.length() > 2 && key.charAt(1) == ':') {
            int type = key.charAt(0);
            key = key.substring(2);
            if (type == 65) {
                Shell.deprecate("Since NeXtMidas 2.5.2: Change use of A:" + key + " to S:" + key + ". The behavior of of A: will change in future releases.");
                type = 83;
            }
            value = Convert.o2o(value, (char)type, ref);
        }
        if ((allFlags & 0x4000) != 0) {
            i = key.indexOf(46);
            int j = key.indexOf(41);
            if (i < 0 && j < 0) {
                if (this.fht == null) return this.putx(key, value, attr);
                Function f = this.fht.get(key);
                if (f == null) return this.putx(key, value, attr);
                f.set(value);
                return value;
            }
            if (j > 0 && key.startsWith("FILE(")) {
                j = StringUtil.getClosingFensePos(key, "()", 4);
                Midas midas = Convert.ref2Midas(ref);
                DataFile df = Convert.inLineFile(midas, key.substring(5, j), true);
                Object prevValue = KeyObject.setKey(df, key.substring(j + 2), value, ref);
                df.close();
                return prevValue;
            }
            if (j >= 0) {
                return KeyObject.setKey(this, key, value, ref);
            }
        }
        this.checkModeFB();
        Object root = this;
        String origKey = key;
        boolean findingNestedIsWorking = true;
        while (findingNestedIsWorking && (i = key.indexOf(46)) > 0) {
            block16: {
                String keyroot;
                block17: {
                    keyroot = key.substring(0, i);
                    if (!(root instanceof Table)) break block17;
                    Object tbl = root;
                    if ((root = ((Table)tbl).getx(keyroot)) != null) break block16;
                    if ((attr & 0x20) != 0 || (((Table)tbl).flags & 0x20) != 0) {
                        root = ((Table)tbl).addTable(keyroot);
                        break block16;
                    } else if ((this.flags & 0x200000) != 0) {
                        findingNestedIsWorking = false;
                        root = this;
                        key = origKey;
                        i = -1;
                        break block16;
                    } else {
                        int origDot = origKey.indexOf(46);
                        String origKeyroot = origDot > 0 ? origKey.substring(0, origDot) : origKey;
                        String topLevelMissing = this.getx(origKeyroot) instanceof Table ? "Key " + keyroot : "Table " + origKeyroot;
                        throw new MidasException(topLevelMissing + " does not exist, so unable to set value of " + origKey + " without forcing via /ADDROOT switch");
                    }
                }
                if ((root = KeyObject.getKey(root, keyroot, null, ref)) == null) {
                    throw new MidasException("Key " + keyroot + " does not exist, so unable to set value of " + origKey + " without forcing via /ADDROOT switch");
                }
            }
            key = key.substring(i + 1);
        }
        if (root instanceof Table) {
            object = ((Table)root).putx(key, value, attr);
            return object;
        }
        object = KeyObject.setKey(root, key, value);
        return object;
    }

    public boolean addIfNotPresent(String key, Object value) throws NullPointerException {
        if (this.containsKey(key)) {
            return false;
        }
        this.put(key, value, 0, null);
        return true;
    }

    public boolean addIfNotPresent(Map<String, Object> map) throws NullPointerException {
        if (map == null) {
            return false;
        }
        boolean retval = false;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            retval |= this.addIfNotPresent(entry.getKey(), entry.getValue());
        }
        return retval;
    }

    public synchronized Object addTable(String key) {
        Object root = this.get(key);
        if (root != null) {
            return root;
        }
        root = new Table(this.specificMode, this.flags);
        this.putx(key, root);
        return root;
    }

    public void putx(String key, Object value) throws NullPointerException {
        this.putx(key, value, 0);
    }

    public synchronized Object putx(String key, Object value, int attr) throws NullPointerException {
        if ((this.flags & 8) != 0 && (attr & 0x10) == 0) {
            Shell.warning("Must use FORCE flag to put tag=" + key + " into ReadOnly table");
            return null;
        }
        if (this.listener != null && this.listener.putAction(key, value)) {
            return null;
        }
        this.checkModeFB();
        if (value == null && (this.flags & 0x8000) == 0) {
            if ((this.flags & 0x80) != 0) {
                throw new NullPointerException("Table: Can not insert " + key + "=" + value + " into table.");
            }
            value = "NULL";
        }
        if (this.prev != null) {
            Object root = null;
            switch (this.genericMode) {
                case 2: {
                    root = this.kv.get(key);
                    break;
                }
                case 9: {
                    root = this.map.get(key);
                    break;
                }
                case 10: {
                    root = this.kbl.getKey(key);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown table mode " + this.genericMode));
                }
            }
            if (root instanceof Results) {
                if (root != value) {
                    return ((Table)root).putx(key, value, attr);
                }
                return null;
            }
        }
        switch (this.genericMode) {
            case 2: {
                if ((this.flags & 4) != 0) {
                    this.kv.add(key, value);
                    return null;
                }
                return this.kv.put(key, value);
            }
            case 9: {
                return this.map.put(key, value);
            }
            case 10: {
                return this.kbl.setKey(key, value);
            }
        }
        throw new AssertionError((Object)("Unknown table mode " + this.genericMode));
    }

    public Object get(String key, Object defValue, int options) {
        boolean drillIntoProperties;
        int allFlags = this.flags | options;
        char type = ' ';
        Object value = null;
        boolean valueSet = false;
        if ((allFlags & 0x1000) != 0 && (key == null || key.isEmpty())) {
            return null;
        }
        if (key == null) {
            throw new NullPointerException("Table Key=null not allowed");
        }
        if ((allFlags & 0x2000) != 0 && key.length() > 2 && key.charAt(1) == ':') {
            type = key.charAt(0);
            key = key.substring(2);
        }
        if ((allFlags & 0x4000) != 0) {
            int i = key.indexOf(46);
            int j = key.indexOf(41);
            if (i < 0 && j < 0) {
                Function f;
                if (this.fht != null && (f = this.fht.get(key)) != null) {
                    value = f.get();
                    valueSet = true;
                } else {
                    value = this.getx(key);
                    valueSet = true;
                }
            } else if (j < 0) {
                Object root = this.getx(key.substring(0, i));
                value = KeyObject.getKey(root, key.substring(i + 1), null, this.ref);
                valueSet = true;
            } else if (key.startsWith("FILE(")) {
                j = StringUtil.getClosingFensePos(key, "()", 4);
                Midas midas = Convert.ref2Midas(this.ref);
                DataFile df = Convert.inLineFile(midas, key.substring(5, j), false);
                value = j == key.length() - 1 ? df : KeyObject.getKey(df, key.substring(j + 2), null, this.ref);
                valueSet = true;
                df.close();
            } else if (key.startsWith("CALC(")) {
                value = Convert.d2o(Convert.s2d(key, this.ref));
                valueSet = true;
            } else if (key.startsWith("TEST(")) {
                value = Convert.d2o(Convert.s2l(key, this.ref));
                valueSet = true;
            } else if (key.startsWith("SEDIT(")) {
                Midas M = Convert.ref2Midas(this.ref);
                Parser p = new Parser(key.substring(6, key.length() - 1), true);
                Args args = new Args(M, p);
                if (this.ref instanceof Args) {
                    ((Args)this.ref).copySwitchesTo(args);
                }
                value = Convert.processSeditCommandLine(args.getCS(1), M, args, 2, false);
                valueSet = true;
            } else {
                try {
                    value = KeyObject.getKey(this, key, null, this.ref);
                    valueSet = true;
                }
                catch (MidasException midasException) {
                    value = null;
                }
            }
        }
        boolean allowingKeysWithDots = (this.flags & 0x200000) != 0;
        boolean bl = drillIntoProperties = !allowingKeysWithDots && (options & 0x200) == 0;
        if (!valueSet) {
            int ii = key.indexOf(46);
            if (ii > 0) {
                String keyroot = key.substring(0, ii);
                String subkey = key.substring(ii + 1);
                Object root = this.getx(keyroot);
                if (root == null) {
                    Object keyWithDotsValue = this.getx(key);
                    if (allowingKeysWithDots && keyWithDotsValue != null) {
                        return keyWithDotsValue;
                    }
                    return defValue;
                }
                while (root != null && (ii = subkey.indexOf(46)) > 0) {
                    keyroot = subkey.substring(0, ii);
                    subkey = subkey.substring(ii + 1);
                    if (root instanceof Table) {
                        root = ((Table)root).getx(keyroot);
                        continue;
                    }
                    if (!drillIntoProperties) continue;
                    root = KeyObject.getKey(root, keyroot);
                }
                if (root == null) {
                    Object keyWithDotsValue = this.getx(key);
                    if (allowingKeysWithDots && keyWithDotsValue != null) {
                        return keyWithDotsValue;
                    }
                    return defValue;
                }
                if (root instanceof Table) {
                    value = ((Table)root).getx(subkey);
                } else if (drillIntoProperties) {
                    value = KeyObject.getKey(root, subkey);
                }
                if (allowingKeysWithDots && value == null) {
                    value = this.getx(key);
                }
            } else {
                value = this.getx(key);
            }
        }
        if (value == null) {
            return defValue;
        }
        if (type != ' ') {
            return Convert.o2o(value, type, this.ref);
        }
        return value;
    }

    public final Object get(String key, Object defValue) {
        return this.get(key, defValue, this.flags);
    }

    public Object get(String key) throws NullPointerException {
        return this.get(key, null, this.flags);
    }

    public Object getx(String key) throws NullPointerException {
        Boolean found;
        Object value;
        this.checkModeFB();
        switch (this.genericMode) {
            case 2: {
                value = this.kv.get(key);
                found = value != null || this.kv.find(key) >= 0;
                break;
            }
            case 9: {
                value = this.map.get(key);
                found = value != null || this.map.containsKey(key);
                break;
            }
            case 10: {
                value = this.kbl.getKey(key);
                found = value != null;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown table mode " + this.genericMode));
            }
        }
        if (this.prev != null) {
            if (!found.booleanValue() && (this.flags & 1) != 0) {
                value = this.prev.getx(key);
            } else if (value instanceof Results) {
                value = ((Table)value).getx(key);
            }
        }
        if (this.listener != null) {
            this.listener.getAction(key, value);
        }
        return value;
    }

    public String match(String abbr) {
        if (this.containsKey(abbr)) {
            return abbr;
        }
        Enumeration<String> e = this.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (!key.startsWith(abbr)) continue;
            return key;
        }
        return null;
    }

    @Override
    public final void clear() {
        this.clear(0);
    }

    public void clear(int attr) {
        if ((this.flags & 8) != 0 && (attr & 0x10) == 0) {
            Shell.warning("Must use FORCE flag to clear ReadOnly table");
            return;
        }
        if (this.genericMode == 10) {
            for (String key : this.kbl.getKeys()) {
                this.remove(key, attr);
            }
        } else {
            switch (this.genericMode) {
                case 1: {
                    this.fb = null;
                    break;
                }
                case 2: {
                    this.kv.clear();
                    break;
                }
                case 9: {
                    this.map.clear();
                    break;
                }
                case 10: {
                    throw new AssertionError((Object)"This should be impossible.");
                }
                default: {
                    throw new AssertionError((Object)("Unknown table mode " + this.genericMode));
                }
            }
        }
    }

    public static boolean isNullOrEmpty(Table tbl) {
        return tbl == null || tbl.isEmpty();
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.genericMode == 1 && this.fb == null) {
            return 0;
        }
        this.checkModeFB();
        switch (this.genericMode) {
            case 2: {
                return this.kv.size();
            }
            case 9: {
                return this.map.size();
            }
            case 10: {
                return this.kbl.getKeys().length;
            }
        }
        throw new AssertionError((Object)("Unknown table mode " + this.genericMode));
    }

    public final int getSize() {
        return this.size();
    }

    @InternalUseOnly(value="This method is for internal use only, use containsKey(..)")
    public boolean containsKeyx(String key) {
        this.checkModeFB();
        switch (this.genericMode) {
            case 2: {
                return this.kv.findKey(key) >= 0;
            }
            case 9: {
                return this.map.containsKey(key);
            }
            case 10: {
                return this.kbl.getKey(key) != null;
            }
        }
        throw new AssertionError((Object)("Unknown table mode " + this.genericMode));
    }

    public boolean containsKey(String key) {
        Object val = this.get(key, null, this.flags | 0x200);
        return val != null;
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkModeFB();
        if (this.genericMode == 10) {
            for (String key : this.kbl.getKeys()) {
                if (!value.equals(this.kbl.getKey(key))) continue;
                return true;
            }
            return false;
        }
        switch (this.genericMode) {
            case 2: {
                return this.kv.findValue(value) >= 0;
            }
            case 9: {
                return this.map.containsValue(value);
            }
        }
        throw new AssertionError((Object)("Unknown table mode " + this.genericMode));
    }

    @Deprecated
    public int enumeration() {
        this.en = new Enum(this);
        return this.size();
    }

    @Deprecated
    public boolean more() {
        if (this.en == null) {
            return false;
        }
        return this.en.hasMoreElements();
    }

    @Deprecated
    public String next() {
        if (this.en == null) {
            return null;
        }
        return this.en.nextElement();
    }

    public final void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream dev) {
        Iterator ti = this.iterator();
        while (ti.getNext()) {
            dev.println(ti.key + " = " + ti.value);
        }
    }

    @Override
    public final String[] getKeys() {
        return this.getKeys(null);
    }

    public final String getKeyList() {
        return this.getKeyList(null);
    }

    public String[] getKeys(Filter valueFilter) {
        Iterator ti = this.iterator();
        if (valueFilter == null) {
            return ti.keys;
        }
        ArrayList<String> list3 = new ArrayList<String>(ti.size);
        while (ti.getNext()) {
            if (!valueFilter.accept(ti.value)) continue;
            list3.add(ti.key);
        }
        return list3.toArray(StringUtil.EMPTY_STRING_ARRAY);
    }

    public String getKeyList(Filter valueFilter) {
        String list3 = "";
        Iterator ti = this.iterator();
        while (ti.getNext()) {
            if (valueFilter != null && !valueFilter.accept(ti.value)) continue;
            if (list3.length() == 0) {
                list3 = ti.key;
                continue;
            }
            list3 = list3 + "," + ti.key;
        }
        return list3;
    }

    @InternalUseOnly
    public String[] getValuesS() {
        Iterator ti = this.iterator();
        ArrayList<String> list3 = new ArrayList<String>(ti.size);
        while (ti.getNext()) {
            list3.add(this.get(ti.key).toString());
        }
        return list3.toArray(StringUtil.EMPTY_STRING_ARRAY);
    }

    public String toString() {
        if (this.fb != null) {
            return new String(this.fb);
        }
        return this.toStringBuffer().toString();
    }

    public static String toHTMLTable(Table table, String fontColor) {
        String displayText = "<table>";
        for (String key : table.keySet()) {
            if (table.get(key) instanceof Table) {
                displayText = displayText + "<tr><td>" + key + "</td><td>" + Table.toHTMLTable((Table)table.get(key), fontColor) + "</td></tr>";
                continue;
            }
            displayText = displayText + "<tr><td>" + key + "</td><td color=#" + fontColor + "><b>" + table.get(key) + "</b></td></tr>";
        }
        displayText = displayText + "</table>";
        return displayText;
    }

    public String getEscapedString() {
        return new String(this.toBytes());
    }

    public byte[] toBytes() {
        StringBuffer sb = new StringBuffer(1024);
        Table.toStringBuffer((Object)this, sb, this.flags);
        byte[] bytes = new byte[sb.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)sb.charAt(i);
        }
        return bytes;
    }

    @InternalUseOnly
    public byte[] toBytes(boolean replaceKeyDots) {
        StringBuffer sb = new StringBuffer(1024);
        Table.toStringBuffer(this, sb, this.flags, replaceKeyDots);
        byte[] bytes = new byte[sb.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)sb.charAt(i);
        }
        return bytes;
    }

    public synchronized StringBuffer toStringBuffer() {
        StringBuffer sb = new StringBuffer(1024);
        int flagsPlusDisableEscape = this.flags | 0x100;
        int serializationFlags = (this.flags & 0x20000) == 0 ? flagsPlusDisableEscape : this.flags;
        Table.toStringBuffer((Object)this, sb, serializationFlags);
        return sb;
    }

    @Deprecated
    public static void toStringBuffer(Object obj, StringBuffer sb, boolean esc) {
        int tflags = esc ? 0 : 256;
        Table.toStringBuffer(obj, sb, tflags);
    }

    static void toStringBuffer(Object obj, StringBuffer sb, int tflags) {
        Table.toStringBuffer(obj, sb, tflags, false);
    }

    static void toStringBuffer(Object obj, StringBuffer sb, int tflags, boolean replaceKeyDots) {
        String str;
        boolean dotGotReplaced = false;
        if (obj == null) {
            sb.append("null");
            return;
        }
        boolean esc = (tflags & 0x100) == 0;
        boolean saveTimeAsTColon = (tflags & 0x800) != 0;
        boolean keepJavaNumberType = (tflags & 0x10000) != 0;
        boolean onlyJavaNumericSerialization = (tflags & 0x80000) != 0;
        boolean quoteKeys = (tflags & 0x100000) != 0;
        boolean isTable = obj instanceof Table;
        boolean addTblSig = esc && !isTable;
        Class<?> clazz = obj.getClass();
        if (isTable) {
            Table tab = (Table)obj;
            if (tab.fb != null) {
                obj = tab.fb;
            } else if (tab.genericMode == 2) {
                obj = tab.kv;
            } else if (tab.genericMode == 9) {
                obj = tab.map;
            } else if (tab.genericMode == 10) {
                obj = tab.kbl;
            } else {
                sb.append("{}");
                return;
            }
        }
        if (obj instanceof KeyVector) {
            KeyVector kv = (KeyVector)obj;
            if (addTblSig) {
                sb.append("O:KV:");
            }
            sb.append('{');
            int i = 0;
            while (i < kv.size()) {
                String key = kv.getKey(i);
                if (quoteKeys) {
                    key = '\"' + key + '\"';
                }
                if (replaceKeyDots) {
                    if (!dotGotReplaced && key.contains(".")) {
                        dotGotReplaced = true;
                    }
                    key = key.replaceAll("\\.", saveStateKeyDotSubstitute);
                }
                sb.append(key);
                sb.append('=');
                Table.toStringBuffer(kv.get(i), sb, tflags, replaceKeyDots);
                if (++i >= kv.size()) continue;
                sb.append(',');
            }
            sb.append('}');
        } else if (obj instanceof Map) {
            if (addTblSig) {
                if (obj instanceof Hashtable) {
                    sb.append("O:HT:");
                } else if (obj instanceof TreeMap) {
                    sb.append("O:TM:");
                } else if (obj instanceof LinkedHashMap) {
                    sb.append("O:LHM:");
                } else if (obj instanceof ConcurrentHashMap) {
                    sb.append("O:CHM:");
                } else {
                    sb.append("O:HM:");
                }
            }
            Map map = (Map)obj;
            java.util.Iterator entries = map.entrySet().iterator();
            sb.append('{');
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Object origKey = entry.getKey();
                String key = String.valueOf(origKey);
                if (replaceKeyDots) {
                    if (!dotGotReplaced && key.contains(".")) {
                        dotGotReplaced = true;
                    }
                    key = key.replaceAll("\\.", saveStateKeyDotSubstitute);
                }
                if (quoteKeys) {
                    key = '\"' + key + '\"';
                }
                Object value = entry.getValue();
                sb.append(key);
                sb.append('=');
                Table.toStringBuffer(value, sb, tflags, replaceKeyDots);
                if (!entries.hasNext()) continue;
                sb.append(',');
            }
            sb.append('}');
        } else if (obj instanceof List) {
            List list3 = (List)obj;
            sb.append('(');
            for (int i = 0; i < list3.size(); ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                Table.toStringBuffer(list3.get(i), sb, tflags);
            }
            sb.append(')');
        } else if (obj instanceof byte[]) {
            byte[] fb = (byte[])obj;
            for (int i = 0; i < fb.length; ++i) {
                sb.append((char)fb[i]);
            }
        } else if (obj instanceof String) {
            str = (String)obj;
            Table.toStringBuffer(str, sb, tflags);
        } else if (obj instanceof Data) {
            Data data = (Data)obj;
            String str2 = data.toString();
            char type = (char)data.type;
            if (data.isString()) {
                Table.toStringBuffer(str2, sb, tflags);
            } else {
                sb.append(type).append(':').append(str2);
            }
        } else if (obj instanceof Keyable) {
            Keyable keyable = (Keyable)obj;
            String[] keys = keyable.getKeys();
            sb.append('{');
            for (int ii = 0; ii < keys.length; ++ii) {
                String key = quoteKeys ? '\"' + keys[ii] + '\"' : keys[ii];
                Object value = keyable.getKey(key);
                if (ii != 0) {
                    sb.append(',');
                }
                if (replaceKeyDots) {
                    if (!dotGotReplaced && key.contains(".")) {
                        dotGotReplaced = true;
                    }
                    key = key.replaceAll("\\.", saveStateKeyDotSubstitute);
                }
                sb.append(key);
                sb.append('=');
                Table.toStringBuffer(value, sb, tflags, replaceKeyDots);
            }
            sb.append('}');
        } else if (clazz.isArray()) {
            int length = Array.getLength(obj);
            sb.append('(');
            for (int ii = 0; ii < length; ++ii) {
                if (ii != 0) {
                    sb.append(',');
                }
                Table.toStringBuffer(Array.get(obj, ii), sb, tflags);
            }
            sb.append(')');
        } else if (clazz == Time.class && saveTimeAsTColon) {
            Time tobj = (Time)obj;
            String str3 = "T:" + tobj.toString("Full_Std", 12);
            sb.append(str3);
        } else if (clazz == File.class || obj instanceof Path) {
            str = obj.toString().replace('\\', '/');
            Table.toStringBuffer(str, sb, tflags);
        } else if (keepJavaNumberType && obj instanceof Number) {
            obj = Table.handleOtherNumberClasses((Number)obj);
            str = obj.toString();
            char type = Data.getDataTypeLetterPlus(obj);
            if (onlyJavaNumericSerialization) {
                type = Character.toUpperCase(type);
            }
            if (type != 'O') {
                sb.append(type + ":");
            }
            sb.append(str);
        } else {
            str = obj.toString();
            if (StringUtil.isNumber(str)) {
                sb.append(str);
            } else {
                Table.toStringBuffer(str, sb, tflags);
            }
        }
        if (dotGotReplaced) {
            Shell.warning("In saving state table " + obj + " had the dots in the key names replaced with " + saveStateKeyDotSubstitute);
        }
    }

    private static Number handleOtherNumberClasses(Number javaNumber) {
        if (javaNumber instanceof BigDecimal) {
            Double doubleVal = ((BigDecimal)javaNumber).doubleValue();
            if (doubleVal != Double.NEGATIVE_INFINITY && doubleVal != Double.POSITIVE_INFINITY) {
                return doubleVal;
            }
            return javaNumber;
        }
        if (javaNumber instanceof BigInteger) {
            try {
                return ((BigInteger)javaNumber).longValueExact();
            }
            catch (ArithmeticException ae) {
                return javaNumber;
            }
        }
        if (javaNumber instanceof AtomicInteger) {
            return ((AtomicInteger)javaNumber).intValue();
        }
        if (javaNumber instanceof AtomicLong) {
            return ((AtomicLong)javaNumber).longValue();
        }
        if (javaNumber instanceof DoubleAccumulator) {
            return ((DoubleAccumulator)javaNumber).doubleValue();
        }
        if (javaNumber instanceof DoubleAdder) {
            return ((DoubleAdder)javaNumber).doubleValue();
        }
        if (javaNumber instanceof LongAccumulator) {
            return ((LongAccumulator)javaNumber).longValue();
        }
        if (javaNumber instanceof LongAdder) {
            return ((LongAdder)javaNumber).longValue();
        }
        return javaNumber;
    }

    private static void toStringBuffer(String str, StringBuffer sb, int tflags) {
        int nbs = 0;
        int nesc = 0;
        int nq = 0;
        int nc = 0;
        int iq = 0;
        int ip = 0;
        int ic = 0;
        int ls = str.length();
        boolean esc = (tflags & 0x100) == 0;
        for (int i = 0; i < ls; ++i) {
            char c = str.charAt(i);
            if (c == '\"') {
                ++nq;
                iq = 1 - iq;
                continue;
            }
            if (c == '\\') {
                ++nbs;
                continue;
            }
            if (c == ',' && iq == 0 && ip == 0 && ic == 0) {
                ++nc;
                continue;
            }
            if (c == '(' && iq == 0) {
                ++ip;
                continue;
            }
            if (c == ')' && iq == 0) {
                --ip;
                continue;
            }
            if (c == '{' && iq == 0) {
                ++ic;
                continue;
            }
            if (c == '}' && iq == 0) {
                --ic;
                continue;
            }
            if (c >= ' ' && c <= '~') continue;
            ++nesc;
        }
        if (nq > 0 && nbs == 0 && nc == 0 && nesc == 0) {
            sb.append(str);
        } else if (nbs + nesc > 0 && esc) {
            sb.append('\"').append(StringUtil.escapeString(str)).append('\"');
        } else {
            sb.append('\"').append(str).append('\"');
        }
    }

    public String toStringAbbr() {
        String str = this.toString();
        if (str.length() < 20) {
            return str;
        }
        return str.substring(0, 20) + "...}";
    }

    public final void fromBytes(byte[] bytes) {
        if (this.genericMode == 1) {
            this.fb = bytes;
        } else {
            this.clear();
            this.fromBytes(bytes, 0, bytes.length);
        }
    }

    public final void append(String string) {
        byte[] bytes = string.getBytes();
        this.fromBytes(bytes, 0, bytes.length);
    }

    public final int fromBytes(byte[] bytes, int index1, int index2) {
        int i;
        boolean onlyJavaNumericSerialization;
        int n = index2;
        boolean escSeqEnabled = (this.flags & 0x100) == 0;
        boolean checkMalformed = (this.flags & 0x400) != 0;
        boolean consistentHandlingWhiteSpace = (this.flags & 0x40000) == 0;
        boolean bl = onlyJavaNumericSerialization = (this.flags & 0x80000) != 0;
        for (i = index1; i < n - 1 && bytes[i] <= 32; ++i) {
        }
        while (i < n - 1 && bytes[n - 1] <= 32) {
            --n;
        }
        boolean curlyTable = false;
        int length = n - i;
        if (length < 2) {
            return -1;
        }
        if (bytes[i] == 123 && bytes[n - 1] == 125) {
            curlyTable = true;
        } else if (bytes[i] != 40 || bytes[n - 1] != 41) {
            StringBuilder errmsg = new StringBuilder("Malformed Table (");
            if (bytes[i] != 123) {
                errmsg.append(" missing open '{' ,");
            }
            if (bytes[n - 1] != 125) {
                errmsg.append(" missing close '}'");
            }
            int limitedLen = Math.min(length, 1000);
            errmsg.append(" ) in table: ").append(new String(bytes, i, limitedLen));
            if (limitedLen < length) {
                errmsg.append(" [...truncated ").append(length - limitedLen).append(" bytes after 1000 limit...]");
            }
            if (checkMalformed) {
                throw new MidasException(errmsg.toString());
            }
            Shell.warning(errmsg);
            return -1;
        }
        while (i < n - 1 && bytes[i + 1] <= 32) {
            ++i;
        }
        while (i < n - 1 && bytes[n - 2] <= 32) {
            --n;
        }
        ++i;
        --n;
        while (i < n) {
            String res;
            int len;
            int k;
            if (consistentHandlingWhiteSpace) {
                while (i < n && bytes[i] <= 32) {
                    ++i;
                }
                while (i < n && bytes[i] == 125) {
                    for (k = i + 1; k < n && bytes[k] <= 32; ++k) {
                    }
                    if (k < n && bytes[k] == 123) {
                        for (i = k + 1; i < n && bytes[i] <= 32; ++i) {
                        }
                        continue;
                    }
                    break;
                }
            } else {
                while (i < n && bytes[i] == 32) {
                    ++i;
                }
                while (i < n && bytes[i] == 125) {
                    for (k = i + 1; k < n && bytes[k] == 32; ++k) {
                    }
                    if (k < n && bytes[k] == 123) {
                        for (i = k + 1; i < n && bytes[i] == 32; ++i) {
                        }
                        continue;
                    }
                    break;
                }
            }
            int ik1 = i;
            int ik2 = i;
            int iv1 = ik2 + 1;
            int nEq = 0;
            boolean inEscSeq = false;
            boolean beforeEquals = true;
            int ibr = 0;
            int iqu = 0;
            int iparen = 0;
            while (i < n && (iparen > 0 || ibr > 0 || iqu > 0 || bytes[i] != 44)) {
                boolean inKeySection = curlyTable && beforeEquals;
                byte ibyte = bytes[i];
                if (!(ibyte != 34 || escSeqEnabled && inEscSeq)) {
                    iqu = 1 - iqu;
                    inEscSeq = false;
                } else if (iqu != 0) {
                    inEscSeq = escSeqEnabled && !inEscSeq && ibyte == 92;
                } else if (ibyte == 123) {
                    beforeEquals = true;
                    ++ibr;
                } else if (ibyte == 125) {
                    --ibr;
                } else if (ibyte == 40) {
                    if (!inKeySection || doNotAllowRandomParen) {
                        ++ibr;
                    } else {
                        ++iparen;
                    }
                } else if (ibyte == 41) {
                    if (!inKeySection || doNotAllowRandomParen) {
                        --ibr;
                    } else {
                        --iparen;
                    }
                } else if (ibyte == 61 && ibr == 0) {
                    beforeEquals = false;
                    if (++nEq == 1) {
                        ik2 = i;
                        iv1 = ik2 + 1;
                        if (consistentHandlingWhiteSpace) {
                            while (bytes[iv1] <= 32) {
                                ++iv1;
                                ++i;
                            }
                        }
                    }
                }
                if (ibr < 0) break;
                ++i;
            }
            if (i <= ik1) break;
            if (nEq == 0) {
                ik2 = i;
            }
            int iv2 = i;
            while (bytes[ik2 - 1] <= 32) {
                --ik2;
            }
            if (bytes[ik1] == 34) {
                ++ik1;
                --ik2;
            }
            if (consistentHandlingWhiteSpace) {
                while (bytes[iv2 - 1] <= 32) {
                    --iv2;
                }
            }
            if (nEq > 1) {
                // empty if block
            }
            char type = '_';
            if (bytes[ik1 + 1] == 58) {
                type = (char)bytes[ik1];
                ik1 += 2;
            }
            String key = Convert.unpackS(bytes, ik1, ik2 - ik1);
            if ((this.flags & 0x40) == 0) {
                key = key.toUpperCase();
            }
            if ((len = iv2 - iv1) <= 0) {
                this.put(key, (Object)"");
            } else if (bytes[iv1] == 34) {
                if (bytes[iv2 - 1] != 34) {
                    String msg = "Malformed Table (improperly quoted) in table: " + new String(bytes, iv1, len);
                    if (checkMalformed) {
                        throw new MidasException(msg);
                    }
                    Shell.warning(msg);
                }
                res = new String(bytes, iv1 + 1, len - 2);
                if (escSeqEnabled) {
                    res = StringUtil.unescapeString(res);
                }
                this.put(key, (Object)res);
            } else if (bytes[iv1] == 123) {
                Table sub = new Table(this.specificMode, this.flags);
                if (this.caretEnabled) {
                    sub.setPrevious(this);
                }
                sub.fromBytes(bytes, iv1, iv2);
                if (this.caretEnabled) {
                    sub.setPrevious(null);
                }
                this.put(key, (Object)sub);
            } else if (this.caretEnabled && bytes[iv1] == 94) {
                String fkey = new String(bytes, iv1 + 1, len - 1);
                Table root = this.getRoot();
                Object rval = KeyObject.getKey(root, fkey);
                if (rval != null) {
                    this.put(key, rval);
                } else {
                    this.put(key, (Object)("^" + fkey));
                }
            } else if (len > 2 && bytes[iv1 + 1] == 58) {
                Number num;
                res = new String(bytes, iv1 + 2, len - 2);
                char newType = (char)bytes[iv1];
                char checkNumberType = onlyJavaNumericSerialization ? Character.toLowerCase(newType) : newType;
                switch (checkNumberType) {
                    case 'd': {
                        num = Double.valueOf(res);
                        break;
                    }
                    case 'f': {
                        num = Float.valueOf(res);
                        break;
                    }
                    case 'x': {
                        num = Long.valueOf(res);
                        break;
                    }
                    case 'l': {
                        num = Integer.valueOf(res);
                        break;
                    }
                    case 'i': {
                        num = Short.valueOf(res);
                        break;
                    }
                    case 'b': {
                        num = Byte.valueOf(res);
                        break;
                    }
                    case 'n': {
                        num = new BigDecimal(res);
                        break;
                    }
                    default: {
                        num = null;
                    }
                }
                if (num != null) {
                    this.put(key, (Object)num, null);
                } else {
                    this.put(key, Convert.s2o(res, newType, null));
                }
            } else {
                res = new String(bytes, iv1, len);
                this.put(key, Convert.s2o(res, type, null));
            }
            if (ibr < 0 && i < n && bytes[i + 1] == 123) {
                ++i;
            }
            while (i < n && bytes[++i] == 32) {
            }
        }
        return 0;
    }

    @InternalUseOnly
    public void modifyKeys(String regexToReplace, String replacement) {
        int i;
        if (regexToReplace == null || replacement == null) {
            return;
        }
        boolean replacementContainsDots = replacement.contains(".");
        boolean regexIsDot = "\\.".equals(regexToReplace);
        if (replacementContainsDots) {
            this.flags |= 0x200000;
        }
        String[] origKeys = this.getKeys();
        String[] newKeys = new String[origKeys.length];
        Object[] newVals = new Object[origKeys.length];
        for (i = 0; i < origKeys.length; ++i) {
            String origKey = origKeys[i];
            Object origVal = this.getKey(origKey);
            if (origVal instanceof Table) {
                Table origValTbl = (Table)origVal;
                origValTbl.setFlags(this.getFlagsInt());
                origValTbl.modifyKeys(regexToReplace, replacement);
            }
            newKeys[i] = origKey.replaceAll(regexToReplace, replacement);
            newVals[i] = origVal;
        }
        this.clear();
        for (i = 0; i < newKeys.length; ++i) {
            this.putx(newKeys[i], newVals[i]);
        }
        if (regexIsDot && !replacementContainsDots) {
            this.setFlags("-AllowDotsInKeys");
        }
    }

    @InternalUseOnly
    public void hasDotsInKeys(String tblName) {
        boolean dotsInKeys = this.hasDotsInKeys();
        if (dotsInKeys) {
            Shell.warning("CONVERT XML2TAB was converting XML that had dots in key name. To avoid crashing,\n      a table was created in a special limited function mode that allows dots in keys.\n      Replace the '.' characters before serializing this table.\n      " + tblName + " = " + this);
        }
    }

    private boolean hasDotsInKeys() {
        String[] tblKeys;
        for (String key : tblKeys = this.getKeys()) {
            Table tblVal;
            boolean hasDottedKeys;
            if (key.contains(".")) {
                return true;
            }
            Object objVal = this.getKey(key);
            if (!(objVal instanceof Table) || !(hasDottedKeys = (tblVal = (Table)objVal).hasDotsInKeys())) continue;
            return hasDottedKeys;
        }
        return false;
    }

    @Deprecated
    public void fromTable(Hashtable<?, ?> table) {
        this.clear();
        this.setMode(3);
        this.putAll(table);
    }

    public final void fromTextFile(TextFile tf) {
        int saveFlags = this.flags;
        this.setMode(2);
        this.fromTextFile(tf, this.flags | 4);
        this.setFlags(saveFlags);
    }

    public final void fromTextFile(TextFile tf, int flags) {
        String line;
        int lastchar = 44;
        StringBuilder sb = new StringBuilder(4096);
        sb.append('{');
        this.setFlags(flags);
        tf.open(8193);
        while ((line = tf.readProper()) != null) {
            if ((line = line.trim()).charAt(0) != '}' && line.charAt(0) != '{' && lastchar != 123 && lastchar != 44) {
                sb.append(',');
            }
            sb.append(line);
            lastchar = line.charAt(line.length() - 1);
        }
        tf.close();
        sb.append('}');
        String str = sb.toString();
        if (str.startsWith("{{") && str.endsWith("}}")) {
            str = str.substring(1, str.length() - 1);
        }
        this.fromBytes(str.getBytes());
    }

    public void toTextFile(TextFile tf) {
        tf.open(8194);
        Table.toTextFile(tf, this, "");
        tf.close();
    }

    @InternalUseOnly(value="Used by PANEL when writing .mmp files")
    public static void toTextFile(TextFile tf, Table t, String pad) {
        Iterator ti = t.iterator();
        for (int i = 0; i < ti.size; ++i) {
            String key = ti.keys[i];
            Object value = ti.values[i];
            if (value instanceof Table) {
                tf.writeln(pad + key + "={");
                Table.toTextFile(tf, (Table)value, pad + "  ");
                tf.writeln(pad + "}");
                continue;
            }
            StringBuffer sb = new StringBuffer();
            Table.toStringBuffer(value, sb, t.flags);
            tf.writeln(pad + key + "=" + sb);
        }
    }

    public Data getData(String key) {
        Object entry = this.get(key);
        if (entry == null) {
            return null;
        }
        if (entry instanceof String) {
            entry = new Data((String)entry);
        }
        return (Data)entry;
    }

    public final Table getTable(String key) {
        return this.getTable(key, false);
    }

    public Table getTable(String key, boolean converto2t) {
        Object entry = this.get(key);
        if (entry instanceof Table) {
            return (Table)entry;
        }
        if (converto2t) {
            return Convert.o2t(entry);
        }
        return null;
    }

    public Table getTable(String key, Table defValue) {
        Object entry = this.get(key, defValue, this.flags | 0x200);
        if (entry instanceof Table) {
            return (Table)entry;
        }
        return defValue;
    }

    public final Table getTableOrNull(String key) {
        return this.getTable(key, null);
    }

    public String getString(String key) {
        Object entry = this.get(key);
        if (entry instanceof String) {
            return (String)entry;
        }
        return null;
    }

    public String getString(String key, String defValue) {
        Object entry = this.get(key, defValue, this.flags | 0x200);
        if (entry instanceof String) {
            return (String)entry;
        }
        return null;
    }

    public DataFile getDataFile(String key) {
        Object entry = this.get(key);
        if (entry instanceof DataFile) {
            return (DataFile)entry;
        }
        return null;
    }

    public final String getUniqueKey(String key) {
        return this.getUniqueKey(key, "");
    }

    public String getUniqueKey(String key, String delim) {
        String keyi = key;
        int i = 1;
        while (this.containsKey(keyi)) {
            keyi = key + delim + i;
            ++i;
        }
        return keyi;
    }

    public void rename(String oldName, String newName) {
        this.checkModeFB();
        if (this.genericMode == 2) {
            this.kv.rename(oldName, newName);
        } else if (this.genericMode == 10) {
            Object val = this.kbl.getKey(oldName);
            if (val != null) {
                this.kbl.setKey(newName, val);
            }
        } else if (this.genericMode == 9) {
            Object val = this.map.remove(oldName);
            if (val != null) {
                this.map.put(newName, val);
            }
        } else {
            throw new AssertionError((Object)("Unknown table mode " + this.genericMode));
        }
    }

    @Override
    public final String getS(String key) {
        return this.getS(key, null);
    }

    @Override
    public final double getD(String key) {
        return this.getD(key, 0.0);
    }

    @Override
    public final float getF(String key) {
        return this.getF(key, 0.0f);
    }

    @Override
    public final long getX(String key) {
        return this.getX(key, 0L);
    }

    @Override
    public final int getL(String key) {
        return this.getL(key, 0);
    }

    @Override
    public final short getI(String key) {
        return this.getI(key, (short)0);
    }

    @Override
    public final byte getB(String key) {
        return this.getB(key, (byte)0);
    }

    @Override
    public final Object getO(String key) {
        return this.getO(key, null);
    }

    @Override
    public final boolean getState(String key) {
        return this.getState(key, false);
    }

    @Override
    public final boolean getNoState(String key) {
        return this.getNoState(key, false);
    }

    @Override
    public final String getS(String key, String def) {
        Object entry = this.get(key);
        return entry == null ? def : Convert.o2s(entry);
    }

    @Override
    public final double getD(String key, double def) {
        Object entry = this.get(key);
        return entry == null ? def : Convert.o2d(entry);
    }

    @Override
    public final float getF(String key, float def) {
        Object entry = this.get(key);
        return entry == null ? def : Convert.o2f(entry);
    }

    @Override
    public final long getX(String key, long def) {
        Object entry = this.get(key);
        return entry == null ? def : Convert.o2x(entry);
    }

    @Override
    public final int getL(String key, int def) {
        Object entry = this.get(key);
        return entry == null ? def : Convert.o2l(entry);
    }

    @Override
    public final short getI(String key, short def) {
        Object entry = this.get(key);
        return entry == null ? def : Convert.o2i(entry);
    }

    @Override
    public final byte getB(String key, byte def) {
        Object entry = this.get(key);
        return entry == null ? def : Convert.o2b(entry);
    }

    @Override
    public final Object getO(String key, Object def) {
        Object entry = this.get(key);
        return entry == null ? def : entry;
    }

    @Override
    public boolean getState(String key, boolean def) {
        String str = this.getS(key, null);
        if (str == null) {
            return def;
        }
        if (StringUtil.isTrue(str)) {
            return true;
        }
        if (StringUtil.isFalse(str)) {
            return false;
        }
        return this.getD(key) > 0.0;
    }

    @Override
    public final boolean getNoState(String key, boolean def) {
        return !this.getState(key, !def);
    }

    public List<?> getList(String key) {
        return Convert.o2List(this.getO(key));
    }

    @Override
    public void put(String key, double value) {
        if ((this.flags & 0x10000) != 0) {
            this.put(key, (Object)value);
        } else {
            this.put(key, Convert.d2o(value));
        }
    }

    @Override
    public void put(String key, float value) {
        if ((this.flags & 0x10000) != 0) {
            this.put(key, (Object)Float.valueOf(value));
        } else {
            this.put(key, Convert.f2o(value));
        }
    }

    @Override
    public void put(String key, long value) {
        if ((this.flags & 0x10000) != 0) {
            this.put(key, (Object)value);
        } else {
            this.put(key, Convert.x2o(value));
        }
    }

    @Override
    public void put(String key, int value) {
        if ((this.flags & 0x10000) != 0) {
            this.put(key, (Object)value);
        } else {
            this.put(key, Convert.l2o(value));
        }
    }

    @Override
    public void put(String key, short value) {
        if ((this.flags & 0x10000) != 0) {
            this.put(key, (Object)value);
        } else {
            this.put(key, Convert.i2o(value));
        }
    }

    @Override
    public void put(String key, byte value) {
        if ((this.flags & 0x10000) != 0) {
            this.put(key, (Object)value);
        } else {
            this.put(key, Convert.b2o(value));
        }
    }

    @Override
    public void put(String key, boolean value) {
        this.put(key, (Object)(value ? Boolean.TRUE : Boolean.FALSE));
    }

    public Table getRoot() {
        Table tbl = this;
        while (tbl.prev != null) {
            tbl = tbl.prev;
        }
        return tbl;
    }

    public void setPrevious(Table prevTable) {
        if (this.prev != null && prevTable != null && prevTable != this.prev) {
            Shell.warning("Table.setPrevious overwriting existing previous link");
        }
        this.prev = prevTable;
    }

    public Table getPrevious() {
        return this.prev;
    }

    public static void setDefaultFlags(int mask) {
        if ((mask & 0x8080) == 32896) {
            throw new IllegalArgumentException("Illegal default flags mask (contains both PERMIT_NULL and EXCEPTION_ON_NULL):" + Integer.toHexString(mask));
        }
        defaultFlags = mask;
    }

    public static final void setDefaultFlags(String mask) {
        Table.setDefaultFlags(Parser.mask(flagsList, mask, Table.getDefaultFlagsInt()));
    }

    public static int getDefaultFlagsInt() {
        return defaultFlags;
    }

    public static final String getDefaultFlags() {
        return Parser.mask2s(flagsList, Table.getDefaultFlagsInt());
    }

    public void setFlags(int mask) {
        if ((mask & 0x8080) == 32896) {
            throw new IllegalArgumentException("Illegal flags mask (contains both PERMIT_NULL and EXCEPTION_ON_NULL):" + Integer.toHexString(mask));
        }
        this.flags = mask;
        if ((this.flags & 4) != 0) {
            this.setMode(2);
        }
    }

    public final void setFlags(String mask) {
        this.setFlags(Parser.mask(flagsList, mask, this.getFlagsInt()));
    }

    public int getFlagsInt() {
        return this.flags;
    }

    public final String getFlags() {
        return Parser.mask2s(flagsList, this.getFlagsInt());
    }

    public static void setDoNotAllowRandomParen(boolean doNotAllowRandomParen) {
        Table.doNotAllowRandomParen = doNotAllowRandomParen;
    }

    public void addListener(Listener listener) {
        if (this.listener != null && this.listener != listener) {
            throw new MidasException("Table currently only supports one listener");
        }
        this.listener = listener;
    }

    public void removeListener(Listener listener) {
        if (listener == this.listener) {
            this.listener = null;
        }
    }

    public Enumeration<String> keys() {
        return new Enum(this);
    }

    @Deprecated
    public Hashtable<String, Object> getHashtable() {
        this.setMode(3);
        return (Hashtable)this.map;
    }

    public Table getInverse() {
        Table t = new Table(this.specificMode, this.flags);
        Iterator ti = this.iterator();
        for (int i = 0; i < ti.size; ++i) {
            t.put(ti.values[i].toString(), (Object)ti.keys[i]);
        }
        return t;
    }

    public void merge(Keyable keyable) {
        block13: {
            block14: {
                Table newTbl;
                block12: {
                    KeyVector newKV = null;
                    newTbl = null;
                    if (keyable instanceof Table) {
                        newTbl = (Table)keyable;
                        newKV = newTbl.kv;
                    } else if (keyable instanceof KeyVector) {
                        newKV = (KeyVector)keyable;
                    }
                    if (newKV == null) break block12;
                    if (newKV.size() == 0) break block13;
                    if (this.getSize() == 0 && this.getModeInt() == 2) {
                        this.kv = newKV.copy();
                    } else {
                        for (int i = 0; i < newKV.size(); ++i) {
                            this.putx(newKV.getKey(i), newKV.get(i));
                        }
                    }
                    break block13;
                }
                if (newTbl == null) break block14;
                if (newTbl.isEmpty()) break block13;
                if (newTbl.fb != null) {
                    if (this.getModeInt() == 1 && this.fb == null) {
                        this.fb = (byte[])newTbl.fb.clone();
                    } else {
                        this.fromBytes(newTbl.fb, 0, newTbl.fb.length);
                    }
                } else {
                    Iterator iter = newTbl.iterator();
                    for (int i = 0; i < iter.keys.length; ++i) {
                        this.putx(iter.keys[i], iter.values[i]);
                    }
                }
                break block13;
            }
            for (String key : keyable.getKeys()) {
                this.putx(key, keyable.getKey(key));
            }
        }
    }

    public synchronized void sortByKey(boolean reverse) {
        if (this.genericMode != 2) {
            this.setMode(2);
        }
        this.kv.sortByKey(reverse);
    }

    public synchronized Table copy() {
        return Table.copyOf(this, this.specificMode);
    }

    @Override
    public final Table toTable() {
        return this.copy();
    }

    public static Table copyOf(Keyable keyable) {
        return Table.copyOf(keyable, 2);
    }

    public static Table merge(Table t1, Table t2, boolean recurse) {
        Table tout = t1.copy();
        if (!recurse) {
            tout.merge(t2);
            return tout;
        }
        for (String key : t2.getKeys()) {
            Object val1;
            Object val2 = t2.get(key);
            if (val2 instanceof Table && (val1 = tout.get(key)) instanceof Table) {
                val2 = Table.merge((Table)val1, (Table)val2, true);
            }
            tout.put(key, val2);
        }
        return tout;
    }

    public static Table copyOf(Keyable keyable, int mode) {
        Table tbl = new Table(mode);
        tbl.merge(keyable);
        return tbl;
    }

    static Table wrap(KeyVector kv) {
        Table tbl = new Table(2);
        tbl.kv = kv;
        return tbl;
    }

    public static Table fromTableFile(MidasReference ref, Object fileName) {
        Table t = new Table();
        t.fromTextFile(new TextFile(ref, fileName));
        return t;
    }

    public static Table fromConfigFile(MidasReference ref, Object fileName) {
        return Table.fromConfigFile(ref, fileName, false, false);
    }

    public static Table fromConfigFile(MidasReference ref, Object fileName, boolean cs, boolean merge) {
        TextFile inFile = new TextFile(ref, fileName);
        inFile.open(8192);
        String[] allLines = inFile.readAllLines();
        inFile.close();
        return Table.fromConfigFile(allLines, cs, merge);
    }

    public static Table fromConfigFile(String[] allLines, boolean cs, boolean merge) {
        Table tbl = new Table();
        Table defs = null;
        Table section = null;
        for (int lineNum = 0; lineNum < allLines.length; ++lineNum) {
            int i;
            String line = allLines[lineNum].trim();
            if (line.startsWith("#") || line.startsWith(";")) {
                line = "";
            }
            if ((i = line.indexOf(" ;")) > 0) {
                line = line.substring(0, i).trim();
            }
            if (line.length() == 0) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                String name = line.substring(1, line.length() - 1).trim().toUpperCase();
                section = new Table();
                if (name.length() == 0) {
                    throw new MidasException("Syntax error near line " + lineNum);
                }
                if (name.equals("DEFAULT")) {
                    defs = section;
                }
                tbl.put(name, (Object)section);
                continue;
            }
            if (section == null) {
                throw new MidasException("Syntax error near line " + lineNum);
            }
            int eq = line.indexOf(61);
            if (eq < 0) {
                throw new MidasException("Syntax error near line " + lineNum);
            }
            String key = line.substring(0, eq).trim();
            String val = line.substring(eq + 1).trim();
            if (!cs) {
                key = key.toUpperCase();
            }
            section.put(key, (Object)val);
        }
        if (merge && defs != null) {
            for (String key : tbl.getKeys()) {
                if (key.equals("DEFAULT")) continue;
                tbl.put(key, (Object)Table.merge(defs, tbl.getTable(key), false));
            }
        }
        return tbl;
    }

    public static Table fromOpalFile(MidasReference ref, Object filename, boolean keepCase) {
        return Table.fromOpalFile(TextFile.readAllLines(ref, filename), keepCase);
    }

    public static Table fromOpalFile(String[] lines, boolean keepCase) {
        ArrayList<String> tokens = new ArrayList<String>();
        block0: for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
            String line = lines[lineNum].trim();
            Parser p = new Parser(line, true);
            for (int i = 1; i <= p.elements(); ++i) {
                String elem = p.get(i);
                if (elem.startsWith("{") && elem.length() > 1) {
                    tokens.add("{");
                    elem = elem.substring(1).trim();
                }
                if (elem.startsWith("//")) continue block0;
                if (elem.startsWith("=")) {
                    tokens.add("=");
                    elem = elem.substring(1);
                }
                Parser pp = new Parser(elem);
                pp.setDelimiter('=');
                pp.clean();
                if (pp.elements() == 1) {
                    tokens.add(elem);
                    continue;
                }
                for (int j = 1; j <= pp.elements(); ++j) {
                    if (j > 1) {
                        tokens.add("=");
                    }
                    tokens.add(pp.get(j));
                }
            }
        }
        int first = 0;
        int last = tokens.size();
        if (((String)tokens.get(first)).equals("{") && ((String)tokens.get(last - 1)).equals("}")) {
            ++first;
            --last;
        }
        Table tbl = new Table();
        LinkedList<Table> stack = new LinkedList<Table>();
        stack.push(tbl);
        int i = first;
        while (i < last) {
            String token;
            if ((token = (String)tokens.get(i++)).equals("}")) {
                stack.pop();
                continue;
            }
            String key = StringUtil.stripQuotes(token);
            String equals = (String)tokens.get(i++);
            String val = (String)tokens.get(i++);
            Table tab = (Table)stack.peek();
            if (!keepCase) {
                key = key.toUpperCase();
            }
            if (!equals.equals("=")) {
                throw new MidasException("Invalid OPAL table, missing '=' near " + key);
            }
            if (val.equals("{")) {
                Table t = new Table();
                stack.push(t);
                tab.put(key, (Object)t);
                continue;
            }
            if (val.startsWith("@")) {
                String ref = StringUtil.stripQuotes(val.substring(1));
                if (!keepCase) {
                    ref = ref.toUpperCase();
                }
                tab.put(key, tab.get(ref));
                continue;
            }
            if (val.startsWith("\"") && val.endsWith("\"")) {
                tab.put(key, (Object)StringUtil.stripQuotes(val));
                continue;
            }
            if (val.length() > 2 && val.charAt(1) == ':') {
                char type = val.charAt(0);
                tab.put(key, Convert.o2o((Object)val.substring(2), type, null));
                continue;
            }
            tab.put(key, (Object)val);
        }
        return tbl;
    }

    public void fromJSON(CharSequence json) {
        this.fromJSON(json, null);
    }

    public void fromJSON(CharSequence json, CharSequence subForDots) {
        boolean subNotNull = subForDots != null;
        boolean subNotHaveDots = subNotNull && !subForDots.toString().contains(".");
        String subDotString = subNotNull ? subForDots.toString() : null;
        Object val = JsonUtilities.fromJSON(json);
        this.clear();
        this.putAllAsPureTable((Map)val, subDotString, subNotHaveDots);
    }

    public List<String> toConfigFile() {
        LinkedList<String> outFile = new LinkedList<String>();
        if (this.containsKey("DEFAULT")) {
            this.addSectionToConfigFile(outFile, "DEFAULT", this.getTable("DEFAULT"));
        }
        for (String sectionName : this.getKeys()) {
            if (sectionName.equals("DEFAULT")) continue;
            this.addSectionToConfigFile(outFile, sectionName, this.getTable(sectionName));
        }
        return outFile;
    }

    private void addSectionToConfigFile(List<String> outFile, String name, Table tbl) {
        if (tbl == null) {
            throw new MidasException("Invalid input table. Expected " + name + " to be a sub-table.");
        }
        outFile.add("[" + name + "]");
        for (String key : tbl.getKeys()) {
            outFile.add(key + "=" + tbl.getS(key));
        }
        outFile.add("");
    }

    public synchronized Iterator iterator() {
        return new Iterator(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.toString());
        out.writeObject(this.flags);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException, ClassCastException {
        String data = (String)in.readObject();
        this.flags = (Integer)in.readObject();
        this.fromBytes(data.getBytes());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(key.toString());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        String[] keys = this.getKeys();
        final Map.Entry[] entries = new Entry[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            entries[i] = new Entry(this, keys[i]);
        }
        return new SimpleSet<Map.Entry<String, Object>>(this){

            @Override
            public int size() {
                return entries.length;
            }

            @Override
            public Map.Entry<String, Object> getItem(int i) {
                return entries[i];
            }

            @Override
            public Object removeItem(int i) {
                return this.table.remove((String)entries[i].getKey());
            }
        };
    }

    @Override
    public Set<String> keySet() {
        final String[] keys = this.getKeys();
        return new SimpleSet<String>(this){

            @Override
            public int size() {
                return keys.length;
            }

            @Override
            public String getItem(int i) {
                return keys[i];
            }

            @Override
            public Object removeItem(int i) {
                return this.table.remove(keys[i]);
            }
        };
    }

    @Override
    public void putAll(Map map) {
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            this.putx(entry.getKey().toString(), entry.getValue());
        }
    }

    void putAllAsPureTable(Map map, String subForDot, boolean replacingDotsInKeys) {
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object val;
            String key = entry.getKey().toString();
            if (key.contains(".")) {
                if (replacingDotsInKeys) {
                    key = key.replaceAll("\\.", subForDot);
                } else if ((this.flags & 0x200000) == 0) {
                    throw new MidasException("Copying Map entries into Table failed. Invalid Map key:" + key + " contains '.'");
                }
            }
            if ((val = entry.getValue()) instanceof Map) {
                Table tab = new Table(this.specificMode, this.flags);
                tab.putAllAsPureTable((Map)val, subForDot, replacingDotsInKeys);
                this.putx(key, tab);
                continue;
            }
            this.putx(key, entry.getValue());
        }
    }

    @Override
    public Collection<Object> values() {
        final String[] keys = this.getKeys();
        return new SimpleSet<Object>(this){

            @Override
            public int size() {
                return keys.length;
            }

            @Override
            public Object getItem(int i) {
                return this.table.get(keys[i]);
            }

            @Override
            public Object removeItem(int i) {
                return this.table.remove(keys[i]);
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Table t1 = this;
        Map t2 = (Map)obj;
        return t1.entrySet().equals(t2.entrySet());
    }

    @Override
    public int hashCode() {
        java.util.Iterator<Map.Entry<String, Object>> entries = this.entrySet().iterator();
        int hashcode = 0;
        while (entries.hasNext()) {
            hashcode += entries.next().hashCode();
        }
        return hashcode;
    }

    @Override
    public final Object get(Object key) throws NullPointerException {
        if (key == null) {
            return null;
        }
        return this.get(key.toString());
    }

    @Override
    public final Object remove(Object key) throws NullPointerException {
        if (key == null) {
            return null;
        }
        return this.remove(key.toString());
    }

    static {
        saveStateKeyDotSubstitute = SAVESTATE_KEY_DOT_SUBSTITUTE = "<DOT>";
        doNotAllowRandomParen = false;
    }

    public static final class Entry
    implements Map.Entry<String, Object> {
        private final Table table;
        private final String key;

        private Entry(Table table, String key) {
            this.table = table;
            this.key = key;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Entry e1 = this;
            Map.Entry e2 = (Map.Entry)obj;
            return (e1.getKey() == null ? e2.getKey() == null : e1.getKey().equals(e2.getKey())) && (e1.getValue() == null ? e2.getValue() == null : e1.getValue().equals(e2.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.table.get(this.key);
        }

        @Override
        public Object setValue(Object value) {
            return this.table.put(this.key, value);
        }
    }

    private abstract class SimpleSet<E>
    extends AbstractSet<E> {
        protected final Table table;

        private SimpleSet(Table table2) {
            this.table = table2;
        }

        public abstract E getItem(int var1);

        public abstract Object removeItem(int var1);

        @Override
        public java.util.Iterator<E> iterator() {
            return new java.util.Iterator<E>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < SimpleSet.this.size();
                }

                @Override
                public E next() {
                    ++this.i;
                    return SimpleSet.this.getItem(this.i - 1);
                }

                @Override
                public void remove() {
                    SimpleSet.this.removeItem(this.i - 1);
                }
            };
        }
    }

    @InternalUseOnly(value="Used by Macro and Results")
    public static interface Function {
        public void set(Object var1);

        public Object get();

        public Object exec(Object var1);
    }

    public static interface Listener {
        public boolean putAction(String var1, Object var2);

        public boolean getAction(String var1, Object var2);
    }

    @InternalUseOnly(value="This class is not intended to be extended or instantiated directly")
    public class Iterator
    implements java.util.Iterator<String>,
    Iterable<String> {
        public Table table;
        public String[] keys;
        public Object[] values;
        public int offset;
        public int size;
        public String key;
        public Object value;

        protected Iterator(Table table, String[] keys, Object[] values) {
            this.table = table;
            this.keys = keys;
            this.values = values;
            this.offset = 0;
            this.size = keys.length;
            if (values == null) {
                this.values = new Object[keys.length];
                for (int i = 0; i < this.size; ++i) {
                    this.values[i] = table.getKey(keys[i]);
                }
            }
        }

        @Deprecated
        public Iterator(Table table) {
            this.table = table;
            table.checkModeFB();
            this.size = table.size();
            this.keys = new String[this.size];
            this.values = new Object[this.size];
            if (table.genericMode == 9) {
                java.util.Iterator iter = table.map.entrySet().iterator();
                for (int i = 0; i < this.size; ++i) {
                    Map.Entry e = iter.next();
                    this.keys[i] = (String)e.getKey();
                    this.values[i] = e.getValue();
                }
            } else if (table.genericMode == 2) {
                for (int i = 0; i < this.size; ++i) {
                    this.keys[i] = table.kv.getKey(i);
                    this.values[i] = table.kv.get(i);
                }
            } else if (table.genericMode == 10) {
                this.keys = table.kbl.getKeys();
                for (int i = 0; i < this.keys.length; ++i) {
                    this.values[i] = table.kbl.getKey(this.keys[i]);
                }
            }
            this.offset = 0;
        }

        @Override
        public boolean hasNext() {
            return this.offset < this.size;
        }

        public boolean getNext() {
            if (this.offset >= this.size) {
                return false;
            }
            this.next();
            return true;
        }

        @Override
        public String next() {
            this.key = this.keys[this.offset];
            this.value = this.values[this.offset];
            ++this.offset;
            return this.key;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public void remove() {
            this.table.remove(this.key);
        }

        @Override
        public java.util.Iterator<String> iterator() {
            return this;
        }

        public void reset() {
            this.offset = 0;
        }
    }

    @Deprecated
    public class Enum
    implements Enumeration<String> {
        private java.util.Iterator<String> iter;
        private KeyVector kv;
        private String[] keys;
        private int item;

        public Enum(Table table) {
            table.checkModeFB();
            switch (table.genericMode) {
                case 2: {
                    this.kv = table.kv;
                    break;
                }
                case 9: {
                    this.iter = table.map.keySet().iterator();
                    break;
                }
                case 10: {
                    this.keys = table.kbl.getKeys();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown table mode " + Table.this.genericMode));
                }
            }
        }

        @Override
        public boolean hasMoreElements() {
            if (this.iter != null) {
                return this.iter.hasNext();
            }
            if (this.kv != null) {
                return this.item < this.kv.size();
            }
            return this.item < this.keys.length;
        }

        @Override
        public String nextElement() {
            if (this.iter != null) {
                return this.iter.next();
            }
            if (this.kv != null) {
                return this.kv.getKey(this.item++);
            }
            return this.keys[this.item++];
        }
    }
}

