/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import nxm.sys.inc.CommandParent;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.inc.ShellParent;
import nxm.sys.lib.Args;
import nxm.sys.lib.Command;
import nxm.sys.lib.CommandLine;
import nxm.sys.lib.Convert;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.Foreign;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.Macro;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.MidasThread;
import nxm.sys.lib.NTerminal;
import nxm.sys.lib.Native;
import nxm.sys.lib.OptionTree;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Registry;
import nxm.sys.lib.Results;
import nxm.sys.lib.Stack;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Terminal;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Theme;
import nxm.sys.lib.Time;
import nxm.sys.lib.Webstart;

public class Shell
implements Runnable,
MidasReference {
    private static final int RUN_TO_COMPLETION = 1;
    private static final int RUN_DEFAULT = 0;
    private static final String cmdRunModeList = "RunToCompletion";
    private static final String CLASS_RESOURCE_NAME = "nxm/sys/lib/Shell.class";
    public static final String PROMPT_STRING = "nM";
    public static final String PROMPT_STRING_PIPE = "-Pipe";
    public static final String PROMPT_STRING_SUSPEND = "-Suspend";
    private static final String JAVADOC_PATH = Shell.getNmRoot() + "htdocs" + File.separator + "api" + File.separator;
    @InternalUseOnly(value="Only meant for read only access")
    public Midas M = new Midas();
    public ShellParent parent;
    private String cmdline = null;
    private boolean configured = false;
    private Command command;
    private int commands;
    private Stack history = new Stack(64);
    private boolean autosave = true;
    @Deprecated
    protected static String javaVersion;
    protected static boolean isOneShot;
    protected static String nmroot;
    protected static Shell currentShell;
    protected static Table options;
    protected static int privs;
    protected static boolean noExternalCmds;
    protected static Method nmClassLoaderAddUrl;
    protected static URLClassLoader nmClassLoader;
    protected static ClassLoader loader;
    protected static Theme theme;
    @Deprecated
    @InternalUseOnly(value="Since NeXtMidas 3.5.4, this was never set")
    public static String vminfo;
    public static final String osrep;
    public static final byte rep;
    public static final String osname;
    public static final String ostag;
    public static final String ostype;
    static final String javaversion;
    private static final int javaMajorVersion;
    public static final boolean iscentos7;
    public static String currentLoader;
    private static String nmpid;
    private boolean rebuildClasspath = false;
    private static Set<String> loadedLibraries;
    private static String urlNeXtMidas;
    private static boolean gradleBuildCommand;
    private static boolean jvmHangWorkaround;
    private static ClassLoader nxmLoader;
    private static AtomicInteger panelCounter;

    public static String getJavaHome() {
        return System.getenv("JAVAHOME") + File.separator + "bin" + File.separator + "java";
    }

    public Shell() {
        this.classInit();
    }

    public Shell(ShellParent parent) {
        this();
        this.parent = parent;
        currentShell = this;
    }

    public Shell(Midas midas, boolean attach) {
        this();
        this.setAutosave(false);
        Object previousShell = midas.registry.get("SHELL");
        if (previousShell instanceof Shell) {
            Stack prevHistory = ((Shell)previousShell).getHistory();
            this.history = new Stack(prevHistory);
            this.parent = ((Shell)previousShell).parent;
        }
        if (!attach) {
            this.M = Macro.cloneContext(midas, false, 0);
            this.M.registry.put("SHELL", this);
            this.M.registry.put("HANDLERS", Registry.handlers);
            this.M.detach();
        } else {
            this.M = midas;
        }
    }

    private void classInit() {
        ClassLoader classLoader;
        Class<?> clazz;
        String noExtCmdProp = Shell.getProperty("NOEXTERNAL");
        if (noExtCmdProp != null) {
            boolean bl = noExternalCmds = noExternalCmds || StringUtil.isTrue(noExtCmdProp);
        }
        if ((clazz = (classLoader = Shell.class.getClassLoader()).getClass()).getName().equals("NmClassLoader")) {
            try {
                nmClassLoaderAddUrl = clazz.getMethod("addURL", URL.class);
                nmClassLoader = (URLClassLoader)classLoader;
            }
            catch (NoSuchMethodException e) {
                this.M.printStackTrace("ERROR: Can't initialize class loader in Shell.", e);
                nmClassLoader = null;
            }
        }
    }

    public static void setPriv(int privilege) {
        privs |= privilege;
    }

    public static boolean getPriv(int privilege) {
        return (privs & privilege) != 0;
    }

    public Stack getHistory() {
        return this.history;
    }

    @InternalUseOnly
    public static boolean isGradleBuild() {
        Manifest manifest;
        if (Boolean.valueOf(System.getenv("ISNEXTMIDASGRADLEBUILD")).booleanValue()) {
            return true;
        }
        Class<Shell> clazz = Shell.class;
        String classname = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(classname).toString();
        if (!classPath.startsWith("jar")) {
            return false;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            manifest = new Manifest(new URI(manifestPath).toURL().openStream());
        }
        catch (IOException | URISyntaxException e) {
            return false;
        }
        Attributes attr = manifest.getMainAttributes();
        String value = attr.getValue("Gradle-Build");
        return value != null;
    }

    @InternalUseOnly
    public static boolean isGradleBuildCommand() {
        return gradleBuildCommand;
    }

    @InternalUseOnly
    public static boolean isRunningFromJarFile() {
        return nmroot.startsWith("jar:") || Shell.isWebStart() || nmroot.startsWith("classpath:");
    }

    @ProvisionalUseOnly(value="API may change")
    public static void setJVMHangWorkaround(boolean enabled) {
        jvmHangWorkaround = enabled;
    }

    @ProvisionalUseOnly(value="API may change")
    public static boolean getJVMHangWorkaround() {
        return jvmHangWorkaround;
    }

    @InternalUseOnly
    public static boolean needRemoveNotifyToAvoidJVMHang() {
        return jvmHangWorkaround && Shell.isRunningFromJarFile();
    }

    public static String getNmRoot() {
        if (nmroot == null) {
            nmroot = Shell.getProperty("NMROOT");
        }
        return nmroot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if ("Mac OS X".equalsIgnoreCase(osname)) {
            Shell.initForMacOsX();
        }
        String arglist = "";
        if (args.length > 0) {
            arglist = args[0];
        }
        for (int i = 1; i < args.length; ++i) {
            arglist = arglist + " " + args[i];
        }
        isOneShot = arglist.length() > 0;
        int exitCode = 0;
        try {
            Shell.runNew(null, arglist, false);
        }
        catch (Throwable t) {
            exitCode = 1;
            t.printStackTrace();
        }
        finally {
            System.exit(exitCode);
        }
    }

    public static Shell runNew(ShellParent parent, String cmdline, boolean bg) {
        currentShell = new Shell();
        Midas shellM = Shell.currentShell.M;
        if (shellM.isAutoDetectingBehavior()) {
            shellM.setIfJavaBehavior(false);
        }
        currentShell.run(parent, cmdline, bg);
        return currentShell;
    }

    public void run(ShellParent parent, String cmdline, boolean bg) {
        this.parent = parent;
        this.cmdline = cmdline;
        if (bg) {
            Thread thread = new Thread(this);
            thread.start();
        } else {
            this.run();
        }
    }

    @Override
    public void run() {
        Shell.setPriv(-1);
        this.open();
        this.process();
        this.close();
    }

    private String detectNMROOT() {
        String detectedNMROOT;
        if (loader == null && (loader = this.getClass().getClassLoader()) == null) {
            this.M.warning("Cannot get ClassLoader for Shell.class! Returning null for detected NMROOT.");
            return null;
        }
        URL url = loader.getResource(CLASS_RESOURCE_NAME);
        if (url != null) {
            int index;
            String urlstr = url.toExternalForm();
            String nmrootURL = urlstr.substring(0, index = urlstr.lastIndexOf(CLASS_RESOURCE_NAME));
            detectedNMROOT = FileUtil.isLocalFileName(nmrootURL) ? FileUtil.toLocalFileName(nmrootURL) : nmrootURL;
            this.M.info("NMROOT not defined. Setting it to: " + detectedNMROOT);
        } else {
            detectedNMROOT = null;
        }
        return detectedNMROOT;
    }

    public void open() {
        boolean gotState;
        loader = this.getClass().getClassLoader();
        nmroot = this.parent != null ? this.parent.getNmRoot() : Shell.getProperty("NMROOT");
        if (nmroot == null) {
            nmroot = this.detectNMROOT();
        }
        this.boot();
        if (this.parent != null && this.parent.getTerminal() != null) {
            this.M.terminal = this.parent.getTerminal();
            this.M.terminal.M = this.M;
            gotState = false;
        } else {
            if (Native.useIO) {
                try {
                    NTerminal nterminal = new NTerminal(this.M);
                    this.M.terminal = nterminal;
                }
                catch (Exception e) {
                    this.M.printStackTrace("Error loading native terminal, using Java version.", e);
                    this.M.terminal = new Terminal(this.M);
                }
            }
            gotState = this.loadState();
        }
        if (!gotState) {
            this.configure();
        } else if (this.rebuildClasspath) {
            this.addPathToClasspath(options.getS("PATH", ""));
        }
        String[] cpEntries = FileUtil.splitEntries(options.getS("CLASSPATH._APPEND_"));
        Shell.addToClasspath(cpEntries);
        this.commands = 0;
    }

    public void process() {
        boolean suspended;
        boolean oneShot = this.cmdline != null && this.cmdline.length() > 0;
        boolean configure = StringUtil.isTrue(Shell.getProperty("CONFIGURE"));
        if (!this.configured && configure) {
            this.runStartupMacro("nmstartup", "HOME", "AUX", "NMSTARTUP.USER");
            if (oneShot) {
                this.runCommand(this.cmdline);
            }
            return;
        }
        if (oneShot) {
            this.runCommand(this.cmdline);
            return;
        }
        boolean bl = suspended = this.M.macro != null && this.M.macro.suspend != 0;
        while (this.M.status != -3) {
            try {
                Class<?> exitClass = Class.forName("nxm.sys.intr.Exit");
                if (exitClass.isInstance(this.command)) {
                    break;
                }
            }
            catch (ClassNotFoundException exitClass) {
                // empty catch block
            }
            if (suspended && this.M.macro.suspend <= 0) break;
            if (this.M.terminal.getInterrupt() != 0) {
                this.exit();
                break;
            }
            this.command = null;
            String prompt = PROMPT_STRING;
            if (this.M.pipeMode != 0) {
                prompt = prompt + PROMPT_STRING_PIPE;
            }
            if (suspended) {
                prompt = prompt + PROMPT_STRING_SUSPEND;
            }
            prompt = prompt + "> ";
            this.cmdline = this.getNextCommand(prompt, "");
            if (this.cmdline == null) {
                return;
            }
            if (this.cmdline.length() == 0) continue;
            if (this.autosave) {
                this.saveState();
            }
            try {
                this.runCommand(this.cmdline, true);
                System.gc();
            }
            catch (Exception e) {
                this.M.printStackTrace(e);
            }
            ++this.commands;
        }
        this.command = null;
        this.cmdline = null;
    }

    public void close() {
        this.M.registry.clear();
        this.saveState();
    }

    public void exit() {
        if (this.command != null && this.command.MQ != null) {
            this.command.MQ.put("EXIT", 0, null);
            for (int i = 0; i < 10 && this.command.state != 4; ++i) {
                Time.sleep(0.1);
            }
        }
    }

    public String getNextCommand(String prompt, String seed) {
        block16: {
            String lastcmd;
            Object peekobj = null;
            String previous = null;
            while (true) {
                this.cmdline = previous == null ? this.M.terminal.getInputTabComplete(prompt, seed) : previous + this.M.terminal.getInput("--> ", seed, 2);
                seed = "";
                if (this.cmdline == null) break block16;
                this.cmdline = this.cmdline.trim();
                if (this.cmdline.length() == 0) break block16;
                if (this.cmdline.startsWith("!")) {
                    int popcode = 0;
                    seed = null;
                    if (this.cmdline.equals("!LAST")) {
                        popcode = -1;
                    } else if (this.cmdline.equals("!NEXT")) {
                        popcode = 1;
                    } else if (this.cmdline.equals("!LASTREF")) {
                        popcode = -2;
                    } else if (this.cmdline.equals("!NEXTREF")) {
                        popcode = 2;
                    } else {
                        seed = this.recall(this.cmdline.substring(1));
                    }
                    if (seed == null) {
                        seed = "";
                    }
                    if (popcode == 0) continue;
                    if (popcode == 1 && peekobj == null) {
                        popcode = 2;
                    }
                    if ((peekobj = this.history.peek(popcode)) != null) {
                        seed = (String)peekobj;
                        continue;
                    }
                    seed = "";
                    continue;
                }
                if (this.cmdline.endsWith("?")) {
                    seed = this.query(this.cmdline.substring(0, this.cmdline.length() - 1));
                    if (seed != null) continue;
                    seed = "";
                    continue;
                }
                if (!this.cmdline.endsWith("&") || this.cmdline.endsWith("&&")) break;
                previous = this.cmdline.substring(0, this.cmdline.length() - 1);
            }
            String origCmdline = this.cmdline;
            if (this.cmdline.endsWith("&&")) {
                this.cmdline = this.cmdline.substring(0, this.cmdline.length() - 1);
            }
            if (!origCmdline.equals(lastcmd = (String)this.history.peek())) {
                this.history.push(origCmdline);
            }
        }
        return this.cmdline;
    }

    public void setState(int state) {
        if (this.command != null) {
            this.command.setState(state);
        }
    }

    public void setAutosave(boolean save) {
        this.autosave = save;
    }

    public boolean getAutosave() {
        return this.autosave;
    }

    public boolean saveState() {
        Results MR = this.M.results;
        String msf = MR.getString("ENV.MSF");
        if (msf == null || msf.equals("NULL")) {
            return false;
        }
        MR.put("ENV.TIMER", Convert.x2o(this.M.timer), 16);
        MR.put("ENV.ELAPSE", Convert.x2o(this.M.elapse), 16);
        try {
            FileOutputStream fos = new FileOutputStream(msf + ".msf");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(Table.getDefaultModeName());
            oos.writeObject(Table.getDefaultFlags());
            MR.put("REG", (Object)new Table());
            oos.writeObject(MR.toBytes(true));
            MR.put("REG", (Object)this.M.registry.table);
            oos.writeObject(Arrays.copyOfRange(this.M.dictionary.entry, 0, this.M.dictionary.size));
            oos.writeObject(this.history);
            oos.writeObject(Registry.handlers.toBytes());
            oos.flush();
            fos.close();
            return true;
        }
        catch (Exception e) {
            Shell.printStackTrace("Error saving state", e);
            return false;
        }
    }

    public boolean loadState() {
        String msf = this.M.results.getString("ENV.MSF");
        if (StringUtil.isNull(msf)) {
            return false;
        }
        try {
            FileInputStream fis = new FileInputStream(msf + ".msf");
            ObjectInputStream ois = new ObjectInputStream(fis);
            String tableMode = (String)ois.readObject();
            String tableFlags = (String)ois.readObject();
            byte[] res = (byte[])ois.readObject();
            String[] dict = (String[])ois.readObject();
            Stack hist = (Stack)ois.readObject();
            byte[] hand = (byte[])ois.readObject();
            fis.close();
            Table.setDefaultMode(tableMode);
            Table.setDefaultFlags(tableFlags);
            this.M.results.setMode(tableMode);
            this.M.results.setFlags(tableFlags);
            this.M.results.fromBytes(res, 0, res.length);
            this.M.dictionary.fromArray(dict);
            Registry.handlers = new Table(hand);
            this.history = hist;
            options = this.M.results.getTable("OPT");
            options.setMode(6);
            options.setFlags(8);
            Table cpTable = options.getTable("CLASSPATH");
            cpTable.setFlags(8);
            String rebuildCP = Shell.getProperty("REBUILDCLASSPATH");
            if (rebuildCP != null && rebuildCP.length() > 0) {
                this.rebuildClasspath = StringUtil.isTrue(rebuildCP);
            }
            if (!this.rebuildClasspath) {
                String[] keys;
                for (String key : keys = cpTable.getKeys()) {
                    if (key.indexOf(95) == 0) continue;
                    Shell.addToClasspath(cpTable.getS(key));
                }
            }
            Results MR = this.M.results;
            MR.put("REG", (Object)this.M.registry.table);
            MR.put("REG.SHELL", (Object)this);
            MR.put("REG.HANDLERS", (Object)Registry.handlers);
            MR.put("RAM", (Object)this.M.pipes);
            MR.put("AUX.CWD", (Object)this.getPathProperty("CWD", "user.dir", "", true));
            if (MR.getState("AUX._TRACKCWD_")) {
                MR.put("AUX.HOMEPATH", MR.get("AUX.CWD"));
            }
            this.M.debug = Parser.mask("IO,Macro,Pipes,Graphics,Results,Primitive,Shell,Args,Trace,Deprecate,SuperTrace", MR.getS("ENV.DEBUG"), 0);
            this.M.verify = Parser.mask("Commands,Switches,Qualifiers,Controls,Beep,Break", MR.getS("ENV.VERIFY"), 0);
            this.M.timer = MR.getX("ENV.TIMER");
            this.M.elapse = MR.getX("ENV.ELAPSE");
            Native.setUse(MR.getS("ENV.USENATIVE"));
            Theme.setOptions(MR.getS("ENV.GRAPHICS"));
            Theme.updateUIManager(MR.getTable("ENV.UIMANAGER"));
            this.M.io.setOptions(MR.getS("ENV.IOOPTIONS"));
            MR.getTable("ENV").setFlags(8);
            return true;
        }
        catch (FileNotFoundException fis) {
        }
        catch (Exception e) {
            this.M.warning("Error loading state: " + e.getMessage());
            this.M.warning("Restarting NeXtMidas session.");
            this.boot();
        }
        return false;
    }

    public String recall(String text) {
        text = text.toUpperCase();
        Object peekobj = this.history.peek(-1);
        while (peekobj != null) {
            String peekstr = (String)peekobj;
            if (peekstr.toUpperCase().startsWith(text)) {
                return peekstr;
            }
            peekobj = this.history.peek(-1);
        }
        return null;
    }

    public String query(String text) {
        Args args = Shell.parseCommand(this.M, text);
        if (args == null) {
            return text;
        }
        for (int i = 1; i <= args.numberOf(); ++i) {
            String key = args.getKey(i);
            String value = args.getValue(i);
            value = this.M.terminal.getInput(key + " = ", value, 0);
            args.put(key, value);
        }
        return args.toString().substring(2);
    }

    public void boot() {
        String hostaddr = "unknown";
        String hostname = "unknown";
        String userhome = "unknown";
        String username = "unknown";
        String msf = "NULL";
        boolean qos = Shell.getPriv(2);
        if (qos) {
            try {
                InetAddress ia = InetAddress.getLocalHost();
                hostname = ia.getHostName();
                hostaddr = ia.getHostAddress();
            }
            catch (Exception e) {
                this.M.printStackTrace("Error in host lookup", e);
            }
            nmpid = Shell.getProperty("NMPID");
            msf = Shell.getProperty("NMSF");
        }
        if (nmpid == null || nmpid.length() < 1) {
            nmpid = "0000";
        }
        String editor = osname.contains("Win") ? "WORDPAD" : (osname.contains("VMS") ? "edit/edt" : "xterm -e vi");
        if (qos) {
            username = this.getPathProperty("USER", "user.name", "unknown", false);
            userhome = this.getPathProperty("HOME", "user.home", "unknown", true);
        }
        Native.initUse();
        this.M.results.put("REG", (Object)this.M.registry.table);
        this.M.results.put("REG.SHELL", (Object)this);
        this.M.results.put("REG.HANDLERS", (Object)Registry.handlers);
        this.M.results.put("RAM", (Object)this.M.pipes);
        this.M.results.put("ENV", (Object)new Table());
        this.M.results.put("ENV.NMROOT", (Object)nmroot);
        this.M.results.put("ENV.USER", (Object)username);
        this.M.results.put("ENV.HOME", (Object)userhome);
        this.M.results.put("ENV.HOSTNAME", (Object)hostname);
        this.M.results.put("ENV.HOSTADDR", (Object)hostaddr);
        this.M.results.put("ENV.OSTYPE", (Object)ostype);
        this.M.results.put("ENV.OSNAME", (Object)osname);
        this.M.results.put("ENV.OSREP", (Object)osrep);
        this.M.results.put("ENV.EDITOR", (Object)editor);
        this.M.results.put("ENV.VIEW", (Object)"TEXT");
        this.M.results.put("ENV.THEME", (Object)"GEAR3");
        this.M.results.put("ENV.STYLE", (Object)"GEAR3");
        this.M.results.put("ENV.GRAPHICS", (Object)Theme.getOptions());
        this.M.results.put("ENV.PID", (Object)nmpid);
        this.M.results.put("ENV.MSF", (Object)msf);
        this.M.results.put("ENV.NMVERSION", (Object)"4.1.4");
        this.M.results.put("ENV.JVMVERSION", (Object)Shell.getJavaVersion());
        this.M.results.put("ENV.NMPRERELEASE", (Object)"FALSE");
        this.M.results.put("ENV.PAUSE", this.M.pause);
        this.M.results.put("ENV.VERIFY", (Object)"|");
        this.M.results.put("ENV.DEBUG", (Object)"|");
        this.M.results.put("ENV.IOOPTIONS", (Object)this.M.io.getOptions());
        this.M.results.put("ENV.USENATIVE", (Object)Native.getUse());
        this.M.results.getTable("ENV").setFlags(8);
        this.M.results.put("OPT", (Object)options);
        this.M.results.put("OPT.PATH", (Object)"SYS");
        Table classpathTbl = new Table(6, 8);
        String preappendCP = Shell.getProperty("CLASSPATHPREPEND");
        String afterSysCP = Shell.getProperty("CLASSPATHAFTERSYS");
        String appendCP = Shell.getProperty("CLASSPATH");
        if (preappendCP != null && preappendCP.length() > 0) {
            classpathTbl.put("_PREPEND_", (Object)preappendCP, 16);
        }
        if (afterSysCP != null && afterSysCP.length() > 0) {
            classpathTbl.put("_AFTERSYS_", (Object)afterSysCP, 16);
        }
        if (appendCP != null && appendCP.length() > 0) {
            classpathTbl.put("_APPEND_", (Object)appendCP, 16);
        }
        Shell.updateFromClassLoader(classpathTbl, null);
        this.M.results.put("OPT.CLASSPATH", (Object)classpathTbl);
        this.M.results.put("AUX", (Object)new Table());
        this.M.results.put("AUX.WRITE", (Object)"HOME");
        this.M.results.put("AUX.READ", (Object)"HOME|RAM|DAT");
        String cwd = nmroot;
        if (qos) {
            cwd = this.getPathProperty("CWD", "user.dir", "", true);
        }
        this.M.results.put("AUX.CWD", (Object)cwd);
        if (userhome.startsWith("http")) {
            userhome = nmroot;
        }
        this.M.results.put("AUX.HOME", (Object)userhome);
        this.M.results.put("AUX.HOMEPATH", (Object)userhome);
        this.M.results.put("AUX.DAT", (Object)Shell.getOptPath("SYS", "DAT"));
        this.M.results.put("AUX.RAM", (Object)"ram:");
        this.M.dictionary.append("CONFIGURE;SYS:4,I,2,FUNC=,OPT=SYS");
        this.M.dictionary.append("EXIT;SYS:4,I,1,FILE=NXMSHELL,");
        this.M.dictionary.append("HELP;SYS:4,I,3,CAT=MAINHELP,ITEM=,OPT=SYS");
        this.M.dictionary.append("MENU;SYS:4,I,4,ACT=LIST,NAME=,SUP=ALL,OPT");
        this.M.dictionary.genAlpha();
    }

    private void runStartupMacro(String macro, String areaOrAux, String opt, String overridePropName) {
        this.configured = true;
        if ((macro = Shell.getProperty(overridePropName, macro)) == null || macro.equalsIgnoreCase("default")) {
            macro = "nmstartup";
        } else if (macro.length() == 0 || macro.equalsIgnoreCase("none")) {
            return;
        }
        if (areaOrAux != null || macro != null) {
            int iSemiColon;
            if (areaOrAux == null) {
                areaOrAux = "HOME";
            }
            macro = macro.trim();
            int iSpace = macro.indexOf(32);
            String arguments = "";
            if (iSpace > 0) {
                arguments = macro.substring(iSpace);
                macro = macro.substring(0, iSpace);
            }
            if ((iSemiColon = macro.indexOf(59)) == 0) {
                throw new MidasException("invalid macro [" + macro + "] specified.");
            }
            if (iSemiColon > 0) {
                areaOrAux = "mcr";
                opt = macro.substring(iSemiColon + 1);
                macro = macro.substring(0, iSemiColon);
            }
            FileName fn = new FileName(macro, true);
            String macroName = fn.getRoot();
            String fname = macro;
            if (fn.getPath().length() == 0) {
                fname = this.M.io.name(areaOrAux, macro, "mm", opt);
            }
            if (this.M.io.exists(fname)) {
                this.runCommand("%" + macroName + ",/MFN=" + fname + arguments);
            } else if (!macro.equalsIgnoreCase("nmstartup")) {
                this.M.warning("Could not find %" + macro + (macro.equals(fname) ? "" : " at " + fname));
            }
        }
    }

    public void configure() {
        String tmp = this.M.io.name("CFG", "HANDLERS", "TBL", "SYS");
        TextFile tf = new TextFile(this.M, (Object)tmp);
        int tabFlags = Table.getDefaultFlagsInt() & 0xFFFFFFFB;
        if (tf.find(-1)) {
            Registry.handlers.fromTextFile(tf, tabFlags);
        }
        this.runCommand("CONFIGURE,KC");
        if (this.parent == null) {
            this.runCommand("VERSION/ALL SYS");
            if (this.cmdline != null && this.cmdline.length() == 0) {
                this.runStartupMacro("nmstartup", "cfg", "SYS", "NMSTARTUP.SYS");
                this.runStartupMacro("nmstartup", "HOME", "AUX", "NMSTARTUP.USER");
                this.cmdline = "EXIT";
            } else {
                this.runStartupMacro("nmstartup", "cfg", "SYS", "NMSTARTUP.SYS");
                this.runStartupMacro("none", "HOME", "AUX", "NMSTARTUP.USER");
            }
        }
        if (this.parent != null) {
            tmp = this.parent.getCWD();
            if (tmp != null) {
                this.M.results.put("AUX.CWD", (Object)tmp);
            }
            if ((tmp = this.parent.getAux()) != null) {
                this.runCommand("AUX " + tmp);
            }
            if ((tmp = this.parent.getHome()) != null) {
                this.M.results.put("AUX.HOME", (Object)tmp);
                this.M.results.put("AUX.HOMEPATH", (Object)tmp);
            }
            if ((tmp = this.parent.getOpts()) != null) {
                this.configureOpts(tmp, this.parent.getServer());
            }
            if ((tmp = this.parent.getNMS()) != null) {
                this.runStartupMacro(tmp, "HOME", "AUX", "NMSTARTUP.USER");
            }
            if ((tmp = this.parent.getTheme()) != null) {
                this.M.results.put("ENV.THEME", (Object)tmp, 16);
                try {
                    Theme.setGlobalTheme(tmp, this.M);
                }
                catch (Exception e) {
                    this.M.warning("Unable to set theme to '" + tmp + "': " + e);
                }
            }
            if ((tmp = this.parent.getStyle()) != null) {
                this.M.results.put("ENV.STYLE", (Object)tmp, 16);
            }
        }
        this.initCompletionExcludedAuxes();
        this.M.status = 0;
    }

    protected void configureOpts(String opts, String server) {
        if (opts == null) {
            return;
        }
        Parser p = new Parser(opts, ',');
        String path = "SYS";
        for (int i = p.elements(); i >= 1; --i) {
            String opt = p.get(i);
            String dir = null;
            int j = opt.indexOf(61);
            if (j > 0) {
                dir = opt.substring(j + 1);
                opt = opt.substring(0, j);
            }
            if (dir != null && dir.indexOf(58) < 0 && server != null) {
                dir = "http://" + server + dir;
            }
            opt = opt.toUpperCase();
            if (dir != null) {
                this.M.results.put("OPT." + opt, (Object)dir);
            }
            this.runCommand("CONFIGURE,C," + opt);
            path = opt + "," + path;
        }
        this.runCommand("PATH/RERUN/VERBOSE=FALSE,SET," + path);
    }

    private String getPathProperty(String name, String name2, String def, boolean term) {
        String tmp = Shell.getProperty(name);
        if (tmp == null) {
            tmp = Shell.getProperty(name2);
        }
        if (tmp == null) {
            tmp = def;
        }
        if (term) {
            tmp = FileName.terminatePath(tmp);
        }
        return tmp;
    }

    public Command runCommand(String cmdline) {
        Command command;
        this.command = command = Shell.runCommand(this.M, cmdline, null);
        return command;
    }

    private Command runCommand(String cmdline, boolean nmPromptCmd) {
        Command command;
        this.command = command = Shell.runCommand(this.M, cmdline, null, null, nmPromptCmd);
        return command;
    }

    public Command runCommand(String cmdline, JPanel mdPanel) {
        return Shell.runCommand(this.M, cmdline, null, mdPanel);
    }

    public static Command runCommand(Midas M, String cmdline) {
        return Shell.runCommand(M, cmdline, null);
    }

    public static Command runCommand(Midas M, String cmdline, CommandParent cmdParent) {
        return Shell.runCommand(M, cmdline, cmdParent, null);
    }

    public static Command runCommand(Midas M, String cmdline, CommandParent cmdParent, JPanel mdPanel) {
        return Shell.runCommand(M, cmdline, cmdParent, mdPanel, false);
    }

    private static Command runCommand(Midas M, String cmdline, CommandParent cmdParent, JPanel mdPanel, boolean nmPromptCmd) {
        Args args;
        if (cmdline.isEmpty()) {
            return null;
        }
        String uniqueRegWinName = null;
        if (mdPanel != null) {
            uniqueRegWinName = "_MDISPLAY" + panelCounter.getAndIncrement() + "_";
            Table win = (Table)M.registry.get("WIN");
            if (win == null) {
                win = new Table();
                M.registry.put("WIN", win);
            }
            if (win.containsKey(uniqueRegWinName)) {
                M.warning("Overriding existing REG.WIN." + uniqueRegWinName + " panel entry [" + win.getO(uniqueRegWinName) + "] with " + mdPanel);
            }
            win.put(uniqueRegWinName, (Object)mdPanel);
            cmdline = cmdline + " /WIN=" + uniqueRegWinName;
        }
        if ((args = Shell.parseCommand(M, cmdline)) == null) {
            return null;
        }
        Command command = Shell.loadCommand(M, args, cmdParent);
        if (command == null) {
            M.warning("couldn't find command : " + cmdline);
            return null;
        }
        command.setNmPromptCmd(nmPromptCmd);
        if (M.isAutoDetectingBehavior() && M.isJavaBehavior()) {
            M.setIfJavaBehavior(!nmPromptCmd);
            if (Midas.isJavaVsMidasDebug()) {
                M.info("#JvsM Shell.runCommand setting Macro/Midas usage to true");
            }
        }
        Shell.execCommand(M, command);
        if (mdPanel != null) {
            M.registry.remove("WIN." + uniqueRegWinName);
        }
        return command;
    }

    public static Args parseCommand(Midas M, String cmdline) {
        return Args.parseCommand(M, cmdline);
    }

    public static Command loadCommand(Midas M, Args args) {
        return Shell.loadCommand(M, args, null);
    }

    public static Command loadCommand(Midas M, Args args, CommandParent cmdParent) {
        Command command = null;
        switch (args.support) {
            case 'I': {
                command = Shell.getCommandForClassName(M, args);
                break;
            }
            case 'P': {
                command = Shell.getCommandForClassName(M, args);
                break;
            }
            case 'H': {
                command = Shell.getCommandForClassName(M, args);
                break;
            }
            case 'M': {
                command = new Macro();
                break;
            }
            case 'O': {
                command = Shell.getCommandForeign(M, args);
                break;
            }
            case 'U': {
                command = Shell.getCommandForeign(M, args);
                break;
            }
            case 'D': {
                command = Shell.getCommandDeprecated(M, args);
                break;
            }
            default: {
                M.error("Undefined command support: " + args.support);
            }
        }
        if (command != null) {
            command.setCmdParent(cmdParent);
            command.setArgs(args);
            if (command.checkin(M) != 0) {
                M.error("loading command " + command.name);
            }
            if (args.support == 'U' && args.getState("/NOEXEC")) {
                M.error("Cannot execute command " + command.name + " from inside shell");
            }
        }
        return command;
    }

    public void setLoader() {
        loader = this.getClass().getClassLoader();
    }

    private static Command getCommandDeprecated(Midas M, Args args) {
        Parser pconf = M.dictionary.findParser(args.getName());
        CommandLine cl = new CommandLine(pconf.getAll());
        String str = args.getName() + " command deprecated";
        if (args.numberOf() > 0) {
            str = str + ", " + cl.getDefault(1);
        }
        M.deprecate(str);
        return null;
    }

    private static Command getCommandForeign(Midas M, Args args) {
        return new Foreign(M.terminal.isExtCmdSupported() && !noExternalCmds);
    }

    private static Command getCommandForClassName(Midas M, Args args) {
        String className = args.getCmdClassName();
        try {
            Class<?> clazz = loader.loadClass(className);
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new MidasException("The class " + className + " is not public.");
            }
            Constructor<?> cnst = clazz.getConstructor(new Class[0]);
            return (Command)cnst.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            String fileName = "" + loader.getResource(className.replace('.', '/') + ".class");
            String srcName = "" + loader.getResource(className.replace('.', '/') + ".java");
            if (M.io.fexists(srcName) && !M.io.fexists(fileName)) {
                throw new MidasException("The class " + className + " has not been compiled.");
            }
            throw new MidasException("Can not find the class " + className + ".", e);
        }
        catch (IllegalAccessException e) {
            throw new MidasException("Could not find a public no-argument constructor for " + className + ".");
        }
        catch (NoSuchMethodException e) {
            throw new MidasException("Could not find a public no-argument constructor for " + className + ".");
        }
        catch (ClassCastException e) {
            throw new MidasException("The class " + className + " does not extend nxm.sys.lib.Command.", e);
        }
        catch (MidasException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MidasException("Error loading " + className + ": " + e.getMessage(), e);
        }
    }

    public static Object getInstanceForClassName(String className) {
        try {
            Class<?> c = loader.loadClass(className);
            return c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new MidasException("Error loading class '" + className + "': " + e, e);
        }
    }

    public static void execCommand(Midas M, Command command) {
        boolean isPiped;
        int runMode = Parser.mask(cmdRunModeList, command.MA.getS("/CMDRUNMODE"), 0);
        boolean bg = command.MA.getState("/BG");
        boolean bl = isPiped = (runMode & 1) == 0 && command.isPipable() && (M.pipeMode == 1 || bg && M.pipeMode != 0);
        if (command.MA.getState("/NOPIPE")) {
            isPiped = false;
        }
        Object engine = isPiped && !bg ? command.MA.getO("/ENGINE") : null;
        command.state = 0;
        command.isPiped = isPiped;
        if (engine != null && command.processReady() != -1) {
            M.macro.addCommand(command);
        } else if (bg || isPiped) {
            double SLEEP_INTERVAL = 0.01;
            MidasThread thread = new MidasThread(M, command);
            command.thread = thread;
            thread.start();
            double cmdOpenTimeout = command.MA.getD("/CMDOPENTIMEOUT", -1.0);
            int numLoops = Integer.MAX_VALUE;
            if (cmdOpenTimeout >= 0.0) {
                numLoops = (int)(cmdOpenTimeout / 0.01);
            }
            while ((command.state == 0 || command.state == 1) && numLoops-- > 0) {
                Time.sleep(0.01);
            }
        } else {
            command.thread = Thread.currentThread();
            command.run();
        }
        Shell.checkAndSetInterrupt(M);
    }

    public static Command execBackgroundCommand(Midas midas, String commandString) {
        if (midas == null) {
            midas = Shell.getSharedMidasContext();
        }
        String cmdline = commandString + " /BG";
        Args args = Args.parseCommand(midas, cmdline);
        Command command = Shell.loadCommand(midas, args);
        Shell.execCommand(midas, command);
        return command;
    }

    public static Command execCommandAndWait(Midas midas, String commandString) {
        if (midas == null) {
            midas = Shell.getSharedMidasContext();
        }
        String cmdline = commandString;
        Args args = Args.parseCommand(midas, cmdline);
        Command command = Shell.loadCommand(midas, args);
        Shell.execCommand(midas, command);
        return command;
    }

    static String getDefArchType() {
        String bits = Shell.getProperty("sun.arch.data.model");
        if (bits == null || bits.length() == 0 || bits.equalsIgnoreCase("unknown")) {
            String arch = Shell.getProperty("os.arch");
            if (arch.equals("i386")) {
                bits = "32";
            } else if (arch.equals("x86")) {
                bits = "32";
            } else if (arch.equals("ppc")) {
                bits = "32";
            } else if (arch.equals("arm")) {
                bits = "32";
            } else if (arch.equals("sparc")) {
                bits = "64";
            } else if (arch.equals("amd64")) {
                bits = "64";
            } else if (arch.equals("alpha")) {
                bits = "64";
            } else if (arch.equals("x86_64")) {
                bits = "64";
            } else {
                Shell.warning("Could not determine if '" + arch + "' was 32Bit or 64Bit, assuming 32Bit.");
                bits = "32";
            }
        }
        return bits;
    }

    public static String getLibrarySuffix() {
        String libSuffix = Shell.getProperty("NATIVELIBSUFFIX");
        if (libSuffix != null) {
            return libSuffix;
        }
        return "_" + ostag + Shell.getDefArchType();
    }

    public static String getLibraryExt() {
        if (ostag.equals("win")) {
            return ".dll";
        }
        if (ostag.equals("vms")) {
            return ".exe";
        }
        return ".so";
    }

    public static String getLibraryPrefix() {
        if (ostag.equals("win") || ostag.equals("vms")) {
            return "";
        }
        return "lib";
    }

    public static String getSharedObjExt() {
        return Shell.getLibrarySuffix() + Shell.getLibraryExt();
    }

    public static boolean loadLibrary(String path, String name) {
        try {
            return Shell.loadLibraryUnsafe(path, name);
        }
        catch (SecurityException e) {
            Shell.printStackTrace("Shell.loadLibrary Security Error: path=" + path + " name=" + name, e);
        }
        catch (UnsatisfiedLinkError e) {
            Shell.printStackTrace("Shell.loadLibrary Error: path=" + path + " name=" + name, e);
        }
        return false;
    }

    public static boolean loadLibraryUnsafe(String path, String name) throws SecurityException, UnsatisfiedLinkError {
        block8: {
            if (!Native.canUse) {
                return false;
            }
            String libName = name + Shell.getLibrarySuffix();
            if (Shell.currentShell.parent != null && IOResource.isURLResource(path) && !FileUtil.isLocalFileName(path)) {
                try {
                    System.loadLibrary(libName);
                }
                catch (UnsatisfiedLinkError e) {
                    try {
                        System.load(Shell.extractLibFromJar(libName, e));
                        break block8;
                    }
                    catch (UnsatisfiedLinkError e2) {
                        String extractionFileName = Shell.extractLibFromGradleJar(libName, path, e);
                        if (extractionFileName != null) {
                            System.load(extractionFileName);
                        }
                        break block8;
                    }
                }
            }
            libName = path + libName + Shell.getLibraryExt();
            int i = libName.indexOf(".jar");
            if (i > 0) {
                libName = "file:" + libName.substring(0, i + 4) + "!" + libName.substring(i + 4);
            }
            System.load(libName);
        }
        return true;
    }

    public static boolean loadLibrary(String className) {
        if (!className.startsWith("nxm.")) {
            return false;
        }
        String name = className.substring(4);
        int i = name.indexOf(46);
        String option = name.substring(0, i);
        name = name.substring(i + 1);
        i = name.indexOf(46);
        String area = name.substring(0, i);
        name = name.substring(i + 1);
        return Shell.loadLibrary(Shell.getOptPath(option, area), name);
    }

    private static String getOptNameFromPath(String path) {
        String[] temp = path.split("/");
        return temp[temp.length - 2];
    }

    public static boolean loadLibrary(String option, String area, String name) {
        return Shell.loadLibrary(Shell.getOptPath(option, area), name);
    }

    private static String extractLibFromJar(String libName, Error eOrig) {
        String fullFileName = Shell.getLibraryPrefix() + libName + Shell.getLibraryExt();
        return Shell.loadFromJar(libName, fullFileName, eOrig);
    }

    private static String extractLibFromGradleJar(String libName, String path, Error eOrig) {
        String gradleNaming = "nxm-" + Shell.getOptNameFromPath(path) + Shell.getLibrarySuffix();
        String fullFileName = "main/shared/lib" + gradleNaming + Shell.getLibraryExt();
        if (loadedLibraries.contains(fullFileName)) {
            return null;
        }
        loadedLibraries.add(fullFileName);
        return Shell.loadFromJar(gradleNaming, fullFileName, eOrig);
    }

    private static String loadFromJar(String libName, String fullFileName, Error eOrig) {
        String libFileName = null;
        try {
            URL url = Shell.class.getClassLoader().getResource(fullFileName);
            if (url == null) {
                throw eOrig;
            }
            File tempLibFile = File.createTempFile(Shell.getLibraryPrefix() + libName, Shell.getLibraryExt());
            tempLibFile.deleteOnExit();
            libFileName = tempLibFile.toString();
            FileUtil.copyBaseFile(Shell.currentShell.M, url.toString(), libFileName);
        }
        catch (Throwable t) {
            throw eOrig;
        }
        return libFileName;
    }

    public String getOptionClassFileName(String name) {
        if (!name.startsWith("nxm.")) {
            return null;
        }
        int i1 = name.indexOf(46, 4);
        String opt = name.substring(4, i1);
        int i2 = name.indexOf(46, i1 + 1);
        String area = name.substring(i1 + 1, i2);
        String path = Shell.getOptPath(opt, area);
        path = path + name.substring(i2 + 1);
        path = path + ".class";
        return path;
    }

    public static String getOptPath(String opt, String area) {
        String path = (String)options.getKey(opt.toUpperCase());
        if (path == null) {
            path = nmroot;
        }
        return FileName.getOptionPath(path, opt, area);
    }

    public static String getAuxPath(String aux) {
        return Shell.currentShell.M.io.getAuxPath(aux.toUpperCase());
    }

    public String getOSType() {
        return ostype;
    }

    public String getOSName() {
        return osname;
    }

    public String getOSRep() {
        return osrep;
    }

    public static String getNmPID() {
        return nmpid;
    }

    public static Shell getCurrent() {
        return currentShell;
    }

    @InternalUseOnly(value="deprecated Since NeXtMidas 3.5.0, use getSharedMidasContext()")
    public static Midas getMidasContext() {
        return Shell.getSharedMidasContext();
    }

    public static Midas getSharedMidasContext() {
        if (currentShell == null) {
            Shell shell;
            currentShell = shell = new Shell();
            shell.open();
            shell.M.terminal = new Terminal(shell.M);
        }
        return Shell.currentShell.M;
    }

    public static void writeln(CharSequence str) {
        Shell.getSharedMidasContext().type(str);
    }

    public static void info(CharSequence str) {
        Shell.getSharedMidasContext().info(str);
    }

    public static void warning(CharSequence str) {
        Shell.getSharedMidasContext().warning(str);
    }

    public static void deprecate(CharSequence str) {
        Shell.getSharedMidasContext().deprecate(str);
    }

    public static void printStackTrace(CharSequence msg, Throwable err) {
        Shell.getSharedMidasContext().printStackTrace(msg, err, false);
    }

    public static void printStackTrace(Throwable err) {
        Shell.getSharedMidasContext().printStackTrace(err, false);
    }

    public static void warnStackTrace(CharSequence msg, Throwable throwable) {
        Shell.getSharedMidasContext().warnStackTrace(msg, throwable);
    }

    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public static Midas getMidasContext(String homepath, String nmRoot) {
        System.setProperty("HOME", homepath);
        System.setProperty("NMROOT", nmRoot);
        return Shell.getSharedMidasContext();
    }

    public static String getResourceUrl(String path, String root, String ext) {
        String resPath;
        URL res;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (ext.length() == 0) {
            ext = "prm";
        }
        if ((res = loader.getResource(resPath = path + root + "." + ext)) != null) {
            return ((Object)res).toString();
        }
        return null;
    }

    public static void beep() {
        Toolkit toolkit;
        try {
            toolkit = Toolkit.getDefaultToolkit();
        }
        catch (Throwable e) {
            toolkit = null;
        }
        if (toolkit != null && !GraphicsEnvironment.isHeadless()) {
            toolkit.beep();
        } else {
            System.out.print("\u0007");
            System.out.flush();
        }
    }

    public static String getJavaVersion() {
        String version = javaversion.replace('-', '_');
        int index = version.indexOf(95);
        if (index > 0) {
            version = version.substring(0, index);
        }
        return version;
    }

    @InternalUseOnly(value="Since added in NeXtMidas 4.0.1")
    public static int getJavaMajorVersion() {
        return javaMajorVersion;
    }

    private static int calcJavaMajorVersion() {
        int _javaMajorVersion = Integer.parseInt(Shell.getJavaVersion().split("[.]")[0]);
        if (_javaMajorVersion == 1) {
            _javaMajorVersion = Integer.parseInt(Shell.getJavaVersion().split("[.]")[1]);
        }
        return _javaMajorVersion;
    }

    @InternalUseOnly(value="Since added in NeXtMidas 3.5.3")
    public static int getJavaUpdateVersion() {
        int updateVer = 0;
        String javaVersion = javaversion;
        int index = javaVersion.indexOf(95);
        if (index == -1) {
            index = javaVersion.indexOf(45);
        }
        if (index > 0 && index + 1 < javaVersion.length()) {
            String str = javaVersion.substring(index + 1);
            try {
                updateVer = Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return updateVer;
    }

    public static String getTempDir() {
        return Shell.getProperty("java.io.tmpdir");
    }

    public static String getProperty(String name) {
        String value = null;
        if (value == null) {
            value = System.getProperty(name);
        }
        if (value == null) {
            value = System.getProperty("jnlp." + name);
        }
        return value;
    }

    public static String getProperty(String name, String defaultValue) {
        String val = Shell.getProperty(name);
        return val == null ? defaultValue : val;
    }

    public static boolean isOneShot() {
        return isOneShot;
    }

    public static boolean isHeadless() {
        return Theme.isHeadless();
    }

    public static boolean isShellInit() {
        return currentShell != null;
    }

    @InternalUseOnly
    public static String getPathToOptJar(String opt) {
        File[] files;
        if (nmroot.startsWith("classpath:") && !Shell.isGradleBuildCommand()) {
            String safeFileToFind = "nxm/" + opt + "/version.txt";
            String pathFile = loader.getResource(safeFileToFind).toString();
            int idxFile = pathFile.indexOf("!/" + safeFileToFind);
            pathFile = pathFile.substring(9, idxFile);
            if (Shell.isWindows()) {
                pathFile = pathFile.replace('/', '\\').replace("\\C:", "C:");
            }
            return pathFile;
        }
        String nmrootRaw = nmroot;
        if (Shell.isGradleBuildCommand()) {
            String safeFileToFind = "nxm/" + opt + "/version.txt";
            String pathFile = loader.getResource(safeFileToFind).toString();
            int idxFile = pathFile.indexOf(opt + "/build/resources");
            nmrootRaw = pathFile.substring(5, idxFile);
        }
        File dir = new File(nmrootRaw + "jars");
        FileUtil.FnFilter filt = FileUtil.createFnFilter(null, "*" + opt + "*.jar", null);
        for (File file : files = FileUtil.findFiles(dir, filt)) {
            String filePath = file.toString();
            String fileName = file.getName();
            if (fileName.contains("-native") || fileName.contains("-sources") || fileName.contains("-test") || fileName.contains("-demo")) continue;
            return filePath;
        }
        return null;
    }

    private static void initForMacOsX() {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "NeXtMidas");
        System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        System.setProperty("apple.awt.graphics.OptimizedShapes", "false");
        System.setProperty("apple.awt.graphics.EnableLazyDrawing", "false");
        System.setProperty("apple.awt.showGrowBox", "false");
        System.setProperty("apple.awt.brushMetalLook", "true");
    }

    @InternalUseOnly(value="This has always been might for internal use only.")
    public static boolean isNeXtOpt() {
        ShellParent parent = Shell.currentShell.parent;
        return parent != null && parent.getClass().getName().equals("nxm.sys.libxm.XmShellParent");
    }

    @InternalUseOnly(value="Since initial version")
    public static boolean isWebStart() {
        return currentShell != null && Shell.currentShell.parent instanceof Webstart;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public static boolean isWindows() {
        return osname.contains("Windows");
    }

    public static boolean isUsingNmClassLoader() {
        return nmClassLoader != null;
    }

    static void updateFromClassLoader(Table cpTable, URL url) {
        String newClassloaderCP = null;
        if (loader instanceof URLClassLoader) {
            newClassloaderCP = StringUtil.join(((URLClassLoader)loader).getURLs(), ",");
        } else if (url != null) {
            newClassloaderCP = cpTable.getS("_CURRENT_", "") + "," + url;
        }
        if (newClassloaderCP != null) {
            cpTable.put("_CURRENT_", (Object)newClassloaderCP, 16);
        }
    }

    public static void addToClasspath(String cp) {
        if (cp == null) {
            return;
        }
        String[] urls = StringUtil.COMMA_REGEX.split(cp);
        Shell.addToClasspath(urls);
    }

    public static void addToClasspath(String[] cpEntries) {
        if (cpEntries == null) {
            return;
        }
        for (String urlstr : cpEntries) {
            if (StringUtil.isEmpty(urlstr) || (urlstr = urlstr.trim()).length() == 0) continue;
            try {
                if (urlstr.indexOf(58) > 1) {
                    Shell.addToClasspath(new URI(urlstr).toURL());
                    continue;
                }
                Shell.addToClasspath(new File(urlstr));
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new MidasException("ERROR: Unable to add url='" + urlstr + "' to classpath.", e);
            }
        }
    }

    public static void addToClasspath(File file) {
        try {
            Shell.addToClasspath(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new MidasException("ERROR: Unable to add file='" + file + "' to classpath.", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addToClasspath(URL url) {
        if (Shell.isUsingNmClassLoader()) {
            try {
                nmClassLoaderAddUrl.invoke((Object)nmClassLoader, url);
                if (options == null) return;
                Shell.updateFromClassLoader(options.getTable("CLASSPATH"), url);
                return;
            }
            catch (Exception e) {
                throw new MidasException("ERROR: Unable to add '" + url + "' to classpath.", e);
            }
        } else {
            Shell.updateFromClassLoader(options.getTable("CLASSPATH"), url);
        }
    }

    public static void addOptToClasspath(String opt) {
        Shell.addOptToClasspath(opt, false);
    }

    public static void addOptToClasspath(String opt, boolean save) {
        String optPath;
        opt = opt.toUpperCase();
        String[] elements = Shell.getClasspathFor(opt);
        Table cpTable = options.getTable("CLASSPATH");
        int ii = 0;
        for (String element : elements) {
            Shell.addToClasspath(element);
            if (!save) continue;
            String key = opt + "_" + Integer.toString(ii);
            cpTable.put(key, (Object)element, 16);
            ++ii;
        }
        if (ii > 0 && (optPath = options.getS(opt)) != null) {
            OptionTree.addedToPath(opt, optPath);
        }
    }

    void addPathToClasspath(String pathstr) {
        String[] path;
        for (String opt : path = pathstr.split(",")) {
            if ((opt = opt.trim()).length() == 0) continue;
            Shell.addOptToClasspath(opt, true);
        }
    }

    public static String[] getClasspathFor(String opt) {
        ArrayList<String> elements = new ArrayList<String>();
        String root = options.getString(opt.toUpperCase());
        String[] jars = OptionTree.getJars(opt);
        if (root != null && !root.equals(Shell.getNmRoot())) {
            elements.add(root.toString());
        }
        if (jars != null) {
            elements.addAll(Arrays.asList(jars));
        }
        return elements.toArray(new String[0]);
    }

    public Theme getTheme() {
        if (theme != null) {
            return theme;
        }
        String name = (String)this.M.results.get("ENV.THEME");
        if (name == null) {
            name = "GEAR3";
        }
        theme = Theme.getTheme(name);
        return theme;
    }

    private void initCompletionExcludedAuxes() {
        String excludeList = Shell.getProperty("COMPLETIONAUXEXCLUDE");
        this.setCompletionExcludedAuxes(excludeList);
    }

    public void setCompletionExcludedAuxes(String excludeList) {
        if (excludeList != null) {
            excludeList = StringUtil.stripQuotes(excludeList);
            StringBuilder sb = new StringBuilder("|");
            Parser parsedList = new Parser(excludeList, '|', true);
            for (String aux : parsedList.getArray(0)) {
                if (aux == null || aux.length() <= 0) continue;
                sb.append(aux).append('|');
            }
            this.M.results.put("AUX._COMPLETIONAUXEXCLUDE_", (Object)sb, 16);
        }
    }

    public String getExcludedAuxes() {
        return this.M.results.getS("AUX._COMPLETIONAUXEXCLUDE_");
    }

    public boolean isExcludedAux(String auxName) {
        String excludeList = this.M.results.getS("AUX._COMPLETIONAUXEXCLUDE_", null);
        if (excludeList == null || excludeList.length() == 0) {
            return false;
        }
        auxName = auxName.toUpperCase();
        Parser parsedList = new Parser(excludeList, '|', true);
        for (String aux : parsedList.getArray(0)) {
            if (!aux.equals(auxName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Midas getMidas() {
        return this.M;
    }

    @InternalUseOnly(value="Since added in NeXtMidas 3.5.2")
    static Shell setCurrentShell(Shell shell) {
        Shell prevShell = currentShell;
        currentShell = shell;
        return prevShell;
    }

    public static void checkAndSetInterrupt(Midas M) {
        if (M.terminal.getInterrupt() > 0) {
            if (M.macro != null) {
                M.macro.state = 10;
            }
            M.terminal.setInterrupt(0);
        }
    }

    public static String[] getKnownOptionTrees() {
        String[] options = null;
        try {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return new File(dir, name).isDirectory();
                }
            };
            options = new File(JAVADOC_PATH).list(filter);
        }
        catch (Exception filter) {
            // empty catch block
        }
        if (options == null) {
            options = StringUtil.EMPTY_STRING_ARRAY;
        }
        for (int i = 0; i < options.length; ++i) {
            options[i] = options[i].toUpperCase();
        }
        return options;
    }

    public static char[] passwdFromGUI(String message) {
        if (Shell.isHeadless()) {
            return null;
        }
        int messageType = 3;
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(2, 0));
        JLabel jl = new JLabel(message);
        JPasswordField pf = new JPasswordField();
        jp.add(jl);
        jp.add(pf);
        int result = JOptionPane.showConfirmDialog(null, jp, "Password Requested", 2, messageType);
        String userPwd = null;
        if (result == 0) {
            userPwd = new String(pf.getPassword());
        }
        return userPwd == null ? null : userPwd.toCharArray();
    }

    public static Object createPopupWithSelections(int messageType, String title, String message, Object[] choices) {
        if (Shell.isHeadless()) {
            return null;
        }
        return JOptionPane.showInputDialog(null, message, title, messageType, null, choices, 0);
    }

    static {
        options = new Table(6);
        privs = 0;
        noExternalCmds = false;
        loadedLibraries = new HashSet<String>();
        urlNeXtMidas = "";
        gradleBuildCommand = false;
        jvmHangWorkaround = false;
        nxmLoader = Shell.class.getClassLoader();
        String osarch = System.getProperty("os.arch", "unknown");
        osname = System.getProperty("os.name", "unknown");
        javaversion = System.getProperty("java.version", "0.0.0");
        javaMajorVersion = Shell.calcJavaMajorVersion();
        String osVersion = System.getProperty("os.version", "unknown");
        iscentos7 = osVersion.contains("el7");
        String tmp = osname.toLowerCase();
        boolean isVMS = tmp.contains("vms");
        boolean isWin = tmp.contains("win");
        ostag = isWin ? "win" : (isVMS ? "vms" : (osarch.contains("arm") ? "arm" : (tmp.contains("linux") ? "lin" : (tmp.contains("solaris") ? "sol" : (tmp.contains("sun") ? "sol" : (tmp.contains("sgi") ? "sgi" : (tmp.contains("hp-ux") ? "hpux" : (tmp.contains("mac") ? "osx" : (tmp.contains("freebsd") ? "bsd" : tmp.substring(0, 3))))))))));
        ostype = isWin ? "DOS" : (isVMS ? "VMS" : "UNIX");
        osrep = isVMS ? "VAX" : (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? "IEEE" : "EEEI");
        rep = (byte)osrep.charAt(0);
        urlNeXtMidas = FileUtil.changePathSeparator(nxmLoader.getResource("nxm/sys/lib/NeXtMidas.class").toString(), "/");
        gradleBuildCommand = urlNeXtMidas.contains("build/classes/java/main/");
        panelCounter = new AtomicInteger(1);
    }
}

