/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DbfFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.GeodeticUtil;
import nxm.sys.lib.Position;
import nxm.sys.lib.ShapeFileModSwapInterface;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;

public class ShapeFile
extends BaseFile
implements ShapeFileModSwapInterface {
    public static final int FILECODE = 9994;
    @Deprecated
    public static final int SHAPEFILE_ID = 9994;
    public static final int VERSION = 1000;
    public static final int NULLSHAPE = 0;
    public static final int POINT = 1;
    public static final int POLYLINE = 3;
    public static final int POLYGON = 5;
    public static final int MULTIPOINT = 8;
    public static final int POINTZ = 11;
    public static final int POLYLINEZ = 13;
    public static final int MULTIPOINTZ = 18;
    public static final int POINTM = 21;
    public static final int POLYLINEM = 23;
    public static final int POLYGONM = 25;
    public static final int MULTIPOINTM = 28;
    public static final int MULTIPATCH = 31;
    @Deprecated
    public static final int ARC = 3;
    @Deprecated
    public static final int ARC_M = 23;
    private int fileCode;
    private int fileLength;
    private int fileOffset;
    private int version;
    public int shapeType;
    public double x1;
    public double y1;
    public double x2;
    public double y2;
    private double timecode;
    public DbfFile dbf;
    protected List<Shape> allShapes;
    protected byte[] ghb = new byte[1024];

    public ShapeFile() {
    }

    @Deprecated
    public ShapeFile(Object ref, Object filename) {
        if (ref instanceof MidasReference) {
            this.init((MidasReference)ref, filename);
        } else {
            this.init(Convert.ref2Midas(ref), filename);
        }
    }

    public ShapeFile(MidasReference ref, Object filename) {
        this.init(ref, filename);
    }

    @Override
    public String toString() {
        String str = "ShapeFile ";
        if (this.io != null) {
            str = str + this.io.getTypeString();
        }
        str = str + " Resource";
        return str;
    }

    @Override
    public void connect(int mode) {
    }

    @Override
    public Data getDataBuffer(int size) {
        return null;
    }

    @Override
    public int getType() {
        return this.fileCode;
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public int read(Data data, int ndo) {
        return -1;
    }

    @Override
    public String listHeader() {
        String list3 = "ShapeFile   :  " + this.getURL() + "\nCode        :  " + this.fileCode + "\nVersion     :  " + this.version + "\nLength      :  " + this.fileLength + "\nSize        :  " + this.getSize() + " bytes\nType        :  " + this.getShapeType() + "\nX1,X2       :  (" + this.x1 + "," + this.x2 + ")\nY1,Y2       :  (" + this.y1 + "," + this.y2 + ")\nDB File     :  " + (this.dbf == null ? null : this.dbf.getName()) + " (exists=" + (this.dbf == null ? null : Boolean.valueOf(this.dbf.isOpen())) + ")\nComment     :  " + this.getComment() + "\n";
        return list3;
    }

    public String getTypeString() {
        return this.getShapeType();
    }

    public String getShapeType() {
        return ShapeFile.getShapeType(this.shapeType, "unknown");
    }

    public static String getShapeType(int type) {
        return ShapeFile.getShapeType(type, null);
    }

    private static String getShapeType(int type, String def) {
        String str = def;
        switch (type) {
            case 0: {
                str = "NullShape";
                break;
            }
            case 1: {
                str = "Point";
                break;
            }
            case 3: {
                str = "PolyLine";
                break;
            }
            case 5: {
                str = "Polygon";
                break;
            }
            case 8: {
                str = "MultiPoint";
                break;
            }
            case 11: {
                str = "PointZ";
                break;
            }
            case 13: {
                str = "PolyLineZ";
                break;
            }
            case 18: {
                str = "MultiPointZ";
                break;
            }
            case 21: {
                str = "PointM";
                break;
            }
            case 23: {
                str = "PolyLineM";
                break;
            }
            case 25: {
                str = "PolygonM";
                break;
            }
            case 28: {
                str = "MultiPointM";
                break;
            }
            case 31: {
                str = "MultiPatch";
            }
        }
        return str;
    }

    @Override
    public String getFormat() {
        return "SD";
    }

    @Override
    public double getStart() {
        return 0.0;
    }

    @Override
    public double getDelta() {
        return 1.0;
    }

    @Override
    public int getUnits() {
        return 0;
    }

    @Override
    public double getXStart() {
        return 0.0;
    }

    @Override
    public double getXDelta() {
        return 1.0;
    }

    @Override
    public int getXUnits() {
        return 0;
    }

    @Override
    public int getXFrame() {
        return 1;
    }

    @Override
    public double getYStart() {
        return 0.0;
    }

    @Override
    public double getYDelta() {
        return 1.0;
    }

    @Override
    public int getYUnits() {
        return 1;
    }

    @Override
    public int getYFrame() {
        return 1;
    }

    @Override
    public double getTimeAt(double offset) {
        return this.timecode;
    }

    @Deprecated
    public void setFormat(String value) {
        Shell.warning("ShapeFile: setFormat(v) not implemented");
    }

    @Deprecated
    public void setXStart(double value) {
        Shell.warning("ShapeFile: setXStart(v) not implemented");
    }

    @Deprecated
    public void setXDelta(double value) {
        Shell.warning("ShapeFile: setXDelta(v) not implemented");
    }

    @Deprecated
    public void setXUnits(int value) {
        Shell.warning("ShapeFile: setXUnits(v) not implemented");
    }

    @Deprecated
    public void setXFrame(int value) {
        Shell.warning("ShapeFile: setXFrame(v) not implemented");
    }

    @Deprecated
    public void setYStart(double value) {
        Shell.warning("ShapeFile: setYStart(v) not implemented");
    }

    @Deprecated
    public void setYDelta(double value) {
        Shell.warning("ShapeFile: setYDelta(v) not implemented");
    }

    @Deprecated
    public void setYUnits(int value) {
        Shell.warning("ShapeFile: setYUnits(v) not implemented");
    }

    @Deprecated
    public void setYFrame(int value) {
        Shell.warning("ShapeFile: setYFrame(v) not implemented");
    }

    public void setTimeCode(double value) {
        this.timecode = value;
    }

    @Override
    public boolean open() {
        if (!super.open()) {
            return false;
        }
        FileName shpName = this.getFileName();
        String dbfName = shpName.getPath() + shpName.getRoot() + ".dbf";
        byte[] hb = new byte[1024];
        ArrayList<Shape> all = new ArrayList<Shape>(1024);
        this.read(hb, 0, 100);
        Convert.swap4(hb, 0, 1);
        Convert.swap4(hb, 24, 1);
        this.fileCode = Convert.unpackL(hb, 0, (byte)69);
        this.fileLength = Convert.unpackL(hb, 24, (byte)69);
        this.version = Convert.unpackL(hb, 28, (byte)69);
        this.shapeType = Convert.unpackL(hb, 32, (byte)69);
        this.x1 = Convert.unpackD(hb, 36, (byte)69);
        this.y1 = Convert.unpackD(hb, 44, (byte)69);
        this.x2 = Convert.unpackD(hb, 52, (byte)69);
        this.y2 = Convert.unpackD(hb, 60, (byte)69);
        this.fileOffset = 50;
        int i = 0;
        while (this.fileOffset < this.fileLength) {
            Shape shape = new Shape(this, i);
            this.fileOffset += shape.getLength();
            all.add(shape);
            ++i;
        }
        this.allShapes = Collections.unmodifiableList(all);
        this.dbf = new DbfFile(this.M, (Object)dbfName);
        this.dbf.open(65);
        if (this.version != 1000) {
            Shell.getSharedMidasContext().warning("ShapeFile: Shape file " + this.getName() + " has Version=" + this.version + " but only Version=" + 1000 + " is supported by ShapeFile.");
        }
        if (this.fileCode != 9994) {
            Shell.getSharedMidasContext().warning("ShapeFile: Shape file " + this.getName() + " has FileCode=" + this.fileCode + " but only FileCode=" + 9994 + " is supported by ShapeFile.");
        }
        return true;
    }

    @Override
    public void close() {
        super.close();
        if (this.dbf != null) {
            this.dbf.close();
        }
    }

    public Shape[] getShapes() {
        List<Shape> all = this.getAllShapes();
        return all.toArray(new Shape[all.size()]);
    }

    public List<Shape> getAllShapes() {
        return this.allShapes;
    }

    public List<Shape> getShapesContaining(double alt, double lat, double lon) {
        return this.getShapesContaining(Position.fromGeo(alt, lat, lon));
    }

    public List<Shape> getShapesContaining(Position p) {
        return this.getAllShapes().stream().filter(s -> s.contains(p)).collect(Collectors.toList());
    }

    public List<Shape> getShapesNear(double alt, double lat, double lon, double radius) {
        return this.getShapesNear(Position.fromGeo(alt, lat, lon), radius);
    }

    public List<Shape> getShapesNear(Position p, double radius) {
        return this.getAllShapes().stream().filter(s -> s.isNear(p, radius)).collect(Collectors.toList());
    }

    public static class Shape {
        private ShapeFile sf;
        private final int index;
        private Color color;
        private final List<double[]> lineStrings;
        @Deprecated
        public double x1;
        @Deprecated
        public double x2;
        @Deprecated
        public double y1;
        @Deprecated
        public double y2;
        @Deprecated
        public int recordNumber;
        @Deprecated
        public int contentLength;
        @Deprecated
        public int shapeType;
        @Deprecated
        public int numParts;
        @Deprecated
        public int numPoints;
        @Deprecated
        public int[] parts;
        @Deprecated
        public double[] points;
        @Deprecated
        public int maxPartLength;
        @Deprecated
        public String label;

        protected Shape(ShapeFile sf, int index) {
            this.sf = Objects.requireNonNull(sf);
            this.index = index;
            this.lineStrings = new ArrayList<double[]>(128);
            this.readFromFile();
        }

        @InternalUseOnly(value="This method should be marked 'protected' as it only used when reading from a shape file")
        public int getLength() {
            return 4 + this.contentLength;
        }

        @Deprecated
        public int readFrom(ShapeFile sf) {
            this.sf = sf;
            this.readFromFile();
            return this.getLength();
        }

        protected void readFromFile() {
            byte[] hb = new byte[1024];
            this.sf.read(hb, 0, 12);
            Convert.swap4(hb, 0, 2);
            this.recordNumber = Convert.unpackL(hb, 0, (byte)69);
            this.contentLength = Convert.unpackL(hb, 4, (byte)69);
            this.shapeType = Convert.unpackL(hb, 8, (byte)69);
            switch (this.shapeType) {
                case 1: {
                    this.sf.read(hb, 0, 16);
                    this.x1 = Convert.unpackD(hb, 0, (byte)69);
                    this.y1 = Convert.unpackD(hb, 8, (byte)69);
                    this.x2 = this.x1;
                    this.y2 = this.y1;
                    this.maxPartLength = 1;
                    break;
                }
                case 3: 
                case 5: {
                    int i;
                    this.sf.read(hb, 0, 40);
                    this.x1 = Convert.unpackD(hb, 0, (byte)69);
                    this.y1 = Convert.unpackD(hb, 8, (byte)69);
                    this.x2 = Convert.unpackD(hb, 16, (byte)69);
                    this.y2 = Convert.unpackD(hb, 24, (byte)69);
                    this.numParts = Convert.unpackL(hb, 32, (byte)69);
                    this.maxPartLength = this.numPoints = Convert.unpackL(hb, 36, (byte)69);
                    this.parts = new int[this.numParts];
                    this.points = new double[this.numPoints * 2];
                    int bufLen = Math.max(this.numParts * 4, this.numPoints * 16);
                    if (bufLen > hb.length) {
                        hb = new byte[bufLen];
                    }
                    this.sf.read(hb, 0, this.numParts * 4);
                    for (i = 0; i < this.numParts; ++i) {
                        this.parts[i] = Convert.unpackL(hb, i * 4, (byte)69);
                    }
                    this.sf.read(hb, 0, this.numPoints * 16);
                    for (i = 0; i < this.numPoints * 2; ++i) {
                        this.points[i] = Convert.unpackD(hb, i * 8, (byte)69);
                    }
                    if (this.numParts > 0) {
                        this.maxPartLength = this.numPoints - this.parts[this.numParts - 1];
                    }
                    int n = 0;
                    for (int i2 = 0; i2 < this.numParts - 1; ++i2) {
                        int nPoints = this.parts[i2 + 1] - this.parts[i2];
                        if (nPoints > this.maxPartLength) {
                            this.maxPartLength = nPoints;
                        }
                        this.lineStrings.add(Arrays.copyOfRange(this.points, n, n + nPoints * 2));
                        n += nPoints * 2;
                    }
                    this.lineStrings.add(Arrays.copyOfRange(this.points, n, this.points.length));
                    break;
                }
                case 8: {
                    break;
                }
                case 23: {
                    break;
                }
                default: {
                    int nullread = (this.contentLength + 4) * 2 - 12;
                    this.sf.read(hb, 0, nullread);
                }
            }
        }

        public String toString() {
            return "Shape: index=" + this.index + " recordNumber=" + this.recordNumber + " type=" + ShapeFile.getShapeType(this.shapeType) + " numParts=" + this.numParts + " lineStringCount=" + this.lineStrings.size() + " dataTable=" + this.getDataTable();
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public Table getDataTable() {
            if (this.sf.dbf.isOpen() && this.index >= 0) {
                return this.sf.dbf.getDataTable(this.index);
            }
            return null;
        }

        public boolean contains(Position p) {
            switch (this.shapeType) {
                default: {
                    return false;
                }
                case 5: 
            }
            return this.lineStrings.stream().anyMatch(ls -> GeodeticUtil.insidePolygon(p, 2, ls));
        }

        public boolean isNear(Position p, double radius) {
            switch (this.shapeType) {
                default: {
                    return false;
                }
                case 1: {
                    return GeodeticUtil.computeDistanceMeters(p, Position.fromGeo(0.0, this.y1, this.x1)) <= radius;
                }
                case 3: {
                    return this.lineStrings.stream().anyMatch(ls -> this.isNear(p, radius, (double[])ls));
                }
                case 5: 
            }
            return this.contains(p) || this.lineStrings.stream().anyMatch(ls -> this.isNear(p, radius, (double[])ls));
        }

        private boolean isNear(Position p, double radius, double[] ls) {
            int i;
            double lat0;
            double lon0;
            if (this.contains(p)) {
                return true;
            }
            switch (this.shapeType) {
                default: {
                    throw new AssertionError((Object)("Unexpected shape: " + this.shapeType));
                }
                case 3: {
                    lon0 = ls[0];
                    lat0 = ls[1];
                    i = 1;
                    break;
                }
                case 5: {
                    lon0 = ls[ls.length - 2];
                    lat0 = ls[ls.length - 1];
                    i = 0;
                }
            }
            Position p0 = Position.fromGeo(0.0, lat0, lon0);
            while (i < ls.length) {
                double lon1 = ls[i];
                double lat1 = ls[i + 1];
                Position p1 = Position.fromGeo(0.0, lat1, lon1);
                double hdgP0P1 = Position.computeHeadingPrecise(p0, p1, 0.0);
                double hdgP0P = Position.computeHeadingPrecise(p0, p, 0.0);
                double alphaP0 = hdgP0P1 - hdgP0P;
                double hdgP1P = Position.computeHeadingPrecise(p1, p, 0.0);
                double hdgP1P0 = Position.computeHeadingPrecise(p1, p0, 0.0);
                double alphaP1 = hdgP1P0 - hdgP1P;
                double r = 0.0;
                r = Position.equals(p0, p1, 1.0E-6) ? GeodeticUtil.computeDistanceMeters(p, p0) : (Math.max(Math.abs(alphaP0), Math.abs(alphaP1)) < 90.0 && !Position.equals(p0, p1, 1.0E-6) ? Math.abs(GeodeticUtil.computeDistanceMeters(p, p0) * Math.tan(Math.toRadians(alphaP0))) : Math.min(GeodeticUtil.computeDistanceMeters(p, p0), GeodeticUtil.computeDistanceMeters(p, p1)));
                if (r <= radius) {
                    return true;
                }
                i += 2;
            }
            return false;
        }
    }
}

