/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.EncodedKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Foreign;
import nxm.sys.lib.JarFile;
import nxm.sys.lib.JsonUtilities;
import nxm.sys.lib.LogUtilities;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;

public class SSLUtilities {
    private static final int STATE_INIT = 0;
    private static final int STATE_DONE = 1;
    private static final int STATE_FAILED = -1;
    private static int initState;
    private static String userQuery;
    private static String groupQuery;
    private static Midas midas;
    private static String userDN;
    private static final List<CertInfo> allCertInfo;
    private static final Map<String, String> jsonKeyPaths;
    private static final Method PROVIDER_CONFIGURE;
    private static Level certInfoLogLevel;
    private static KeyStore currentKeyStore;
    private static KeyStore currentTrustStore;
    private static String nssLibsDir;
    private static boolean pkcs11Initialized;
    private static String serverTrustMode;
    private static final String JDK_17_INACCESSIBLEOBJECTEXCEPTION_CLASS_STRING = "class java.lang.reflect.InaccessibleObjectException";
    private static int javaMajVer;

    private SSLUtilities() {
    }

    public static String initSSLContext() {
        return SSLUtilities.initSSLContext(null, null, null, null, null, null, null, null);
    }

    public static String initSSLContext(MidasReference ref, Properties props) {
        return SSLUtilities.initSSLContext(ref, props, null, null, null, null, null, null);
    }

    public static String initSSLContext(MidasReference ref, String propsFileName) {
        return SSLUtilities.initSSLContext(ref, null, propsFileName, null, null, null, null, null);
    }

    public static synchronized String initSSLContext(MidasReference ref, Properties props, String propsFileName, String keyStoreFile, String keyStorePasswd, String keyStorePasswdFile, String trustStoreFile, String trustStorePasswd) {
        return SSLUtilities.initSSLContext(ref, props, propsFileName, keyStoreFile, keyStorePasswd, keyStorePasswdFile, trustStoreFile, trustStorePasswd, false);
    }

    @ProvisionalUseOnly(value="API may change, added for evaluation")
    public static synchronized String initAnyHostNameSSL(MidasReference ref, Properties props, String propsFileName, String keyStoreFile, String keyStorePasswd, String keyStorePasswdFile, String trustStoreFile, String trustStorePasswd) {
        return SSLUtilities.initSSLContext(ref, props, propsFileName, keyStoreFile, keyStorePasswd, keyStorePasswdFile, trustStoreFile, trustStorePasswd, true);
    }

    @InternalUseOnly
    public static synchronized String initSSLContext(MidasReference ref, Properties props, String propsFileName, String keyStoreFile, String keyStorePasswd, String keyStorePasswdFile, String trustStoreFile, String trustStorePasswd, boolean noHostNameVerfication) {
        switch (initState) {
            case 0: {
                break;
            }
            case 1: {
                String serverTrustExtention = serverTrustMode.isEmpty() ? "" : " with server trust mode '" + serverTrustMode + "'";
                throw new IllegalStateException("Initialization already complete for " + SSLUtilities.getUserCN() + serverTrustExtention);
            }
            case -1: {
                throw new IllegalStateException("Initialization failed, leaving JVM in an inconsistent state, need to restart JVM.");
            }
            default: {
                throw new AssertionError((Object)("Illegal state: " + initState));
            }
        }
        try {
            Object jsonKey;
            ArrayList<KeyManager> keyMgrs = new ArrayList<KeyManager>(8);
            ArrayList<TrustManager> trustMgrs = new ArrayList<TrustManager>(8);
            ArrayList<CertInfo> certInfo = new ArrayList<CertInfo>(8);
            Boolean useGUI = null;
            userDN = null;
            midas = Convert.ref2Midas(ref);
            props = SSLUtilities.getProps(props, propsFileName);
            String _keyStoreFile = props.getProperty("SSLUtilities.keyStoreFile");
            String _trustStoreFile = props.getProperty("SSLUtilities.trustStoreFile");
            String _trustStorePasswd = props.getProperty("SSLUtilities.trustStorePasswd");
            String _keyStorePasswdFile = props.getProperty("SSLUtilities.keyStorePasswdFile");
            String _capiEnabled = props.getProperty("SSLUtilities.capiEnabled");
            String _nssEnabled = props.getProperty("SSLUtilities.nssEnabled");
            String pksc11Provider = props.getProperty("SSLUtilities.pksc11Provider");
            String pkcs11Config = props.getProperty("SSLUtilities.pkcs11Config");
            String sslContextType = props.getProperty("SSLUtilities.sslContextType");
            String keyStoreType = props.getProperty("SSLUtilities.keyStoreType");
            String trustStoreType = props.getProperty("SSLUtilities.trustStoreType");
            String keyMgrAlgorithm = props.getProperty("SSLUtilities.keyMgrAlgorithm");
            String trustMgrAlgorithm = props.getProperty("SSLUtilities.trustMgrAlgorithm");
            String certFilterClass = props.getProperty("SSLUtilities.certFilterClass");
            String certSelector = props.getProperty("SSLUtilities.certSelector");
            keyStoreFile = SSLUtilities.applyDefault(keyStoreFile, SSLUtilities.findFile(_keyStoreFile));
            trustStoreFile = SSLUtilities.applyDefault(trustStoreFile, SSLUtilities.findFile(_trustStoreFile));
            keyStorePasswdFile = SSLUtilities.applyDefault(keyStorePasswdFile, SSLUtilities.findFile(_keyStorePasswdFile));
            keyStorePasswd = SSLUtilities.applyDefault(keyStorePasswd, "AUTO");
            trustStorePasswd = SSLUtilities.applyDefault(trustStorePasswd, SSLUtilities.applyDefault(_trustStorePasswd, "AUTO"));
            boolean capiEnabled = SSLUtilities.applyDefault(_capiEnabled, true);
            boolean nssEnabled = SSLUtilities.applyDefault(_nssEnabled, true);
            pksc11Provider = SSLUtilities.applyDefault(pksc11Provider, null);
            sslContextType = SSLUtilities.applyDefault(sslContextType, "TLSv1.2");
            trustStoreType = SSLUtilities.applyDefault(trustStoreType, KeyStore.getDefaultType());
            keyMgrAlgorithm = SSLUtilities.applyDefault(keyMgrAlgorithm, KeyManagerFactory.getDefaultAlgorithm());
            trustMgrAlgorithm = SSLUtilities.applyDefault(trustMgrAlgorithm, TrustManagerFactory.getDefaultAlgorithm());
            certSelector = SSLUtilities.applyDefault(certSelector, "AUTO");
            pkcs11Config = SSLUtilities.findFile(pkcs11Config);
            trustStoreFile = SSLUtilities.findFile(trustStoreFile);
            keyStorePasswdFile = SSLUtilities.findFile(keyStorePasswdFile);
            userQuery = props.getProperty("SSLUtilities.userQuery");
            groupQuery = props.getProperty("SSLUtilities.groupQuery");
            Enumeration<?> propNames = props.propertyNames();
            jsonKeyPaths.clear();
            while (propNames.hasMoreElements()) {
                String key = propNames.nextElement().toString();
                String val = props.getProperty(key);
                if (!key.startsWith("SSLUtilities.responsePath.")) continue;
                jsonKey = key.replaceFirst("SSLUtilities.responsePath.", "");
                jsonKeyPaths.put(((String)jsonKey).toLowerCase(), val);
            }
            String[] loggingValues = new String[]{propsFileName, keyStoreFile, trustStoreFile, keyStorePasswd, trustStorePasswd, keyStorePasswdFile, String.valueOf(capiEnabled), String.valueOf(nssEnabled), pkcs11Config, pksc11Provider, sslContextType, keyStoreType, trustStoreType, keyMgrAlgorithm, trustMgrAlgorithm, certFilterClass, certSelector};
            LogUtilities.log(SSLUtilities.class, midas, certInfoLogLevel, () -> SSLUtilities.logInitializationProperties(loggingValues[0], loggingValues[1], loggingValues[2], loggingValues[3], loggingValues[4], loggingValues[5], loggingValues[6], loggingValues[7], loggingValues[8], loggingValues[9], loggingValues[10], loggingValues[11], loggingValues[12], loggingValues[13], loggingValues[14], loggingValues[15], loggingValues[16]));
            SSLUtilities.tryInitPKCS11(certInfo, keyMgrs, trustMgrs, pksc11Provider, pkcs11Config);
            SSLUtilities.tryInitCAPI(certInfo, keyMgrs, trustMgrs, capiEnabled);
            SSLUtilities.tryInitNSS(certInfo, keyMgrs, trustMgrs, nssEnabled, !StringUtil.isEmpty(nssLibsDir));
            try {
                SSLUtilities.loadKeyStore(certInfo, keyMgrs, capiEnabled, nssEnabled, pksc11Provider, pkcs11Config, keyStoreFile, keyMgrAlgorithm, keyStoreType, certFilterClass, keyStorePasswd, keyStorePasswdFile, certSelector, useGUI);
                if (trustStoreFile != null) {
                    BaseFile truststoreFile = new BaseFile(midas, (Object)trustStoreFile);
                    jsonKey = null;
                    try {
                        InputStream inStreamTrust = truststoreFile.findResource(-1).getInputStream();
                        char[] trustPasswdChars = SSLUtilities.getTrustStorePasswd(trustStoreFile, trustStorePasswd, null);
                        KeyStore ts = KeyStore.getInstance(trustStoreType);
                        ts.load(null);
                        ts.load(inStreamTrust, trustPasswdChars);
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustMgrAlgorithm);
                        tmf.init(ts);
                        currentTrustStore = ts;
                        trustMgrs.addAll(0, Arrays.asList(tmf.getTrustManagers()));
                    }
                    catch (Throwable inStreamTrust) {
                        jsonKey = inStreamTrust;
                        throw inStreamTrust;
                    }
                    finally {
                        if (truststoreFile != null) {
                            if (jsonKey != null) {
                                try {
                                    truststoreFile.close();
                                }
                                catch (Throwable inStreamTrust) {
                                    ((Throwable)jsonKey).addSuppressed(inStreamTrust);
                                }
                            } else {
                                truststoreFile.close();
                            }
                        }
                    }
                }
                SSLContext sslContext = SSLContext.getInstance(sslContextType);
                KeyManager[] _keyMgrs = keyMgrs.toArray(new KeyManager[keyMgrs.size()]);
                TrustManager[] _trustMgrs = trustMgrs.toArray(new TrustManager[trustMgrs.size()]);
                sslContext.init(_keyMgrs, _trustMgrs, null);
                SSLSocketFactory socketFactory = sslContext.getSocketFactory();
                SSLContext.setDefault(sslContext);
                HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
                if (noHostNameVerfication) {
                    HttpsURLConnection.setDefaultHostnameVerifier(new AcceptAllHostNameVerifier());
                }
                new URI("https://example.com").toURL().openConnection();
                HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
                if (noHostNameVerfication) {
                    HttpsURLConnection.setDefaultHostnameVerifier(new AcceptAllHostNameVerifier());
                }
                SSLContext defaultSSLContext = SSLContext.getDefault();
                LogUtilities.log(SSLUtilities.class, midas, certInfoLogLevel, () -> SSLUtilities.logSSLContext(Arrays.toString(_keyMgrs), Arrays.toString(_trustMgrs), sslContext, _keyMgrs, _trustMgrs, socketFactory, defaultSSLContext));
            }
            catch (Exception ex) {
                throw new MidasException("SSL init failed", ex);
            }
            initState = 1;
            if (noHostNameVerfication) {
                serverTrustMode = "ANYHOSTNAME";
            }
            return SSLUtilities.getUserDN();
        }
        catch (Error | RuntimeException e) {
            initState = -1;
            throw e;
        }
    }

    @InternalUseOnly
    public static Properties getProps(Properties props, String propsFileName) {
        if (props != null) {
            if (propsFileName == null) {
                propsFileName = "<props>";
            }
        } else {
            if (propsFileName == null || propsFileName.isEmpty()) {
                propsFileName = System.getProperty("SSLUtilities.properties");
            }
            if (propsFileName == null || propsFileName.isEmpty()) {
                propsFileName = "SSLUtilities.properties";
            }
            if ((props = SSLUtilities.loadPropsFile(propsFileName, true)) == null) {
                ClassLoader cl = SSLUtilities.class.getClassLoader();
                URL propFileUrl = cl.getResource(propsFileName);
                if (propFileUrl == null) {
                    String auxes = Shell.getMidasContext().results.getTable("AUX").toString();
                    throw new MidasException("Properties file '" + propsFileName + "' not found in classpath or Midas path (current aux list:" + auxes + ")");
                }
                propsFileName = propFileUrl.toString();
                props = SSLUtilities.loadPropsFile(propsFileName, false);
            }
        }
        return props;
    }

    @InternalUseOnly
    public static String loadKeyStore(List<CertInfo> certInfo, List<KeyManager> keyMgrs, boolean capiEnabled, boolean nssEnabled, String pksc11Provider, String pkcs11Config, String keyStoreFile, String keyMgrAlgorithm, String keyStoreType, String certFilterClass, String keyStorePasswd, String keyStorePasswdFile, String certSelector, Boolean useGUI) throws Exception {
        KeyStore ks;
        boolean isWindows = Shell.isWindows();
        String keyStoreExtension = new FileName(keyStoreFile).getExt();
        if (keyStoreFile == null || !certInfo.isEmpty()) {
            ks = null;
        } else if (keyStoreExtension.equalsIgnoreCase("pem")) {
            ks = SSLUtilities.readPemFile(keyStoreFile, null).getKeyStore();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyMgrAlgorithm);
            kmf.init(ks, null);
            SSLUtilities.findCertificates(certInfo, kmf, ks, null, capiEnabled & isWindows);
            if (certInfo.isEmpty()) {
                LogUtilities.log(SSLUtilities.class, midas, Level.WARNING, "First PEM cert chain was not valid, switching to code that uses last valid cert and does not load full chain");
                ks = SSLUtilities.readPemFilePreferLast(keyStoreFile, null);
                kmf.init(ks, null);
                SSLUtilities.findCertificates(certInfo, kmf, ks, null, capiEnabled & isWindows);
            }
        } else {
            try (BaseFile privKeyFile = new BaseFile(midas, (Object)keyStoreFile);){
                InputStream inStreamKey = privKeyFile.findResource(-1).getInputStream();
                if (keyStoreType == null || keyStoreType.isEmpty()) {
                    keyStoreType = keyStoreExtension.equalsIgnoreCase("p12") || keyStoreExtension.equalsIgnoreCase("pfx") ? "PKCS12" : (keyStoreExtension.equalsIgnoreCase("jks") ? "JKS" : KeyStore.getDefaultType());
                }
                ks = KeyStore.getInstance(keyStoreType);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyMgrAlgorithm);
                try {
                    KeyStoreSpi keyStoreSpi = SSLUtilities.getKeyStoreSpi(ks);
                    if (keyStoreSpi.getClass().getName().equals("sun.security.pkcs12.PKCS12KeyStore")) {
                        Field entries = keyStoreSpi.getClass().getDeclaredField("entries");
                        Field modifiers = Field.class.getDeclaredField("modifiers");
                        modifiers.setAccessible(true);
                        modifiers.set(entries, entries.getModifiers() & 0xFFFFFFEF);
                        entries.setAccessible(true);
                        entries.set(keyStoreSpi, new EntriesMap());
                    }
                }
                catch (ReflectiveOperationException e) {
                    throw new MidasException("Unable to configure PKCS12 KeyStoreSpi", e);
                }
                catch (RuntimeException e) {
                    if (e.getClass().toString().equals(JDK_17_INACCESSIBLEOBJECTEXCEPTION_CLASS_STRING)) {
                        LogUtilities.log(SSLUtilities.class, midas, Level.WARNING, "findCertificates unable access private fields to work-around duplicates in PKCS12 certificates add this jvm option --add-opens java.base/java.security=ALL-UNNAMED", e);
                    }
                    throw e;
                }
                char[] keyPasswdChars = SSLUtilities.getKeyStorePasswd(keyStoreFile, keyStorePasswd, keyStorePasswdFile);
                ks.load(inStreamKey, keyPasswdChars);
                kmf.init(ks, keyPasswdChars);
                SSLUtilities.findCertificates(certInfo, kmf, ks, keyPasswdChars, capiEnabled & isWindows);
            }
        }
        if (ks != null) {
            currentKeyStore = ks;
        }
        if (certFilterClass != null && !certFilterClass.isEmpty()) {
            CertFilter certFilter = (CertFilter)Class.forName(certFilterClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            certInfo = certFilter.filter(certInfo);
        }
        if (certInfo.size() > 1) {
            switch (certSelector) {
                default: {
                    throw new IllegalArgumentException("Invalid value certSelector='" + certSelector + "'");
                }
                case "FIRST": {
                    certInfo = Collections.singletonList(certInfo.get(0));
                    break;
                }
                case "AUTO": {
                    if (useGUI != null && !useGUI.booleanValue()) {
                        LogUtilities.log(SSLUtilities.class, certInfoLogLevel, "The first certificate is being selected");
                        certInfo = Collections.singletonList(certInfo.get(0));
                        break;
                    }
                }
                case "GUI": {
                    int messageType = 3;
                    String title = "NeXtMidas SSL Initialization";
                    String message = "Select certificate to use";
                    Object[] choices = certInfo.toArray(new CertInfo[certInfo.size()]);
                    Object choice = Shell.createPopupWithSelections(messageType, title, message, choices);
                    certInfo = choice == null ? Collections.singletonList(certInfo.get(0)) : Collections.singletonList((CertInfo)choice);
                }
            }
        }
        if (!certInfo.isEmpty()) {
            keyMgrs.add(new CertKeyManager(certInfo.get((int)0).kmf, certInfo));
            allCertInfo.addAll(certInfo);
            userDN = certInfo.get(0).getUserDN();
        }
        return userDN;
    }

    @ProvisionalUseOnly(value="WARNING: This is dangerous to use!")
    public static synchronized String initInsecureSSL(MidasReference ref, String keyStoreFile, String keyStorePasswd, String keyStorePasswdFile) {
        return SSLUtilities.initInsecureSSL(ref, keyStoreFile, keyStorePasswd, keyStorePasswdFile, null, false);
    }

    @ProvisionalUseOnly(value="WARNING: This is dangerous to use!")
    public static synchronized String initInsecureSSL(MidasReference ref, String keyStoreFile, String keyStorePasswd, String keyStorePasswdFile, String propsFileName, boolean userFromProps) {
        switch (initState) {
            case 0: {
                break;
            }
            case 1: {
                String serverTrustExtention = serverTrustMode.isEmpty() ? "" : " with server trust mode '" + serverTrustMode + "'";
                throw new IllegalStateException("Initialization already complete for " + SSLUtilities.getUserCN() + serverTrustExtention);
            }
            case -1: {
                throw new IllegalStateException("Initialization failed, leaving JVM in an inconsistent state, need to restart JVM.");
            }
            default: {
                throw new AssertionError((Object)("Illegal state: " + initState));
            }
        }
        try {
            ArrayList<KeyManager> keyMgrs = new ArrayList<KeyManager>(8);
            ArrayList<TrustManager> trustMgrs = new ArrayList<TrustManager>(8);
            ArrayList<CertInfo> certInfo = new ArrayList<CertInfo>(8);
            Boolean useGUI = null;
            boolean capiEnabled = !userFromProps;
            boolean nssEnabled = !userFromProps;
            String keyMgrAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            String keyStoreType = null;
            String certFilterClass = null;
            String certSelector = "AUTO";
            if (userFromProps) {
                Properties props = SSLUtilities.getProps(null, propsFileName);
                String _keyStoreFile = props.getProperty("SSLUtilities.keyStoreFile");
                String _keyStorePasswdFile = props.getProperty("SSLUtilities.keyStorePasswdFile");
                keyStoreFile = SSLUtilities.applyDefault(keyStoreFile, SSLUtilities.findFile(_keyStoreFile));
                keyStorePasswdFile = SSLUtilities.applyDefault(keyStorePasswdFile, SSLUtilities.findFile(_keyStorePasswdFile));
                String _capiEnabled = props.getProperty("SSLUtilities.capiEnabled");
                String _nssEnabled = props.getProperty("SSLUtilities.nssEnabled");
                capiEnabled = SSLUtilities.applyDefault(_capiEnabled, false);
                nssEnabled = SSLUtilities.applyDefault(_nssEnabled, false);
                userQuery = props.getProperty("SSLUtilities.userQuery");
                groupQuery = props.getProperty("SSLUtilities.groupQuery");
                Enumeration<?> propNames = props.propertyNames();
                jsonKeyPaths.clear();
                while (propNames.hasMoreElements()) {
                    String key = propNames.nextElement().toString();
                    String val = props.getProperty(key);
                    if (!key.startsWith("SSLUtilities.responsePath.")) continue;
                    String jsonKey = key.replaceFirst("SSLUtilities.responsePath.", "");
                    jsonKeyPaths.put(jsonKey.toLowerCase(), val);
                }
            }
            if (keyStorePasswd == null) {
                keyStorePasswd = "AUTO";
            }
            userDN = null;
            midas = Convert.ref2Midas(ref);
            SSLUtilities.tryInitCAPI(certInfo, keyMgrs, trustMgrs, capiEnabled);
            SSLUtilities.tryInitNSS(certInfo, keyMgrs, trustMgrs, nssEnabled, !StringUtil.isEmpty(nssLibsDir));
            try {
                SSLUtilities.loadKeyStore(certInfo, keyMgrs, capiEnabled, nssEnabled, null, null, keyStoreFile, keyMgrAlgorithm, keyStoreType, certFilterClass, keyStorePasswd, keyStorePasswdFile, certSelector, useGUI);
                TrustManager[] trustAllCerts = SSLUtilities.getAllTrustingTrustManager();
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                KeyManager[] _keyMgrs = keyMgrs.toArray(new KeyManager[keyMgrs.size()]);
                sslContext.init(_keyMgrs, trustAllCerts, null);
                HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(new AcceptAllHostNameVerifier());
                SSLSocketFactory socketFactory = sslContext.getSocketFactory();
                SSLContext.setDefault(sslContext);
                HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
                new URI("https://example.com").toURL().openConnection();
                HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            }
            catch (Exception ex) {
                throw new MidasException("SSL init failed", ex);
            }
            initState = 1;
            serverTrustMode = "INSECURE";
            return SSLUtilities.getUserDN();
        }
        catch (Error | RuntimeException e) {
            initState = -1;
            throw e;
        }
    }

    private static TrustManager[] getAllTrustingTrustManager() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509ExtendedTrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }
        }};
        return trustAllCerts;
    }

    @InternalUseOnly
    public static Properties loadPropsFile(Object propsFileName, boolean optional) {
        block31: {
            Properties props = null;
            int flags = optional ? 97 : 1;
            try (BaseFile propFile = new BaseFile(midas, propsFileName);){
                if (!propFile.exists() && !optional) {
                    throw new MidasException("Properties file not found: " + propFile);
                }
                if (!propFile.open(flags)) break block31;
                try (InputStream in = propFile.getResource().getInputStream();){
                    props = new Properties();
                    props.load(in);
                }
                catch (IOException e) {
                    throw new MidasException("Error loading " + propsFileName, e);
                }
                Enumeration<?> names = props.propertyNames();
                boolean ok = false;
                while (!ok && names.hasMoreElements()) {
                    ok = names.nextElement().toString().startsWith("SSLUtilities.");
                }
                if (!ok) {
                    throw new MidasException("Error loading " + propsFileName + ": File does not contain any of the required SSLUtilities.* keys.");
                }
                Properties properties = props;
                return properties;
            }
        }
        return null;
    }

    private static String logInitializationProperties(String propsFileName, String keyStoreFile, String trustStoreFile, String keyStorePasswd, String trustStorePasswd, String keyStorePasswdFile, String capiEnabled, String nssEnabled, String pkcs11Config, String pksc11Provider, String sslContextType, String keyStoreType, String trustStoreType, String keyMgrAlgorithm, String trustMgrAlgorithm, String certFilterClass, String certSelector) {
        StringBuilder debugStr = new StringBuilder(32768);
        debugStr.append("\n+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
        debugStr.append("Java System Properties:").append(SSLUtilities.toStr(System.getProperties())).append('\n');
        debugStr.append("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
        debugStr.append("SSLUtilities.initSSLContext(..) initializing with:\n");
        debugStr.append("  props              = ").append(propsFileName).append('\n');
        debugStr.append("  keyStoreFile       = ").append(keyStoreFile).append('\n');
        debugStr.append("  trustStoreFile     = ").append(trustStoreFile).append('\n');
        debugStr.append("  keyStorePasswd     = ").append(SSLUtilities.passwdToStr(keyStorePasswd)).append('\n');
        debugStr.append("  trustStorePasswd   = ").append(SSLUtilities.passwdToStr(trustStorePasswd)).append('\n');
        debugStr.append("  keyStorePasswdFile = ").append(keyStorePasswdFile).append('\n');
        debugStr.append("  capiEnabled        = ").append(capiEnabled).append('\n');
        debugStr.append("  nssEnabled         = ").append(nssEnabled).append('\n');
        debugStr.append("  pkcs11Config       = ").append(pkcs11Config).append('\n');
        debugStr.append("  pksc11Provider     = ").append(pksc11Provider).append('\n');
        debugStr.append("  sslContextType     = ").append(sslContextType).append('\n');
        debugStr.append("  keyStoreType       = ").append(keyStoreType).append('\n');
        debugStr.append("  trustStoreType     = ").append(trustStoreType).append('\n');
        debugStr.append("  keyMgrAlgorithm    = ").append(keyMgrAlgorithm).append('\n');
        debugStr.append("  trustMgrAlgorithm  = ").append(trustMgrAlgorithm).append('\n');
        debugStr.append("  certFilterClass    = ").append(certFilterClass).append('\n');
        debugStr.append("  certSelector       = ").append(certSelector).append('\n');
        debugStr.append("  -------------------------------------------------------------------------\n");
        debugStr.append("  userQuery          = ").append(userQuery).append('\n');
        debugStr.append("  groupQuery         = ").append(groupQuery).append('\n');
        debugStr.append("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
        return debugStr.toString();
    }

    private static String logSSLContext(String keyMgrs, String trustMgrs, SSLContext ctx, KeyManager[] _keyMgrs, TrustManager[] _trustMgrs, SSLSocketFactory socketFactory, SSLContext defaultSSLContext) {
        StringBuilder debugStr = new StringBuilder(32768);
        debugStr.append("\n+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
        debugStr.append("SSLUtilities.initSSLContext(..) setting SSL context to use:\n");
        debugStr.append("  _keyMgrs   = ").append(SSLUtilities.toStr(Arrays.toString(_keyMgrs))).append('\n');
        debugStr.append("  _trustMgrs = ").append(SSLUtilities.toStr(Arrays.toString(_trustMgrs))).append('\n');
        debugStr.append("  ctx                                   = ").append(SSLUtilities.toStr(ctx.getProtocol())).append('\n');
        debugStr.append("  socketFactory default cipher suites   = ").append(SSLUtilities.toStr(socketFactory.getDefaultCipherSuites())).append('\n');
        debugStr.append("  socketFactory supported cipher suites = ").append(SSLUtilities.toStr(socketFactory.getSupportedCipherSuites())).append('\n');
        debugStr.append("  SSLContext.getDefault()               = ").append(SSLUtilities.toStr(defaultSSLContext.getProtocol())).append('\n');
        debugStr.append("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
        return debugStr.toString();
    }

    private static boolean applyDefault(String value, boolean def) {
        if (value == null) {
            return def;
        }
        if (value.isEmpty()) {
            return def;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException("Expected 'true' or 'false' but given '" + value + "'");
    }

    private static String applyDefault(String value, String def) {
        if (value == null) {
            return def;
        }
        if (value.isEmpty()) {
            return def;
        }
        return value;
    }

    private static String passwdToStr(String passwd) {
        if (passwd == null) {
            return null;
        }
        switch (passwd) {
            case "": {
                return "";
            }
            case "AUTO": {
                return "AUTO";
            }
            case "NONE": {
                return "NONE";
            }
            case "GUI": {
                return "GUI";
            }
        }
        return "********";
    }

    private static String passwdToStr(char[] passwd) {
        if (passwd == null) {
            return null;
        }
        return SSLUtilities.passwdToStr(new String(passwd));
    }

    private static CharSequence toStr(Object obj) {
        return SSLUtilities.toStr(obj, "\n    ");
    }

    /*
     * WARNING - void declaration
     */
    private static CharSequence toStr(Object obj, String indent) {
        StringBuilder str;
        if (obj == null) {
            return null;
        }
        if (obj instanceof X509Certificate) {
            return ((X509Certificate)((Object)obj)).getSubjectX500Principal().getName();
        }
        if (obj instanceof Certificate) {
            return "non-X509Certificate type=" + ((Certificate)((Object)obj)).getType();
        }
        if (obj instanceof Properties) {
            Enumeration<?> e = ((Properties)((Object)obj)).propertyNames();
            Iterator map = new TreeMap();
            while (e.hasMoreElements()) {
                String string = e.nextElement().toString();
                map.put(string, ((Properties)((Object)obj)).getProperty(string));
            }
            obj = map;
        }
        if (obj instanceof Map) {
            str = new StringBuilder(1024);
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                String key = entry.getKey().toString();
                CharSequence val = SSLUtilities.toStr(entry.getValue());
                str.append(indent).append(key);
                for (int i = key.length(); i < 32; ++i) {
                    str.append(' ');
                }
                str.append(" = ");
                str.append(SSLUtilities.toStr(val, indent + "  "));
            }
            return str;
        }
        if (obj instanceof Iterable) {
            str = new StringBuilder(1024);
            for (Object t : (Iterable)((Object)obj)) {
                str.append(indent).append(SSLUtilities.toStr(t, indent + "  "));
            }
            return str;
        }
        if (obj.getClass().isArray()) {
            void var4_11;
            int len = Array.getLength(obj);
            StringBuilder str2 = new StringBuilder(1024);
            boolean bl = false;
            while (var4_11 < len) {
                str2.append(indent).append(SSLUtilities.toStr(Array.get(obj, (int)var4_11), indent + "  "));
                ++var4_11;
            }
            return str2;
        }
        return ((Object)obj).toString();
    }

    private static char[] getKeyStorePasswd(String keyStoreFile, String keyStorePasswd, String keyStorePasswdFile) {
        if (keyStorePasswdFile != null) {
            return SSLUtilities.passwdFromFile(keyStorePasswdFile);
        }
        if (keyStorePasswd == null) {
            return null;
        }
        switch (keyStorePasswd) {
            case "AUTO": {
                return Shell.passwdFromGUI("Enter password for " + keyStoreFile);
            }
            case "GUI": {
                return Shell.passwdFromGUI("Enter password for " + keyStoreFile);
            }
            case "NONE": {
                return null;
            }
        }
        return keyStorePasswd.toCharArray();
    }

    private static char[] getTrustStorePasswd(String trustStoreFile, String trustStorePasswd, String trustStorePasswdFile) {
        if (trustStorePasswdFile != null) {
            return SSLUtilities.passwdFromFile(trustStorePasswdFile);
        }
        if (trustStorePasswd == null) {
            return null;
        }
        switch (trustStorePasswd) {
            case "AUTO": {
                return null;
            }
            case "GUI": {
                return Shell.passwdFromGUI("Enter password for " + trustStoreFile);
            }
            case "NONE": {
                return null;
            }
        }
        return trustStorePasswd.toCharArray();
    }

    private static String findFile(String fileList) {
        if (fileList == null) {
            return null;
        }
        if ((fileList = fileList.trim()).startsWith("[[") && fileList.endsWith("]]")) {
            return fileList;
        }
        String host = "${HOST}";
        try {
            InetAddress ia = InetAddress.getLocalHost();
            host = ia.getHostName();
            int i = host.indexOf(46);
            if (i > 0) {
                host = host.substring(0, i);
            }
        }
        catch (UnknownHostException e) {
            Shell.printStackTrace("Unable to get host name", e);
        }
        for (String fileName : fileList.split(",")) {
            String fname = fileName.trim().replace("${HOME}", Shell.getProperty("user.home", "${HOME}")).replace("${USER}", Shell.getProperty("user.name", "${USER}")).replace("${HOST}", host);
            if (fname.isEmpty()) continue;
            if (new File(fname).exists()) {
                return fname;
            }
            if (SSLUtilities.class.getClassLoader().getResource(fname) != null) {
                return fname;
            }
            BaseFile bf = new BaseFile(fname);
            String fileUrl = bf.getURL();
            boolean fileExists = bf.exists();
            bf.close();
            if (!fileExists) continue;
            return fileUrl;
        }
        return null;
    }

    @ProvisionalUseOnly(value="This method is experimental and will likely change.")
    public static CharSequence getClientAttributes(String clientDN) {
        SSLUtilities.checkInit();
        Objects.requireNonNull(clientDN, "Client Distinguished Name (DN) must be specified");
        if (StringUtil.isNullOrEmpty(userQuery)) {
            throw new MidasException(" In order to verify a a client's attributes, thethe properties file must define: SSLUtilities.userQuery");
        }
        try {
            String cleanClientDN = clientDN.replace(" ", "%20");
            URL url = new URI(String.format(userQuery, cleanClientDN)).toURL();
            return SSLUtilities.downloadJson(url);
        }
        catch (IOException | URISyntaxException ioe) {
            throw new MidasException("Unable to get client attributes.", ioe);
        }
    }

    @ProvisionalUseOnly(value="This method is experimental and will likely change.")
    public static boolean verifyGroupProject(String clientDN, String group2, String project) {
        SSLUtilities.checkInit();
        if (clientDN == null || group2 == null || project == null) {
            throw new MidasException("In order to verify that a client is a member of the required group, client DN, project, and group must be specified - user DN:" + userDN + " group:" + group2 + " project:" + project);
        }
        if (StringUtil.isNullOrEmpty(groupQuery)) {
            throw new MidasException("In order to verify that a client is a member of the required group, the properties file must define: SSLUtilities.groupQuery");
        }
        String cleanClientDN = clientDN.replace(" ", "%20");
        String cleanProject = project.replace(" ", "%20");
        try {
            URL url = new URI(String.format(groupQuery, cleanClientDN, cleanProject)).toURL();
            CharSequence jsonCharSeq = SSLUtilities.downloadJson(url);
            String projectJsonKeyPath = jsonKeyPaths.get("project_group");
            String groupValue = String.format("cn=%s", group2);
            boolean isInGroup = SSLUtilities.jsonObjHasAttribute(jsonCharSeq, groupValue, projectJsonKeyPath, true);
            return isInGroup;
        }
        catch (IOException | URISyntaxException ioe) {
            throw new MidasException("ERROR connecting and obtaining project/group info.", ioe);
        }
    }

    @InternalUseOnly
    public static ArrayList<String> validateLocalCerts(String trustStoreFile, String pwTrustStore) {
        return SSLUtilities.validateLocalCerts(trustStoreFile, pwTrustStore, CertificateProperty.DN, false);
    }

    @InternalUseOnly
    public static ArrayList<String> validateLocalCerts(String trustStoreFile, String pwTrustStore, CertificateProperty certProp, boolean verbose) {
        ArrayList<String> names = new ArrayList<String>();
        if (!Shell.isWindows()) {
            LogUtilities.log(SSLUtilities.class, midas, Level.WARNING, "Validating auto-discovered local certificates is only supported in Windows");
            return names;
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("Windows-MY", "SunMSCAPI");
            keyStore.load(null, null);
            return SSLUtilities.validateCerts(trustStoreFile, pwTrustStore, keyStore, certProp, verbose);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            if (verbose) {
                LogUtilities.log(SSLUtilities.class, midas, Level.INFO, "Exception loading keystore with local certificates", e);
            }
            return names;
        }
    }

    @InternalUseOnly
    public static ArrayList<String> validateCerts(String trustStoreFile, String pwTrustStore, KeyStore keyStore, CertificateProperty certProp, boolean verbose) {
        ArrayList<X509TrustManager> trustMgrs;
        block16: {
            char[] trustpw = pwTrustStore == null ? null : pwTrustStore.toCharArray();
            trustMgrs = new ArrayList<X509TrustManager>(8);
            if (trustStoreFile != null) {
                try (BaseFile truststoreFile = new BaseFile(midas, (Object)trustStoreFile);){
                    InputStream inStreamTrust = truststoreFile.findResource(-1).getInputStream();
                    KeyStore ts = KeyStore.getInstance(KeyStore.getDefaultType());
                    ts.load(null);
                    ts.load(inStreamTrust, trustpw);
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                    tmf.init(ts);
                    for (TrustManager tm : tmf.getTrustManagers()) {
                        if (!(tm instanceof X509TrustManager)) continue;
                        trustMgrs.add((X509TrustManager)tm);
                    }
                }
                catch (IOException | GeneralSecurityException e) {
                    if (!verbose) break block16;
                    LogUtilities.log(SSLUtilities.class, midas, Level.INFO, "Exception loading truststore when validating certificates", e);
                }
            }
        }
        return SSLUtilities.validateCerts(trustMgrs, keyStore, certProp, verbose);
    }

    @InternalUseOnly
    public static ArrayList<String> validateCerts(List<X509TrustManager> trustMgrs, KeyStore keyStore, CertificateProperty certProp, boolean verbose) {
        ArrayList<String> properties;
        block15: {
            properties = new ArrayList<String>();
            try {
                Enumeration<String> aliases = keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    Certificate cert;
                    String logMsg = "";
                    String alias = aliases.nextElement();
                    if (verbose) {
                        logMsg = logMsg + " alias: " + alias;
                    }
                    if (!((cert = keyStore.getCertificate(alias)) instanceof X509Certificate)) continue;
                    String name = ((X509Certificate)cert).getSubjectX500Principal().getName();
                    if (verbose) {
                        logMsg = logMsg + " DN: " + name;
                    }
                    Certificate[] chain = keyStore.getCertificateChain(alias);
                    ArrayList<X509Certificate> list509 = new ArrayList<X509Certificate>();
                    for (int i = 0; i < chain.length; ++i) {
                        if (!(chain[i] instanceof X509Certificate)) continue;
                        list509.add((X509Certificate)chain[i]);
                    }
                    X509Certificate[] chain509 = list509.toArray(new X509Certificate[0]);
                    for (X509TrustManager trustMgr : trustMgrs) {
                        block14: {
                            try {
                                String property;
                                switch (certProp) {
                                    case ALIAS: {
                                        property = alias;
                                        break;
                                    }
                                    case DN: {
                                        property = name;
                                        break;
                                    }
                                    default: {
                                        property = alias;
                                    }
                                }
                                trustMgr.checkClientTrusted(chain509, cert.getType());
                                properties.add(property);
                                if (verbose) {
                                    logMsg = "Passed Certificate Validation" + logMsg;
                                }
                            }
                            catch (Exception e) {
                                if (!verbose) break block14;
                                logMsg = "Failed Certificate Validation" + logMsg;
                            }
                        }
                        if (!verbose) continue;
                        logMsg = logMsg + " trust manager:" + trustMgr;
                        LogUtilities.log(SSLUtilities.class, midas, Level.INFO, logMsg);
                    }
                }
            }
            catch (KeyStoreException e) {
                if (!verbose) break block15;
                LogUtilities.log(SSLUtilities.class, midas, Level.INFO, "Exception validating certificates", e);
            }
        }
        return properties;
    }

    @InternalUseOnly
    public static CertificateProperty getCertificateProperty(String prop) {
        return CertificateProperty.valueOf(prop);
    }

    @ProvisionalUseOnly(value="This method is experimental and will likely change.")
    public static <T> boolean verifyUserAttribute(CharSequence jsonObjCharSeq, String attributeName, T attributeValue) {
        return SSLUtilities.verifyUserAttribute(jsonObjCharSeq, attributeName, attributeValue, false);
    }

    @ProvisionalUseOnly(value="This method is experimental and will likely change.")
    public static <T> boolean verifyUserAttribute(CharSequence jsonObjCharSeq, String attributeName, T attributeValue, boolean allowPartialMatch) {
        String pathToAttr = jsonKeyPaths.get(attributeName.toLowerCase());
        return SSLUtilities.jsonObjHasAttribute(jsonObjCharSeq, attributeValue, pathToAttr, allowPartialMatch);
    }

    @InternalUseOnly
    public static void overideJsonKeyPaths(String jsonPathProps) {
        jsonKeyPaths.clear();
        if (jsonPathProps == null || jsonPathProps.isEmpty()) {
            return;
        }
        Properties props = SSLUtilities.getProps(null, jsonPathProps);
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String key = propNames.nextElement().toString();
            String val = props.getProperty(key);
            if (!key.startsWith("SSLUtilities.responsePath.")) continue;
            String jsonKey = key.replaceFirst("SSLUtilities.responsePath.", "");
            jsonKeyPaths.put(jsonKey.toLowerCase(), val);
        }
    }

    @ProvisionalUseOnly(value="in evaluation")
    public static boolean verifyJsonHasAttributes(CharSequence jsonResponse, Table attrValueTbl, boolean allowPartialMatch) {
        boolean authorized = false;
        boolean noAttributeFailures = true;
        if (attrValueTbl != null) {
            boolean activeKeyPaths = !jsonKeyPaths.isEmpty();
            for (String attr : attrValueTbl) {
                String jsonKeyPath = activeKeyPaths ? jsonKeyPaths.get(attr) : null;
                String pathToAttr = jsonKeyPath == null ? attr : jsonKeyPath;
                boolean thisAttributeIsValid = SSLUtilities.jsonObjHasAttribute(jsonResponse, attrValueTbl.get(attr), pathToAttr, allowPartialMatch);
                LogUtilities.log(SSLUtilities.class, midas, certInfoLogLevel, () -> "SSLUtilities.verifyJsonHasAttributes: attr:" + attr + " value:" + pathToAttr + " valid:" + thisAttributeIsValid);
                if (thisAttributeIsValid) continue;
                noAttributeFailures = false;
                break;
            }
            authorized = noAttributeFailures;
        } else {
            authorized = jsonResponse != null && jsonResponse.length() == 0;
        }
        return authorized;
    }

    @InternalUseOnly
    public static CharSequence downloadJson(URL url) throws IOException {
        int num;
        URLConnection conn = url.openConnection();
        URL.setURLStreamHandlerFactory(null);
        LogUtilities.log(SSLUtilities.class, midas, certInfoLogLevel, "Downloading JSON from {0}", (Object)url);
        conn.setRequestProperty("Accept", "aplication/json, text/json, */*");
        conn.setRequestProperty("X-XSRF-UseProtection", "false");
        conn.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        conn.setUseCaches(false);
        Map<String, List<String>> requestProperties = conn.getRequestProperties();
        boolean usesCaches = conn.getUseCaches();
        conn.connect();
        if (conn instanceof HttpURLConnection) {
            int responseCode = ((HttpURLConnection)conn).getResponseCode();
            LogUtilities.log(SSLUtilities.class, midas, certInfoLogLevel, () -> SSLUtilities.logConnection(url, conn, requestProperties, usesCaches, responseCode));
            if (responseCode != 200) {
                throw new IOException("Connection to " + url + " returned " + responseCode + " (expected " + 200 + ")");
            }
        }
        InputStream in = conn.getInputStream();
        byte[] buf = new byte[32768];
        int off = 0;
        while ((num = in.read(buf, off, buf.length - off)) >= 0) {
            buf = Arrays.copyOf(buf, buf.length + 32768);
            off += num;
        }
        String json = new String(buf, 0, off);
        LogUtilities.log(SSLUtilities.class, midas, certInfoLogLevel, () -> "\n+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n" + json + "\n+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
        return json;
    }

    private static String logConnection(URL url, URLConnection conn, Map<String, List<String>> requestProperties, boolean usesCaches, int responseCode) {
        StringBuilder debugStr = new StringBuilder(32768);
        debugStr.append("\n++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
        debugStr.append("SSLUtilities.downloadJson(..):\n");
        debugStr.append("  url                          = ").append(url).append('\n');
        debugStr.append("  conn                         = ").append(conn).append('\n');
        debugStr.append("  conn.getRequestProperties()  = ").append(requestProperties).append('\n');
        debugStr.append("  conn.getUseCaches()          = ").append(usesCaches).append('\n');
        debugStr.append("  conn.getHeaderFields()       = ").append(conn.getHeaderFields()).append('\n');
        debugStr.append("  conn.getResponseCode()       = ").append(responseCode).append('\n');
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection c = (HttpsURLConnection)conn;
            try {
                debugStr.append("  conn.getCipherSuite()        = ").append(c.getCipherSuite()).append('\n');
                debugStr.append("  conn.getHostnameVerifier()   = ").append(c.getHostnameVerifier()).append('\n');
                debugStr.append("  conn.getLocalPrincipal()     = ").append(c.getLocalPrincipal()).append('\n');
                debugStr.append("  conn.getPeerPrincipal()      = ").append(c.getPeerPrincipal()).append('\n');
                debugStr.append("  conn.getSSLSocketFactory()   = ").append(c.getSSLSocketFactory()).append('\n');
                debugStr.append("  conn.getLocalCertificates()  = ").append(SSLUtilities.toStr(c.getLocalCertificates())).append('\n');
                debugStr.append("  conn.getServerCertificates() = ").append(SSLUtilities.toStr(c.getServerCertificates())).append('\n');
            }
            catch (SSLPeerUnverifiedException ssle) {
                throw new MidasException("ERROR getting HttpsURLConnection information.", ssle);
            }
        }
        debugStr.append("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
        return debugStr.toString();
    }

    @ProvisionalUseOnly(value="This method is experimental and will likely change.")
    public static <T> boolean jsonObjHasAttribute(CharSequence jsonObjStr, T attribute, String pathToAttr, boolean allowPartialMatch) {
        LogUtilities.log(SSLUtilities.class, midas, certInfoLogLevel, "attribute: {0} pathToAttr:{1} partial match allowed:{2}\n json:{3}", attribute, pathToAttr, allowPartialMatch, jsonObjStr);
        if (attribute == null || pathToAttr == null) {
            return false;
        }
        boolean hasAttr = false;
        String[] jsonKeys = pathToAttr.split("[,\\s]+");
        LinkedList<String> listJsonKeys = new LinkedList<String>(Arrays.asList(jsonKeys));
        try {
            LinkedHashMap jsonAsMap = JsonUtilities.fromJSON(LinkedHashMap.class, jsonObjStr);
            String currKey = listJsonKeys.removeFirst();
            Object innerObj = jsonAsMap.get(currKey);
            while (!listJsonKeys.isEmpty() && innerObj instanceof Map) {
                currKey = listJsonKeys.removeFirst();
                innerObj = ((Map)innerObj).get(currKey);
            }
            if (listJsonKeys.isEmpty()) {
                if (innerObj instanceof ArrayList) {
                    ArrayList attrArray = (ArrayList)innerObj;
                    hasAttr = attrArray.contains(attribute);
                    if (!hasAttr & allowPartialMatch && attribute instanceof CharSequence) {
                        for (int arrayIndex = 0; !hasAttr && arrayIndex < attrArray.size(); ++arrayIndex) {
                            Object entry = attrArray.get(arrayIndex);
                            if (entry == null || !(entry instanceof String)) continue;
                            hasAttr = ((String)entry).contains((CharSequence)attribute);
                        }
                    }
                } else {
                    if (innerObj != null && innerObj.getClass() == Boolean.class && attribute.getClass() == String.class && (((String)attribute).equalsIgnoreCase("true") || ((String)attribute).equalsIgnoreCase("false"))) {
                        Boolean boolAttr = Boolean.valueOf((String)attribute);
                        hasAttr = boolAttr.equals(innerObj);
                    } else {
                        hasAttr = attribute.equals(innerObj);
                    }
                    if (!hasAttr & allowPartialMatch && attribute instanceof CharSequence && innerObj instanceof String) {
                        hasAttr = ((String)innerObj).contains((CharSequence)attribute);
                    }
                }
            }
        }
        catch (IllegalArgumentException iae) {
            throw new MidasException("SSLUtilities parameter jsonObjStr must be JSON Object:", iae);
        }
        return hasAttr;
    }

    @InternalUseOnly(value="This is public only to support testing.")
    public static char[] passwdFromFile(String keyStorePasswdFile) {
        String userPwd;
        FileName fnKeyStorePasswdFile = new FileName(keyStorePasswdFile, FileName.FNCase.KeepCase);
        try (TextFile tf = new TextFile(fnKeyStorePasswdFile);){
            tf.open(8193);
            userPwd = tf.read();
            userPwd = userPwd.replaceAll("\\s", "");
        }
        return userPwd.toCharArray();
    }

    public static boolean isInitDone() {
        return initState == 1;
    }

    private static void checkInit() {
        switch (initState) {
            case 0: {
                throw new IllegalStateException("Not initialized.");
            }
            case 1: {
                break;
            }
            case -1: {
                throw new IllegalStateException("Not initialized.");
            }
            default: {
                throw new AssertionError((Object)("Illegal state: " + initState));
            }
        }
    }

    public static String getUserDN() {
        SSLUtilities.checkInit();
        return allCertInfo.isEmpty() ? null : allCertInfo.get(0).getUserDN();
    }

    public static String getUserCN() {
        SSLUtilities.checkInit();
        return allCertInfo.isEmpty() ? null : allCertInfo.get(0).getUserCN();
    }

    public static String getUserAlias(boolean normalize) {
        SSLUtilities.checkInit();
        return allCertInfo.isEmpty() ? null : allCertInfo.get(0).getUserAlias(normalize);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore readPemFilePreferLast(String fileName, String algorithm) {
        if (algorithm == null) {
            algorithm = "RSA";
        }
        try (TextFile tf = new TextFile(null, (Object)fileName);){
            tf.open();
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = null;
            PublicKey publicKey = null;
            PrivateKey privateKey = null;
            LinkedList<String> lines = new LinkedList<String>(Arrays.asList(tf.readAllLines()));
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(null, null);
            Base64.Decoder decoder = Base64.getDecoder();
            int certKeyPair = 0;
            boolean certReady = false;
            boolean privateKeyOccursFirst = false;
            while (!lines.isEmpty()) {
                EncodedKeySpec spec;
                byte[] bytes;
                String line = lines.pop().replaceAll("(\\r|\\n)", "");
                if (!line.startsWith("-----BEGIN ")) continue;
                if (line.endsWith("CERTIFICATE-----")) {
                    bytes = decoder.decode(SSLUtilities.readContent(lines));
                    certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bytes));
                    certReady = true;
                    continue;
                }
                if (line.endsWith("PUBLIC KEY-----")) {
                    bytes = decoder.decode(SSLUtilities.readContent(lines));
                    spec = new X509EncodedKeySpec(bytes);
                    publicKey = kf.generatePublic(spec);
                    continue;
                }
                if (!line.endsWith("PRIVATE KEY-----")) continue;
                bytes = decoder.decode(SSLUtilities.readContent(lines));
                spec = new PKCS8EncodedKeySpec(bytes);
                PrivateKey previousPrivateKey = privateKey;
                privateKey = kf.generatePrivate(spec);
                if (certReady) {
                    ++certKeyPair;
                    if (privateKeyOccursFirst) {
                        SSLUtilities.addPEMCertToKeystore(ks, certificate, publicKey, previousPrivateKey, tf, certKeyPair);
                    } else {
                        SSLUtilities.addPEMCertToKeystore(ks, certificate, publicKey, privateKey, tf, certKeyPair);
                        privateKey = null;
                    }
                    certReady = false;
                    publicKey = null;
                    certificate = null;
                    continue;
                }
                privateKeyOccursFirst = true;
            }
            if (certReady) {
                SSLUtilities.addPEMCertToKeystore(ks, certificate, publicKey, privateKey, tf, ++certKeyPair);
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            throw new MidasException("Error reading " + fileName, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PemFile readPemFile(String fileName, String algorithm) {
        if (algorithm == null) {
            algorithm = "RSA";
        }
        try (TextFile tf = new TextFile(null, (Object)fileName);){
            tf.open();
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(8);
            PublicKey publicKey = null;
            PrivateKey privateKey = null;
            LinkedList<String> lines = new LinkedList<String>(Arrays.asList(tf.readAllLines()));
            Base64.Decoder decoder = Base64.getDecoder();
            String alias = "pem-file-" + tf.getName().getBasename();
            while (!lines.isEmpty()) {
                byte[] bytes;
                String line = lines.pop().replaceAll("(\\r|\\n)", "");
                if (!line.startsWith("-----BEGIN ")) continue;
                if (line.endsWith("CERTIFICATE-----")) {
                    bytes = decoder.decode(SSLUtilities.readContent(lines));
                    certificates.add((X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bytes)));
                    continue;
                }
                if (line.endsWith("PUBLIC KEY-----")) {
                    if (publicKey != null) {
                        LogUtilities.log(Level.WARNING, "Multiple public keys found in " + fileName + ", using the first one");
                        continue;
                    }
                    bytes = decoder.decode(SSLUtilities.readContent(lines));
                    publicKey = kf.generatePublic(new X509EncodedKeySpec(bytes));
                    continue;
                }
                if (!line.endsWith("PRIVATE KEY-----")) continue;
                if (publicKey != null) {
                    LogUtilities.log(Level.WARNING, "Multiple private keys found in " + fileName + ", using the first one");
                    continue;
                }
                bytes = decoder.decode(SSLUtilities.readContent(lines));
                privateKey = kf.generatePrivate(new PKCS8EncodedKeySpec(bytes));
            }
            X509Certificate[] certChain = SSLUtilities.buildCertChain(fileName, certificates);
            PemFile pemFile = new PemFile(fileName, alias, certChain, publicKey, privateKey);
            return pemFile;
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading " + fileName, e);
        }
    }

    private static X509Certificate[] buildCertChain(String fileName, Collection<X509Certificate> certs) {
        ArrayList chains = new ArrayList(certs.size());
        for (X509Certificate c : certs) {
            LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
            chains.add(linkedList);
            linkedList.add(c);
        }
        block1: for (int i = 0; i < chains.size(); ++i) {
            LinkedList chainI = (LinkedList)chains.get(i);
            if (chainI == null) continue;
            X500Principal x500Principal = ((X509Certificate)chainI.getFirst()).getSubjectX500Principal();
            X500Principal issI = ((X509Certificate)chainI.getLast()).getIssuerX500Principal();
            for (int j = i + 1; j < chains.size(); ++j) {
                LinkedList chainJ = (LinkedList)chains.get(j);
                if (chainJ == null) continue;
                X500Principal subJ = ((X509Certificate)chainJ.getFirst()).getSubjectX500Principal();
                X500Principal issJ = ((X509Certificate)chainJ.getLast()).getIssuerX500Principal();
                if (issI.equals(subJ)) {
                    chainJ.addAll(0, chainI);
                    chains.set(i, null);
                    continue block1;
                }
                if (!issJ.equals(x500Principal)) continue;
                chainJ.addAll(chainI);
                chains.set(i, null);
                continue block1;
            }
        }
        LinkedList first = null;
        for (LinkedList linkedList : chains) {
            if (linkedList == null) continue;
            if (first == null) {
                first = linkedList;
                continue;
            }
            LogUtilities.log(Level.WARNING, "Multiple cert chains found in " + fileName + " trying " + ((X509Certificate)first.getFirst()).getSubjectX500Principal());
        }
        return first == null ? null : first.toArray(new X509Certificate[first.size()]);
    }

    private static void addPEMCertToKeystore(KeyStore ks, X509Certificate certificate, PublicKey publicKey, PrivateKey privateKey, TextFile textFile, int certNum) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException {
        if (certificate != null && publicKey == null) {
            publicKey = certificate.getPublicKey();
        }
        String fileName = textFile.getName().toString();
        Objects.requireNonNull(certificate, "Missing required certificate in " + fileName);
        Objects.requireNonNull(publicKey, "Missing required public key in " + fileName);
        Objects.requireNonNull(privateKey, "Missing required private key in " + fileName);
        char[] password = new char[]{};
        String alias = "pem-file-" + textFile.getName().getBasename();
        if (certNum > 1) {
            alias = alias + "_" + certNum;
        }
        Certificate[] certChain = new Certificate[]{certificate};
        KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(password);
        KeyStore.PrivateKeyEntry pemPrivateKey = new KeyStore.PrivateKeyEntry(privateKey, certChain);
        ks.setEntry(alias, pemPrivateKey, protParam);
    }

    private static String readContent(LinkedList<String> lines) {
        StringBuilder str = new StringBuilder(4096);
        while (!lines.isEmpty()) {
            String line = lines.pop();
            if (line.startsWith("-----END ")) {
                return str.toString().replaceAll("(\\r|\\n)", "");
            }
            str.append(line);
        }
        return str.toString();
    }

    @InternalUseOnly
    public static int tryInitCAPI(List<CertInfo> certInfo, List<KeyManager> keyMgrs, List<TrustManager> trustMgrs, boolean capiEnabled) {
        if (!(capiEnabled && Shell.isWindows() && certInfo.isEmpty())) {
            return -2;
        }
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            KeyStore ks = KeyStore.getInstance("Windows-MY");
            KeyStore ts = KeyStore.getInstance("Windows-ROOT");
            int old = certInfo.size();
            ks.load(null, null);
            ts.load(null, null);
            kmf.init(ks, null);
            tmf.init(ts);
            SSLUtilities.findCertificates(certInfo, kmf, ks, null, true);
            trustMgrs.addAll(Arrays.asList(tmf.getTrustManagers()));
            return certInfo.size() - old;
        }
        catch (Exception e) {
            LogUtilities.log(SSLUtilities.class, midas, Level.SEVERE, "tryInitCAPI: Error initializing SSL Context based on content obtained via Microsoft's CAPI", e);
            return -1;
        }
    }

    @InternalUseOnly
    public static int tryInitNSS(List<CertInfo> certInfo, List<KeyManager> keyMgrs, List<TrustManager> trustMgrs, boolean nssEnabled, boolean includeLibDir) {
        if (!nssEnabled || !certInfo.isEmpty() || pkcs11Initialized) {
            return -2;
        }
        if (StringUtil.isEmpty(nssLibsDir)) {
            includeLibDir = false;
        }
        try {
            String profiles = SSLUtilities.findFile("${HOME}/.mozilla/firefox/profiles.ini");
            if (profiles == null) {
                return -1;
            }
            Table profilesTbl = Table.fromConfigFile(null, profiles);
            String profilePath = null;
            profilePath = SSLUtilities.getSelectedProfilePath(profilesTbl);
            if (profilePath == null) {
                profilePath = SSLUtilities.getProfilePathNamedDefault(profilesTbl);
            }
            if (profilePath == null) {
                return -1;
            }
            File rootDir = new File(profiles).getParentFile();
            File profileDir = new File(rootDir, profilePath);
            String pkcs11Provider = "NSScrypto";
            String pkcs11Config = "name=NSScrypto\nnssDbMode=readOnly\nnssSecmodDirectory=\"" + profileDir + "\"\nattributes=compatibility";
            if (includeLibDir) {
                StringBuilder out = new StringBuilder(80);
                StringBuilder err = new StringBuilder(80);
                int exitCode = Foreign.runInternal("which firefox", out, err);
                if (exitCode != 0) {
                    return -1;
                }
                File firefox = new File(out.toString().trim());
                if (!firefox.exists()) {
                    return -1;
                }
                try {
                    firefox = firefox.getCanonicalFile();
                }
                catch (IOException e) {
                    firefox = firefox.getAbsoluteFile();
                }
                File dir = new File(nssLibsDir);
                File[] nssFiles = dir.listFiles((d, n) -> n.matches("libnss.+[.]so.*"));
                if (nssFiles.length == 0 && (nssFiles = (dir = firefox.getParentFile()).listFiles((d, n) -> n.matches("libnss.+[.]so.*"))).length == 0) {
                    return -1;
                }
                pkcs11Config = pkcs11Config + "\nnssLibraryDirectory=\"" + dir + "\"\n";
            }
            return SSLUtilities.tryInitPKCS11(certInfo, keyMgrs, trustMgrs, pkcs11Provider, pkcs11Config);
        }
        catch (Exception e) {
            LogUtilities.log(SSLUtilities.class, midas, Level.SEVERE, "tryInitCAPI: Error initializing SSL Context based on content obtained via Firefox's NSS", e);
            return -1;
        }
    }

    private static String getSelectedProfilePath(Table profilesTbl) {
        for (String key : profilesTbl.getKeys()) {
            String profilePath;
            Table t = profilesTbl.getTableOrNull(key);
            if (t == null || !t.containsKey("DEFAULT") || !t.getState("DEFAULT") || (profilePath = t.getS("PATH")) == null) continue;
            return profilePath;
        }
        return null;
    }

    private static String getProfilePathNamedDefault(Table profilesTbl) {
        for (String key : profilesTbl.getKeys()) {
            String profilePath;
            Table t = profilesTbl.getTableOrNull(key);
            if (t == null || !t.containsKey("NAME") || !t.getS("NAME").equalsIgnoreCase("default") || (profilePath = t.getS("PATH")) == null) continue;
            return profilePath;
        }
        return null;
    }

    @InternalUseOnly
    public static int tryInitPKCS11(List<CertInfo> certInfo, List<KeyManager> keyMgrs, List<TrustManager> trustMgrs, String pkcs11Provider, String pkcs11Config) {
        if (StringUtil.isEmpty(pkcs11Provider) || StringUtil.isEmpty(pkcs11Config) || !certInfo.isEmpty() || pkcs11Initialized) {
            return -2;
        }
        try {
            Provider provider = Security.getProvider(pkcs11Provider);
            if (provider == null) {
                if (PROVIDER_CONFIGURE != null) {
                    provider = Security.getProvider("SunPKCS11");
                    provider = (Provider)PROVIDER_CONFIGURE.invoke((Object)provider, "--" + pkcs11Config);
                } else {
                    Constructor<?> con;
                    boolean isFileName;
                    Class<?> clazz = Class.forName("sun.security.pkcs11.SunPKCS11");
                    boolean bl = isFileName = !pkcs11Config.contains("=") && !pkcs11Config.contains("\n");
                    if (pkcs11Config.startsWith("[[") && pkcs11Config.endsWith("]]")) {
                        isFileName = false;
                        pkcs11Config = pkcs11Config.substring(2, pkcs11Config.length() - 2).trim().replaceAll(";[ ]*", "\n");
                    }
                    if (!isFileName) {
                        con = clazz.getConstructor(InputStream.class);
                        ByteArrayInputStream in = new ByteArrayInputStream(pkcs11Config.getBytes());
                        provider = (Provider)con.newInstance(in);
                    } else {
                        con = clazz.getConstructor(String.class);
                        provider = (Provider)con.newInstance(pkcs11Config);
                    }
                }
                pkcs11Initialized = true;
                Security.addProvider(provider);
            }
            int old = certInfo.size();
            KeyStore ks = KeyStore.getInstance("PKCS11", provider);
            ks.load(new PasswdFromGUI("Enter password for PKCS11 provider (" + pkcs11Provider + ")"));
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, null);
            SSLUtilities.findCertificates(certInfo, kmf, ks, null, Shell.isWindows());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            trustMgrs.addAll(Arrays.asList(tmf.getTrustManagers()));
            if (ks != null) {
                currentKeyStore = ks;
            }
            return certInfo.size() - old;
        }
        catch (Exception e) {
            LogUtilities.log(SSLUtilities.class, midas, Level.SEVERE, "tryInitPKCS11: Error initializing SSL Context based on PKCS11 content provider", e);
            return -1;
        }
    }

    @InternalUseOnly
    public static boolean isValidDigitalSignature(X509Certificate cert) {
        boolean[] keyUsage = cert.getKeyUsage();
        if (keyUsage == null) {
            return false;
        }
        if (keyUsage.length < 9) {
            return false;
        }
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            return false;
        }
        return keyUsage[0];
    }

    @InternalUseOnly
    public static KeyStoreSpi getKeyStoreSpi(KeyStore ks) throws ReflectiveOperationException {
        Field _keyStoreSpi = ks.getClass().getDeclaredField("keyStoreSpi");
        _keyStoreSpi.setAccessible(true);
        KeyStoreSpi keyStoreSpi = (KeyStoreSpi)_keyStoreSpi.get(ks);
        try {
            Class<?> keyStoreDelegator = Class.forName("sun.security.provider.KeyStoreDelegator");
            if (keyStoreDelegator.isInstance(keyStoreSpi)) {
                Field keystore = keyStoreDelegator.getDeclaredField("keystore");
                keystore.setAccessible(true);
                KeyStoreSpi delegate = (KeyStoreSpi)keystore.get(keyStoreSpi);
                if (delegate != null) {
                    keyStoreSpi = delegate;
                }
            }
        }
        catch (ReflectiveOperationException e) {
            LogUtilities.log(SSLUtilities.class, midas, certInfoLogLevel, "Issue accessing the KeyStoreSPI", e);
        }
        return keyStoreSpi;
    }

    @InternalUseOnly
    public static void findCertificates(List<CertInfo> certInfo, KeyManagerFactory kmf, KeyStore ks, char[] passwd, boolean checkCapi) throws Exception {
        block3: {
            block2: {
                KeyStoreSpi keyStoreSpi;
                KeyStoreSpi keyStoreSpi2 = keyStoreSpi = checkCapi ? SSLUtilities.getKeyStoreSpi(ks) : null;
                if (!checkCapi || !keyStoreSpi.getClass().getName().equals("sun.security.mscapi.KeyStore$MY")) break block2;
                Field _entries = keyStoreSpi.getClass().getEnclosingClass().getDeclaredField("entries");
                _entries.setAccessible(true);
                Object keyStoreSpiEntry = _entries.get(keyStoreSpi);
                if (!(keyStoreSpiEntry instanceof Iterable)) break block3;
                for (Object entry : (Iterable)keyStoreSpiEntry) {
                    Field _certChain = entry.getClass().getDeclaredField("certChain");
                    Field _privateKey = entry.getClass().getDeclaredField("privateKey");
                    Field _alias = entry.getClass().getDeclaredField("alias");
                    _certChain.setAccessible(true);
                    _privateKey.setAccessible(true);
                    _alias.setAccessible(true);
                    X509Certificate[] certChain = (X509Certificate[])_certChain.get(entry);
                    PrivateKey privateKey = (PrivateKey)_privateKey.get(entry);
                    X509Certificate cert = certChain[0];
                    LogUtilities.log(SSLUtilities.class, midas, certInfoLogLevel, "findCertificates if");
                    if (!SSLUtilities.isValidDigitalSignature(cert)) continue;
                    String newAlias = SSLUtilities.getUniqueAlias(certInfo, cert);
                    certInfo.add(new CertInfo(kmf, newAlias, cert, certChain, privateKey));
                }
                break block3;
            }
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate certificate = ks.getCertificate(alias);
                if (!(certificate instanceof X509Certificate)) continue;
                X509Certificate cert = (X509Certificate)certificate;
                LogUtilities.log(SSLUtilities.class, midas, certInfoLogLevel, "findCertificates else valid:{0}", (Object)SSLUtilities.isValidDigitalSignature(cert));
                if (!SSLUtilities.isValidDigitalSignature(cert)) continue;
                PrivateKey privateKey = (PrivateKey)ks.getKey(alias, passwd);
                Certificate[] certChain = ks.getCertificateChain(alias);
                String newAlias = SSLUtilities.getUniqueAlias(certInfo, cert);
                if (certChain == null || privateKey == null) continue;
                certInfo.add(new CertInfo(kmf, newAlias, cert, certChain, privateKey));
            }
        }
    }

    private static String getUniqueAlias(List<CertInfo> certInfo, X509Certificate cert) {
        String subjectDN = cert.getSubjectX500Principal().getName();
        int hash = cert.hashCode();
        String alias = subjectDN + " [" + Integer.toHexString(hash) + "]";
        while (SSLUtilities.getCertInfo(certInfo, alias) != null) {
            alias = subjectDN + " [" + Integer.toHexString(++hash) + "]";
        }
        return alias;
    }

    private static CertInfo getCertInfo(List<CertInfo> certInfo, String alias) {
        for (CertInfo c : certInfo) {
            if (!c.alias.equals(alias)) continue;
            return c;
        }
        return null;
    }

    public static void signJarFile(Object fname) {
        String oldFileName;
        String outFileName;
        String inFileName;
        SSLUtilities.checkInit();
        if (allCertInfo.isEmpty()) {
            throw new IllegalStateException("No certs loaded during init.");
        }
        try {
            inFileName = FileName.toFileName(fname).toLocalFileName();
            outFileName = inFileName + ".part";
            oldFileName = inFileName + ".orig";
        }
        catch (MalformedURLException e) {
            throw new MidasException("Unable to access " + fname, e);
        }
        File inFilePath = new File(inFileName);
        File outFilePath = new File(outFileName);
        File oldFilePath = new File(oldFileName);
        try {
            try (JarFile inFile = new JarFile(null, (Object)inFileName);
                 JarFile outFile = new JarFile(null, (Object)(inFile.getURL() + ".part"));){
                byte[] sfManifestBuf;
                byte[] manifestBuf;
                Object attr;
                inFile.open(1);
                outFile.open(2);
                CertInfo certInfo = allCertInfo.get(0);
                String alias = certInfo.getUserAlias(true);
                byte[] buf = new byte[32768];
                URI tsaURI = null;
                String tsaPolicy = null;
                String keyAlgo = certInfo.privateKey.getAlgorithm();
                boolean keyAlgoDSA = keyAlgo.toUpperCase().endsWith("DSA");
                String dgstAlgo = "SHA-256";
                String sigAlgo = keyAlgoDSA ? "SHA256withDSA" : "SHA256withRSA";
                Signature sig = Signature.getInstance(sigAlgo);
                MessageDigest digest = MessageDigest.getInstance(dgstAlgo);
                Manifest manifest = inFile.manifest;
                Map<String, Attributes> entries = manifest.getEntries();
                String creator = System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")";
                String mfFileName = "META-INF/MANIFEST.MF";
                String sfFileName = "META-INF/" + alias + ".SF";
                String sigFileName = "META-INF/" + alias + (keyAlgoDSA ? ".DSA" : ".RSA");
                Base64.Encoder encoder = Base64.getEncoder();
                if (entries.isEmpty()) {
                    Iterator<String> iter = entries.keySet().iterator();
                    while (iter.hasNext()) {
                        if (inFile.zipFile.getEntry(iter.next()) != null) continue;
                        iter.remove();
                    }
                } else {
                    Object[] attr2 = manifest.getMainAttributes();
                    attr2.putValue("Manifest-Version", "1.0");
                    attr2.putValue("Created-By", creator);
                }
                manifest.getMainAttributes().remove(new Attributes.Name("Created-By"));
                for (Object entry : inFile.getEntries()) {
                    if (entry instanceof JarEntry) {
                        JarEntry je = (JarEntry)entry;
                        if (je.isDirectory() || je.getName().startsWith("META-INF/")) continue;
                        FileName fileName = new FileName("jar:" + inFile.getURL() + "!/" + je.getName(), true);
                        try (BaseFile bf = new BaseFile(null, (Object)fileName);){
                            bf.open();
                            try (InputStream in = bf.getResource().getInputStream();){
                                int numRead;
                                while ((numRead = in.read(buf)) >= 0) {
                                    digest.update(buf, 0, numRead);
                                }
                                String dgst = encoder.encodeToString(digest.digest());
                                attr = entries.get(je.getName());
                                if (attr == null) {
                                    attr = new Attributes();
                                    entries.put(je.getName(), (Attributes)attr);
                                }
                                ((Attributes)attr).putValue(dgstAlgo + "-Digest", dgst);
                                continue;
                            }
                            catch (IOException e) {
                                throw new MidasException("Error reading " + fileName, e);
                            }
                        }
                    }
                    throw new MidasException("Expected JarEntry but found " + entry.getClass() + " in " + inFile.getName());
                }
                try (ByteArrayOutputStream out = new ByteArrayOutputStream(32768);){
                    manifest.write(out);
                    out.flush();
                    out.close();
                    manifestBuf = out.toByteArray();
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                Manifest sfManifest = new Manifest();
                Attributes sfMainAttr = sfManifest.getMainAttributes();
                Map<String, Attributes> sfEntries = sfManifest.getEntries();
                Object mfDigester = SSLUtilities.ManifestDigester_new(manifestBuf);
                Object mainAttr = SSLUtilities.ManifestDigester_get(mfDigester, "Manifest-Main-Attributes", false);
                byte[] manifestDig = SSLUtilities.ManifestDigester_manifestDigest(mfDigester, digest);
                byte[] mainAttrDig = SSLUtilities.ManifestDigester_Entry_digest(mainAttr, digest);
                String manifestDgst = encoder.encodeToString(manifestDig);
                String mainAttrDgst = encoder.encodeToString(mainAttrDig);
                sfMainAttr.putValue("Signature-Version", "1.0");
                sfMainAttr.putValue(dgstAlgo + "-Digest-Manifest-Main-Attributes", mainAttrDgst);
                sfMainAttr.putValue(dgstAlgo + "-Digest-Manifest", manifestDgst);
                sfMainAttr.putValue("Created-By", creator);
                for (String key : manifest.getEntries().keySet()) {
                    attr = SSLUtilities.ManifestDigester_get(mfDigester, key, false);
                    byte[] dig = SSLUtilities.ManifestDigester_Entry_digest(attr, digest);
                    String dgst = encoder.encodeToString(dig);
                    Attributes a = new Attributes();
                    a.putValue(dgstAlgo + "-Digest", dgst);
                    sfEntries.put(key, a);
                }
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream(32768);
                    attr = null;
                    try {
                        sfManifest.write(out);
                        out.flush();
                        out.close();
                        sfManifestBuf = out.toByteArray();
                    }
                    catch (Throwable dig) {
                        attr = dig;
                        throw dig;
                    }
                    finally {
                        if (out != null) {
                            if (attr != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable dig) {
                                    ((Throwable)attr).addSuppressed(dig);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                sig.initSign(certInfo.privateKey);
                sig.update(sfManifestBuf);
                byte[] signature = sig.sign();
                byte[] pkcs7 = null;
                pkcs7 = javaMajVer > 21 ? SSLUtilities.PKCS7_generateSignedData(certInfo.certChain, sfManifestBuf, sigAlgo, "SHA-256", certInfo.privateKey) : SSLUtilities.PKCS7_generateSignedData(signature, certInfo.certChain, sfManifestBuf, sigAlgo, tsaURI, tsaPolicy, "SHA-256");
                try (FileOutputStream dest = new FileOutputStream(outFileName);
                     BufferedOutputStream bos = new BufferedOutputStream(dest);
                     ZipOutputStream out = new ZipOutputStream(bos);){
                    out.putNextEntry(new JarEntry(mfFileName));
                    out.write(manifestBuf);
                    out.closeEntry();
                    out.putNextEntry(new JarEntry(sfFileName));
                    out.write(sfManifestBuf);
                    out.closeEntry();
                    out.putNextEntry(new JarEntry(sigFileName));
                    out.write(pkcs7);
                    out.closeEntry();
                    for (Object entry : inFile.getEntries()) {
                        JarEntry je = (JarEntry)entry;
                        if (je.getName().equals(mfFileName) || je.getName().equals(sfFileName) || je.getName().equals(sigFileName)) continue;
                        out.putNextEntry(new JarEntry(je.getName()));
                        if (!je.isDirectory()) {
                            FileName fileName = new FileName("jar:" + inFile.getURL() + "!/" + je.getName(), true);
                            try (BaseFile bf = new BaseFile(null, (Object)fileName);){
                                bf.open();
                                try (InputStream in = bf.getResource().getInputStream();){
                                    int numRead;
                                    while ((numRead = in.read(buf)) >= 0) {
                                        out.write(buf, 0, numRead);
                                    }
                                    out.write(buf, 0, 0);
                                }
                                catch (IOException e) {
                                    throw new MidasException("Error reading " + fileName, e);
                                }
                            }
                        }
                        out.closeEntry();
                    }
                }
                catch (IOException e) {
                    throw new MidasException("Could not write " + outFileName, e);
                }
                outFilePath.renameTo(inFilePath);
            }
            catch (InvalidKeyException | SignatureException e) {
                throw new MidasException("Could not sign JAR file", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError("Could not find SHA256withRSA", e);
            }
        }
        catch (IllegalArgumentException e) {
            throw new MidasException("Reflection failure in signing JAR file", e);
        }
        finally {
            outFilePath.delete();
        }
    }

    @InternalUseOnly
    public static void setCertInfoLogLevel(Level logLevel) {
        certInfoLogLevel = logLevel;
    }

    @InternalUseOnly
    public static Level getCertInfoLogLevel() {
        return certInfoLogLevel;
    }

    private static byte[] PKCS7_generateSignedData(byte[] signature, X509Certificate[] certChain, byte[] content, String sigAlgo, URI tsaURI, String tsaPolicy, String algorithm) {
        try {
            Class<?> _PKCS7 = Class.forName("sun.security.pkcs.PKCS7");
            Method method = _PKCS7.getMethod("generateSignedData", byte[].class, X509Certificate[].class, byte[].class, String.class, URI.class, String.class, String.class);
            return (byte[])method.invoke(null, signature, certChain, content, sigAlgo, tsaURI, tsaPolicy, algorithm);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not sign JAR file", e);
        }
    }

    private static byte[] PKCS7_generateSignedData(X509Certificate[] certChain, byte[] content, String sigAlgo, String algorithm, PrivateKey privateKey) {
        try {
            Class<?> _PKCS7 = Class.forName("sun.security.pkcs.PKCS7");
            Method method = _PKCS7.getMethod("generateSignedData", String.class, Provider.class, PrivateKey.class, X509Certificate[].class, byte[].class, Boolean.TYPE, Boolean.TYPE, Function.class);
            return (byte[])method.invoke(null, sigAlgo, null, privateKey, certChain, content, false, false, null);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not sign JAR file", e);
        }
    }

    private static Object ManifestDigester_new(byte[] manifestBuf) {
        try {
            Class<?> clazz = Class.forName("sun.security.util.ManifestDigester");
            Constructor<?> con = clazz.getConstructor(byte[].class);
            return con.newInstance(new Object[]{manifestBuf});
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Can't compute manifest digest", e);
        }
    }

    private static Object ManifestDigester_get(Object manifestDigester, String key, boolean flag) {
        try {
            Class<?> clazz = Class.forName("sun.security.util.ManifestDigester");
            Method method = clazz.getDeclaredMethod("get", String.class, Boolean.TYPE);
            return method.invoke(manifestDigester, key, flag);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Can't compute manifest digest", e);
        }
    }

    private static byte[] ManifestDigester_manifestDigest(Object manifestDigester, MessageDigest md) {
        try {
            Class<?> clazz = Class.forName("sun.security.util.ManifestDigester");
            Method method = clazz.getDeclaredMethod("manifestDigest", MessageDigest.class);
            return (byte[])method.invoke(manifestDigester, md);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Can't compute manifest digest", e);
        }
    }

    private static byte[] ManifestDigester_Entry_digest(Object entry, MessageDigest md) {
        try {
            Class<?> clazz = Class.forName("sun.security.util.ManifestDigester$Entry");
            Method method = clazz.getDeclaredMethod("digest", MessageDigest.class);
            return (byte[])method.invoke(entry, md);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Can't compute manifest digest", e);
        }
    }

    @InternalUseOnly
    public static void setUserQuery(String userQuery) {
        SSLUtilities.userQuery = userQuery;
    }

    @InternalUseOnly
    public static void setGroupQuery(String groupQuery) {
        SSLUtilities.groupQuery = groupQuery;
    }

    @InternalUseOnly
    public static void addToJsonKeyPath(String jsonKey, String jsonPath) {
        jsonKeyPaths.put(jsonKey.toLowerCase(), jsonPath);
    }

    @ProvisionalUseOnly(value="Use with caution")
    public static KeyStore getCurrentKeyStore() {
        return currentKeyStore;
    }

    @ProvisionalUseOnly(value="Use with caution")
    public static KeyStore getCurrentTrustStore() {
        return currentTrustStore;
    }

    public static void setNssLibsDir(String nssLibsLoc) {
        nssLibsDir = nssLibsLoc;
    }

    @ProvisionalUseOnly(value="Read Only")
    public static List<CertInfo> getAllCertInfo() {
        return allCertInfo;
    }

    static {
        Method m;
        initState = 0;
        userQuery = null;
        groupQuery = null;
        midas = null;
        userDN = null;
        allCertInfo = new ArrayList<CertInfo>(4);
        jsonKeyPaths = new LinkedHashMap<String, String>(32);
        certInfoLogLevel = Level.FINEST;
        serverTrustMode = "";
        javaMajVer = Shell.getJavaMajorVersion();
        try {
            m = Class.forName("java.security.Provider").getMethod("configure", String.class);
        }
        catch (Exception e) {
            m = null;
        }
        PROVIDER_CONFIGURE = m;
    }

    public static class PemFile {
        protected static final char[] NO_PASSWORD = new char[0];
        protected final String fileName;
        protected final KeyStore ks;
        protected final String alias;
        protected final KeyStore.PasswordProtection pass;
        protected final KeyStore.PrivateKeyEntry pvtKey;
        protected final X509Certificate cert;

        public PemFile(String fileName, String alias, X509Certificate[] certChain, PublicKey publicKey, PrivateKey privateKey) throws GeneralSecurityException, IOException {
            if (certChain == null || certChain.length == 0) {
                throw new IllegalArgumentException("Missing required certificate in " + fileName);
            }
            if (publicKey == null) {
                publicKey = certChain[0].getPublicKey();
            }
            Objects.requireNonNull(publicKey, "Missing required public key in " + fileName);
            Objects.requireNonNull(privateKey, "Missing required private key in " + fileName);
            this.fileName = fileName;
            this.alias = alias;
            this.pass = new KeyStore.PasswordProtection(NO_PASSWORD);
            this.pvtKey = new KeyStore.PrivateKeyEntry(privateKey, certChain);
            this.ks = KeyStore.getInstance("PKCS12");
            this.ks.load(null, null);
            this.ks.setEntry(alias, this.pvtKey, this.pass);
            this.cert = (X509Certificate)this.ks.getCertificate(alias);
        }

        public KeyStore getKeyStore() {
            return this.ks;
        }

        public String getAlias() {
            return this.alias;
        }

        public KeyStore.PrivateKeyEntry getPrivateKeyEntry() {
            return this.pvtKey;
        }

        public KeyStore.PasswordProtection getPasswordProtection() {
            return this.pass;
        }

        public X509Certificate getCertificate() {
            return this.cert;
        }

        public X500Principal getSubject() {
            return this.cert.getSubjectX500Principal();
        }

        public X500Principal getIssuer() {
            return this.cert.getIssuerX500Principal();
        }

        public String toString() {
            return "<" + this.getSubject() + "><" + this.getIssuer() + ">";
        }
    }

    @InternalUseOnly
    public static class AcceptAllHostNameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    static final class PasswdFromGUI
    implements CallbackHandler,
    KeyStore.LoadStoreParameter {
        private final String prompt;

        PasswdFromGUI(String prompt) {
            this.prompt = prompt;
        }

        @Override
        public KeyStore.ProtectionParameter getProtectionParameter() {
            return new KeyStore.CallbackHandlerProtection(this);
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback cb : callbacks) {
                if (!(cb instanceof PasswordCallback)) {
                    throw new UnsupportedCallbackException(cb, "Unrecognized Callback");
                }
                PasswordCallback pwdCb = (PasswordCallback)cb;
                String ppt = this.prompt != null ? this.prompt : pwdCb.getPrompt();
                pwdCb.setPassword(Shell.passwdFromGUI(ppt));
            }
        }
    }

    private static class CertKeyManager
    extends X509ExtendedKeyManager {
        private final X509KeyManager mgr;
        private final List<CertInfo> certInfo;

        CertKeyManager(KeyManagerFactory kmf, List<CertInfo> certInfo) {
            Objects.requireNonNull(kmf);
            Objects.requireNonNull(certInfo);
            this.mgr = (X509KeyManager)kmf.getKeyManagers()[0];
            this.certInfo = certInfo;
        }

        public String toString() {
            return "CertKeyManager: mgr=" + this.mgr + " certInfo=" + this.certInfo;
        }

        @Override
        public String chooseClientAlias(String[] s, Principal[] p, Socket k) {
            if (!this.certInfo.isEmpty()) {
                return this.certInfo.get((int)0).alias;
            }
            return this.mgr.chooseClientAlias(s, p, k);
        }

        @Override
        public String chooseEngineClientAlias(String[] s, Principal[] p, SSLEngine e) {
            if (!this.certInfo.isEmpty()) {
                return this.certInfo.get((int)0).alias;
            }
            if (this.mgr instanceof X509ExtendedKeyManager) {
                return ((X509ExtendedKeyManager)this.mgr).chooseEngineClientAlias(s, p, e);
            }
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            CertInfo c = SSLUtilities.getCertInfo(this.certInfo, alias);
            return c != null ? c.certChain : this.mgr.getCertificateChain(alias);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            CertInfo c = SSLUtilities.getCertInfo(this.certInfo, alias);
            return c != null ? c.privateKey : this.mgr.getPrivateKey(alias);
        }

        @Override
        public String chooseServerAlias(String s, Principal[] p, Socket k) {
            return this.mgr.chooseServerAlias(s, p, k);
        }

        @Override
        public String[] getClientAliases(String s, Principal[] p) {
            return this.mgr.getClientAliases(s, p);
        }

        @Override
        public String[] getServerAliases(String s, Principal[] p) {
            return this.mgr.getServerAliases(s, p);
        }
    }

    public static final class CertInfo {
        final KeyManagerFactory kmf;
        final String alias;
        final X509Certificate cert;
        final X509Certificate[] certChain;
        final PrivateKey privateKey;

        CertInfo(KeyManagerFactory kmf, String alias, X509Certificate cert, X509Certificate[] certChain, PrivateKey privateKey) {
            this.kmf = Objects.requireNonNull(kmf);
            this.alias = Objects.requireNonNull(alias);
            this.cert = Objects.requireNonNull(cert);
            this.certChain = Objects.requireNonNull(certChain);
            this.privateKey = Objects.requireNonNull(privateKey);
        }

        CertInfo(KeyManagerFactory kmf, String alias, X509Certificate cert, Certificate[] certChain, PrivateKey privateKey) {
            this(kmf, alias, cert, new X509Certificate[certChain.length], privateKey);
            for (int i = 0; i < certChain.length; ++i) {
                this.certChain[i] = (X509Certificate)certChain[i];
            }
        }

        public String toString() {
            return this.getAlias();
        }

        public String getAlias() {
            return this.alias;
        }

        public X509Certificate getX509Certificate() {
            return this.cert;
        }

        public String getUserDN() {
            return this.getX509Certificate().getSubjectX500Principal().getName();
        }

        public String getUserCN() {
            return this.getUserCNAlias(false);
        }

        public String getUserAlias(boolean normalize) {
            String userAlias = this.getUserCNAlias(true);
            return normalize ? this.normalizeAlias(userAlias) : userAlias;
        }

        private String getUserCNAlias(boolean alias) {
            String userDN = this.getUserDN();
            int start = userDN.toLowerCase().indexOf("cn=");
            if (start < 0) {
                return userDN;
            }
            int end = userDN.indexOf(44, start);
            if (end < 0) {
                end = userDN.length();
            }
            String userCN = userDN.substring(start + 3, end);
            return alias ? this.toAlias(userCN) : userCN;
        }

        String normalizeAlias(String alias) {
            for (int i = 0; i < alias.length(); ++i) {
                char c = alias.charAt(i);
                if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '-' || c == '_') continue;
                alias = alias.substring(0, i) + '_' + alias.substring(i + 1);
            }
            if (alias.length() > 8) {
                alias = alias.substring(0, 8);
            }
            return alias.toUpperCase();
        }

        private String toAlias(String userCN) {
            if (userCN.indexOf(32) < 0) {
                int index = userCN.indexOf(46);
                if (index >= 1 && Character.isAlphabetic(userCN.charAt(0))) {
                    return userCN.substring(0, index);
                }
                return userCN;
            }
            String[] names = userCN.split("[ ]+");
            String bestName = names[0];
            int bestRank = 0;
            for (String name : names) {
                boolean allLower = true;
                boolean allUpper = true;
                boolean anyNumbers = false;
                for (int j = 0; j < name.length(); ++j) {
                    char c = name.charAt(j);
                    allLower = allLower && Character.isLowerCase(c);
                    allUpper = allUpper && Character.isUpperCase(c);
                    anyNumbers = anyNumbers || Character.isDigit(c);
                }
                int rank = 0;
                if (anyNumbers) {
                    rank = 100;
                } else if (allLower) {
                    rank = 10;
                } else if (allUpper) {
                    rank = 5;
                }
                if (rank <= bestRank) continue;
                bestName = name;
                bestRank = rank;
            }
            return bestName;
        }
    }

    public static interface CertFilter {
        public List<CertInfo> filter(List<CertInfo> var1);
    }

    private static class EntriesMap<K, V>
    implements Map<K, V> {
        private final Map<K, V> map = Collections.synchronizedMap(new LinkedHashMap());
        private int count = 0;

        private EntriesMap() {
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsValue(Object v) {
            return this.map.containsValue(v);
        }

        @Override
        public boolean containsKey(Object k) {
            return this.map.containsKey(k);
        }

        @Override
        public V get(Object k) {
            return this.map.get(k);
        }

        @Override
        public V remove(Object k) {
            return this.map.remove(k);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        public String toString() {
            return this.map.toString();
        }

        @Override
        public Set<K> keySet() {
            return this.map.keySet();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public boolean equals(Object o) {
            return this.map.equals(o);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> t) {
            this.map.putAll(t);
        }

        @Override
        public V put(K key, V value) {
            int index;
            if (key instanceof String && (index = key.toString().indexOf(9)) < 0) {
                key = key + "\t[" + this.count++ + "]";
            }
            return this.map.put(key, value);
        }
    }

    public static enum CertificateProperty {
        ALIAS,
        DN;

    }
}

