/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.Comparator;
import nxm.sys.lib.Data;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Util;

public class RecordComparator
implements Comparator<Object> {
    private String[] keys;
    private boolean reverse = false;
    private String format = null;
    private int offset = 0;

    public RecordComparator(String[] keys) {
        this.keys = keys;
    }

    public RecordComparator(String[] in_keys, int in_offset, String in_format) {
        this.keys = in_keys;
        this.offset = in_offset;
        this.format = in_format;
        this.reverse = this.keys[0].startsWith("-");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Keys ");
        sb.append(StringUtil.join(this.keys, " "));
        sb.append(" format " + this.format);
        sb.append(" offset " + this.offset);
        sb.append(" reverse " + this.reverse);
        return sb.toString();
    }

    @Override
    public int compare(Object first, Object second) {
        if (first instanceof Table) {
            return this.compare((Table)first, (Table)second, 0);
        }
        return this.compare((Data)first, (Data)second, this.offset, this.format, this.reverse);
    }

    private int compare(Data first, Data second, int offset, String format, boolean reverse) {
        int test = 0;
        char formatType = format.charAt(1);
        double diff = 0.0;
        if (Data.isString((byte)formatType)) {
            int bpa = Data.getBPA(format);
            String s1 = first.unpackS(offset, bpa);
            String s2 = second.unpackS(offset, bpa);
            test = s1.compareTo(s2);
        } else {
            switch (formatType) {
                case 'D': {
                    diff = first.unpackD(offset) - second.unpackD(offset);
                    break;
                }
                case 'F': {
                    diff = first.unpackF(offset) - second.unpackF(offset);
                    break;
                }
                case 'X': {
                    diff = first.unpackX(offset) - second.unpackX(offset);
                    break;
                }
                case 'L': {
                    diff = first.unpackL(offset) - second.unpackL(offset);
                    break;
                }
                case 'I': {
                    diff = first.unpackI(offset) - second.unpackI(offset);
                    break;
                }
                case 'B': {
                    diff = first.unpackB(offset) - second.unpackB(offset);
                    break;
                }
                default: {
                    Shell.warning("unknown format type '" + formatType + "'");
                }
            }
            test = (int)Math.signum(diff);
        }
        return reverse ? -test : test;
    }

    private int compare(Table first, Table second, int keyIndex) {
        if (keyIndex >= this.keys.length) {
            return 0;
        }
        String key = this.keys[keyIndex];
        boolean reverse = false;
        if (key.startsWith("-")) {
            key = key.substring(1);
            reverse = true;
        } else if (key.startsWith("+")) {
            key = key.substring(1);
            reverse = false;
        }
        Object firstObj = first.get(key);
        Object secondObj = second.get(key);
        if (firstObj == null || secondObj == null) {
            throw new RuntimeException("sort: Attempting to compare field (" + key + ") but found null entry in (" + first + ") and (" + second + ").");
        }
        int test = Util.compare(firstObj, secondObj);
        if (test == 0) {
            return this.compare(first, second, keyIndex + 1);
        }
        return reverse ? -test : test;
    }
}

