/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.FilenameFilter;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Time;

public class RamResource
extends IOResource {
    public String name;
    public RamFile ramfile = new RamFile();

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public void setURL(String urlstr) {
        super.setURL(urlstr);
        this.name = urlstr.substring(4);
    }

    @Override
    public boolean exists() {
        return this.M.pipes.containsKey(this.name);
    }

    @Override
    public boolean open() {
        this.isOpen = false;
        if (this.dir > 0) {
            RamFile prevRamfile = (RamFile)this.M.pipes.get(this.name);
            if (prevRamfile != null) {
                prevRamfile.setLength(this.ramfile.length);
                this.ramfile = prevRamfile;
            } else {
                this.M.pipes.put(this.name, (Object)this.ramfile);
            }
        } else if (this.dir <= 0) {
            this.ramfile = (RamFile)this.M.pipes.get(this.name);
        }
        this.isOpen = this.ramfile != null;
        return this.isOpen;
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public boolean delete() {
        this.M.pipes.remove(this.name);
        return true;
    }

    @Override
    public long getLength() {
        return this.ramfile.length;
    }

    @Override
    public void setLength(long bytes) {
        this.ramfile.setLength(bytes);
    }

    @Override
    public boolean seek(long offset) {
        this.offset = offset;
        return true;
    }

    @Override
    public int read(byte[] buf, int boff, int bytes) {
        long bytesToRead = Math.min((long)bytes, (long)this.ramfile.length - this.offset);
        if (bytesToRead <= 0L) {
            return -1;
        }
        int status = (int)bytesToRead;
        System.arraycopy(this.ramfile.buffer, (int)this.offset, buf, boff, status);
        this.offset += (long)status;
        return status;
    }

    @Override
    public int write(byte[] buf, int boff, int bytes) {
        if (this.offset + (long)bytes > (long)this.ramfile.length) {
            this.ramfile.setLength(this.offset + (long)bytes);
        }
        System.arraycopy(buf, boff, this.ramfile.buffer, (int)this.offset, bytes);
        this.offset += (long)bytes;
        this.ramfile.lastModified = Time.current();
        return bytes;
    }

    @Override
    public String[] getEntryList(FilenameFilter filter) {
        return this.filterEntries(filter, this.M.pipes.getKeys());
    }

    @Override
    public IOResource getEntry(String name) {
        return null;
    }

    @Override
    public Time lastModifiedTime() {
        return new Time(this.ramfile.lastModified);
    }

    @Override
    public long lastModified() {
        return (long)Time.toJ1970(this.ramfile.lastModified);
    }

    public static class RamFile {
        public static final int MAX_SIZE = Integer.MAX_VALUE;
        public static final int MAX_INITIAL = 0x1000000;
        private static final int MAX_INCREMENT = 0x400000;
        public int length = 0;
        public byte[] buffer;
        private int increment = 1024;
        double lastModified = Time.current();

        public void setLength(long bytes) {
            if (bytes > Integer.MAX_VALUE) {
                throw new MidasException("Cannot set RamFile size larger then 2 GiB limit [" + bytes + "]");
            }
            if (bytes < 0L) {
                throw new MidasException("Cannot set RamFile size to negative [" + bytes + "]");
            }
            byte[] oldbuffer = this.buffer;
            int oldlength = this.length;
            this.length = (int)bytes;
            if (oldbuffer == null) {
                bytes = Math.min(0x1000000L, bytes);
                this.length = (int)bytes;
            } else if (this.length <= oldbuffer.length) {
                return;
            }
            int newBufSize = (int)Math.min(Integer.MAX_VALUE, bytes + (long)this.increment);
            this.buffer = new byte[newBufSize];
            if (this.increment < 0x400000) {
                this.increment = (int)Math.min(0x400000L, bytes * 2L);
            }
            if (oldbuffer != null) {
                System.arraycopy(oldbuffer, 0, this.buffer, 0, Math.min(oldlength, this.length));
            }
        }

        public double getLastModified() {
            return this.lastModified;
        }
    }
}

