/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import nxm.sys.inc.Commandable;
import nxm.sys.inc.IDable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Command;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Message;
import nxm.sys.lib.Time;

public class Processor
implements IDable,
MessageHandler,
Commandable {
    public String id;
    public String address;
    public int state = 0;
    public KeyVector commands;

    @Override
    public int open() {
        this.commands = new KeyVector(16);
        return 2;
    }

    public void run() {
        this.state = 0;
        this.state = this.open();
        while (this.state != 9 || this.state != 10) {
            if (this.process() != -1) continue;
            Time.sleep(0.0125);
        }
        this.state = this.close();
    }

    @Override
    public int process() {
        int status = -1;
        for (int i = 0; i < this.commands.size(); ++i) {
            int cstatus;
            Command cmd = (Command)this.commands.get(i);
            if (cmd.state == 9 || cmd.state == 10) {
                int n = -1;
            }
            if ((cstatus = cmd.queue.getAvail() > 0 ? cmd.processMessage(cmd.queue.get()) : (cmd.isPiped && cmd.M.pipeMode != 2 ? -1 : cmd.process())) == -1 || cstatus == 8) continue;
            status = 0;
        }
        return status;
    }

    @Override
    public int processMessage(Message msg) {
        return -1;
    }

    @Override
    public int close() {
        for (int i = 0; i < this.commands.size(); ++i) {
            Command cmd = (Command)this.commands.get(i);
            cmd.state = 9;
        }
        return 9;
    }

    public int addCommand(Command cmd) {
        this.commands.add(cmd.id, cmd);
        return this.commands.size();
    }

    public int remCommand(Command cmd) {
        this.commands.remove(cmd.id);
        return this.commands.size();
    }

    public void setID(String id) {
        this.id = id;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }
}

