/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.FilenameFilter;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.Pipe;
import nxm.sys.lib.Time;
import nxm.sys.lib.TimeLine;

public class PipeResource
extends IOResource {
    public Pipe pipe;
    public int outlet;
    public String name;
    public DataFile df;
    public int pipeSize;
    public double pause = 0.0125;
    public static boolean POLLING = true;
    private double diffInReconnectOffsetFromInitialConnect = 0.0;
    private double initialConnectSeekPos = 0.0;

    @Override
    public boolean isStream() {
        return true;
    }

    @Override
    public boolean isStreaming() {
        if (this.pipe == null) {
            return true;
        }
        DataFile df = this.pipe.getDataFile(this.outlet);
        if (df == null) {
            return true;
        }
        if (df.isOpen) {
            return true;
        }
        if (df.getNextDataFile() != null) {
            return false;
        }
        return this.pipe.inlet != 0;
    }

    @Override
    public boolean exists() {
        this.name = this.urlstr.substring(4).toUpperCase();
        return this.M.pipes.containsKey(this.name);
    }

    @Override
    public synchronized boolean open() {
        this.pipe = (Pipe)this.M.pipes.get(this.name);
        if (this.dir <= 0) {
            this.outlet = this.pipe.attach(this.dir, this.df);
            this.initTimecode();
        } else if (this.pipe == null) {
            int maxOutlets = 8;
            if (this.qualTable != null) {
                maxOutlets = this.qualTable.getL("MAXOUTLETS", maxOutlets);
            }
            this.pipe = new Pipe(this.M, this.name, maxOutlets);
            this.pipe.setSize(this.pipeSize);
            this.outlet = this.pipe.attach(this.dir, this.df);
            if (!this.M.io.isOptionSet(CoreIO.IOOptions.DoublePropagateTimelineKeywordsInPipe)) {
                this.df.deleteTimeLineKeywords();
            }
            this.M.pipes.put(this.name, (Object)this.pipe);
        } else {
            this.outlet = this.pipe.attach(this.dir, this.df);
            this.M.pipes.put(this.name, (Object)this.pipe);
        }
        this.pause = this.M.pause;
        if (this.M.macro != null) {
            this.pause = this.M.macro.lines[1].getD("/POLL", this.pause);
        }
        this.isOpen = this.outlet >= 0;
        return this.isOpen;
    }

    @Override
    public synchronized boolean close() {
        if (this.pipe == null) {
            return true;
        }
        this.pipe.detach(this.outlet, this.df);
        if (this.outlet == 0 && this.pipe.inlet == 0) {
            this.M.pipes.remove(this.name);
        }
        return true;
    }

    @Override
    public boolean delete() {
        this.M.pipes.remove(this.name);
        return true;
    }

    @Override
    public long getLength() {
        return (long)this.pipe.inPtr;
    }

    @Override
    public boolean seek(long offset) {
        if (this.outlet > 0) {
            this.pipe.outPtr[this.outlet] = offset;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public long seek() {
        if (this.outlet > 0) {
            return (long)this.pipe.outPtr[this.outlet];
        }
        return (long)this.pipe.inPtr;
    }

    @Override
    public long avail() {
        return (long)this.pipe.avail(this.outlet);
    }

    @Override
    public boolean isReady(int numBytes) {
        return this.pipe.isReady(this.outlet, numBytes);
    }

    @Override
    public int read(byte[] buf, int boff, int bytes) {
        return this.read(buf, 0L, boff, bytes);
    }

    @Override
    public int write(byte[] buf, int boff, int bytes) {
        return this.write(buf, 0L, boff, bytes);
    }

    @Override
    public int read(long lbuf, int boff, int bytes) {
        return this.read(null, lbuf, boff, bytes);
    }

    @Override
    public int write(long lbuf, int boff, int bytes) {
        return this.write(null, lbuf, boff, bytes);
    }

    private int read(byte[] buf, long lbuf, int boff, int bytes) {
        int status = 0;
        int off = boff;
        while (bytes > 0) {
            status = this.pipe.read(buf, lbuf, off, bytes, this.outlet);
            if (status > 0) {
                bytes -= status;
                off += status;
                continue;
            }
            if (status < 0 || this.df.cmd != null && this.df.cmd.isStateChanged()) break;
            if (POLLING) {
                Time.sleep(this.pause);
                continue;
            }
            try {
                this.pipe.wait();
            }
            catch (Exception exception) {}
        }
        this.offset = (long)this.pipe.outPtr[this.outlet];
        if (!POLLING) {
            this.pipe.awaken();
        }
        if (status < 0 && off == boff) {
            return status;
        }
        this.propagateTimecode();
        return off - boff;
    }

    private int write(byte[] buf, long lbuf, int boff, int bytes) {
        int status = 0;
        int off = boff;
        while (bytes > 0) {
            status = this.pipe.write(buf, lbuf, off, bytes, this.outlet);
            if (status > 0) {
                bytes -= status;
                off += status;
                continue;
            }
            if (status < 0) break;
            if (POLLING) {
                Time.sleep(this.pause);
                continue;
            }
            try {
                this.pipe.wait();
            }
            catch (Exception exception) {}
        }
        this.offset = (long)this.pipe.inPtr;
        if (!POLLING) {
            this.pipe.awaken();
        }
        if (status < 0 && off == boff) {
            return status;
        }
        return off - boff;
    }

    @Override
    public String[] getEntryList(FilenameFilter filter) {
        return this.filterEntries(filter, this.M.pipes.getKeys());
    }

    @Override
    public IOResource getEntry(String name) {
        return null;
    }

    @Override
    public Time lastModifiedTime() {
        return new Time(this.pipe.lastModified);
    }

    @Override
    public long lastModified() {
        return (long)Time.toJ1970(this.pipe.lastModified);
    }

    public void connect(int flag) {
        if (flag > 0 && this.outlet == -2) {
            this.outlet = this.pipe.attach(this.dir, this.df);
        }
        if (flag < 0 && this.outlet > 0) {
            this.outlet = this.pipe.detach(this.outlet, this.df);
        }
    }

    public int readHeader(byte[] hb) {
        return this.pipe.readHeader(hb, this.outlet);
    }

    public int writeHeader(byte[] hb) {
        return this.pipe.writeHeader(hb, this.outlet);
    }

    private void initTimecode() {
        DataFile previous = this.df.getPreviousDataFile();
        if (previous == null) {
            this.df.newTimeLineFromDF(this.pipe.getDataFile(this.outlet));
            this.initialConnectSeekPos = this.pipe.getDataFile(this.outlet).seek();
            this.propagateTimecode();
        } else {
            DataFile in;
            Time stopTime = previous.getTimeAt(previous.seek(), null);
            Time startTime = stopTime.addSec(previous.getDelta());
            this.df.newTimeLineFromDF(previous);
            this.df.setTimeAt(0.0, startTime, TimeLine.NotifyInvalidEntry.WARNING);
            if (!this.M.io.isOptionSet(CoreIO.IOOptions.DisablePipeRestartTimeLinesFix) && this.df.isInput && (in = this.pipe.getDataFile(this.outlet)) != null) {
                TimeLine inTimeLine = in.getTimeLineHandler();
                if (inTimeLine != null && in.getBPE() != 0.0) {
                    this.diffInReconnectOffsetFromInitialConnect = Math.floor(in.getTimeLineHandler().getOffsetAt(startTime) / in.getBPE()) - this.initialConnectSeekPos;
                } else if (inTimeLine == null) {
                    this.diffInReconnectOffsetFromInitialConnect = Math.floor((startTime.getSec() - in.getTimeAt(this.initialConnectSeekPos)) / in.getDelta());
                }
            }
        }
    }

    private void propagateTimecode() {
        DataFile in = this.pipe.getDataFile(this.outlet);
        double seekBytes = this.df.seek() * this.df.getBPE();
        double seekElem = Math.floor(seekBytes / in.getBPE());
        Time time = !this.M.io.isOptionSet(CoreIO.IOOptions.DisablePipeRestartTimeLinesFix) ? in.getTimeAt(this.diffInReconnectOffsetFromInitialConnect + this.initialConnectSeekPos + seekElem, null) : in.getTimeAt(this.initialConnectSeekPos + seekElem, null);
        if (this.df.timeLine == null || this.df.timeLine.getSize() == 0) {
            if (in.sourceTimeLineFormat != null) {
                this.df.setTimeLineFormat(in.sourceTimeLineFormat);
            }
            if (in.sourceTimeLineTolr != 0.0) {
                this.df.setTimeLineTolerance(in.sourceTimeLineTolr);
            }
            if (this.df.timeLine.format != TimeLine.Format.MICROSECOND_PRECISION) {
                this.df.timeLine.setAlloc(TimeLine.getHighPrecisionAllocDefault());
            }
        }
        this.df.setTimeAt(time, TimeLine.NotifyInvalidEntry.WARNING);
    }
}

