/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import nxm.sys.inc.OptionTreeAutoLoaderInterface;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.NeXtMidas;
import nxm.sys.lib.Shell;

public class OptionTreeAutoLoaderService {
    private static OptionTreeAutoLoaderService service;
    private ServiceLoader<OptionTreeAutoLoaderInterface> loader = ServiceLoader.load(OptionTreeAutoLoaderInterface.class);

    public static synchronized OptionTreeAutoLoaderService getInstance() {
        if (service == null) {
            service = new OptionTreeAutoLoaderService();
        }
        return service;
    }

    public String optionTreePathFromClasspath() {
        String optName = null;
        String pathCmd = "PATH ADD+ ";
        try {
            for (OptionTreeAutoLoaderInterface opt : this.loader) {
                optName = opt.getOptionTreeName();
                String optCommand = "OPTION," + optName + ",CLASSPATH";
                Shell.runCommand(Shell.getMidasContext(), optCommand);
                Shell.runCommand(Shell.getMidasContext(), pathCmd + optName);
            }
            NeXtMidas nxm = NeXtMidas.getGlobalInstance();
            optName = nxm.getPath();
        }
        catch (ServiceConfigurationError serviceError) {
            optName = null;
            throw new MidasException("Exception when retrieving service provider for OptionTreePathFromClasspath method: ", serviceError);
        }
        return optName;
    }
}

