/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Native;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class OS {
    @Deprecated
    public OS() {
    }

    public static Table getStatFS(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        if (path.indexOf(58) > 0) {
            return null;
        }
        long[] data = new long[10];
        int stat = Native.statfs(path, data);
        if (stat < 0) {
            data[2] = 1024L;
            data[1] = 1024L;
            data[0] = 1024L;
            data[3] = 0L;
        }
        int tmby = (int)(data[0] * data[1] / 1000000L);
        int fmby = (int)(data[0] * data[2] / 1000000L);
        int files = (int)data[3];
        int used = (int)(100L - 100L * data[2] / Math.max(1L, data[1]));
        String stats = "{PATH=" + path + ",FILES=" + files + ",TMBY=" + tmby + ",FMBY=" + fmby + ",USED=" + used + "}";
        return new Table(stats);
    }

    public static int getStats(int flags, byte[] buf) {
        return OS.runCommand("top -n 1 -b", flags, buf);
    }

    @InternalUseOnly(value="Since added")
    public static int runCommand(String cmd, int flags, byte[] buf) {
        int boff = 0;
        int timeout = 20;
        try {
            Runtime runtime = Runtime.getRuntime();
            StringTokenizer st = new StringTokenizer(cmd);
            String[] cmdArray = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                cmdArray[i] = st.nextToken();
                ++i;
            }
            Process osProcess = runtime.exec(cmdArray);
            OutputStream osInput = osProcess.getOutputStream();
            InputStream osOutput = osProcess.getInputStream();
            int state = 0;
            while (state >= 0 && timeout != 0 && boff < buf.length) {
                int bytes = osOutput.available();
                if (bytes > 0) {
                    bytes = Math.min(bytes, buf.length - boff);
                    if ((bytes = osOutput.read(buf, boff, bytes)) > 0) {
                        boff += bytes;
                    }
                    state = 1;
                }
                try {
                    int status = osProcess.exitValue();
                    if (osOutput.available() > 0) {
                        state = 0;
                        continue;
                    }
                    state = -1;
                }
                catch (IllegalThreadStateException e) {
                    if (state == 0) {
                        Time.sleep(0.1);
                        --timeout;
                        continue;
                    }
                    state = 0;
                }
            }
            osInput.close();
            osOutput.close();
        }
        catch (Exception e) {
            Shell.printStackTrace("Error running OS cmd", e);
        }
        return boff;
    }
}

