/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import nxm.sys.lib.FileResource;
import nxm.sys.lib.Native;

public class NFileResource
extends FileResource {
    private int fd;

    @Override
    public boolean open() {
        this.isOpen = false;
        this.fd = Native.fopen(this.file.toString(), this.dir);
        boolean bl = this.isOpen = this.fd > 0;
        if (this.isOpen && this.getStateQualifier("DELETEONEXIT")) {
            this.file.deleteOnExit();
        }
        return this.isOpen;
    }

    @Override
    public boolean close() {
        if (!this.isOpen) {
            return false;
        }
        Native.fclose(this.fd);
        this.isOpen = false;
        return true;
    }

    @Override
    public boolean seek(long offset) {
        if (offset == this.offset) {
            return true;
        }
        if (Native.fseek(this.fd, offset) != offset) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public int read(byte[] buf, int boff, int bytes) {
        int status = 0;
        int off = boff;
        while (bytes > 0 && (status = Native.freadb(this.fd, buf, off, bytes)) > 0) {
            bytes -= status;
            off += status;
        }
        bytes = off - boff;
        if (status == 0 && bytes == 0) {
            return -1;
        }
        if (status < 0 && bytes == 0) {
            return -3;
        }
        this.offset += (long)bytes;
        return bytes;
    }

    @Override
    public int write(byte[] buf, int boff, int bytes) {
        int off = boff;
        int status = Native.fwriteb(this.fd, buf, off, bytes);
        this.offset += (long)bytes;
        return bytes;
    }

    @Override
    public int read(long lbuf, int boff, int bytes) {
        int status = 0;
        int off = boff;
        while (bytes > 0 && (status = Native.fread(this.fd, lbuf, off, bytes)) > 0) {
            bytes -= status;
            off += status;
        }
        bytes = off - boff;
        if (status == 0 && bytes == 0) {
            return -1;
        }
        if (status < 0 && bytes == 0) {
            return -3;
        }
        this.offset += (long)bytes;
        return bytes;
    }

    @Override
    public int write(long lbuf, int boff, int bytes) {
        int off = boff;
        int status = Native.fwrite(this.fd, lbuf, off, bytes);
        this.offset += (long)bytes;
        return bytes;
    }

    @Override
    public String toString() {
        return "NativeFileResource : " + this.getURL();
    }
}

