/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import nxm.sys.inc.IDable;
import nxm.sys.inc.Keyable;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Parser;

public class Message
implements Keyable {
    public static final String propertyList = "Name,Info,Data,From,To";
    public String name;
    public int info;
    public Object data;
    public Object from;
    public Object to;
    public Object quals;
    public Message next;
    public Message prev;
    private XmMsgType xmMsgType = XmMsgType.NEXTMIDAS;
    public static final String stringList = "Name,Info,Data,From,To,FID,TID,Quals";
    public static final int NAME = 1;
    public static final int INFO = 2;
    public static final int DATA = 4;
    public static final int FROM = 8;
    public static final int TO = 16;
    public static final int FID = 32;
    public static final int TID = 64;
    public static final int QUALS = 128;
    private static int defToStringMask = 231;
    private static String defToStringStr = Parser.mask2s("Name,Info,Data,From,To,FID,TID,Quals", defToStringMask).toUpperCase();
    private static String[] keys = new String[]{"NAME", "DATA", "INFO", "TO", "FROM", "TID", "FID", "QUALS"};

    public Message(String name, int info, Object data) {
        this(name, info, data, null, null, null, null);
    }

    public Message(String name, int info, Object data, XmMsgType xmMsgType) {
        this(name, info, data, null, null, null, xmMsgType);
    }

    public Message(String name, int info, Object data, Object quals) {
        this(name, info, data, null, null, quals, null);
    }

    public Message(String name, int info, Object data, Object to, Object from) {
        this(name, info, data, to, from, null, null);
    }

    public Message(String name, int info, Object data, Object to, Object from, Object quals) {
        this(name, info, data, to, from, quals, null);
    }

    public Message(String name, int info, Object data, Object to, Object from, Object quals, XmMsgType xmMsgType) {
        this.name = name;
        this.info = info;
        this.data = data;
        this.to = to;
        this.from = from;
        this.quals = quals;
        if (xmMsgType != null) {
            this.xmMsgType = xmMsgType;
        }
    }

    public String getS() {
        return this.getData().toString();
    }

    public String getName() {
        return this.name;
    }

    public int getInfo() {
        return this.info;
    }

    public Object getData() {
        return this.data;
    }

    public Object getFrom() {
        return this.from;
    }

    public Object getTo() {
        return this.to;
    }

    public Object getQuals() {
        return this.quals;
    }

    public String getFromID() {
        return this.getID(this.from);
    }

    public String getToID() {
        return this.getID(this.to);
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setInfo(int value) {
        this.info = value;
    }

    public void setData(Object value) {
        this.data = value;
    }

    public void setFrom(Object value) {
        this.from = value;
    }

    public void setTo(Object value) {
        this.to = value;
    }

    public void setQuals(Object value) {
        this.quals = value;
    }

    public String toString() {
        return this.toString("-DATA");
    }

    public String toString(String list3) {
        return this.toString(Parser.mask(stringList, list3, defToStringMask));
    }

    public String toString(int mask) {
        String list3 = Parser.mask2s(stringList, mask).toUpperCase();
        StringBuilder str = new StringBuilder();
        str.append("Message:");
        for (int index = 0; index < keys.length; ++index) {
            String key = keys[index];
            if (list3.indexOf(key) < 0) continue;
            str.append(" " + keys[index] + "=" + this.getKey(key));
        }
        return str.toString();
    }

    @Override
    public String[] getKeys() {
        return keys;
    }

    @Override
    public Object getKey(String key) {
        Object value = null;
        if (key.equals("NAME")) {
            value = this.getName();
        } else if (key.equals("FID")) {
            value = this.getFromID();
        } else if (key.equals("DATA")) {
            value = this.getData();
        } else if (key.equals("TID")) {
            value = this.getToID();
        } else if (key.equals("INFO")) {
            value = this.getInfo();
        } else if (key.equals("TO")) {
            value = this.getTo();
        } else if (key.equals("FROM")) {
            value = this.getFrom();
        } else if (key.equals("QUALS")) {
            value = this.getQuals();
        }
        return value;
    }

    @Override
    public Object setKey(String key, Object value) {
        if (key.equals("NAME")) {
            this.setName(Convert.o2s(value));
        } else if (key.equals("INFO")) {
            this.setInfo(Convert.o2l(value));
        } else if (key.equals("DATA")) {
            this.setData(value);
        } else if (key.equals("TO")) {
            this.setTo(value);
        } else if (key.equals("FROM")) {
            this.setFrom(value);
        } else if (key.equals("QUALS")) {
            this.setQuals(value);
        } else {
            return null;
        }
        return value;
    }

    @Deprecated
    public String getID(Object obj) {
        if (obj instanceof IDable) {
            return ((IDable)obj).getID();
        }
        return "NOID";
    }

    public void setXmMessageType(XmMsgType xmt) {
        this.xmMsgType = xmt;
    }

    public XmMsgType getXmMessageType() {
        return this.xmMsgType;
    }

    public static enum XmMsgType {
        NEXTMIDAS,
        CONFIGURED,
        UNCONFIGURED,
        AUTO;

    }
}

