/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.zip.Deflater;
import java.util.zip.Inflater;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.IOResource;

@ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
class MatLabZipResource
extends IOResource {
    private static int CBUFSZ = 4096;
    private static int UBUFSZ = CBUFSZ + 64;
    private static int INMEM = 1;
    private static int NOZIP = 2;
    private IOResource io;
    private long cstart;
    private long coffset;
    private long uoffset;
    private int clength;
    private int ulength;
    private byte[] cbuf = new byte[CBUFSZ];
    private byte[] ubuf = new byte[UBUFSZ];
    private boolean tandem;
    private boolean inMem;
    private boolean noZip;
    private Inflater inflater;
    private Deflater deflater;

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    MatLabZipResource(IOResource io, long cstart, int flags) {
        this.io = io;
        this.cstart = cstart;
        this.coffset = cstart;
        this.clength = 0;
        this.uoffset = cstart;
        this.ulength = 0;
        this.M = io.M;
        this.dir = io.dir;
        this.type = io.type;
        this.urlstr = io.urlstr;
        this.qualTable = io.qualTable;
        this.isOpen = io.isOpen;
        this.tandem = io.isOpen;
        if (this.dir < 0) {
            this.inflater = new Inflater();
        } else {
            this.deflater = new Deflater();
            this.ulength = CBUFSZ;
        }
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public boolean seek(long offset) {
        this.offset = offset;
        return offset == this.offset;
    }

    private boolean rseek(long offset) {
        boolean back;
        boolean bl = back = offset < this.uoffset;
        if (back) {
            this.inflater.reset();
            this.uoffset = this.coffset = this.cstart;
            this.clength = 0;
            this.ulength = 0;
        }
        if (offset >= this.uoffset + (long)this.ulength) {
            if (this.inflater.getRemaining() <= 0) {
                this.coffset += (long)this.clength;
                this.clength = this.io.read(this.cbuf, 0, CBUFSZ, this.coffset);
                this.inflater.setInput(this.cbuf, 0, this.clength);
            }
            try {
                this.uoffset += (long)this.ulength;
                this.ulength = this.inflater.inflate(this.ubuf, 0, UBUFSZ);
            }
            catch (Exception e) {
                System.out.println("Problem with inflater: " + e);
            }
        }
        return true;
    }

    private boolean wseek(long offset, boolean finish) {
        if (offset >= this.uoffset + (long)this.ulength || finish) {
            int ulen = (int)(offset - this.uoffset);
            if (ulen > 0 && this.deflater.needsInput()) {
                this.deflater.setInput(this.ubuf, 0, ulen);
                this.uoffset += (long)ulen;
            }
            if (finish) {
                this.deflater.finish();
            }
            this.clength = -1;
            while (this.clength != 0) {
                try {
                    this.clength = this.deflater.deflate(this.cbuf, 0, CBUFSZ);
                }
                catch (Exception e) {
                    System.out.println("Problem with deflater: " + e);
                }
                if (this.clength <= 0) continue;
                this.io.write(this.cbuf, 0, this.clength, this.coffset);
                this.coffset += (long)this.clength;
            }
        }
        return true;
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public boolean open() {
        if (this.tandem) {
            return false;
        }
        return this.io.open();
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public boolean close() {
        if (this.dir > 0) {
            this.wseek(this.offset, true);
        }
        if (this.tandem) {
            return false;
        }
        return this.io.close();
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public long getLength() {
        return this.length;
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public void setLength(long length) {
        this.length = length;
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public int read(byte[] buf, int boff, int bytes) {
        boolean status = false;
        int off = boff;
        while (bytes > 0) {
            int ndo;
            int uoff = (int)(this.offset - this.uoffset);
            if (this.offset < this.cstart) {
                ndo = (int)(this.cstart - this.offset);
                if (ndo > bytes) {
                    ndo = bytes;
                }
                this.io.read(buf, boff, ndo, this.offset);
            } else {
                int n = ndo = uoff < 0 ? 0 : this.ulength - uoff;
                if (ndo <= 0) {
                    this.rseek(this.offset);
                    continue;
                }
                if (ndo > bytes) {
                    ndo = bytes;
                }
                System.arraycopy(this.ubuf, uoff, buf, boff, ndo);
            }
            bytes -= ndo;
            boff += ndo;
            this.offset += (long)ndo;
        }
        return boff;
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public int write(byte[] buf, int boff, int bytes) {
        boolean status = false;
        int off = boff;
        while (bytes > 0) {
            int ndo;
            if (this.offset < this.cstart) {
                ndo = (int)(this.cstart - this.offset);
                if (ndo > bytes) {
                    ndo = bytes;
                }
                this.io.write(buf, boff, ndo, this.offset);
            } else {
                int uoff = (int)(this.offset - this.uoffset);
                int n = ndo = uoff < 0 ? 0 : this.ulength - uoff;
                if (ndo > bytes) {
                    ndo = bytes;
                }
                if (ndo <= 0) {
                    this.wseek(this.offset, false);
                    continue;
                }
                System.arraycopy(buf, boff, this.ubuf, uoff, ndo);
            }
            bytes -= ndo;
            boff += ndo;
            this.offset += (long)ndo;
        }
        return boff;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    void setBuffer(byte[] buf, long offset, int length) {
        this.ubuf = buf;
        this.uoffset = offset;
        this.ulength = length;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    byte[] getBuffer() {
        return this.ubuf;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    long getCompressedOffset() {
        return this.coffset;
    }
}

