/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Build;
import nxm.sys.lib.Convert;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.Foreign;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.SSLUtilities;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.ZipFile;

public class JarFile
extends ZipFile {
    Manifest manifest;

    public JarFile() {
    }

    @Deprecated
    public JarFile(Object ref, Object filename) {
        this.init(Convert.ref2Midas(ref), filename);
    }

    public JarFile(MidasReference ref, Object filename) {
        this.init(ref, filename);
    }

    @Override
    public String getMimeType() {
        return "application/x-java-archive";
    }

    @Override
    ZipEntry[] readZipFile() throws IOException {
        String fname = FileUtil.toLocalFileName(this.getURL());
        java.util.jar.JarFile jarFile = new java.util.jar.JarFile(fname);
        this.manifest = jarFile.getManifest();
        return fname == null ? null : this.readZipFile(jarFile);
    }

    @Override
    ZipEntry[] readZipInputStream() throws IOException {
        JarInputStream in = new JarInputStream(this.io.getInputStream());
        this.manifest = in.getManifest();
        return this.readZipInputStream(in);
    }

    @Override
    public String listHeader() {
        return "JarFile          : " + this.getURL() + "\nEntries          : " + this.getNumEntries() + "\nBytes            : " + this.getSize() + "\nMain Attributes  : " + this.listMainAttributes() + "Manifest Entries : " + this.listManifestEntries();
    }

    private String listMainAttributes() {
        StringBuilder attr = new StringBuilder();
        if (this.manifest == null) {
            attr.append("(not available)\n");
        } else {
            attr.append("\n");
            for (Map.Entry<Object, Object> entry : this.manifest.getMainAttributes().entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                attr.append("  ").append(StringUtil.padRight(key, 32));
                attr.append(" : ").append(value).append('\n');
            }
        }
        return attr.toString();
    }

    private String listManifestEntries() {
        StringBuilder ent = new StringBuilder();
        if (this.manifest == null) {
            ent.append("(not available)\n");
        } else {
            ent.append("(excludes SHA1-Digest)\n");
            Iterator<String> entries = this.manifest.getEntries().keySet().iterator();
            while (entries.hasNext()) {
                String name = entries.next().toString();
                boolean anyAttr = false;
                for (Map.Entry<Object, Object> entry : this.manifest.getAttributes(name).entrySet()) {
                    String key = entry.getKey().toString();
                    String value = entry.getValue().toString();
                    if (key.equals("SHA1-Digest")) continue;
                    if (!anyAttr) {
                        anyAttr = true;
                        ent.append("  ").append(StringUtil.padRight(name, 32)).append(" :");
                    }
                    ent.append(' ').append(key).append('=').append(value);
                }
                if (!anyAttr) continue;
                ent.append('\n');
            }
        }
        return ent.toString();
    }

    @Override
    void notEditable() {
        throw new UnsupportedOperationException("JarFile is not editable.");
    }

    @Override
    public Table getDataTable(double offset) {
        if (offset < 0.0) {
            return null;
        }
        if (offset >= (double)this.zipEntries.length) {
            return null;
        }
        Table t = super.getDataTable(offset);
        JarEntry e = (JarEntry)this.zipEntries[(int)offset];
        StringBuilder attrs = new StringBuilder();
        String certs = "";
        String signers = "";
        try {
            Attributes a = e.getAttributes();
            Object[] c = e.getCertificates();
            Object[] s = e.getCodeSigners();
            if (a != null) {
                for (Map.Entry<Object, Object> ent : a.entrySet()) {
                    if (attrs.length() != 0) {
                        attrs.append(", ");
                    }
                    attrs.append(ent.getKey()).append(":").append(ent.getValue());
                }
            }
            if (c != null) {
                certs = StringUtil.join(c);
            }
            if (s != null) {
                signers = StringUtil.join(s);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        t.put("ATTRIBUTES", (Object)attrs);
        t.put("CERTIFICATES", (Object)certs);
        t.put("CODE_SIGNERS", (Object)signers);
        return t;
    }

    @Override
    public int getRecordDefCount() {
        return super.getRecordDefCount() + 3;
    }

    @Override
    public Table getRecordDef(int i) {
        Table t;
        switch (i - super.getRecordDefCount()) {
            case 0: {
                t = new Table();
                t.put("NAME", (Object)"ATTRIBUTES");
                break;
            }
            case 1: {
                t = new Table();
                t.put("NAME", (Object)"CERTIFICATES");
                break;
            }
            case 2: {
                t = new Table();
                t.put("NAME", (Object)"CODE_SIGNERS");
                break;
            }
            default: {
                t = super.getRecordDef(i);
            }
        }
        return t;
    }

    public static void signJarFile(Midas midas, FileName fname) {
        JarFile.signJarFile(midas, fname, null, null, null, false);
    }

    @InternalUseOnly(value="Since initial version")
    public static void signJarFile(Midas midas, FileName fname, String opt, Table customKeystoreCfg, String customJarsignerOptions, boolean debug) {
        String optionsFromBuildProps;
        String keyAlias;
        String keystoreFilePath;
        if (fname == null) {
            throw new IllegalArgumentException("JAR FileName cannot be null");
        }
        if (midas == null) {
            midas = Shell.getSharedMidasContext();
        }
        if (!FileUtil.isLocalFileName(fname.toString())) {
            throw new MidasException("JarFile.signJarFile(...): Can only sign JAR files on the local disk; given '" + fname + "'.");
        }
        String sep = File.separator;
        String jarFilename = FileUtil.toLocalFileName(fname.toString());
        if (jarFilename.length() == 0) {
            throw new MidasException("JarResource.signJar(..): Can only sign JAR, no file name given.");
        }
        String storePass = null;
        String keyPass = null;
        String optionsFromCfgTab = null;
        if (customKeystoreCfg != null) {
            keystoreFilePath = customKeystoreCfg.getS("KEYSTOREFILE");
            keyAlias = customKeystoreCfg.getS("KEYALIAS");
            storePass = customKeystoreCfg.getS("KEYSTOREPASS");
            keyPass = customKeystoreCfg.getS("KEYPASS");
            optionsFromCfgTab = customKeystoreCfg.getS("MOREOPTIONS");
        } else {
            keystoreFilePath = Shell.getOptPath("sys", "cfg") + "keystore";
            storePass = "nmsign";
            keyAlias = "nmsign";
        }
        if (keystoreFilePath == null || keystoreFilePath.isEmpty()) {
            throw new IllegalArgumentException("KEYSTOREFILE= is required! given " + keystoreFilePath);
        }
        if (keyAlias == null || keyAlias.isEmpty()) {
            throw new IllegalArgumentException("KEYALIAS= is required! given " + keyAlias);
        }
        if (storePass == null || storePass.isEmpty()) {
            throw new IllegalArgumentException("KEYSTOREPASS= is required! given " + storePass);
        }
        StringBuilder cmdline = new StringBuilder(256);
        String javahome = Shell.getProperty("JAVAHOME");
        cmdline.append(FileName.terminatePath(javahome)).append("bin").append(sep).append("jarsigner");
        if (opt == null) {
            opt = "SYS";
        }
        if ((optionsFromBuildProps = Build.getPropertyStatic(opt, "jarsigner.flags")) != null && optionsFromBuildProps.length() > 0) {
            cmdline.append(' ').append(optionsFromBuildProps);
        }
        cmdline.append(" -keystore ").append(keystoreFilePath);
        if (storePass != null && !storePass.isEmpty()) {
            cmdline.append(" -storepass");
            if (!storePass.startsWith(":env ") && !storePass.startsWith(":file ")) {
                cmdline.append(' ');
            }
            cmdline.append(storePass);
        }
        if (keyPass != null && !keyPass.isEmpty()) {
            cmdline.append(" -keypass ").append(keyPass);
        }
        if (optionsFromCfgTab != null) {
            cmdline.append(' ').append(optionsFromCfgTab);
        }
        if (customJarsignerOptions != null) {
            cmdline.append(' ').append(customJarsignerOptions);
        }
        cmdline.append(' ').append(jarFilename);
        cmdline.append(' ').append(keyAlias);
        if (javahome == null) {
            throw new MidasException("JAVAHOME OS env not set to JDK directory, cannot run: " + cmdline);
        }
        if (debug) {
            midas.type("Running following command to sign jar: " + cmdline);
        }
        if (Foreign.runInternal(midas, cmdline.toString(), true) != 0) {
            if (Shell.getJavaMajorVersion() == 8 && Shell.getJavaUpdateVersion() < 312 && customKeystoreCfg == null) {
                throw new MidasException("JarFile: Default JAR signing with JDK 8 requires update version 312 or greater, filename='" + jarFilename + "' command='" + cmdline + "'.");
            }
            throw new MidasException("JarFile: Unknown error while signing JAR, filename='" + jarFilename + "' command='" + cmdline + "'.");
        }
    }

    public static void createJarFile(Midas midas, FileName jarFile, String[] names, FileName[] files, boolean verbose) {
        JarFile.createJarFile(midas, jarFile, null, names, files, verbose, false);
    }

    @ProvisionalUseOnly(value="This improved method of signing jars is not yet fully tested")
    public static void createJarFile(Midas midas, FileName jarFile, Manifest manifest, String[] names, FileName[] files, boolean verbose, boolean sign) {
        try (FileOutputStream dest = new FileOutputStream(jarFile.toString());
             BufferedOutputStream bos = new BufferedOutputStream(dest);
             JarOutputStream out = manifest == null ? new JarOutputStream(bos) : new JarOutputStream((OutputStream)bos, manifest);){
            ZipFile.createZipFile(midas, out, names, files, true, verbose);
            out.flush();
        }
        catch (Exception e) {
            throw new MidasException("JarFile: Error unable to create jar file", e);
        }
        if (sign) {
            SSLUtilities.signJarFile(jarFile);
        }
    }

    @InternalUseOnly(value="Since initial version")
    public static void createJarFile(Midas midas, FileName jarFile, Manifest manifest, String[] names, FileName[] files, boolean verbose, boolean sign, String opt, Table customKeystoreCfg, String customJarsignerOptions, boolean debug) {
        try {
            FileOutputStream dest = new FileOutputStream(jarFile.toString());
            BufferedOutputStream bos = new BufferedOutputStream(dest);
            JarOutputStream out = manifest == null ? new JarOutputStream(bos) : new JarOutputStream((OutputStream)bos, manifest);
            ZipFile.createZipFile(midas, out, names, files, true, verbose);
        }
        catch (Exception e) {
            throw new MidasException("JarFile: Error unable to create jar file", e);
        }
        if (sign) {
            if (verbose) {
                String moreDetails = "";
                if (customKeystoreCfg != null) {
                    moreDetails = " with custom keystore file " + customKeystoreCfg.getS("KEYSTOREFILE");
                }
                midas.info("Signing JAR file " + jarFile + moreDetails);
            }
            JarFile.signJarFile(midas, jarFile, opt, customKeystoreCfg, customJarsignerOptions, debug);
        }
    }
}

