/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;

public class Import {
    @Deprecated
    public Import() {
    }

    public static Table getEnvTable() {
        Table tbl = new Table();
        Properties env = Import.getProperties();
        Enumeration<?> e = env.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.indexOf(".") >= 0) {
                System.out.println("ENV VAR WITH DOT => Name " + name);
                continue;
            }
            tbl.put(name, (Object)env.getProperty(name));
        }
        return tbl;
    }

    public static String getEnv(String key) {
        return System.getenv(key);
    }

    public static String getEnv(String key, String defVal) {
        String value = null;
        try {
            value = System.getenv(key);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (value == null) {
            value = defVal;
        }
        return value;
    }

    private static Properties getProperties() {
        Properties env = new Properties();
        try {
            Map<String, String> envMap = System.getenv();
            for (Map.Entry<String, String> entry : envMap.entrySet()) {
                env.setProperty(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            throw new MidasException("Unable to get environment variables", e);
        }
        return env;
    }

    public static String expandEnvVars(String text) {
        return StringUtil.expandVariables(text, System.getenv(), 1);
    }
}

