/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.Closeable;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import nxm.sys.inc.IOResourceFactory;
import nxm.sys.lib.ClassPathResource;
import nxm.sys.lib.Convert;
import nxm.sys.lib.FileResource;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.FtpResource;
import nxm.sys.lib.HttpResource;
import nxm.sys.lib.JarResource;
import nxm.sys.lib.MftpResource;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.NFileResource;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.PipeResource;
import nxm.sys.lib.RamResource;
import nxm.sys.lib.Registry;
import nxm.sys.lib.SocketResource;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.lib.UdpResource;
import nxm.sys.lib.UrlResource;

public class IOResource {
    protected int type;
    protected Midas M;
    protected int dir;
    protected long offset = 0L;
    protected long length = -1L;
    public boolean isOpen;
    public static final int UNKNOWN = 0;
    public static final int FILE = 1;
    public static final int PIPE = 2;
    public static final int SOCK = 3;
    public static final int UDP = 4;
    public static final int HTTP = 5;
    public static final int JAR = 6;
    public static final int RAM = 7;
    public static final int NFILE = 8;
    public static final int RAMD = 9;
    public static final int MFTP = 10;
    public static final int FTP = 11;
    public static final int URL = 12;
    public static final int USER = 13;
    public static final String typeList = "Unknown,File,Pipe,Socket,Udp,Http,Jar,Ram,NFile,RamDisk,MFtp,Ftp,Url,User";
    private static final String dirList = "InputTrunc,Input,InOut,Output,OutputTrunc";
    public static final int DIR_INPUT_TRUNC = -2;
    public static final int DIR_INPUT = -1;
    public static final int DIR_INOUT = 0;
    public static final int DIR_OUTPUT = 1;
    public static final int DIR_OUTPUT_TRUNC = 2;
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected String urlstr;
    protected Table qualTable;

    public static int getType(String urlstr) {
        int type = (urlstr = urlstr.toLowerCase()).startsWith("_") ? 2 : (urlstr.startsWith("file:") ? 1 : (urlstr.startsWith("jar:") ? 6 : (urlstr.startsWith("http:") ? 5 : (urlstr.startsWith("https:") ? 5 : (urlstr.startsWith("udp:") ? 4 : (urlstr.startsWith("stp:") ? 3 : (urlstr.startsWith("ftp:") ? 11 : (urlstr.startsWith("ram:_") ? 2 : (urlstr.startsWith("ram:") ? 7 : (urlstr.startsWith("ramd:") ? 9 : (urlstr.startsWith("ice:") ? 9 : (urlstr.startsWith("mftp:") ? 10 : (IOResource.isUserResource(urlstr) ? 13 : (IOResource.isURLResource(urlstr) ? 12 : 1))))))))))))));
        return type;
    }

    public static IOResource getInstance(Midas M, int type, String urlstr, int dir, Table quals) {
        String rg;
        IOResource res = null;
        if (type == 0) {
            type = IOResource.getType(urlstr);
        }
        if (type == 9 && !urlstr.endsWith(".det") && dir != 0) {
            type = 1;
        }
        if (type == 1 && quals != null && quals.getState("USENATIVE")) {
            type = 8;
        }
        if (quals != null && (rg = quals.getString("RG")) != null) {
            res = (IOResource)Registry.getHandler("RESOURCE." + rg);
        } else {
            switch (type) {
                case 1: {
                    res = new FileResource();
                    break;
                }
                case 2: {
                    res = new PipeResource();
                    break;
                }
                case 3: {
                    res = new SocketResource();
                    break;
                }
                case 11: {
                    res = new FtpResource();
                    break;
                }
                case 4: {
                    res = new UdpResource();
                    break;
                }
                case 5: {
                    res = new HttpResource();
                    break;
                }
                case 6: {
                    res = new JarResource();
                    break;
                }
                case 7: {
                    res = new RamResource();
                    break;
                }
                case 8: {
                    res = new NFileResource();
                    break;
                }
                case 10: {
                    res = new MftpResource();
                    break;
                }
                case 12: {
                    res = new UrlResource();
                    break;
                }
                case 9: 
                case 13: {
                    return IOResource.initUserInstance(M, type, urlstr, dir, quals);
                }
            }
        }
        if (res != null) {
            res.init(M, type, urlstr, dir, quals);
        }
        return res;
    }

    public final IOResource init(Midas M, int type, String urlstr, int dir, Table quals) {
        this.setContext(M);
        this.setDir(dir);
        this.setType(type);
        this.setURL(urlstr);
        this.setQualifiers(quals);
        return this;
    }

    public Midas getContext() {
        return this.M;
    }

    public void setContext(Midas M) {
        this.M = M;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTypeString() {
        return Parser.get(typeList, this.getType(), -1);
    }

    public static String getTypeString(Midas midas, String url) {
        int type = IOResource.getType(url);
        String str = Parser.get(typeList, type, -1);
        if (type == 13) {
            String name = url.substring(0, url.indexOf(58)).toUpperCase();
            str = Registry.getHandlerName("RESOURCE." + name);
            int index = str.lastIndexOf(46);
            if (index > 0) {
                str = str.substring(index + 1);
            }
            if (str.endsWith("Resource")) {
                str = str.substring(0, str.length() - 8);
            }
        }
        return str;
    }

    public String getURL() {
        return this.urlstr;
    }

    public void setURL(String urlstr) {
        this.urlstr = urlstr;
    }

    protected void setURL(String prefix, String ext, String[] roots, String urlstr) {
        IOResource archio;
        String archioURL;
        int index;
        String name = this.getClass().getName();
        String tmp = urlstr;
        boolean ok = false;
        for (int i = 0; !ok && i < roots.length; ++i) {
            ok = urlstr.indexOf(roots[i]) > 0;
        }
        if (!ok && ext != null && urlstr.endsWith(ext)) {
            urlstr = urlstr + roots[0];
            if (roots.length != 1) {
                this.M.warning(name + ": Missing file root specifier at end of " + tmp + ", should be one of '" + StringUtil.join(roots, "', '") + "'.");
            }
        }
        if (!ok && (index = urlstr.indexOf(33)) > 0) {
            urlstr = urlstr.substring(0, index) + roots[0] + urlstr.substring(index + 1);
            ok = true;
            this.M.warning(name + ": Missing file root specifier in " + tmp + ", found '!' but expected one of '" + StringUtil.join(roots, "', '") + "'.");
        }
        if (!ok && ext != null) {
            index = -1;
            String root = null;
            for (int i = 0; index == -1 && i < roots.length; ++i) {
                if (roots[i].length() <= 1) continue;
                root = roots[i].substring(1);
                index = urlstr.indexOf(ext + root);
            }
            if (index > 0) {
                urlstr = urlstr.substring(0, index += ext.length()) + "!" + urlstr.substring(index);
                ok = true;
                this.M.warning(name + ": Missing file root specifier in " + tmp + ", found '" + root + "' but expected one of '" + StringUtil.join(roots, "', '") + "'.");
            }
        }
        if (!ok && ext != null && (index = urlstr.indexOf(ext)) > 0) {
            urlstr = urlstr.substring(0, index += ext.length()) + roots[0] + urlstr.substring(index);
            ok = true;
            this.M.warning(name + ": Missing file root specifier in " + tmp + ", found '" + ext + "' but expected one of '" + StringUtil.join(roots, "', '") + "' immediately after " + ext + ".");
        }
        if (!ok) {
            throw new MidasException("Illegal archive specification, cound not find file/archive specifier in " + tmp + ".");
        }
        index = urlstr.indexOf(33);
        String filename = urlstr.substring(index);
        String archname = urlstr.substring(0, index);
        if (archname.startsWith(prefix)) {
            archname = archname.substring(prefix.length());
        }
        if (!(archioURL = (archio = this.M.io.findResource(archname, -1)).getURL()).startsWith("file:") && FileUtil.isLocalFileName(archioURL)) {
            archioURL = "file:" + archioURL;
        }
        archioURL = archioURL.replace('\\', '/');
        this.urlstr = prefix + archioURL + filename;
    }

    public InputStream getUrlStream() throws MalformedURLException, IOException {
        URL url = null;
        try {
            url = new URI(this.getURL()).toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException("Forming URL via URI failed:" + e.getMessage() + " " + e.getStackTrace());
        }
        return url.openStream();
    }

    public void setQualifiers(Table table) {
        this.qualTable = table;
    }

    public Object getQualifier(String key) {
        if (this.qualTable == null) {
            return null;
        }
        return this.qualTable.get(key);
    }

    public boolean getStateQualifier(String key) {
        Object obj = this.getQualifier(key);
        if (obj == null) {
            return false;
        }
        return Convert.o2bool(obj, this.M);
    }

    public static String dirToString(int dir) {
        String str = Parser.get(dirList, dir, -3);
        if (str.length() == 0) {
            str = dir < 0 ? "UnknownInput" : "UnknownOutput";
        }
        return str;
    }

    public int getDir() {
        return this.dir;
    }

    public void setDir(int dir) {
        this.dir = dir;
    }

    public long seek() {
        return this.offset;
    }

    public boolean seek(long offset) {
        return offset == this.offset;
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isStream() {
        return false;
    }

    public boolean isStreaming() {
        return false;
    }

    public boolean isPipe() {
        return this.type == 2;
    }

    public boolean isFile() {
        return this.type == 1 || this.type == 8;
    }

    public boolean isJarFile() {
        return this.type == 6;
    }

    public boolean exists() {
        return false;
    }

    public boolean open() {
        return false;
    }

    public boolean close() {
        return false;
    }

    public boolean delete() {
        return false;
    }

    public long getLength() {
        return 0L;
    }

    public void setLength(long val) {
        this.length = val;
    }

    public long avail() {
        return this.getLength() - this.offset;
    }

    public boolean isReady(int numBytes) {
        if (!this.isStream()) {
            return true;
        }
        if (this.avail() >= (long)numBytes) {
            return true;
        }
        long remainingBytes = this.getLength() - this.seek();
        if (remainingBytes < (long)numBytes) {
            return this.avail() == remainingBytes;
        }
        return false;
    }

    public long lastModified() {
        return 0L;
    }

    public Time lastModifiedTime() {
        Time time = new Time();
        long utcLastModified = this.lastModified();
        if (utcLastModified != 0L) {
            time.fromJ1970ms(utcLastModified);
        }
        return time;
    }

    public int read(byte[] buf, int boff, int bytes) {
        return -1;
    }

    public int write(byte[] buf, int boff, int bytes) {
        return -1;
    }

    public String[] getEntryList(FilenameFilter filter) {
        return null;
    }

    protected String[] filterEntries(FilenameFilter filter, String[] entries) {
        if (filter == null) {
            return entries;
        }
        ArrayList<String> list3 = new ArrayList<String>(entries.length);
        for (String name : entries) {
            if (!filter.accept(null, name)) continue;
            list3.add(name);
        }
        return list3.toArray(new String[list3.size()]);
    }

    public IOResource getEntry(String name) {
        return null;
    }

    public final boolean open(int dir) {
        this.setDir(dir);
        return this.open();
    }

    public final int read(byte[] buf, int boff, int bytes, long offset) {
        this.seek(offset);
        return this.read(buf, boff, bytes);
    }

    public int read(long lbuf, int boff, int bytes) {
        byte[] buf = new byte[bytes];
        int stat = this.read(buf, 0, bytes);
        Native.ja2p(buf, 0, lbuf, boff, bytes);
        return stat;
    }

    public final int write(byte[] buf, int boff, int bytes, long offset) {
        this.seek(offset);
        return this.write(buf, boff, bytes);
    }

    public int write(long lbuf, int boff, int bytes) {
        byte[] buf = new byte[bytes];
        Native.p2ja(lbuf, boff, buf, 0, bytes);
        int stat = this.write(buf, 0, bytes);
        return stat;
    }

    private int read() {
        byte[] buf = new byte[1];
        int count = this.read(buf, 0, buf.length);
        return count < 0 ? -1 : buf[0];
    }

    private void write(int b) {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, buf.length);
    }

    public InputStream getInputStream() {
        final IOResource self = this;
        return new InputStream(){

            @Override
            public int available() {
                return (int)Math.min(Integer.MAX_VALUE, self.avail());
            }

            @Override
            public int read() {
                return self.read();
            }

            @Override
            public int read(byte[] buf, int off, int len) {
                return self.read(buf, off, len);
            }

            @Override
            public void close() {
                self.close();
            }
        };
    }

    public OutputStream getOutputStream() {
        final IOResource self = this;
        return new OutputStream(){

            @Override
            public void write(int b) {
                self.write(b);
            }

            @Override
            public void write(byte[] buf, int off, int len) {
                self.write(buf, off, len);
            }

            @Override
            public void close() {
                self.close();
            }
        };
    }

    private static boolean isUserResource(String urlstr) {
        return IOResource.getUserResourceHandler(urlstr) != null;
    }

    private static IOResource initUserInstance(Midas M, int type, String urlstr, int dir, Table quals) {
        Object handler = IOResource.getUserResourceHandler(urlstr);
        if (handler instanceof IOResourceFactory) {
            IOResource res = ((IOResourceFactory)handler).getResourceFor(M, type, urlstr, dir, quals);
            if (res != null) {
                return res;
            }
            return new IOResource().init(M, type, urlstr, dir, quals);
        }
        return ((IOResource)handler).init(M, type, urlstr, dir, quals);
    }

    private static Object getUserResourceHandler(String urlstr) {
        int i = urlstr.indexOf(58);
        if (i < 2) {
            return null;
        }
        String name = urlstr.substring(0, i).toUpperCase();
        if (name.equals("CLASSPATH")) {
            return ClassPathResource.INSTANCE;
        }
        return Registry.getHandler("RESOURCE." + name);
    }

    static boolean isURLResource(String str) {
        if (str == null) {
            return false;
        }
        if (str.indexOf(58) > 1) {
            return Character.isLetter(str.charAt(0));
        }
        return false;
    }

    public Table getStatFS() {
        return null;
    }

    protected boolean closeIO(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

