/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.MidasIOException;
import nxm.sys.lib.Native;
import nxm.sys.lib.Table;

public class FileResource
extends IOResource {
    protected File file;
    private RandomAccessFile raf;

    @Override
    public boolean isContainer() {
        return this.file.isDirectory();
    }

    @Override
    public boolean exists() {
        boolean retVal = false;
        try {
            retVal = this.file.exists();
        }
        catch (SecurityException e) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    public void setURL(String str) {
        super.setURL(str);
        String localFileName = FileUtil.toLocalFileName(str);
        this.file = localFileName != null ? new File(localFileName) : new File(str);
    }

    @Override
    public String getURL() {
        int i;
        int n = i = this.urlstr != null ? this.urlstr.indexOf(":/") : -1;
        if (i > 0) {
            return this.urlstr;
        }
        if (this.file != null) {
            try {
                return this.file.toURI().toURL().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.urlstr == null) {
            return "file:<null url>";
        }
        if (i < 0) {
            i = this.urlstr.indexOf(":\\");
        }
        if (i < 0) {
            return "file:" + this.urlstr;
        }
        return this.urlstr;
    }

    @Override
    public InputStream getInputStream() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
        }
        catch (IOException e) {
            this.M.error(e);
        }
        return fis;
    }

    @Override
    public OutputStream getOutputStream() {
        FileOutputStream fis = null;
        try {
            fis = new FileOutputStream(this.file);
        }
        catch (IOException e) {
            this.M.error(e);
        }
        return fis;
    }

    @Override
    public boolean open() {
        this.isOpen = false;
        if (this.dir > 0 && this.getStateQualifier("MKDIR") && !this.mkdirs()) {
            this.M.error("Could not create parent directories for " + this);
        }
        try {
            this.raf = this.dir >= 0 ? new RandomAccessFile(this.file, "rw") : new RandomAccessFile(this.file, "r");
            if (this.dir == 2) {
                long newLength = this.length < 0L ? 0L : this.length;
                this.raf.setLength(newLength);
            }
            this.isOpen = true;
            if (this.getStateQualifier("DELETEONEXIT")) {
                this.file.deleteOnExit();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.isOpen;
    }

    @Override
    public boolean close() {
        if (!this.isOpen) {
            return false;
        }
        try {
            if (this.raf != null) {
                this.raf.close();
            }
            this.isOpen = false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public boolean seek(long offset) {
        if (offset == this.offset) {
            return true;
        }
        try {
            this.raf.seek(offset);
        }
        catch (IOException e) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public long avail() {
        return this.file.length() - this.offset;
    }

    @Override
    public int read(byte[] buf, int boff, int bytes) {
        int status = 0;
        int off = boff;
        while (bytes > 0) {
            try {
                status = this.raf.read(buf, off, bytes);
            }
            catch (IOException e) {
                if (this.M.io.isOptionSet(CoreIO.IOOptions.FileIONoAbort)) {
                    status = -1;
                }
                throw new MidasIOException("FileResource: Error Reading File!", e);
            }
            if (status <= 0) break;
            bytes -= status;
            off += status;
        }
        bytes = off - boff;
        if (status < 0 && bytes == 0) {
            return status;
        }
        this.offset += (long)bytes;
        return bytes;
    }

    @Override
    public int write(byte[] buf, int boff, int bytes) {
        try {
            this.raf.write(buf, boff, bytes);
        }
        catch (IOException e) {
            if (this.M.io.isOptionSet(CoreIO.IOOptions.FileIONoAbort)) {
                return -1;
            }
            throw new MidasIOException("FileResource: Error Writing File!", e);
        }
        this.offset += (long)bytes;
        return bytes;
    }

    @Override
    public String[] getEntryList(FilenameFilter filter) {
        return this.file.list(filter);
    }

    @Override
    public IOResource getEntry(String name) {
        return null;
    }

    public String toString() {
        return "FileResource : " + this.getURL();
    }

    public boolean mkdirs() {
        File dir = this.file.getParentFile();
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return dir.isDirectory();
    }

    @Override
    public Table getStatFS() {
        String path = this.urlstr;
        if (path == null) {
            return null;
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        if (path.indexOf(58) > 0) {
            return null;
        }
        long[] data = new long[10];
        int stat = Native.statfs(path, data);
        if (stat < 0) {
            data[2] = 1024L;
            data[1] = 1024L;
            data[0] = 1024L;
            data[3] = 0L;
        }
        int tmby = (int)(data[0] * data[1] / 1000000L);
        int fmby = (int)(data[0] * data[2] / 1000000L);
        int files = (int)data[3];
        int used = (int)(100L - 100L * data[2] / Math.max(1L, data[1]));
        Table stats = new Table();
        stats.put("PATH", (Object)path);
        stats.put("FILES", files);
        stats.put("TMBY", tmby);
        stats.put("FMBY", fmby);
        stats.put("USED", used);
        return stats;
    }

    @Override
    public long lastModified() {
        return this.file == null ? 0L : this.file.lastModified();
    }
}

