/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.LinkedHashMap;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Time;

@InternalUseOnly
public class DataFileStreamSupport {
    private static final int IKOFF = 164;
    char NULL = '\u0000';
    private byte[] mainKWBytes = ("VER=1.1" + this.NULL + "IO=NeXtMidas" + this.NULL + "CREATOR=NXM" + "4.1.4" + this.NULL).getBytes();
    private int BLOCK_SIZE_MINUS_1 = 511;
    private String version = "BLUE";
    private String header_rep = Shell.osrep;
    private String data_rep = Shell.osrep;
    private int detached = 1;
    private int protectedFlag = 0;
    private int pipe = 0;
    private int ext_start = 1;
    private int ext_size;
    private double data_start = 0.0;
    private double data_size = 0.0;
    private int type = 1000;
    private String format = "SF";
    private short flagmask = 0;
    private double timeCode = 0.0;
    private short inlet = 0;
    private short outlets = 0;
    private int outmask = 0;
    private int pipeloc = 0;
    private int pipesize = 0;
    private double in_byte = 0.0;
    private double out_byte = 0.0;
    private double out_bytes = 0.0;
    private int keylength = this.mainKWBytes.length;
    private double xstart = 0.0;
    private double xdelta = 1.0;
    private int xunits;
    private int subsize = 0;
    private double ystart = 0.0;
    private double ydelta = 1.0;
    private int yunits = 1;
    private byte formatMode;
    private byte formatType;
    private Keywords extHeaderKWs = null;

    public byte[] packBlueFile(byte[] data) {
        return this.packBlueFile(data, 0, data.length);
    }

    public byte[] packBlueFile(byte[] data, int off, double data_size) {
        this.detached = 0;
        this.data_start = 512.0;
        this.data_size = data_size;
        int numBlocksData = (int)((data_size + (double)this.BLOCK_SIZE_MINUS_1) / 512.0);
        int dataBlocksSize = numBlocksData * 512;
        this.ext_start = 1 + numBlocksData;
        this.calcExtHeaderSize();
        int extKWBlocksSize = (this.ext_size + this.BLOCK_SIZE_MINUS_1) / 512;
        int blueFileSize = 512 + dataBlocksSize + extKWBlocksSize * 512;
        byte[] blueFileBytes = new byte[blueFileSize];
        this.packHeaderControlBlock(blueFileBytes);
        if (data_size > 0.0) {
            System.arraycopy(data, off, blueFileBytes, (int)this.data_start, (int)data_size);
        }
        if (this.ext_size != 0) {
            System.arraycopy(this.extHeaderKWs.buf, 0, blueFileBytes, this.ext_start * 512, this.ext_size);
        }
        return blueFileBytes;
    }

    public byte[] packDetachedHeader() {
        this.detached = 1;
        this.data_start = 0.0;
        this.calcExtHeaderSize();
        byte[] detachedHeader = new byte[512 + this.ext_size];
        this.packHeaderControlBlock(detachedHeader);
        if (this.ext_size != 0) {
            System.arraycopy(this.extHeaderKWs.buf, 0, detachedHeader, this.ext_start * 512, this.ext_size);
        }
        return detachedHeader;
    }

    public byte[] packMainHeaderBuffer() {
        this.calcExtHeaderSize();
        byte[] mainHeader = new byte[512];
        this.packHeaderControlBlock(mainHeader);
        return mainHeader;
    }

    public byte[] packExtendedHeaderBuffer() {
        this.calcExtHeaderSize();
        int extKWBlocksSize = (this.ext_size + this.BLOCK_SIZE_MINUS_1) / 512;
        byte[] extendedHeader = new byte[extKWBlocksSize];
        if (this.ext_size != 0) {
            System.arraycopy(this.extHeaderKWs.buf, 0, extendedHeader, 0, this.ext_size);
        }
        return extendedHeader;
    }

    private void packHeaderControlBlock(byte[] hb) {
        byte headerRep = Data.getRep(this.header_rep);
        Convert.packS(hb, 0, 4, this.version);
        Convert.packS(hb, 4, 4, this.header_rep);
        Convert.packS(hb, 8, 4, this.data_rep);
        Convert.packL(hb, 12, this.detached, headerRep);
        Convert.packL(hb, 16, this.protectedFlag, headerRep);
        Convert.packL(hb, 20, this.pipe, headerRep);
        Convert.packL(hb, 24, this.ext_start, headerRep);
        Convert.packL(hb, 28, this.ext_size, headerRep);
        Convert.packD(hb, 32, this.data_start, headerRep);
        Convert.packD(hb, 40, this.data_size, headerRep);
        Convert.packL(hb, 48, this.type, headerRep);
        Convert.packS(hb, 52, 2, this.format);
        Convert.packD(hb, 56, this.timeCode, headerRep);
        Convert.packL(hb, 160, this.keylength, headerRep);
        Convert.packD(hb, 256, this.xstart, headerRep);
        Convert.packD(hb, 264, this.xdelta, headerRep);
        Convert.packL(hb, 272, this.xunits, headerRep);
        Convert.packL(hb, 276, this.subsize, headerRep);
        Convert.packD(hb, 280, this.ystart, headerRep);
        Convert.packD(hb, 288, this.ydelta, headerRep);
        Convert.packL(hb, 296, this.yunits, headerRep);
        System.arraycopy(this.mainKWBytes, 0, hb, 164, this.keylength);
    }

    private void calcExtHeaderSize() {
        this.ext_size = this.extHeaderKWs != null && this.extHeaderKWs.buf != null ? this.extHeaderKWs.size : 0;
    }

    public void setDetached(boolean isDetached) {
        this.detached = isDetached ? 1 : 0;
    }

    public void setDetached(int detached) {
        this.detached = detached;
    }

    public int getDetached() {
        return this.detached;
    }

    public void setProtected(boolean isProtected) {
        this.protectedFlag = isProtected ? 1 : 0;
    }

    public void setProtected(int protectedFlag) {
        this.protectedFlag = protectedFlag;
    }

    @InternalUseOnly
    public int getProtected() {
        return this.protectedFlag;
    }

    public void setExtStart(int ext_start) {
        this.ext_start = ext_start;
    }

    @InternalUseOnly
    public int getExtStart() {
        return this.ext_start;
    }

    @InternalUseOnly
    public void setExtSize(int ext_size) {
        this.ext_size = ext_size;
    }

    @InternalUseOnly
    public int getExtSize() {
        return this.ext_size;
    }

    public void setDataStart(double data_start) {
        this.data_start = data_start;
    }

    @InternalUseOnly
    public double getDataStart() {
        return this.data_start;
    }

    public void setDataSize(double data_size) {
        this.data_size = data_size;
    }

    @InternalUseOnly
    public double getDataSize() {
        return this.data_size;
    }

    @InternalUseOnly
    public void setType(int type) {
        this.type = type;
    }

    @InternalUseOnly
    public int getType() {
        return this.type;
    }

    @InternalUseOnly
    public void setFormat(String format) {
        if (format.length() != 2) {
            throw new IllegalArgumentException("DataFileStream.setFormat requires a 2-char string - illegal:" + format);
        }
        this.format = format;
    }

    @InternalUseOnly
    public String getFormat() {
        return this.format;
    }

    @InternalUseOnly
    public void setFormatMode(byte formatMode) {
        this.formatMode = formatMode;
        this.format = (char)formatMode + this.format.substring(1);
    }

    @InternalUseOnly
    public byte getFormatMode() {
        return this.formatMode;
    }

    @InternalUseOnly
    public void setFormatType(byte formatType) {
        this.formatType = formatType;
        this.format = this.format.substring(0, 1) + (char)formatType;
    }

    @InternalUseOnly
    public byte getFormatType() {
        return this.formatType;
    }

    public void setTimeCode(double timeCode) {
        this.timeCode = timeCode;
    }

    public void setTimeCode(Time time) {
        this.setTimeCode(time.getSec());
    }

    @InternalUseOnly
    public double getTimeCode() {
        return this.timeCode;
    }

    @InternalUseOnly
    public int getKeyLength() {
        return this.keylength;
    }

    @InternalUseOnly
    public void setExtendedHeaderKeywords(LinkedHashMap<String, Object> map) {
        this.extHeaderKWs = new Keywords();
        this.extHeaderKWs.setScope("EXT");
        this.extHeaderKWs.addAll(map);
    }

    @InternalUseOnly
    public void setXStart(double xstart) {
        this.xstart = xstart;
    }

    @InternalUseOnly
    public double getXStart() {
        return this.xstart;
    }

    @InternalUseOnly
    public void setXDelta(double xdelta) {
        this.xdelta = xdelta;
    }

    @InternalUseOnly
    public double getXDelta() {
        return this.xdelta;
    }

    public void setXUnits(int xunits) {
        this.xunits = xunits;
    }

    @InternalUseOnly
    public int getXUnits() {
        return this.xunits;
    }

    public void setSubsize(int subsize) {
        this.subsize = subsize;
    }

    @InternalUseOnly
    public int getSubsize() {
        return this.subsize;
    }

    @InternalUseOnly
    public void setYStart(double ystart) {
        this.ystart = ystart;
    }

    @InternalUseOnly
    public double getYStart() {
        return this.ystart;
    }

    @InternalUseOnly
    public void setYDelta(double ydelta) {
        this.ydelta = ydelta;
    }

    @InternalUseOnly
    public double getYDelta() {
        return this.ydelta;
    }

    public void setYUnits(int yunits) {
        this.yunits = yunits;
    }

    @InternalUseOnly
    public int getYUnits() {
        return this.yunits;
    }
}

