/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.Midas;
import nxm.sys.lib.PipeResource;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;

@InternalUseOnly
public class DataFileHeader {
    private DataFile df;
    private byte[] hbuf;
    private Midas M;
    private Keywords extendedHeaderKeywords;
    private Keywords mainKeywords;
    private Table headerValues;
    private Table headKeyTable;
    private Table headerValuesCS;
    private Table headKeyTableCS;
    private String headerRep;
    private String dataRep;
    private int type;
    private String format;
    private byte formatMode;
    private byte formatType;
    private double xStart;
    private double xDelta;
    private double yStart;
    private double yDelta;
    private short flagMask;
    private double dataSize;
    private double dataStart;
    private int extSize;
    private int extStart;
    private String version = "1.1";
    private int pipeId;
    private int detached;
    private int protectedFromOverwrite;
    private double timeCode;
    private int keyLength;
    private short inlet;
    private short outlet;
    private int pipeLoc;
    private int pipeSize;
    private double inByte;
    private double outByte;
    InputStream fis;
    IOResource res;
    PipeResource resPipe;
    private boolean ableToParseHeader = false;

    public DataFileHeader(DataFile df) {
        this.df = df;
        this.M = df.M;
        this.readHeader();
    }

    @InternalUseOnly
    public Keywords getExtendedHeaderKeywords() {
        if (this.res instanceof PipeResource) {
            return this.resPipe.pipe.getDataFile().getKeywordsObject();
        }
        if (this.extendedHeaderKeywords == null && this.ableToParseHeader) {
            long off = (long)this.extStart * 512L;
            if (!this.res.isOpen) {
                this.res.open();
            }
            int len = (this.extSize + 511) / 512 * 512;
            byte[] bufWithKeys = new byte[len];
            int bytes = this.res.read(bufWithKeys, 0, this.extSize, off);
            this.extendedHeaderKeywords = new Keywords();
            this.extendedHeaderKeywords.init(bufWithKeys, bytes, this.hbuf[4]);
            this.res.close();
        }
        return this.extendedHeaderKeywords;
    }

    private void readHeader() {
        try {
            this.res = this.M.io.findResource(this.df.getFileName(), -1, "", null, false);
            this.hbuf = new byte[512];
            if (this.res instanceof PipeResource) {
                this.resPipe = (PipeResource)this.res;
                this.res.exists();
                this.resPipe.df = this.df;
                Convert.packD(this.hbuf, 32, 0.0);
                Convert.packL(this.hbuf, 20, 0);
                this.resPipe.pipeSize = 131072;
                this.resPipe.open();
                this.resPipe.readHeader(this.hbuf);
            } else {
                this.res.open();
                this.fis = this.res.getInputStream();
                this.fis.read(this.hbuf);
            }
            this.version = Convert.unpackS(this.hbuf, 0, 4);
            this.headerRep = Convert.unpackS(this.hbuf, 4, 4);
            this.dataRep = Convert.unpackS(this.hbuf, 8, 4);
            this.detached = Convert.unpackL(this.hbuf, 12);
            this.protectedFromOverwrite = Convert.unpackL(this.hbuf, 16);
            this.pipeId = Convert.unpackL(this.hbuf, 20);
            this.extStart = Convert.unpackL(this.hbuf, 24);
            this.extSize = Convert.unpackL(this.hbuf, 28);
            this.dataStart = Convert.unpackD(this.hbuf, 32);
            this.dataSize = Convert.unpackD(this.hbuf, 40);
            this.type = Convert.unpackL(this.hbuf, 48);
            this.format = Convert.unpackS(this.hbuf, 52, 2);
            this.formatMode = Convert.unpackB(this.hbuf, 52);
            this.formatType = Convert.unpackB(this.hbuf, 53);
            this.flagMask = Convert.unpackI(this.hbuf, 54);
            this.timeCode = Convert.unpackD(this.hbuf, 56);
            this.inlet = Convert.unpackI(this.hbuf, 64);
            this.outlet = Convert.unpackI(this.hbuf, 66);
            this.pipeLoc = Convert.unpackL(this.hbuf, 72);
            this.pipeSize = Convert.unpackL(this.hbuf, 76);
            this.inByte = Convert.unpackD(this.hbuf, 80);
            this.outByte = Convert.unpackD(this.hbuf, 88);
            this.keyLength = Convert.unpackL(this.hbuf, 160);
            this.xStart = Convert.unpackD(this.hbuf, 256);
            this.xDelta = Convert.unpackD(this.hbuf, 264);
            if (this.type >= 2000) {
                this.yStart = Convert.unpackD(this.hbuf, 280);
                this.yDelta = Convert.unpackD(this.hbuf, 288);
            }
            this.ableToParseHeader = true;
        }
        catch (Exception e) {
            Shell.getMidasContext().warning("Unable to parse the header from " + this.df.getFileName());
        }
        finally {
            if (this.res != null) {
                this.res.close();
            }
            if (this.fis != null) {
                try {
                    this.fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @InternalUseOnly
    public void addToFile(char type, Object val, String name) {
        byte[] buf;
        File file = new File(this.df.filename);
        try {
            FileInputStream fis = new FileInputStream(file);
            buf = new byte[(int)file.length()];
            fis.read(buf);
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        byte[] data = this.packTestDataToBuffer(type, val);
        int off = this.extStart * 512 + this.extSize;
        if (off == 0) {
            off = (int)(this.dataStart + this.dataSize);
        }
        int ltag = name.length();
        int len = data.length;
        int length = (len + ltag + 15) / 8 * 8;
        short lext = (short)(length - len);
        if (buf.length < length + off) {
            int size = buf.length;
            byte[] bufo = buf;
            buf = new byte[length + off];
            System.arraycopy(bufo, 0, buf, 0, size);
        }
        Convert.packL(buf, off + 0, length);
        Convert.packI(buf, off + 4, lext);
        buf[off + 6] = ltag;
        buf[off + 7] = (byte)type;
        System.arraycopy(data, 0, buf, off + 8, len);
        int i = 0;
        int j = off + 8 + len;
        while (i < ltag) {
            buf[j++] = (byte)name.charAt(i++);
        }
        Convert.packL(buf, 28, this.extSize + length);
        Convert.packL(buf, 24, off / 512);
        this.extSize += length;
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            bos.write(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.readHeader();
    }

    @InternalUseOnly
    public byte[] packTestDataToBuffer(char type, Object val) {
        byte[] res = new byte[type == 'U' ? 2 : 4];
        if (type == 'U') {
            Convert.packI(res, 0, (Short)val);
        } else {
            Convert.packL(res, 0, (Integer)val);
        }
        return res;
    }

    @InternalUseOnly
    public byte[] getHeaderbuf() {
        return this.hbuf;
    }

    @InternalUseOnly
    public Keywords getMainKeywords() {
        if (this.res instanceof PipeResource) {
            return ((PipeResource)this.res).pipe.getDataFile().getKeywordsObject();
        }
        if (this.mainKeywords == null && this.ableToParseHeader) {
            if (!this.res.isOpen) {
                this.res.open();
            }
            byte[] mainKeysBuf = new byte[this.keyLength];
            this.res.read(mainKeysBuf, 0, this.keyLength, 164L);
            String keytemp = new String(mainKeysBuf);
            this.mainKeywords = new Keywords(this.df);
            this.mainKeywords.init(null, 0, this.hbuf[4]);
            String[] keyValueArray = this.keyValueArrayFromNullSeparatedKeys(keytemp);
            if (keyValueArray == null) {
                return this.mainKeywords;
            }
            for (int i = 0; i < keyValueArray.length - 1; i += 2) {
                this.mainKeywords.put(keyValueArray[i], keyValueArray[i + 1]);
            }
        }
        return this.mainKeywords;
    }

    private String[] keyValueArrayFromNullSeparatedKeys(String nullSeparatedKeys) {
        int lastIndex = (nullSeparatedKeys = nullSeparatedKeys.replaceAll(String.valueOf('\u0000'), "=")).length() - 1;
        if (lastIndex == -1) {
            return null;
        }
        if (nullSeparatedKeys.charAt(lastIndex) == '=') {
            nullSeparatedKeys = nullSeparatedKeys.substring(0, lastIndex);
        }
        return nullSeparatedKeys.split("=");
    }

    @InternalUseOnly
    public String getHeaderRep() {
        return this.headerRep;
    }

    @InternalUseOnly
    public String getDataRep() {
        return this.dataRep;
    }

    @InternalUseOnly
    public int getType() {
        return this.type;
    }

    @InternalUseOnly
    public String getFormat() {
        return this.format;
    }

    @InternalUseOnly
    public byte getFormatMode() {
        return this.formatMode;
    }

    @InternalUseOnly
    public byte getFormatType() {
        return this.formatType;
    }

    @InternalUseOnly
    public double getxStart() {
        return this.xStart;
    }

    @InternalUseOnly
    public double getxDelta() {
        return this.xDelta;
    }

    @InternalUseOnly
    public double getyStart() {
        return this.yStart;
    }

    @InternalUseOnly
    public double getyDelta() {
        return this.yDelta;
    }

    @InternalUseOnly
    public short getFlagMask() {
        return this.flagMask;
    }

    @InternalUseOnly
    public double getDataSize() {
        return this.dataSize;
    }

    @InternalUseOnly
    public double getDataStart() {
        return this.dataStart;
    }

    @InternalUseOnly
    public int getExtSize() {
        return this.extSize;
    }

    @InternalUseOnly
    public int getExtStart() {
        return this.extStart;
    }

    @InternalUseOnly
    public String getVersion() {
        return this.version;
    }

    @InternalUseOnly
    public int getPipeId() {
        return this.pipeId;
    }

    @InternalUseOnly
    public int getDetached() {
        return this.detached;
    }

    @InternalUseOnly
    public int getProtectedFromOverwrite() {
        return this.protectedFromOverwrite;
    }

    @InternalUseOnly
    public double getTimeCode() {
        return this.timeCode;
    }

    @InternalUseOnly
    public int getKeyLength() {
        return this.keyLength;
    }

    @InternalUseOnly
    public short getInlet() {
        return this.inlet;
    }

    @InternalUseOnly
    public short getOutlet() {
        return this.outlet;
    }

    @InternalUseOnly
    public int getPipeLoc() {
        return this.pipeLoc;
    }

    @InternalUseOnly
    public int getPipeSize() {
        return this.pipeSize;
    }

    @InternalUseOnly
    public double getInByte() {
        return this.inByte;
    }

    @InternalUseOnly
    public double getOutByte() {
        return this.outByte;
    }

    @InternalUseOnly
    public byte[] getHbuf() {
        return this.hbuf;
    }

    @InternalUseOnly
    public IOResource getRes() {
        return this.res;
    }

    @InternalUseOnly
    public boolean isAbleToParseHeader() {
        return this.ableToParseHeader;
    }

    Keywords getKeywords(String type) {
        return type.toUpperCase().equals("MAIN") ? this.getMainKeywords() : this.getExtendedHeaderKeywords();
    }

    Object getHeaderField(String fieldName) {
        String ucFieldName;
        switch (ucFieldName = fieldName.toUpperCase()) {
            case "TYPE": {
                return this.getType();
            }
            case "SIZE": {
                return this.getDataSize();
            }
            case "DATASTART": {
                return this.getDataStart();
            }
            case "DATAREP": {
                return this.getDataRep();
            }
            case "FORMAT": {
                return this.getFormat();
            }
            case "XSTART": {
                return this.getyStart();
            }
            case "XDELTA": {
                return this.getxDelta();
            }
            case "YSTART": {
                return this.getyStart();
            }
            case "YDELTA": {
                return this.getxDelta();
            }
            case "TIMECODE": {
                return this.getTimeCode();
            }
        }
        this.M.warning("DataFieldHeader.getHeaderField() does not currently have support for " + ucFieldName);
        return "";
    }

    @InternalUseOnly
    public Table getHeaderValuesCS() {
        if (this.headerValuesCS == null) {
            this.headerValuesCS = new Table("SLHM", "AutoReadPrev|CaseSensitive");
            this.headerValuesCS.put("Type", this.getType());
            this.headerValuesCS.put("Size", this.getDataSize());
            this.headerValuesCS.put("DataRep", (Object)this.getDataRep());
            this.headerValuesCS.put("Format", (Object)this.getFormat());
            this.headerValuesCS.put("XStart", this.getyStart());
            this.headerValuesCS.put("XDelta", this.getxDelta());
            this.headerValuesCS.put("YStart", this.getyStart());
            this.headerValuesCS.put("YDelta", this.getyDelta());
            this.headerValuesCS.put("Timecode", this.getTimeCode());
        }
        return this.headerValuesCS;
    }

    @InternalUseOnly
    public Table getHeaderAndKeywordsAsTableCS() {
        if (this.headKeyTableCS == null) {
            this.headKeyTableCS = new Table();
            this.headKeyTableCS.put("FileKeywordsMain", (Object)this.getMainKeywords().makeTable());
            this.headKeyTableCS.put("FileKeywordsExt", (Object)this.getExtendedHeaderKeywords().makeTable());
            this.headKeyTableCS.put("FileHeader", (Object)this.getHeaderValuesCS());
        }
        return this.headKeyTableCS;
    }

    @InternalUseOnly
    public Table getHeaderValues() {
        if (this.headerValues == null) {
            this.headerValues = new Table();
            this.headerValues.put("TYPE", this.getType());
            this.headerValues.put("SIZE", this.getDataSize());
            this.headerValues.put("DATASTART", this.getDataStart());
            this.headerValues.put("DATAREP", (Object)this.getDataRep());
            this.headerValues.put("FORMAT", (Object)this.getFormat());
            this.headerValues.put("XSTART", this.getyStart());
            this.headerValues.put("XDELTA", this.getxDelta());
            this.headerValues.put("YSTART", this.getyStart());
            this.headerValues.put("YDELTA", this.getxDelta());
            this.headerValues.put("TIMECODE", this.getTimeCode());
        }
        return this.headerValues;
    }

    @InternalUseOnly
    public Table getHeaderAndKeywordsAsTable() {
        if (this.headKeyTable == null) {
            this.headKeyTable = new Table();
            this.headKeyTable.put("MAIN", (Object)this.getMainKeywords().makeTable());
            this.headKeyTable.put("EXTENDED", (Object)this.getExtendedHeaderKeywords().makeTable());
            this.headKeyTable.put("HEADER", (Object)this.getHeaderValues());
        }
        return this.headKeyTable;
    }
}

