/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public final class Cache {
    public static final String cacheTypeList = "LRU,SLRU,_RESERVED_SLOT3_,AUTO,SAUTO";
    public static final int LRU = 1;
    public static final int SLRU = 2;
    static final int OLD_SLRU_CONST_VALUE = 3;
    public static final int AUTO = 4;
    public static final int SAUTO = 5;
    public static final int MIN_SIZE = 1;
    public static final double NO_AGE_LIMIT = 0.0;
    private CacheType cache = null;
    private Map<String, TimeStampedValue> vCache = null;
    private int maxSize = 1;
    private double maxAge = 0.0;
    private long statsPut = 0L;
    private long statsGet = 0L;
    private long statsRemove = 0L;
    private long statsClear = 0L;
    private long statsHits = 0L;
    private long statsVHits = 0L;
    private long statsExp = 0L;
    private long statsFull = 0L;

    public Cache(int maxSize) {
        this(5, maxSize, 0.0);
    }

    public Cache(String type, int maxSize) {
        this(type, maxSize, 0.0);
    }

    public Cache(int type, int maxSize) {
        this(type, maxSize, 0.0);
    }

    public Cache(String type, int maxSize, double maxAge) {
        this(Parser.find(cacheTypeList, type, -1), maxSize, maxAge);
    }

    public Cache(int type, int maxSize, double maxAge) {
        this(type, maxSize, maxAge, null);
    }

    @InternalUseOnly
    public Cache(int type, int size, double age, WeakHashMap<String, TimeStampedValue> vc) {
        if (vc == null) {
            vc = new WeakHashMap();
        }
        this.vCache = type == 1 || type == 4 ? vc : Collections.synchronizedMap(vc);
        switch (type) {
            case 1: {
                this.cache = new LRU();
                break;
            }
            case 2: {
                this.cache = new SLRU();
                break;
            }
            case 3: {
                this.cache = new SLRU();
                break;
            }
            case 4: {
                this.cache = new HashMapCache();
                break;
            }
            case 5: {
                this.cache = new ConcurrentHashMapCache();
                break;
            }
            default: {
                throw new MidasException("Cache: Invalid cache type '" + type + "'.");
            }
        }
        this.setMaxSize(size);
        this.setMaxAge(age);
    }

    public int getCacheType() {
        return this.cache.cacheType();
    }

    public String getCacheTypeName() {
        return Parser.get(cacheTypeList, this.getCacheType());
    }

    public Object peek(String key) {
        return this.getFromVCache(key, true);
    }

    public Object peek(String key, boolean vc) {
        return vc ? this.getFromVCache(key, true) : this.getFromCache(key, true);
    }

    public Object get(String key) {
        Object val = this.getFromCache(key, false);
        return val != null ? val : this.getFromVCache(key, false);
    }

    public Object get(String key, boolean vc) {
        Object val = this.getFromCache(key, false);
        return val != null || !vc ? val : this.getFromVCache(key, false);
    }

    public Object remove(String key) {
        Object val = this.getFromCache(key, true);
        if (val == null) {
            val = this.getFromVCache(key, true);
        } else {
            ++this.statsRemove;
        }
        this.cache.cacheRemove(key);
        this.vCache.remove(key);
        return val;
    }

    public void clear() {
        this.vCache.clear();
        this.cache.cacheClear();
        ++this.statsClear;
    }

    public void put(String key, Object val) {
        TimeStampedValue tsv = new TimeStampedValue(val);
        this.vCache.put(key, tsv);
        this.cache.cachePut(key, tsv);
        ++this.statsPut;
    }

    public String toString() {
        return "Cache: " + this.getStats();
    }

    @InternalUseOnly
    public Table getStats() {
        Table tbl = new Table();
        tbl.put("TYPE", (Object)this.getCacheTypeName());
        tbl.put("MAX_SIZE", this.getMaxSize());
        tbl.put("MAX_AGE", this.getMaxAge());
        tbl.put("TOTAL_PUTS", this.statsPut);
        tbl.put("TOTAL_GETS", this.statsGet);
        tbl.put("TOTAL_REMOVES", this.statsRemove);
        tbl.put("TOTAL_CLEARS", this.statsClear);
        tbl.put("TOTAL_HITS", this.statsHits);
        tbl.put("TOTAL_CAPACITY_DROPS", this.statsFull);
        tbl.put("TOTAL_EXPIRATION_DROPS", this.statsExp);
        tbl.put("TOTAL_VICTIM_CACHE_HITS", this.statsVHits);
        return tbl;
    }

    public synchronized void setMaxSize(int size) {
        if (size < 1) {
            Shell.getSharedMidasContext().warning("Cache size of " + size + " is too small using " + 1 + ".");
            size = 1;
        }
        if (this.maxSize != size) {
            this.maxSize = size;
            this.cache.cacheCleanup();
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public synchronized void setMaxAge(double age) {
        if (age < 0.0) {
            Shell.getSharedMidasContext().warning("Invalid maxAge of " + age + " for cache using NO_AGE_LIMIT.");
            age = 0.0;
        }
        if (this.maxAge != age) {
            this.maxAge = age;
            this.cache.cacheCleanup();
        }
    }

    public double getMaxAge() {
        return this.maxAge;
    }

    private Object getFromCache(String key, boolean peek) {
        TimeStampedValue tsv = peek ? this.cache.cachePeek(key) : this.cache.cacheGet(key);
        Object val = null;
        if (!peek) {
            ++this.statsGet;
        }
        if (tsv != null) {
            if (!peek) {
                ++this.statsHits;
            }
            if (tsv.isExpired()) {
                this.cache.cacheRemove(key);
                ++this.statsExp;
            } else {
                val = tsv.getValue();
            }
        }
        return val;
    }

    private Object getFromVCache(String key, boolean peek) {
        TimeStampedValue tsv = this.vCache.get(key);
        Object val = null;
        if (tsv != null) {
            if (tsv.isExpired()) {
                this.vCache.remove(key);
            } else {
                val = tsv.getValue();
                if (!peek) {
                    this.cache.cachePut(key, tsv);
                    ++this.statsVHits;
                }
            }
        }
        return val;
    }

    @InternalUseOnly(value="since created")
    public synchronized int size() {
        return this.cache.size();
    }

    @InternalUseOnly
    private class ConcurrentHashMapCache
    extends ConcurrentHashMap<String, TimeStampedValue>
    implements CacheType {
        private static final long serialVersionUID = 2013100700350L;

        public ConcurrentHashMapCache() {
            super(Math.max(Cache.this.maxSize, 16) + 1, 1.0f);
        }

        @Override
        public int cacheType() {
            return 5;
        }

        @Override
        public String toString() {
            return "SAUTO";
        }

        @Override
        public TimeStampedValue cacheGet(String key) {
            return (TimeStampedValue)this.get(key);
        }

        @Override
        public TimeStampedValue cacheRemove(String key) {
            return (TimeStampedValue)this.remove(key);
        }

        @Override
        public TimeStampedValue cachePeek(String key) {
            return (TimeStampedValue)this.get(key);
        }

        @Override
        public void cacheClear() {
            this.clear();
        }

        @Override
        public void cachePut(String key, TimeStampedValue val) {
            this.put(key, val);
            if (this.size() > Cache.this.maxSize) {
                Set set = this.entrySet();
                Iterator iter = set.iterator();
                for (int ii = 0; ii < 5 && iter.hasNext(); ++ii) {
                    Map.Entry entry = iter.next();
                    String aKey = (String)entry.getKey();
                    if (aKey.equals(key)) continue;
                    iter.remove();
                    Cache.this.statsRemove++;
                    break;
                }
            }
        }

        @Override
        public void cacheCleanup() {
            if (Cache.this.maxAge != 0.0 || this.size() > Cache.this.maxSize) {
                for (Map.Entry entry : this.entrySet()) {
                    TimeStampedValue tsv = (TimeStampedValue)entry.getValue();
                    if (!tsv.isExpired()) continue;
                    this.remove(tsv);
                }
                int toRemove = this.size() - Cache.this.maxSize;
                if (toRemove > 0) {
                    Iterator iter = this.entrySet().iterator();
                    while (iter.hasNext() && toRemove > 0) {
                        iter.remove();
                        Cache.this.statsRemove++;
                        --toRemove;
                    }
                }
            }
        }
    }

    @InternalUseOnly
    private class HashMapCache
    extends HashMap<String, TimeStampedValue>
    implements CacheType {
        private static final long serialVersionUID = 2013100700350L;

        public HashMapCache() {
            super(Math.max(Cache.this.maxSize, 16) + 1, 1.0f);
        }

        @Override
        public int cacheType() {
            return 4;
        }

        @Override
        public String toString() {
            return "AUTO";
        }

        @Override
        public TimeStampedValue cacheGet(String key) {
            return (TimeStampedValue)this.get(key);
        }

        @Override
        public TimeStampedValue cacheRemove(String key) {
            return (TimeStampedValue)this.remove(key);
        }

        @Override
        public TimeStampedValue cachePeek(String key) {
            return (TimeStampedValue)this.get(key);
        }

        @Override
        public void cacheClear() {
            this.clear();
        }

        @Override
        public void cachePut(String key, TimeStampedValue val) {
            this.put(key, val);
            if (this.size() > Cache.this.maxSize) {
                Iterator keyIter = this.keySet().iterator();
                for (int ii = 0; ii < 5 && keyIter.hasNext(); ++ii) {
                    String aKey = (String)keyIter.next();
                    if (aKey.equals(key)) continue;
                    keyIter.remove();
                    Cache.this.statsRemove++;
                    break;
                }
            }
        }

        @Override
        public void cacheCleanup() {
            if (Cache.this.maxAge != 0.0 || this.size() > Cache.this.maxSize) {
                for (Map.Entry entry : this.entrySet()) {
                    TimeStampedValue tsv = (TimeStampedValue)entry.getValue();
                    if (!tsv.isExpired()) continue;
                    this.remove(tsv);
                }
                int toRemove = this.size() - Cache.this.maxSize;
                if (toRemove > 0) {
                    Iterator iter = this.entrySet().iterator();
                    while (iter.hasNext() && toRemove > 0) {
                        iter.remove();
                        Cache.this.statsRemove++;
                        --toRemove;
                    }
                }
            }
        }
    }

    @InternalUseOnly
    private class SLRU
    extends LRU {
        private static final long serialVersionUID = 2012012300311L;

        private SLRU() {
        }

        @Override
        public int cacheType() {
            return 2;
        }

        @Override
        public String toString() {
            return "SLRU";
        }

        @Override
        public synchronized void cachePut(String key, TimeStampedValue val) {
            super.cachePut(key, val);
        }

        @Override
        public synchronized void cacheClear() {
            super.cacheClear();
        }

        @Override
        public synchronized void cacheCleanup() {
            super.cacheCleanup();
        }

        @Override
        public synchronized TimeStampedValue cacheGet(String key) {
            return super.cacheGet(key);
        }

        @Override
        public synchronized TimeStampedValue cacheRemove(String key) {
            return super.cacheRemove(key);
        }

        @Override
        public synchronized TimeStampedValue cachePeek(String key) {
            return super.cachePeek(key);
        }

        @Override
        protected synchronized boolean removeEldestEntry(Map.Entry<String, TimeStampedValue> eldest) {
            return super.removeEldestEntry(eldest);
        }
    }

    @InternalUseOnly
    private class LRU
    extends LinkedHashMap<String, TimeStampedValue>
    implements CacheType {
        private static final long serialVersionUID = 2012012200311L;

        public LRU() {
            super(Math.max(Cache.this.maxSize, 16) + 1, 1.0f, true);
        }

        @Override
        public int cacheType() {
            return 1;
        }

        @Override
        public TimeStampedValue cacheGet(String key) {
            return (TimeStampedValue)this.get(key);
        }

        @Override
        public TimeStampedValue cacheRemove(String key) {
            return (TimeStampedValue)this.remove(key);
        }

        @Override
        public String toString() {
            return "LRU";
        }

        @Override
        public void cacheClear() {
            this.clear();
        }

        @Override
        public void cachePut(String key, TimeStampedValue val) {
            this.put(key, val);
        }

        @Override
        public TimeStampedValue cachePeek(String key) {
            TimeStampedValue val = null;
            if (this.containsKey(key)) {
                Iterator iter = this.entrySet().iterator();
                while (iter.hasNext() && val == null) {
                    Map.Entry entry = iter.next();
                    if (!((String)entry.getKey()).equals(key)) continue;
                    val = (TimeStampedValue)entry.getValue();
                }
            }
            return val;
        }

        @Override
        public void cacheCleanup() {
            if (Cache.this.maxAge != 0.0 || this.size() > Cache.this.maxSize) {
                Iterator iter = this.entrySet().iterator();
                while (iter.hasNext()) {
                    TimeStampedValue tsv = (TimeStampedValue)iter.next().getValue();
                    if (!tsv.isExpired()) continue;
                    this.remove(tsv);
                    Cache.this.statsExp++;
                }
                int toRemove = this.size() - Cache.this.maxSize;
                if (toRemove > 0) {
                    iter = this.entrySet().iterator();
                    while (iter.hasNext() && toRemove > 0) {
                        this.remove(iter.next());
                        Cache.this.statsRemove++;
                        --toRemove;
                    }
                }
            }
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, TimeStampedValue> eldest) {
            boolean remove = false;
            if (Cache.this.maxAge == 0.0) {
                remove = this.size() > Cache.this.maxSize;
            } else if (eldest.getValue().isExpired()) {
                remove = true;
            } else if (this.size() <= Cache.this.maxSize) {
                remove = false;
            } else {
                remove = true;
                Iterator iter = this.entrySet().iterator();
                while (iter.hasNext()) {
                    TimeStampedValue tsv = (TimeStampedValue)iter.next().getValue();
                    if (!tsv.isExpired()) continue;
                    this.remove(tsv);
                    Cache.this.statsExp++;
                    remove = false;
                }
            }
            if (remove) {
                Cache.this.statsFull++;
            }
            return remove;
        }
    }

    private static interface CacheType {
        public int cacheType();

        public TimeStampedValue cachePeek(String var1);

        public TimeStampedValue cacheGet(String var1);

        public void cachePut(String var1, TimeStampedValue var2);

        public TimeStampedValue cacheRemove(String var1);

        public void cacheClear();

        public void cacheCleanup();

        @InternalUseOnly
        public int size();
    }

    @InternalUseOnly
    public class TimeStampedValue {
        private final Object value;
        private final double time;

        public TimeStampedValue(Object value) {
            this(value, Time.current());
        }

        public TimeStampedValue(Object value, double time) {
            this.value = value;
            this.time = time;
        }

        private Object getValue() {
            return this.value;
        }

        private double getTime() {
            return this.time;
        }

        private boolean isExpired() {
            return Cache.this.maxAge <= 0.0 ? false : this.time + Cache.this.maxAge < Time.current();
        }
    }
}

