/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import nxm.sys.inc.Installation;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Args;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Command;
import nxm.sys.lib.Convert;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.Foreign;
import nxm.sys.lib.Import;
import nxm.sys.lib.Macro;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import tools.BuildProps;

public class Build {
    public static final String MACRO_AREA = "mcr";
    public static final String INTR_AREA = "intr";
    public static final String PRIM_AREA = "prim";
    public static final String HOST_AREA = "host";
    public static final String TEST_AREA = "test";
    public static final String LIBC_AREA = "libc";
    public static final String LIBF_AREA = "libf";
    public static final String LIBM_AREA = "libm";
    public static final String BUILD_TYPE_LIST = "Java,Native,Host";
    public static final int BUILD_CLASS_FILES = 1;
    public static final int BUILD_NATIVE_FILES = 2;
    public static final int BUILD_HOST_FILES = 4;
    private static final File[] EMPTY_FILE_ARRAY = new File[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final boolean INTERNAL_JAVAH = false;
    private static final boolean INTERNAL_JAVADOC = false;
    private static Midas defaultMidas = null;
    private static boolean defaultShowDebug = false;
    private static boolean defaultKeepFiles = true;
    private static final char SEMICOLON = ';';
    private static final Pattern WHITESPACE_REGEX = Pattern.compile("\\s+");
    private static final Pattern COMMA_REGEX = StringUtil.COMMA_REGEX;
    private static final Pattern SEMICOLON_REGEX = Pattern.compile(";");
    private static final Pattern COMMA_OR_PIPE_REGEX = Pattern.compile("[,|]");
    private static final String[] compOptionsXBC = new String[]{"gfc", "ifc", "ifort", "ifx", "pgf77"};
    private static final String[] compOptionsNXM = new String[]{"gfc", "ifc", "ifort", "ifx", "pfc", "pgf77"};
    private static final String[] archOptions = new String[]{"32BIT", "64BIT", "CLASSIC"};
    private static final String defaultForCompiler = "ifort";
    private static String defaultGfcForCompiler = null;
    private static String gfcForCompiler = null;
    private static String gfcLibsDir = null;
    private static String forCompiler;
    private static String xmArchType;
    private static String[] prependSuffixes;
    private static String[] appendSuffixes;
    private Midas midas;
    private Shell shell;
    private boolean verbose;
    private boolean showDebug;
    private boolean keepFiles;
    private boolean forPreProc;
    private Vector<File> classFiles;
    private Vector<File> junitFiles;
    private Vector<File> nativeFiles;
    private Vector<File> cpphostFiles;
    private Vector<File> hostFiles;
    private Vector<File> clibFiles;
    private Vector<File> xlibFiles;
    private Vector<File> cleanFiles;
    private Table bldFlags;
    private int compileCount;
    private Map<String, Object> primConfig;
    private Map<String, Map<String, Object>> libConfigMap;
    private HashSet<String> platform;
    private JavaCompiler compiler = null;
    public static final String JAVA_SOURCE = ".java";
    public static final String C_SOURCE = ".c";
    public static final String CPP_SOURCE = ".cc";
    public static final String FOR_SOURCE = ".for";
    public static final String FLIB_SOURCE = ".flib";
    public static final String CLIB_SOURCE = ".clib";
    public static final String CPPLIB_SOURCE = ".cpplib";
    public static final String ALL_SOURCE = ".java|.c|.cc|.for|.flib|.clib|.cpplib";
    public static final String FPP_EXTENSION = ".fpp";
    public static final String OBJ_EXTENSION = ".o";
    private static final String[] LIB_EXTENSIONS;
    private static final String[] LIB_NAME_LIST;
    private static final String[] LIB_LIST_EXTS;
    public static final BuildFileFilter JAVA_SOURCE_FILTER;
    public static final BuildFileFilter C_SOURCE_FILTER;
    public static final BuildFileFilter CPP_SOURCE_FILTER;
    public static final BuildFileFilter FOR_SOURCE_FILTER;
    public static final BuildFileFilter CLIB_SOURCE_FILTER;
    public static final BuildFileFilter CPPLIB_SOURCE_FILTER;
    public static final BuildFileFilter FLIB_SOURCE_FILTER;
    public static final BuildFileFilter ALL_SOURCE_FILTER;
    private static final int DETECT_WARN_OR_ERROR = 12;
    @InternalUseOnly
    public static final int BUILD_SUCCESSFUL = 0;
    @InternalUseOnly
    public static final int BUILD_FAILURE = 1;

    private Build(Midas midas, boolean verbose, boolean showDebug, boolean keepFiles, String forCompiler, boolean forPreProc, Table bldFlags) {
        this.midas = midas;
        this.shell = Shell.getCurrent();
        this.verbose = verbose;
        this.showDebug = showDebug;
        this.keepFiles = keepFiles;
        Build.forCompiler = forCompiler;
        this.forPreProc = forPreProc;
        this.classFiles = new Vector();
        this.junitFiles = new Vector();
        this.nativeFiles = new Vector();
        this.cpphostFiles = new Vector();
        this.hostFiles = new Vector();
        this.clibFiles = new Vector();
        this.xlibFiles = new Vector();
        this.cleanFiles = new Vector();
        this.libConfigMap = new HashMap<String, Map<String, Object>>();
        this.platform = new HashSet();
        this.setBldFlags(bldFlags);
        this.reset();
        if (midas != null) {
            midas.resetBuildStatus();
        }
        if (System.getProperty("nxm.sys.lib.Shell.ostag") == null) {
            System.setProperty("nxm.sys.lib.Shell.ostag", Shell.ostag);
        }
    }

    private void reset() {
        this.classFiles.clear();
        this.junitFiles.clear();
        this.nativeFiles.clear();
        this.cpphostFiles.clear();
        this.hostFiles.clear();
        this.clibFiles.clear();
        this.xlibFiles.clear();
        this.cleanFiles.clear();
        this.libConfigMap.clear();
        this.platform.clear();
    }

    public static Build newInstance(Midas midas, boolean verbose, boolean showDebug, boolean keepFiles, Table bldFlags) {
        boolean forPreProc = true;
        String forCompiler = null;
        return new Build(midas, verbose, showDebug, keepFiles, forCompiler, forPreProc, bldFlags);
    }

    private void setBldFlags(Table flags) {
        this.bldFlags = flags != null ? flags : new Table();
    }

    private int compileClassFiles(List<File> files, boolean junit) {
        if (files == null) {
            files = Collections.emptyList();
        }
        if (files.isEmpty()) {
            return 0;
        }
        String flagsName = junit ? "junit.flags" : "java.flags";
        String opt = this.getOpt(files);
        String options = this.getProperty(opt, flagsName);
        int numFiles = 0;
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(WHITESPACE_REGEX.split(options)));
        for (File file : files) {
            if (file.exists()) {
                if (this.verbose) {
                    this.info("Compiling " + file.getAbsolutePath());
                }
                args.add(file.getAbsolutePath());
                ++numFiles;
                continue;
            }
            this.warn("File not found " + file);
        }
        if (numFiles > 0) {
            String option = this.getOpt(files.get(0).getParent());
            String classpath = Build.getClassPath(option);
            args.add(0, "-classpath");
            args.add(1, classpath);
            Object[] argArray = args.toArray(new String[args.size()]);
            boolean doInternalCompile = StringUtil.isFalse(BuildProps.getSysProp("compat.ext.javac"));
            if (doInternalCompile) {
                if (this.internalCompile((String[])argArray) != 0) {
                    numFiles = 0;
                }
            } else {
                String javac = "java." + Shell.ostype + ".javac";
                String command = BuildProps.getSysPath(javac) + " " + StringUtil.join(argArray, " ");
                if (!this.runInternalOS(command)) {
                    numFiles = -1;
                }
            }
        }
        return numFiles;
    }

    public static boolean compileDocs(String opt, String dir) {
        return Build.compileDocs(opt, dir, defaultShowDebug);
    }

    public static boolean compileDocs(String opt, String dir, boolean debug) {
        File overview;
        String path;
        String[] dirs;
        Midas midas = defaultMidas;
        opt = opt.toLowerCase();
        String java_cp = Build.getClassPath(opt);
        String javadoc = Build.getPropertyStatic(opt, "java." + Shell.ostype + ".javadoc");
        String docdir = Build.getPropertyStatic(opt, "javadoc." + Shell.ostype + ".dir");
        String javadocFlags = Build.getPropertyStatic(opt, "javadoc.flags");
        String packages = "";
        if (opt.equals("sys") && Integer.parseInt(Shell.getJavaVersion().split("[.]")[0]) < 9) {
            if (!Installation.ApplyBugFix.WORKAROUND_JDK8_JAVADOC_ISSUE) {
                packages = packages + " " + Shell.getNmRoot() + "tools" + File.separator + "NmClassLoader.java";
            }
            packages = packages + " tools";
        }
        if (dir != null && dir.length() > 0) {
            docdir = dir;
        }
        if ((dirs = midas.io.listFiles(path = Shell.getOptPath(opt, null), "*", "dir")) == null) {
            midas.warning("Can not compile docs for option " + opt);
            return false;
        }
        for (String area : dirs) {
            String apath = Shell.getOptPath(opt, area);
            String[] files = midas.io.listFiles(apath, "*", "java");
            if (files == null || files.length <= 0) continue;
            packages = packages + " nxm." + opt + "." + area;
        }
        String command = " -classpath " + java_cp + " " + javadocFlags + " -d " + docdir + FileName.LOCAL_PATH_DELIM + opt + " " + packages;
        File sysLink = new File(docdir + FileName.LOCAL_PATH_DELIM + "sys" + FileName.LOCAL_PATH_DELIM + "package-list");
        if (!opt.equals("sys") && sysLink.exists()) {
            command = " -link " + sysLink.getParent() + command;
        }
        if ((overview = new File(path + "overview.html")).exists()) {
            command = " -overview " + overview.getAbsolutePath() + command;
        }
        boolean success = true;
        try {
            if (packages.length() > 0) {
                Build.runInternalOS(midas, javadoc + " " + command, debug);
            }
            String indexFileName = docdir + FileName.LOCAL_PATH_DELIM + "index.html";
            String optFileName = docdir + FileName.LOCAL_PATH_DELIM + "opt.html";
            String[] options = Shell.getKnownOptionTrees();
            PrintStream indexFile = new PrintStream(new FileOutputStream(indexFileName));
            PrintStream optFile = new PrintStream(new FileOutputStream(optFileName));
            if (options == null) {
                options = new String[]{"SYS"};
            }
            indexFile.println("<html>\n  <head>\n    <!-- This file has been auto-generated by\n         nxm.sys.lib.Build. DO NOT EDIT! -->\n\n    <title>NeXtMidas Code Documentation</title>\n  </head>\n  <FRAMESET rows=\"5%,95%\">\n    <FRAME src=\"opt.html\"\n           name=\"optListFrame\"\n           title=\"All Option Trees\">\n    <FRAME src=\"sys/index.html\"\n           name=\"javadocFrame\"\n           title=\"Generated Documentation\">\n    <NOFRAMES>\n      This document is designed to be viewed using frames. If\n      you can see this message, your browser does not have frame\n      support turned on.<br>\n      <br>\n      <a href=\"opt.html\">Non-Frame Version</a>\n    </NOFRAMES>\n  </FRAMESET></html>");
            indexFile.close();
            optFile.println("<html>\n  <head>\n    <!-- This file has been auto-generated by\n         nxm.sys.lib.Build. DO NOT EDIT! -->\n\n    <title>NeXtMidas Option Trees</title>\n    <meta NAME=\"keywords\" CONTENT=\"Options\">\n    <link REL=\"stylesheet\" TYPE=\"text/css\"          HREF=\"sys/stylesheet.css\" TITLE=\"Style\">\n  </head>\n  <body bgcolor=\"white\">\n    <div style=\"text-align:center;\">\n      <font CLASS=\"FrameItemFont\">Option Trees: ");
            for (String option : options) {
                optFile.println("      &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <a href=\"" + option.toLowerCase() + "/index.html\" target=\"javadocFrame\">" + option.toUpperCase() + "</a>\n");
            }
            optFile.println("      </font>\n    </div>\n  </body>\n</html>\n");
            optFile.close();
        }
        catch (IOException exception) {
            midas.warning("Build is unable to create index file for javadoc pages.");
            success = false;
        }
        return success;
    }

    private String makeNativeHeader(String path, String name) {
        String area = this.getArea(path);
        String opt = this.getOpt(path);
        String javaCP = Build.getClassPath(opt);
        String javah = this.getProperty(opt, "java." + Shell.ostype + ".javah");
        String javac = this.getProperty(opt, "java." + Shell.ostype + ".javac");
        String clazz = "nxm." + opt + "." + area + "." + name;
        String header = path + "nxm_" + opt + "_" + area + "_" + name + ".h";
        String command = javah + " -classpath " + javaCP + " -jni -d " + path + " " + clazz;
        if (Integer.parseInt(Shell.getJavaVersion().split("[.]")[0]) >= 9) {
            clazz = "nxm/" + opt + "/" + area + "/" + name + JAVA_SOURCE;
            command = javac + " -classpath " + javaCP + " -h " + path + " " + Shell.getNmRoot() + File.separator + clazz;
        }
        this.runAutoOS(command);
        return header;
    }

    private int compileNativeFiles(File[] files) {
        int num_files = 0;
        boolean hasError = false;
        for (File file : files) {
            File javaFile = this.getJavaFile(file);
            if (!file.exists()) {
                this.warn("File not found " + file);
                continue;
            }
            String filename = file.getName();
            boolean isCppHostmainroutine = filename.equals("hostmainroutine.cc");
            if (javaFile == null && !isCppHostmainroutine) continue;
            try {
                int index = filename.indexOf(".");
                String name = filename.substring(0, index);
                String ext = filename.substring(index);
                String path = FileName.terminatePath(file.getParent());
                boolean cpp = CPP_SOURCE_FILTER.accept(file);
                if (this.verbose) {
                    this.info("Compiling " + file);
                }
                if (!this.compileNativeFile(path, name, ext, null)) {
                    this.warn("Unable to compile native code for " + file);
                    hasError = true;
                    continue;
                }
                ++num_files;
                if (isCppHostmainroutine) continue;
                String liblist = this.getLibList(path, name);
                if (!this.linkNativeLib(path, name, liblist, false, cpp)) {
                    this.warn("Unable to link native code for " + file);
                    hasError = true;
                    continue;
                }
                this.cleanFiles.add(new File(path + name + OBJ_EXTENSION));
                String[] icfiles = Shell.getSharedMidasContext().io.listFiles(path, name + "$*", "class");
                if (icfiles == null) continue;
                for (int ic = 0; ic < icfiles.length; ++ic) {
                    String icName;
                    String iclass;
                    block13: {
                        String fName = icfiles[ic];
                        int i1 = fName.indexOf(36);
                        int i2 = fName.lastIndexOf(46);
                        iclass = fName.substring(i1 + 1, i2);
                        icName = name + "$" + iclass;
                        String opt = this.getOpt(path);
                        String area = this.getArea(path);
                        try {
                            Class<?> clazz = Class.forName("nxm." + opt + "." + area + "." + icName);
                            clazz.getField("useNative");
                            if (!this.verbose) break block13;
                            this.info("Compiling " + file + " for " + clazz);
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    String ofile = path + icName + OBJ_EXTENSION;
                    if (!this.compileNativeFile(path, name, ext, ofile, "-DINNERCLASS_" + iclass)) {
                        this.warn("Unable to compile native code for " + icName);
                    }
                    if (!this.linkNativeLib(path, icName, liblist = this.getLibList(path, icName), false, cpp)) {
                        this.warn("Unable to link native code for " + icName);
                    }
                    this.cleanFiles.add(new File(ofile));
                }
            }
            catch (Exception e) {
                this.midas.printStackTrace("Unable to compile " + file, e);
                return -1;
            }
        }
        if (hasError) {
            return -1;
        }
        return num_files;
    }

    private int compileNativeHeaders(File[] files) {
        for (File file : files) {
            File javafile = this.getJavaFile(file);
            if (!file.exists()) {
                this.warn("File not found " + file);
                continue;
            }
            if (javafile == null) continue;
            try {
                int index = file.getName().indexOf(".");
                String name = file.getName().substring(0, index);
                String path = FileName.terminatePath(file.getParent());
                this.makeNativeHeader(path, name);
            }
            catch (Exception e) {
                this.midas.printStackTrace("Unable to build JNI header for " + file, e);
                return -1;
            }
        }
        return 0;
    }

    private File getJavaFile(File file) {
        if (file.exists() && (C_SOURCE_FILTER.accept(file) || CPP_SOURCE_FILTER.accept(file))) {
            int index = file.getName().indexOf(".");
            String name = file.getName().substring(0, index);
            File java = new File(file.getParent(), name + JAVA_SOURCE);
            if (java.exists()) {
                return java;
            }
            java = new File(file.getParent(), name + ".class");
            if (java.exists()) {
                return java;
            }
        }
        return null;
    }

    private int copyPrecompiledFiles(File[] files) {
        int count = 0;
        for (File file : files) {
            boolean valid;
            boolean bl = valid = C_SOURCE_FILTER.accept(file) || CPP_SOURCE_FILTER.accept(file);
            if (!file.exists()) {
                this.warn("File not found " + file);
                continue;
            }
            if (!valid || this.getJavaFile(file) == null) continue;
            int index = file.getName().indexOf(".");
            String name = file.getName().substring(0, index);
            String path = FileName.terminatePath(file.getParent());
            String dllDir = Shell.getNmRoot() + "os\\dos\\dlls\\";
            String in = dllDir + name + Shell.getSharedObjExt();
            String out = path + name + Shell.getSharedObjExt();
            try {
                FileUtil.copyBaseFile(this.midas, in, out);
            }
            catch (Exception e) {
                this.midas.printStackTrace("Could not copy pre-compiled DLL " + in + " to " + out + ": " + e.getMessage(), e);
            }
        }
        return count;
    }

    private boolean compileNativeFile(String path, String name, String ext, String outFile) {
        String opt = this.getOpt(path);
        String area = this.getArea(path);
        String inFile = path + name + ext;
        boolean cpp = CPP_SOURCE_FILTER.accept(inFile);
        if (outFile == null) {
            outFile = path + name + OBJ_EXTENSION;
        }
        String command = this.getCCompilerFlags(opt, cpp) + " " + this.getFlagsFromConfig(opt, area, name, "cflags") + " " + this.getCCompilerFlagsFromOSEnv(cpp) + " -o " + outFile + " " + inFile;
        return this.runAutoOS(command);
    }

    private boolean compileNativeFile(String path, String name, String ext, String outFile, String cflags) {
        String opt = this.getOpt(path);
        String area = this.getArea(path);
        String inFile = path + name + ext;
        boolean cpp = CPP_SOURCE_FILTER.accept(inFile);
        if (outFile == null) {
            outFile = path + name + OBJ_EXTENSION;
        }
        String command = this.getCCompilerFlags(opt, cpp) + " " + this.getFlagsFromConfig(opt, area, name, "cflags") + " " + this.getCCompilerFlagsFromOSEnv(cpp) + " " + cflags + " -o " + outFile + " " + inFile;
        return this.runAutoOS(command);
    }

    private boolean linkNativeLib(String path, String name, String liblist, boolean independent, boolean cpp) {
        String opt = this.getOpt(path);
        String area = this.getArea(path);
        StringBuilder cFiles = new StringBuilder();
        String libName = path + name + Shell.getSharedObjExt();
        if (!independent) {
            cFiles.append(path + name + OBJ_EXTENSION + " ");
        }
        if (cpp && area.equals(HOST_AREA)) {
            String xbclibpath = Shell.getOptPath("xbc", "lib");
            String hprim = xbclibpath + "libHPrimitive" + Shell.getSharedObjExt();
            String hmainroutine = xbclibpath + "hostmainroutine" + OBJ_EXTENSION;
            cFiles.append(hmainroutine + " " + hprim + " ");
        }
        cFiles.append(liblist);
        String command = this.getCCompiler(opt, cpp) + " -o " + libName + " " + cFiles + " " + this.getCLinkFlags(opt, cpp) + " " + this.getFlagsFromConfig(opt, area, name, "lflags");
        return this.runAutoOS(command);
    }

    private boolean compileFortran(String path, String name, String ext) {
        String area = this.getArea(path);
        String opt = this.getOpt(path);
        String inName = path + name + ext;
        String fppName = null;
        String outName = path + name + OBJ_EXTENSION;
        boolean status = true;
        String compFlags = this.getFortranCompiler(opt) + " " + this.getFlagsFromConfig(opt, area, name, "cflags") + " " + this.getFortranFlags(opt, area, path);
        if (this.forPreProc) {
            if (this.preprocessFortran(path, name, ext, FPP_EXTENSION, compFlags)) {
                inName = fppName = path + name + FPP_EXTENSION;
            } else {
                this.warn("Error while trying to preprocess " + inName);
                status = false;
            }
        }
        if (status) {
            status = this.runAutoOS(compFlags + " " + this.getFortranHostFlags(opt, area) + " -o " + outName + " " + inName);
            if (fppName != null && status) {
                this.cleanFiles.add(new File(fppName));
            }
        }
        return status;
    }

    @InternalUseOnly
    @Deprecated
    public static boolean preprocessFortran(String path, String nameList, String ext, String newExt, Object ref, boolean verbose, boolean debug, Table bldFlags) {
        Midas midas = Convert.ref2Midas(ref);
        if (!(ref instanceof Macro) || ((Macro)ref).option.equals("XBC")) {
            throw new MidasException("Error: nxm.sys.lib.Build.preprocessFortran is for internal use only.");
        }
        Build build = Build.newInstance(midas, verbose, bldFlags);
        build.showDebug = debug;
        String[] names = COMMA_OR_PIPE_REGEX.split(nameList);
        String area = build.getArea(path);
        String opt = build.getOpt(path);
        boolean ok = true;
        String flags = build.getFortranFlags(opt, area, path);
        for (int i = 0; ok && i < names.length; ++i) {
            String inName = path + names[i] + ext;
            if (verbose) {
                build.info("Preprocessing " + inName);
            }
            if (debug) {
                build.info("      using flags: " + flags);
            }
            if (ok = build.preprocessFortran(path, names[i], ext, newExt, flags)) continue;
            build.warn("Error while trying to preprocess " + inName);
        }
        return ok;
    }

    private boolean preprocessFortran(String path, String name, String oldExt, String newExt, String flags) {
        String oldName = FileName.terminatePath(path) + name + oldExt;
        String newName = FileName.terminatePath(path) + name + newExt;
        try {
            Class[] ctypes = new Class[]{Midas.class, Boolean.TYPE};
            Object[] cparam = new Object[]{this.midas, this.showDebug};
            Class[] types = new Class[]{String.class, String.class, String.class};
            Object[] params = new Object[]{oldName, newName, flags};
            Class<?> clazz = Class.forName("nxm.xbc.lib.FortranPreprocessor");
            Constructor<?> cons = clazz.getConstructor(ctypes);
            Object obj = cons.newInstance(cparam);
            Method meth = clazz.getMethod("preprocess", types);
            Boolean status = (Boolean)meth.invoke(obj, params);
            return status;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnsatisfiedLinkError) {
                BaseFile bf = new BaseFile(this.midas, (Object)"nxm.xbc.lib.FortranPreprocessor.class");
                if (!bf.exists()) {
                    this.midas.warning(">>>> ");
                    this.midas.warning(">>>> WARNING:");
                    this.midas.warning(">>>>   Can not preprocess Fortran file, XBC does not appear to have");
                    this.midas.warning(">>>>   been built yet. Please build XBC with 'nM> MAKE ALL XBC' first. ");
                    this.midas.warning(">>>> ");
                } else {
                    this.midas.warning(">>>> ");
                    this.midas.warning(">>>> WARNING:");
                    this.midas.warning(">>>>   Can not preprocess Fortran file, try building in the");
                    this.midas.warning(">>>>   NeXtMidas shell with Native code enabled. ");
                    this.midas.warning(">>>> ");
                }
            } else {
                this.midas.printStackTrace("Error building " + oldName, e);
            }
            return false;
        }
    }

    private boolean linkFortran(String path, String name, String libList, boolean independent) {
        String area = this.getArea(path);
        String opt = this.getOpt(path);
        String outName = path + name + Shell.getSharedObjExt();
        if (area.equals(HOST_AREA)) {
            String hprim = Shell.getOptPath("xbc", "lib") + "libHPrimitive" + Shell.getSharedObjExt();
            libList = hprim + " " + libList;
        }
        if (!independent) {
            libList = path + name + OBJ_EXTENSION + " " + libList;
        }
        String linkCmd = this.getFortranLinker(opt) + " " + this.getFlagsFromConfig(opt, area, name, "lflags") + " " + this.getFortranFlags(opt, area, path) + this.getFortranHostFlags(opt, area) + " -o " + outName + " " + libList;
        return this.runAutoOS(linkCmd);
    }

    private int compileHostFiles(File[] files) {
        int numFiles = 0;
        for (File file : files) {
            if (!file.exists()) {
                this.warn("File not found " + file);
                continue;
            }
            boolean isFortran = FOR_SOURCE_FILTER.accept(file);
            boolean isCpp = CPP_SOURCE_FILTER.accept(file);
            boolean isC = C_SOURCE_FILTER.accept(file);
            if (!isFortran && !isCpp && !isC) continue;
            try {
                String path = FileName.terminatePath(file.getParent());
                int index = file.getName().indexOf(46);
                String name = file.getName().substring(0, index);
                String ext = file.getName().substring(index);
                String liblist = this.getLibList(path, name);
                if (isFortran || isCpp) {
                    String outputFile;
                    File cFile = new File(path, name + C_SOURCE);
                    File cppFile = new File(path, name + CPP_SOURCE);
                    if (cFile.exists()) {
                        if (this.verbose) {
                            this.info("Compiling " + cFile);
                        }
                        if (!this.compileNativeFile(path, name, C_SOURCE, outputFile = path + name + "_c" + OBJ_EXTENSION)) {
                            this.warn("Unable to compile native C code for " + cFile);
                            return -1;
                        }
                        liblist = outputFile + " " + liblist;
                        this.cleanFiles.add(new File(outputFile));
                    }
                    if (!isCpp && cppFile.exists()) {
                        if (this.verbose) {
                            this.info("Compiling " + cppFile);
                        }
                        if (!this.compileNativeFile(path, name, CPP_SOURCE, outputFile = path + name + "_cc" + OBJ_EXTENSION)) {
                            this.warn("Unable to compile native C++ code for " + cppFile);
                            return -1;
                        }
                        liblist = outputFile + " " + liblist;
                        this.cleanFiles.add(new File(outputFile));
                    }
                }
                if (this.verbose) {
                    this.info("Compiling " + file);
                }
                if (isFortran) {
                    if (!this.compileFortran(path, name, ext) || !this.linkFortran(path, name, liblist, false)) {
                        this.warn("Unable to compile native Fortran code for " + file);
                        return -1;
                    }
                } else if (!this.compileNativeFile(path, name, ext, null) || !this.linkNativeLib(path, name, liblist, false, isCpp)) {
                    this.warn("Unable to compile native C/C++ code for " + file);
                    return -1;
                }
                this.cleanFiles.add(new File(path + name + OBJ_EXTENSION));
                ++numFiles;
            }
            catch (Exception e) {
                this.midas.printStackTrace("Unable to compile " + file + ": " + e.getMessage(), e);
            }
        }
        return numFiles;
    }

    private int buildSharedObjects(File[] files) {
        int numCompiled = 0;
        ArrayList<File> librariesAlreadyBuilt = new ArrayList<File>();
        for (File libfile : files) {
            if (librariesAlreadyBuilt.contains(libfile)) continue;
            numCompiled += this.buildShareObject(libfile, librariesAlreadyBuilt);
        }
        return numCompiled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int buildShareObject(File libfile, List<File> librariesAlreadyBuilt) {
        int numCompiled = 0;
        this.info("Building Shared Object " + libfile);
        File[] libs = this.prepareLibraries(libfile, true);
        if (libs.length == 0) {
            throw new MidasException("Unable to build shared object " + libfile);
        }
        String path = libfile.getParentFile().getAbsolutePath() + File.separator;
        String fname = libfile.getName();
        String name = fname.substring(0, fname.lastIndexOf(46));
        StringBuilder liblist = new StringBuilder();
        for (File file : libs) {
            String fullpathname;
            liblist.append(' ');
            try {
                fullpathname = file.getCanonicalPath();
            }
            catch (IOException ioe) {
                fullpathname = file.getAbsolutePath();
            }
            if (FLIB_SOURCE_FILTER.accept(file) || CLIB_SOURCE_FILTER.accept(file) || CPPLIB_SOURCE_FILTER.accept(file)) {
                String libname = fullpathname.substring(0, fullpathname.lastIndexOf(46)) + Shell.getSharedObjExt();
                if (!librariesAlreadyBuilt.contains(libfile) && !new File(libname).exists()) {
                    numCompiled += this.buildShareObject(file, librariesAlreadyBuilt);
                }
                liblist.append(libname);
                continue;
            }
            liblist.append(fullpathname);
        }
        if (FLIB_SOURCE_FILTER.accept(libfile)) {
            if (!this.linkFortran(path, name, liblist.toString(), true)) throw new MidasException("Unable to link libraries for " + libfile);
            ++numCompiled;
        } else {
            boolean cpp = CPPLIB_SOURCE_FILTER.accept(libfile);
            if (!this.linkNativeLib(path, name, liblist.toString(), true, cpp)) throw new MidasException("Unable to link libraries for " + libfile);
            ++numCompiled;
        }
        librariesAlreadyBuilt.add(libfile);
        return numCompiled;
    }

    private File[] prepareLibraries(File file, boolean compile) {
        File[] returnValue = EMPTY_FILE_ARRAY;
        boolean verbose = this.verbose && compile;
        boolean error = false;
        if (file.exists()) {
            try {
                String[] libs = this.readLibListFile(file);
                ArrayList<File> toLink = new ArrayList<File>();
                for (String libName : libs) {
                    String fileName = libName.replace('\\', File.separatorChar).replace('/', File.separatorChar);
                    File src = new File(fileName);
                    if (!src.exists()) {
                        if (verbose) {
                            this.warn("    " + src + " (MISSING)");
                        }
                        error = true;
                        continue;
                    }
                    if (C_SOURCE_FILTER.accept(src) || CPP_SOURCE_FILTER.accept(src) || FOR_SOURCE_FILTER.accept(src)) {
                        int index = src.getName().lastIndexOf(46);
                        String path = src.getParentFile().getAbsolutePath() + File.separator;
                        String name = src.getName().substring(0, index);
                        String ext = src.getName().substring(index);
                        boolean cpp = CPP_SOURCE_FILTER.accept(src);
                        File lib = new File(src.getParentFile(), name + OBJ_EXTENSION);
                        if (verbose) {
                            this.info("    " + src + " (BUILDING)");
                        }
                        toLink.add(lib);
                        this.cleanFiles.add(lib);
                        if (!compile) continue;
                        if (FOR_SOURCE_FILTER.accept(src)) {
                            if (this.compileFortran(path, name, ext)) continue;
                            this.warn("Unable to compile " + src);
                            error = true;
                            continue;
                        }
                        if (this.compileNativeFile(path, name, ext, null)) continue;
                        this.warn("Unable to compile " + src);
                        error = true;
                        continue;
                    }
                    if (verbose) {
                        this.info("    " + src + " (FOUND)");
                    }
                    toLink.add(src);
                }
                if (!error) {
                    returnValue = toLink.toArray(EMPTY_FILE_ARRAY);
                }
            }
            catch (Exception e) {
                this.midas.printStackTrace("Unable to compile " + file + ": " + e.getMessage(), e);
            }
        } else {
            this.warn("File not found " + file);
        }
        return returnValue;
    }

    private String[] readLibListFile(File file) throws IOException {
        String line;
        ArrayList<String> libs = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("!")) continue;
            if (StringUtil.isWildcardString(line)) {
                File root = file.getParentFile();
                if (line.startsWith("/") || line.startsWith("\\")) {
                    root = new File(File.pathSeparator);
                    line = line.substring(1);
                }
                this.listFiles(libs, root, line);
                continue;
            }
            String filename = FileUtil.startsWithRootDir(line) ? line : file.getParent() + File.separator + line;
            libs.add(filename);
        }
        in.close();
        return libs.toArray(EMPTY_STRING_ARRAY);
    }

    private void listFiles(List<String> fileList, File root, String name) {
        name = name.replace('\\', '/');
        while (name.indexOf(47) == 0) {
            name = name.substring(1);
        }
        if (!root.isDirectory()) {
            throw new MidasException("Can not list files in " + root + ": not a directory.");
        }
        if (name.indexOf(47) > 0) {
            String item = name.substring(0, name.indexOf(47));
            name = name.substring(name.indexOf(47) + 1);
            if (StringUtil.isWildcardString(item)) {
                File[] files;
                for (File file : files = root.listFiles()) {
                    if (!file.isDirectory() || !StringUtil.isWildcardMatch(item, file.getName())) continue;
                    this.listFiles(fileList, file, name);
                }
            } else {
                this.listFiles(fileList, new File(root, item), name);
            }
        } else if (StringUtil.isWildcardString(name)) {
            File[] files;
            for (File file : files = root.listFiles()) {
                if (file.isDirectory() || !StringUtil.isWildcardMatch(name, file.getName())) continue;
                fileList.add(file.toString());
            }
        } else {
            fileList.add(new File(root, name).toString());
        }
    }

    private void checkForLibs(File file) {
        int index = file.getName().indexOf(".");
        String name = file.getName().substring(0, index);
        String path = FileName.terminatePath(file.getParent());
        this.checkForLibs(path, name);
    }

    private String formName(String s, String name) {
        int i = s.indexOf(36);
        int j = name.indexOf(36);
        if (i > 0 && j < 0) {
            return null;
        }
        int k = s.indexOf("<name>");
        if (k >= 0) {
            s = s.substring(0, k) + name + s.substring(k + 6);
        }
        if ((k = s.indexOf("<inner>")) >= 0) {
            s = s.substring(0, k) + name.substring(j + 1) + s.substring(k + 7);
        }
        if ((k = s.indexOf("<outer>")) >= 0) {
            s = s.substring(0, k) + name.substring(0, j) + s.substring(k + 7);
        }
        return s;
    }

    private void checkForLibs(String path, String name) {
        block0: for (String libName : LIB_NAME_LIST) {
            if ((libName = this.formName(libName, name)) == null) continue;
            for (String libExt : LIB_LIST_EXTS) {
                File file = new File(path + libName + libExt);
                if (!file.exists() || this.xlibFiles.contains(file) || this.clibFiles.contains(file)) continue;
                this.xlibFiles.add(file);
                continue block0;
            }
        }
    }

    private String getLibList(String path, String name) {
        String liblist = "";
        block0: for (String libName : LIB_NAME_LIST) {
            if ((libName = this.formName(libName, name)) == null) continue;
            for (String libExtension : LIB_EXTENSIONS) {
                File file = new File(path + libName + Shell.getLibrarySuffix() + libExtension);
                if (!file.exists()) continue;
                liblist = liblist + " " + file;
                continue block0;
            }
        }
        return liblist;
    }

    private boolean isRunInternalOk() {
        return !Shell.ostag.equals("win");
    }

    private boolean runAutoOS(String command) {
        return this.isRunInternalOk() ? this.runInternalOS(command) : this.runExternalOS(command);
    }

    private boolean runInternalOS(String command) {
        return Build.runInternalOS(this.midas, command, this.showDebug);
    }

    private boolean runExternalOS(String command) {
        return Build.runExternalOS(this.midas, command, this.showDebug);
    }

    private static boolean runInternalOS(Midas midas, String command, boolean showDebug) {
        if (showDebug) {
            midas.info("Running Command: " + command);
        }
        return Foreign.runInternal(midas, command, true) == 0;
    }

    private static boolean runExternalOS(Midas midas, String command, boolean showDebug) {
        if (showDebug) {
            midas.info("Running Command: " + command);
        }
        Foreign.runExternal(midas, command);
        return true;
    }

    private String getProperty(String opt, String propName) {
        String name = propName.replace('.', '_').toUpperCase();
        String prop = this.bldFlags == null ? null : this.bldFlags.getS(name, null);
        String val = Build.getPropertyStatic(opt, propName);
        if (val == null) {
            val = "";
        }
        prop = prop == null ? val : prop + " " + val;
        return prop;
    }

    public static String getPropertyStatic(String opt, String propName) {
        String value = BuildProps.getPropsFor(opt, Shell.getCurrent()).getProperty(propName, prependSuffixes, appendSuffixes);
        return value == null ? "" : value;
    }

    public int compile(String opt, String areaList, int types) {
        String[] areas = StringUtil.split(areaList);
        String optPath = "," + this.midas.getResults().get("OPT.PATH") + ",";
        for (String area : areas) {
            File[] junitDirs;
            File junit;
            File path = new File(this.midas.io.name(area, "", "", opt));
            if (!path.exists()) continue;
            if ((types & 4) != 0) {
                types |= 2;
            }
            if ((types & 1) != 0) {
                this.classFiles.addAll(Arrays.asList(Build.listFiles(path, JAVA_SOURCE_FILTER)));
            }
            if ((types & 2) != 0) {
                this.nativeFiles.addAll(Arrays.asList(Build.listFiles(path, C_SOURCE_FILTER)));
                this.nativeFiles.addAll(Arrays.asList(Build.listFiles(path, CPP_SOURCE_FILTER)));
                this.clibFiles.addAll(Arrays.asList(Build.listFiles(path, CLIB_SOURCE_FILTER)));
                this.clibFiles.addAll(Arrays.asList(Build.listFiles(path, CPPLIB_SOURCE_FILTER)));
            }
            if ((types & 4) != 0) {
                this.clibFiles.addAll(Arrays.asList(Build.listFiles(path, FLIB_SOURCE_FILTER)));
                if (area.equalsIgnoreCase(HOST_AREA)) {
                    if (optPath.indexOf(",XBC,") < 0) {
                        this.midas.warning("Must add XBC to the path before compiling host primitives.");
                    } else if (optPath.indexOf("," + opt + ",") >= 0) {
                        String[] hostCommands;
                        for (String hostCmd : hostCommands = Command.getMenuCommands(this.midas, null, "H", opt, false, false)) {
                            hostCmd = hostCmd.toLowerCase();
                            File forFile = new File(path, hostCmd + FOR_SOURCE);
                            File cppFile = new File(path, hostCmd + CPP_SOURCE);
                            File cFile = new File(path, hostCmd + C_SOURCE);
                            if (forFile.exists()) {
                                this.hostFiles.add(forFile);
                                continue;
                            }
                            if (cppFile.exists()) {
                                this.hostFiles.add(cppFile);
                                continue;
                            }
                            if (!cFile.exists()) continue;
                            this.hostFiles.add(cFile);
                        }
                    } else {
                        this.midas.warning("Must add " + opt + " to the path before compiling host primitives.");
                    }
                }
            }
            if (!area.equalsIgnoreCase(TEST_AREA) || (types & 1) == 0 || !(junit = new File(path, "junit")).exists()) continue;
            this.junitFiles.addAll(Arrays.asList(Build.listFiles(junit, JAVA_SOURCE_FILTER)));
            for (File junitDir : junitDirs = junit.listFiles()) {
                File[] junitDirSubDirs;
                if (!junitDir.exists() || !junitDir.isDirectory()) continue;
                this.junitFiles.addAll(Arrays.asList(Build.listFiles(junitDir, JAVA_SOURCE_FILTER)));
                for (File junitDirSubDir : junitDirSubDirs = junitDir.listFiles()) {
                    if (!junitDirSubDir.exists() || !junitDirSubDir.isDirectory()) continue;
                    this.junitFiles.addAll(Arrays.asList(Build.listFiles(junitDirSubDir, JAVA_SOURCE_FILTER)));
                }
            }
        }
        return this.compile(opt);
    }

    public final int compile(File file, String optname) {
        return this.compile(new File[]{file}, optname);
    }

    public int compile(File[] files, String optname) {
        String area = "";
        return this.compile(files, optname, area);
    }

    public int compile(File[] files, String optname, String area) {
        for (File file : files) {
            if (JAVA_SOURCE_FILTER.accept(file)) {
                this.classFiles.add(file);
                continue;
            }
            if (C_SOURCE_FILTER.accept(file) || CPP_SOURCE_FILTER.accept(file)) {
                if (area.equalsIgnoreCase(HOST_AREA)) {
                    this.hostFiles.add(file);
                } else {
                    this.nativeFiles.add(file);
                }
                this.checkForLibs(file);
                continue;
            }
            if (FOR_SOURCE_FILTER.accept(file)) {
                this.hostFiles.add(file);
                this.checkForLibs(file);
                continue;
            }
            if (CLIB_SOURCE_FILTER.accept(file) || CPPLIB_SOURCE_FILTER.accept(file) || FLIB_SOURCE_FILTER.accept(file)) {
                this.clibFiles.add(file);
                continue;
            }
            this.warn("Unknown file extension for " + file + ", skipping.");
        }
        return this.compile(optname);
    }

    private boolean usesPrecompiledLibs(String opt) {
        return this.getCCompiler(opt, false).equals("none");
    }

    private boolean checkEmpty(List<?> list3, String descr) {
        boolean ok;
        boolean bl = ok = list3.size() == 0;
        if (!ok) {
            this.warn("Can not compile " + descr + " when C/C++ compiler is set to 'none'.");
        }
        return ok;
    }

    private synchronized int compile(String opt) {
        if (opt == null) {
            opt = this.getOpt(this.nativeFiles);
        }
        boolean precompiled = this.usesPrecompiledLibs(opt);
        boolean ok = true;
        this.compileCount = 0;
        ok = ok && this.count(this.compileClassFiles(this.classFiles, false));
        boolean bl = ok = ok && this.count(this.compileClassFiles(this.junitFiles, true));
        if (precompiled) {
            ok = ok && this.count(this.copyPrecompiledFiles(Build.asArray(this.nativeFiles)));
            ok = ok && this.checkEmpty(this.hostFiles, "host primitives");
            ok = ok && this.checkEmpty(this.clibFiles, ".clib and .cpplib and .flib files");
        } else {
            if (this.primConfig == null || !opt.equalsIgnoreCase((String)this.primConfig.get("optname"))) {
                HashMap<String, Object> defaults = new HashMap<String, Object>();
                ArrayList<String> default_libdepend = new ArrayList<String>();
                default_libdepend.add("HPrimitive;XBC");
                defaults.put("libdepend", default_libdepend);
                this.primConfig = this.read_cfg_file(opt, "primitives.cfg", defaults);
            }
            ok = ok && this.count(this.compileNativeHeaders(Build.asArray(this.nativeFiles)));
            ok = ok && this.count(this.buildSharedObjects(Build.asArray(this.clibFiles)));
            ok = ok && this.count(this.buildSharedObjects(Build.asArray(this.xlibFiles)));
            ok = ok && this.count(this.compileNativeFiles(Build.asArray(this.nativeFiles)));
            boolean bl2 = ok = ok && this.count(this.compileHostFiles(Build.asArray(this.hostFiles)));
        }
        if (ok) {
            this.delete(Build.asArray(this.cleanFiles));
        }
        this.reset();
        return this.compileCount;
    }

    private boolean count(int numCompiled) {
        this.compileCount = numCompiled < 0 ? numCompiled : this.compileCount + numCompiled;
        return this.compileCount >= 0;
    }

    private static File[] asArray(List<File> list3) {
        return list3.toArray(EMPTY_FILE_ARRAY);
    }

    public static void compileMacro(String opt, String name) {
        Midas midas = defaultMidas;
        if (name.endsWith(".mm")) {
            name = name.substring(0, name.length() - 3);
        }
        Args targs = Shell.parseCommand(midas, name);
        Command command = Shell.loadCommand(midas, targs);
        ((Macro)command).loadText();
    }

    private String getOpt(List<File> files) {
        String opt = "SYS";
        if (files != null && files.size() > 0) {
            opt = this.getOpt(files.get(0).getAbsolutePath());
            for (File f : files) {
                String option = this.getOpt(f.getAbsolutePath());
                if (opt.equals(option)) continue;
                this.midas.warning("BUILD: Given set of files that span multiple option trees, using build.props in SYS.");
                opt = "SYS";
                break;
            }
        }
        return opt;
    }

    private String getArea(String path) {
        return this.getOptArea(path)[1];
    }

    private String getOpt(String path) {
        return this.getOptArea(path)[0];
    }

    private String[] getOptArea(String path) {
        String area;
        String opt;
        int j;
        int i;
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        if ((i = path.lastIndexOf(File.separator + "nxm" + File.separator)) == -1) {
            // empty if block
        }
        if ((j = path.indexOf(File.separator, i + 5)) == -1) {
            opt = path.substring(i + 5);
            area = "";
        } else {
            opt = path.substring(i + 5, j);
            area = path.substring(j + 1);
        }
        return new String[]{opt, area};
    }

    private static String getClassPath(String opt) {
        StringBuilder classPath = new StringBuilder();
        classPath.append(Build.getPropertyStatic(opt, "java.class.path"));
        if (opt != null) {
            classPath.append(File.pathSeparator);
            classPath.append(StringUtil.join(Shell.getClasspathFor(opt), File.pathSeparator));
        }
        return classPath.toString();
    }

    private static PrintWriter getMidasPrintWriter(int msgType, Midas midas) {
        return new PrintWriter(Build.getOutputStreamToMidas(msgType, midas));
    }

    private static OutputStream getOutputStreamToMidas(final int msgType, final Midas midas) {
        final String lineSeparator = Shell.getProperty("line.separator");
        final boolean warnUnlessAutodetectError = 12 == msgType;
        return new OutputStream(){
            private StringBuffer buffer = new StringBuffer();

            @Override
            public synchronized void write(int b) {
                this.buffer.append((char)b);
            }

            @Override
            public synchronized void flush() {
                this.flush(false);
            }

            @Override
            public synchronized void close() {
                this.flush(true);
            }

            public synchronized void flush(boolean forceWrite) {
                if (forceWrite || this.buffer.length() > 0) {
                    String text = this.buffer.toString();
                    if (text.endsWith(lineSeparator)) {
                        text = text.substring(0, text.length() - lineSeparator.length());
                    }
                    int midasMsgType = msgType;
                    if (warnUnlessAutodetectError) {
                        if (text.toLowerCase().contains("error:")) {
                            midasMsgType = 2;
                            if (midas != null) {
                                midas.setBuildStatus(1);
                                midas.addBuildError(text);
                            }
                        } else {
                            midasMsgType = 1;
                        }
                    }
                    midas.message(text, midasMsgType, null);
                    this.buffer = new StringBuffer();
                }
            }
        };
    }

    public static String getFortranCompiler() {
        if (forCompiler == null) {
            forCompiler = Build.getPropertyStatic("SYS", "fflags.compiler");
            if (xmArchType == null) {
                Build.getXmArchType();
            }
            forCompiler = forCompiler == null || forCompiler.trim().length() == 0 ? "auto" : forCompiler.trim().toLowerCase();
            Midas sharedMidas = Shell.getSharedMidasContext();
            Table sharedMidasResults = sharedMidas.getResults();
            String path = "," + sharedMidasResults.getS("OPT.PATH") + ",";
            boolean xbcOnPath = path.contains(",XBC,");
            if (forCompiler.equals("auto")) {
                String envVar = Import.getEnv("NM_FORTRAN");
                if (envVar == null) {
                    envVar = Import.getEnv("XM_FORTRAN");
                }
                if (envVar != null) {
                    envVar = envVar.trim().toLowerCase();
                }
                forCompiler = envVar != null && envVar.length() > 0 ? envVar : defaultForCompiler;
            }
            if ((forCompiler = forCompiler.trim().replace('\t', ' ')).indexOf(32) > 0) {
                forCompiler = forCompiler.substring(0, forCompiler.indexOf(32));
            }
            boolean forCompilerEqGfc = forCompiler.equals("gfc");
            boolean forCompilerEqGfcGfortran = forCompiler.equals("gfc-gfortran");
            boolean forCompilerEqGfortran = forCompiler.equals("gfortran");
            if (forCompilerEqGfc || forCompilerEqGfcGfortran || forCompilerEqGfortran) {
                defaultGfcForCompiler = Build.getPropertyStatic("SYS", "gfc.bin");
                Shell.runCommand(sharedMidas, "os/stdout=GFCSCRIPT ^{env.nmroot}os/unix/nmgfcinfo.sh");
                String[] gfcScript = sharedMidasResults.get("GFCSCRIPT").toString().trim().split("\n");
                gfcForCompiler = gfcScript[0];
                if (gfcForCompiler != null && !gfcForCompiler.equals("-1")) {
                    gfcLibsDir = gfcScript[1];
                    if (forCompilerEqGfcGfortran && !gfcForCompiler.equals("gfc-gfortran")) {
                        Shell.info("'gfc-gfortran' specified, but switching to using the 'gfortran' gfc Fortran compiler.");
                    } else if (forCompilerEqGfortran && !gfcForCompiler.equals("gfortran")) {
                        Shell.warning(">>>> ");
                        Shell.warning(">>>> WARNING:");
                        Shell.warning(">>>>   The 'gfortran' gfc Fortran compiler either is NOT installed or does NOT take DEC extensions.");
                        Shell.warning(">>>>   Switching to using the 'gfc-gfortran' gfc Fortran compiler.");
                        Shell.warning(">>>> ");
                    }
                } else {
                    gfcForCompiler = forCompilerEqGfc ? defaultGfcForCompiler : forCompiler;
                    Shell.warning(">>>> ");
                    Shell.warning(">>>> WARNING:");
                    Shell.warning(">>>>   Neither the 'gfc-gfortran' nor 'gfortran' gfc Fortran compilers seem to take DEC extensions or be installed.");
                    if (forCompilerEqGfc) {
                        Shell.warning(">>>> Switching to " + defaultGfcForCompiler + " by default since 'gfc' was specified.");
                    }
                    Shell.warning(">>>> ");
                }
                forCompiler = "gfc";
            } else if (xbcOnPath && forCompiler.equals("pgf77")) {
                Shell.warning(">>>> ");
                Shell.warning(">>>> WARNING:");
                Shell.warning(">>>>   NeXtMidas XBC does not support the 'pgf77' Fortran compiler.");
                Shell.warning(">>>>   Your host primitives will have undefined behaviors and/or core dump.");
                Shell.warning(">>>> ");
            } else {
                Object[] compOptions;
                Object[] objectArray = compOptions = xbcOnPath ? compOptionsXBC : compOptionsNXM;
                if (Arrays.binarySearch(compOptions, forCompiler) < 0) {
                    Shell.warning(">>>> ");
                    Shell.warning(">>>> WARNING:");
                    Shell.warning(">>>>   NeXtMidas does not support the '" + forCompiler + "' Fortran compiler for use.");
                    Shell.warning(">>>>   Please set the environment variable NM_FORTRAN to indicate your compiler.");
                    Shell.warning(">>>>   Using default compiler 'ifort'.");
                    Shell.warning(">>>> ");
                    forCompiler = defaultForCompiler;
                }
            }
        }
        return forCompiler;
    }

    public static String getXmArchType() {
        if (xmArchType == null && Arrays.binarySearch(archOptions, xmArchType = (xmArchType = Build.getPropertyStatic("SYS", "fflags.xmarch")) == null || xmArchType.trim().length() == 0 ? "auto" : xmArchType.trim().toUpperCase()) < 0) {
            String def = Shell.getDefArchType() + "BIT";
            if (!xmArchType.equals("AUTO")) {
                Shell.warning(">>>> ");
                Shell.warning(">>>> WARNING:");
                Shell.warning(">>>>   NeXtMidas does not support the '" + xmArchType + "' arch type. Expected one of");
                Shell.warning(">>>>   '32Bit,64Bit,Classic'. Please set fflags.xmarch in nxm/sys/cfg/build.props.");
                Shell.warning(">>>>   Using default fflags.xmarch='" + def + "'.");
                Shell.warning(">>>> ");
            }
            xmArchType = def;
        }
        return xmArchType;
    }

    private int internalCompile(String[] args) {
        int status = -1;
        OutputStream warnOrError = Build.getOutputStreamToMidas(12, this.midas);
        OutputStream info = Build.getOutputStreamToMidas(0, this.midas);
        if (this.showDebug) {
            this.midas.info("Running internal compile: " + Arrays.toString(args));
        }
        status = this.getJavaCompiler().run(null, info, warnOrError, args);
        if (this.showDebug) {
            this.midas.type("Build.internalCompile(..) args.length = " + args.length + " result = " + status);
        }
        return status;
    }

    private static void internalJavadoc(Midas midas, String doclet, String[] args) {
        PrintWriter warn = Build.getMidasPrintWriter(1, midas);
        PrintWriter info = Build.getMidasPrintWriter(0, midas);
        try {
            Class<?> main = Class.forName("com.sun.tools.javadoc.Main");
            Object[] params = new Object[]{"NeXtMidas", warn, warn, info, doclet, args};
            Class[] types = new Class[]{String.class, PrintWriter.class, PrintWriter.class, PrintWriter.class, String.class, String[].class};
            Method execute = main.getMethod("execute", types);
            execute.invoke(null, params);
        }
        catch (Exception e) {
            midas.printStackTrace("Build: Error running javadoc internally", e);
        }
    }

    private void delete(File[] files) {
        block5: {
            if (this.keepFiles) break block5;
            if (this.isRunInternalOk()) {
                for (File file : files) {
                    if (!file.exists()) continue;
                    if (this.showDebug) {
                        this.info("Deleting " + file);
                    }
                    if (file.delete()) continue;
                    this.warn("Unable to delete " + file);
                }
            } else {
                String rm = this.getProperty("SYS", "remove." + Shell.ostype);
                Arrays.sort(files);
                for (int i = 0; i < files.length; ++i) {
                    if (i > 0 && files[i - 1].equals(files[i])) continue;
                    this.runExternalOS(rm + " " + files[i].getAbsolutePath());
                }
            }
        }
    }

    private void info(String str) {
        this.midas.message(str, 0, null);
    }

    private void warn(String str) {
        this.midas.message(str, 1, null);
    }

    private static File[] listFiles(File path, FilenameFilter filter) {
        return path.listFiles(filter);
    }

    private String getOsName(String opt) {
        return this.getProperty(opt, "native." + Shell.ostag + ".osname");
    }

    private String getCCompilerFlagsFromOSEnv(boolean cpp) {
        String flags_from_env;
        String string = flags_from_env = cpp ? Import.getEnv("NM_CXX_OPTIONS") : Import.getEnv("NM_CC_OPTIONS");
        if (flags_from_env == null) {
            flags_from_env = "";
        }
        return flags_from_env;
    }

    private String getCCompilerFlags(String opt, boolean cpp) {
        return this.getCCompiler(opt, cpp) + " " + this.getCBuildFlags(opt, cpp);
    }

    private String getCLinkerFlags(String opt, boolean cpp) {
        return this.getCCompiler(opt, cpp) + " " + this.getCLinkFlags(opt, cpp);
    }

    private String getCCompiler(String opt, boolean cpp) {
        String compiler;
        if (cpp) {
            compiler = Import.getEnv("NM_CXX");
            if (compiler == null) {
                compiler = this.getProperty(opt, "native." + Shell.ostag + ".cppcomp");
            }
        } else {
            compiler = Import.getEnv("NM_CC");
            if (compiler == null) {
                compiler = this.getProperty(opt, "native." + Shell.ostag + ".compiler");
            }
        }
        return compiler;
    }

    private CharSequence getCBuildFlags(String opt, boolean cpp) {
        String flagsOsType = this.getProperty(opt, "flags." + Shell.ostype);
        String cflagsOsType = this.getProperty(opt, "cflags." + Shell.ostype);
        String osname = this.getProperty(opt, "native." + Shell.ostag + ".osname");
        String processor = Shell.getProperty("os.arch");
        String cCompilerLower = this.getCCompiler(opt, cpp).toLowerCase();
        StringBuilder cflagsNative = new StringBuilder();
        if (cpp) {
            cflagsNative.append(this.getProperty(opt, "native." + Shell.ostag + ".cpp.comp"));
            if (cCompilerLower.equals("icpx")) {
                cflagsNative.append(" " + this.getProperty(opt, "native." + Shell.ostag + ".cpp.comp.llvm"));
            }
            if (Shell.iscentos7) {
                cflagsNative.append(" " + this.getProperty(opt, "native." + Shell.ostag + ".cpp.comp.el7"));
            }
        } else {
            cflagsNative.append(this.getProperty(opt, "native." + Shell.ostag + ".cflags"));
            if (cCompilerLower.equals("icx")) {
                cflagsNative.append(" " + this.getProperty(opt, "native." + Shell.ostag + ".cflags.llvm"));
            }
        }
        StringBuilder retflags = new StringBuilder(512);
        if (processor.equals("i386") || processor.equals("x86")) {
            retflags.append("-D_ALLOW_64BIT_UNALIGNED ");
        }
        retflags.append("-D_" + osname + " -D_" + this.shell.getOSRep() + " -D_" + Build.getXmArchType());
        if (!opt.equals("sys")) {
            retflags.append(" -I" + Shell.getOptPath(opt, "inc"));
        }
        retflags.append(" " + flagsOsType + " " + cflagsOsType + " " + cflagsNative);
        return retflags;
    }

    private String getCLinkFlags(String opt, boolean cpp) {
        String lflags = this.getProperty(opt, "lflags." + Shell.ostype);
        String nlflags = cpp ? this.getProperty(opt, "native." + Shell.ostag + ".cpp.link") : this.getProperty(opt, "native." + Shell.ostag + ".lflags");
        return lflags + " " + nlflags;
    }

    private String getFortranCompiler(String opt) {
        Build.getFortranCompiler();
        String forComp = this.getProperty(opt, forCompiler + ".comp") + " " + this.getProperty(opt, "native." + Shell.ostag + ".for.comp");
        if (forCompiler.equals("gfc") && gfcForCompiler != null && !gfcForCompiler.equals(defaultGfcForCompiler)) {
            forComp = (" " + forComp).replaceFirst(" " + defaultGfcForCompiler + " ", gfcForCompiler + " ");
        }
        return forComp;
    }

    private String getFortranLinker(String opt) {
        Build.getFortranCompiler();
        String forLinker = this.getProperty(opt, forCompiler + ".link") + " " + this.getProperty(opt, "native." + Shell.ostag + ".for.link");
        if (forCompiler.equals("gfc") && gfcForCompiler != null && !gfcForCompiler.equals(defaultGfcForCompiler)) {
            forLinker = (" " + forLinker).replaceFirst(" " + defaultGfcForCompiler + " ", gfcForCompiler + " ");
            if (gfcLibsDir != null) {
                forLinker = forLinker.replaceAll(this.getProperty(opt, "gfc.libs.dir"), gfcLibsDir);
            }
        }
        return forLinker;
    }

    private String getFortranFlags(String opt, String area, String path) {
        String fflags = this.getProperty(opt, "flags." + Shell.ostype) + " " + this.getProperty(opt, "fflags." + Shell.ostype) + " -D_" + Build.getFortranCompiler().toUpperCase() + " -D_" + this.getOsName(opt) + " -D_" + this.shell.getOSRep() + " -D_" + Build.getXmArchType() + " ";
        String local = "-I" + Shell.getOptPath(opt, "inc") + "  -I" + path;
        if (!opt.equalsIgnoreCase("sys")) {
            fflags = opt.equalsIgnoreCase("xm") ? fflags + " " + local : local + " " + fflags;
        }
        return fflags;
    }

    private String getFortranHostFlags(String opt, String area) {
        return !area.equals(HOST_AREA) ? "" : this.getProperty(opt, "fflags.host");
    }

    private Map<String, Object> read_cfg_file(String opt, String cfg_fname, Map<String, Object> defaults) {
        String filename;
        TextFile tf;
        Map<String, Object> cfg = this.getDefaultConfig();
        if (defaults != null) {
            cfg.putAll(defaults);
        }
        if (!(tf = new TextFile(this.midas, (Object)(filename = Shell.getOptPath(opt, "CFG") + cfg_fname))).exists()) {
            return cfg;
        }
        cfg.put("optname", opt.toLowerCase());
        cfg.put("cfgfile", filename);
        if (this.platform.isEmpty()) {
            this.platform.add(this.getOsName(opt));
            this.platform.add(this.shell.getOSType());
            this.platform.add(this.shell.getOSName());
            this.platform.add("NEXTMIDAS");
        }
        tf.open(8193);
        this.parseCfgFile(opt, cfg, defaults, tf, this.platform);
        this.resolve_libdepend(cfg);
        tf.close();
        return cfg;
    }

    private Map<String, Object> getDefaultConfig() {
        LinkedHashMap<String, Object> cfg = new LinkedHashMap<String, Object>();
        cfg.put("cfgfile", null);
        cfg.put("cflags", new ArrayList());
        cfg.put("lflags", new ArrayList());
        cfg.put("libdepend", new ArrayList());
        cfg.put("linklibs", "");
        cfg.put("searchpath", "");
        cfg.put("targets", new LinkedHashMap());
        cfg.put("targetlist", new ArrayList());
        return cfg;
    }

    private Map<String, Object> newTargetConfig(String target, Map<String, Object> cfg) {
        HashMap<String, Object> c = new HashMap<String, Object>();
        c.put("cfgfile", cfg.get("cfgfile"));
        c.put("cflags", ((ArrayList)cfg.get("cflags")).clone());
        c.put("lflags", ((ArrayList)cfg.get("lflags")).clone());
        c.put("libdepend", ((ArrayList)cfg.get("libdepend")).clone());
        c.put("libdefault", ((ArrayList)cfg.get("libdefault")).clone());
        c.put("linklibs", cfg.get("linklibs"));
        c.put("searchpath", cfg.get("searchpath"));
        c.put("modules", new ArrayList());
        c.put("headers", new ArrayList());
        c.put("target", target);
        ArrayList targetlist = (ArrayList)cfg.get("targetlist");
        Map targets = (Map)cfg.get("targets");
        targetlist.add(target);
        targets.put(target, c);
        return c;
    }

    private void parseCfgFile(String optname, Map<String, Object> cfg, Map<String, Object> defaults, TextFile tf, Set<String> platform) {
        String line;
        int line_no = 0;
        int indent = 0;
        Map<String, Object> c = cfg;
        String ignoreTarget = null;
        int mindent = 0;
        ArrayList<Object> modules = new ArrayList();
        cfg.put("libdefault", ((ArrayList)cfg.get("libdepend")).clone());
        while ((line = tf.read()) != null) {
            ++line_no;
            String trimmedline = line.trim();
            int trimlen = trimmedline.length();
            if (trimlen == 0 || trimmedline.startsWith("!")) continue;
            indent = StringUtil.rtrim(line).length() - trimlen;
            if (indent == 0) {
                c = cfg;
            }
            if (indent <= mindent) {
                mindent = 0;
            }
            String[] tokens = WHITESPACE_REGEX.split(trimmedline);
            int endIndex = tokens.length;
            if (tokens.length >= 3 && tokens[tokens.length - 2].equals("->") && !tokens[0].endsWith(":")) {
                if (this.inExcludeDirective(tokens[tokens.length - 1], platform)) continue;
                endIndex -= 2;
            }
            String directive = tokens[0].toLowerCase();
            if (indent == 0 && directive.endsWith(":")) {
                String target = directive;
                if (tokens.length >= 3 && tokens[tokens.length - 2].equals("->") && this.inExcludeDirective(tokens[tokens.length - 1], platform)) {
                    ignoreTarget = target;
                    continue;
                }
                ignoreTarget = null;
                c = this.newTargetConfig(target.substring(0, target.length() - 1), cfg);
                continue;
            }
            if (ignoreTarget != null) continue;
            if (directive.equals("optdepend")) {
                c.put("optdepnd", this.parseDirectiveList(tokens, 1, endIndex, false));
                continue;
            }
            if (directive.equals("libdepend")) {
                Object lib;
                ArrayList<String> dependlist = this.parseDirectiveList(tokens, 1, endIndex, false);
                ArrayList libdepend = new ArrayList();
                for (String arg : dependlist) {
                    lib = null;
                    String opt = null;
                    if ("+".equals(arg) || "-".equals(arg)) {
                        libdepend.add(arg);
                        continue;
                    }
                    if (arg.indexOf(";") >= 0) {
                        String[] tmp = SEMICOLON_REGEX.split(arg);
                        lib = tmp[0];
                        opt = tmp.length < 2 ? optname : tmp[1].toUpperCase();
                    } else {
                        lib = "*";
                        opt = arg.toUpperCase();
                    }
                    if (!((String)lib).equals("*")) {
                        libdepend.add((String)lib + ";" + opt);
                        continue;
                    }
                    Map<String, Object> optcfg = this.getLibrariesConfig(opt, defaults);
                    ArrayList targetlist = (ArrayList)optcfg.get("targetlist");
                    int count = 0;
                    if (targetlist != null) {
                        for (String targetname : targetlist) {
                            libdepend.add(targetname + ";" + opt);
                            ++count;
                        }
                    }
                    if (count != 0) continue;
                    libdepend.add(";" + opt);
                }
                ArrayList arrayList = (ArrayList)c.get("libdepend");
                ArrayList cfg_libdefault = (ArrayList)c.get("libdefault");
                if (libdepend.isEmpty()) {
                    arrayList.clear();
                    cfg_libdefault.clear();
                } else if (libdepend.contains("-")) {
                    lib = libdepend.iterator();
                    while (lib.hasNext()) {
                        String libname = (String)lib.next();
                        if (!cfg_libdefault.contains(libname)) continue;
                        cfg_libdefault.remove(libname);
                    }
                } else if (!libdepend.contains("+")) {
                    for (String libname : arrayList) {
                        if (libdepend.contains(libname)) continue;
                        libdepend.remove(libname);
                    }
                }
                this.modList(arrayList, libdepend.toArray(EMPTY_STRING_ARRAY), 0, libdepend.size());
                this.warnDuplicateLibs(c);
                continue;
            }
            if (directive.equals("lflags")) {
                this.modList((ArrayList)c.get("lflags"), tokens, 1, endIndex);
                this.warnDuplicateLibs(c);
                continue;
            }
            if (directive.equals("cflags")) {
                if (c.containsKey("modules") || mindent > 0) {
                    HashMap<String, ArrayList> module_cflags = (HashMap<String, ArrayList>)c.get("module_cflags");
                    if (module_cflags == null) {
                        module_cflags = new HashMap<String, ArrayList>();
                        c.put("module_cflags", module_cflags);
                    }
                    if (mindent > 0) {
                        for (String string : modules) {
                            ArrayList cflaglist = (ArrayList)module_cflags.get(string);
                            if (cflaglist == null) {
                                cflaglist = (ArrayList)((ArrayList)c.get("cflags")).clone();
                                module_cflags.put(string, cflaglist);
                            }
                            this.modList(cflaglist, tokens, 1, endIndex);
                        }
                        continue;
                    }
                    ArrayList c_modules = (ArrayList)c.get("modules");
                    for (String m : c_modules) {
                        if (module_cflags.containsKey(m)) continue;
                        ArrayList arrayList = (ArrayList)c.get("cflags");
                        module_cflags.put(m, (ArrayList)arrayList.clone());
                    }
                }
                this.modList((ArrayList)c.get("cflags"), tokens, 1, endIndex);
                continue;
            }
            if (directive.equals("libname") && c.containsKey("modules")) {
                c.put("libname", tokens[1]);
                continue;
            }
            if (directive.equals("modules") && c.containsKey("modules")) {
                String lastItem;
                modules = this.parseDirectiveList(tokens, 1, endIndex, false);
                int lastItemIndex = modules.size() - 1;
                String string = lastItem = lastItemIndex >= 0 ? (String)modules.get(lastItemIndex) : "";
                if (lastItem.endsWith(":")) {
                    mindent = indent;
                    if (lastItem.equals(":")) {
                        modules.remove(lastItemIndex);
                    } else {
                        modules.set(lastItemIndex, lastItem.substring(0, lastItem.length() - 1));
                    }
                } else {
                    mindent = 0;
                }
                ((ArrayList)c.get("modules")).addAll(modules);
                continue;
            }
            if (directive.equals("headers") && c.containsKey("modules")) {
                ((ArrayList)c.get("headers")).addAll(this.parseDirectiveList(tokens, 1, endIndex, false));
                continue;
            }
            this.midas.warning("Unrecognized/unexpected directive '" + directive + "' at line " + line_no + " of file " + tf.getName() + " indent=" + indent + " mindent=" + mindent);
        }
    }

    private boolean inExcludeDirective(String dlist, Set<String> platform) {
        String[] items;
        boolean result = true;
        if (dlist.startsWith("!")) {
            return !this.inExcludeDirective(dlist.substring(1), platform);
        }
        for (String item : items = COMMA_REGEX.split(dlist)) {
            if (!(item.startsWith("$") ? Import.getEnv(item.substring(1)) != null : platform.contains(item))) continue;
            return false;
        }
        return result;
    }

    private void modList(ArrayList<String> list3, String[] mods, int start, int end) {
        if (mods == null || mods.length == 0) {
            list3.clear();
        } else if (mods[start].equals("+")) {
            for (int i = start + 1; i < end; ++i) {
                list3.add(0, mods[i]);
            }
        } else if (mods[end - 1].equals("+")) {
            for (int i = start; i < end - 1; ++i) {
                list3.add(mods[i]);
            }
        } else if (mods[start].equals("-")) {
            for (int i = start + 1; i < end; ++i) {
                list3.remove(mods[i]);
            }
        } else if (mods[end - 1].equals("-")) {
            for (int i = start; i < end - 1; ++i) {
                list3.remove(mods[i]);
            }
        } else {
            list3.clear();
            for (int i = start; i < end; ++i) {
                list3.add(mods[i]);
            }
        }
    }

    private ArrayList<String> parseDirectiveList(String[] tokens, int start, int end, boolean upcase) {
        ArrayList<String> list3 = new ArrayList<String>(tokens.length);
        for (int ii = start; ii < end; ++ii) {
            String[] strarr;
            for (String item : strarr = COMMA_REGEX.split(tokens[ii])) {
                if (upcase) {
                    item = item.toUpperCase();
                }
                list3.add(item);
            }
        }
        return list3;
    }

    private void warnDuplicateLibs(Map<String, Object> cfg) {
        HashSet<String> warnset = new HashSet<String>();
        ArrayList libdepend = (ArrayList)cfg.get("libdepend");
        ArrayList lflags = (ArrayList)cfg.get("lflags");
        HashSet<String> libs = new HashSet<String>();
        for (String str : libdepend) {
            String libname;
            int iSemiColon = str.indexOf(59);
            if (iSemiColon <= 1 || libs.add(libname = str.substring(0, iSemiColon).toLowerCase())) continue;
            warnset.add(libname);
        }
        for (String curflag : lflags) {
            String libname;
            if (!curflag.startsWith("-l") || libs.add(libname = curflag.substring(2).toLowerCase())) continue;
            warnset.add(libname);
        }
        String cfgfile = (String)cfg.get("cfgfile");
        String target = (String)cfg.get("target");
        HashSet<String> warned = (HashSet<String>)cfg.get("warned");
        if (warned == null) {
            warned = new HashSet<String>();
            cfg.put("warned", warned);
        }
        for (String libname : warnset) {
            if (warned.contains(libname)) continue;
            this.midas.warning("Multiple \"-l" + libname + "\" flags for target '" + target + "' in: " + cfgfile);
            warned.add(libname);
        }
    }

    private void resolve_libdepend(Map<String, Object> cfg) {
        ArrayList libdependList = (ArrayList)cfg.get("libdepend");
        LinkedHashSet<String> linklibs = new LinkedHashSet<String>();
        LinkedHashSet<String> searchpath = new LinkedHashSet<String>();
        for (String lib : libdependList) {
            int iSemicolon = lib.indexOf(59);
            if (iSemicolon >= 0) {
                String includeDir;
                String incDir;
                String libpath;
                String optname = lib.substring(iSemicolon + 1);
                String libname = lib.substring(0, iSemicolon);
                boolean is3rdPartyLib = false;
                if (optname.startsWith("$")) {
                    File file;
                    is3rdPartyLib = true;
                    String envName = optname.substring(1);
                    String pathFromOsEnv = Import.getEnv(envName, envName + "__OS_ENV_NOT_FOUND__");
                    libpath = FileName.addPathDir(pathFromOsEnv, "lib");
                    incDir = FileName.addPathDir(pathFromOsEnv, "inc");
                    includeDir = FileName.addPathDir(pathFromOsEnv, "include");
                    if (!(CoreIO.fexists(includeDir, true) && CoreIO.fexists(incDir, true) || CoreIO.fexists(libpath, true) || !(file = new File(pathFromOsEnv)).isDirectory())) {
                        File parent = file.getParentFile();
                        String grandParentDir = parent.getParent();
                        String productDir = parent.getName();
                        if (productDir.equals("include") || productDir.equals("lib")) {
                            includeDir = FileName.addPathDir(grandParentDir, "include" + File.separator + productDir);
                            includeDir = FileName.addPathDir(grandParentDir, "lib" + File.separator + productDir);
                        }
                    }
                } else {
                    libpath = Shell.getOptPath(optname, "lib");
                    incDir = Shell.getOptPath(optname, "inc");
                    includeDir = Shell.getOptPath(optname, "include");
                }
                linklibs.add("-L" + libpath);
                if (libname.length() > 0 && libname.indexOf("*") < 0) {
                    if (is3rdPartyLib) {
                        linklibs.add("-l" + libname);
                    } else {
                        linklibs.add("-l" + libname + Shell.getLibrarySuffix());
                    }
                }
                File incFile = new File(incDir);
                File includeFile = new File(includeDir);
                if (incFile.isDirectory()) {
                    searchpath.add("-I" + incDir);
                }
                if (!includeFile.isDirectory()) continue;
                searchpath.add("-I" + includeDir);
                continue;
            }
            this.midas.warning("CFG configuration for libdepend has not be normalized! ignoring " + lib);
        }
        ArrayList lflagsList = (ArrayList)cfg.get("lflags");
        Iterator lflagsIter = lflagsList.iterator();
        while (lflagsIter.hasNext()) {
            String lflag = (String)lflagsIter.next();
            if (!lflag.startsWith("-l") && !lflag.startsWith("-L")) continue;
            linklibs.add(lflag);
            lflagsIter.remove();
        }
        cfg.put("linklibs", this.converToString(linklibs));
        cfg.put("searchpath", this.converToString(searchpath));
        Map targets = (Map)cfg.get("targets");
        if (targets != null) {
            Iterator iter = targets.values().iterator();
            while (iter.hasNext()) {
                this.resolve_libdepend((Map)iter.next());
            }
        }
    }

    private String converToString(Object collection) {
        StringBuilder sb = new StringBuilder();
        if (collection instanceof Collection) {
            Collection list3 = (Collection)collection;
            Iterator iter = list3.iterator();
            while (iter.hasNext()) {
                sb.append(" ").append(iter.next());
            }
        } else if (collection != null) {
            sb.append(" ").append(collection);
        }
        return Import.expandEnvVars(sb.toString());
    }

    private String getFlagsFromConfig(String opt, String area, String targetname, String flagname) {
        StringBuilder sb = new StringBuilder(256);
        Map<Object, Object> topLevelConfig = area.equals(HOST_AREA) ? this.primConfig : this.getLibrariesConfig(opt, null);
        if (topLevelConfig != null) {
            Map<Object, Object> cfg;
            Map targetsMap = (Map)topLevelConfig.get("targets");
            if (targetsMap == null) {
                cfg = topLevelConfig;
            } else {
                cfg = (Map<Object, Object>)targetsMap.get(targetname);
                if (cfg == null) {
                    cfg = (Map)targetsMap.get(targetname.toLowerCase());
                }
                if (cfg == null && targetname.startsWith("lib")) {
                    cfg = (Map)targetsMap.get(targetname.substring(3));
                }
                if (cfg == null) {
                    cfg = topLevelConfig;
                }
            }
            sb.append(this.converToString(cfg.get(flagname)));
            if (flagname.equals("cflags")) {
                Object searchpath = cfg.get("searchpath");
                if (searchpath != null) {
                    sb.append(" ").append(searchpath);
                }
            } else if (flagname.equals("lflags")) {
                String rpath_option = this.getProperty(opt, "rpath_option");
                String linklibs = (String)cfg.get("linklibs");
                sb.append((CharSequence)this.expand_rpath_opts(linklibs, rpath_option));
                if (linklibs != null) {
                    sb.append(" ").append(linklibs);
                }
            }
        }
        return sb.toString();
    }

    private StringBuilder expand_rpath_opts(String linklibs, String rpath_option) {
        StringBuilder sb = new StringBuilder(linklibs.length());
        if (rpath_option == null || rpath_option.trim().length() == 0) {
            return sb;
        }
        StringTokenizer st = new StringTokenizer(linklibs);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.startsWith("-L") || token.length() <= 2) continue;
            sb.append(" " + rpath_option + token.substring(2));
        }
        return sb;
    }

    private Map<String, Object> getLibrariesConfig(String optname, Map<String, Object> defaults) {
        Map<String, Object> cfg = this.libConfigMap.get(optname);
        if (cfg == null) {
            cfg = this.read_cfg_file(optname, "libraries.cfg", defaults);
            this.libConfigMap.put(optname, cfg);
        }
        return cfg;
    }

    private synchronized JavaCompiler getJavaCompiler() throws MidasException {
        if (this.compiler == null) {
            this.compiler = ToolProvider.getSystemJavaCompiler();
            if (this.compiler == null) {
                throw new MidasException("Unable to get Java compiler! Not using JDK?");
            }
        }
        return this.compiler;
    }

    @InternalUseOnly
    public static void setMidasContext(Midas midas) {
        defaultMidas = midas;
    }

    @InternalUseOnly
    private static Build newInstance(Midas midas, boolean verbose, Table bldFlags) {
        return Build.newInstance(midas, verbose, defaultShowDebug, defaultKeepFiles, bldFlags);
    }

    static {
        LIB_EXTENSIONS = new String[]{".so", OBJ_EXTENSION, ".a"};
        LIB_NAME_LIST = new String[]{"lib<name>", "libAll", "libAll$<inner>", "lib<outer>$All"};
        LIB_LIST_EXTS = new String[]{CLIB_SOURCE, CPPLIB_SOURCE, FLIB_SOURCE};
        JAVA_SOURCE_FILTER = new BuildFileFilter(JAVA_SOURCE);
        C_SOURCE_FILTER = new BuildFileFilter(C_SOURCE);
        CPP_SOURCE_FILTER = new BuildFileFilter(CPP_SOURCE);
        FOR_SOURCE_FILTER = new BuildFileFilter(FOR_SOURCE);
        CLIB_SOURCE_FILTER = new BuildFileFilter(CLIB_SOURCE);
        CPPLIB_SOURCE_FILTER = new BuildFileFilter(CPPLIB_SOURCE);
        FLIB_SOURCE_FILTER = new BuildFileFilter(FLIB_SOURCE);
        ALL_SOURCE_FILTER = new BuildFileFilter(ALL_SOURCE);
        String aArchSuffix = ".append." + Shell.getDefArchType() + "bit";
        String pArchSuffix = ".prepend." + Shell.getDefArchType() + "bit";
        appendSuffixes = new String[]{".append", aArchSuffix};
        prependSuffixes = new String[]{pArchSuffix, ".prepend"};
    }

    public static final class BuildFileFilter
    implements FilenameFilter,
    FileFilter {
        private final String[] extList;

        private BuildFileFilter(String ext) {
            this.extList = ext.split("[|]");
        }

        @Override
        public boolean accept(File path) {
            return this.accept(path.getName());
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.accept(name);
        }

        public boolean accept(String name) {
            boolean accept = false;
            for (int i = 0; !accept && i < this.extList.length; ++i) {
                accept = name.endsWith(this.extList[i]);
            }
            return accept;
        }
    }
}

