/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import nxm.sys.inc.AsciiMap;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Command;
import nxm.sys.lib.Convert;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Macro;
import nxm.sys.lib.MaskValue;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Results;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;
import nxm.sys.lib.XMValue;

public class Args
implements AsciiMap,
MidasReference {
    private static final int I_NARGS = 3;
    public static final String trueStates = "|Y|YES|T|TRUE|ON|1|PASS|SUCCESS|ABSC|ABS|AB|";
    public static final String falseStates = "|N|NO|F|FALSE|OFF|0|FAIL|INDEX|IND|IN|";
    public Midas M;
    public int nargs;
    public int nargsx;
    public Command cmd;
    public String name;
    public String option;
    public String cmdline;
    public char support;
    private String cmdClassName = null;
    public static final int FLAGS_NONE = 0;
    public static final int RESOLVE = 1;
    public static final int KEEP_QUOTES = 2;
    public static final int UPCASE_UNQUOTED = 4;
    public static final int UPCASE_QUOTED = 8;
    public static final int UPCASE = 12;
    public static final int REQUIRED = 16;
    public static final int NO_ERROR = 32;
    public static final int STATE_CHECK = 64;
    public static final String STATE_SWITCH_VAL = new String("");
    @InternalUseOnly(value="Since NeXtMidas 3.3.1, this has always been meant for internal use only")
    public static final Double STATE_SWITCH_D = 1.0;
    @InternalUseOnly(value="Since NeXtMidas 3.3.1, this has always been meant for internal use only")
    public static final Float STATE_SWITCH_F = Float.valueOf(1.0f);
    @InternalUseOnly(value="Since NeXtMidas 3.3.1, this has always been meant for internal use only")
    public static final Long STATE_SWITCH_X = 1L;
    @InternalUseOnly(value="Since NeXtMidas 3.3.1, this has always been meant for internal use only")
    public static final Integer STATE_SWITCH_L = 1;
    @InternalUseOnly(value="Since NeXtMidas 3.3.1, this has always been meant for internal use only")
    public static final Short STATE_SWITCH_I = 1;
    @InternalUseOnly(value="Since NeXtMidas 3.3.1, this has always been meant for internal use only")
    public static final Byte STATE_SWITCH_B = 1;
    private KeyVector kv;
    private int lineNumber = -1;

    public Args(Midas M) {
        this.M = M;
        this.kv = new KeyVector(32);
    }

    public Args(Midas M, Parser p) {
        this(M);
        this.put("all", p.getAll());
        this.nargs = 0;
        while (p.more()) {
            ++this.nargs;
            this.put("P" + this.nargs, p.get(this.nargs));
        }
    }

    private int getNDef(String name) {
        return name.charAt(0) == '/' ? -1 : 0;
    }

    public byte getB(int arg) {
        return this.getB(this.getKey(arg));
    }

    public byte getB(String name) {
        return this.getB(name, (byte)this.getNDef(name));
    }

    public byte getB(String name, byte def) {
        return this.getB(name, (Byte)def);
    }

    public final Byte getB(String name, Byte def) {
        return this.getB(name, def, STATE_SWITCH_B);
    }

    public final Byte getB(String name, Byte def, Byte sdef) {
        return (Byte)this.getNumber(name, 'B', def, sdef);
    }

    public short getI(int arg) {
        return this.getI(this.getKey(arg));
    }

    public short getI(String name) {
        return this.getI(name, (short)this.getNDef(name));
    }

    public short getI(String name, short def) {
        return this.getI(name, (Short)def);
    }

    public final Short getI(String name, Short def) {
        return this.getI(name, def, STATE_SWITCH_I);
    }

    public final Short getI(String name, Short def, Short sdef) {
        return (Short)this.getNumber(name, 'I', def, sdef);
    }

    public int getL(int arg) {
        return this.getL(this.getKey(arg));
    }

    public int getL(int arg, int def) {
        return this.getL(this.getKey(arg), def);
    }

    public int getL(String name) {
        return this.getL(name, this.getNDef(name));
    }

    public int getL(String name, int def) {
        return this.getL(name, (Integer)def);
    }

    public final Integer getL(String name, Integer def) {
        return this.getL(name, def, STATE_SWITCH_L);
    }

    public final Integer getL(String name, Integer def, Integer sdef) {
        return (Integer)this.getNumber(name, 'L', def, sdef);
    }

    public long getX(int arg) {
        return this.getX(this.getKey(arg));
    }

    public long getX(int arg, long def) {
        return this.getX(this.getKey(arg), def);
    }

    public long getX(String name) {
        return this.getX(name, (long)this.getNDef(name));
    }

    public long getX(String name, long def) {
        return this.getX(name, (Long)def);
    }

    public final Long getX(String name, Long def) {
        return this.getX(name, def, STATE_SWITCH_X);
    }

    public final Long getX(String name, Long def, Long sdef) {
        return (Long)this.getNumber(name, 'X', def, sdef);
    }

    public float getF(int arg) {
        return this.getF(this.getKey(arg));
    }

    public float getF(String name) {
        return this.getF(name, this.getNDef(name));
    }

    public float getF(String name, float def) {
        return this.getF(name, Float.valueOf(def)).floatValue();
    }

    public final Float getF(String name, Float def) {
        return this.getF(name, def, STATE_SWITCH_F);
    }

    public final Float getF(String name, Float def, Float sdef) {
        return (Float)this.getNumber(name, 'F', def, sdef);
    }

    public double getD(int arg) {
        return this.getD(this.getKey(arg));
    }

    public double getD(String name) {
        return this.getD(name, this.getNDef(name));
    }

    public double getD(String name, double def) {
        return this.getD(name, (Double)def);
    }

    public final Double getD(String name, Double def) {
        return this.getD(name, def, STATE_SWITCH_D);
    }

    public final Double getD(String name, Double def, Double sdef) {
        return (Double)this.getNumber(name, 'D', def, sdef);
    }

    private Number getNumber(String name, char type, Number def, Number sdef) {
        Object obj;
        String value = this.getRaw(name);
        if (value == null) {
            return def;
        }
        if (value.length() == 0 && name.charAt(0) == '/') {
            return sdef;
        }
        value = value.toUpperCase();
        Object object = obj = type == 'B' || type == 'I' ? Convert.s2o(value, 'L', (Object)this) : Convert.s2o(value, type, (Object)this);
        if (obj == null) {
            throw new MidasException("Unable to convert " + name + " to type " + type);
        }
        switch (type) {
            case 'D': {
                return Convert.o2d(obj);
            }
            case 'F': {
                return Float.valueOf(Convert.o2f(obj));
            }
            case 'X': {
                return Convert.o2x(obj);
            }
            case 'L': {
                return Convert.o2l(obj);
            }
            case 'I': {
                int lval = Convert.o2l(obj);
                if (lval < Short.MIN_VALUE) {
                    throw new MidasException("Value " + lval + " out of I: range");
                }
                if (lval > Short.MAX_VALUE) {
                    throw new MidasException("Value " + lval + " out of I: range");
                }
                return (short)lval;
            }
            case 'B': {
                int lval = Convert.o2l(obj);
                if (lval < -128) {
                    throw new MidasException("Value " + lval + " out of B: range");
                }
                if (lval > 127) {
                    throw new MidasException("Value " + lval + " out of B: range");
                }
                return (byte)lval;
            }
        }
        throw new AssertionError((Object)("Unexpected type '" + type + "'"));
    }

    public String getCS(int arg) {
        return this.getCS(this.getKey(arg));
    }

    public String getCS(String name) {
        return this.getCS(name, "");
    }

    public String getCS(String name, String defvalue) {
        return this.getString(name, defvalue, 1);
    }

    public String getCS(String name, String defvalue, String sdefval) {
        return this.getString(name, defvalue, sdefval, 1);
    }

    public String getQ(int arg) {
        return this.getQ(this.getKey(arg));
    }

    public String getQ(String name) {
        return this.getQ(name, "");
    }

    public String getQ(String name, String defvalue) {
        return this.getString(name, defvalue, 0);
    }

    public String getQ(String name, String defvalue, String sdefval) {
        return this.getString(name, defvalue, sdefval, 0);
    }

    public String getS(int arg) {
        return this.getS(this.getKey(arg));
    }

    public String getS(String name) {
        return this.getS(name, "");
    }

    public String getS(String name, String defvalue) {
        return this.getString(name, defvalue, 5);
    }

    public String getS(String name, String defvalue, String sdefval) {
        return this.getString(name, defvalue, sdefval, 5);
    }

    public String getString(String name, String defvalue, int flags) throws MidasException {
        return this.getString(name, defvalue, "", flags);
    }

    public String getString(String name, String defvalue, String sdefval, int flags) throws MidasException {
        String value = this.getRaw(name);
        if (value == null) {
            if ((flags & 0x10) != 0) {
                throw new MidasException("Argument '" + name + "=' is required.");
            }
            value = defvalue;
            flags &= 0xFFFFFFFE;
        } else if (value == STATE_SWITCH_VAL && (flags & 0x40) == 0) {
            value = sdefval;
            flags &= 0xFFFFFFFE;
        }
        if (value == null || value.length() == 0) {
            return value;
        }
        return this.resolveString(value, flags);
    }

    public String resolveString(String value, int flags) {
        int vls;
        boolean resolve = (flags & 1) != 0;
        boolean quotes = (flags & 2) != 0;
        boolean upcase = (flags & 4) != 0;
        boolean upcase_quoted = (flags & 8) != 0;
        int ls = value.length();
        if (ls > 0 && value.charAt(0) == '/' && resolve && (vls = Results.validNameLength(value, 1)) == ls - 1) {
            String tmp = this.getRaw(value.toUpperCase());
            value = tmp == null ? "NULL" : tmp;
            ls = value.length();
        }
        if (ls != 0) {
            if (value.charAt(0) == '`') {
                value = value.substring(1, ls - 1);
            } else if (value.charAt(0) == '\"') {
                if (!quotes) {
                    value = value.charAt(ls - 1) == '\"' ? value.substring(1, ls - 1) : value.substring(1, ls);
                }
                if (upcase_quoted) {
                    value = Parser.toUpperCaseWithQuotes(value);
                }
            } else {
                if (resolve && Results.validNameLength(value, 0) == ls) {
                    Object resvalue = this.M.results.get(Parser.toUpperCaseWithQuotes(value));
                    if (resvalue instanceof String) {
                        value = resvalue.toString();
                        upcase = upcase_quoted;
                    } else if (resvalue instanceof Data && ((Data)resvalue).isString()) {
                        value = resvalue.toString();
                    } else if (resvalue instanceof XMValue && ((XMValue)resvalue).getFormatType() == 'A') {
                        value = resvalue.toString();
                    } else if (resvalue instanceof Number || resvalue instanceof Boolean) {
                        value = resvalue.toString();
                    }
                }
                if (upcase) {
                    value = Parser.toUpperCaseWithQuotes(value);
                }
            }
        }
        return value;
    }

    public String getU(int arg) {
        return this.getU(this.getKey(arg));
    }

    public String getU(String name) {
        return this.getU(name, "");
    }

    public String getU(String name, String defvalue) {
        return this.getString(name, defvalue, 4);
    }

    public String getU(String name, String defvalue, String sdefval) {
        return this.getString(name, defvalue, sdefval, 4);
    }

    public String getUQ(int arg) {
        return this.getUQ(this.getKey(arg));
    }

    public String getUQ(String name) {
        return this.getUQ(name, null);
    }

    public String getUQ(String name, String defvalue) {
        return this.getString(name, defvalue, 6);
    }

    public final boolean getZ(int arg) {
        return this.getState(this.getKey(arg), false);
    }

    public final boolean getZ(String name) {
        return this.getState(name, false);
    }

    public final boolean getZ(String name, boolean defvalue) {
        return this.getState(name, defvalue);
    }

    public boolean getState(int arg) {
        return this.getState(this.getKey(arg), false);
    }

    public boolean getState(String name) {
        return this.getState(name, false);
    }

    public boolean getState(String name, boolean defvalue) {
        boolean isSwitch = name.startsWith("/");
        String svalue = this.getString(name, null, 76);
        if (svalue == null || svalue.equals("NULL")) {
            return defvalue;
        }
        if (svalue.length() == 0 && isSwitch) {
            return true;
        }
        String text = "|" + svalue + "|";
        if (trueStates.indexOf(text) >= 0) {
            return true;
        }
        if (falseStates.indexOf(text) >= 0) {
            return false;
        }
        isSwitch = isSwitch || svalue.startsWith("/");
        svalue = this.getString(name, null, 77);
        if (svalue == null || svalue.equals("NULL")) {
            return defvalue;
        }
        if (svalue.length() == 0 && isSwitch) {
            return true;
        }
        text = "|" + svalue + "|";
        if (trueStates.indexOf(text) >= 0) {
            return true;
        }
        if (falseStates.indexOf(text) >= 0) {
            return false;
        }
        Data value = this.getData(name, '_');
        if (value == null) {
            return defvalue;
        }
        if (!value.isString()) {
            return value.toD() > 0.0;
        }
        if (value.size == 0) {
            return false;
        }
        if (svalue.startsWith("(") && svalue.endsWith(")")) {
            return Args.logicalTest(this, svalue);
        }
        throw new MidasException("Illegal state value: " + name + "=" + value.toString());
    }

    public boolean getNoState(int arg) {
        return this.getNoState(this.getKey(arg));
    }

    public boolean getNoState(String name) {
        return this.getNoState(name, false);
    }

    public boolean getNoState(String name, boolean defvalue) {
        return !this.getState(name, !defvalue);
    }

    public FileName getFileName(int arg) {
        return this.getFileName(this.getKey(arg));
    }

    public FileName getFileName(String name) {
        return this.getFileName(name, "", "");
    }

    public FileName getFileName(String name, String defvalue) {
        return this.getFileName(name, defvalue, "");
    }

    public FileName getFileName(String name, String defvalue, String sdefval) {
        String fname = this.getString(name, defvalue, sdefval, 2);
        return BaseFile.getFileNameFor(this.cmd, fname);
    }

    public FileName getFileName(String name, int flags) {
        String fname = this.getString(name, null, 2 | flags);
        return BaseFile.getFileNameFor(this.cmd, fname);
    }

    public BaseFile getFile(int arg) {
        return this.getFile(this.getKey(arg));
    }

    public BaseFile getFile(String name) {
        FileName fn = this.getFileName(name);
        BaseFile bf = BaseFile.getInstanceFor(this.cmd, (Object)fn);
        return bf;
    }

    public <T> T getFile(int arg, Class<T> type) {
        return this.getFile(this.getKey(arg), type);
    }

    public <T> T getFile(String name, Class<T> type) {
        if (type == null) {
            throw new NullPointerException("Input parameter type can not be null.");
        }
        FileName fn = this.getFileName(name);
        BaseFile bf = BaseFile.getInstanceFor(this.cmd, (Object)fn);
        try {
            return (T)bf;
        }
        catch (ClassCastException e) {
            throw new MidasException("Can not convert " + name + "=" + fn + " to an instance of " + type.getName() + ".");
        }
    }

    public BaseFile getBaseFile(int arg) {
        return this.getBaseFile(this.getKey(arg));
    }

    public BaseFile getBaseFile(String name) {
        FileName fn = this.getFileName(name);
        BaseFile bf = new BaseFile(this.cmd, (Object)fn);
        return bf;
    }

    public DataFile getDataFile(int arg) {
        return this.getDataFile(this.getKey(arg));
    }

    public DataFile getDataFile(String name) {
        return this.getDataFile(name, "", "", 0);
    }

    public DataFile getDataFile(String name, String types, String formats, int flags) {
        return this.getDataFile(name, types, formats, flags, 0.0, null);
    }

    public DataFile getDataFile(String name, DataFile hcbin, int flags) {
        return this.getDataFile(name, "", "", flags, 0.0, hcbin);
    }

    public DataFile getDataFile(String name, String types, String formats, int flags, double size, DataFile hcbin) {
        FileName fn = this.getFileName(name);
        BaseFile bf = BaseFile.getInstanceFor(this.cmd, (Object)fn);
        DataFile df = bf instanceof DataFile ? (DataFile)bf : new DataFile();
        df.init(this.cmd, fn, types, formats, flags, size, hcbin);
        if (this.cmd != null) {
            this.cmd.addProgressFeed(df);
        }
        return df;
    }

    public TextFile getTextFile(int arg) {
        return this.getTextFile(this.getKey(arg));
    }

    public TextFile getTextFile(String name) {
        return this.getTextFile(name, null);
    }

    public TextFile getTextFile(String name, int flags) {
        FileName fn = this.getFileName(name, flags);
        TextFile tf = new TextFile(this.cmd, (Object)fn);
        return tf;
    }

    public TextFile getTextFile(String name, TextFile defTF) {
        FileName fn = this.getFileName(name);
        TextFile tf = new TextFile(this.cmd, (Object)fn);
        if (tf == null) {
            return defTF;
        }
        return tf;
    }

    public Data getData(int arg) {
        return this.getData(this.getKey(arg));
    }

    public Data getData(String name) {
        return this.getData(name, null);
    }

    public Data getData(String name, Data defvalue) {
        Data value = this.getData(name, '_');
        if (value != null) {
            return value;
        }
        return defvalue;
    }

    private Data getData(String name, char type) {
        String value = this.getRaw(name);
        if (value == null) {
            return null;
        }
        value = Parser.toUpperCaseWithQuotes(value);
        return Data.fromString(value, type, this);
    }

    @InternalUseOnly(value="Since NeXtMidas 3.3.2, this has always been meant for internal use only, but may become provisional in the future")
    private Data getNumericData(String name) {
        String value = this.getRaw(name);
        if (value == null) {
            return null;
        }
        Data data = Data.fromString(value = Parser.toUpperCaseWithQuotes(value), '_', this);
        if (Convert.isNumericConversion(data.getFormatTypeChar())) {
            return data;
        }
        return Data.fromString(value, 'D', this);
    }

    public Message getMessage(int arg) {
        return this.getMessage(this.getKey(arg));
    }

    public Message getMessage(String name) {
        return this.getMessage(name, null);
    }

    public Message getMessage(String name, Message defMsg) {
        String value = this.getU(name, "");
        Object obj = this.M.results.get(value);
        if (obj instanceof Message) {
            return (Message)obj;
        }
        return defMsg;
    }

    public List<?> getList(int index) {
        return Convert.o2List(this.getO(index));
    }

    public List<?> getList(String key) {
        return this.getList(key, null);
    }

    public List<?> getList(String key, List<?> list3) {
        Object obj = this.getO(key);
        if (obj != null) {
            return Convert.o2List(obj);
        }
        return list3;
    }

    public Object getO(int arg) {
        return this.getO(this.getKey(arg));
    }

    public Object getO(String name) {
        return this.getO(name, null);
    }

    public Object getO(String name, Object defvalue, boolean uc) {
        String value = this.getRaw(name);
        if (value == null) {
            return defvalue;
        }
        if (value.isEmpty()) {
            return value;
        }
        int ls = value.length();
        if (ls > 0 && value.charAt(0) == '\"') {
            value = value.charAt(ls - 1) == '\"' ? value.substring(1, ls - 1) : value.substring(1, ls);
            return value;
        }
        String ucvalue = Parser.toUpperCaseWithQuotes(value);
        Object obj = this.M.results.get(ucvalue);
        if (obj != null) {
            return obj;
        }
        if (uc) {
            return Convert.s2o(ucvalue, '_', (Object)this);
        }
        return Convert.s2o(value, '_', (Object)this);
    }

    public Object getO(String name, Object defvalue) {
        return this.getO(name, defvalue, true);
    }

    public Table getTable(int arg) {
        return this.getTable(this.getKey(arg));
    }

    public Table getTable(String name) {
        return this.getTable(name, null, 0);
    }

    public Table getTable(String name, Table defTab) {
        return this.getTable(name, defTab, 0);
    }

    public Table getTable(String name, Table defTab, int flags) {
        String value = this.getU(name, "");
        if (value.length() <= 0) {
            if ((flags & 0x10) != 0) {
                throw new MidasException("Argument '" + name + "=' is required.");
            }
            return defTab;
        }
        Table table = Convert.o2t(value, this);
        if (table == null && (flags & 0x20) == 0) {
            throw new MidasException("Invalid Table for parameter: " + name + "=" + value);
        }
        return table;
    }

    public Time getTime(int arg) {
        return this.getTime(this.getKey(arg));
    }

    public Time getTime(String name) {
        return this.getTime(name, null);
    }

    public Time getTime(String name, Time defvalue) {
        String value = this.getRaw(name);
        if (value == null) {
            return defvalue;
        }
        int i = (value = value.toUpperCase()).indexOf(124);
        if (i > 0) {
            double wsec = Convert.o2d(value.substring(0, i), this.M);
            double fsec = Convert.o2d(value.substring(i + 1), this.M);
            wsec -= wsec % 1.0;
            this.M.deprecate("Use of X-Midas WSEC|FSEC time syntax is deprecated, use (<wsec>,<fsec>).");
            return new Time(wsec, fsec %= 1.0);
        }
        Object obj = this.M.results.get(value);
        return obj != null ? Time.toTime(obj) : Time.toTime(value);
    }

    public void put(String key, String value) {
        key = this.evaluateCarets(key);
        this.kv.put(key, value);
    }

    public String get(String key) {
        return (String)this.kv.get(key);
    }

    public void remove(String key) {
        this.kv.remove(key);
    }

    public int numberOf() {
        return this.nargs;
    }

    public int size() {
        return this.nargs;
    }

    public String getRaw() {
        String value = this.cmdline;
        return this.evaluateCarets(value);
    }

    public String getRawArgs() {
        StringBuilder rawArgs = new StringBuilder();
        Parser line = new Parser(this.getRaw());
        boolean first = true;
        line.setTreatBSlashAsEscape(!this.M.io.isOptionSet(CoreIO.IOOptions.DisableEscapeSequences));
        if (line.get(1).startsWith("$")) {
            rawArgs.append(line.get(1).substring(1));
            first = false;
        }
        for (int i = 2; i <= line.elements(); ++i) {
            String value = line.get(i, !first);
            String val = line.get(i, false);
            if (val.startsWith("/")) {
                String switchName;
                int equals = val.indexOf(61);
                String string = switchName = equals < 0 ? val : val.substring(0, equals);
                if (this.find(switchName)) break;
            }
            rawArgs.append(value);
            first = false;
        }
        return rawArgs.toString();
    }

    public String getRaw(String name) {
        boolean isSwitch;
        String value = null;
        boolean bl = isSwitch = name.charAt(0) == '/';
        if (isSwitch && this.M.macro != null) {
            boolean inheritFromParent;
            boolean inherit = !name.equals("/BG") && !name.equals("/ID");
            boolean bl2 = inheritFromParent = inherit && !name.equals("/MSGID");
            if (value == null && this.M.macro.lines[0] != null && inheritFromParent) {
                value = this.M.macro.lines[0].get(name);
            }
            if (value == null) {
                value = this.get(name);
            }
            if (value == null && this.M.macro.lines[1] != null && inherit) {
                value = this.M.macro.lines[1].get(name);
            }
        } else {
            value = this.get(name);
        }
        if (value == null || value.length() == 0 && !isSwitch || value.equalsIgnoreCase("NOTPRESENT")) {
            return null;
        }
        value = this.evaluateCarets(value);
        return value;
    }

    public String evaluateCarets(String value) {
        int i;
        int kk;
        if (value == null) {
            return value;
        }
        int j = kk = value.length();
        while ((i = value.lastIndexOf(94, j)) >= 0) {
            block14: {
                Object obj;
                String tmp;
                int k;
                block12: {
                    block13: {
                        block11: {
                            if (value.charAt(i + 1) != '{') break block11;
                            k = value.indexOf(125, i);
                            if (k < i + 1) {
                                throw new MidasException(this.getName() + ": Syntax Error: Can not evaluate carets: Missing '}' character in ( " + value + " ).");
                            }
                            tmp = value.substring(i + 2, k).toUpperCase();
                            obj = this.M.results.get(tmp);
                            ++k;
                            break block12;
                        }
                        if (value.charAt(i + 1) != '/') break block13;
                        j = Results.validNameLength(value, i + 2);
                        if (j < 1) break block14;
                        k = i + j + 2;
                        tmp = value.substring(i + 1, k).toUpperCase();
                        obj = this.getRaw(tmp);
                        if (obj == null) {
                            obj = "NULL";
                        }
                        break block12;
                    }
                    j = Results.validNameLength(value, i + 1);
                    if (j < 1) break block14;
                    k = i + j + 1;
                    tmp = value.substring(i + 1, k).toUpperCase();
                    obj = this.M.results.get(tmp);
                }
                if (obj != null) {
                    tmp = obj.toString();
                    if (k < kk) {
                        tmp = tmp + value.substring(k);
                    }
                    if (i == 0) {
                        return tmp;
                    }
                    value = value.substring(0, i) + tmp;
                    kk = value.length();
                }
            }
            j = i - 1;
        }
        return value;
    }

    public String getKey(int arg) {
        String value = this.kv.getKey(arg);
        if (value == null || arg > this.nargs) {
            value = "BogusIndex";
        }
        return value;
    }

    public String getValue(int arg) {
        String value = (String)this.kv.get(arg);
        if (value == null) {
            value = "BogusIndex";
        }
        return value;
    }

    public Object getID(String name, Object defvalue) {
        String value = this.getRaw(name);
        if (value == null) {
            return defvalue;
        }
        Object obj = this.M.registry.get(value.toUpperCase());
        if (obj == null) {
            return defvalue;
        }
        return obj;
    }

    public int getLength(String name) {
        String value = this.getRaw(name);
        if (value == null) {
            return -1;
        }
        return value.length();
    }

    public boolean isPresent(String name) {
        return this.getRaw(name) != null;
    }

    public boolean find(String name) {
        return this.isPresent(name);
    }

    public String getFormat(String name, String allowable) {
        return this.getFormat(name, allowable, "");
    }

    public String getFormat(String name, String defvalue, String allowable) {
        String format = this.getS(name, defvalue);
        return this.testFormat(format, allowable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String testFormat(String format, String allowable) {
        int formatLen = format == null ? 0 : format.length();
        String fc = format;
        if (formatLen != 2) {
            if (formatLen == 1) {
                fc = "S" + format;
            } else {
                if (formatLen < 3) throw new MidasException("No format specified! " + format);
                if (format.equals("REAL") || format.equals("R*04") || format.startsWith("FLO")) {
                    fc = "SF";
                } else if (format.startsWith("DOU") || format.equals("R*08")) {
                    fc = "SD";
                } else if (format.startsWith("XLO") || format.equals("I*08")) {
                    fc = "SX";
                } else if (format.startsWith("LON") || format.equals("I*04")) {
                    fc = "SL";
                } else if (format.startsWith("INT") || format.equals("I*02")) {
                    fc = "SI";
                } else if (format.startsWith("BYT") || format.equals("I*01") || format.equals("B*01")) {
                    fc = "SB";
                } else if (format.startsWith("BIT") || format.startsWith("PAC")) {
                    fc = "SP";
                } else if (format.startsWith("OFF") || format.equals("OB01")) {
                    fc = "SO";
                } else if (format.startsWith("COM") || format.equals("C*08")) {
                    fc = "CF";
                } else if (format.equals("C*16")) {
                    fc = "CD";
                } else {
                    if (!format.equals("C*04")) throw new MidasException("Unrecognized format: " + format);
                    fc = "CI";
                }
            }
        }
        if (DataFile.checkFormat(fc, allowable)) return fc;
        throw new MidasException("Format '" + format + "' not allowed in " + allowable);
    }

    public int getChoice(String name, String selections, int defsel) {
        return this.getSelectionIndex(name, selections, defsel);
    }

    public int getSelectionIndex(String name, String selections, int defsel) {
        return this.getSelectionIndex(name, selections, defsel, 0);
    }

    public int getSelectionIndex(String name, String selections, int defsel, int offset) {
        String select = this.getS(name);
        int item = Parser.find(selections, select, defsel, offset);
        if (item < offset && item != defsel && !selections.startsWith("-")) {
            throw new MidasException("Selection " + select + " not in list " + selections);
        }
        return item;
    }

    public String getSelection(String name, String selections, String defsel) {
        String select = this.getS(name);
        String item = Parser.find(selections, select, defsel);
        if (item == null) {
            throw new MidasException("Selection " + select + " not in list " + selections);
        }
        return item;
    }

    public <E extends Enum<E>> E getSelection(String name, E def) {
        Object[] enums = (Enum[])def.getClass().getEnumConstants();
        String selection = this.getS(name);
        if (selection == null || selection.length() == 0) {
            return def;
        }
        for (Enum enum_ : enums) {
            if (!enum_.toString().equals(selection)) continue;
            return (E)enum_;
        }
        for (Enum enum_ : enums) {
            if (!enum_.toString().equalsIgnoreCase(selection)) continue;
            return (E)enum_;
        }
        throw new IllegalArgumentException("Selection '" + selection + "' not found in " + StringUtil.join(enums));
    }

    public <E extends Enum<E>> MaskValue<E> getMaskValue(String name, Class<E> type) {
        String maskStr = this.getS(name);
        if (maskStr == null || maskStr.length() == 0) {
            return MaskValue.forType(type, (Enum[])new Enum[0]);
        }
        return MaskValue.fromString(maskStr, type);
    }

    public <E extends Enum<E>> MaskValue<E> getMaskValue(String name, MaskValue<E> current, MaskValue<E> def) {
        String maskStr = this.getS(name);
        if (maskStr == null || maskStr.length() == 0) {
            return def.copy();
        }
        return MaskValue.fromString(maskStr, current, def);
    }

    public int getOptionMask(String name, String options, int defmask) {
        String list3 = this.getS(name);
        int item = Parser.mask(options, list3, defmask);
        return item;
    }

    private String getSN(int arg) {
        return this.getString(this.getKey(arg), "NULL", 13);
    }

    private String getCSN(int arg, boolean caseSen) {
        return this.getString(this.getKey(arg), "NULL", caseSen ? 1 : 13);
    }

    private boolean equals(int i, String test, int j, double relTol, double absTol) {
        Data data1 = this.getNumericData(this.getKey(i));
        Data data2 = this.getNumericData(this.getKey(j));
        return absTol < 0.0 ? data1.equals(data2, Data.parseTestFlag(test, false), relTol) : data1.equals(data2, Data.parseTestFlag(test, true), absTol);
    }

    private int compare(int i, String test, int j) {
        Data data1 = this.getNumericData(this.getKey(i));
        Data data2 = this.getNumericData(this.getKey(j));
        return data1.compareTo(data2, Data.parseTestFlag(test, false));
    }

    @Deprecated
    static boolean logicalTest(Object ref, String test) {
        if (ref instanceof MidasReference) {
            return Args.logicalTest((MidasReference)ref, test);
        }
        return Args.logicalTest(Convert.ref2Midas(ref), test);
    }

    static boolean logicalTest(MidasReference ref, String test) {
        Midas midas = Convert.ref2Midas(ref);
        int off = test.startsWith("TEST(") ? 5 : 1;
        int end = test.length() - 1;
        Args args = new Args(midas, new Parser(test.substring(off, end), true));
        if (ref instanceof Args) {
            ((Args)ref).copySwitchesTo(args);
            args.cmd = ((Args)ref).cmd;
        }
        return args.logicalTest();
    }

    @InternalUseOnly(value="Since NeXtMidas 3.3.1, this has always been meant for internal use only")
    public boolean logicalTest() {
        if (this.nargs == 0) {
            return true;
        }
        if (this.nargs == 1) {
            return this.getState(1);
        }
        boolean result = false;
        boolean cs = this.getState("/CS", false);
        double relTol = this.getD("/TOL", -1.0);
        double absTol = this.getD("/DELTA", -1.0);
        try {
            int i = 2;
            while (true) {
                Object obj;
                String baseTest;
                String test;
                boolean negate = false;
                String string = test = i > this.nargs ? "" : this.getU(i);
                if (test.equals("NE") || test.equals("!=")) {
                    test = "EQ";
                    negate = true;
                } else if (test.startsWith("NE/")) {
                    test = "EQ/" + test.substring(3);
                    negate = true;
                } else if (test.length() > 1 && test.charAt(0) == 'N' && Character.isLetter(test.charAt(1))) {
                    test = test.substring(1);
                    negate = true;
                }
                int iSlash = test.indexOf(47);
                String string2 = baseTest = iSlash < 0 ? test : test.substring(0, iSlash);
                if (test.startsWith("EQT") && !test.equals("EQT") && !test.equals("EQTOL")) {
                    this.M.deprecate("Since NeXtMidas 2.7.0: Please use EQT or ~= in place of " + test + " in " + this.getRaw());
                    test = "EQT";
                }
                if (test.equals("EQS")) {
                    result = this.getCSN(i + 1, cs).equals(this.getCSN(i - 1, cs));
                } else if (test.equals("SUBS")) {
                    result = this.getCSN(i + 1, cs).indexOf(this.getCSN(i - 1, cs)) >= 0;
                } else if (test.equals("STARTS")) {
                    result = this.getCSN(i - 1, cs).startsWith(this.getCSN(i + 1, cs));
                } else if (test.equals("ENDS")) {
                    result = this.getCSN(i - 1, cs).endsWith(this.getCSN(i + 1, cs));
                } else if (test.equals("SEQS") || test.equals("EQSS")) {
                    String s2;
                    String s1 = this.getCSN(i - 1, cs);
                    result = s1.startsWith(s2 = this.getCSN(i + 1, cs)) || s2.startsWith(s1);
                } else if (test.equals("EQT") || test.equals("~=")) {
                    result = this.equals(i - 1, "EQ/T", i + 1, relTol, absTol);
                } else if (test.equals("EQTOL")) {
                    result = this.equals(i - 1, "EQ/T", i + 1, relTol, absTol);
                } else if (baseTest.equals("EQ") || test.equals("==")) {
                    result = this.equals(i - 1, test, i + 1, relTol, absTol);
                } else if (baseTest.equals("LE") || test.equals("<=")) {
                    result = this.compare(i - 1, test, i + 1) <= 0;
                } else if (baseTest.equals("GE") || test.equals(">=")) {
                    result = this.compare(i - 1, test, i + 1) >= 0;
                } else if (baseTest.equals("LT") || test.equals("<")) {
                    result = this.compare(i - 1, test, i + 1) < 0;
                } else if (baseTest.equals("GT") || test.equals(">")) {
                    result = this.compare(i - 1, test, i + 1) > 0;
                } else if (test.equals("ANYBITS")) {
                    result = (this.getL(i - 1) & this.getL(i + 1)) != 0;
                } else if (test.equals("ALLBITS")) {
                    result = (this.getL(i - 1) | this.getL(i + 1)) == this.getL(i - 1);
                } else if (test.equals("CONTAINS") || test.equals("CONTAINS/K")) {
                    obj = this.getO(i - 1);
                    if (obj instanceof Map) {
                        Object key = obj instanceof Table ? this.getCSN(i + 1, cs) : this.getO(i + 1);
                        result = ((Map)obj).containsKey(key);
                    }
                } else if (test.equals("CONTAINS/V")) {
                    obj = this.getO(i - 1);
                    if (obj instanceof Map) {
                        Object value = this.getO(i + 1);
                        result = ((Map)obj).containsValue(value);
                    }
                } else if (test.equals("TYPEOF")) {
                    result = this.testTypeOf(this.getO(i - 1), this.getS(i + 1));
                } else if (test.equals("INSTANCEOF")) {
                    result = this.testInstanceOf(this.getO(i - 1), this.getCS(i + 1));
                } else if (test.equals("OEQ") || test.equals("EQO")) {
                    result = this.getO(i - 1).equals(this.getO(i + 1));
                } else if (test.startsWith("FEQ") || test.startsWith("EQF")) {
                    BaseFile bf1 = this.getFile(i - 1);
                    BaseFile bf2 = this.getFile(i + 1);
                    int testFlags = BaseFile.parseFileTestFlag(test);
                    if (absTol > -1.0 && (testFlags & 0x20) != 0) {
                        testFlags = testFlags - 32 + 512;
                    }
                    result = bf1.equals(bf2, testFlags);
                } else if (test.startsWith("AEX")) {
                    result = new File(this.getCS(--i)).exists();
                } else if (test.startsWith("REX")) {
                    result = this.M.results.get(this.getU(--i)) != null;
                } else if (test.startsWith("FEX")) {
                    result = this.getFile(--i).find(-1);
                } else if (test.startsWith("DEX")) {
                    result = this.getFile(--i).isDir();
                } else if (test.startsWith("PEX")) {
                    result = this.M.macro.args.isPresent(this.getU(--i));
                } else if (test.equals("ISTRUE")) {
                    result = this.getState(--i);
                } else if (test.equals("ISFALSE")) {
                    result = !this.getState(--i);
                } else if (test.equals("ISNULL")) {
                    result = StringUtil.isNull(this.getSN(--i));
                } else if (test.length() == 0 && this.getU(i - 1).length() != 0 || test.equals("THEN") || Args.isCompoundTest(test)) {
                    result = this.getState(i - 1);
                    i -= 2;
                } else {
                    throw new MidasException("Illegal logical test: " + test);
                }
                if (negate) {
                    boolean bl = result = !result;
                }
                if (++i < this.nargs && !(test = this.getU(i + 1)).equals("THEN")) {
                    if (test.equals("OR")) {
                        if (result) {
                            return result;
                        }
                    } else if (test.equals("AND")) {
                        if (!result) {
                            return result;
                        }
                    } else {
                        throw new MidasException("Illegal logical expression");
                    }
                    i += 3;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            String text;
            if (this.M.macro != null) {
                int line = this.M.macro.nextIndex - 1;
                text = this.M.macro.lines[line].cmdline;
            } else {
                text = this.getRaw();
            }
            throw new MidasException("Args: logical test had an exception at command: '" + text + "'. " + e.getMessage(), e);
        }
        return result;
    }

    static boolean isUnaryTest(String op) {
        if (op.startsWith("N")) {
            op = op.substring(1);
        }
        boolean unary = op.startsWith("FEX") || op.startsWith("DEXIST") || op.startsWith("AEX") || op.startsWith("REX") || op.startsWith("PEX") || op.equals("IS") || op.equals("ISNULL") || op.equals("ISTRUE") || op.equals("ISFALSE");
        return unary;
    }

    static boolean isCompoundTest(String op) {
        return op.equals("AND") || op.equals("OR");
    }

    @Deprecated
    public boolean testTypeOf(Object obj, String type) {
        if (type.equals("S")) {
            return obj instanceof String;
        }
        if (type.length() == 1 && obj instanceof Data) {
            return ((Data)obj).type == (byte)type.charAt(0);
        }
        if (type.length() == 2 && obj instanceof Data) {
            return ((Data)obj).getFormat().equals(type);
        }
        return obj.getClass().getName().equalsIgnoreCase(type);
    }

    private boolean testInstanceOf(Object obj, String type) {
        try {
            Class<?> clazz = Class.forName(type, false, Shell.class.getClassLoader());
            return clazz.isInstance(obj);
        }
        catch (ClassNotFoundException e) {
            throw new MidasException("Could not find class '" + type + "', note that class names are case sensitive.", e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.support).append(':').append(this.name);
        for (int i = 1; i < this.kv.size(); ++i) {
            String key = this.kv.getKey(i);
            String value = this.getValue(i);
            sb.append(',').append(key).append('=').append(value);
        }
        if (this.support == 'U' || this.support == 'O') {
            sb.append(this.cmdline);
        }
        return sb.toString();
    }

    private String keyMatch(String abbr, int limit) {
        int ii;
        String match = null;
        for (ii = 0; ii <= limit; ++ii) {
            if (!abbr.equals(this.kv.getKey(ii))) continue;
            return abbr;
        }
        for (ii = 0; ii <= limit; ++ii) {
            String key = this.kv.getKey(ii);
            if (!key.startsWith(abbr)) continue;
            if (match == null) {
                match = key;
                continue;
            }
            this.M.warning("Ambiguous tag abbreviation \"" + abbr + "\": \"" + match + "\" selected, \"" + key + "\" ignored");
        }
        return match;
    }

    public String getName() {
        return this.name;
    }

    public String getOption() {
        return this.option;
    }

    public char getSupport() {
        return this.support;
    }

    public int getNArgs() {
        return this.nargs;
    }

    public KeyVector getKV() {
        return this.kv;
    }

    @InternalUseOnly(value="Since NeXtMidas 3.5.4, this has always been meant for internal use only")
    public void dump() {
        System.out.println("CmdLine = " + this.getValue(0));
        System.out.println("CmdName = " + this.getName());
        System.out.println("Support = " + this.getSupport());
        System.out.println("CmdClass= " + this.getCmdClassName());
        System.out.println("Positional Args = " + this.nargs);
        for (int i = 1; i <= this.nargs; ++i) {
            System.out.println(" PI=" + i + " Key=" + this.kv.getKey(i) + " Value=" + this.kv.get(i));
        }
        int xargs = this.kv.size() - this.nargs - 1;
        System.out.println("Extra Args = " + xargs);
        for (int i = this.nargs + 1; i < this.kv.size(); ++i) {
            System.out.println(" Key=" + this.kv.getKey(i) + " Value=" + this.kv.get(i));
        }
    }

    public SplitArg getSplitArg(String string, char delimiter) {
        SplitArg sa = new SplitArg();
        sa.setString(string, delimiter);
        return sa;
    }

    private static boolean noMoreParameters(Parser line, int icur) {
        boolean more = true;
        int i = icur + 1;
        while (more && line.more()) {
            String arg = line.get(i);
            if (arg.indexOf(47) != 0 || arg.length() == 1 || arg.indexOf(47, 1) >= 0 && arg.indexOf(61) < 0) {
                more = false;
            }
            ++i;
        }
        line.get(icur);
        return more;
    }

    private static Parser getUserMacroConfig(Midas M, String name, boolean isOutsideOptionTree) {
        String confstr = "USERMACRO,M,0+,";
        String mfn = name;
        mfn = !isOutsideOptionTree ? Macro.getFileName(M, name, "SYS") : mfn.substring(1) + ".mm";
        TextFile file = new TextFile(M, (Object)mfn);
        if (file.open(33)) {
            String text = file.readProper();
            Parser smp = new Parser(text);
            smp.clean();
            int nargs = smp.elements() - 1;
            confstr = "USERMACRO,M," + nargs + ",";
            for (int i = 1; i <= nargs; ++i) {
                String arg = smp.get(i + 1);
                String def = "";
                int ic = arg.indexOf(58);
                int ib = arg.indexOf(91);
                if (ic >= 0 && (ib < 0 || ib > 0 && ic < ib)) {
                    arg = arg.substring(ic + 1);
                    ib = arg.indexOf(91);
                }
                if (ib >= 0) {
                    def = arg.substring(ib + 1, arg.length() - 1);
                    arg = arg.substring(0, ib);
                } else if (arg.indexOf(61) >= 0) {
                    int ie = arg.indexOf(61);
                    def = arg.substring(ie + 1, arg.length());
                    arg = arg.substring(0, ie);
                }
                confstr = confstr + arg + "=" + def + ",";
            }
            file.close();
        }
        return new Parser(confstr);
    }

    public void copySwitchesTo(Args args) {
        for (int i = this.nargs + 1; i < this.kv.size(); ++i) {
            String key = this.kv.getKey(i);
            if (key == null || !key.startsWith("/")) continue;
            args.put(key, (String)this.kv.get(i));
        }
    }

    public void propagateSwitchesTo(Args args) {
        for (int i = this.nargs + 1; i < this.nargsx; ++i) {
            String key = this.kv.getKey(i);
            if (key == null || !key.startsWith("/")) continue;
            args.put(key, (String)this.kv.get(i));
        }
    }

    private static String findDefaultSupport(Midas M, String fname, String name, String area, String option) {
        String support = "U";
        if (option != null && area != null) {
            if (area.equals("HOST")) {
                support = "H";
            }
            if (area.equals("INTR")) {
                support = "I";
            }
            if (area.equals("PRIM")) {
                support = "P";
            }
            if (area.equals("MCR")) {
                support = "M";
            }
        }
        if (support.equals("U")) {
            try {
                Class<?> clazz = Class.forName(fname);
                if (Primitive.class.isAssignableFrom(clazz)) {
                    support = "P";
                } else if (Intrinsic.class.isAssignableFrom(clazz)) {
                    support = "I";
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return support;
    }

    private static Parser findConfiguration(Midas M, String fname, String name, String area, String option, String support) {
        Parser conf = null;
        if (!support.equals("U") && (conf = M.dictionary.findParser(name + ";" + option)) != null && !conf.get(2).equals(support)) {
            conf = conf.get(2).indexOf(support) > 0 ? null : null;
        }
        if (conf == null) {
            // empty if block
        }
        if (conf == null) {
            conf = new Parser(name + ";" + option + ":" + name.length() + "," + support + ",0+,");
        }
        return conf;
    }

    public static Args parseCommand(Midas M, String cmdline) {
        int i;
        Pattern macro_name_pattern = Pattern.compile("^[^ .]+");
        Parser line = new Parser(cmdline);
        Parser conf = null;
        String name = null;
        String csName = null;
        String support = "U";
        String option = "";
        Args args = new Args(M);
        args.put("all", cmdline);
        line.setTreatBSlashAsEscape(!M.io.isOptionSet(CoreIO.IOOptions.DisableEscapeSequences));
        line.clean(false);
        csName = line.get(1);
        boolean isOutsideNxmOptionTree = false;
        String macroExt = ".mm";
        int extLength = macroExt.length();
        String filePath = "";
        boolean isFilePath = false;
        String macroFileName = csName.split(" ")[0];
        if ((macroFileName.endsWith(macroExt) || macroFileName.contains(macroExt + "/")) && !M.io.isOptionSet(CoreIO.IOOptions.DoNotAllowExecutionOfMacroOutsideOfHomepath)) {
            filePath = macroFileName.substring(1, macroFileName.indexOf(macroExt) + extLength);
            if (Shell.isWindows()) {
                filePath = filePath.replaceAll("\\\\", "/");
                String windowsRegex = "^[a-zA-Z]:/[/S|*/S]?.*$";
                isFilePath = filePath.matches(windowsRegex);
            } else {
                isFilePath = filePath.startsWith("/");
            }
            if (isFilePath) {
                isOutsideNxmOptionTree = true;
                args.put("/MFN", filePath);
                name = csName.substring(0, csName.indexOf(macroExt));
            }
        }
        if ((i = !isOutsideNxmOptionTree ? csName.indexOf(47) : csName.indexOf(47, csName.indexOf(macroExt) + extLength)) > 0) {
            line.switchlen = csName.length();
            csName = csName.substring(0, i);
        }
        if (!isOutsideNxmOptionTree) {
            name = csName.toUpperCase();
        }
        if (csName.startsWith("nxm.")) {
            String area = null;
            i = 4;
            int j = csName.indexOf(46, i);
            if (j > 0) {
                option = csName.substring(i, j).toUpperCase();
                i = j + 1;
            }
            if ((j = csName.indexOf(46, i)) > 0) {
                area = csName.substring(i, j).toUpperCase();
                i = j + 1;
            }
            if ((j = csName.indexOf(46, i)) > 0) {
                area = null;
            }
            String cmd = csName.substring(csName.lastIndexOf(46) + 1).toUpperCase();
            name = cmd + ";" + option;
            support = Args.findDefaultSupport(M, csName, cmd, area, option);
            conf = Args.findConfiguration(M, csName, cmd, area, option, support);
        } else {
            conf = M.dictionary.findParser(name);
            csName = null;
        }
        if (conf != null) {
            name = conf.get(1);
            i = name.indexOf(59);
            option = name.substring(i + 1);
            name = name.substring(0, i);
            i = option.indexOf(58);
            option = option.substring(0, i);
            if (support.equals("U")) {
                support = conf.get(2);
            }
            if (support.equals("O")) {
                cmdline = "$" + cmdline;
            } else {
                Args.parseArgs(M, args, line, conf);
            }
            args.setCmdClassName(csName);
        } else if (name.length() != 0) {
            if (name.charAt(0) == '%') {
                if (name.endsWith(".MM") || name.endsWith(".MMP")) {
                    throw new MidasException("Illegal macro name '" + name + "'. Do not include file extension when running a macro");
                }
                if (!macro_name_pattern.matcher(name).matches()) {
                    throw new MidasException("Illegal macro name '" + name + "'. Command names may contain letters and symbols excluding spaces and dots");
                }
                support = "M";
                conf = Args.getUserMacroConfig(M, name, isOutsideNxmOptionTree);
                Args.parseArgs(M, args, line, conf);
            } else if (name.charAt(0) == '$') {
                support = "O";
            } else {
                name = "";
            }
        }
        int sIndex = 0;
        String ss = args.getS("/S", null);
        if (support.length() > 1 || ss != null && ss.length() > 0) {
            if (ss != null && ss.length() > 0) {
                sIndex = support.indexOf(ss.charAt(0));
            }
            if (sIndex < 0) {
                sIndex = 0;
            }
        }
        args.support = support.charAt(sIndex);
        args.name = name;
        args.option = option;
        args.cmdline = cmdline;
        if ((M.debug & 0x80) != 0) {
            args.dump();
        }
        return args;
    }

    private static String handleEscapesInArgString(Midas midas, String argstr) {
        if (argstr == null || argstr.length() < 3 || argstr.charAt(0) != '\"' || argstr.charAt(argstr.length() - 1) != '\"') {
            return argstr;
        }
        boolean disableEscapeSeq = midas.io.isOptionSet(CoreIO.IOOptions.DisableEscapeSequences);
        if (disableEscapeSeq) {
            if (argstr.indexOf(92) != -1) {
                String msg = "Use of backslash in quoted strings are deprecated since 2.9.0.\n  In a future release, the default behavior will treat the backslash as the\n  escape character like in Java/C string escape sequences.\n  Run \"ENV set iooptions -DisableEscapeSequences\" to enable escape sequences.\n  argstr = [" + argstr + "]";
                midas.deprecate(msg);
            }
            return argstr;
        }
        argstr = StringUtil.unescapeString(argstr);
        return argstr;
    }

    public static void parseArgs(Midas M, Args args, Parser line, Parser conf) {
        String value;
        String key;
        int j;
        int i;
        int kvSize = 0;
        String arg = conf.get(3);
        boolean xargs = arg.endsWith("+");
        if (xargs) {
            arg = arg.substring(0, arg.length() - 1);
        }
        int nargs = Integer.parseInt(arg);
        int anargs = conf.elements() - 3;
        for (i = 1; i <= nargs; ++i) {
            arg = conf.get(3 + i);
            j = arg.indexOf(61);
            if (j < 0) {
                key = "P" + i;
                value = arg;
            } else {
                key = arg.substring(0, j);
                value = arg.substring(j + 1);
            }
            value = Args.handleEscapesInArgString(M, value);
            args.put(key, value);
            ++kvSize;
        }
        i = 2;
        int k = 0;
        while (line.more()) {
            arg = line.get(i);
            arg = Args.handleEscapesInArgString(M, arg);
            j = arg.indexOf(61);
            int jj = arg.indexOf(123);
            if (j > 0 && jj >= 0 && jj < j) {
                j = -1;
            }
            if (j > 0 && arg.charAt(0) == '\"') {
                j = -1;
            }
            if ((j <= 0 || arg.charAt(0) != '/') && j > 0 && Results.validNameLength(arg, 0) != j) {
                j = -1;
            }
            String tkey = j > 0 ? arg.substring(0, j).toUpperCase() : null;
            value = arg.substring(j + 1);
            if (j > 0) {
                value = Args.handleEscapesInArgString(M, value);
            }
            if (!(arg.indexOf(47) != 0 || arg.length() <= 1 || arg.indexOf(47, 1) >= 0 && j < 0 || j <= 0 && !Args.noMoreParameters(line, i))) {
                if (j < 0) {
                    args.put(arg.toUpperCase(), STATE_SWITCH_VAL);
                } else {
                    args.put(tkey, value);
                }
            } else if (j > 0) {
                ++k;
                key = args.keyMatch(tkey, kvSize);
                if (Args.isDuplicate(line, i)) {
                    M.warning("Duplicate keys entered: " + line.getAll());
                }
                if (key != null) {
                    args.put(key, value);
                } else if (xargs) {
                    k = Math.max(k, nargs + 1);
                    args.put(tkey, value);
                } else {
                    M.warning("Bad Argument: " + arg);
                }
            } else if (k < nargs) {
                key = args.getKV().getKey(++k);
                if (arg.startsWith("//")) {
                    args.put(key, arg.substring(1));
                } else if (arg.length() > 0) {
                    args.put(key, arg);
                }
            } else if (xargs) {
                key = "P" + ++k;
                if (arg.startsWith("//")) {
                    args.put(key, arg.substring(1));
                } else {
                    args.put(key, arg);
                }
            } else {
                String cmdLine = line.getAll().toUpperCase();
                if (cmdLine.startsWith("ELSE,IF") || cmdLine.startsWith("ELSE;SYS,IF")) {
                    throw new MidasException("Expected ELSEIF (no space): " + line.getAll());
                }
                M.warning("Too many arguments: " + line.getAll());
            }
            ++i;
        }
        kvSize = Args.parseConfiguredSwitches(M, args, conf, nargs, anargs, kvSize);
        if (k > nargs) {
            nargs = k;
        }
        args.nargs = nargs;
        args.nargsx = args.kv.size();
        if (line.switchlen > 0) {
            arg = line.get(0, line.switchlen);
            for (i = arg.indexOf(47); i < line.switchlen; i += k) {
                k = line.lengthd(i);
                arg = line.get(i, k);
                j = arg.indexOf(61);
                if (j < 0) {
                    args.put(arg.toUpperCase(), STATE_SWITCH_VAL);
                    continue;
                }
                key = arg.substring(0, j).toUpperCase();
                value = arg.substring(j + 1);
                value = Args.handleEscapesInArgString(M, value);
                args.put(key, value);
            }
        }
    }

    public static boolean isDuplicate(Parser line, int curIndex) {
        boolean more = true;
        int j = 0;
        String arg1 = line.get(curIndex);
        int k = arg1.indexOf(61);
        String key = arg1.substring(0, k);
        int i = curIndex + 1;
        while (more && line.more()) {
            String arg2 = line.get(i);
            if (!arg2.isEmpty()) {
                j = arg2.indexOf(61);
                if (k > 0 && j > 0 && key.equals(arg2.substring(0, j))) {
                    line.get(curIndex);
                    return true;
                }
            }
            ++i;
        }
        line.get(curIndex);
        return false;
    }

    private static int parseConfiguredSwitches(Midas M, Args args, Parser conf, int nargs, int anargs, int kvSize) {
        for (int i = nargs + 1; i <= anargs; ++i) {
            String arg = conf.get(3 + i);
            int iSwitch = arg.indexOf(47);
            if (iSwitch >= 0) {
                String value;
                String key;
                int j = arg.indexOf(61);
                if (j < 0) {
                    key = arg;
                    value = STATE_SWITCH_VAL;
                } else {
                    key = arg.substring(0, j);
                    value = arg.substring(j + 1);
                }
                args.put(key, value);
                ++kvSize;
                continue;
            }
            if ((M.debug & 0x80) == 0) continue;
            M.warning("'" + conf.getAll() + "' has extra arg = '" + arg + "' in config is not a switch");
        }
        return kvSize;
    }

    public Set<String> getAllSwitchNames() {
        HashSet<String> names = new HashSet<String>();
        Args.addAllSwitchNames(names, this);
        if (this.M.macro != null) {
            if (this.M.macro.lines[0] != null) {
                Args.addAllSwitchNames(names, this.M.macro.lines[0]);
            }
            if (this.M.macro.lines[1] != null) {
                Args.addAllSwitchNames(names, this.M.macro.lines[1]);
            }
        }
        return names;
    }

    private static void addAllSwitchNames(Set<String> names, Args MA) {
        for (int i = 1; i < MA.getKV().size(); ++i) {
            String key = MA.getKV().getKey(i);
            if (key.charAt(0) != '/') continue;
            names.add(key);
        }
    }

    void setCmdClassName(String str) {
        this.cmdClassName = str;
    }

    public String getCmdClassName() {
        String cname = null;
        if (this.support == 'I' || this.support == 'P') {
            cname = this.cmdClassName;
        }
        if (cname == null) {
            String opt = this.option.toLowerCase();
            String nameLC = this.name.toLowerCase();
            switch (this.support) {
                case 'I': {
                    cname = "nxm." + opt + ".intr." + this.name.substring(0, 1) + nameLC.substring(1);
                    break;
                }
                case 'P': {
                    cname = "nxm." + opt + ".prim." + nameLC;
                    break;
                }
                case 'M': {
                    cname = "nxm.sys.lib.Macro";
                    break;
                }
                case 'H': {
                    cname = "nxm.xbc.lib.HPrimitive";
                    break;
                }
                case 'D': {
                    cname = null;
                    break;
                }
                case 'O': {
                    cname = null;
                    break;
                }
                case 'U': {
                    cname = null;
                    break;
                }
                default: {
                    cname = null;
                }
            }
        }
        return cname;
    }

    public String getDefaultSourceName() {
        String fname;
        switch (this.support) {
            case 'I': {
                fname = this.getCmdClassName() + ".java";
                break;
            }
            case 'P': {
                fname = this.getCmdClassName() + ".java";
                break;
            }
            case 'M': {
                fname = Macro.getFileName(this.M, this.name, this.option);
                break;
            }
            case 'H': {
                fname = "nxm." + this.option.toLowerCase() + ".host." + this.name.toLowerCase() + ".for";
                break;
            }
            case 'D': {
                fname = null;
                break;
            }
            case 'O': {
                fname = null;
                break;
            }
            case 'U': {
                fname = null;
                break;
            }
            default: {
                fname = null;
            }
        }
        return fname == null ? null : new FileName(fname).toString();
    }

    void setLineNumber(int line) {
        this.lineNumber = line;
    }

    int getLineNumber() {
        return this.lineNumber;
    }

    public int getAddressing() {
        int mode = this.getState("/ABSC") ? 5 : 1;
        mode = this.getSelectionIndex("/ADDR", "INDEX,ABSCISSA,ABSCISSA_AUTO,TIMECODE,ABSCISSA_LEGACY", mode);
        mode = this.getSelectionIndex("/ADDRESSING", "INDEX,ABSCISSA,ABSCISSA_AUTO,TIMECODE,ABSCISSA_LEGACY", mode);
        return mode;
    }

    public boolean hasAddressing() {
        return this.isPresent("/ABSC") || this.isPresent("/ADDR") || this.isPresent("/ADDRESSING");
    }

    @Override
    public Midas getMidas() {
        return this.M;
    }

    public class SplitArg {
        Parser p;
        int fields;
        boolean addQuotes = false;

        public void setString(String string, char delimiter) {
            this.fields = 0;
            if (string == null || string.length() == 0) {
                return;
            }
            int ls = string.length();
            boolean bl = this.addQuotes = ls > 2 && string.charAt(0) == '\"' && string.indexOf(34, 1) == ls - 1;
            if (this.addQuotes) {
                string = string.substring(1, ls - 1);
            }
            this.p = new Parser(string, delimiter);
            this.fields = this.p.elements();
        }

        public String getField(int index) {
            if (index < 0 || index >= this.fields) {
                return null;
            }
            String field = this.p.get(index + 1);
            if (!this.addQuotes) {
                return field;
            }
            int lf = field.length();
            if (lf < 1 || field.charAt(lf - 1) != '\"') {
                field = field + '\"';
            }
            if (lf == 0 || field.charAt(0) != '\"') {
                field = '\"' + field;
            }
            return field;
        }

        public int getFields() {
            return this.fields;
        }
    }
}

