/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.text.ParseException;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.MFormat;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Time;

public class Timex
extends Intrinsic {
    public static final double SECS_IN_YEAR = 86400.0;
    private static final int ARG_INPUT_TIME = 1;

    @Override
    public int process() {
        MFormat outFormat;
        int dp = this.MA.getL("/PREC", -1);
        String inFmt = this.MA.getS("/INFMT", null);
        String outFmt = this.MA.getS("/FMT", null);
        Time time = Time.currentTime();
        boolean hasOutput = false;
        for (int n = 1; n <= this.MA.numberOf(); ++n) {
            DataFile hcb;
            String key = this.MA.getKey(n);
            String label = this.MA.getU(n);
            boolean handled = true;
            if (key.equals("TIME") || key.equals("P" + n)) {
                if (!label.equals("NOW")) {
                    if (label.equals("DAY")) {
                        time.floor(86400.0);
                    } else if (label.equals("SSM")) {
                        time.modulo(86400.0);
                    } else if (label.equals("TERM")) {
                        this.M.println("Time = " + time);
                        hasOutput = true;
                    } else if (label.equals("TERMINAL")) {
                        this.M.println("Time = " + time);
                        hasOutput = true;
                    } else if (n == 1) {
                        time = this.getInputTime(inFmt, time);
                    } else {
                        MFormat mFormat = outFormat = (outFmt = time.createHighPrecisionSimpleDateFormat(outFmt)) == null ? null : MFormat.getDateFormatFor(outFmt, dp);
                        if (outFormat == null) {
                            this.MR.put(label, (Object)time);
                            hasOutput = true;
                        } else {
                            this.MR.put(label, (Object)outFormat.format(time));
                            hasOutput = true;
                        }
                    }
                }
            } else if (key.equals("INFILE")) {
                hcb = this.MA.getDataFile("INFILE");
                hcb.open();
                time.fromTimeCode(hcb);
                hcb.close();
            } else if (key.equals("INACQ")) {
                hcb = this.MA.getDataFile("INACQ");
                hcb.open();
                time.fromAcqDate(hcb);
                hcb.close();
            } else if (key.equals("INQUAD")) {
                hcb = this.MA.getDataFile("INQUAD");
                hcb.open();
                time.fromQuadwords(hcb);
                hcb.close();
            } else if (key.equals("ROUND")) {
                double sec = this.MA.getD("ROUND");
                time.round(sec);
            } else {
                handled = false;
            }
            if (handled) continue;
            hasOutput = true;
            if (n == 1) {
                String extra = "FILE,ACQ,QUAD".indexOf(key) >= 0 ? "- Try IN" + key : "";
                this.M.error("Need an input parameter in 1st slot " + extra);
                continue;
            }
            if (key.equals("FILE")) {
                hcb = this.MA.getDataFile("FILE");
                hcb.open(3);
                time.toTimeCode(hcb);
                hcb.close();
                continue;
            }
            if (key.equals("ACQ")) {
                hcb = this.MA.getDataFile("ACQ");
                hcb.open(3);
                time.toAcqDate(hcb);
                hcb.close();
                continue;
            }
            if (key.equals("QUAD")) {
                hcb = this.MA.getDataFile("QUAD");
                hcb.open(3);
                time.toQuadwords(hcb);
                hcb.close();
                continue;
            }
            if (key.equals("SEC")) {
                key = "MJS";
            } else if (key.equals("JUL")) {
                key = "JD";
            } else if (key.equals("Y")) {
                key = "YEAR";
            } else if (key.equals("FN")) {
                key = "TOFILENAME";
            }
            Object obj = KeyObject.getKey(time, key);
            if (obj == null) {
                this.M.error("Illegal time key: " + key + "=" + label);
            }
            this.MR.put(label, obj);
        }
        if (!hasOutput) {
            MFormat mFormat = outFormat = (outFmt = time.createHighPrecisionSimpleDateFormat(outFmt)) == null ? null : MFormat.getDateFormatFor(outFmt, dp);
            if (outFormat == null) {
                this.M.println("Time = " + time.toString(dp));
            } else {
                this.M.println("Time = " + outFormat.format(time));
            }
        }
        return 9;
    }

    private Time parseTime(MFormat fmt, String str) {
        try {
            Time t = Time.toTime(fmt.parseObject(str));
            if (t == null) {
                throw new MidasException("Unable to parse '" + str + "' using " + fmt + ".");
            }
            return t;
        }
        catch (ParseException e) {
            throw new MidasException("Unable to parse '" + str + "': " + e.getMessage(), e);
        }
    }

    private Time getInputTime(String inFmt, Time time) {
        String inTimeArg = this.MA.getRaw(this.MA.getKey(1));
        time = inFmt != null ? new Time(inTimeArg, inFmt) : this.MA.getTime(1);
        return time;
    }
}

